/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);
    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager impmissing(&document1, QUrl("missingfile.ofx"));
            SKGTESTERROR("imp1.importFile", impmissing.importFile(), false);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/ofx_spec160_stmtrs_example.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        {
            // To check double import
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/ofx_spec160_stmtrs_example.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }
        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "999988", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "200.29");
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/ofx_spec201_stmtrs_example.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "999988", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "200.29");
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/t1.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Investment account 12345 at broker ameritrade.com", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1672.84");
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/385366.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Investment account 209830947 at broker fidelity.com", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-1.818989404e-12");
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/430130.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "1234567L123", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-8238.77");
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/ca_remi.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }
        QStringList oResult;
        SKGTESTERROR("ACCOUNT:getDistinctValues", document1.getDistinctValues("account", "t_name", oResult), true);
        SKGTEST("ACCOUNT:oResult.size", oResult.size(), 5);


        /*SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "1234567L123", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "3366.86");*/
    }

    {
        // Test import OFX with initial balance
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/initial_balance.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "40080030367683", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "5036.46");
    }

    {
        // Test import OFX with initial balance after rename of account
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Create account
            SKGBEGINTRANSACTION(document1, "CREATE_ACCOUNT", err);
            SKGTESTERROR("DOC.addOrModifyAccount", document1.addOrModifyAccount("COURANT", "111111", "BANK"), true);
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/bug_statement.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "COURANT", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "7645.86");
    }

    {
        // Test BUG 234771
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Create an account without number
            SKGBEGINTRANSACTION(document1, "CREATE_ACCOUNT", err);
            SKGTESTERROR("DOC.addOrModifyAccount", document1.addOrModifyAccount("COURANT", "", "BANK"), true);
        }
        {
            // Create an account without number
            SKGBEGINTRANSACTION(document1, "CREATE_ACCOUNT", err);
            SKGTESTERROR("DOC.addOrModifyAccount", document1.addOrModifyAccount("COURANT2", "", "BANK"), true);
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/234771.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
            // document1.dump ( DUMPOPERATION|DUMPACCOUNT );
        }

        // Test BUG 319706
        bool existMode = false;
        SKGTESTERROR("doc.existObjects", document1.existObjects("operation", "t_mode<>''", existMode), true);
        SKGTESTBOOL("doc.existMode", existMode, true);
    }

    {
        // Test UTF-8 - 284843
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/284843.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        int nb = 0;
        SKGTESTERROR("PAYEE.getNbObjects", document1.getNbObjects("v_payee", "t_name='" % QString::fromUtf8("カ－ド") % "'", nb), true);
        SKGTEST("PAYEE.getNbObjects", nb, 1);
        document1.dump(DUMPPAYEE);
    }

    {
        // Test UTF-8
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/UTF8.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }
    }

    {
        // Test 255133
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/exception.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }
    }

    {
        // Test import OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/missing_file.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), false);
        }
    }

    {
        // Test export OFX skrooge
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGImportExportManager exp(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("OUT") % "/skgtestimportofx/export.ofx"));
            SKGTESTERROR("imp1.exportFile", exp.exportFile(), false);
        }
    }

    {
        // Test 336320
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/336320.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        int nb1 = 0;
        SKGTESTERROR("PAYEE.getNbObjects", document1.getNbObjects("operation", "", nb1), true);

        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/336320.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        int nb2 = 0;
        SKGTESTERROR("PAYEE.getNbObjects", document1.getNbObjects("operation", "", nb2), true);

        SKGTEST("PAYEE.getNbObjects", nb1, nb2);
    }

    {
        // Test handling of debit amount with wrong sign
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/debit_pos.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        bool existDebitPos = false;
        SKGTESTERROR("doc.existObjects", document1.existObjects("v_operation", "t_mode='Debit' and f_currentamount>0", existDebitPos), true);
        SKGTESTBOOL("doc.existDebitPos", existDebitPos, false);
    }

    {
        // Test import OFX with missing id on transactions (Theo Raves)
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/mut.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        SKGAccountObject account;
        SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "11111111000", account), true);
        SKGTESTERROR("ACCOUNT.load", account.load(), true);
        SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-12.34");
    }

    {
        // Test import OFX from GNUCASH fr Android
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);

        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportofx/20150818_133327_gnucash_export.ofx"));
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }
    }
    // End test
    SKGENDTEST();
}
