/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A plugin for monthly report
 *
 * @author Stephane MANKOWSKI
 */
#include "skgmonthlyplugin.h"
#include "skgmonthlypluginwidget.h"
#include "skgreport.h"
#include "skgmainpanel.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>
#include <kaboutdata.h>
#include <kcolorscheme.h>
#include <kstandarddirs.h>
#include <kgenericfactory.h>

#include <QDesktopServices>
#include <QFileInfo>
#include <QDir>
#include <QFile>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGMonthlyPluginFactory, registerPlugin<SKGMonthlyPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGMonthlyPluginFactory("skg_monthly", "skg_monthly"))

SKGMonthlyPlugin::SKGMonthlyPlugin(QWidget* /*iWidget*/, QObject* iParent, const QVariantList& /*iArg*/) :
    SKGInterfacePlugin(iParent),
    m_currentBankDocument(NULL), m_mainPage(NULL)
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::SKGMonthlyPlugin");
}

SKGMonthlyPlugin::~SKGMonthlyPlugin()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::~SKGMonthlyPlugin");
    m_currentBankDocument = NULL;
}

bool SKGMonthlyPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::setupActions");
    Q_UNUSED(iArgument);
    m_currentBankDocument = iDocument;

    setComponentData(KGlobal::mainComponent());
    setXMLFile("../skg_monthly/skg_monthly.rc");

    KColorScheme scheme(QPalette::Normal, KColorScheme::Window);

    m_mainPage = new QWebView();
    m_mainPage->page()->setLinkDelegationPolicy(QWebPage::DelegateAllLinks);
    connect(m_mainPage, SIGNAL(linkClicked(QUrl)), SKGMainPanel::getMainPanel(), SLOT(openPage(QUrl)));
    SKGMainPanel::getMainPanel()->setMainWidget(m_mainPage);
    refreshMainPage();
    connect(m_currentBankDocument, SIGNAL(transactionSuccessfullyEnded(int)), this, SLOT(refreshMainPage()));

    //Make needed paths
    QString path = KStandardDirs::locateLocal("data", KGlobal::mainComponent().aboutData()->appName() % "/html/default/");

    //Copy "default" directory in locale
    foreach(const QString & file, KStandardDirs().findAllResources("data", KGlobal::mainComponent().aboutData()->appName() % "/html/default/*.html")) {
        QString target = path % QFileInfo(file).fileName();
        QFile(target).remove();
        QFile(file).copy(target);
    }

    //Create yours actions here
    return true;
}

void SKGMonthlyPlugin::refreshMainPage()
{
    QString html;

    QString templateFile = KStandardDirs().findResource("data", KGlobal::mainComponent().aboutData()->appName() % "/html/main.txt");
    if (templateFile.isEmpty()) {
        html = i18nc("Error message", "File %1/html/main.txt not found", KGlobal::mainComponent().aboutData()->appName());
    } else {
        if (m_currentBankDocument) {
            SKGReport* rep = m_currentBankDocument->getReport();
            SKGError err = rep->getReportFromTemplate(rep, templateFile, html);
            IFKO(err) html += err.getFullMessageWithHistorical();
            delete rep;
        }
    }

    m_mainPage->setHtml(html);
}

SKGTabPage* SKGMonthlyPlugin::getWidget()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::getWidget");
    return new SKGMonthlyPluginWidget(m_currentBankDocument);
}

QString SKGMonthlyPlugin::title() const
{
    return toolTip();
}

QString SKGMonthlyPlugin::icon() const
{
    return "view-documents-finances";
}

QString SKGMonthlyPlugin::toolTip() const
{
    return i18nc("A tool tip", "Monthly report");
}

int SKGMonthlyPlugin::getOrder() const
{
    return 50;
}

QStringList SKGMonthlyPlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... you can generate a monthly report.</p>"));
    output.push_back(i18nc("Description of a tips", "<p>... you can download more monthly report templates.</p>"));
    output.push_back(i18nc("Description of a tips", "<p>... you can create and share your own monthly report template.</p>"));
    return output;
}

bool SKGMonthlyPlugin::isInPagesChooser() const
{
    return true;
}
#include "skgmonthlyplugin.moc"
