/*
 * This file is part of the syndication library
 *
 * Copyright (C) 2005 Frank Osterfeld <osterfeld@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef SYNDICATION_RSS2_RSS2_H
#define SYNDICATION_RSS2_RSS2_H

#include <syndication/rss2/category.h>
#include <syndication/rss2/cloud.h>
#include <syndication/rss2/document.h>
#include <syndication/rss2/enclosure.h>
#include <syndication/rss2/image.h>
#include <syndication/rss2/item.h>
#include <syndication/rss2/parser.h>
#include <syndication/rss2/source.h>
#include <syndication/rss2/textinput.h>

namespace Syndication
{

/**
 * A parser and model classes for RSS 0.91 (Userland and Netscape flavor), 0.92, 0.93, 0.94
 * and 2.0(.1)
 */
namespace RSS2 {}

} // namespace Syndication

#endif // SYNDICATION_RSS2_RSS2_H
