/*  This file is part of the KDE project
    Copyright (C) 2008 Lukas Appelhans <l.appelhans@gmx.de>
    Copyright (C) 2008 Alessandro Diaferia <alediaferia@gmail.com>
    Copyright (C) 2008 Daniel Nicoletti <dantti85-pk@yahoo.com.br>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#include "pkitem.h"
#include "pkgroup.h"
#include "AuthorizationsModel.h"

#include <KIconLoader>

Item::Item(PolKitPolicyFileEntry* entry, AbstractItem* parent) : AbstractItem(parent),
        m_entry(entry)
{
    polkit_policy_file_entry_ref(entry);
    if (parent && parent->isGroup()) {
        static_cast<Group*>(parent)->appendChild(this);
    }
    // yep, caching the icon DOES improve speed
    QString iconName = polkit_policy_file_entry_get_action_icon_name(m_entry);
    if (KIconLoader::global()->iconPath(iconName, KIconLoader::NoGroup, true).isEmpty()) {
        m_icon = KIcon("preferences-desktop-cryptography");
    } else {
        m_icon = KIcon(iconName);
    }
}

Item::~Item()
{
    polkit_policy_file_entry_unref(m_entry);
}

QVariant Item::data(int column, int datarole)
{
    Q_UNUSED(column);
    if (datarole == Qt::DisplayRole) {
        return polkit_policy_file_entry_get_action_description(m_entry);
    } else if (datarole == Qt::DecorationRole) {
        return m_icon;
    } else if (datarole == PolkitKde::AuthorizationsModel::IdRole) {
        return polkit_policy_file_entry_get_id(m_entry);
    } else if (datarole == PolkitKde::AuthorizationsModel::PolkitEntryRole) {
        QVariant v;
        v.setValue(m_entry);
        return v;
    } else if (datarole == PolkitKde::AuthorizationsModel::EntryTypeRole) {
        return PolkitKde::AuthorizationsModel::ActionEntry;
    }
    return QVariant();
}

void Item::setEntry(PolKitPolicyFileEntry* entry)
{
    //the old one can be safely unref
    polkit_policy_file_entry_unref(m_entry);
    m_entry = entry;
    polkit_policy_file_entry_ref(entry);
}
