/***************************************************************************
                          framedlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <kcolorbutton.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include "arrayitem.h"
#include "edittextdlg.h"
#include "framedlg.h"
#include "frameitem.h"
#include "funitem.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "utils.h"

FrameDlg::FrameDlg(QWidget* _parent, KplDoc* model, int it) :
 KDialogBase(Plain, i18n("Frame"), Help | Ok | Apply | Cancel, Ok, _parent, 0,
             true, true), m(model), norm(false), item(it)
{
  fi = (FrameItem*) m->items()->at(item);
  Utils::setSize(this, "FrameDialog");
  QFrame* frame = plainPage();
  QGridLayout* grid = new QGridLayout(frame, 3, 2, 0, spacingHint());
  grid->addWidget(bg = new QButtonGroup(0, Qt::Vertical, i18n("Axis mode"),
                                        frame), 0, 0);
  QVBoxLayout* vbox2 = new QVBoxLayout(bg->layout(), 8);
  vbox2->addWidget(new QRadioButton(i18n("Frame only"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics with numbers"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid with numbers"), bg));
  ((QRadioButton*) bg->find(fi->gridmode))->setChecked(true);
  vbox2 = new QVBoxLayout(spacingHint());
  grid->addLayout(vbox2, 0, 1);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Window"), frame);
  vbox2->addWidget(g);
  QGridLayout* grid2 = new QGridLayout(g->layout(), 2, 7, spacingHint());
  grid2->addWidget(new QLabel(i18n("Left margin"), g), 0, 0);
  grid2->addWidget(ex0 = new KplDoubleEdit(fi->x0, 0.0, 200.0, g), 0, 1);
  grid2->addWidget(new QLabel("cm", g), 0, 2);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid2->addWidget(new QLabel(i18n("Width"), g), 0, 4);
  grid2->addWidget(exl = new KplDoubleEdit(fi->w, 0.5, 200.0, g), 0, 5);
  grid2->addWidget(new QLabel("cm", g), 0, 6);
  grid2->addWidget(new QLabel(i18n("Bottom margin"), g), 1, 0);
  grid2->addWidget(ey0 = new KplDoubleEdit(fi->y0, 0.0, 200.0, g), 1, 1);
  grid2->addWidget(new QLabel("cm", g), 1, 2);
  grid2->addWidget(new QLabel(i18n("Height"), g), 1, 4);
  grid2->addWidget(eyl = new KplDoubleEdit(fi->h, 0.5, 200.0, g), 1, 5);
  grid2->addWidget(new QLabel("cm", g), 1, 6);
  vbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Scaling"), frame));
  grid2 = new QGridLayout(g->layout(), 2, 7, 6);
  grid2->addWidget(new QLabel("xmin", g), 0, 0);
  grid2->addWidget(exMin = new KplDoubleEdit(fi->xmi, fi->logx ?
                                             1.0e-300 : -1.0e300,
                                             1.0e300, g, 'g', 6), 0, 1);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid2->addWidget(new QLabel("xmax", g), 0, 3);
  grid2->addWidget(exMax = new KplDoubleEdit(fi->xma, fi->logx ?
                                             1.0e-300 : -1.0e300,
                                             1.0e300, g, 'g', 6), 0, 4);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 5);
  grid2->addWidget(logX = new QCheckBox("log", g), 0, 6);
  logX->setChecked(fi->logx);
  grid2->addWidget(new QLabel("ymin", g), 1, 0);
  grid2->addWidget(eyMin = new KplDoubleEdit(fi->ymi, fi->logy ?
                                             1.0e-300 : -1.0e300,
                                             1.0e300, g, 'g', 6), 1, 1);
  grid2->addWidget(new QLabel("ymax", g), 1, 3);
  grid2->addWidget(eyMax = new KplDoubleEdit(fi->yma, fi->logy ?
                                             1.0e-300 : -1.0e300,
                                             1.0e300, g, 'g', 6), 1, 4);
  grid2->addWidget(logY = new QCheckBox("log", g), 1, 6);
  logY->setChecked(fi->logy);
  grid->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Colors"), frame),
                  1, 0);
  grid2 = new QGridLayout(g->layout(), 2, 2, spacingHint());
  grid2->addWidget(new QLabel(i18n("Frame"), g), 0, 0);
  grid2->addWidget(colFrame = new KColorButton(QColor(fi->colFrame), g), 0, 1);
  grid2->addWidget(new QLabel(i18n("Grid"), g), 1, 0);
  grid2->addWidget(colGrid = new KColorButton(QColor(fi->colGrid), g), 1, 1);
  grid->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Axes"), frame),
                  1, 1);
  grid2 = new QGridLayout(g->layout(), 2, 11, spacingHint());
  grid2->addWidget(new QLabel("xtic", g), 0, 0);
  grid2->addWidget(exTic = new KplDoubleEdit(fi->xtic, g), 0, 1);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid2->addWidget(new QLabel("xoff", g), 0, 3);
  grid2->addWidget(exOff = new KplDoubleEdit(fi->xOff, 0.0, 1.0e300, g, 'g', 6),
                   0, 4);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 5);
  grid2->addWidget(new QLabel("mticx", g), 0, 6);
  grid2->addWidget(emTicx = new KplSpinBox(0, 10, 1, g), 0, 7);
  emTicx->setValue(fi->mticx);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 8);
  grid2->addWidget(new QLabel("ndigx", g), 0, 9);
  grid2->addWidget(enDigx = new KplSpinBox(-1, 8, 1, g), 0, 10);
  enDigx->setValue(fi->ndigx);
  enDigx->setEnabled(!fi->logx);
  grid2->addWidget(new QLabel("ytic", g), 1, 0);
  grid2->addWidget(eyTic = new KplDoubleEdit(fi->ytic, g), 1, 1);
  grid2->addWidget(new QLabel("yoff", g), 1, 3);
  grid2->addWidget(eyOff = new KplDoubleEdit(fi->yOff, 0.0, 1.0e300, g, 'g', 6),
                   1, 4);
  grid2->addWidget(new QLabel("mticy", g), 1, 6);
  grid2->addWidget(emTicy = new KplSpinBox(0, 10, 1, g), 1, 7);
  emTicy->setValue(fi->mticy);
  grid2->addWidget(new QLabel("ndigy", g), 1, 9);
  grid2->addWidget(enDigy = new KplSpinBox(-1, 8, 1, g), 1, 10);
  enDigy->setValue(fi->ndigy);
  enDigy->setEnabled(!fi->logy);
  grid->addLayout(vbox2 = new QVBoxLayout(6), 2, 0);
  vbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Automatic"),
                   frame));
  QVBoxLayout* vbox3 = new QVBoxLayout(g->layout(), spacingHint());
  vbox3->addWidget(autoNorm = new QCheckBox(i18n("Normalization"), g));
  autoNorm->setChecked(m->options()->autoNorm && (!(fi->logx || fi->logy)));
  QPushButton* b = new QPushButton(i18n("Autoscale"), g);
  vbox3->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotAutoScale()));
  bool e = false;
  if ((item + 1) < (int) m->items()->count())
    for (KplItem* itm = m->items()->at(item + 1); itm;
         itm = m->items()->next()) {
      switch (itm->iType()) {
        case KplItem::Array:
        case KplItem::Function:
        case KplItem::ParFunction:
        case KplItem::Spline:
          e = true;
          break;
        default:
          break;
      }
      if (itm->iType() == KplItem::Frame)
        break;
    }
  b->setEnabled(e);
  autoNorm->setEnabled(e);
  grid->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Labels"), frame),
                  2, 1);
  grid2 = new QGridLayout(g->layout(), 3, 8, spacingHint());
  grid2->addWidget(new QLabel("iex", g), 0, 0);
  grid2->addWidget(ex = new KplSpinBox(-300, 300, 1, g), 0, 1);
  ex->setValue(fi->iex);
  grid2->addItem(new QSpacerItem(20, 10, QSizePolicy::Minimum), 0, 2);
  grid2->addWidget(new QLabel(i18n("x axis"), g), 0, 3);
  grid2->addWidget(eLetX = new QLineEdit(fi->sx, g), 0, 4);
  grid2->addWidget(b = new QPushButton("...", g), 0, 5);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetX()));
  grid2->addWidget(xBottom = new QCheckBox(i18n("Bottom"), g), 0, 6);
  xBottom->setChecked(fi->xBottom);
  grid2->addWidget(xTop = new QCheckBox(i18n("Top"), g), 0, 7);
  xTop->setChecked(fi->xTop);
  grid2->addWidget(new QLabel("iey", g), 1, 0);
  grid2->addWidget(ey = new KplSpinBox(-300, 300, 1, g), 1, 1);
  ey->setValue(fi->iey);
  grid2->addWidget(new QLabel(i18n("y axis"), g), 1, 3);
  grid2->addWidget(eLetY = new QLineEdit(fi->sy, g), 1, 4);
  grid2->addWidget(b = new QPushButton("...", g), 1, 5);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetY()));
  grid2->addWidget(yLeft = new QCheckBox(i18n("Left"), g), 1, 6);
  yLeft->setChecked(fi->yLeft);
  grid2->addWidget(yRight = new QCheckBox(i18n("Right"), g), 1, 7);
  yRight->setChecked(fi->yRight);
  grid2->addWidget(new QLabel(i18n("Heading"), g), 2, 3);
  grid2->addWidget(eLetH = new QLineEdit(fi->sh, g), 2, 4);
  grid2->addWidget(b = new QPushButton("...", g), 2, 5);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetH()));
  QHBoxLayout* hbox = new QHBoxLayout(vbox2, 6);
  hbox->addWidget(new QLabel(i18n("Symbol size"), frame));
  hbox->addWidget(eRelSiz = new KplSpinBox(10, 800, 1, frame));
  eRelSiz->setValue(qRound(100 * fi->relsiz));
  eRelSiz->setSuffix(" %");
  setHelp("SEC-FRAME");
  connect(logX, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  connect(logY, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  connect(autoNorm, SIGNAL(toggled(bool)), SLOT(slotNormToggled(bool)));
}

FrameDlg::~FrameDlg()
{
  Utils::saveSize(this, "FrameDialog");
}

void FrameDlg::getValues(bool ok)
{
  fi->xmi = exMin->value();
  fi->xma = exMax->value();
  fi->ymi = eyMin->value();
  fi->yma = eyMax->value();
  fi->logx = logX->isChecked();
  fi->logy = logY->isChecked();
  fi->xBottom = xBottom->isChecked();
  fi->xTop = xTop->isChecked();
  fi->yLeft = yLeft->isChecked();
  fi->yRight = yRight->isChecked();
  fi->xtic = exTic->value();
  if (!fi->logx) {
    double d = 0.01 *(fi->xma - fi->xmi);
    if (fi->xtic < d)
      fi->xtic = exTic->setValue(d);
  }
  fi->ytic = eyTic->value();
  if (!fi->logy) {
    double d = 0.01 *(fi->yma - fi->ymi);
    if (fi->ytic < d)
      fi->ytic = eyTic->setValue(d);
  }
  fi->xOff = exOff->value();
  fi->yOff = eyOff->value();
  fi->setPos(ex0->value(), ey0->value());
  fi->w = exl->value();
  fi->h = eyl->value();
  fi->colFrame = colFrame->color().rgb();
  fi->colGrid = colGrid->color().rgb();
  fi->iex = ex->interpretedValue();
  fi->iey = ey->interpretedValue();
  fi->mticx = emTicx->interpretedValue();
  fi->mticy = emTicy->interpretedValue();
  fi->ndigx = enDigx->interpretedValue();
  fi->ndigy = enDigy->interpretedValue();
  fi->sx = eLetX->text();
  fi->sy = eLetY->text();
  fi->sh = eLetH->text();
  fi->relsiz = 0.01 * eRelSiz->interpretedValue();
  fi->gridmode = bg->id(bg->selected());
  if (norm)
    fi->normalize(item, m->items(), fx, fy);
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}

void FrameDlg::slotLogToggled(bool state)
{
  const QCheckBox* b = (const QCheckBox*) sender();
  KplDoubleEdit *mi, *ma, *off = 0;
  if ((b == logX) || (b == logY)) {
    KplSpinBox* nd;
    if (b == logX) {
      nd = enDigx;
      mi = exMin;
      ma = exMax;
      off = exOff;
    } else {
      nd = enDigy;
      mi = eyMin;
      ma = eyMax;
      off = eyOff;
    }
    nd->setEnabled(!state);
    off->setEnabled(!state);
    double bottom = state ? 1.0e-300 : -1.0e300;
    mi->setBottom(bottom);
    ma->setBottom(bottom);
  }
  if (state) {
    autoNorm->setChecked(false);
    off->setText("0");
  }
}

void FrameDlg::slotNormToggled(bool state)
{
  if (state) {
    logX->setChecked(false);
    logY->setChecked(false);
  }
}

void FrameDlg::slotEditLetX()
{
  EditTextDlg::editText(this, eLetX);
}

void FrameDlg::slotEditLetY()
{
  EditTextDlg::editText(this, eLetY);
}

void FrameDlg::slotEditLetH()
{
  EditTextDlg::editText(this, eLetH);
}

void FrameDlg::slotAutoScale()
{
  FrameItem ft = *fi;
  ft.w = exl->value();
  ft.h = eyl->value();
  ft.logx = logX->isChecked();
  ft.logy = logY->isChecked();
  norm = ft.calcAutoScale(autoNorm->isChecked(), item, m->items(), &fx, &fy);
  if (norm) {
    ex->setValue(ft.iex);
    emTicx->setValue(ft.mticx);
    enDigx->setValue(ft.ndigx);
    exMin->setValue(ft.xmi);
    exMax->setValue(ft.xma);
    exTic->setValue(ft.xtic);
    ey->setValue(ft.iey);
    emTicy->setValue(ft.mticy);
    enDigy->setValue(ft.ndigy);
    eyMin->setValue(ft.ymi);
    eyMax->setValue(ft.yma);
    eyTic->setValue(ft.ytic);
    exOff->setValue(0.0);
    eyOff->setValue(0.0);
  }
}

void FrameDlg::slotOk()
{
  getValues(true);
}

void FrameDlg::slotApply()
{
  getValues(false);
}
