/***************************************************************************
 *
 * knetworkmanager-synchronizer.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Valentine Sinitsyn.
 *
 * Author: Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef _KNETWORKMANAGER_SYNCHRONIZER_H_
#define _KNETWORKMANAGER_SYNCHRONIZER_H_

#include <qmap.h>

class Device;

class Synchronizer
{
	public:
		Synchronizer(Device *dev);
		~Synchronizer();
		
		enum Sources
		{
			Pending = 0x01,
			Storage = 0x02,
			New = 0x04,
			Any = 0xFFFFFFFF
		};
		
		void setSources(int sources);
		/**
		 * Retrieves network identified by essid from specified sources and
		 * marks it with specified net_path.
		 *
		 * If New is not among sources, the return value can be NULL
		 *
		 * @return A pointer to synchronized network
		 */
		Network * synchronize(const QString &essid, const QString &net_path);

	private:
		Device * device;
		int sources;
};
#endif
