/***************************************************************************
                          kplchecklistitem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Aug 22 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <kapp.h>
#include "kplchecklistitem.h"

KplCheckListItem::KplCheckListItem(KListView* _parent, KplCheckListItem* after) :
#if KDE_VERSION >= 220
  KListViewItem(_parent, after), on(false)
#else
  QListViewItem(_parent, after), on(false)
#endif
{
  init();
}

KplCheckListItem::KplCheckListItem(KplCheckListItem* _parent,
                                   KplCheckListItem* after) :
#if KDE_VERSION >= 220
  KListViewItem(_parent, after), on(false)
#else
  QListViewItem(_parent, after), on(false)
#endif
{
  init();
}

KplCheckListItem::~KplCheckListItem()
{
}

void KplCheckListItem::setOn(bool b)
{
  bool old = on;
  on = b;
  if (on != old) {
    init();
    emit stateChanged(this, on);
  }
}

bool KplCheckListItem::isOn() const
{
  return on;
}

void KplCheckListItem::setOpen(bool b)
{
  if (b != isOpen()) {
    KListViewItem::setOpen(b);
    emit openChanged(this, b);
  }
}

void KplCheckListItem::init()
{
  setPixmap(0, SmallIcon(on ? "checked" : "unchecked"));
}
