/***************************************************************************
                          arraydlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARRAYDLG_H
#define ARRAYDLG_H

#include <qstring.h>
#include <kdialogbase.h>

class QLineEdit;
class QLabel;
class QCheckBox;
class KURL;
class KColorButton;
class KplSpinBox;
class KplDoc;
class ArrayItem;
class KplDoubleEdit;

/**
  * Array settings dialog class. Provides a dialog for the settings
  * of an array plot item.
  * @author Werner Stille
  */
class ArrayDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ad pointer to array object.
   */
  ArrayDlg(QWidget* parent, KplDoc* model, ArrayItem* ad);
  /** Destructor. */
  ~ArrayDlg();

protected:
  /**
   * Updates ranges of spin boxes.
   * @param ad pointer to array object.
   */
  void setSpinBoxes(ArrayItem* ad);
  /**
   * Loads file.
   * @return true when when succeeded.
   */
  bool load(KURL &url);
  /**
   * Copies settings to array object.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  /**
   * Reads edited data into array object.
   * @param fromBuffer read editor buffer instead of file when true.
   * @return true when when succeeded.
   */
  bool readData(bool fromBuffer = false);
  QString buf;
  KplDoc* m;
  ArrayItem *ad, *adt;
  KplDoubleEdit *efx, *efy;
  QLabel* fileName;
  KplSpinBox *ix, *iy, *ie, *iStart, *n, *symb, *eRelSize;
  QCheckBox *err, *internal;
  KColorButton* colData;
  QPushButton *bReload, *edit;

protected slots:
  /** Adjusts the Number of points spinbox when start index is changed. */
  void slotStartChanged(int);
  /** Adjusts the Start index spinbox when number of points is changed. */
  void slotNChanged(int);
  /** Displays the dialog for selection of a data file. */
  void slotFile();
  /** Reloads file. */
  void slotReload();
  /** Toggles internal/external data. */
  void slotInternal(bool);
  /** Edits internal data. */
  void slotEdit();
  /** Applies edited array data. */
  void slotEditApply();
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
