/***************************************************************************
                          legenditem.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Tue Aug 31 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEGENDITEM_H
#define LEGENDITEM_H

#include <qstring.h>
#include "kplitem.h"

class KplCheckListItem;

/**
  * Legend item class. Class for legends items explaining markers
  * and line types.
  * @author Werner Stille
  */
class LegendItem : public DecoItem
{
public:
  /** Constructor */
  LegendItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  LegendItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  LegendItem(KSimpleConfig* plo, Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param symb 0 for circles, < 0 for different markers,
    * >0 for different line types.
    * @param colSymb color for marker or line.
    * @param colText color for text.
    * @param x x position in cm.
    * @param y y position in cm.
    * @param xoff x offset for text in cm.
    * @param yoff y offset for text in cm.
    * @param relSize relative size of text.
    * @param text legend text.
    */
  LegendItem(bool active, int symb, const QString& colSymb,
             const QString& colText, double x, double y,
             double xoff, double yoff, double relSize,
             const QString& text);
  /** Destructor */
  virtual ~LegendItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;

protected:
  int symb;
  unsigned coltext;
  double xtext, ytext, symbSize;
  QString s;

  friend class LegendDlg;
};

#endif
