/***************************************************************************
                          kplspinbox.h  -  description
                             -------------------
    begin                : Fri Sep 8 2000
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLSPINBOX_H
#define KPLSPINBOX_H

#include <qspinbox.h>

/**
  * Spinbox class. Provides the method interpretedValue() to reflect
  * lineedit changes to the returned value.
  * @author Werner Stille
  */
class KplSpinBox : public QSpinBox
{
public:
  /**
   * Constructor.
   * @param minValue minimum value.
   * @param maxValue maximum value.
   * @param step step size.
   * @param parent pointer to parent widget.
   * @param name name of the widget.
   */
  KplSpinBox(int minValue, int maxValue, int step = 1,
             QWidget* parent = 0, const char* name = 0);
  /** Destructor */
  ~KplSpinBox();
  /**
   * Returns value according to lineedit changes.
   * @return value.
   */
  int interpretedValue();
};

#endif
