#include "kaphorism.h"
#include <qapplication.h>
#include <qpalette.h>
#include <qfontdialog.h>

spruch_widget::spruch_widget(QWidget *parent, QString spreuk, QString auth,kaphorism_widget *w)
   : 
   QLabel(parent, "Spreuk", WStyle_Customize | WStyle_StaysOnTop |
                            WStyle_NoBorderEx
         )
{
  aphorism=w;
  author=NULL;
  font=NULL;
  authorFont=NULL;
  layoutSpreuk(spreuk,auth);
}

spruch_widget::~spruch_widget()
{
  delete font;
  delete authorFont;
  delete author;
}

void spruch_widget::layoutSpreuk(QString & spreuk,QString & auth)
{
int     size,weight;
QString face;
bool    italic;

  KSimpleConfig conf("kaphorism.rc");
  conf.setGroup("font");
  face=conf.readEntry("face","times");
  size=conf.readNumEntry("size",24);
  weight=conf.readNumEntry("weight",QFont::Normal);
  italic=conf.readBoolEntry("italic",false);

  spreuk+="\n";
  if (font!=NULL) { delete font; }
  font=new QFont(face,size,weight,italic);
  setFont(*font);
  setFrameStyle(QFrame::Panel| QFrame::Raised);
  setLineWidth(4);
  setMargin(15);
  setText(spreuk);
  setBackgroundColor(colorGroup().base());
  adjustSize();

  move((QApplication::desktop()->width()- width())/2,
       (QApplication::desktop()->height()- height())/2);

  if (author==NULL) { author=new QLabel(this); }
  author->setText(auth);
  if (authorFont!=NULL) { delete authorFont; }
  authorFont=new QFont(face,(size*3)/4,weight,!italic);
  author->setFont(*authorFont);
  author->setBackgroundColor(colorGroup().base());
  author->adjustSize();

  author->move(width()-author->width()-15,height()-author->height()-20);
}

void spruch_widget::mouseReleaseEvent(QMouseEvent *e)
{
  if (e->button()==1) {
    aphorism->closed=true;
    close();
  }
  else {QString face;
        int     size,weight;
        bool    italic;

    {KSimpleConfig conf("kaphorism.rc");
     conf.setGroup("font");
     face=conf.readEntry("face","times");
     size=conf.readNumEntry("size",24);
     weight=conf.readNumEntry("weight",QFont::Normal);
     italic=conf.readBoolEntry("italic",false);
    }

    {bool ok;
     QFont font(face,size,weight,italic);
       font=QFontDialog::getFont(&ok,font,this);
       if (ok) {
          face=font.family();
          size=font.pointSize();
          weight=font.weight();
          italic=font.italic();
          {KSimpleConfig conf("kaphorism.rc");
           conf.setGroup("font");
           conf.writeEntry("face",face);
           conf.writeEntry("size",size);
           conf.writeEntry("weight",weight);
           conf.writeEntry("italic",italic);
          }
          {QString s,a;
            s=text().stripWhiteSpace();
            a=author->text().stripWhiteSpace();
            layoutSpreuk(s,a);
            update();
          }
       }
    }
  }
}
