#include <kapp.h>
#include <kaboutapplication.h>
#include <klocale.h>

#include "kaphorism.h"

#include <stdio.h>

kaphorism_widget::kaphorism_widget(QWidget *parent) 
    : QWidget(parent)
{
  displayed=false;
  closed=true;
  spruch=NULL;
  menu=new QPopupMenu();
  menu->insertItem(i18n("&Quit"),this,SLOT(quit()));
  menu->insertItem(i18n("&About"),this,SLOT(about()));
  menu->insertSeparator();
  connect(menu,SIGNAL(activated(int)),this,SLOT(choose(int)));
}

kaphorism_widget::~kaphorism_widget()
{
  delete menu;
}

void  kaphorism_widget::mouseReleaseEvent(QMouseEvent *e)
{
  if (e->button()==1) {
    if (!displayed) {
      if (spruch!=NULL) { delete spruch; }
      spruch=new spruch_widget(0,gebeSpruch(),gebeAuteur(),this);
      spruch->show();
      displayed=true;
      closed=false;
    }
    else if (closed) { 
      displayed=false;
      mouseReleaseEvent(e);
    }
    else {
      displayed=false;
      closed=true;
      delete spruch;
      spruch=NULL;
    }
  }
  else {
    menu->popup(QCursor::pos());
  }
}

void kaphorism_widget::choose(QString)
{}

QString kaphorism_widget::choice(int)
{
QString s="";
return s;
}

void kaphorism_widget::loadNew(QString)
{}

QPixmap *kaphorism_widget::pixmap(void)
{
return NULL;
}

QString kaphorism_widget::gebeSpruch(void)
{
QString s="Geen Spreuk";
return s;
}

QString kaphorism_widget::gebeAuteur(void)
{
QString s="Geen Auteur";
return s;
}

void kaphorism_widget::paintEvent(QPaintEvent *)
{
QPixmap *pic=pixmap();
  if (pic!=NULL) {
    QPainter p(this);
    int x = (width() - pic->width()) / 2;
    int y = (height() - pic->height()) / 2;
    if ( x < 0 ) x = 0;
    if ( y < 0 ) y = 0;
    p.drawPixmap(x , y, *pic);
    p.end();
  }
}

void kaphorism_widget::quit(void)
{
   kapp->quit();
}

void kaphorism_widget::about(void)
{
  KAboutApplication(this).exec();
}

void kaphorism_widget::setChoices(void)
{
int i;
QString s;
  for(i=0;(s=choice(i))!="";i++) {
    printf("%s\n",s.latin1());
    menu->insertItem(s,i+10);
  }
}

void kaphorism_widget::choose(int choice)
{
  if (choice>=10) {QString c;
    printf("%d\n",choice);
    c=menu->text(choice);
    printf("%s\n",c.latin1());
    choose(c);
    loadNew(c);
    update();
  }
}
