/***************************************************************************
                          linedlg.cpp  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "lineitem.h"
#include "symboldlg.h"
#include "linedlg.h"
#include "arrowdlg.h"

LineDlg::LineDlg(QWidget* parent, KplDoc* model, LineItem* ld0) :
 DecoDlg(parent, model, ld0, 4), ld(ld0)
{
  resize(400, 170);
  setCaption(i18n("Line"));
  ArrowDlg::initPolarEntries(this, ld, grid, &eDir, &eLen);
  initEntries(1);
  lSize->setText(i18n("Width"));
  grid->addWidget(new QLabel(i18n("Type"), this), 3, 0);
  grid->addWidget(symb = new KplSpinBox(1, 9, 1, this), 3, 1);
  symb->setValue(ld->symb);
  SymbolButton* bSymb = new SymbolButton(this, symb, true);
  grid->addWidget(bSymb, 3, 2);
  bSymb->setFixedWidth(50);
  initButtons();
  connect(bHelp, SIGNAL(clicked()), SLOT(slotHelp()));
  connect(bOK, SIGNAL(clicked()), SLOT(slotOK()));
  connect(bApply, SIGNAL(clicked()), SLOT(slotApply()));
}

LineDlg::~LineDlg()
{
}

void LineDlg::getValues(bool ok)
{
  ld->symb = symb->interpretedValue();
  ld->dir = eDir->value();
  ld->len = eLen->value();
  DecoDlg::getValues(ok);
}

void LineDlg::slotOK()
{
  getValues(true);
}

void LineDlg::slotApply()
{
  getValues(false);
}

void LineDlg::slotHelp()
{
  kapp->invokeHelp("SEC-LINE");
}
