/* Original function: gsl_sf_lngamma_impl (GNU Scientific Library)
 * Minor modifications by Werner Stille */

/* Author:  G. Jungman
 * RCS:     $Id: gamma.c,v 1.25 1998/08/17 00:33:36 jungman Exp $
 */
#include <math.h>

#define LogRootTwoPi_  0.9189385332046727418

/* coefficients for gamma=7, kmax=8  Lanczos method */
static double lanczos_7_c[9] = {
  0.99999999999980993227684700473478,
  676.520368121885098567009190444019,
 -1259.13921672240287047156078755283,
  771.3234287776530788486528258894,
 -176.61502916214059906584551354,
  12.507343278686904814458936853,
 -0.13857109526572011689554707,
  9.984369578019570859563e-6,
  1.50563273514931155834e-7
};

/* Lanczos with gamma=7, truncated at 1/(z+8)
 * [J. SIAM Numer. Anal, Ser. B, 1 (1964) 86]
 */
double lgam(double x)
{
  int k;
  double Ag;

  x -= 1.; /* Lanczos writes z! instead of Gamma(z) */
  Ag = lanczos_7_c[0];
  for (k = 1; k <= 8; k++)
    Ag += lanczos_7_c[k] / (x+k);
  return (x + 0.5) * log(x + 7.5) - (x + 7.5) + LogRootTwoPi_ + log(Ag);
}
