/***************************************************************************
                          legenddlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEGENDDLG_H
#define LEGENDDLG_H

#include <qdialog.h>

class QLineEdit;
class KplSpinBox;
class KColorButton;
class LegendItem;
class KplDoc;
class KplDoubleEdit;

/**
  * Legend settings dialog class. Provides a dialog for the settings
  * of a legend describing markers or lines.
  * @author Werner Stille
  */
class LegendDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ld pointer to legend data structure.
   */
  LegendDlg(QWidget* parent, KplDoc* model, LegendItem* ld);
  /** Destructor. */
  ~LegendDlg();

protected:
  /**
   * Copies settings to legend data structure.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  LegendItem* ld;
  KplDoubleEdit *ex0, *ey0, *exl, *eyl;
  QLineEdit* eText;
  KplSpinBox *symb, *eRelSize;
  KColorButton *colSymb, *colText;

protected slots:
  /** Displays dialog to edit text. */
  void slotEditText();
  /** Applies settings and leaves the dialog. */
  void slotOK();
  /** Applies settings without leaving the dialog. */
  void slotApply();
  /** Displays help for the legend settings dialog. */
  void slotHelp();
};

#endif
