/***************************************************************************
                          kplwidget.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qdragobject.h>
#include "kplwidget.h"

KplWidget::KplWidget(QWidget* parent) :
 QWidget(parent)
{
  pm = new QPixmap(1, 1, -1);
  setBackgroundMode(PaletteBase);
	setAcceptDrops(true);
  setMouseTracking(true);
}

KplWidget::~KplWidget()
{
  delete pm;
}

void KplWidget::paintEvent(QPaintEvent* e)
{
  QRect ur = e->rect();
  bitBlt(this, ur.topLeft(), pm, ur);
}

void KplWidget::mouseMoveEvent(QMouseEvent* e)
{
  setCursor(crossCursor);
  emit mouseMoved(e);
}

void KplWidget::mousePressEvent(QMouseEvent* e)
{
  if (e->button() == RightButton)
    emit rightButtonPressed();
  else
    if (e->button() == LeftButton)
      emit leftButtonPressed(e);
}

void KplWidget::mouseReleaseEvent(QMouseEvent* e)
{
  if (e->button() == LeftButton)
    emit leftButtonReleased(e);
}

void KplWidget::enterEvent(QEvent*)
{
  emit mouseEntered(mapFromGlobal(QCursor::pos()));
}

void KplWidget::leaveEvent(QEvent*)
{
  emit mouseLeaved();
}

void KplWidget::dragEnterEvent(QDragEnterEvent*e)
{
  if (QUriDrag::canDecode(e))
    e->accept(rect());
  else
    e->ignore(rect());
}

void KplWidget::dropEvent(QDropEvent*e)
{
  QStrList l;
  if (QUriDrag::decode(e, l)) {
    KURL::List list(QStringList::fromStrList(l));
    emit urlsDropped(&list);
    e->accept();
  } else
    e->ignore();
}
