/***************************************************************************
                          funcdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <dlfcn.h>
#include <qfileinfo.h>
#include <qlistbox.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qdir.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kcolorbtn.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include "funcdlg.h"
#include "kpldoc.h"
#include "symboldlg.h"
#include "utils.h"
#include "funitem.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"

FuncDlg::FuncDlg(QWidget* parent, KplDoc* model, FunItem* fd0) :
 QDialog(parent, 0, true), m(model), fd(fd0)
{
  fdt = new FunItem(*fd);
  resize(410, 330);
  setCaption(i18n("Function"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "y(x)", this);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, 6);
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileName = new QLineEdit(fd->pathy.isLocalFile() ?
                                           fd->pathy.path() :
                                           fd->pathy.url(), g));
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(func = new QLineEdit(fd->namey, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFunc()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameter()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, this));
  grid = new QGridLayout(g->layout(), 6, 6, 6);
  grid->addWidget(new QLabel("xmin", g), 0, 0);
  grid->addWidget(exMin = new KplDoubleEdit(fd->tmin, 0.0, 0.0, g, "%.6lg"),
                  0, 1);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel("xmax", g), 0, 4);
  grid->addWidget(exMax = new KplDoubleEdit(fd->tmax, 0.0, 0.0, g, "%.6lg"),
                  0, 5);
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("x", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  grid->addWidget(exStep = new KplDoubleEdit(fd->dt, 0.0, 0.0, g, "%.6lg"),
                  1, 1);
  grid->addItem(new QSpacerItem(20, 10), 2, 0);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 3, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, 0.0, 0.0, g, "%.6lg"), 3, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 3, 4);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, 0.0, 0.0, g, "%.6lg"), 3, 5);
  grid->addItem(new QSpacerItem(20, 10), 4, 0);
  grid->addWidget(new QLabel(i18n("Symbol"), g), 5, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 5, 1);
  symb->setValue(fd->symb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  bSymb->setFixedWidth(50);
  grid->addWidget(bSymb, 5, 2);
  grid->addWidget(new QLabel(i18n("Color"), g), 5, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 5, 5);
  colData->setMinimumWidth(50);
  hbox = new QHBoxLayout(vbox);
  hbox->addWidget(b = new QPushButton(i18n("Help"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(b = new QPushButton(i18n("OK"), this));
  b->setMinimumWidth(50);
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(b = new QPushButton(i18n("Apply"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(slotApply()));
  hbox->addWidget(b = new QPushButton(i18n("Export"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(slotExportValues()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

FuncDlg::~FuncDlg()
{
  delete fdt;
}

bool FuncDlg::getTemp()
{
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->tmin = exMin->value();
  fdt->tmax = exMax->value();
  fdt->dt = exStep->value();
  fdt->pathy = fileName->text();
  fdt->namey = func->text();
  if (fdt->hmody)
    dlclose(fdt->hmody);
  if (Utils::getFuncAddr(fdt->pathy.path(), fdt->namey, &fdt->hmody,
                         &fdt->fkty))
    return false;
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  return true;
}

void FuncDlg::getValues(bool ok)
{
  if (getTemp()) {
    *fd = *fdt;
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
    else
      *fdt = *fd;
  }
}

void FuncDlg::slotFile()
{
  Utils::getFile(fileName, m);
}

void FuncDlg::slotFunc()
{
  Utils::getFunc(this, fileName, func);
}

void FuncDlg::slotGetParameter()
{
  Utils::getPar(this, fdt->py, m);
}

void FuncDlg::slotEditParameter()
{
  EditParameterDlg dlg(this, m, fdt->py, fileName->text(), func->text());
  dlg.exec();
}

void FuncDlg::slotSaveParameter()
{
  Utils::saveFunPar(this, fdt->py, m);
}

void FuncDlg::slotExportValues()
{
  if (getTemp()) {
    KURL url;
    if (Utils::getWriteURL(this, url, "*.dat\n*", m)) {
      QFile f(url.isLocalFile() ?
              url.path() : (QDir::homeDirPath() + "/kpltmp.tmp"));
      if (f.open(IO_WriteOnly)) {
        QTextStream ts(&f);
        fdt->exportTable(ts, m);
        f.close();
        m->setCurrentDir(url);
        if (!url.isLocalFile()) {
          m->job = KIO::file_copy(KURL(QDir::homeDirPath() + "/kpltmp.tmp"),
                                  url, -1, true);
          m->connectIOfinished();
        }
      } else
        KMessageBox::error(this, i18n("while trying to open"));
    }
  }
}

void FuncDlg::slotOK()
{
  getValues(true);
}

void FuncDlg::slotApply()
{
  getValues(false);
}

void FuncDlg::slotHelp()
{
  kapp->invokeHelp("SEC-FUNC");
}

ParFuncDlg::ParFuncDlg(QWidget* parent, KplDoc* model, ParFunItem* fd0) :
 QDialog(parent, 0, true), m(model), fd(fd0)
{
  fdt = new ParFunItem(*fd);
  resize(410, 450);
  setCaption(i18n("Parametric function"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "x(t)", this);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, 6);
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileNamex = new QLineEdit(fd->pathx.isLocalFile() ?
                                            fd->pathx.path() :
                                            fd->pathx.url(), g));
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFilex()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(funcx = new QLineEdit(fd->namex, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFuncx()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameterx()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameterx()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameterx()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, "y(t)", this));
  grid = new QGridLayout(g->layout(), 3, 2, 6);
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 0, 1);
  hbox->addWidget(fileNamey = new QLineEdit(fd->pathy.isLocalFile() ?
                                            fd->pathy.path() :
                                            fd->pathy.url(), g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFiley()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(funcy = new QLineEdit(fd->namey, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFuncy()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParametery()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParametery()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParametery()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, this));
  grid = new QGridLayout(g->layout(), 6, 6, 6);
  grid->addWidget(new QLabel("tmin", g), 0, 0);
  grid->addWidget(etMin = new KplDoubleEdit(fd->tmin, 0.0, 0.0, g, "%.6lg"),
                  0, 1);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel("tmax", g), 0, 4);
  grid->addWidget(etMax = new KplDoubleEdit(fd->tmax, 0.0, 0.0, g, "%.6lg"),
                  0, 5);
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("t", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  grid->addWidget(etStep = new KplDoubleEdit(fd->dt, 0.0, 0.0, g, "%.6lg"),
                  1, 1);
  grid->addItem(new QSpacerItem(20, 10), 2, 0);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 3, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, 0.0, 0.0, g, "%.6lg"), 3, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 3, 4);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, 0.0, 0.0, g, "%.6lg"), 3, 5);
  grid->addItem(new QSpacerItem(20, 10), 4, 0);
  grid->addWidget(new QLabel(i18n("Symbol"), g), 5, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 5, 1);
  symb->setValue(fd->symb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  bSymb->setFixedWidth(50);
  grid->addWidget(bSymb, 5, 2);
  grid->addWidget(new QLabel(i18n("Color"), g), 5, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 5, 5);
  colData->setMinimumWidth(50);
  hbox = new QHBoxLayout(vbox);
  hbox->addWidget(b = new QPushButton(i18n("Help"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(b = new QPushButton(i18n("OK"), this));
  b->setMinimumWidth(50);
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(b = new QPushButton(i18n("Apply"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(slotApply()));
  hbox->addWidget(b = new QPushButton(i18n("Export"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(slotExportValues()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  b->setMinimumWidth(50);
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

ParFuncDlg::~ParFuncDlg()
{
  delete fdt;
}

bool ParFuncDlg::getTemp()
{
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->tmin = etMin->value();
  fdt->tmax = etMax->value();
  fdt->dt = etStep->value();
  fdt->pathx = fileNamex->text();
  fdt->namex = funcx->text();
  if (fdt->hmodx)
    dlclose(fdt->hmodx);
  if (Utils::getFuncAddr(fdt->pathx.path(), fdt->namex, &fdt->hmodx,
                         &fdt->fktx))
    return false;
  fdt->pathy = fileNamey->text();
  fdt->namey = funcy->text();
  if (fdt->hmody)
    dlclose(fdt->hmody);
  if (Utils::getFuncAddr(fdt->pathy.path(), fdt->namey, &fdt->hmody,
                         &fdt->fkty))
    return false;
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  return true;
}

void ParFuncDlg::getValues(bool ok)
{
  if (getTemp()) {
    *fd = *fdt;
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
  }
}

void ParFuncDlg::slotFilex()
{
  Utils::getFile(fileNamex, m);
}

void ParFuncDlg::slotFiley()
{
  Utils::getFile(fileNamey, m);
}

void ParFuncDlg::slotFuncx()
{
  Utils::getFunc(this, fileNamex, funcx);
}

void ParFuncDlg::slotFuncy()
{
  Utils::getFunc(this, fileNamey, funcy);
}

void ParFuncDlg::slotGetParameterx()
{
  Utils::getPar(this, fdt->px, m);
}

void ParFuncDlg::slotGetParametery()
{
  Utils::getPar(this, fdt->py, m);
}

void ParFuncDlg::slotEditParameterx()
{
  EditParameterDlg dlg(this, m, fdt->px, fileNamex->text(), funcx->text());
  dlg.exec();
}

void ParFuncDlg::slotEditParametery()
{
  EditParameterDlg dlg(this, m, fdt->py, fileNamey->text(), funcy->text());
  dlg.exec();
}

void ParFuncDlg::slotSaveParameterx()
{
  Utils::saveFunPar(this, fdt->px, m);
}

void ParFuncDlg::slotSaveParametery()
{
  Utils::saveFunPar(this, fdt->py, m);
}

void ParFuncDlg::slotExportValues()
{
  if (getTemp()) {
    KURL url;
    if (Utils::getWriteURL(this, url, "*.dat\n*", m)) {
      QFile f(url.isLocalFile() ?
              url.path() : (QDir::homeDirPath() + "/kpltmp.tmp"));
      if (f.open(IO_WriteOnly)) {
        QTextStream ts(&f);
        fdt->exportTable(ts, m);
        f.close();
        m->setCurrentDir(url);
        if (!url.isLocalFile()) {
          m->job = KIO::file_copy(KURL(QDir::homeDirPath() + "/kpltmp.tmp"),
                                  url, -1, true);
          m->connectIOfinished();
        }
      } else
        KMessageBox::error(this, i18n("while trying to open"));
    }
  }
}

void ParFuncDlg::slotOK()
{
  getValues(true);
}

void ParFuncDlg::slotApply()
{
  getValues(false);
}

void ParFuncDlg::slotHelp()
{
  kapp->invokeHelp("SEC-PARFUNC");
}
