/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>
#include <kaccel.h>
#include <krun.h>
#include <kmainwindow.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbear.h"
#include "resource.h"

static const char *description = 	I18N_NOOP( IDS_APPNAME );

int main(int argc, char *argv[]) {
 	KAboutData aboutData( "kbear", IDS_APPNAME,
			VERSION, description , KAboutData::License_GPL,
			I18N_NOOP( IDS_COPYRIGHT ),I18N_NOOP("A graphical FTP client for KDE"), IDS_HOMEPAGE, IDS_AUTHOR_EMAIL );
	aboutData.addAuthor( IDS_AUTHOR, I18N_NOOP("Implementation"), IDS_AUTHOR_EMAIL, IDS_HOMEPAGE );
	aboutData.addCredit ( "Steven Hatfield",
									I18N_NOOP("For beta testing and suggestions"),
									"ashari@server.knightswood.net" );
	aboutData.addCredit ( "Rinse de Vries", I18N_NOOP("Dutch translation"), "rinse@daxis.nl" );
	aboutData.addCredit ( "Martin Adler", I18N_NOOP("German translation"), "Martin.Adler@gmx.net" );
	aboutData.addCredit ( "Norbert Popiolek", I18N_NOOP("Polish translation"), "norbert@kde.com.pl" );
	aboutData.addCredit ( "Herv PARISSI", I18N_NOOP("French translation"), "hparissi@mail.dotcom.fr" );
	aboutData.addCredit ( "Danilo Ingami", I18N_NOOP("Italian translation 1"), "kosmo@europe.com" );
	aboutData.addCredit ( "Vincenzo Linarello from cooperativa sociale l'Utopia", I18N_NOOP("Italian translation update"), "linux.com@tiscalinet.it", "http://www.comunita.org/utopia/index2.htm" );
	aboutData.addCredit ( "Jlio Maranho", I18N_NOOP("Brazilian Portuguese translation"), "julio_maranhao@hotmail.com" );
	aboutData.addCredit ( "Juan Luis Baptiste from Merlinux Group",
									I18N_NOOP("Spanish translation and Mandrake 7.2 rpm package"),
									"jbaptiste@nextmedia-i.com", "http://www.merlinux.org" );
	aboutData.addCredit ( "Falk Brettschneider",
									I18N_NOOP("For implementing the excellent library QextMdi"),
									"gigafalk@yahoo.com", "http://www.geocities.com/gigafalk/qextmdi.htm" );
	aboutData.addCredit ( "Carsten Pfeiffer" , I18N_NOOP("For tips and encourage"), "pfeiffer@kde.org" );
	aboutData.addCredit ( "David Faure", I18N_NOOP("For help and tips"), "david@mandrakesoft.com" );
	aboutData.addCredit ( "All students at ITE", I18N_NOOP("For NOT testing it ;-)"), "itestud@ite.mh.se", "www2.ite.mh.se" );
	
	KCmdLineArgs::init( argc, argv, &aboutData );
	
	KApplication app;
	
	QFrame *f = new QFrame( 0L, "KBear Splash",QWidget::WStyle_NoBorderEx | QWidget::WStyle_Customize );
	QPixmap pm( UserIcon("kbear-logo") );
	f->setBackgroundPixmap(pm);
	f->setGeometry( QApplication::desktop()->width ()/2-300,
  						    	QApplication::desktop()->height()/2-60, 600, 120 );
	f->show();
	
	KBear* myKBearApp = new KBear();
   	app.setMainWidget( myKBearApp );
	delete f;
	myKBearApp->show();
	return app.exec();
}
