/***************************************************************************
                          kbear.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 *********************************************************************************/
#include "kbear.h"

//-----------------------------------------------
KBear::KBear()
	:	QextMdiMainFrm( 0 ), localFileSys( 0L ),
		localFileSysCaption( i18n("Your Local File System" ) ),
		myClipBoard( new KBearClipBoard() ),
		p_activeView( 0L ), firstRun( false )
{
	openWithHandler = new KFileOpenWithHandler();
   //set application config file
 	myConfig =  new KConfig("kbearrc");

	myCaption = IDS_APPNAME;
	myCaption += " - ";
	myCaption += VERSION;
	///////////////////////////////////////////////////////////////////
	// call inits to invoke all other construction parts
	createMdiManager();
	setupActions();
	initMenuBar();
	initToolBar();
	initStatusBar();
	transferView = new KBearTransferView( p_mySplitter, "TransferView" );
	p_mySplitter->setResizeMode( transferView, QSplitter::KeepSize );
	// read config file
	readOptions();
	fillWindowMenu();
	initLocalFileSys();
	myConfig->setGroup("General Options");
	firstRun = myConfig->readBoolEntry( "First Run", true );
	if( firstRun )
   		slotWelcome();
   	myConfig->setGroup("View Options");
	if( myConfig->readBoolEntry( "TopLevel Mode", false ) )
		switchToToplevelMode();
	else
		switchToChildframeMode();

}
//-----------------------------------------------
KBear::~KBear() {
	delete myClipBoard;
	delete openWithHandler;
}
//-----------------------------------------------
void KBear::show() {
	setPlainCaption( myCaption );
	QextMdiMainFrm::show();
	QApplication::restoreOverrideCursor();

	myConfig->setGroup("General Options");
	if( myConfig->readBoolEntry( "Run Tip Of Today", true ) )
		slotRunTipOfToday();
	if( firstRun)
		slotFtpSiteManager();
}
//-----------------------------------------------
void KBear::fillWindowMenu() {
	QextMdiMainFrm::fillWindowMenu();
   m_pPlacingMenu->clear();
   m_pPlacingMenu->insertItem( i18n("Ca&scade windows"), this,SLOT(cascadeWindows()));
   m_pPlacingMenu->insertItem(i18n("Cascade &maximized"), this,SLOT(cascadeMaximized()));
   m_pPlacingMenu->insertItem(i18n("Expand &vertical"), this,SLOT(expandVertical()));
   m_pPlacingMenu->insertItem(i18n("Expand &horizontal"), this,SLOT(expandHorizontal()));
   m_pPlacingMenu->insertItem(i18n("A&nodine's tile"), this,SLOT(tileAnodine()));
   m_pPlacingMenu->insertItem(i18n("&Pragma's tile"), this,SLOT(tilePragma()));
   m_pPlacingMenu->insertItem(i18n("Tile v&ertically"), this,SLOT(tileVertically()));
	int pos = m_pDockMenu->idAt( 0 );
	m_pDockMenu->setAccel( Key_F5, pos );
	pos = m_pDockMenu->idAt( 1 );
	m_pDockMenu->setAccel( Key_F6, pos );
}
//-----------------------------------------------
void KBear::initMenuBar() {
	///////////////////////////////////////////////////////////////////
	// MENUBAR
	///////////////////////////////////////////////////////////////////
	// popup menu for recent connections
	recentFtpMenu = new QPopupMenu( this );
	connect(recentFtpMenu, SIGNAL(activated(int)), SLOT(slotFtpOpenRecent(int)));

	///////////////////////////////////////////////////////////////////
	// menuBar entry FTP
	ftpMenu = new QPopupMenu( this );
	quickConnectAction->plug( ftpMenu );
	disConnectAction->plug( ftpMenu );
	ftpMenu->insertSeparator();
	ftpMenu->insertItem(i18n("Open &Recent..."), recentFtpMenu );
	ftpMenu->insertSeparator();
	clearRecentAction->plug( ftpMenu );
	ftpMenu->insertSeparator();
	siteManagerAction->plug( ftpMenu );
	ftpMenu->insertSeparator();
	quitAction->plug( ftpMenu );

	///////////////////////////////////////////////////////////////////
	// menuBar entry Edit
	editMenu = new QPopupMenu( this );
	cutAction->plug( editMenu );
	copyAction->plug( editMenu );
	pasteAction->plug( editMenu );
	editMenu->insertSeparator();
	findAction->plug( editMenu );
	editMenu->insertSeparator();
	selectAllAction->plug( editMenu );
	clearSelectionAction->plug( editMenu );
	invertSelectionAction->plug( editMenu );

	///////////////////////////////////////////////////////////////////
	// menuBar entry Settings
	settingsMenu=new QPopupMenu(  this );
	toolBarToggleAction->plug( settingsMenu );
	statusBarToggleAction->plug( settingsMenu );
	taskBarToggleAction->plug( settingsMenu );
	transferViewToggleAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	localFileSysToggleAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	settingsAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	runTipAction->plug( settingsMenu );
	settingsMenu->insertSeparator();
	wizardAction->plug( settingsMenu );
	///////////////////////////////////////////////////////////////////
	// menuBar entry Help
	myHelpMenu = customHelpMenu();
	
	///////////////////////////////////////////////////////////////////
	// MENUBAR CONFIGURATION
	// set menuBar() the current menuBar

	menuBar()->insertItem(i18n("&FTP"), ftpMenu);
	menuBar()->insertItem(i18n("&Edit"), editMenu);
	menuBar()->insertItem(i18n("&Settings"), settingsMenu);
	menuBar()->insertItem(i18n("&Window"), windowMenu());
	menuBar()->insertItem(i18n("&Help"), myHelpMenu);

	setMenuForSDIModeSysButtons( menuBar() );
///////////////////////////////////////////////////////////////////////
}
//-----------------------------------------------
void KBear::initToolBar() {
	///////////////////////////////////////////////////////////////////
	// TOOLBAR
	toolBar = new KToolBar( this, "MainToolBar");
   toolBar->setBarPos( KToolBar::Top );

	quickConnectAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	disConnectAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	siteManagerAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	cutAction->plug( toolBar );
	copyAction->plug( toolBar );
	pasteAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	findAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	
	// Check if KMail is installed
	QString tmp = KGlobal::dirs()->findResourceDir( "apps", "Internet/KMail.desktop" );
	if( tmp == QString::null )  // No it's not so disable the action
		emailAction->setEnabled( false );
	emailAction->plug( toolBar );
	
	actionSeparator->plug( toolBar );
	browserAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	helpAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	whatsThisAction->plug( toolBar );
	actionSeparator->plug( toolBar );
	runTipAction->plug( toolBar );
}
//-----------------------------------------------
void KBear::initStatusBar() {
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(i18n( "Ready." ) );
}

//-----------------------------------------------
void KBear::slotCreateClient( ConnectInfo& info, bool addRecent ) {
	int numOfViews = (int)m_pWinList->count();
	QextMdiChildView* w = new KBearFtpView( this, 0L, info.host );
	addWindow( w );
	QWhatsThis::add(w,i18n("This Window displays the remote file system.\n"
  												"You can use this to transfer files and folders to or\n"
  												"from your local file system by drag and drop."));
	w->resize( 400, 300 );
	w->show();
	w->setIcon( KApplication::kApplication()->miniIcon() );
	w->setMDICaption( info.host );

	if( isInTopLevelMode() )
		connect( w, SIGNAL(viewPositionChanged() ),
						this, SLOT( saveChildViewPositions() ) );
	connect( w, SIGNAL(gotFocus( QextMdiChildView* ) ),
					this, SLOT( slotSetActiveView( QextMdiChildView* ) ) );
	
	((KBearFtpView*)w)->slotConnectRemote( info.host, info.port, info.anonym, info.user, info.pass, info.path );
	QValueList<int>::Iterator iter( childStartPositions.begin() );
	if( b_rememberChildPositions && isInTopLevelMode() ) {
		KActionCollection* coll = ((KBearFtpView*)w)->myOperator()->actionCollection();
		if( ((KToggleAction*)coll->action("detailed list" ))->isChecked() )
			((KBearFtpView*)w)->myOperator()->slotSetDetailedListViewMode();
		else
			((KBearFtpView*)w)->myOperator()->slotSetIconViewMode();

		if( numOfViews < (int)childStartPositions.count()/4 ) {
			iter = childStartPositions.at( numOfViews * 4 );
			int x = *iter++;
			int y = *iter++;
			int width = *iter++;
			int height = *iter;
			w->setGeometry( x, y, width, height );
		}
	}
	else if( b_autoChildFrameMode && ! isInTopLevelMode() )
		setChildFrameMode( currentChildFrameMode );
	if( info.label != "" && addRecent )
		addRecentFile( info.label );
	
	p_activeView = localFileSys;
}
//-----------------------------------------------
void KBear::initLocalFileSys() {
  	localFileSys = new KBearFtpView( this, 0L, localFileSysCaption);
  	addWindow( localFileSys );
  	QWhatsThis::add( localFileSys, i18n("This Window displays your local file system.\n"
  															"You can use this to transfer files and folders to or\n"
  															"from a remote host by drag and drop."));
	// local filesystem settings
	myConfig->setGroup("View Options");
	bool b_localFileSysCheckBox = myConfig->readBoolEntry("Show Local", true);
	setLocalFileSystemEntry( b_localFileSysCheckBox );
	localFileSys->resize( 400, 300 );
	if( !	b_localFileSysCheckBox ) {
		localFileSys->hide();
		removeWindowFromMdi( localFileSys );
	}
	else
		localFileSys->show();
	localFileSys->setIcon( KApplication::kApplication()->miniIcon() );
	localFileSys->setMDICaption( localFileSysCaption );

	if( isInTopLevelMode() )
		connect( localFileSys, SIGNAL(viewPositionChanged() ),
						this, SLOT( saveChildViewPositions() ) );
	connect( localFileSys, SIGNAL(gotFocus( QextMdiChildView* ) ),
					this, SLOT( slotSetActiveView( QextMdiChildView* ) ) );
	connect( (KBearFtpView*)localFileSys, SIGNAL(localFileSysCloseRequest() ),
					localFileSysToggleAction, SLOT( activate() ) );
	((KBearFtpView*)localFileSys)->slotConnectLocal( QDir::homeDirPath() );
	
	p_activeView = localFileSys;
}
//-----------------------------------------------
bool KBear::queryExit() {
	saveOptions();
	return true;
}
//-----------------------------------------------
bool KBear::queryClose() {
	myConfig->setGroup("General Options");
	if( ! myConfig->readBoolEntry( "Confirm On Exit", true)
			|| (transferView->childCount() == 0 && transferQueue.count() == 0) )
		return true;
	
	KBearQueryExit* queryExitDlg = new KBearQueryExit( this, "KBearQueryExit", true);
	queryExitDlg->numOfTransfers->display( i18n("%1").arg(transferView->childCount()));
	queryExitDlg->numOfQueuedTransfers->display( i18n("%1").arg(transferQueue.count()));
	bool confirm = true;
	queryExitDlg->askAgainCheckBox->setChecked( ! confirm );
	int accept = queryExitDlg->exec();
	confirm = queryExitDlg->askAgainCheckBox->isChecked();
	delete queryExitDlg;
	if ( accept == QDialog::Accepted ) {
		myConfig->writeEntry( "Confirm On Exit", !confirm );
		return true;
	}
	return false;
}
//-----------------------------------------------
void KBear::slotFtpQuickConnect() {
  	statusBar()->message(i18n("Opening new connection..."));
	KBearQuickConnect* quickConnectDlg = new KBearQuickConnect( this,"QuickConnect");
	quickConnectDlg->setCaption(i18n("QuickConnect"));
	connect( quickConnectDlg, SIGNAL( remoteConnect( ConnectInfo&, bool ) ),
					this, SLOT( slotCreateClient( ConnectInfo&, bool ) ) );
  	connect( quickConnectDlg, SIGNAL( saveToSiteManager( SiteInfo& ) ),
					this, SLOT( slotSaveToSiteManager( SiteInfo& ) ) );
  	quickConnectDlg->exec();
  	delete quickConnectDlg;
  	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotFtpSiteManager() {
  	statusBar()->message(i18n("Opening the SiteManager..."));
	KDialogBase dialog( this, "SiteManagerDialog", true, i18n("SiteManager"), 0, KDialogBase::Ok );

	KBearSiteManager* mySiteManager = new KBearSiteManager( &dialog,"SiteManager");
	connect( mySiteManager, SIGNAL( remoteConnect( ConnectInfo&, bool ) ),
					this, SLOT( slotCreateClient( ConnectInfo&, bool ) ) );
	mySiteManager->setConnectEnabled( true );
	dialog.setMainWidget( mySiteManager );
	connect( mySiteManager,SIGNAL( close() ),&dialog,SLOT( slotOk() ) );
	dialog.setInitialSize( QSize(500,500));
	dialog.exec();	
  	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotFtpDisconnect() {
	KBearFtpView* m = (KBearFtpView*)activeWindow();
  	if( m == (KBearFtpView*)localFileSys )
  		KMessageBox::sorry (this, i18n("Sorry, you can't disconnect from your local filesystem ;-)"), i18n("Disconnect..."));
  	else {
		statusBar()->message(i18n("Closing connection..."));
		if( m ) 	{
			m->close();		
  		}
  	}
  	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotFtpQuit()
{
  statusBar()->message(i18n("Exiting application...") );
  ///////////////////////////////////////////////////////////////////
  // exits the Application
	if( queryClose() )
		qApp->exit();
	
	statusBar()->message( i18n("Ready.") );
}
//-----------------------------------------------
void KBear::slotViewToolBar()
{
  statusBar()->message(i18n("Toggle toolbar...") );
  ///////////////////////////////////////////////////////////////////
  // turn toolbar on or off
  if (toolBar->isVisible()) {
    toolBar->hide();
    toolBarToggleAction->setChecked( false );
  }
  else {
    toolBar->show();
    toolBarToggleAction->setChecked( true );
  }
  statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotViewStatusBar() {
  statusBar()->message(i18n("Toggle statusbar...") );
  ///////////////////////////////////////////////////////////////////
  //turn statusbar on or off

  if ( statusBar()->isVisible() )   {
    statusBar()->hide();
    statusBarToggleAction->setChecked( false );
  }
  else   {
    statusBar()->show();
    statusBarToggleAction->setChecked( true );
  }

  statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotViewTaskBar(){
  statusBar()->message(i18n("Toggle taskbar...") );
  ///////////////////////////////////////////////////////////////////
  //turn statusbar on or off

  if (m_pTaskBar->isVisible()) {
    hideViewTaskBar();
    taskBarToggleAction->setChecked( false );  }
  else {
    showViewTaskBar();
    taskBarToggleAction->setChecked( true );  }

  statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotStatusHelpMsg(const QString &text){
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}
//-----------------------------------------------
/**  undocks all view windows (unix-like) */
void KBear::switchToToplevelMode(){
	if( isInTopLevelMode() )
		return;
	QextMdiMainFrm::switchToToplevelMode();

	if( b_rememberChildPositions )
		setChildViewPositions();
	p_activeView = 0L;
	for(QextMdiChildView* view = m_pWinList->first(); view!=0; view=m_pWinList->next() ) {
		KActionCollection* coll = ((KBearFtpView*)view)->myOperator()->actionCollection();
		if( ((KToggleAction*)coll->action( "detailed list" ))->isChecked() )
			((KBearFtpView*)view)->myOperator()->slotSetDetailedListViewMode();
		else
			((KBearFtpView*)view)->myOperator()->slotSetIconViewMode();
			connect( view, SIGNAL(viewPositionChanged() ),
						this, SLOT( saveChildViewPositions() ) );
	}
//	QApplication::restoreOverrideCursor();
}
//-----------------------------------------------
/** docks all view windows (Windows-like) */
void KBear::switchToChildframeMode(){
	QApplication::sendPostedEvents();
	for(QextMdiChildView* view = m_pWinList->first(); view!=0; view=m_pWinList->next() )
		disconnect( view, SIGNAL(viewPositionChanged() ),
						this, SLOT( saveChildViewPositions() ) );
   QRect rect = geometry();
   QextMdiMainFrm::switchToChildframeMode();
	setGeometry( rect.x(), rect.y(), width(), height() );
	if( b_autoChildFrameMode )
		setChildFrameMode( currentChildFrameMode );
//	QApplication::restoreOverrideCursor();
}
//-----------------------------------------------
/** just additionally fits the system menu button position to the menu position */
void KBear::resizeEvent ( QResizeEvent *e) {
   QextMdiMainFrm::resizeEvent( e );
   setSysButtonsAtMenuPosition();
}
//-----------------------------------------------
/** toggles the transfer view */
void KBear::slotViewTransferWindow(){
	if( localFileSys == 0L )
		return;
	statusBar()->message(i18n("Toggle the transfer view..."));
	///////////////////////////////////////////////////////////////////
	//turn TransferView on or off
	if( transferViewToggleAction->isChecked() )
		transferView->show();
	else
		transferView->hide();
	
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
/** toggles the home window */
void KBear::slotLocalFileSys() {
	statusBar()->message(i18n("Toggle the local file system window..."));
	///////////////////////////////////////////////////////////////////
	//turn LocalFileSys on or off
	if( localFileSysToggleAction->isChecked() ) {
		addWindow( localFileSys );
		localFileSys->show();
		if( b_rememberChildPositions && isInTopLevelMode() )
			setChildViewPositions();
	}
	else {
		localFileSys->hide();
		removeWindowFromMdi( localFileSys );
	}
	if( b_autoChildFrameMode && ! isInTopLevelMode() )
		setChildFrameMode( currentChildFrameMode );
	
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::saveOptions() {	
	myConfig->setGroup("General Options");
	myConfig->writeEntry("First Run", false );
	myConfig->writeEntry("Recent Connections", recentConnections );
	bool b_runTimeSettings = myConfig->readBoolEntry( "Run Time Settings", true);
	if( b_runTimeSettings )
		myConfig->writeEntry("Queue Transfers", b_queueTransfers );
	myConfig->writeEntry( "Run Time Settings", b_runTimeSettings );
//	myConfig->writeEntry( "Auto Resume", KProtocolManager::autoResume() );		
	
	myConfig->setGroup("View Options");
	myConfig->writeEntry ( "Splitter", p_mySplitter->sizes() );
	if( b_runTimeSettings ) {
		myConfig->writeEntry("Show Local", localFileSysToggleAction->isChecked() );
		myConfig->writeEntry("Show Statusbar", statusBarToggleAction->isChecked() );
		myConfig->writeEntry("Show Taskbar", taskBarToggleAction->isChecked() );
		myConfig->writeEntry("Show Toolbar", toolBarToggleAction->isChecked() );
		myConfig->writeEntry("Show TransferView", transferViewToggleAction->isChecked() );
		myConfig->writeEntry("TopLevel Mode", isInTopLevelMode() );
		if( b_autoChildFrameMode )
			defaultChildFrameMode = currentChildFrameMode;
		myConfig->writeEntry( "ChildFrame Mode", defaultChildFrameMode );
	}
	myConfig->writeEntry ( "Remember Child Positions", b_rememberChildPositions );
	saveChildViewPositions();	

	if( localFileSys )
		((KBearFtpView*)localFileSys)->myOperator()->saveConfig( myConfig, "View Settings" );
	saveMainWindowSettings( myConfig );
	myConfig->sync();
}
//-----------------------------------------------
void KBear::readOptions() {
	applyMainWindowSettings( myConfig );
	myConfig->setGroup("View Settings");
	// geometry settings
	QRect rect(0,0,myConfig->readNumEntry("Width",640),
							myConfig->readNumEntry("Height",520));
	setGeometry( rect );
	
	myConfig->setGroup("General Options");
	recentConnections.setAutoDelete( true );
	
	bool firstRun = myConfig->readBoolEntry( "First Run", true);
	if( firstRun ) {
		toolBar->setBarPos( KToolBar::Top );
		m_pTaskBar->setBarPos( KToolBar::Bottom );
	}
	// initialize the recent file list
	int numOfEntries = myConfig->readListEntry("Recent Connections",recentConnections);
	for (int i=0; i < numOfEntries; i++)
		recentFtpMenu->insertItem( QString::fromUtf8(recentConnections.at( i ) ) );
	
	IDS_STARTPAGE = myConfig->readEntry( "Start Page" , IDS_STARTPAGE );

	str_emailDefault = myConfig->readEntry( "Default Email" , "" );

	b_queueTransfers = myConfig->readBoolEntry( "Queue Transfers", false );
	
//	KProtocolManager::setAutoResume( myConfig->readBoolEntry( "Auto Resume", false) );		
	
	myConfig->setGroup("View Options");
	
	//splitter geometry
	if( firstRun ) {
		QValueList<int> list;
		list << 212 << 104;
		p_mySplitter->setSizes( list );
	}
	else
		p_mySplitter->setSizes( myConfig-> readIntListEntry( "Splitter" ) );
	
	// statusbar settings
	bool b_statusBarCheckBox = myConfig->readBoolEntry("Show Statusbar", true);
	statusBarToggleAction->setChecked( b_statusBarCheckBox );
	if( ! b_statusBarCheckBox )
		statusBar()->hide();
	// taskbar settings
	bool b_taskBarCheckBox = myConfig->readBoolEntry("Show Taskbar", true);
	taskBarToggleAction->setChecked( b_taskBarCheckBox );
	if( ! b_taskBarCheckBox )
		hideViewTaskBar();
	
	// toolbar settings
	bool b_toolBarCheckBox = myConfig->readBoolEntry("Show Toolbar", true);
	toolBarToggleAction->setChecked( b_toolBarCheckBox );
	if( ! b_toolBarCheckBox)
		toolBar->hide();
	
	// transferview settings
	bool b_transferViewCheckBox = myConfig->readBoolEntry("Show TransferView", true);
	transferViewToggleAction->setChecked( b_transferViewCheckBox );
	if( ! b_transferViewCheckBox )
		transferView->hide();
	b_rememberChildPositions = myConfig->readBoolEntry( "Remember Child Positions",  true );
	childStartPositions = myConfig->readIntListEntry( "Child Positions" );
	

	b_autoChildFrameMode = myConfig->readBoolEntry( "Use Auto ChildFrame Mode", true);
	defaultChildFrameMode = myConfig->readUnsignedNumEntry( "ChildFrame Mode", ChildFrameModeSettings::AnodinesTile );
	currentChildFrameMode = defaultChildFrameMode;
	if( b_autoChildFrameMode && ! isInTopLevelMode() ) // if we should use auto child frame mode
		setChildFrameMode( currentChildFrameMode ); // auto arrange
}
//-----------------------------------------------
void KBear::slotFtpOpenRecent(int id ) {
	statusBar()->message(i18n("Opening connection..."));
	KBearSiteManager* mySiteManager = new KBearSiteManager( 0,"SiteManager");
	SiteInfo* siteInf = mySiteManager->selectedSite( recentFtpMenu->text( id  ) );
	if( siteInf )
		slotCreateClient( siteInf->info, false );
	else {
		KMessageBox::error ( this, i18n("Can't find the site: %1\n"
													"It's probably removed from the SiteManager.\n"
													"It will now also be removed from the list over recent connections").arg(recentFtpMenu->text( id ))
									, i18n("Error opening recent...") );
		recentConnections.find( recentFtpMenu->text( id ) );
		if( recentConnections.current() )
			recentConnections.remove( recentConnections.current() ); 			
		recentFtpMenu->removeItem( id );
	}
	delete mySiteManager;
	statusBar()->message( i18n("Ready.") );
}
//-----------------------------------------------
void KBear::slotFtpClearRecent() {
	recentFtpMenu->clear();
	recentConnections.clear();
}
//-----------------------------------------------
void KBear::addRecentFile(const QString &file) {
	if(recentConnections.contains(file.utf8()))
		return; // it's already there

	if( recentConnections.count() >= 10)
		recentConnections.remove(recentConnections.last());
	
	recentConnections.prepend(file.utf8());

	recentFtpMenu->clear();

	for ( int i =0 ; i < (int)recentConnections.count(); i++)
		recentFtpMenu->insertItem(QString::fromUtf8(recentConnections.at(i)));
}
//-----------------------------------------------
void KBear::showAboutApplication () {
	KAboutApplication about( this );
	about.exec();
}
//-----------------------------------------------
/** uncheck the meny entry for local file system */
void KBear::setLocalFileSystemEntry( bool flag ){
	localFileSysToggleAction->setChecked( flag );
}
//-----------------------------------------------
/**  */
void KBear::slotCut(){
	slotCopy();
	if( ! myClipBoard->isEmpty() )
		myClipBoard->setCut( true );
	if( isInTopLevelMode() )
		p_activeView = 0L;

}
//-----------------------------------------------
/**  */
void KBear::slotCopy(){
	if( isInTopLevelMode() && ! p_activeView ) {
		showActionDisabledInTopLevelMode();
		return;
	}
	KBearFtpView* current = (KBearFtpView*)p_activeView;
	KURL::List urlList = current->myHighlightedItems();
	if( ! urlList.isEmpty() ) {
		pasteAction->setEnabled( true );
		myClipBoard->setContents( urlList, current->myOperator()->viewWidget() );
		myClipBoard->setCut( false );
	}
	if( isInTopLevelMode() )
		p_activeView = 0L;
}
//-----------------------------------------------
/**  */
void KBear::slotPaste() {
	if( isInTopLevelMode() && ! p_activeView ) {
		showActionDisabledInTopLevelMode();
		return;
	}
	KBearFtpView* current = (KBearFtpView*)p_activeView;
	pasteAction->setEnabled( false );
	if( myClipBoard->isEmpty() )
		return;
	KURL::List lst = myClipBoard->clipBoardContents();
	if( myClipBoard->cut() )
		startTransfer( current, lst, true );
	else
		startTransfer( current, lst, false );
	
	myClipBoard->clear();
	myClipBoard->setCut( false );
	if( isInTopLevelMode() )
		p_activeView = 0L;
}
//-----------------------------------------------
/**  */
void KBear::slotFind(){
	if( isInTopLevelMode() && ! p_activeView ) {
		showActionDisabledInTopLevelMode();
		return;
	}
	KBearFtpView* current = (KBearFtpView*)p_activeView;
	KBearSearch myDialog( this, "SearchDialog", true );
	if( myDialog.exec() == QDialog::Accepted ){
		bool caseSensitive = myDialog.caseSensitiveCheckBox->isChecked();	
		QString name = myDialog.searchEdit->text();
		((KBearFtpView*)current)->myOperator()->setCurrentItem( name, caseSensitive );
	}
	if( isInTopLevelMode() )
		p_activeView = 0L;
}
//-----------------------------------------------
/** this function is invoced first time the user
starts KBear to setup the app, can also be started from the menu */
void KBear::slotWelcome() {
	KBearWizard myWiz( this, "Wizard" );
	setDialogSettings( myWiz.settingsWidget(), myWiz.mixedSettingsWidget(), myWiz.childFrameModeSettings() );
	myWiz.exec();
	changeViewSettings( myWiz.settingsWidget() );	
	changeMixedSettings( myWiz.mixedSettingsWidget() );	
	changeChildFrameModeSettings( myWiz.childFrameModeSettings() );	
//	KProtocolManager::reparseConfiguration();
}
//-----------------------------------------------
/**  */
void KBear::slotShowHelp(){
	KApplication::kApplication()->invokeHelp();
}
//-----------------------------------------------
/** open a dialog for setting general application settings */
void KBear::slotSettings(){
	settingsDialog = new KBearSettingsDialog( this, "SettingsDialog" );
	connect( settingsDialog, SIGNAL( applyClicked() ), this, SLOT( slotApplySettings() ) );
	ViewSettingsWidget* view = settingsDialog->viewSettingsWidget();
	MixedSettingsWidget* mixed = settingsDialog->mixedSettingsWidget();
	ChildFrameModeSettings* child = settingsDialog->childFrameModeSettings();
	setDialogSettings( view, mixed, child );
	if( settingsDialog->exec() == QDialog::Accepted ) {
		changeViewSettings( view );
		changeMixedSettings( mixed );
		changeChildFrameModeSettings( child );
//		KProtocolManager::reparseConfiguration();
	}
	delete settingsDialog;
}
//-----------------------------------------------
void KBear::setDialogSettings( ViewSettingsWidget* w, MixedSettingsWidget* m, ChildFrameModeSettings* c ){
	myConfig->setGroup("View Settings");
	bool viewType = myConfig->readBoolEntry("Show DetailView", true);
	w->p_detailedViewButton->setChecked( viewType );
	w->p_iconViewButton->setChecked( ! viewType );
	w->p_treeViewCheckBox->setChecked( myConfig->readBoolEntry("Show TreeView", true) );
	w->p_transferViewCheckBox->setChecked( transferViewToggleAction->isChecked() );
	w->p_toolBarCheckBox->setChecked( toolBarToggleAction->isChecked() );
	w->p_statusBarCheckBox->setChecked( statusBarToggleAction->isChecked() );
	w->p_taskBarCheckBox->setChecked( taskBarToggleAction->isChecked() );
	
	myConfig->setGroup("View Options");
	if( myConfig->readBoolEntry( "TopLevel Mode", false) )
		w->p_topLevelRadioButton->setChecked( true );
	else
		w->p_childFrameRadioButton->setChecked( true );
	w->p_rememberPosCheckBox->setChecked( b_rememberChildPositions );
	c->setDefaultChildFrameMode( defaultChildFrameMode );
	c->p_useAutoChildFrameMode->setChecked( b_autoChildFrameMode );
	
	myConfig->setGroup("General Options");
	if( myConfig->readBoolEntry( "First Run", true) )
		w->p_localFileSysCheckBox->setChecked( true );
	else
		w->p_localFileSysCheckBox->setChecked( localFileSysToggleAction->isChecked() );
	w->p_runSettingsCheckBox->setChecked( myConfig->readBoolEntry( "Run Time Settings", true) );
	m->p_confirmExitCheckBox->setChecked( myConfig->readBoolEntry( "Confirm On Exit", true) );
	m->p_runTipCheckBox->setChecked( myConfig->readBoolEntry( "Run Tip Of Today", true) );
	m->p_queueTransferCheckBox->setChecked( b_queueTransfers );
	m->setDefaultWebPage( IDS_STARTPAGE );
	m->setDefaultEmail( str_emailDefault );
#warning FIXME 	m->autoResumeCheckBox()->setChecked( KProtocolManager::autoResume() ) as soon as kdelibs are changed
	m->p_autoResumeCheckBox->setChecked( KProtocolManager::autoResume() );
#warning FIXME 	m->partExtensionCheckBox()->setChecked( KProtocolManager::markPartial() ) as soon as kdelibs are changed
	m->p_partExtensionCheckBox->setChecked( ! KProtocolManager::markPartial() );
	w->slotViewSelect();
}
//-----------------------------------------------
void KBear::slotApplySettings(){
	switch( settingsDialog->activePageIndex() ) {
		case 0:
			changeViewSettings( settingsDialog->viewSettingsWidget() ); break;
		case 1:
			changeChildFrameModeSettings( settingsDialog->childFrameModeSettings() ); break;
		case 2:
			changeMixedSettings( settingsDialog->mixedSettingsWidget() ); break;
	}
}
//-----------------------------------------------
/** No descriptions */
void KBear::changeViewSettings( ViewSettingsWidget* w ){
													
	if( w->p_transferViewCheckBox->isChecked() != transferViewToggleAction->isChecked() )
		transferViewToggleAction->activate();
	if( w->p_toolBarCheckBox->isChecked() != toolBarToggleAction->isChecked() )
		toolBarToggleAction->activate();
	if( w->p_statusBarCheckBox->isChecked() != statusBarToggleAction->isChecked() )
		statusBarToggleAction->activate();
	if( w->p_taskBarCheckBox->isChecked() != taskBarToggleAction->isChecked() )
		taskBarToggleAction->activate();
	if( w->p_localFileSysCheckBox->isChecked() != localFileSysToggleAction->isChecked() )
		localFileSysToggleAction->activate();
	
	myConfig->setGroup("View Options");
	bool topLevel = w->p_topLevelRadioButton->isChecked();
	myConfig->writeEntry( "TopLevel Mode", topLevel );
	b_rememberChildPositions = w->p_rememberPosCheckBox->isChecked();
	myConfig->writeEntry( "Remember Child Positions", b_rememberChildPositions );
	
	myConfig->setGroup("General Options");
	myConfig->writeEntry( "Run Time Settings", w->p_runSettingsCheckBox->isChecked() );
// emit the changes
	emit viewSettingsChanged( w->p_detailedViewButton->isChecked(),
													w->p_iconViewButton->isChecked(),
													w->p_treeViewCheckBox->isChecked() );

	if( topLevel )
		switchToToplevelMode();
	else
		switchToChildframeMode();

}
//-----------------------------------------------
/** No descriptions */
void KBear::changeMixedSettings( MixedSettingsWidget* m ){
	myConfig->setGroup("General Options");
	myConfig->writeEntry( "Confirm On Exit", m->p_confirmExitCheckBox->isChecked() );
	b_queueTransfers = m->p_queueTransferCheckBox->isChecked();
	myConfig->writeEntry( "Run Tip Of Today", m->p_runTipCheckBox->isChecked() );

#warning FIXME 	KProtocolManager::setAutoResume as soon as kdelibs are changed
	KProtocolManager::setAutoResume( m->p_autoResumeCheckBox->isChecked() );
#warning FIXME 	KProtocolManager::setMarkPartial as soon as kdelibs are changed
	KProtocolManager::setMarkPartial( ! m->p_partExtensionCheckBox->isChecked() );
	IDS_STARTPAGE = m->defaultWebPage();
	myConfig->writeEntry( "Start Page", IDS_STARTPAGE );
	str_emailDefault = m->defaultEmail();
	myConfig->writeEntry( "Default Email", str_emailDefault );
}
//-----------------------------------------------
/** No descriptions */
void KBear::changeChildFrameModeSettings( ChildFrameModeSettings* c ){
	myConfig->setGroup("View Options");
	defaultChildFrameMode = c->getDefaultChildFrameMode();
	currentChildFrameMode = defaultChildFrameMode;
	b_autoChildFrameMode = c->p_useAutoChildFrameMode->isChecked();
	myConfig->writeEntry( "Use Auto ChildFrame Mode", b_autoChildFrameMode );
	myConfig->writeEntry( "ChildFrame Mode", defaultChildFrameMode );
}
//-----------------------------------------------
void KBear::startTransfer( KBearFtpView* view, KURL::List& urlList, bool move ){
	KURL dest = view->getCurrentURL();
	for ( KURL::List::Iterator it = urlList.begin(); it != urlList.end(); ++it ) {
		
		if( b_queueTransfers && (it != urlList.begin() || transferView->childCount()>0)) {
			KBearTransferQueueItem* qItem= new KBearTransferQueueItem;
			qItem->move =  move;
			qItem->source =  (*it);
			qItem->dest =  dest;
			qItem->host =  urlList.first().host();
			transferQueue.enqueue( /*(const KBearTransferQueueItem*)*/qItem );
		}
		else {
			KIO::Job* transferJob = activateTransfer( (*it), dest, urlList.first().host(), move );
			// only call rereaddir() on ftp sites, on local filesys KDirWatch takes care of updating the view
			if( view->getCurrentURL().protocol() =="ftp" )
				connect( (KIO::Job*)transferJob, SIGNAL( result( KIO::Job*)),
								view->myOperator(), SLOT( rereadDir()));

		}
	}
}
//-----------------------------------------------
KIO::Job* KBear::activateTransfer( KURL source, KURL dest, QString host, bool move ) {
	KIO::CopyJob* transferJob = 0;
	if( move ) {
		transferJob = KIO::move( source, dest, false );
		connect( (KIO::Job*)transferJob, SIGNAL( result( KIO::Job*)),
								this, SLOT( slotDeleteItem( KIO::Job* ) ));
		urlDeleteMap.insert( transferJob, source );
	}
	else
		transferJob = KIO::copy( source, dest, false );

	KBearTransferViewItem* item = new KBearTransferViewItem( transferJob, transferView, host, move );
	connect( item, SIGNAL( finished()), this, SLOT( slotStartNextTransfer() ));

	return transferJob;
}
//-----------------------------------------------
void KBear::slotDeleteItem( KIO::Job* job ) {
	QMap< KIO::Job*, KURL>::Iterator urlIter = urlDeleteMap.find( job );
	emit deleteItem( (*urlIter) );
	urlDeleteMap.remove( job );
}
//-----------------------------------------------
void KBear::slotStartNextTransfer(){
	if( b_queueTransfers && transferQueue.count() > 0 ) {
		KBearTransferQueueItem* qItem = transferQueue.dequeue();
		//start next pending transfer
		activateTransfer( qItem->source, qItem->dest, qItem->host, qItem->move );
		delete qItem;
	}
}
//-----------------------------------------------
void KBear::setupActions(){
	myActionCollection = new KActionCollection( this, "KBearActionCollection" );
	myActionCollection->setInstance( KGlobal::instance() );
	myActionCollection->setHighlightingEnabled( true );
	// first setup the actions
	cutAction = KStdAction::cut( this, SLOT( slotCut() ), myActionCollection, "cut" );
	copyAction = KStdAction::copy( this, SLOT( slotCopy() ), myActionCollection, "copy" );
	pasteAction = KStdAction::paste( this, SLOT( slotPaste() ), myActionCollection, "paste" );
	pasteAction->setEnabled( false );
	findAction = KStdAction::find( this, SLOT( slotFind() ), myActionCollection, "find" );
 	selectAllAction = KStdAction::selectAll ( this, SLOT( slotSelectAll() ), myActionCollection , "select all" );	
	clearSelectionAction = new KAction( i18n("&Clear selection"),0,
						this, SLOT( slotClearSelection() ), myActionCollection, "clear selection" );
	invertSelectionAction = new KAction( i18n("&Invert selection"),0,
						this, SLOT( slotInvertSelection() ), myActionCollection, "invert selection" );
	
	actionSeparator = new KActionSeparator( myActionCollection, "separator" );
	
	quickConnectAction = new KAction( i18n("&Quick Connect"),
						"connect_creating", KStdAccel::key( KStdAccel::New ),
						this, SLOT( slotFtpQuickConnect() ), myActionCollection, "quick connect" );

	disConnectAction = new KAction( i18n("&Close Connection"),
						"connect_no", KStdAccel::key( KStdAccel::Close ),
						this, SLOT( slotFtpDisconnect() ), myActionCollection, "close connection" );

	siteManagerAction = new KAction( i18n("&Open Sitemanager"),
						"contents", KStdAccel::key( KStdAccel::Open ),
						 this, SLOT( slotFtpSiteManager() ), myActionCollection, "sitemanager" );

	clearRecentAction = new KAction( i18n("&Clear Recent..."), 0,
						this, SLOT( slotFtpClearRecent() ), myActionCollection, "clear recent" );

	quitAction = KStdAction::quit( this, SLOT( slotFtpQuit() ), myActionCollection, "quit" );

	toolBarToggleAction = KStdAction::showToolbar ( this, SLOT( slotViewToolBar() ), myActionCollection, "toggle toolbar" );

	statusBarToggleAction = KStdAction::showStatusbar ( this, SLOT( slotViewStatusBar() ), myActionCollection, "toggle statusbar" );
	
	taskBarToggleAction = new KToggleAction( i18n("T&askbar"), 0,
						this, SLOT( slotViewTaskBar() ), myActionCollection, "toggle taskbar" );

	transferViewToggleAction = new KToggleAction( i18n("Transfer &View"), 0,
						this, SLOT( slotViewTransferWindow() ), myActionCollection, "toggle transferview" );

	localFileSysToggleAction = new KToggleAction( i18n("Your &Local Filesystem"), 0,
						this, SLOT( slotLocalFileSys() ), myActionCollection, "toggle local" );

	settingsAction = new KAction( i18n("&General Settings"), 0,
						this, SLOT( slotSettings() ), myActionCollection, "settings" );

	runTipAction = new KAction( i18n("Run &Tip of today"), "ktip", KAccel::stringToKey("F10"),
						this, SLOT( slotRunTipOfToday() ), myActionCollection, "tip of today" );

	wizardAction = new KAction( i18n("Run &Wizard..."), "wizard",0,
						this, SLOT( slotWelcome() ), myActionCollection, "wizard" );
	
	emailAction = new KAction( i18n("Open KMail"),
						"kmail",0, this, SLOT( slotOpenKMail() ), myActionCollection, "kmail" );
	
	browserAction = new KAction( i18n("Open Konqueror Web Browser"),
						"konqueror",0, this, SLOT( slotOpenBrowser() ), myActionCollection, "konqueror" );
	
	helpAction = KStdAction::help( this, SLOT( slotShowHelp() ), myActionCollection, "help" );

	whatsThisAction = KStdAction::whatsThis( this, SLOT( slotWhatsThis() ), myActionCollection, "whats this" );

// setup tooltips
	quickConnectAction->setToolTip ( i18n("Open a new connection") );
	disConnectAction->setToolTip ( i18n("Close current connection") );
	siteManagerAction->setToolTip ( i18n("Open the Sitemanager") );

// setup status text
	quickConnectAction->setStatusText( i18n("Open a new connection") );
	disConnectAction->setStatusText( i18n("Close current connection") );
	siteManagerAction->setStatusText( i18n("Open the Sitemanager") );
//	helpAction->setStatusText( i18n("Open the Sitemanager") );
// setup whats this
	quickConnectAction->setWhatsThis( i18n("Click this button to open a new connection.\n\n"
                  "You can also select the Quick Connect command from the FTP menu.") );
	disConnectAction->setWhatsThis( i18n("Click this button to close current connection.\n\n"
                  "You can also select the Close Connection command from the FTP menu.") );
	siteManagerAction->setWhatsThis( i18n("Click this button to open the Sitemanager.\n\n"
                  "You can also select the Open Sitemanager command from the FTP menu.") );
	runTipAction->setWhatsThis( i18n("Click this button to run the Tip of today dialog.\n\n"
                  "You can also select the Run Tip of today command from the Settings menu.") );
	emailAction->setWhatsThis( i18n("Click this button to open KMail.") );
	browserAction->setWhatsThis( i18n("Click this button to open Konqueror Web Browser.") );

    // insert them into the actionCollection
	myActionCollection->insert( cutAction );
	myActionCollection->insert( copyAction );
	myActionCollection->insert( pasteAction );
	myActionCollection->insert( findAction );
	myActionCollection->insert( selectAllAction );
	myActionCollection->insert( clearSelectionAction );
	myActionCollection->insert( invertSelectionAction );
	myActionCollection->insert( actionSeparator );
	myActionCollection->insert( quickConnectAction );
	myActionCollection->insert( disConnectAction );
	myActionCollection->insert( siteManagerAction );
	myActionCollection->insert( clearRecentAction );
	myActionCollection->insert( settingsAction );
	myActionCollection->insert( runTipAction );
	myActionCollection->insert( wizardAction );
	myActionCollection->insert( emailAction );
	myActionCollection->insert( browserAction );
	myActionCollection->insert( toolBarToggleAction );
	myActionCollection->insert( statusBarToggleAction );
	myActionCollection->insert( taskBarToggleAction );
	myActionCollection->insert( transferViewToggleAction );
	myActionCollection->insert( localFileSysToggleAction );
}
//-----------------------------------------------
void KBear::slotWhatsThis(){
	QWhatsThis::enterWhatsThisMode();
}
//-----------------------------------------------
QPopupMenu* KBear::taskBarPopup(QextMdiChildView* pWnd,bool bIncludeWindowPopup ) {
	QPopupMenu* menu = QextMdiMainFrm::taskBarPopup( pWnd, bIncludeWindowPopup );
	((KBearFtpView*)pWnd)->myOperator()->actionCollection()->action("separator")->plug( menu );
	((KBearFtpView*)pWnd)->myOperator()->actionCollection()->action("popupMenu")->plug( menu );
	return menu;
	bIncludeWindowPopup = false; // dummy!, only to avoid "unused parameter"
}
//-----------------------------------------------
bool KBear::detailedViewIsSet() const {
	return myConfig->readBoolEntry("Show DetailView", true);
}
//-----------------------------------------------
void KBear::slotSelectAll(){
	if( isInTopLevelMode() && ! p_activeView ) {
		showActionDisabledInTopLevelMode();
		return;
	}
	KBearDirOperator* dirOp = ((KBearFtpView*)p_activeView)->myOperator();
	((KFileView*)dirOp->view())->selectAll();
	if( isInTopLevelMode() )
		p_activeView = 0L;
}
//-----------------------------------------------
void KBear::slotClearSelection(){
	if( isInTopLevelMode() && ! p_activeView ) {
		showActionDisabledInTopLevelMode();
		return;
	}
	KBearDirOperator* dirOp = ((KBearFtpView*)p_activeView)->myOperator();
	((KFileView*)dirOp->view())->clearSelection();
	if( isInTopLevelMode() )
		p_activeView = 0L;
}
//-----------------------------------------------
void KBear::slotInvertSelection(){
	if( isInTopLevelMode() && ! p_activeView ) {
		showActionDisabledInTopLevelMode();
		return;
	}
	KBearDirOperator* dirOp = ((KBearFtpView*)p_activeView)->myOperator();
	((KFileView*)dirOp->view())->invertSelection();
	if( isInTopLevelMode() )
		p_activeView = 0L;
}
//-----------------------------------------------
void KBear::slotOpenBrowser() {
	QStringList args;
	args.append("openURL");
	args.append( IDS_STARTPAGE );
	KApplication::kApplication()->kdeinitExec( i18n("kfmclient"), args );
}
//-----------------------------------------------
void KBear::slotOpenKMail() {
	KApplication::kApplication()->kdeinitExec( i18n("kmail") );
}
//-----------------------------------------------
void KBear::slotSaveToSiteManager( SiteInfo& siteInfo ) {
	KBearSiteManager* mySiteManager = new KBearSiteManager( 0,"SiteManager");
	mySiteManager->saveSite( siteInfo );
	delete mySiteManager;
}
//-----------------------------------------------
void KBear::setChildFrameMode( unsigned int mode ){
	switch( mode ) {
		case ChildFrameModeSettings::Cascade:
			cascadeWindows();break;
		case ChildFrameModeSettings::CascadeMaximized:
			cascadeMaximized();break;
		case ChildFrameModeSettings::ExpandVertical:
			expandVertical();break;
		case ChildFrameModeSettings::ExpandHorizontal:
			expandHorizontal();break;
		case ChildFrameModeSettings::AnodinesTile:
			tileAnodine();break;
		case ChildFrameModeSettings::PragmasTile:
			tilePragma();break;
		case ChildFrameModeSettings::TileVertically:
			tileVertically();break;
		case ChildFrameModeSettings::None:
			break;
	}
}
//-----------------------------------------------
void KBear::cascadeWindows() {
	QextMdiMainFrm::cascadeWindows();
	currentChildFrameMode = ChildFrameModeSettings::Cascade;
}
//-----------------------------------------------
void KBear::cascadeMaximized() {
	QextMdiMainFrm::cascadeMaximized();
	currentChildFrameMode = ChildFrameModeSettings::CascadeMaximized;
}
//-----------------------------------------------
void KBear::expandVertical() {
	QextMdiMainFrm::expandVertical();
	currentChildFrameMode = ChildFrameModeSettings::ExpandVertical;
}
//-----------------------------------------------
void KBear::expandHorizontal() {
	QextMdiMainFrm::expandHorizontal();
	currentChildFrameMode = ChildFrameModeSettings::ExpandHorizontal;
}
//-----------------------------------------------
void KBear::tilePragma() {
	QextMdiMainFrm::tilePragma();
	currentChildFrameMode = ChildFrameModeSettings::PragmasTile;
}
//-----------------------------------------------
void KBear::tileAnodine() {
	QextMdiMainFrm::tileAnodine();
	currentChildFrameMode = ChildFrameModeSettings::AnodinesTile;
}
//-----------------------------------------------
void KBear::tileVertically() {
	QextMdiMainFrm::tileVertically();
	currentChildFrameMode = ChildFrameModeSettings::TileVertically;
}
//-----------------------------------------------
void KBear::setChildViewPositions(){
	if( ! childStartPositions.count() )
		return;
	QValueList<int>::Iterator iter( childStartPositions.begin() );
	QValueList<int>::Iterator stopIter( childStartPositions.end() );
	for(QextMdiChildView* view = m_pWinList->first(); view!=0; view=m_pWinList->next() ) {
		if( iter != stopIter ) {
			int x = *iter++;
			int y = *iter++;
			int width = *iter++;
			int height = *iter++;
			view->setGeometry( x, y, width, height );
		}
		else
			view->setGeometry( 0, 0, 400, 300 );
	}
}
//-----------------------------------------------
void KBear::saveChildViewPositions(){
	if( ! b_rememberChildPositions || ! m_bTopLevelMode )
		return;
	QValueList<int>::Iterator iter( childStartPositions.begin() );
	QValueList<int>::Iterator stopIter( childStartPositions.end() );
	for(QextMdiChildView* view = m_pWinList->first(); view!=0; view=m_pWinList->next() ) {
		if( iter != stopIter ) {
			*iter = view->x();
			++iter;
			*iter = view->y();
			++iter;
			*iter = view->width();
			++iter;
			*iter = view->height();
			++iter;
		}
		else {
			childStartPositions.append( view->x() );	
			childStartPositions.append( view->y() );	
			childStartPositions.append( view->width() );	
			childStartPositions.append( view->height() );
		}
	}
	myConfig->setGroup("General Options");
	if( ! myConfig->readBoolEntry( "Run Time Settings", true ) )
		return;
	myConfig->setGroup("View Options");
	myConfig->writeEntry( "Child Positions", childStartPositions );
}
//-----------------------------------------------
/** for internal use */
void KBear::slotSetActiveView( QextMdiChildView* view ) {
	p_activeView = view;
}
//-----------------------------------------------
/** for internal use */
void KBear::slotClearActiveView() {
	p_activeView = 0L;
}
//-----------------------------------------------
/** Runs the tip of today dialog */
void KBear::slotRunTipOfToday(){
	bool runOnStart = myConfig->readBoolEntry( "Run Tip Of Today", true);
	KBearTipOfToday tipOfToday( this, "KBearTipOfToday");
	tipOfToday.runTipCheckBox->setChecked( runOnStart );
	tipOfToday.run();
	myConfig->setGroup("General Options");
	myConfig->writeEntry( "Run Tip Of Today", tipOfToday.runTipOfToday() );
}
//-----------------------------------------------
/** No descriptions */
void KBear::showActionDisabledInTopLevelMode() {
	KMessageBox::information ( this, i18n("When working in Toplevel mode you can only use this action\n"
													"by rightclicking in the view where you want the action to be performed."),
													i18n("Action disabled") );
}
//-----------------------------------------------
