#include <qtabdialog.h>
#include <qradiobutton.h>

#include "kvideodb.h"
#include "movies.h"

#ifndef SEARCH

#define SEARCH

class searchWindow : public QDialog
{
  Q_OBJECT
 public:
  searchWindow(KVideoDB *);
  ~searchWindow(){};

  KVideoDB *papa;

  QTabDialog   *tDialog;
  QWidget      *page1;
  QWidget      *page2;

  // first page

  QComboBox    *search1;
  QComboBox    *search1E;
  QComboBox    *search2;
  QComboBox    *search2E;

  QButtonGroup *andOr;
  QButtonGroup *leeqgr1;
  QButtonGroup *leeqgr2;

  QRadioButton *and;
  QRadioButton *or;
  
  QRadioButton *l1;
  QPushButton  *e1;
  QRadioButton *g1;
  QRadioButton *l2;
  QPushButton  *e2;
  QRadioButton *g2;
  
  // second page

  QComboBox    *index;
  QComboBox    *category;
  QComboBox    *sound;
  QComboBox    *speed;
  QComboBox    *fsk;
  QComboBox    *source;
  QComboBox    *videonorm;
  QComboBox    *rating;
  
  QPushButton  *bw;
  QPushButton  *commercial;
  QPushButton  *widescreen;
  QPushButton  *omu;
  QPushButton  *caption;
  
  QPushButton  *onButton[13];
  
  // Buttons

  QPushButton  *randomB;
  QPushButton  *searchB;
  
 public slots:
  void slotSearch();
  void slotCancel();
  void slotRandom();
  void slotReset();
 private slots:
  void slotS1(int);
  void slotS2(int);
  void slotS1E(int);
  void slotS2E(int);
  void slotoB0Clicked();
  void slotoB1Clicked();
  void slotoB2Clicked();
  void slotoB3Clicked();
  void slotoB4Clicked();
  void slotoB5Clicked();
  void slotoB6Clicked();
  void slotoB7Clicked();
  void slotoB8Clicked();
  void slotoB9Clicked();
  void slotoB10Clicked();
  void slotoB11Clicked();
  void slotoB12Clicked();
  void slotBwClicked();
  void slotComClicked();
  void slotWideClicked();
  void slotOmuClicked();
  void slotCapClicked();
  
 protected:
  bool searchFct(Movie *);
};

#endif
