#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <kcombo.h>
#include <kmsgbox.h>

#include <qfile.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qframe.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qstrlist.h>
#include <qdatetime.h>

#include "bstar.h"
#include "search.h"
#include "options.h"
#include "hilfsrout.h"

extern Config config;
extern BStarTree *anchor;
int relString1=0;
int relString2=0;

//////////////////////////////////////////////////////////////////
//                                                              //
//                  Constructor for the Search-Window           //
//                                                              //
//////////////////////////////////////////////////////////////////

searchWindow::searchWindow(KVideoDB *parent):QDialog(parent,0,TRUE){
  
  setFixedSize(600,340);
  setCaption(i18n("Search the Database"));

  // build a tabDialog
  tDialog = new QTabDialog(this,"topDialog");
  tDialog->setGeometry(0,0,600,340);
  tDialog->setCancelButton(i18n("Cancel"));
  tDialog->setDefaultButton(i18n("&Default"));
//   tDialog->setApplyButton("invis");
  tDialog->setOkButton(i18n("&Random"));
//   tDialog->setStyle(MotifStyle);
  
  // connect it to some slots
  connect(tDialog,SIGNAL(cancelButtonPressed()),SLOT(slotCancel()));
  connect(tDialog,SIGNAL(defaultButtonPressed()),SLOT(slotReset()));
  connect(tDialog,SIGNAL(applyButtonPressed()),SLOT(slotRandom()));
  
  // build a random- and a search-button
//   randomB = new QPushButton(i18n("&Random"),this,"rB");
//   randomB->setGeometry(441,308,73,26);
//   randomB->setAccel(ALT+Key_R);
//   connect(randomB,SIGNAL(clicked()), SLOT(slotRandom()));
  
  searchB = new QPushButton(i18n("&Search"),this,"sB");
  searchB->setGeometry(7,308,73,27);
  searchB->setAccel(ALT+Key_S);
  searchB->setDefault(TRUE);
  connect(searchB,SIGNAL(clicked()), SLOT(slotSearch()));
  
  // build the two pages, that should form the tabDialog
  page1 = new QWidget(tDialog,"p1");
  page2 = new QWidget(tDialog,"p2");
  
  // first page with two readonly comboboxes, two read/write comboboxes
  // two less/equal/greater buttongroups and a and/or buttongroup
  search1  = new QComboBox(FALSE,page1,"s1");
  search1->setGeometry(15,50,200,25);
  search1->insertItem(i18n("None"));
  search1->insertItem(i18n("Title"));
  search1->insertItem(i18n("Original"));
  search1->insertItem(i18n("Cassette"));
  search1->insertItem(i18n("Start"));
  search1->insertItem(i18n("Length"));
  search1->insertItem(i18n("orig. Length"));
  search1->insertItem(i18n("Country"));
  search1->insertItem(i18n("Year"));
  search1->insertItem(i18n("Date of Recording"));
  search1->insertItem(i18n("Director"));
  search1->insertItem(i18n("Producer"));
  search1->insertItem(i18n("Cast"));
  connect(search1,SIGNAL(activated(int)),SLOT(slotS1(int)));
  
  search1E = new QComboBox(TRUE,page1,"s1B");
  search1E->setGeometry(230,50,200,25);
  search1E->setEnabled(FALSE);
  search1E->insertItem("");
  search1E->insertStrList(&(config.searchHistory1));
  
  search2  = new QComboBox(FALSE,page1,"s2");
  search2->setGeometry(15,130,200,25);
  search2->insertItem(i18n("None"));
  search2->insertItem(i18n("Title"));
  search2->insertItem(i18n("Original"));
  search2->insertItem(i18n("Cassette"));
  search2->insertItem(i18n("Start"));
  search2->insertItem(i18n("Length"));
  search2->insertItem(i18n("orig. Length"));
  search2->insertItem(i18n("Country"));
  search2->insertItem(i18n("Year"));
  search2->insertItem(i18n("Date of Recording"));
  search2->insertItem(i18n("Director"));
  search2->insertItem(i18n("Producer"));
  search2->insertItem(i18n("Cast"));
  connect(search2,SIGNAL(activated(int)),SLOT(slotS2(int)));

  search2E = new QComboBox(TRUE,page1,"s2B");
  search2E->setGeometry(230,130,200,25);
  search2E->setEnabled(FALSE);
  search2E->insertItem("");
  search2E->insertStrList(&(config.searchHistory2));
  
  andOr = new QButtonGroup(page1);
  andOr->setGeometry(15,88,200,29);
  and = new QRadioButton(i18n("and"),andOr,"and");
  and->setGeometry(10,2,90,25);
  or = new QRadioButton(i18n("or"),andOr,"or");
  or->setGeometry(100,2,90,25);
  andOr->setButton(0);
  
  leeqgr1 = new QButtonGroup(page1);
  leeqgr1->setGeometry(445,50,130,25);

  l1 = new QRadioButton("",leeqgr1,"l1");
  l1->setGeometry(15,3,20,20);
  e1 = new QPushButton("",page1,"e1");
  e1->setGeometry(500,57,12,12);
  e1->setToggleButton(TRUE);
  e1->setOn(TRUE);
  g1 = new QRadioButton("",leeqgr1,"g1");
  g1->setGeometry(95,3,20,20);
  l1->setEnabled(FALSE);
  e1->setEnabled(FALSE);
  g1->setEnabled(FALSE);
  
  leeqgr2 = new QButtonGroup(page1);
  leeqgr2->setGeometry(445,130,130,25);

  l2 = new QRadioButton("",leeqgr2,"l2");
  l2->setGeometry(15,3,20,20);
  e2 = new QPushButton("",page1,"e2");
  e2->setGeometry(500,137,12,12);
  e2->setToggleButton(TRUE);
  e2->setOn(TRUE);
  g2 = new QRadioButton("",leeqgr2,"g2");
  g2->setGeometry(95,3,20,20);
  l2->setEnabled(FALSE);
  e2->setEnabled(FALSE);
  g2->setEnabled(FALSE);

  QLabel *less = new QLabel(i18n("less"),page1,"le_l",0);
  less->setGeometry(445,20,40,25);
  less->setAlignment(AlignCenter);
  QLabel *equal = new QLabel(i18n("equal"),page1,"eq_l",0);
  equal->setGeometry(485,20,40,25);
  equal->setAlignment(AlignCenter);
  QLabel *greater = new QLabel(i18n("greater"),page1,"gr_l",0);
  greater->setGeometry(525,20,40,25);
  greater->setAlignment(AlignCenter);

  // second page with 8 readonly comboboxes, 8 labels, 
  // 5 togglebuttons for the flags and 13 togglebuttons to 
  // activate/deactivate the other widgets
  QFrame *gFrame = new QFrame(page2,"");
  gFrame->setGeometry(293,10,2,150);
  gFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
  
  // first row of comboboxes
  QLabel *indexL = new QLabel(i18n("Index:"),page2,"i_l",0);
  indexL->setGeometry(15,20,100,25);
  index  = new QComboBox(FALSE,page2,"index");
  index->setGeometry(115,20,140,25);
  index->insertItem(i18n("<Unknown>"),-1);
  index->insertItem(i18n("First Movie"),-1);
  index->insertItem(i18n("Second Movie"),-1);
  index->insertItem(i18n("Third Movie"),-1);
  index->insertItem(i18n("Fourth Movie"),-1);
  index->insertItem(i18n("Fifth Movie"),-1);
  index->insertItem(i18n("Sixth Movie"),-1);
  onButton[0] = new QPushButton("",page2,"oB0");
  onButton[0]->setGeometry(270,28,10,10);
  onButton[0]->setToggleButton(TRUE);
  QLabel *catL = new QLabel(i18n("Category:"),page2,"c_l",0);
  catL->setGeometry(15,55,100,25);
  category = new QComboBox(FALSE,page2,"cat");
  category->setGeometry(115,55,140,25);
  category->insertStrList(&(config.category));
  onButton[1] = new QPushButton("",page2,"oB1");
  onButton[1]->setGeometry(270,63,10,10);
  onButton[1]->setToggleButton(TRUE);
  QLabel *soundL = new QLabel(i18n("Sound:"),page2,"snd_l",0);
  soundL->setGeometry(15,90,100,25);
  sound = new QComboBox(FALSE,page2,"snd");
  sound->setGeometry(115,90,140,25);
  sound->insertStrList(&(config.sound));
  onButton[2] = new QPushButton("",page2,"oB2");
  onButton[2]->setGeometry(270,98,10,10);
  onButton[2]->setToggleButton(TRUE);
  QLabel *speedL = new QLabel(i18n("Speed:"),page2,"spd_l",0);
  speedL->setGeometry(15,125,100,25);
  speed = new QComboBox(FALSE,page2,"spd");
  speed->setGeometry(115,125,140,25);
  speed->insertStrList(&(config.speed));
  onButton[3] = new QPushButton("",page2,"oB3");
  onButton[3]->setGeometry(270,133,10,10);
  onButton[3]->setToggleButton(TRUE);

  // second row of comboboxes
  QLabel *fskL = new QLabel(i18n("Rated as:"),page2,"fsk_l",0);
  fskL->setGeometry(305,20,100,25);
  fsk  = new QComboBox(FALSE,page2,"fsk");
  fsk->setGeometry(405,20,140,25);
  fsk->insertStrList(&(config.fsk));
  onButton[4] = new QPushButton("",page2,"oB4");
  onButton[4]->setGeometry(560,28,10,10);
  onButton[4]->setToggleButton(TRUE);
  QLabel *srcL = new QLabel(i18n("Recorded from:"),page2,"src_l",0);
  srcL->setGeometry(305,55,100,25);
  source = new QComboBox(FALSE,page2,"src");
  source->setGeometry(405,55,140,25);
  source->insertStrList(&(config.source));
  onButton[5] = new QPushButton("",page2,"oB5");
  onButton[5]->setGeometry(560,63,10,10);
  onButton[5]->setToggleButton(TRUE);
  QLabel *normL = new QLabel(i18n("Videonorm:"),page2,"norm_l",0);
  normL->setGeometry(305,90,100,25);
  videonorm = new QComboBox(FALSE,page2,"norm");
  videonorm->setGeometry(405,90,140,25);
  videonorm->insertStrList(&(config.videonorm));
  onButton[6] = new QPushButton("",page2,"oB6");
  onButton[6]->setGeometry(560,98,10,10);
  onButton[6]->setToggleButton(TRUE);
  QLabel *rateL = new QLabel(i18n("Rating:"),page2,"rate_l",0);
  rateL->setGeometry(305,125,100,25);
  rating = new QComboBox(FALSE,page2,"rating");
  rating->setGeometry(405,125,140,25);
  QString rate = i18n("Rating");
  rating->insertItem(rate + ":  0");
  rating->insertItem(rate + ":  1");
  rating->insertItem(rate + ":  2");
  rating->insertItem(rate + ":  3");
  rating->insertItem(rate + ":  4");
  rating->insertItem(rate + ":  5");
  rating->insertItem(rate + ":  6");
  rating->insertItem(rate + ":  7");
  rating->insertItem(rate + ":  8");
  rating->insertItem(rate + ":  9");
  rating->insertItem(rate + ": 10");
  
  onButton[7] = new QPushButton("",page2,"oB7");
  onButton[7]->setGeometry(560,133,10,10);
  onButton[7]->setToggleButton(TRUE);

  // horizontal separator
  QFrame *hFrame = new QFrame(page2,"");
  hFrame->setGeometry(12,170,560,2);
  hFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
  
  // 5 toggle buttons for the flags
  bw = new QPushButton(page2,"colore");
  bw->setToggleButton(TRUE);
  bw->setGeometry(35,190,25,25);
  bw->setPixmap(QPixmap::QPixmap(picPath(i18n("color.xpm"))));
  connect(bw,SIGNAL(clicked()),SLOT(slotBwClicked()));
  onButton[8] = new QPushButton(page2,"oB8");
  onButton[8]->setGeometry(42,225,10,10);
  onButton[8]->setToggleButton(TRUE);
  commercial= new QPushButton(page2,"com");
  commercial->setToggleButton(TRUE);
  commercial->setGeometry(158,190,25,25);
  commercial->setPixmap(QPixmap::QPixmap(picPath("nocommercial.xpm")));
  connect(commercial,SIGNAL(clicked()),SLOT(slotComClicked()));
  onButton[9] = new QPushButton(page2,"oB9");
  onButton[9]->setGeometry(165,225,10,10);
  onButton[9]->setToggleButton(TRUE);
  widescreen = new QPushButton(page2,"ws");
  widescreen->setToggleButton(TRUE);
  widescreen->setGeometry(281,190,25,25);
  widescreen->setPixmap(QPixmap::QPixmap(picPath("smallscreen.xpm")));
  connect(widescreen,SIGNAL(clicked()),SLOT(slotWideClicked()));
  onButton[10] = new QPushButton(page2,"oB10");
  onButton[10]->setGeometry(288,225,10,10);
  onButton[10]->setToggleButton(TRUE);
  omu = new QPushButton(page2,"omu");
  omu->setToggleButton(TRUE);
  omu->setGeometry(407,190,25,25);
  omu->setPixmap(QPixmap::QPixmap(picPath("noomu.xpm")));
  connect(omu,SIGNAL(clicked()),SLOT(slotOmuClicked()));
  onButton[11] = new QPushButton(page2,"oB11");
  onButton[11]->setGeometry(414,225,10,10);
  onButton[11]->setToggleButton(TRUE);
  caption = new QPushButton(page2,"caption");
  caption->setToggleButton(TRUE);
  caption->setGeometry(520,190,25,25);
  caption->setPixmap(QPixmap::QPixmap(picPath("nocaption.xpm")));
  connect(caption,SIGNAL(clicked()),SLOT(slotCapClicked()));
  onButton[12] = new QPushButton(page2,"oB12");
  onButton[12]->setGeometry(527,225,10,10);
  onButton[12]->setToggleButton(TRUE);

  // disable all comboboxes and flag-buttons
  index->setEnabled(FALSE);
  category->setEnabled(FALSE);
  sound->setEnabled(FALSE);
  speed->setEnabled(FALSE);
  fsk->setEnabled(FALSE);
  source->setEnabled(FALSE);
  videonorm->setEnabled(FALSE);
  rating->setEnabled(FALSE);
  bw->setEnabled(FALSE);
  commercial->setEnabled(FALSE);
  widescreen->setEnabled(FALSE);
  omu->setEnabled(FALSE);
  caption->setEnabled(FALSE);
  
  // connect the onButtons to slots
  connect(onButton[0],SIGNAL(clicked()),SLOT(slotoB0Clicked()));
  connect(onButton[1],SIGNAL(clicked()),SLOT(slotoB1Clicked()));
  connect(onButton[2],SIGNAL(clicked()),SLOT(slotoB2Clicked()));
  connect(onButton[3],SIGNAL(clicked()),SLOT(slotoB3Clicked()));
  connect(onButton[4],SIGNAL(clicked()),SLOT(slotoB4Clicked()));
  connect(onButton[5],SIGNAL(clicked()),SLOT(slotoB5Clicked()));
  connect(onButton[6],SIGNAL(clicked()),SLOT(slotoB6Clicked()));
  connect(onButton[7],SIGNAL(clicked()),SLOT(slotoB7Clicked()));
  connect(onButton[8],SIGNAL(clicked()),SLOT(slotoB8Clicked()));
  connect(onButton[9],SIGNAL(clicked()),SLOT(slotoB9Clicked()));
  connect(onButton[10],SIGNAL(clicked()),SLOT(slotoB10Clicked()));
  connect(onButton[11],SIGNAL(clicked()),SLOT(slotoB11Clicked()));
  connect(onButton[12],SIGNAL(clicked()),SLOT(slotoB12Clicked()));

  // add some tooltips
  QToolTip::add(bw,i18n("Check if movie should be in Black & White"));  
  QToolTip::add(commercial,i18n("Check if movie should contain commercials"));  
  QToolTip::add(widescreen,i18n("Check if movie should be in widescreen "));  
  QToolTip::add(omu,i18n("Check if movie should have subtitles"));  
  QToolTip::add(caption,i18n("Check if movie should contain closed captions"));
  for (int i=0; i<13; i++)
    QToolTip::add(onButton[i],i18n("Check to activate the corresponding widget"));  

  // add the two pages to the tabdialog
  tDialog->addTab(page1,i18n("&Search"));
  tDialog->addTab(page2,i18n("&Extended"));

  papa = parent;
}


//////////////////////////////////////////////////////////////////////////
//                                                                      //
//              Slots for the correct behaviour of the window           //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

void searchWindow::slotS1(int line)
{
  if ((line == 4) || (line == 5) || (line == 6) || (line == 8) || (line == 9)){
    search1E->setEnabled(TRUE);
    l1->setEnabled(TRUE);
    e1->setEnabled(TRUE);
    g1->setEnabled(TRUE);
  } else {
    if (line == 0)
      search1E->setEnabled(FALSE);
    else
      search1E->setEnabled(TRUE);
    l1->setChecked(FALSE);
    l1->setEnabled(FALSE);
    e1->setOn(TRUE);
    e1->setEnabled(FALSE);
    g1->setChecked(FALSE);
    g1->setEnabled(FALSE);
  }
}

void searchWindow::slotS2(int line)
{
  if ((line == 4) || (line == 5) || (line == 6) || (line == 8) || (line == 9)){
    search2E->setEnabled(TRUE);
    l2->setEnabled(TRUE);
    e2->setEnabled(TRUE);
    g2->setEnabled(TRUE);
  } else {
    if (line == 0)
      search2E->setEnabled(FALSE);
    else
      search2E->setEnabled(TRUE);
    l2->setChecked(FALSE);
    l2->setEnabled(FALSE);
    e2->setOn(TRUE);
    e2->setEnabled(FALSE);
    g2->setChecked(FALSE);
    g2->setEnabled(FALSE);
  }
}

void searchWindow::slotS1E(int line)
{
}


void searchWindow::slotS2E(int line)
{
}

void searchWindow::slotoB0Clicked()
{
  if (onButton[0]->isOn())
    index->setEnabled(TRUE);
  else
    index->setEnabled(FALSE);
}

void searchWindow::slotoB1Clicked()
{
  if (onButton[1]->isOn())
    category->setEnabled(TRUE);
  else
    category->setEnabled(FALSE);
}

void searchWindow::slotoB2Clicked()
{
  if (onButton[2]->isOn())
    sound->setEnabled(TRUE);
  else
    sound->setEnabled(FALSE);
}

void searchWindow::slotoB3Clicked()
{
  if (onButton[3]->isOn())
    speed->setEnabled(TRUE);
  else
    speed->setEnabled(FALSE);
}

void searchWindow::slotoB4Clicked()
{
  if (onButton[4]->isOn())
    fsk->setEnabled(TRUE);
  else
    fsk->setEnabled(FALSE);
}

void searchWindow::slotoB5Clicked()
{
  if (onButton[5]->isOn())
    source->setEnabled(TRUE);
  else
    source->setEnabled(FALSE);
}

void searchWindow::slotoB6Clicked()
{
  if (onButton[6]->isOn())
    videonorm->setEnabled(TRUE);
  else
    videonorm->setEnabled(FALSE);
}

void searchWindow::slotoB7Clicked()
{
  if (onButton[7]->isOn())
    rating->setEnabled(TRUE);
  else
    rating->setEnabled(FALSE);
}

void searchWindow::slotoB8Clicked()
{
  if (onButton[8]->isOn())
    bw->setEnabled(TRUE);
  else{
    bw->setEnabled(FALSE);
  }
}

void searchWindow::slotoB9Clicked()
{
  if (onButton[9]->isOn())
    commercial->setEnabled(TRUE);
  else{
    commercial->setEnabled(FALSE);
  }
}

void searchWindow::slotoB10Clicked()
{
  if (onButton[10]->isOn())
    widescreen->setEnabled(TRUE);
  else{
    widescreen->setEnabled(FALSE);
  }
}

void searchWindow::slotoB11Clicked()
{
  if (onButton[11]->isOn())
    omu->setEnabled(TRUE);
  else{
    omu->setEnabled(FALSE);
  }
}

void searchWindow::slotoB12Clicked()
{
  if (onButton[12]->isOn())
    caption->setEnabled(TRUE);
  else{
    caption->setEnabled(FALSE);
  }
}

void searchWindow::slotBwClicked()
{
  if (bw->isOn())
    bw->setPixmap(QPixmap::QPixmap(picPath(i18n("bw.xpm"))));
  else
    bw->setPixmap(QPixmap::QPixmap(picPath(i18n("color.xpm"))));
}

void searchWindow::slotComClicked()
{
  if (commercial->isOn())
    commercial->setPixmap(QPixmap::QPixmap(picPath(i18n("commercial.xpm"))));
  else
    commercial->setPixmap(QPixmap::QPixmap(picPath(i18n("nocommercial.xpm"))));
}

void searchWindow::slotWideClicked()
{
  if (widescreen->isOn())
    widescreen->setPixmap(QPixmap::QPixmap(picPath(i18n("widescreen.xpm"))));
  else
    widescreen->setPixmap(QPixmap::QPixmap(picPath(i18n("smallscreen.xpm"))));
}

void searchWindow::slotOmuClicked()
{
  if (omu->isOn())
    omu->setPixmap(QPixmap::QPixmap(picPath(i18n("omu.xpm"))));
  else
    omu->setPixmap(QPixmap::QPixmap(picPath(i18n("noomu.xpm"))));
}

void searchWindow::slotCapClicked()
{
  if (caption->isOn())
    caption->setPixmap(QPixmap::QPixmap(picPath(i18n("caption.xpm"))));
  else
    caption->setPixmap(QPixmap::QPixmap(picPath(i18n("nocaption.xpm"))));
}

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//                 Slots for the case of a pressed button               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

void searchWindow::slotSearch()
{
  QString sStr1="";
  QString sStr2="";
  bool selected=FALSE;
  int andOrFlag=0;
  
  ///////////////////////////////////////////
  //                                       //
  //  read all the data, the user put in   //
  //                                       //
  ///////////////////////////////////////////

  relString1=0;
  relString2=0;
  // first the text part (No. 1)
  // is the read/write-QComboBox enabled?
  // read the content and add it to the config-entry
  // then operate the less/equal/greater-buttongroup
  if (search1E->isEnabled()){
    sStr1 = search1E->currentText();
    if (sStr1.length() > 0){
      selected = TRUE;               // the user has specified sth. to be searched
      if (!config.searchHistory1.contains(sStr1)){
	QStrList listDummy;
	listDummy.clear();
	listDummy.append(sStr1);
	for (unsigned int i=0; i < config.searchHistory1.count(); i++)
	  listDummy.append(config.searchHistory1.at(i));
	config.searchHistory1=listDummy;
	KConfig *kconfig = KApplication::getKApplication()->getConfig();
	kconfig->setGroup("history");
	kconfig->writeEntry("a",config.searchHistory1);
	kconfig->sync();
      }
      if (e1->isEnabled()){
	if (e1->isOn())
	  relString1 += 1;
	if (l1->isOn())
	  relString1 += 2;
	else if (g1->isOn())
	  relString1 += 4;
      }
      else
	relString1 = 1;
    }
  } else
    relString1 = 8;

  // text part (No. 2)
  // (analogous to No. 1)
  if (search2E->isEnabled()){
    sStr2 = search2E->currentText();
    if (sStr2 != ""){
      if (!config.searchHistory2.contains(sStr2)){
	QStrList listDummy;
	listDummy.clear();
	listDummy.append(sStr2);
	for (unsigned int i=0; i < config.searchHistory2.count(); i++)
	  listDummy.append(config.searchHistory2.at(i));
	config.searchHistory2=listDummy;
	KConfig *kconfig = KApplication::getKApplication()->getConfig();
	kconfig->setGroup("history");
	kconfig->writeEntry("b",config.searchHistory2);
	kconfig->sync();
      }
      if (e2->isEnabled()){
	if (e2->isOn())
	  relString2 += 1;
	if (l2->isOn())
	  relString2 += 2;
	else if (g2->isOn())
	  relString2 += 4;
      }
      else
	relString2 = 1;
    }
  } else
    relString2 = 8;
  
  // the and/or buttonGroup
  if (or->isOn())    // "or" is down
    andOrFlag=1;
  else               // "and" is down
    andOrFlag=0;

  // secondly the combobox and flag part
  // has any widget been activated? then the search may start 
  if ((onButton[0]->isOn()) || (onButton[1]->isOn()) || (onButton[2]->isOn()) || 
      (onButton[3]->isOn()) || (onButton[4]->isOn()) || (onButton[5]->isOn()) || 
      (onButton[6]->isOn()) || (onButton[7]->isOn()) || (onButton[8]->isOn()) || 
      (onButton[9]->isOn()) || (onButton[10]->isOn()) || (onButton[11]->isOn()) || 
      (onButton[12]->isOn()))
    selected = TRUE;
  
  // has every data been correct, so we can start a search??
  if (selected && (relString1 > 0) && (relString2 > 0)){
    //////////////////////////////////////////////
    //                                          //
    //              yes, so SEARCH!             //
    //                                          //
    //////////////////////////////////////////////
    Movie *curMov = anchor->firstMovie();
    QStrList movs;
    while (curMov){
      if (this->searchFct(curMov))
	movs.inSort(curMov->title);
      curMov = anchor->nextMovie();
    }
    this->papa->movies->clear();
    this->papa->clearAll(FALSE);
    this->papa->toolBar()->setItemEnabled(43,TRUE);
    this->papa->toolBar()->setItemEnabled(13,TRUE);
    this->papa->toolBar()->setItemEnabled(12,TRUE);
    this->papa->toolBar()->setItemEnabled(30,TRUE);
    this->papa->edit->setItemEnabled(this->papa->edit->idAt(6),TRUE);
    this->papa->edit->setItemEnabled(this->papa->edit->idAt(4),TRUE);
    this->papa->file->setItemEnabled(4,TRUE);
    this->papa->file->setItemEnabled(5,TRUE);
    this->papa->file->setItemEnabled(6,TRUE);
    this->papa->movies->insertStrList(&movs);
    if (this->papa->movies->count() > 0)
      this->papa->movies->setCurrentItem(0);
    this->close();
  } else {
    // No, just return, to give the user the chance to 
    // alter his search-function
    KMsgBox::message(this,i18n("Error"),i18n("Please specify a search function!"),0,"OK");
    return;
    
  }
}

//////////////////////////////////////////////////////
//                                                  //
//             Just return to the main window       //
//                                                  //
//////////////////////////////////////////////////////
void searchWindow::slotCancel()
{
  this->close();
}

//////////////////////////////////////////////////////
//                                                  //
//  Choose randomly either one movie from the whole //
//  list, or from the movies which fit into the     //
//  search constraints                              //
//                                                  //
//////////////////////////////////////////////////////
void searchWindow::slotRandom()
{
  int index;
  QDateTime dT(QDate::currentDate(),QTime::currentTime());
  QDateTime zero(QDate(1,1,1),QTime(0,0));
  
  srandom((unsigned int)zero.secsTo(dT));
  index = random()%(this->papa->movies->count());
  this->papa->movies->setCurrentItem(index);
  this->papa->movies->centerCurrentItem();
  this->close();
}

//////////////////////////////////////////////////////
//                                                  //
//      Reset all fields of the window to their     //
//      default values                              //
//                                                  //
//////////////////////////////////////////////////////
void searchWindow::slotReset()
{
  cout << "reset\n";
}


//////////////////////////////////////////////////////////////////////
//                                                                  //
//                    The Search Function                           //
//                                                                  //
//////////////////////////////////////////////////////////////////////

bool searchWindow::searchFct(Movie *curMov)
{
  bool OK=FALSE;
  bool OK2=FALSE;
  bool flagsOK=TRUE;
  
  QString dummy;
  bool castOK = FALSE;
  int intDummy = 0;
  char *fehler;
  
  if (search1->currentItem() > 0){
    switch (search1->currentItem()){
    case 1:
      if (curMov->title.contains(search1E->currentText(),FALSE) > 0)
	OK=TRUE;
      break;
    case 2:
      if (curMov->original.contains(search1E->currentText(),FALSE) > 0)
	OK=TRUE;
      break;
    case 3:
      if (curMov->cassette.contains(search1E->currentText(),FALSE) > 0)
	OK=TRUE;
      break;
    case 4:
      if (curMov->start == -1)
	break;
      intDummy = strtol(search1E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->start == intDummy)
	  OK=TRUE;
	break;
      case 2:
	if (curMov->start < intDummy)
	  OK=TRUE;
	break;
      case 3:
	if (curMov->start <= intDummy)
	  OK=TRUE;
	break;
      case 4:
	if (curMov->start > intDummy)
	  OK=TRUE;
	break;
      case 5:
	if (curMov->start >= intDummy)
	  OK=TRUE;
	break;
      default:
	break;
      }
      break;
    case 5:
      if (curMov->length[0] == 0)
	break;
      intDummy = strtol(search1E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->length[0] == intDummy)
	  OK=TRUE;
	break;
      case 2:
	if (curMov->length[0] < intDummy)
	  OK=TRUE;
	break;
      case 3:
	if (curMov->length[0] <= intDummy)
	  OK=TRUE;
	break;
      case 4:
	if (curMov->length[0] > intDummy)
	  OK=TRUE;
	break;
      case 5:
	if (curMov->length[0] >= intDummy)
	  OK=TRUE;
	break;
      default:
	break;
      }
      break;
    case 6:
      if (curMov->length[1] == 0)
	break;
      intDummy = strtol(search1E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->length[1] == intDummy)
	  OK=TRUE;
	break;
      case 2:
	if (curMov->length[1] < intDummy)
	  OK=TRUE;
	break;
      case 3:
	if (curMov->length[1] <= intDummy)
	  OK=TRUE;
	break;
      case 4:
	if (curMov->length[1] > intDummy)
	  OK=TRUE;
	break;
      case 5:
	if (curMov->length[1] >= intDummy)
	  OK=TRUE;
	break;
      default:
	break;
      }
      break;
    case 7:
      if (curMov->country.contains(search1E->currentText(),FALSE) > 0)
	OK=TRUE;
      break;
    case 8:
      if (curMov->year == 0)
	break;
      intDummy = strtol(search1E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->year == intDummy)
	  OK=TRUE;
	break;
      case 2:
	if (curMov->year < intDummy)
	  OK=TRUE;
	break;
      case 3:
	if (curMov->year <= intDummy)
	  OK=TRUE;
	break;
      case 4:
	if (curMov->year > intDummy)
	  OK=TRUE;
	break;
      case 5:
	if (curMov->year >= intDummy)
	  OK=TRUE;
	break;
      default:
	break;
      }
      break;
    case 9:
      break;
    case 10:
      if (curMov->director.contains(search1E->currentText(),FALSE) > 0)
	OK=TRUE;
      break;
    case 11:
      if (curMov->producer.contains(search1E->currentText(),FALSE) > 0)
	OK=TRUE;
      break;
    case 12:
      dummy = curMov->cast.first();
      if (dummy.contains(search1E->currentText(),FALSE) > 0)
	castOK = TRUE;
      else{
	dummy = curMov->cast.next();
	if (dummy.contains(search1E->currentText(),FALSE) > 0)
	  castOK = TRUE;
	else{
	  dummy = curMov->cast.next();
	  if (dummy.contains(search1E->currentText(),FALSE) > 0)
	    castOK = TRUE;
	  else{
	    dummy = curMov->cast.next();
	    if (dummy.contains(search1E->currentText(),FALSE) > 0)
	      castOK = TRUE;
	  }
	}
      }
      if (castOK)
	OK=TRUE;
      break;
    default:
      break;
    }
  } else
    OK = TRUE;

  castOK = FALSE;
  
  if (search2->currentItem() > 0){
    switch (search2->currentItem()){
    case 1:
      if (curMov->title.contains(search2E->currentText(),FALSE) > 0)
	OK2=TRUE;
      break;
    case 2:
      if (curMov->original.contains(search2E->currentText(),FALSE) > 0)
	OK2=TRUE;
      break;
    case 3:
      if (curMov->cassette.contains(search2E->currentText(),FALSE) > 0)
	OK2=TRUE;
      break;
    case 4:
      if (curMov->start == -1)
	break;
      intDummy = strtol(search2E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->start == intDummy)
	  OK2=TRUE;
	break;
      case 2:
	if (curMov->start < intDummy)
	  OK2=TRUE;
	break;
      case 3:
	if (curMov->start <= intDummy)
	  OK2=TRUE;
	break;
      case 4:
	if (curMov->start > intDummy)
	  OK2=TRUE;
	break;
      case 5:
	if (curMov->start >= intDummy)
	  OK2=TRUE;
	break;
      default:
	break;
      }
      break;
    case 5:
      if (curMov->length[0] == 0)
	break;
      intDummy = strtol(search2E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->length[0] == intDummy)
	  OK2=TRUE;
	break;
      case 2:
	if (curMov->length[0] < intDummy)
	  OK2=TRUE;
	break;
      case 3:
	if (curMov->length[0] <= intDummy)
	  OK2=TRUE;
	break;
      case 4:
	if (curMov->length[0] > intDummy)
	  OK2=TRUE;
	break;
      case 5:
	if (curMov->length[0] >= intDummy)
	  OK2=TRUE;
	break;
      default:
	break;
      }
      break;
    case 6:
      if (curMov->length[1] == 0)
	break;
      intDummy = strtol(search2E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->length[1] == intDummy)
	  OK2=TRUE;
	break;
      case 2:
	if (curMov->length[1] < intDummy)
	  OK2=TRUE;
	break;
      case 3:
	if (curMov->length[1] <= intDummy)
	  OK2=TRUE;
	break;
      case 4:
	if (curMov->length[1] > intDummy)
	  OK2=TRUE;
	break;
      case 5:
	if (curMov->length[1] >= intDummy)
	  OK2=TRUE;
	break;
      default:
	break;
      }
      break;
    case 7:
      if (curMov->country.contains(search2E->currentText(),FALSE) > 0)
	OK2=TRUE;
      break;
    case 8:
      if (curMov->year == 0)
	break;
      intDummy = strtol(search2E->currentText(),&fehler,10);
      if (strcmp(fehler,"\0"))
	break;
      switch (relString1){
      case 1:
	if (curMov->year == intDummy)
	  OK2=TRUE;
	break;
      case 2:
	if (curMov->year < intDummy)
	  OK2=TRUE;
	break;
      case 3:
	if (curMov->year <= intDummy)
	  OK2=TRUE;
	break;
      case 4:
	if (curMov->year > intDummy)
	  OK2=TRUE;
	break;
      case 5:
	if (curMov->year >= intDummy)
	  OK2=TRUE;
	break;
      default:
	break;
      }
      break;
    case 9:
      break;
    case 10:
      if (curMov->director.contains(search2E->currentText(),FALSE) > 0)
	OK2=TRUE;
      break;
    case 11:
      if (curMov->producer.contains(search2E->currentText(),FALSE) > 0)
	OK2=TRUE;
      break;
    case 12:
      dummy = curMov->cast.first();
      if (dummy.contains(search2E->currentText(),FALSE) > 0)
	castOK = TRUE;
      else{
	dummy = curMov->cast.next();
	if (dummy.contains(search2E->currentText(),FALSE) > 0)
	  castOK = TRUE;
	else{
	  dummy = curMov->cast.next();
	  if (dummy.contains(search2E->currentText(),FALSE) > 0)
	    castOK = TRUE;
	  else{
	    dummy = curMov->cast.next();
	    if (dummy.contains(search2E->currentText(),FALSE) > 0)
	      castOK = TRUE;
	  }
	}
      }
      if (castOK)
	OK2=TRUE;
      break;
    default:
      break;
    }
  } else
    OK2 = OK;
  
  if (onButton[0]->isOn())
    if (curMov->index != index->currentItem())
      flagsOK = FALSE;
  if (onButton[1]->isOn())
    if (!curMov->category.contains(category->currentText()))
      flagsOK = FALSE;
  if (onButton[2]->isOn())
    if (curMov->sound != sound->currentText())
      flagsOK = FALSE;
  if (onButton[3]->isOn())
    if (curMov->speed != speed->currentText())
      flagsOK = FALSE;
  if (onButton[4]->isOn())
    if (curMov->fsk != fsk->currentText())
      flagsOK = FALSE;
  if (onButton[5]->isOn())
    if (curMov->source != source->currentItem())
      flagsOK = FALSE;
  if (onButton[6]->isOn())
    if (curMov->videonorm != videonorm->currentItem())
      flagsOK = FALSE;
  if (onButton[7]->isOn())
    if (curMov->rating != rating->currentItem())
      flagsOK = FALSE;
  if (onButton[8]->isOn())
    if (bw->isOn()){
      if (!(curMov->flags & 1))
	flagsOK = FALSE;
    } else {
      if (curMov->flags & 1)
	flagsOK = FALSE;
    }
  if (onButton[9]->isOn())
    if (commercial->isOn()){
      if (!(curMov->flags & 2))
	flagsOK = FALSE;
    } else {
      if (curMov->flags & 2)
	flagsOK = FALSE;
    }
  if (onButton[10]->isOn())
    if (widescreen->isOn()){
      if (!(curMov->flags & 4))
	flagsOK = FALSE;
    } else {
      if (curMov->flags & 4)
	flagsOK = FALSE;
    }
  if (onButton[11]->isOn())
    if (omu->isOn()){
      if (!(curMov->flags & 8))
	flagsOK = FALSE;
    } else {
      if (curMov->flags & 8)
	flagsOK = FALSE;
    }
  if (onButton[12]->isOn())
    if (caption->isOn()){
      if (!(curMov->flags & 16))
	flagsOK = FALSE;
    } else {
      if (curMov->flags & 16)
	flagsOK = FALSE;
    }
  

  if (and->isOn())
    if (((OK) && (OK2)) && (flagsOK))
      return TRUE;
    else
      return FALSE;
  else
    if (((OK) || (OK2)) && (flagsOK))
      return TRUE;
    else
      return FALSE;
}
