#include <qstring.h>
#include <qpixmap.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>

#include "kvideodb.h"

#ifndef PRINT

#define PRINT
#define MAX_PIX 50;


void kvdbPrint(KVideoDB *);

class pXPM
{
 public:
  pXPM();
  
  QString key;
  QPixmap pxpm;
};

class PrintPixmaps
{
 public:
  PrintPixmaps();
  
  pXPM pxpm[50];
  int maxIndex;
  
  bool insert(QString,QPixmap);
  int find(QString);
};


class printWindow : public QDialog
{
  Q_OBJECT
 public:
  printWindow(KVideoDB *);
  ~printWindow(){};

  QListView    *printers;
  QButtonGroup *printerChoice;
  QLineEdit    *printFile;
  QButtonGroup *paperSize;
  QButtonGroup *printFormat;
  QButtonGroup *pageOrientation;
  QButtonGroup *printWhat;
  QPushButton  *up;
  QPushButton  *down;
  QLineEdit    *copies;

  QPushButton  *ok;
  QPushButton  *cancel;

 public slots:
  void slotOK();
  void slotCancel();
  void slotUp();
  void slotDown();
  void slotPrinterClicked(int);
  void slotOrientationClicked(int);
  void slotFormatClicked(int);
  void slotSizeClicked(int);
  
};


#endif
