
 /* kvideodb.h.
 *
 * Copyright (C) 1998 Carsten Heiming
 *
 */

#include <kapp.h>
#include <ktmainwindow.h>
#include <kurl.h>
#include <kfm.h>
#include <ktabctl.h>
#include <qmultilinedit.h>
#include <qmlined.h>
#include <qlistbox.h>

#include "fakebuttons.h"
#include "labelFrames.h"

#ifndef KVIDEO
#define KVIDEO

class KVideoDB : public KTMainWindow
{
  Q_OBJECT;
  
 public:
  KVideoDB();
  ~KVideoDB(){};
  
  bool loadFile(const char* filename);
  void moveWidgets(int, int);
  void showMovies(QString);
  void addToRecent(QString);
  void insertMovies();
  void clearAll(bool);
  int xStart;
  int gotoCurrent(QString);
  
  KMenuBar    *mainMenu;
  KTabCtl     *dataTab;
  QWidget     *page1;
  QWidget     *page2;
  QWidget     *page3;
  
  QPopupMenu  *file;
  QPopupMenu  *edit;
  QPopupMenu  *options;
  QPopupMenu  *recentFile;
  
  QFrame      *buttonFrame;
  
  FakeButton  *title_b;
  FakeButton  *original_b;
  QPushButton *tapeNr_b;
  FakeButton  *indexNr_b;
  FakeButton  *length_b;
  FakeButton  *olength_b;
  QPushButton *country_b;
  QPushButton *year_b;
  QPushButton *date_b;

  QPushButton *director_b;
  QPushButton *producer_b;
  QPushButton *composer_b;
  
  QPushButton *cast1_b;
  QPushButton *cast2_b;
  QPushButton *cast3_b;
  QPushButton *cast4_b;

  FakeButton  *time_b;

  QPushButton *category1_b;
  QPushButton *category2_b;

  QPushButton *tapeLength_b;
  QPushButton *tapeType_b;
  QPushButton *recType_b;

  QPushButton *sound_b;
  QPushButton *color_b;
  QPushButton *speed_b;
  QPushButton *commercial_b;
  QPushButton *source_b;

  QPushButton *widescreen_b;
  QPushButton *omu_b;
  QPushButton *fsk_b;
  QPushButton *caption_b;
  QPushButton *movie_b;

  QPushButton *rating_b;

  QPushButton *movieB[6];
  
  QLabel *title_l;
  QLabel *original_l;
  QLabel *tape_l;
  QLabel *length_l;
  QLabel *release_l;
  QLabel *date_l;

  QLabel *director_l;
  QLabel *producer_l;
  QLabel *composer_l;
  
  QLabel *cast1_l;
  QLabel *cast2_l;
  QLabel *cast3_l;
  QLabel *cast4_l;
  QLabel *cast5_l;

  QLabel *category_l;
  QLabel *flags_l;
  QLabel *tapeLength_l;
  QLabel *tapeType_l;
  QLabel *recType_l;

  QFrame      *freeFrame;
  QLabel      *freeLabel;
  QLabel      *freeSearch_l;
  QLabel      *cassTime;
  QLabel      *time[5];
  labelFrame  *movieLabel[13];
  QLabel      *cassNo;
  
  QLabel *rating_l;
  
  QPixmap      sound_p;
  QPixmap      country_p;
  QPixmap      color_p;
  QPixmap      commercial_p;
  QPixmap      source_p;
  
  QListBox       *movies;
  QMultiLineEdit *comments;
  
  public slots:
    void slotQuit();
    void slotRecent(int);
    void slotConfigure();
    void slotOptionsProp();
    void slotShowCassWin();
    void slotSwallowCassWin();
    void slotSaveOptions();
    void slotDropEvent( KDNDDropZone *);
    void slotLoadFile();
    void slotPrintFile();
    void slotSaveKnownFile();
    void slotSaveFile();
    void slotNewWindow();
    void slotAddMovie();
    void slotEditMovie();
    void slotAskDel();
    void slotDelMovie();
    void slotSearch();
    void slotToolbarClicked(int);
    void slotBarMoved();
    void slotListClicked();
    void slotListdClicked(int);
    //    void slotInsertMovie();
    void slotCassetteClicked();
    void slotCountryClicked();
    void slotYearClicked();
    void slotDateClicked();
    void slotCast1Clicked();
    void slotCast2Clicked();
    void slotCast3Clicked();
    void slotCast4Clicked();
    void slotDirectorClicked();
    void slotProducerClicked();
    void slotComposerClicked();
    void slotCat1Clicked();
    void slotCat2Clicked();
    void slotRatingClicked();
    void slotSoundClicked();
    void slotSpeedClicked();
    void slotSourceClicked();
    void slotVideonormClicked();
    void slotFskClicked();
    void slotColorClicked();
    void slotCommercialClicked();
    void slotWidescreenClicked();
    void slotSubtitlesClicked();
    void slotCaptionClicked();
    void slotTLengthClicked();
    void slotTTypeClicked();
    void slotRTypeClicked();
    void slotReset();
    void slotSearchCass();
    void slotSearchSpace();
    void slotB1Clicked();
    void slotB2Clicked();
    void slotB3Clicked();
    void slotB4Clicked();
    void slotB5Clicked();
    void slotB6Clicked();
    
 protected:
    void findCast(QString);
    void findCategory(QString);
    void closeEvent(QCloseEvent *);
    //    void readProperties(KConfig*);
    
    
 private:
    KFM* kfm;
    enum {TOOLBAR_EXIT, TOOLBAR_OPEN};
};

extern addMovie();

#endif
