#ifndef HILFSROUT
#define HILFSROUT

#include "kvideodb.h"
#include "movies.h"
#include "fakebuttons.h"

// Functions to build some paths
// picPath : Path in which the icons of the buttons are searched
char *picPath(const char *);

// myIcon : Path in which additional toolbar icons are searched
char *myIcon(char *);

// rcPath : Path where the local config file is searched
char *rcPath();

// other routines
// Function to change all uppercase letters in a string to lowercase 
// and to erase all spaces
char *lowerString(char *);

int min(int, int);

Movie *getCurrentMovie(QString);

// Insert Movies into the Movie-Browser
void insertMovies(KVideoDB *);

// Save the File
bool saveFile(QString);

// Function to remove the leading spaces in a QString
QString removeLeadingSpaces(QString);

// Show a version-message when the program was called with
// "kvideodb --version"
void displayVersion();

// Show a help-message when the program was called with
// "kvideodb --help"
void displayHelp();

// Function to print all the titles saved in the B*-Tree
void printList();

// Does the Movie exist already in the database?
char *titleExists(QString);

bool checkCassIndex(QString,int);

int gotoCurrent(QString);

int compare(const Movie *,const Movie *);

bool correctString(QString, QString);

void export2html();

bool cassDataOK(Movie *);

void changeCassData (Movie *);

void changeThisCassData (Movie *);

char *calcLength(int);
#endif

