#include <iostream.h>
#include <stdio.h>
#include <ctype.h>

#include <qlistbox.h>
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kmsgbox.h>

#include "hilfsrout.h"
#include "bstar.h"

extern BStarTree *anchor;
extern char appsPath[50];
extern char localConfigPath[60];
extern QString VideoFile;
extern bool changed;

// Functions to build some paths
// picPath : Path in which the icons of the buttons are searched
char *picPath(const char *xpm)
{
  static char result[80];
  
  sprintf(result,"%s/kvideodb/pics/%s",appsPath,xpm);
  return result;
}


// myIcon : Path in which additional toolbar icons are searched
char *myIcon(char *xpm)
{
  static char result[80];
  
  sprintf(result,"%s/kvideodb/toolbar/%s",appsPath,xpm);
  return result;
}

// rcPath : Path where the local config file is searched
char *rcPath()
{
  static char result[80];
  
  sprintf(result,"%s/kvideodbrc",localConfigPath);
  return result;
}

// other routines
// Function to change all uppercase letters in a string to lowercase 
// and to erase all spaces
char *lowerString(char *upString)
{
  static char result[80];
  unsigned int i;
  unsigned int j;
  
  for (i=0,j=0; i <strlen(upString); i++){
    if (upString[i] != ' '){
      result[j] = tolower(upString[i]);
      j++;
    }
  }
  result[j] = '\0';
  return result;
}

int min (int a, int b)
{
  if (a < b)
    return a;
  else 
    return b;
}



// Function to insert the movies into the 
// Movie-Browser in the Main-Window
void insertMovies(KVideoDB *mainWin)
{
  Movie *current = anchor->firstMovie();
  
  while (current){
    mainWin->movies->inSort(current->title.data());
    current = anchor->nextMovie();
  }
}


// Save the File
bool saveFile(QString name)
{
  QFile dataFile(name.data());
  Movie *current = anchor->firstMovie();
  int j=1;
  bool openOK;
  
  openOK = dataFile.open(IO_WriteOnly);
  if (!openOK)
    return FALSE;

  QTextStream dataStream(&dataFile);
  dataStream << "# Movie-File generated by KVideoDB v" << VERSION << "\n"
	     << "# Each Movie is represented by its Title, original Title,\n"
	     << "# Cassette-No., Index-No., Start-Time, Length,\n"
	     << "# original Length, Country, Year, Date of recording,\n"
	     << "# Director, Producer, 4 Casts, 2 Categories and flags,\n"
	     << "# which are B&W, Commercials, Widescreen, Subtitles, Closed Captions\n";
  while (current){
    dataStream << "[" << j << "]\n";
    dataStream << "  Title = " << current->title << "\n";
    dataStream << "  Original = " << current->original << "\n";
    dataStream << "  Cassette = " << current->cassette << "\n";
    dataStream << "  Index = " << (current->index) << "\n";
    dataStream << "  Start-Time = " << current->start << "\n";
    dataStream << "  Length = " << current->length[0] << "\n";
    dataStream << "  orig. Length = " << current->length[1] << "\n";
    dataStream << "  Country = " << current->country << "\n";
    dataStream << "  Year = " << current->year << "\n";
    if (current->date->isValid())
      dataStream << "  Date of recording = " << current->date->day() << "."
		 << current->date->month() << "." << current->date->year() << "\n";
    else
      dataStream << "  Date of recording = \n";
    dataStream << "  Director = " << current->director << "\n";
    dataStream << "  Producer = " << current->producer << "\n";
    dataStream << "  Composer = " << current->composer << "\n";
    dataStream << "  Cast1 = " << current->cast.first() << "\n";
    dataStream << "  Cast2 = " << current->cast.next() << "\n";
    dataStream << "  Cast3 = " << current->cast.next() << "\n";
    dataStream << "  Cast4 = " << current->cast.next() << "\n";
    dataStream << "  Quality-Points = " << current->rating << "\n";
    dataStream << "  Category1 = " << current->category.first() << "\n";
    dataStream << "  Category2 = " << current->category.last() << "\n";
    dataStream << "  Sound = " << current->sound << "\n";
    dataStream << "  Speed = " << current->speed << "\n";
    dataStream << "  Source = " << current->source << "\n";
    dataStream << "  Videonorm = " << current->videonorm << "\n";
    dataStream << "  Rated as = " << current->fsk << "\n";
    dataStream << "  Recording-Type = " << current->recType << "\n";
    dataStream << "  Tape-Type = " << current->tapeType << "\n";
    dataStream << "  Tape-Length = " << current->tapeLength << "\n";
    dataStream << "  B&W = ";
    if (current->flags & 1)
      dataStream << "Yes\n";
    else
      dataStream << "No\n";
    dataStream << "  Commercials = ";
    if ((current->flags >> 1) & 1)
      dataStream << "Yes\n";
    else
      dataStream << "No\n";
    dataStream << "  Widescreen = ";
    if ((current->flags >> 2) & 1)
      dataStream << "Yes\n";
    else
      dataStream << "No\n";
    dataStream << "  Subtitles = ";
    if ((current->flags >> 3) & 1)
      dataStream << "Yes\n";
    else
      dataStream << "No\n";
    dataStream << "  Captions = ";
    if ((current->flags >> 4) & 1)
      dataStream << "Yes\n";
    else
      dataStream << "No\n";
    dataStream << "  Comment = ";
    for (unsigned int i=0; i < current->comment.length(); i++){
      if (current->comment.at(i) != '\n')
	dataStream << current->comment.at(i);
      else
	dataStream << "\\n";
    }
    dataStream << "\n";
    j++;
    current = anchor->nextMovie();
  }
  dataFile.close();
  VideoFile = name;
  changed = FALSE;
  return TRUE;
}


QString removeLeadingSpaces(QString qstr)
{
  QString a=qstr;
  
  while (a.left(1) == " ")
    a = a.right(a.length()-1);
  
  return a;
}

void displayVersion()
{
  cout << "KVideoDB v" << VERSION << " --  1998 Carsten Heiming, Stefan Siegel\n";
}


void displayHelp()
{
  cout << "\nkvideodb [filename] [options] [--help] [--version]\n";
  cout << "\n  filename: Name of the File to be loaded\n";
  cout << "            It should end on \".vdb\"";
  cout << "\n  options:\n";
  cout << "    -p: default Properties wont be displayed\n";
  cout << "    -c: Cassette-Window wont be displayed\n";
  cout << "    -s: Cassette-Window will be swallowed (not implemented yet)\n";
  cout << "    -d: Ask before deleting a movie\n\n";
  cout << "   --help: This page is shown\n";
  cout << "   --version: A version message is shown\n\n";
}


// Function to print all the titles saved in the B*-Tree
void printList()
{
  Movie *current;
  
  current=anchor->firstMovie();

  while(current){
    cout << "Title: " << current->title << "\n";
    current=anchor->nextMovie();
  }
  
}

char *titleExists(QString testTitle)
{
  Movie *current = anchor->firstMovie();
  
  while(current)
    if (current->title == testTitle.data())
      return(current->cassette.data());
    else
      current = anchor->nextMovie();
  return NULL;
}

bool checkCassIndex(QString cass, int index)
{
  Movie *current = anchor->firstMovie();
  
  if (index == 0)
    return TRUE;
  
  while(current)
    if ((current->cassette == cass.data()) && (current->index == index))
      return FALSE;
    else
      current = anchor->nextMovie();
  
  return TRUE;
}


int gotoCurrent(QString bText)
{
  int index=0;
  Movie *current =anchor->firstMovie();
  
  while (current){
    if (current->title == bText)
      return index;
    index++;
    current = anchor->nextMovie();
  }
  return index;
}


// Compare two Movies:
// -1 : M1 < M2
//  1 : M1 > M2
//  0 : M1 = M2
int compare(const Movie *M1,const Movie *M2)
{
  if (M1->title.data() < M2->title)
    return -1;
  else if (M1->title.data() > M2->title)
    return 1;
  else
    return 0;
}

bool correctString(QString a, QString b)
{
  unsigned int i=0;
  do{
    if (a.at(i) == '*')
      return TRUE;
    if (a.at(i) != b.at(i))
      return FALSE;
    i++;
  }while ((i<a.length()) && (a.at(i) == b.at(i)));
  if ((a.at(i) != '*') && (i < b.length()))
    return FALSE;
  else
    return TRUE;
}

void export2html()
{
  bool openOK = FALSE;
  QFile htmlFile("kvideodb-export.html");
  Movie *current = anchor->firstMovie();
  
  openOK = htmlFile.open(IO_WriteOnly);
  if (!openOK){
    KMsgBox::message(0,i18n("Error"),i18n("Error writing file - perhaps wrong permissions"),0,"OK");
    return;
  }
  
  QTextStream htmlStream(&htmlFile);

  htmlStream << "<html>\n  <head>\n    <title>KVideoDB HTML-Export</title>\n  </head>\n<body>\n";
  while (current){
    htmlStream << "<TABLE BORDER=3 CELLPADDING=4 CELLSPACING=3 WIDTH=700>\n";
    htmlStream << "<TR>\n  <TD ROWSPAN=17 VALIGN=TOP>\n";
    htmlStream << current->title;
    htmlStream << "\n  </TD>\n  <TD>\n";
    htmlStream << i18n("Original") << ": " << current->original.data();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Cassette") << ": " << current->cassette;
    htmlStream << ", " << i18n("Index") << ": " << current->index;
    htmlStream << ", " << i18n("Start") << ": " << current->start << " min.";
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Length") << ": " << current->length[0] << " min., " 
	       << i18n("orig. Length") << ": " << current->length[1] << " min.";
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Release") << ": " << current->country << " " << current->year;
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Date of Recording") << ": " << current->date->toString();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Director") << ": " << current->director;
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Producer") << ": " << current->producer;
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Cast 1") << ": " << current->cast.first();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Cast 2") << ": " << current->cast.next();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Cast 3") << ": " << current->cast.next();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Cast 4") << ": " << current->cast.next();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Category") << ": " << current->category.first()
	       << " / " << current->category.last();
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Sound") << ": " << current->sound
	       << ", " << i18n("Speed") << ": "<< current->speed;
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Videonorm") << ": " << current->videonorm
	       << ", " << i18n("Source") << ": " << current->source
	       << ", " << i18n("Rated") << ": " << current->fsk;
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("B&W") << ": ";
    if (current->flags & 1)
      htmlStream << i18n("Yes");
    else
      htmlStream << i18n("No");
    htmlStream << ", " << i18n("Commercial") << ": ";
    if (current->flags & 2)
      htmlStream << i18n("Yes");
    else
      htmlStream << i18n("No");
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Widescreen") << ": ";
    if (current->flags & 4)
      htmlStream << i18n("Yes");
    else
      htmlStream << i18n("No");
    htmlStream << ", " << i18n("Subtitles") << ": ";
    if (current->flags & 8)
      htmlStream << i18n("Yes");
    else
      htmlStream << i18n("No");    
    htmlStream << "\n  </TD>\n</TR>\n<TR>\n  <TD>\n";
    htmlStream << i18n("Closed Captions") << ": ";
    if (current->flags & 16)
      htmlStream << i18n("Yes");
    else
      htmlStream << i18n("No");
    htmlStream << ", " << i18n("Quality-Points") << ": " << current->rating;
    htmlStream << "\n  </TD>\n</TR>\n</TABLE>\n<BR>\n";
    current=anchor->nextMovie();
  }   
  htmlStream << "</body>\n</html>\n";
  htmlFile.close();
}


/////////////////////////////////////////////////////////
//             Routines to check and set               //
//                the cassette-data                    //
/////////////////////////////////////////////////////////
bool cassDataOK(Movie *testMov)
{
  Movie *current=anchor->firstMovie();

  while (current){
    if (!strcmp(testMov->cassette,current->cassette)){
      if ((testMov->tapeType != current->tapeType.data()) || 
	  (testMov->tapeLength != current->tapeLength))
	return FALSE;
    }
    current = anchor->nextMovie();
  }
  return TRUE;
}


void changeCassData(Movie *okMov)
{
  Movie *current=anchor->firstMovie();
  
  while (current){
    if (!strcmp(okMov->cassette,current->cassette)){
      current->tapeType = okMov->tapeType;
      current->tapeLength = okMov->tapeLength;
    }
    current = anchor->nextMovie();
  }
}

void changeThisCassData(Movie *wrongMov)
{
  Movie *current=anchor->firstMovie();
  
  while(current){
    if (!strcmp(wrongMov->cassette,current->cassette)){
      wrongMov->tapeType = current->tapeType;
      wrongMov->tapeLength = current->tapeLength;
      return;
    }
    current = anchor->nextMovie();
  }
}

char *calcLength(int length)
{
  int minutes = length % 60;
  int hours = length / 60;
  static char cLength[80];
  
  sprintf(cLength,"%1d:%02d",hours,minutes);
  return cLength;
}
