/*
 * win_dialog.cpp
 *
 * Copyright (C) 1999 Lubos Lunak <l.lunak@email.cz>
 */

#include <qpixmap.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <kapp.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <qtooltip.h>
#include "win_dialog.h"

win_dialog::win_dialog()
    : QDialog( 0, 0, true )
    {
	QGridLayout* layout = new QGridLayout( this, 2, 2, 20 );
	layout->setRowStretch( 0, 5 );
	layout->addRowSpacing( 0, 100 );
	layout->setRowStretch( 1, 0 );
	layout->addRowSpacing( 1, 50 );
	layout->setColStretch( 0, 1 );
	layout->addColSpacing( 0, 100 );
	layout->setColStretch( 1, 1 );
	layout->addColSpacing( 1, 100 );
	
	setCaption( i18n( "Select window" ));
	windows_list = new QListView( this, "ListView_1" );
	windows_list->setGeometry( 20, 20, 500, 320 );
	windows_list->setMinimumSize( 200, 100 );
//	windows_list->setMaximumSize( 32767, 32767 );
	connect( windows_list, SIGNAL(doubleClicked(QListViewItem*)), SLOT(window_selected(QListViewItem*)) );
	connect( windows_list, SIGNAL(returnPressed(QListViewItem*)), SLOT(window_selected(QListViewItem*)) );
	windows_list->setFocusPolicy( QWidget::TabFocus );
	windows_list->setBackgroundMode( QWidget::PaletteBackground );
	windows_list->setFontPropagation( QWidget::NoChildren );
	windows_list->setPalettePropagation( QWidget::NoChildren );
 	windows_list->setFrameStyle( 17 );
	windows_list->setResizePolicy( QScrollView::Manual );
	windows_list->setVScrollBarMode( QScrollView::Auto );
	windows_list->setHScrollBarMode( QScrollView::Auto );
	windows_list->setTreeStepSize( 0 );
	windows_list->setMultiSelection( FALSE );
	windows_list->setAllColumnsShowFocus( true );
	windows_list->setItemMargin( 1 );
	windows_list->setRootIsDecorated( FALSE );
	windows_list->addColumn( i18n( "Window title"), 200 );
	windows_list->setColumnWidthMode( 0, QListView::Manual );
	windows_list->setColumnAlignment( 0, 1 );
	windows_list->addColumn( i18n("Window command"), 150 );
	windows_list->setColumnWidthMode( 1, QListView::Manual );
	windows_list->setColumnAlignment( 1, 1 );
	windows_list->addColumn( i18n("Window class"), 148 );
	windows_list->setColumnWidthMode( 2, QListView::Manual );
	windows_list->setColumnAlignment( 2, 1 );
	QToolTip::add( windows_list, i18n( "This is list of all windows that appear to be created by the command" ));
	layout->addMultiCellWidget( windows_list, 0, 0, 0, 1 );

	QPushButton* qtarch_PushButton_1;
	qtarch_PushButton_1 = new QPushButton( this, "PushButton_1" );
	qtarch_PushButton_1->setGeometry( 100, 360, 140, 30 );
	connect( qtarch_PushButton_1, SIGNAL(clicked()), SLOT(select_pressed()) );
	qtarch_PushButton_1->setFocusPolicy( QWidget::TabFocus );
	qtarch_PushButton_1->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_PushButton_1->setFontPropagation( QWidget::NoChildren );
	qtarch_PushButton_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_PushButton_1->setText( i18n("Select") );
	qtarch_PushButton_1->setAutoRepeat( FALSE );
	qtarch_PushButton_1->setAutoResize( FALSE );
	qtarch_PushButton_1->setDefault( true );
	qtarch_PushButton_1->setMaximumSize( 140, 30 );
	QToolTip::add( qtarch_PushButton_1, i18n( "Press this button to automatically fill in the parameters from the selected window" ));
	layout->addWidget( qtarch_PushButton_1, 1, 0, AlignCenter );

	QPushButton* qtarch_PushButton_2;
	qtarch_PushButton_2 = new QPushButton( this, "PushButton_2" );
	qtarch_PushButton_2->setGeometry( 320, 360, 100, 30 );
	connect( qtarch_PushButton_2, SIGNAL(clicked()), SLOT(reject()) );
	qtarch_PushButton_2->setFocusPolicy( QWidget::TabFocus );
	qtarch_PushButton_2->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_PushButton_2->setFontPropagation( QWidget::NoChildren );
	qtarch_PushButton_2->setPalettePropagation( QWidget::NoChildren );
	qtarch_PushButton_2->setText( i18n("Cancel") );
	qtarch_PushButton_2->setAutoRepeat( FALSE );
	qtarch_PushButton_2->setAutoResize( FALSE );
	qtarch_PushButton_2->setMaximumSize( 140, 30 );
	layout->addWidget( qtarch_PushButton_2, 1, 1, AlignCenter );

	layout->activate();
	resize( 540,410 );
	setMinimumSize( 300, 200 );
	
	window_titles.setAutoDelete( false ); // CHECKME important
	last_autoact = winId();
}

void win_dialog::window_selected(QListViewItem* item )
    {
    accept();
    }
    
void win_dialog::select_pressed()
    {
    if( windows_list->currentItem() != NULL )
	window_selected( windows_list->currentItem());
    }

void win_dialog::add_win( Window w )
    {
    if( w != winId())
	{
	QString title = get_window_title( w );
	QString command = get_window_command( w );
	QString clas = get_window_class( w );
	if( window_titles.find( title + command + clas ))
	    return;
	else
	    window_titles.insert( title + command + clas,
		new QListViewItem( windows_list, title, command, clas ));
	if( last_autoact == w )
	    act_win( w );
	}

    }

void win_dialog::act_win( Window w )
    {
    if( w != winId())
	{
	QString title = get_window_title( w );
	QString command = get_window_command( w );
	QString clas = get_window_class( w );
	QListViewItem* new_pos = window_titles.find( title + command + clas );
	if( new_pos )
	    {
	    windows_list->setSelected( new_pos, true );
	    last_autoact = w;
	    }
	}
    }


QString win_dialog::get_window_command( Window w )
    {
    char** argv_ret;
    int argc_ret;
    if( XGetCommand( qt_xdisplay(), w, &argv_ret, &argc_ret ) == 0 ) // 0 means error
	return "";
    if( argv_ret == NULL )
	return "";
    QString ret( argv_ret[ 0 ] );
    for( int cnt = 1;
	 cnt < argc_ret;
	 ++cnt )
	{
	ret += ' ';
	ret += argv_ret[ cnt ];
	}
    XFreeStringList( argv_ret );
    return ret;
    }
    
QString win_dialog::get_window_title( Window w )
    {
    XTextProperty text_ret;
    char** list_ret;
    int list_cnt;
    if( XGetWMName( qt_xdisplay(), w, &text_ret ) == 0 ) // 0 means error
	return "";  // CHECKME ?? KWM_WIN_TITLE ???
    if( XmbTextPropertyToTextList( qt_xdisplay(), &text_ret, &list_ret, &list_cnt ) != Success )
	return "";
    QString ret;
    for( int cnt = 0;
         cnt < list_cnt;
         ++cnt )
        ret += list_ret[ cnt ];
    XFreeStringList( list_ret );
    return ret;
    }
    

QString win_dialog::get_window_class( Window w )
    {
    XClassHint hints_ret;
    if( XGetClassHint( qt_xdisplay(), w, &hints_ret ) == 0 ) // 0 means error
	return "";
    QString ret( hints_ret.res_name );
    ret += ' ';
    ret += hints_ret.res_class;
    XFree( hints_ret.res_name );
    XFree( hints_ret.res_class );
    return ret;
    }
