/*
 * main_widget.cpp
 *
 * Copyright (C) 1999 Lubos Lunak <l.lunak@email.cz>
 */

#include "kcmhotkeys.h"
#include <qtooltip.h>
#include <qheader.h>

// Generated by QArchitect :)
KHKWidget::KHKWidget( QWidget* parent )
    : QWidget( parent ), last_index( NULL ), ignore( false )
    {
	
	QVBoxLayout* vlayout = new QVBoxLayout( this, 5, 0 );

	QHBoxLayout* hlayout = new QHBoxLayout( 10 );
	vlayout->addLayout( hlayout, 1 );
	
	QVBoxLayout* listbox_holder = new QVBoxLayout;
	hlayout->addLayout( listbox_holder, 1 );

	QLabel* qtarch_label_actions;
	qtarch_label_actions = new QLabel( this, "label_actions" );
	qtarch_label_actions->setGeometry( 0, 0, 70, 10 );
	qtarch_label_actions->setFixedSize( 70, 15 );
	qtarch_label_actions->setFocusPolicy( QWidget::NoFocus );
	qtarch_label_actions->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_label_actions->setFontPropagation( QWidget::NoChildren );
	qtarch_label_actions->setPalettePropagation( QWidget::NoChildren );
	qtarch_label_actions->setText( i18n("Actions :" ));
	qtarch_label_actions->setAlignment( 289 );
	qtarch_label_actions->setMargin( -1 );
	listbox_holder->addWidget( qtarch_label_actions, 0, AlignLeft );

	actions_list = new QListView( this, "actions_listbox" );
	actions_list->setMinimumSize( 150, 200 );
	connect( actions_list, SIGNAL(currentChanged(QListViewItem*)), SLOT(got_highlight(QListViewItem*)) );
	actions_list->setFocusPolicy( QWidget::StrongFocus );
	actions_list->setBackgroundMode( QWidget::PaletteBackground );
//	actions_list->setBackgroundMode( QWidget::PaletteBase );
	actions_list->setFontPropagation( QWidget::SameFont );
	actions_list->setPalettePropagation( QWidget::SameFont );
	actions_list->setFrameStyle( 51 );
//	actions_list->setLineWidth( 2 );
	actions_list->setMultiSelection( FALSE );
	actions_list->setResizePolicy( QScrollView::Manual );
	actions_list->setVScrollBarMode( QScrollView::Auto );
	actions_list->setHScrollBarMode( QScrollView::Auto );
	actions_list->setTreeStepSize( 0 );
	actions_list->setItemMargin( 1 );
	actions_list->setRootIsDecorated( FALSE );
	actions_list->addColumn( i18n( "Name"), -1 );
	actions_list->setColumnWidthMode( 0, QListView::Manual );
	actions_list->setColumnAlignment( 0, 1 );
	actions_list->setColumnWidth( 0, 170 );
	actions_list->addColumn( i18n("Hotkey"), -1 );
	actions_list->setColumnWidthMode( 1, QListView::Manual );
	actions_list->setColumnAlignment( 1, 1 );
	actions_list->setColumnWidth( 1, 170 );
        actions_list->setSorting( 0 );
	actions_list->setAllColumnsShowFocus( true );
	QToolTip::add( actions_list->header(),
	    i18n( "Click on the column headers to sort either by action name or by hotkey" ));
	actions_list->header()->setMovingEnabled( false );
	listbox_holder->addWidget( actions_list, 1 );
	
	QGroupBox* groupbox_action;
	groupbox_action = new QGroupBox( this, "groupbox_action" );
	hlayout->addWidget( groupbox_action, 4 );
	groupbox_action->setFocusPolicy( QWidget::NoFocus );
	groupbox_action->setBackgroundMode( QWidget::PaletteBackground );
	groupbox_action->setFontPropagation( QWidget::NoChildren );
	groupbox_action->setPalettePropagation( QWidget::NoChildren );
	groupbox_action->setFrameStyle( 49 );
	groupbox_action->setTitle( i18n("Action") );
	groupbox_action->setAlignment( 1 );
	
	QGridLayout* action_layout = new QGridLayout( groupbox_action, 20, 7 );
	action_layout->addRowSpacing( 0, 15 );
	action_layout->setRowStretch( 0, 0 );
	action_layout->setRowStretch( 1, 0 );
	action_layout->setRowStretch( 2, 0 );
	action_layout->addRowSpacing( 3, 5 );
	action_layout->setRowStretch( 3, 1 );
	action_layout->setRowStretch( 4, 0 );
	action_layout->setRowStretch( 5, 0 );
	action_layout->addRowSpacing( 6, 5 );
	action_layout->setRowStretch( 6, 1 );
	action_layout->setRowStretch( 7, 0 );
	action_layout->setRowStretch( 8, 0 );
	action_layout->addRowSpacing( 9, 5 );
	action_layout->setRowStretch( 9, 1 );
	action_layout->setRowStretch( 10, 0 );
	action_layout->setRowStretch( 11, 0 );
	action_layout->addRowSpacing( 12, 5 );
	action_layout->setRowStretch( 12, 1 );
	action_layout->setRowStretch( 13, 0 );
	action_layout->setRowStretch( 14, 0 );
	action_layout->addRowSpacing( 15, 5 );
	action_layout->setRowStretch( 15, 1 );
	action_layout->setRowStretch( 16, 0 );
	action_layout->setRowStretch( 17, 0 );
	action_layout->addRowSpacing( 17, 5 );
	action_layout->setRowStretch( 17, 1 );
	action_layout->setRowStretch( 19, 0 );
	action_layout->addRowSpacing( 19, 10 );
	action_layout->setRowStretch( 19, 0 );

	action_layout->setColStretch( 0, 0 );
	action_layout->addColSpacing( 0, 10 );
	action_layout->setColStretch( 1, 3 );
	action_layout->addColSpacing( 2, 10 );
	action_layout->setColStretch( 2, 0 );
	action_layout->setColStretch( 3, 3 );
	action_layout->addColSpacing( 3, 165 );
	action_layout->addColSpacing( 4, 10 );
	action_layout->setColStretch( 4, 0 );
	action_layout->setColStretch( 5, 1 );
	action_layout->addColSpacing( 5, 100 );
	action_layout->setColStretch( 6, 0 );
	action_layout->addColSpacing( 6, 10 );
	
	QLabel* qtarch_label_action_name;
	qtarch_label_action_name = new QLabel( groupbox_action, "label_action_name" );
	qtarch_label_action_name->setMinimumSize( 110, 30 );
	qtarch_label_action_name->setFocusPolicy( QWidget::NoFocus );
	qtarch_label_action_name->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_label_action_name->setFontPropagation( QWidget::NoChildren );
	qtarch_label_action_name->setPalettePropagation( QWidget::NoChildren );
	qtarch_label_action_name->setText( i18n("Action name :" ));
	qtarch_label_action_name->setAlignment( 289 );
	qtarch_label_action_name->setMargin( -1 );
	action_layout->addMultiCellWidget( qtarch_label_action_name, 1, 1, 1, 3, AlignLeft );

	action_name = new QLineEdit( groupbox_action, "action_name_w" );
	action_name->setMinimumSize( 150, 30 );
	connect( action_name, SIGNAL(textChanged(const char*)), SLOT(action_name_changed(const char*)) );
	action_name->setFocusPolicy( QWidget::StrongFocus );
	action_name->setBackgroundMode( QWidget::PaletteBase );
	action_name->setFontPropagation( QWidget::NoChildren );
	action_name->setPalettePropagation( QWidget::NoChildren );
	action_name->setText( "" );
	action_name->setMaxLength( 32767 );
	action_name->setEchoMode( QLineEdit::Normal );
	action_name->setFrame( TRUE );
	action_layout->addMultiCellWidget( action_name, 2, 2, 1, 3 );

	combo_runcommand = new QComboBox( FALSE, groupbox_action, "ComboBox_1" );
	combo_runcommand->setMinimumSize( 150, 25 );
 	connect( combo_runcommand, SIGNAL(highlighted(int)), SLOT(action_usecommand_changed(int)) );
	combo_runcommand->setFocusPolicy( QWidget::StrongFocus );
	combo_runcommand->setBackgroundMode( QWidget::PaletteBackground );
	combo_runcommand->setFontPropagation( QWidget::AllChildren );
	combo_runcommand->setPalettePropagation( QWidget::AllChildren );
	combo_runcommand->setSizeLimit( 10 );
	combo_runcommand->setAutoResize( FALSE );
	combo_runcommand->insertItem( i18n("Command to execute" ));
	combo_runcommand->insertItem( i18n("URL to execute" ));
	combo_runcommand->insertItem( i18n("Macro to execute" ));
	action_layout->addMultiCellWidget( combo_runcommand, 4, 4, 1, 3 );

	action_runcommand = new QLineEdit( groupbox_action, "action_runcommand_w" );
	action_runcommand->setMinimumSize( 150, 30 );
	action_runcommand->setFocusPolicy( QWidget::StrongFocus );
	action_runcommand->setBackgroundMode( QWidget::PaletteBase );
	action_runcommand->setFontPropagation( QWidget::NoChildren );
	action_runcommand->setPalettePropagation( QWidget::NoChildren );
	action_runcommand->setText( "" );
	action_runcommand->setMaxLength( 32767 );
	action_runcommand->setEchoMode( QLineEdit::Normal );
	action_runcommand->setFrame( TRUE );
	action_layout->addMultiCellWidget( action_runcommand, 5, 5, 1, 3 );

	button_browse = new QPushButton( groupbox_action, "browse_runcommand" );
	button_browse->setMinimumSize( 100, 30 );
	button_browse->setMaximumSize( 150, 30 );
	connect( button_browse, SIGNAL(clicked()), SLOT(action_runcommand_browse()) );
	button_browse->setFocusPolicy( QWidget::TabFocus );
	button_browse->setBackgroundMode( QWidget::PaletteBackground );
	button_browse->setFontPropagation( QWidget::NoChildren );
	button_browse->setPalettePropagation( QWidget::NoChildren );
	button_browse->setText( i18n( "Browse..." ));
	button_browse->setAutoRepeat( FALSE );
	button_browse->setAutoResize( FALSE );
	action_layout->addWidget( button_browse, 5, 5, AlignCenter );

 	button_guess = new QPushButton( groupbox_action, "PushButton_11" );
	button_guess->setMinimumSize( 100, 30 );
	button_guess->setMaximumSize( 150, 30 );
 	connect( button_guess, SIGNAL(clicked()), SLOT(guess_pressed()) );
 	button_guess->setFocusPolicy( QWidget::TabFocus );
 	button_guess->setBackgroundMode( QWidget::PaletteBackground );
 	button_guess->setFontPropagation( QWidget::NoChildren );
 	button_guess->setPalettePropagation( QWidget::NoChildren );
 	button_guess->setText( i18n("&Autodetect" ));
 	button_guess->setAutoRepeat( FALSE );
 	button_guess->setAutoResize( FALSE );
	QToolTip::add( button_guess, i18n( "Press this button to let KHotKeys try finding the parameters ( window properties ) automatically")); 
	action_layout->addWidget( button_guess, 2, 5, AlignCenter );
 
	combo_action_command = new QComboBox( FALSE, groupbox_action, "ComboBox_4" );
	combo_action_command->setMinimumSize( 150, 25 );
	connect( combo_action_command, SIGNAL(highlighted(int)), SLOT(action_command_toggle(int)) );
	combo_action_command->setFocusPolicy( QWidget::StrongFocus );
	combo_action_command->setBackgroundMode( QWidget::PaletteBackground );
	combo_action_command->setFontPropagation( QWidget::AllChildren );
	combo_action_command->setPalettePropagation( QWidget::AllChildren );
	combo_action_command->setSizeLimit( 10 );
	combo_action_command->setAutoResize( FALSE );
	combo_action_command->insertItem( i18n("Window command is not significant" ));
	combo_action_command->insertItem( "" );
	combo_action_command->insertItem( "" );
	action_layout->addMultiCellWidget( combo_action_command, 7, 7, 1, 5 );

	action_command = new QLineEdit( groupbox_action, "action_command_w" );
	action_command->setMinimumSize( 150, 30 );
	action_command->setFocusPolicy( QWidget::StrongFocus );
	action_command->setBackgroundMode( QWidget::PaletteBase );
	action_command->setFontPropagation( QWidget::NoChildren );
	action_command->setPalettePropagation( QWidget::NoChildren );
	action_command->setText( "" );
	action_command->setMaxLength( 32767 );
	action_command->setEchoMode( QLineEdit::Normal );
	action_command->setFrame( TRUE );
	action_layout->addMultiCellWidget( action_command, 8, 8, 1, 5 );
	
/*	button_autofill = new QPushButton( groupbox_action, "button_autofill" );
	button_autofill->setMinimumSize( 100, 30 );
	button_autofill->setMaximumSize( 150, 30 );
	connect( button_autofill, SIGNAL(clicked()), SLOT(autofill_pressed()) );
	button_autofill->setFocusPolicy( QWidget::TabFocus );
	button_autofill->setBackgroundMode( QWidget::PaletteBackground );
	button_autofill->setFontPropagation( QWidget::NoChildren );
	button_autofill->setPalettePropagation( QWidget::NoChildren );
	button_autofill->setText( i18n("Auto&fill" ));
	button_autofill->setAutoRepeat( FALSE );
	button_autofill->setAutoResize( FALSE );
	action_layout->addWidget( button_autofill, 8, 5, AlignCenter );*/

	combo_action_title = new QComboBox( FALSE, groupbox_action, "ComboBox_3" );
	combo_action_title->setMinimumSize( 150, 25 );
	connect( combo_action_title, SIGNAL(highlighted(int)), SLOT(action_title_toggle(int)) );
	combo_action_title->setFocusPolicy( QWidget::StrongFocus );
	combo_action_title->setBackgroundMode( QWidget::PaletteBackground );
	combo_action_title->setFontPropagation( QWidget::AllChildren );
	combo_action_title->setPalettePropagation( QWidget::AllChildren );
	combo_action_title->setSizeLimit( 10 );
	combo_action_title->setAutoResize( FALSE );
	combo_action_title->insertItem( i18n("Window title is not significant" ));
	combo_action_title->insertItem( "" );
	combo_action_title->insertItem( "" );
	action_layout->addMultiCellWidget( combo_action_title, 10, 10, 1, 5 );
	
	action_title = new QLineEdit( groupbox_action, "action_title_w" );
	action_title->setMinimumSize( 150, 30 );
	action_title->setFocusPolicy( QWidget::StrongFocus );
	action_title->setBackgroundMode( QWidget::PaletteBase );
	action_title->setFontPropagation( QWidget::NoChildren );
	action_title->setPalettePropagation( QWidget::NoChildren );
	action_title->setText( "" );
	action_title->setMaxLength( 32767 );
	action_title->setEchoMode( QLineEdit::Normal );
	action_title->setFrame( TRUE );
	action_layout->addMultiCellWidget( action_title, 11, 11, 1, 5 );

	combo_action_class = new QComboBox( FALSE, groupbox_action, "ComboBox_2" );
	combo_action_class->setMinimumSize( 150, 25 );
	connect( combo_action_class, SIGNAL(highlighted(int)), SLOT(action_class_toggle(int)) );
	combo_action_class->setFocusPolicy( QWidget::StrongFocus );
	combo_action_class->setBackgroundMode( QWidget::PaletteBackground );
	combo_action_class->setFontPropagation( QWidget::AllChildren );
	combo_action_class->setPalettePropagation( QWidget::AllChildren );
	combo_action_class->setSizeLimit( 10 );
	combo_action_class->setAutoResize( FALSE );
	combo_action_class->insertItem( i18n("Window class is not significant" ));
	combo_action_class->insertItem( "" );
	combo_action_class->insertItem( "" );
	action_layout->addMultiCellWidget( combo_action_class, 13, 13, 1, 5 );

	action_class = new QLineEdit( groupbox_action, "action_class_w" );
	action_class->setMinimumSize( 150, 30 );
	action_class->setFocusPolicy( QWidget::StrongFocus );
	action_class->setBackgroundMode( QWidget::PaletteBase );
	action_class->setFontPropagation( QWidget::NoChildren );
	action_class->setPalettePropagation( QWidget::NoChildren );
	action_class->setText( "" );
	action_class->setMaxLength( 32767 );
	action_class->setEchoMode( QLineEdit::Normal );
	action_class->setFrame( TRUE );
	action_layout->addMultiCellWidget( action_class, 14, 14, 1, 5 );
	
	
	combo_win_search = new QComboBox( FALSE, groupbox_action, "ComboBox_2" );
	combo_win_search->setMinimumSize( 350, 25 );
	connect( combo_win_search, SIGNAL(highlighted(int)), SLOT(action_class_toggle(int)) );
	combo_win_search->setFocusPolicy( QWidget::StrongFocus );
	combo_win_search->setBackgroundMode( QWidget::PaletteBackground );
	combo_win_search->setFontPropagation( QWidget::AllChildren );
	combo_win_search->setPalettePropagation( QWidget::AllChildren );
	combo_win_search->setSizeLimit( 10 );
	combo_win_search->setAutoResize( FALSE );
	combo_win_search->insertItem( i18n("Search for any matching windows" ));
	combo_win_search->insertItem( i18n("Search only for windows created by this command" ));
	combo_win_search->insertItem( i18n("Search for the last active matching window" ));
	action_layout->addMultiCellWidget( combo_win_search, 16, 16, 1, 5 );

	button_hotkey = new QPushButton( groupbox_action, "change_button" );
	button_hotkey->setMinimumSize( 100, 30 );
	button_hotkey->setMaximumSize( 150, 30 );
	connect( button_hotkey, SIGNAL(clicked()), SLOT(action_hotkey_change()) );
	button_hotkey->setFocusPolicy( QWidget::TabFocus );
	button_hotkey->setBackgroundMode( QWidget::PaletteBackground );
	button_hotkey->setFontPropagation( QWidget::NoChildren );
	button_hotkey->setPalettePropagation( QWidget::NoChildren );
	button_hotkey->setText( i18n("&Hotkey..." ));
	button_hotkey->setAutoRepeat( FALSE );
	button_hotkey->setAutoResize( FALSE );
	action_layout->addWidget( button_hotkey, 18, 1, AlignCenter );
	
	action_hotkey_text = new QLineEdit( groupbox_action, "action_hotkey_text_w" );
	action_hotkey_text->setMinimumSize( 150, 30 );
	action_hotkey_text->setFocusPolicy( QWidget::NoFocus );
	action_hotkey_text->setBackgroundMode( QWidget::PaletteBase );
	action_hotkey_text->setFontPropagation( QWidget::NoChildren );
	action_hotkey_text->setPalettePropagation( QWidget::NoChildren );
	action_hotkey_text->setText( "" );
	action_hotkey_text->setMaxLength( 32767 );
	action_hotkey_text->setEchoMode( QLineEdit::Normal );
	action_hotkey_text->setFrame( TRUE );
	action_layout->addMultiCellWidget( action_hotkey_text, 18, 18, 3, 5 );
	QToolTip::add( action_hotkey_text, i18n( "Press the 'Hotkey' button to change the hotkey" ));

	QGroupBox* groupbox_global;
	groupbox_global = new QGroupBox( this, "groupbox_global" );
	vlayout->addWidget( groupbox_global, 0, AlignVCenter );
//	vlayout->addSpacing( 5 );
	groupbox_global->setFocusPolicy( QWidget::NoFocus );
	groupbox_global->setBackgroundMode( QWidget::PaletteBackground );
	groupbox_global->setFontPropagation( QWidget::NoChildren );
	groupbox_global->setPalettePropagation( QWidget::NoChildren );
	groupbox_global->setFrameStyle( 17 );
	groupbox_global->setTitle( i18n("Global" ));
	groupbox_global->setAlignment( 1 );

	QGridLayout* global_layout = new QGridLayout( groupbox_global, 3, 4, 5, 5 );
	global_layout->addRowSpacing( 0, 5 );
	global_layout->setRowStretch( 1, 1 );
	global_layout->setRowStretch( 2, 1 );
	global_layout->setColStretch( 0, 1 );
	global_layout->setColStretch( 1, 1 );
	global_layout->setColStretch( 2, 1 );
	global_layout->setColStretch( 3, 1 );

	QPushButton* qtarch_new_button;
	qtarch_new_button = new QPushButton( groupbox_global, "new_button" );
	qtarch_new_button->setMinimumSize( 100, 30 );
	qtarch_new_button->setMaximumSize( 150, 30 );
	connect( qtarch_new_button, SIGNAL(clicked()), SLOT(new_action()) );
	qtarch_new_button->setFocusPolicy( QWidget::TabFocus );
	qtarch_new_button->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_new_button->setFontPropagation( QWidget::NoChildren );
	qtarch_new_button->setPalettePropagation( QWidget::NoChildren );
	qtarch_new_button->setText( i18n("&New action" ));
	qtarch_new_button->setAutoRepeat( FALSE );
	qtarch_new_button->setAutoResize( FALSE );
	global_layout->addWidget( qtarch_new_button, 1, 0, AlignCenter );

	copy_button = new QPushButton( groupbox_global, "copy_button" );
	copy_button->setMinimumSize( 100, 30 );
	copy_button->setMaximumSize( 150, 30 );
	connect( copy_button, SIGNAL(clicked()), SLOT(copy_action()) );
	copy_button->setFocusPolicy( QWidget::TabFocus );
	copy_button->setBackgroundMode( QWidget::PaletteBackground );
	copy_button->setFontPropagation( QWidget::NoChildren );
	copy_button->setPalettePropagation( QWidget::NoChildren );
	copy_button->setText( i18n("&Copy action" ));
	copy_button->setAutoRepeat( FALSE );
	copy_button->setAutoResize( FALSE );
	global_layout->addWidget( copy_button, 2, 0, AlignCenter );

	delete_button = new QPushButton( groupbox_global, "delete_button" );
	delete_button->setMinimumSize( 100, 30 );
	delete_button->setMaximumSize( 150, 30 );
	connect( delete_button, SIGNAL(clicked()), SLOT(delete_action()) );
	delete_button->setFocusPolicy( QWidget::TabFocus );
	delete_button->setBackgroundMode( QWidget::PaletteBackground );
	delete_button->setFontPropagation( QWidget::NoChildren );
	delete_button->setPalettePropagation( QWidget::NoChildren );
	delete_button->setText( i18n("&Delete action" ));
	delete_button->setAutoRepeat( FALSE );
	delete_button->setAutoResize( FALSE );
	global_layout->addWidget( delete_button, 1, 1, AlignCenter );

/*	QPushButton* qtarch_PushButton_6;
	qtarch_PushButton_6 = new QPushButton( groupbox_global, "PushButton_6" );
	qtarch_PushButton_6->setMinimumSize( 100, 30 );
	qtarch_PushButton_6->setMaximumSize( 150, 30 );
	connect( qtarch_PushButton_6, SIGNAL(clicked()), SLOT(start_button_clicked()) );
	qtarch_PushButton_6->setFocusPolicy( QWidget::TabFocus );
	qtarch_PushButton_6->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_PushButton_6->setFontPropagation( QWidget::NoChildren );
	qtarch_PushButton_6->setPalettePropagation( QWidget::NoChildren );
	qtarch_PushButton_6->setText( i18n("Start KHotKeys" ));
	qtarch_PushButton_6->setAutoRepeat( FALSE );
	qtarch_PushButton_6->setAutoResize( FALSE );
	global_layout->addWidget( qtarch_PushButton_6, 1, 1, AlignCenter );

	QPushButton* qtarch_PushButton_7;
	qtarch_PushButton_7 = new QPushButton( groupbox_global, "PushButton_7" );
	qtarch_PushButton_7->setMinimumSize( 100, 30 );
	qtarch_PushButton_7->setMaximumSize( 150, 30 );
	connect( qtarch_PushButton_7, SIGNAL(clicked()), SLOT(end_button_clicked()) );
	qtarch_PushButton_7->setFocusPolicy( QWidget::TabFocus );
	qtarch_PushButton_7->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_PushButton_7->setFontPropagation( QWidget::NoChildren );
	qtarch_PushButton_7->setPalettePropagation( QWidget::NoChildren );
	qtarch_PushButton_7->setText( i18n("End KHotKeys" ));
	qtarch_PushButton_7->setAutoRepeat( FALSE );
	qtarch_PushButton_7->setAutoResize( FALSE );
	global_layout->addWidget( qtarch_PushButton_7, 2, 1, AlignCenter );*/

	button_reset_status = new QPushButton( groupbox_global, "PushButton_8" );
	button_reset_status->setMinimumSize( 100, 30 );
	button_reset_status->setMaximumSize( 150, 30 );
	connect( button_reset_status, SIGNAL(clicked()), SLOT(reset_button_change()) );
	button_reset_status->setFocusPolicy( QWidget::TabFocus );
	button_reset_status->setBackgroundMode( QWidget::PaletteBackground );
	button_reset_status->setFontPropagation( QWidget::NoChildren );
	button_reset_status->setPalettePropagation( QWidget::NoChildren );
	button_reset_status->setText( i18n("Reset hotkey..." ));
	button_reset_status->setAutoRepeat( FALSE );
	button_reset_status->setAutoResize( FALSE );
	global_layout->addWidget( button_reset_status, 1, 2, AlignCenter );

	reset_hotkey_text = new QLineEdit( groupbox_global, "LineEdit_9" );
	reset_hotkey_text->setMinimumSize( 100, 30 );
	reset_hotkey_text->setFocusPolicy( QWidget::NoFocus );
	reset_hotkey_text->setBackgroundMode( QWidget::PaletteBase );
	reset_hotkey_text->setFontPropagation( QWidget::NoChildren );
	reset_hotkey_text->setPalettePropagation( QWidget::NoChildren );
	reset_hotkey_text->setText( "" );
	reset_hotkey_text->setMaxLength( 32767 );
	reset_hotkey_text->setEchoMode( QLineEdit::Normal );
	reset_hotkey_text->setFrame( TRUE );
	QToolTip::add( reset_hotkey_text, i18n( "Press the 'Reset hotkey' button to change the hotkey" ));
	global_layout->addWidget( reset_hotkey_text, 1, 3, AlignCenter );

	QLabel* qtarch_label_execute;
	qtarch_label_execute = new QLabel( groupbox_global, "label_execute" );
	qtarch_label_execute->setMinimumSize( 100, 30 );
	qtarch_label_execute->setMaximumSize( 200, 30 );
	qtarch_label_execute->setFocusPolicy( QWidget::NoFocus );
	qtarch_label_execute->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_label_execute->setFontPropagation( QWidget::NoChildren );
	qtarch_label_execute->setPalettePropagation( QWidget::NoChildren );
	qtarch_label_execute->setText( i18n("Execute timeout :" ));
	qtarch_label_execute->setAlignment( AlignCenter );
	qtarch_label_execute->setMargin( -1 );
	global_layout->addWidget( qtarch_label_execute, 2, 2, AlignCenter );

	execute_timeout = new QLineEdit( groupbox_global, "LineEdit_7" );
	execute_timeout->setMinimumSize( 100, 30 );
	execute_timeout->setFocusPolicy( QWidget::StrongFocus );
	execute_timeout->setBackgroundMode( QWidget::PaletteBase );
	execute_timeout->setFontPropagation( QWidget::NoChildren );
	execute_timeout->setPalettePropagation( QWidget::NoChildren );
	execute_timeout->setText( "" );
	execute_timeout->setMaxLength( 20 );
	execute_timeout->setEchoMode( QLineEdit::Normal );
	execute_timeout->setFrame( TRUE );
	global_layout->addWidget( execute_timeout, 2, 3, AlignCenter );

	QDoubleValidator* val = new QDoubleValidator( execute_timeout );
	val->setRange( 0, 600000 );
	execute_timeout->setValidator( val );

	action_layout->activate();
	global_layout->activate();
	vlayout->activate();
	action_name->setValidator( new QHKValidator( action_name ));
    }

