#ifndef MACRO_DIALOG_H 
#define MACRO_DIALOG_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qdialog.h>
#include <qlistbox.h>
#include <kaccel.h>
#include <kkeydialog.h>
#include <qvector.h>

class QListBox_ign // fixes a little bug in Qt
    : public QListBox
    {
    public:
	QListBox_ign( QWidget* );
    protected:
    virtual void keyPressEvent( QKeyEvent *e );
    };

class KKeyChooser_ign // fixes a little bug in Qt
    : public KKeyChooser
    {
    public:
	KKeyChooser_ign( QDict<KKeyEntry> *aKeyDict, QWidget *parent = 0,
		     bool check_against_std_keys = false);
    protected:
    virtual void keyPressEvent( QKeyEvent *e );
    };


class macro_dialog
    : public QDialog
    {
    Q_OBJECT
    public:
	macro_dialog( const QString& );
	QString get_macro_text() const;
    protected slots:
        void ok_pressed();
        void new_pressed();
        void delete_pressed();
        void moveup_pressed();
        void movedown_pressed();
	void highlighted(int);
    protected:
	void check_enabled();
	KKeyEntry* make_key_entry( const QString& name_P, uint keycode_P );
	QListBox* macro_list;
	KKeyChooser* keys;
	QPushButton* delete_button;
	QPushButton* moveup_button;
	QPushButton* movedown_button;
	QDict< KKeyEntry > dict;
	int previous_pos;
	QString ret_macro_text;
    };

// Inline

inline
QListBox_ign::QListBox_ign( QWidget* parent )
    : QListBox( parent )
    {
    }

inline
KKeyChooser_ign::KKeyChooser_ign( QDict<KKeyEntry> *aKeyDict, QWidget *parent,
    bool check_against_std_keys )
    : KKeyChooser( aKeyDict, parent, check_against_std_keys )
    {
    }

inline
QString macro_dialog::get_macro_text() const
    {
    return ret_macro_text;
    }

#endif
