/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include <qdom.h>
#include <qtextstream.h>
#include <qstring.h>

#include "savetobibtex.h"



void 
SaveToBibtex::save( QDomElement firstEntry, QTextStream &out )
{
    for ( ; !firstEntry.isNull(); firstEntry = firstEntry.nextSibling().toElement() )
	saveEntry( firstEntry, out );
 
}

    
void 
SaveToBibtex::saveEntry( QDomElement entry, QTextStream &out )
{
    QString tmp;
    
    // write entry type
    out << "@";
    out << entry.tagName().lower() << "{";
    
    // write label
    out << entry.attribute( "label" ) << ",\n";
    
    // write entry fields
    QDomElement entryField = entry.firstChild().toElement();
    for ( ; !entryField.isNull(); entryField = entryField.nextSibling().toElement() ){
	out << "  " << entryField.tagName().lower() << " = {";
	out << entryField.firstChild().nodeValue();
	out << "},\n";
    }
    
    // closing bracket
    out << "}\n" << endl;
}












