#include <qfiledlg.h>
#include <qfiledef.h>
#include <qwidget.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <kwm.h>
#include <kkeyconf.h>
#include <kmsgbox.h>
#include "ksimpledlg.h"
#include "kdepopup.h"

#define SMB_BUFSIZE	65536

Window w;

kdepopup :: kdepopup(QWidget *parent, const char *name)
	: KTopLevelWidget(name)

{
char pa[1024];

	menubar=new KMenuBar(this);
	fileMenu=new QPopupMenu;
	menubar->insertItem(i18n("&File"),fileMenu);
	fileMenu->insertItem(i18n("&New message"),this,SLOT(newsmbw()),CTRL + Key_N);
	fileMenu->insertSeparator();
	fileMenu->insertItem(i18n("&Close"),this,SLOT(iconify()),CTRL + Key_W);
	fileMenu->insertItem(i18n("&Quit"),KApplication::getKApplication(),
		SLOT(quit()),CTRL + Key_Q);
	QString at="kdepopup 0.1.3";
	at+=i18n("\n\nRolf Jakob (rjakob@duffy1.franken.de)\n\nutility to send and receive SMB messages for the KDE Desktop Environment");
	helpMenu = kapp->getHelpMenu(true, at.data());
	menubar->insertItem(i18n("&Help"),helpMenu);

	menubar->show();
	setMenu(menubar);

/*
	statusbar=new KStatusBar(this);
	statusbar->insertItem("Status",1);
	statusbar->show();
	setStatusBar(statusbar);
*/

	label=new QLabel(this);
//	label->setText("fasel");
	sprintf(pa,"%s/kdepopup/sambaani64.gif",
		kapp->kde_datadir().data());
	label->setPixmap(pa); 	label->setAlignment(AlignCenter);
	label->setMargin(10); 	label->resize(label->sizeHint());
	label->move(0,menubar->height());
//	setView(label);
	resize(label->width(),label->height()+menubar->height());

	sock=new KServerSocket(4414);
	connect(sock,SIGNAL(accepted(KSocket *)),SLOT(sock_conn(KSocket *)));
}


kdepopup :: ~kdepopup()
{
}


void kdepopup :: newsmbw()
{
	kw=new ksmbWindow(0,0,0,1);
	kw->setCaption(i18n("New message"));
	
}

ksmbWindow :: ksmbWindow(QWidget *parent, const char *name,QMultiLineEdit *olist,
	int flag, char *ofrom, char *oto, char *ohost)
{
	from=new char[1024];
	to=new char[1024];
	host=new char[1024];
	date=new char[1024];
	if (ofrom) strcpy(from,ofrom); else *from=0;
	if (oto) strcpy(to,oto); else *to=0;
	if (ohost) strcpy(host,ohost); else *host=0;

	menubar=new KMenuBar(this);
	fileMenu=new QPopupMenu;
	menubar->insertItem(i18n("&File"),fileMenu);
	if (flag) {
		fileMenu->insertItem(i18n("&Host..."),this,SLOT(edithost()),CTRL + Key_H);
		fileMenu->insertItem(i18n("&Send"),this,SLOT(msgsend()),CTRL + Key_D);
	} else {
		fileMenu->insertItem(i18n("&Reply"),this,SLOT(answer()),CTRL + Key_R);
		fileMenu->insertItem(i18n("&Save"),this,SLOT(msgsave()),CTRL + Key_S);
	}
	fileMenu->insertItem(i18n("C&lear"),this,SLOT(msgclear()),CTRL + Key_L);
	fileMenu->insertItem(i18n("&Font ..."),this,SLOT(selectfont()));
	fileMenu->insertSeparator();
	fileMenu->insertItem(i18n("&Close"),this,SLOT(close()),CTRL + Key_W);
	menubar->show();
	setMenu(menubar);

	statusbar=new KStatusBar(this);
	statusbar->insertItem(i18n("Status"),1);
	statusbar->show();
	setStatusBar(statusbar);

	textw=new QMultiLineEdit(this);
	if (!flag)
		textw->setReadOnly(TRUE);

	KConfig *config=kapp->getConfig();
	config->setGroup("kdepopup");
	myfont=config->readFontEntry("font");
	textw->setFont(myfont);
	textw->setAutoUpdate(TRUE);
	setView(textw);
	if (olist) fill(olist);
	show();

}

void ksmbWindow :: answer()
{
	kw=new ksmbWindow(0,0,textw,1,from,to,host);
}

void ksmbWindow :: msgclear()
{
	textw->clear();
}

void ksmbWindow :: selectfont()
{
	KConfig *config=kapp->getConfig();
	config->setGroup("kdepopup");
	KFontDialog::getFont(myfont);
	config->writeEntry("font",myfont);
	config->sync();
	textw->setFont(myfont);
}

void ksmbWindow :: msgsave()
{
	msgsavef();
}

void ksmbWindow :: edithost()
{
char buffer[128];

	ksimpledialog *ho=new ksimpledialog(0,i18n("Enter hostname to send message to"),TRUE);
//	ksimpledialog *ho=new ksimpledialog;
	ho->setlabel(i18n("Enter hostname to send message to"));
	ho->setvalue(host);
	ho->exec();
	strcpy(host,ho->getvalue());
	delete ho;
	sprintf(buffer,i18n("New message to %s"),host);
	setCaption(buffer);

}

void ksmbWindow :: msgsavef(QString *filename=0)
{

#define MAXLENGTH	1602

int i,fd,do_del;
char p[MAXLENGTH];

	do_del=0;
	if (!filename) {
		filename=new QString(KFileDialog::getSaveFileName("",
		"*",0,"save message to ..."));
		do_del=1;
		}

	if (!filename->isEmpty()) {
		fd=::open(filename->data(),O_WRONLY|O_CREAT|O_TRUNC,0666);
		if (fd>=0) {
			for (i=0;i<textw->numLines();i++) {
				snprintf(p,MAXLENGTH-1,"%s\n",textw->textLine(i));
				::write(fd,p,strlen(p));
				}
			::close(fd);
			}
		} else {
			printf("not opened\n");
		}
	if (do_del) delete filename;
}

ksmbWindow :: fill(QMultiLineEdit *list)
{
int i;
char buffer[1024];

	for (i=0;i<list->numLines();i++) {
		sprintf(buffer,"> %s",list->textLine(i));
		textw->insertLine(buffer);
		}
	sprintf(buffer,i18n("Reply to message from %s at %s to %s"),from,host,to);
	setCaption(buffer);
}

ksmbWindow :: ~ksmbWindow()
{
	delete from,to,host;
	delete statusbar;
	delete fileMenu;
	delete menubar;
}

void ksmbWindow :: msgsend()
{
char buf[1024],msg[1024],addmsg[1024];
int rc,hrc,lrc;

	statusbar->changeItem("sending ...",1);
	kapp->processEvents();

	QString *filen=new QString("/tmp/kdepopup.tmp");
	msgsavef(filen);
	sprintf(buf,"sh -c \"smbclient -M %s < %s\"",host,filen->data());
	rc=system(buf);
	if (rc) {
		statusbar->changeItem("sending failed",1);
		hrc=rc/256; lrc=rc%256;
		if (hrc>128) sprintf(addmsg,"\n(killed by signal %d)",hrc-128);
		sprintf(msg,"send message failed\nsmbclient returned %d (%d/%d)%s",
			rc,hrc,lrc,addmsg);
		KMsgBox :: message(this,i18n("kdepopup error"),msg,
			KMsgBox::STOP,i18n("Oops"));
	}
	delete filen;
	if (!rc) close();
}

void ksmbWindow :: close()
{
	delete this;
}
 
void kdepopup :: iconify()
{
	KWM::setIconify(w,TRUE);
}

void ksmbWindow :: readfromsocket(KSocket *k)
{
int rc,s;
char *p,*q;

	char *buf=new char[SMB_BUFSIZE+1];
//	KWM::activate(w);
	s=k->socket();
	p=buf;
	while (1) {
		rc=read(s,p,SMB_BUFSIZE-(p-buf));
		*(p+rc)=0;
		if (!rc || rc<0) break;
		p+=rc;
		}

//	KMsgBox :: message(this,"debug",buf);

	p=buf;
	while(*p) {

	if (p && !strncmp(p,"DATE:",5)) {
		q=p+5; p=strchr(q,'\n');
		if (p) *p++=0;
		strcpy(date,q);
		continue;
		}
	if (p && !strncmp(p,"FROM:",5)) {
		q=p+5; p=strchr(q,'\n');
		if (p) *p++=0;
		strcpy(from,q);
		continue;
		}
	if (p && !strncmp(p,"TO:",3)) {
		q=p+3; p=strchr(q,'\n');
		if (p) *p++=0;
		strcpy(to,q);
		continue;
		}
	if (p && !strncmp(p,"HOST:",5)) {
		q=p+5; p=strchr(q,'\n');
		if (p) *p++=0;
		strcpy(host,q);
		continue;
		}
	textw->insertLine(p);
	break;

	}

	sprintf(buf,i18n("Message from %s at %s to %s %s"),from,host,to,date);
	setCaption(buf);
	delete buf;
}

void kdepopup :: sock_conn(KSocket *k)
{
int rc,s;
// char *p,*q,from[128],to[128],host[128];

	kw=new ksmbWindow();
	kw->readfromsocket(k);

	delete k;

}

int main(int argc, char* argv[])
{
int rc;

	KApplication *app=new KApplication(argc,argv);

	kdepopup *smb=new kdepopup;

	if (app->isRestored()) {
		if (KTopLevelWidget::canBeRestored(1)) {
			smb->restore(1);
			}
	}

	app->setMainWidget(smb);
	smb->show();

//	w=KWM::activeWindow();

//	iconifying was a problem on KDE startup (got an invalid window parameter)
//	KWM::setIconify(w,TRUE);
//	printf("window iconified\n");
//	fflush(stdout);

	rc=app->exec();

	return(rc);
}

