/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [status.h]                  Status Line                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

/* Plan
   - different states
     - welcome.
     - terminating
     - disconnected
     - connected
     - file transfer
*/

#ifndef __STATUS_H
#define __STATUS_H

#include <qwidget.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include <qdatetm.h>
#include <kprogress.h>
#include <qtooltip.h>

#include "zmodem.h"

class StatusLine : public QFrame
{
  Q_OBJECT
public:
  StatusLine(QWidget *parent=0, const char *name=0);
  ~StatusLine();

  setStatus(char* text);
  setValue(int val);

public slots:
  // Related to zmodem transfer
  void ZmodemEvent(Zmodem::EventType event, const char *text, long value);
  void setConnect(bool);

private:
  // appearence
  QBoxLayout* gm;
  QLabel* status;
  QLabel* connected;
  KProgress* progress;
  // zmodem transfer
  void    fileinfo();
  QTime   clock;
  QString filename;
  long    bytesTotal;
  long    bytesFile;
  long    bytesDone;
  long    startTime;
  long    errors;      // better 'very short' type?
  char*   direction;
};

#endif // STATUS_H
