/*
 * This code is auto-generated from Wikidata data. Licensed under CC0.
 */

#include "knowledgedb.h"
#include "timezonedb.h"
#include "trainstationdb.h"
#include "timezonedb_data_p.h"

namespace KItinerary {
namespace KnowledgeDb {
static const TrainStation trainstation_table[] = {
    {Coordinate{19.0994, 47.4656}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ferencváros railway station
    {Coordinate{16.5878, 47.6778}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sopron railway station
    {Coordinate{-8.3124, 41.3791}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Q10275806
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q1032032
    {Coordinate{25.6481, 60.3964}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Porvoo railway station
    {Coordinate{24.4895, 64.6837}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Raahe railway station
    {Coordinate{24.9414, 60.171}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Helsinki Central Railway Station
    {Coordinate{24.8639, 60.2467}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Malminkartano railway station
    {Coordinate{11.5794, 58.5292}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Dingle railway station
    {Coordinate{24.1858, 56.9189}, Tz::Europe_Riga, CountryId{"LV"}}, // Jāņavārti Station
    {Coordinate{25.4064, 65.1961}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Haukipudas railway station
    {Coordinate{25.5547, 60.4081}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q10518700
    {Coordinate{9.96278, 53.4656}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heimfeld station
    {Coordinate{25.4411, 65.3186}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ii railway station
    {Coordinate{22.7147, 63.6744}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Pietarsaari railway station
    {Coordinate{25.6136, 60.4067}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kiiala train stop
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q10548421
    {Coordinate{25.1016, 60.457}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ainola railway station
    {Coordinate{23.2369, 59.9041}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q10554301
    {Coordinate{14.6164, 58.9892}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Laxå railway station
    {Coordinate{12.2728, 57.7694}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Lerum railway station
    {Coordinate{18.9611, 47.5358}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hárs-hegy
    {Coordinate{27.5792, 64.0647}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Murtomäki railway station
    {Coordinate{126.633, 45.7619}, Tz::Asia_Shanghai, CountryId{"CN"}}, // Harbin railway station
    {Coordinate{10.09, 46.6978}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zernez station
    {Coordinate{9.90556, 46.4856}, Tz::Europe_Zurich, CountryId{"CH"}}, // Surovas
    {Coordinate{10.0544, 46.3247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Poschiavo
    {Coordinate{10.0997, 46.2731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Miralago
    {Coordinate{8.40417, 46.5672}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muttbach-Belvédère Station
    {Coordinate{8.76972, 46.6811}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sedrun railway station
    {Coordinate{8.508, 47.3647}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Friesenberg railway station
    {Coordinate{8.62073, 46.9493}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sisikon railway station
    {Coordinate{7.95869, 46.7362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberried am Brienzersee railway station
    {Coordinate{7.99012, 46.7525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ebligen railway station
    {Coordinate{8.31, 46.982}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hergiswil railway station
    {Coordinate{8.303, 47.0351}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lucerne Allmend/Messe railway station
    {Coordinate{8.54448, 47.2867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langnau-Gattikon railway station
    {Coordinate{8.53508, 47.2967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wildpark-Höfli railway station
    {Coordinate{8.52522, 47.3032}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sihlau railway station
    {Coordinate{8.5215, 47.3197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sood-Oberleimbach railway station
    {Coordinate{8.87899, 47.3684}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bauma railway station
    {Coordinate{8.75207, 47.2359}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uerikon railway station
    {Coordinate{9.31, 46.8075}, Tz::Europe_Zurich, CountryId{"CH"}}, // Versam-Safien
    {Coordinate{9.70333, 46.7978}, Tz::Europe_Zurich, CountryId{"CH"}}, // Litzirüti
    {Coordinate{17.3156, 62.3867}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Sundsvall central station
    {Coordinate{17.2914, 62.3897}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Sundsvall western station
    {Coordinate{18.7044, 63.2893}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Örnsköldsvik central station
    {Coordinate{33.7542, 48.104}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q10853622
    {Coordinate{34.2374, 48.4825}, Tz::Europe_Kiev, CountryId{"UA"}}, // Verkhivtseve Railway Station
    {Coordinate{9.51236, 46.8498}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chur West
    {Coordinate{15.1, 37.5067}, Tz::Europe_Rome, CountryId{"IT"}}, // Catania Centrale railway station
    {Coordinate{6.39944, 46.4756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Allaman
    {Coordinate{6.87722, 46.448}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10947816
    {Coordinate{6.89542, 46.4428}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948043
    {Coordinate{6.82431, 46.4707}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948087
    {Coordinate{6.72722, 46.4885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948129
    {Coordinate{6.74528, 46.4893}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948238
    {Coordinate{7.02556, 46.1692}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948282
    {Coordinate{6.84361, 46.4631}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10948797
    {Coordinate{6.69056, 46.5039}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10949227
    {Coordinate{6.65917, 46.511}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pully railway station
    {Coordinate{6.78472, 46.4742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10950827
    {Coordinate{6.79694, 46.4725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10951147
    {Coordinate{7.00205, 46.2164}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10951368
    {Coordinate{6.92292, 46.4264}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952194
    {Coordinate{7.03833, 46.1386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952886
    {Coordinate{6.83556, 46.4682}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952909
    {Coordinate{6.92778, 46.4175}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10952911
    {Coordinate{6.70722, 46.4956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q10953216
    {Coordinate{13.3694, 52.5251}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Hauptbahnhof
    {Coordinate{8.53619, 47.5239}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bülach railway station
    {Coordinate{7.35005, 47.362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Delémont Station
    {Coordinate{24.9378, 58.7569}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q10987307
    {Coordinate{25.5467, 58.5453}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q10990043
    {Coordinate{19.0911, 47.4903}, Tz::Europe_Budapest, CountryId{"HU"}}, // Józsefváros railway station
    {Coordinate{24.8142, 59.065}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11039999
    {Coordinate{24.7011, 59.3381}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11041241
    {Coordinate{24.6767, 59.2736}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11043684
    {Coordinate{25.1447, 58.8344}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11046777
    {Coordinate{24.6947, 59.2227}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11048360
    {Coordinate{24.744, 59.1705}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11049028
    {Coordinate{25.5203, 58.7233}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11049439
    {Coordinate{24.8997, 58.9425}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q11051395
    {Coordinate{7.63381, 48.9524}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1105334
    {Coordinate{18.4246, 47.1832}, Tz::Europe_Budapest, CountryId{"HU"}}, // Székesfehérvár railway station
    {Coordinate{9.5753, 45.1693}, Tz::Europe_Rome, CountryId{"IT"}}, // Ospedaletto Lodigiano railway station
    {Coordinate{19.9675, 46.4661}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kistelek railway station
    {Coordinate{12.2926, 44.3144}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1112711
    {Coordinate{14.8727, 40.6403}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontecagnano railway station
    {Coordinate{11.3968, 45.2304}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1113920
    {Coordinate{11.6606, 43.4965}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1115149
    {Coordinate{14.8302, 38.1593}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1115937
    {Coordinate{15.6526, 38.1264}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio di Calabria Santa Caterina railway station
    {Coordinate{14.2709, 51.0844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neukirch West railway station
    {Coordinate{7.5411, 45.2556}, Tz::Europe_Rome, CountryId{"IT"}}, // Mathi railway station
    {Coordinate{9.60582, 47.7848}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Ravensburg
    {Coordinate{12.2988, 45.8848}, Tz::Europe_Rome, CountryId{"IT"}}, // Conegliano railway station
    {Coordinate{10.0503, 45.6564}, Tz::Europe_Rome, CountryId{"IT"}}, // Iseo railway station
    {Coordinate{15.4232, 40.8869}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1118820
    {Coordinate{11.274, 43.8486}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1121442
    {Coordinate{9.28686, 45.6456}, Tz::Europe_Rome, CountryId{"IT"}}, // Macherio-Canonica railway halt
    {Coordinate{10.4728, 45.1072}, Tz::Europe_Rome, CountryId{"IT"}}, // Q1122437
    {Coordinate{26.7658, 57.1828}, Tz::Europe_Riga, CountryId{"LV"}}, // Gulbene railway station
    {Coordinate{17.8056, 51.6492}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Ostrów Wielkopolski
    {Coordinate{117.332, 49.6394}, Tz::Asia_Chita, CountryId{"RU"}}, // Zabaykalsk Railway Station
    {Coordinate{25.045, 60.2939}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Tikkurila railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q114061
    {Coordinate{7.61006, 43.7927}, Tz::Europe_Rome, CountryId{"IT"}}, // Ventimiglia railway station
    {Coordinate{11.2367, 43.8003}, Tz::Europe_Rome, CountryId{"IT"}}, // Firenze Rifredi railway station
    {Coordinate{11.8803, 45.4175}, Tz::Europe_Rome, CountryId{"IT"}}, // Padova railway station
    {Coordinate{142.731, 46.8058}, Tz::Asia_Sakhalin, CountryId{"RU"}}, // Q1153093
    {Coordinate{10.6552, 44.7244}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio Emilia AV Mediopadana railway station
    {Coordinate{}, Tz::Asia_Tokyo, CountryId{"JP"}}, // Q11584599
    {Coordinate{15.2806, 37.0689}, Tz::Europe_Rome, CountryId{"IT"}}, // Siracusa railway station
    {Coordinate{8.92667, 45.5694}, Tz::Europe_Rome, CountryId{"IT"}}, // Canegrate railway station
    {Coordinate{8.12617, 49.198}, Tz::Europe_Berlin, CountryId{"DE"}}, // Landau (Pfalz) Hauptbahnhof
    {Coordinate{142.68, 46.9931}, Tz::Asia_Sakhalin, CountryId{"JP"}}, // Q11627144
    {Coordinate{}, Tz::Asia_Tokyo, CountryId{"JP"}}, // Q11677451
    {Coordinate{11.5737, 47.7605}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Tölz railway station
    {Coordinate{28.6134, 49.8894}, Tz::Europe_Kiev, CountryId{"UA"}}, // Berdychiv
    {Coordinate{7.94266, 52.5511}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bersenbrück
    {Coordinate{8.88791, 53.061}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremen-Sebaldsbrück
    {Coordinate{7.8817, 48.0687}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11693885
    {Coordinate{13.7904, 51.0214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11694982
    {Coordinate{19.42, 54.1503}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Elblag (station)
    {Coordinate{7.1109, 51.5376}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11699550
    {Coordinate{19.3589, 47.5924}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gödöllő railway station
    {Coordinate{8.03083, 44.6978}, Tz::Europe_Rome, CountryId{"IT"}}, // Alba railway station
    {Coordinate{26.0459, 61.2028}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Heinola railway station
    {Coordinate{11.0105, 52.2221}, Tz::Europe_Berlin, CountryId{"DE"}}, // Helmstedt railway station
    {Coordinate{10.2133, 47.5592}, Tz::Europe_Berlin, CountryId{"DE"}}, // Immenstadt station
    {Coordinate{10.7599, 47.219}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q11711967
    {Coordinate{25.1739, 61.8649}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Jämsä railway station
    {Coordinate{20.6178, 50.8742}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q11738980
    {Coordinate{9.1732, 47.6742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11743020
    {Coordinate{9.14717, 47.6825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11743021
    {Coordinate{14, 54.0333}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koserow railway station
    {Coordinate{15.5697, 54.1822}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q11744737
    {Coordinate{6.6459, 51.3575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Uerdingen station
    {Coordinate{16.2445, 50.4298}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Kudowa-Zdrój
    {Coordinate{14.0667, 54}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kölpinsee railway station
    {Coordinate{14.608, 52.5684}, Tz::Europe_Berlin, CountryId{"DE"}}, // Küstrin-Kietz station
    {Coordinate{12.4299, 51.3716}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Thekla railway station
    {Coordinate{12.3894, 51.3962}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Messe railway station
    {Coordinate{12.4438, 51.3442}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Paunsdorf station
    {Coordinate{23.7542, 61.3133}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Lempäälä railway station
    {Coordinate{16.5656, 51.8469}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Leszno
    {Coordinate{9.4993, 47.6615}, Tz::Europe_Berlin, CountryId{"DE"}}, // Löwental
    {Coordinate{13.961, 51.8622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübbenau railway station
    {Coordinate{11.6578, 52.1665}, Tz::Europe_Berlin, CountryId{"DE"}}, // Magdeburg-Eichenweiler railway station
    {Coordinate{8.3141, 49.9612}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11766347
    {Coordinate{8.4541, 49.4933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim-Handelshafen station
    {Coordinate{8.4541, 49.4238}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim-Rheinau station
    {Coordinate{9.36917, 47.4231}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen railway station
    {Coordinate{9.003, 47.7393}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11770331
    {Coordinate{11.1431, 47.8449}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weilheim (Oberbay) station
    {Coordinate{27.2776, 61.6879}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Mikkeli railway station
    {Coordinate{12.9598, 50.9872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mittweida railway station
    {Coordinate{11.428, 48.1546}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Leienfelsstraße station
    {Coordinate{11.4436, 48.1487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich-Westkreuz station
    {Coordinate{14.0667, 54}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neu Pudagla railway station
    {Coordinate{13.2617, 53.5622}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubrandenburg railway station
    {Coordinate{8.6123, 47.6826}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuhausen Badischer railway station
    {Coordinate{8.495, 47.6891}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q11790775
    {Coordinate{11.0583, 49.4075}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794301
    {Coordinate{11.0548, 49.4295}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794302
    {Coordinate{11.1111, 49.4446}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nürnberg-Gleißhammer station
    {Coordinate{11.0682, 49.4428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794304
    {Coordinate{11.1217, 49.4641}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11794306
    {Coordinate{10.4979, 48.8509}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nördlingen station
    {Coordinate{11.8308, 53.4301}, Tz::Europe_Berlin, CountryId{"DE"}}, // Parchim railway station
    {Coordinate{11.7239, 49.1642}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Parsberg
    {Coordinate{10.2316, 52.319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Peine station
    {Coordinate{21.7875, 61.4772}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Pori railway station
    {Coordinate{13.0367, 52.3928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Potsdam Charlottenhof railway station
    {Coordinate{12.9501, 48.8394}, Tz::Europe_Berlin, CountryId{"DE"}}, // Deggendorf Hauptbahnhof
    {Coordinate{22.7767, 49.7839}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q11829017
    {Coordinate{8.9692, 47.7357}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q11833501
    {Coordinate{19.1003, 49.5069}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Rajcza Centrum railway station
    {Coordinate{12.3453, 51.5242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Delitzsch unterer station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ajos rail yard
    {Coordinate{22.6958, 63.7069}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Alholma (Leppäluoto) harbor track railway station
    {Coordinate{29.0247, 64.4508}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11852727
    {Coordinate{24.9568, 60.3041}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Aviapolis railway station
    {Coordinate{23.0808, 59.8656}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11856399
    {Coordinate{24.1908, 62.5411}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Eläinpuisto-Zoo
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11858533
    {Coordinate{24.1508, 63.915}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11858763
    {Coordinate{24.1314, 65.8281}, Tz::Europe_Stockholm, CountryId{"FI"}}, // Haparanda railway station
    {Coordinate{25.5086, 60.9208}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11861183
    {Coordinate{21.3458, 60.7961}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Hangonsaari railway station
    {Coordinate{22.1336, 61.31}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11861540
    {Coordinate{30.1933, 62.5567}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11861989
    {Coordinate{25.4728, 60.8958}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11862444
    {Coordinate{24.9231, 60.7536}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11862591
    {Coordinate{25.2258, 64.7336}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Hirvineva railway station
    {Coordinate{23.8491, 53.6865}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrodna
    {Coordinate{28.4631, 64.6838}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Hyrynsalmi railway station
    {Coordinate{29.4442, 63.4547}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11864162
    {Coordinate{24.9258, 60.2125}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11864600
    {Coordinate{28.7767, 61.1958}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Imatra railway station
    {Coordinate{24.1453, 62.5507}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Inha railway station
    {Coordinate{26.8395, 60.6968}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Inkeroinen railway station
    {Coordinate{22.3948, 62.9513}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Isokyrö railway station
    {Coordinate{22.9542, 62.4719}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11865685
    {Coordinate{28.4892, 61.1203}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Joutseno station
    {Coordinate{26.9378, 60.604}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Juurikorpi railway station
    {Coordinate{25.2744, 60.8675}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11868360
    {Coordinate{23.0222, 62.0269}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11869011
    {Coordinate{27.3476, 60.9108}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11869035
    {Coordinate{23.9147, 63.8986}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kannus railway station
    {Coordinate{23.3883, 61.7511}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11869852
    {Coordinate{24.4183, 64.0156}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Karhukangas railway station
    {Coordinate{22.2119, 62.4599}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11870457
    {Coordinate{23.0356, 63.0997}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kauhava railway station
    {Coordinate{23.6833, 66.4483}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11870545
    {Coordinate{27.2281, 63.7094}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11870623
    {Coordinate{26.3303, 60.8853}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kausala railway station
    {Coordinate{25.5139, 64.9128}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kempele railway station
    {Coordinate{29.8035, 61.8876}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11871170
    {Coordinate{24.7069, 62.2555}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Keuruu railway station
    {Coordinate{26.6117, 63.6411}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kiuruvesi railway station
    {Coordinate{27.4717, 64.4686}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kivesjärvi railway station
    {Coordinate{24.8458, 60.314}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kivistö railway station
    {Coordinate{22.3033, 61.2544}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kokemäki railway station
    {Coordinate{24.5069, 62.1281}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kolho railway station
    {Coordinate{29.8571, 62.7325}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kontiolahti railway station
    {Coordinate{28.1133, 64.3386}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kontiomäki railway station
    {Coordinate{22.4622, 62.6881}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11872739
    {Coordinate{23.0367, 62.1744}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kuivasjärvi railway station
    {Coordinate{27.5171, 62.7719}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11873669
    {Coordinate{26.9066, 60.539}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11873982
    {Coordinate{26.8976, 60.5076}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kyminlinna railway station
    {Coordinate{25.11, 60.4244}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kytömaa railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11874094
    {Coordinate{28.0711, 64.1186}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11874402
    {Coordinate{22.0032, 62.9902}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11874419
    {Coordinate{27.7103, 64.2314}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11874538
    {Coordinate{26.1267, 60.5992}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11874637
    {Coordinate{25.1739, 60.8489}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11874694
    {Coordinate{24.5356, 65.7961}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Laurila railway station
    {Coordinate{25.0391, 60.3227}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Leinelä railway station
    {Coordinate{24.969, 60.316}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Helsinki Airport railway station
    {Coordinate{26.2472, 60.4194}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Loviisa Port railyard
    {Coordinate{29.3219, 61.8003}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Lusto railway station
    {Coordinate{28.5, 63.8817}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Maanselkä railway station
    {Coordinate{23.3375, 63.8414}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11881499
    {Coordinate{27.655, 64.4133}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Melalahti railway station
    {Coordinate{23.885, 61.2333}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11882289
    {Coordinate{25.08, 60.8231}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11883143
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11883568
    {Coordinate{25.2711, 65.5367}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Myllykangas railway station
    {Coordinate{26.7883, 60.77}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Myllykoski railway station
    {Coordinate{24.2789, 62.525}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Myllymäki railway station
    {Coordinate{25.9897, 61.1636}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11883670
    {Coordinate{21.9642, 60.6507}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11883684
    {Coordinate{26.8814, 61.4214}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Mäntyharju railway station
    {Coordinate{22.4817, 61.8447}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Niinisalo railway station
    {Coordinate{25.2661, 60.3825}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11884448
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11884566
    {Coordinate{24.3172, 60.3292}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Nummela railway station
    {Coordinate{25.7486, 60.8156}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11885783
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11885792
    {Coordinate{24.3706, 61.6744}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11885796
    {Coordinate{27.0897, 64.1139}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Otanmäki rail yard
    {Coordinate{26.9189, 60.475}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11886387
    {Coordinate{22.6864, 60.4592}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Paimio railway station
    {Coordinate{27.8222, 64.4008}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Paltamo railway station
    {Coordinate{29.5022, 61.5586}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Parikkala railway station
    {Coordinate{23.5522, 60.0981}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Pohjankuru railway station
    {Coordinate{22.9411, 62.6483}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11888470
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11888974
    {Coordinate{22.129, 60.4858}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Raisio railway station
    {Coordinate{24.7617, 60.5322}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Rajamäki railway station
    {Coordinate{29.2944, 61.8031}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11890618
    {Coordinate{22.9967, 62.9033}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11891325
    {Coordinate{26.8861, 63.6019}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11891384
    {Coordinate{25.0983, 64.6608}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ruukki railway station
    {Coordinate{24.7575, 60.8175}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11891564
    {Coordinate{27.345, 56.5197}, Tz::Europe_Riga, CountryId{"LV"}}, // Q11891612
    {Coordinate{29.6619, 61.6958}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11891820
    {Coordinate{24.2822, 63.9794}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Sievi railway station
    {Coordinate{27.4061, 62.2897}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11893387
    {Coordinate{27.6661, 63.0753}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Siilinjärvi railway station
    {Coordinate{23.3115, 59.9262}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Skogby Stop
    {Coordinate{25.5403, 60.3003}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Sköldvik railway station
    {Coordinate{27.21, 63.6317}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11893993
    {Coordinate{27.4222, 63.8647}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Sukeva railway station
    {Coordinate{28.3672, 62.3561}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11895634
    {Coordinate{29.0608, 62.7172}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11895636
    {Coordinate{27.998, 63.9777}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Talvivaara rail yard
    {Coordinate{21.7419, 62.475}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11897075
    {Coordinate{30.3552, 62.2448}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11897816
    {Coordinate{27.7251, 62.997}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11897875
    {Coordinate{24.6383, 60.9183}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Turenki railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Törmä railway station
    {Coordinate{30.2417, 62.9122}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Uimaharju railway station
    {Coordinate{26.9326, 60.8775}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11899737
    {Coordinate{21.4272, 60.7972}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Uusikaupunki railway station
    {Coordinate{26.0156, 60.9278}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Uusikylä railway station
    {Coordinate{26.8425, 64.5581}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vaala railway station
    {Coordinate{25.8744, 66.5189}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11899953
    {Coordinate{28.3376, 60.8553}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vainikkala railway station
    {Coordinate{24.0167, 61.2742}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11900121
    {Coordinate{30.1639, 62.305}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11900131
    {Coordinate{22.8875, 61.3492}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vammala Railway Station
    {Coordinate{29.9486, 64.5397}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vartius railway station
    {Coordinate{29.6117, 63.4215}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11901166
    {Coordinate{23.77, 61.2125}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11901292
    {Coordinate{25.8248, 60.9466}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Villähde railway station
    {Coordinate{24.5072, 62.0258}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vilppula railway station
    {Coordinate{22.8236, 63.2864}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11901889
    {Coordinate{28.2733, 64.1475}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vuokatti Railway Station
    {Coordinate{22.9594, 62.4}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11902887
    {Coordinate{29.5653, 62.6206}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ylämylly railway station
    {Coordinate{29.4689, 64.4794}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q11902963
    {Coordinate{24.0636, 62.5536}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ähtäri railway station
    {Coordinate{28.8906, 64.8867}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ämmänsaari railway station
    {Coordinate{53.9508, 56.9542}, Tz::Europe_Samara, CountryId{"RU"}}, // Q1191379
    {Coordinate{6.2317, 51.008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q12013412
    {Coordinate{7.0752, 51.4503}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Steele station
    {Coordinate{6.85219, 51.052}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Worringen station
    {Coordinate{8.44944, 52.2044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bruchmühlen station
    {Coordinate{6.94911, 51.4728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Borbeck station
    {Coordinate{36.3958, 49.8481}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12061729
    {Coordinate{29.1722, 50.1317}, Tz::Europe_Kiev, CountryId{"UA"}}, // 62 km
    {Coordinate{33.642, 48.0442}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12062161
    {Coordinate{28.9006, 50.1681}, Tz::Europe_Kiev, CountryId{"UA"}}, // 82 km
    {Coordinate{7.07925, 50.8581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Porz-Wahn station
    {Coordinate{8.27944, 52.2364}, Tz::Europe_Berlin, CountryId{"DE"}}, // Westerhausen station
    {Coordinate{24.3669, 50.635}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12073651
    {Coordinate{26.9289, 49.4894}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12073663
    {Coordinate{28.6704, 49.8599}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ivankivtsi
    {Coordinate{26.3613, 50.4616}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ivachkove
    {Coordinate{29.0392, 50.1369}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ivnytsya
    {Coordinate{35.1897, 48.4706}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12073915
    {Coordinate{28.8125, 45.36}, Tz::Europe_Kiev, CountryId{"UA"}}, // Izmail
    {Coordinate{37.3011, 49.216}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12074128
    {Coordinate{26.8322, 50.1073}, Tz::Europe_Kiev, CountryId{"UA"}}, // Izyaslav
    {Coordinate{35.2803, 48.4014}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ilarionove
    {Coordinate{35.1283, 47.8531}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12074332
    {Coordinate{31.6649, 51.367}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12074333
    {Coordinate{38.4719, 48.3947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12074337
    {Coordinate{37.6823, 49.4734}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12074338
    {Coordinate{27.06, 50.1328}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12074339
    {Coordinate{31.8944, 49.2033}, Tz::Europe_Kiev, CountryId{"UA"}}, // imeni Tarasa Shevchenko
    {Coordinate{33.1419, 47.6786}, Tz::Europe_Kiev, CountryId{"UA"}}, // Inhulets
    {Coordinate{29.4517, 50.7211}, Tz::Europe_Kiev, CountryId{"UA"}}, // Irsha
    {Coordinate{32.4082, 50.8422}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12075422
    {Coordinate{29.2658, 47.9858}, Tz::Europe_Kiev, CountryId{"UA"}}, // Abamelikove
    {Coordinate{30.3796, 50.4673}, Tz::Europe_Kiev, CountryId{"UA"}}, // Akademmistechko
    {Coordinate{33.2219, 51.4531}, Tz::Europe_Kiev, CountryId{"UA"}}, // Altynivka
    {Coordinate{29.0109, 50.0246}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12078317
    {Coordinate{26.9831, 49.7928}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12078695
    {Coordinate{33.6906, 47.6594}, Tz::Europe_Kiev, CountryId{"UA"}}, // Apostolove
    {Coordinate{29.4228, 45.9961}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12079378
    {Coordinate{36.2983, 45.3747}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Bagerovo
    {Coordinate{34.6467, 48.4819}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12080158
    {Coordinate{32.4606, 50.1292}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12080262
    {Coordinate{35.5874, 49.362}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12080652
    {Coordinate{29.625, 47.875}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12080698
    {Coordinate{34.8381, 48.5936}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12080746
    {Coordinate{35.6193, 49.9261}, Tz::Europe_Kiev, CountryId{"UA"}}, // Baranove
    {Coordinate{27.8328, 50.5036}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12080994
    {Coordinate{31.32, 50.3461}, Tz::Europe_Kiev, CountryId{"UA"}}, // Baryshivka
    {Coordinate{28.1231, 50.8233}, Tz::Europe_Kiev, CountryId{"UA"}}, // Baskaky
    {Coordinate{33.4844, 47.8728}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12081218
    {Coordinate{32.7987, 51.181}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bakhmach-Kyivskiy
    {Coordinate{33.8492, 44.7556}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Bakhchysarai Railway Station
    {Coordinate{36.2491, 49.8885}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12081555
    {Coordinate{36.1337, 50.1658}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bezrukivka Railway Halt
    {Coordinate{31.5019, 50.3282}, Tz::Europe_Kiev, CountryId{"UA"}}, // Berezan
    {Coordinate{28.7427, 50.2293}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bystra
    {Coordinate{31.0372, 50.6468}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bobryk
    {Coordinate{31.3714, 50.7636}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bobrovytsya
    {Coordinate{33.3856, 51.8591}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12083236
    {Coordinate{32.0083, 50.1919}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{27.1394, 49.3739}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12083285
    {Coordinate{35.4898, 50.1565}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bogodukhiv
    {Coordinate{28.5794, 50.3186}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12083401
    {Coordinate{34.1228, 48.3553}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bozhedarivka
    {Coordinate{30.9456, 50.3767}, Tz::Europe_Kiev, CountryId{"UA"}}, // Boryspil
    {Coordinate{29.8942, 50.6287}, Tz::Europe_Kiev, CountryId{"UA"}}, // Borodianka
    {Coordinate{30.4091, 50.4261}, Tz::Europe_Kiev, CountryId{"UA"}}, // Borshchahivka-Technichna
    {Coordinate{29.4931, 47.8661}, Tz::Europe_Kiev, CountryId{"UA"}}, // Borshchi
    {Coordinate{30.5681, 50.4078}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12084353
    {Coordinate{30.2994, 50.3211}, Tz::Europe_Kiev, CountryId{"UA"}}, // Boiarka
    {Coordinate{39.1458, 48.3989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12084546
    {Coordinate{33.8531, 46.8314}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12084628
    {Coordinate{36.9325, 49.4259}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12084642
    {Coordinate{33.4859, 51.8032}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12084850
    {Coordinate{25.1561, 50.0697}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12084951
    {Coordinate{33.44, 51.6472}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bryulovetskyi
    {Coordinate{23.9369, 49.9042}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12085088
    {Coordinate{29.2125, 49.9243}, Tz::Europe_Kiev, CountryId{"UA"}}, // Brivky
    {Coordinate{36.4445, 49.6594}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12085277
    {Coordinate{37.3941, 49.1314}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12085501
    {Coordinate{30.2214, 50.5489}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bucha
    {Coordinate{30.1098, 49.8121}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bila Tserkva
    {Coordinate{30.3392, 46.1847}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bilhorod-Dnistrovskyi
    {Coordinate{30.3347, 50.4878}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bilychi
    {Coordinate{30.0844, 50.1736}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12086658
    {Coordinate{28.7447, 48.5336}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vapnyarka
    {Coordinate{28.5561, 49.4637}, Tz::Europe_Kiev, CountryId{"UA"}}, // Varshitsya
    {Coordinate{30.2253, 50.2258}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vasylkiv 1st
    {Coordinate{32.5449, 51.1143}, Tz::Europe_Kiev, CountryId{"UA"}}, // Velyka Zahorivka
    {Coordinate{26.9536, 49.925}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12088492
    {Coordinate{26.9433, 49.8319}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12088497
    {Coordinate{33.7381, 50.3647}, Tz::Europe_Kiev, CountryId{"UA"}}, // Veneslavivka
    {Coordinate{26.9822, 49.9853}, Tz::Europe_Kiev, CountryId{"UA"}}, // Verbivtsi
    {Coordinate{28.9499, 49.7877}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vernyhorodok
    {Coordinate{34.3686, 48.5539}, Tz::Europe_Kiev, CountryId{"UA"}}, // Verkhnodniprovsk
    {Coordinate{36.3086, 48.2069}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12088881
    {Coordinate{29.992, 47.1059}, Tz::Europe_Kiev, CountryId{"UA"}}, // Veselyi Kut
    {Coordinate{33.4281, 47.9958}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12089050
    {Coordinate{30.3978, 46.6136}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyhoda
    {Coordinate{32.8656, 47.9811}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12089634
    {Coordinate{30.3689, 50.3844}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyshneve
    {Coordinate{30.0275, 50.1478}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyshnyaky
    {Coordinate{35.3764, 45.1683}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Vladislavovka Railway station
    {Coordinate{36.9194, 50.2836}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12089995
    {Coordinate{38.4883, 48.8697}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12090014
    {Coordinate{29.68, 50.0411}, Tz::Europe_Kiev, CountryId{"UA"}}, // Volytsya
    {Coordinate{24.3347, 50.8417}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12090407
    {Coordinate{26.2084, 49.5322}, Tz::Europe_Kiev, CountryId{"UA"}}, // Volochysk
    {Coordinate{34.2246, 51.1702}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vorozhba
    {Coordinate{30.5844, 47.8767}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12090819
    {Coordinate{29.1167, 49.8927}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vchoraishe
    {Coordinate{26.4503, 49.4955}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12093150
    {Coordinate{34.0158, 48.4653}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12093253
    {Coordinate{29.4381, 51.3616}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12093298
    {Coordinate{28.511, 49.2393}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vinnytsia
    {Coordinate{35.574, 50.0842}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12093758
    {Coordinate{30.8397, 49.7474}, Tz::Europe_Kiev, CountryId{"UA"}}, // Halyne
    {Coordinate{32.1907, 50.7063}, Tz::Europe_Kiev, CountryId{"UA"}}, // Halka
    {Coordinate{27.3918, 50.1311}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hannusyne
    {Coordinate{33.0681, 47.9292}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12094549
    {Coordinate{34.7741, 46.1737}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12094739
    {Coordinate{30.3075, 50.2575}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hlevakha
    {Coordinate{33.9383, 51.6781}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hlukhiv
    {Coordinate{28.7213, 49.8038}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hluhivtsi
    {Coordinate{33.8228, 49.9125}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hoholeve
    {Coordinate{28.7153, 49.5653}, Tz::Europe_Kiev, CountryId{"UA"}}, // Holendry
    {Coordinate{28.6823, 50.456}, Tz::Europe_Kiev, CountryId{"UA"}}, // Gorbashi
    {Coordinate{31.6419, 51.9144}, Tz::Europe_Kiev, CountryId{"UA"}}, // Horodnia
    {Coordinate{24.8156, 50.4498}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12097137
    {Coordinate{34.9836, 48.4783}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12097185
    {Coordinate{36.8671, 49.7292}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12097411
    {Coordinate{26.9511, 49.4282}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12097633
    {Coordinate{31.8349, 50.9984}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hryhoro-Ivanivka
    {Coordinate{32.8234, 51.0179}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12097711
    {Coordinate{33.5397, 51.2139}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12098060
    {Coordinate{26.857, 49.4637}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hruzivtsi
    {Coordinate{35.3748, 50.1775}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12098238
    {Coordinate{35.2661, 48.8022}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12098255
    {Coordinate{27.725, 50.5286}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12098353
    {Coordinate{30.2736, 50.2444}, Tz::Europe_Kiev, CountryId{"UA"}}, // Danylivka
    {Coordinate{27.1006, 49.765}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12099624
    {Coordinate{28.409, 49.948}, Tz::Europe_Kiev, CountryId{"UA"}}, // Demchyn
    {Coordinate{38.4972, 48.3647}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12100187
    {Coordinate{28.5596, 49.3239}, Tz::Europe_Kiev, CountryId{"UA"}}, // Desenka
    {Coordinate{29.1164, 45.6519}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dzynilor
    {Coordinate{30.9408, 50.5923}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dymerka
    {Coordinate{34.4169, 48.5892}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12101357
    {Coordinate{34.5875, 48.5256}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kamianske
    {Coordinate{34.991, 48.4217}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12101392
    {Coordinate{28.5858, 51.2897}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khaichnoryn
    {Coordinate{32.7617, 48.115}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dolynska
    {Coordinate{31.688, 50.9443}, Tz::Europe_Kiev, CountryId{"UA"}}, // Doslidna
    {Coordinate{28.6724, 50.9424}, Tz::Europe_Kiev, CountryId{"UA"}}, // Drevlyanka
    {Coordinate{33.3922, 51.1989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12102637
    {Coordinate{37.6917, 48.815}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12102642
    {Coordinate{28.425, 50.3517}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12102644
    {Coordinate{27.3403, 50.3197}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12102711
    {Coordinate{26.8381, 49.0206}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dunaivtsi
    {Coordinate{34.9089, 48.4614}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12103344
    {Coordinate{34.0414, 51.8106}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12104126
    {Coordinate{24.0172, 52.2006}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhabinka
    {Coordinate{33.9153, 48.4369}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12104400
    {Coordinate{31.001, 50.6264}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zherdove
    {Coordinate{28.6978, 50.2681}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhytomyr
    {Coordinate{36.2475, 49.8475}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12104670
    {Coordinate{33.6153, 48.3817}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhovti Vody 1
    {Coordinate{28.7204, 48.6012}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhuravlivka
    {Coordinate{31.1357, 50.6901}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zavorychi
    {Coordinate{33.5589, 46.7731}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12105183
    {Coordinate{29.795, 50.6567}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zahaltsi
    {Coordinate{37.2033, 49.3767}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12105425
    {Coordinate{36.1617, 49.9675}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12105617
    {Coordinate{27.0186, 49.6111}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12105801
    {Coordinate{35.2378, 47.8842}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12105856
    {Coordinate{35.1881, 47.7958}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12105858
    {Coordinate{35.1847, 47.8222}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12105859
    {Coordinate{27.0297, 49.5506}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12105943
    {Coordinate{35.2297, 49.2144}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12106211
    {Coordinate{34.0224, 52.1839}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zernove
    {Coordinate{32.7012, 48.7089}, Tz::Europe_Kiev, CountryId{"UA"}}, // Znamyanka-Pasazhirska
    {Coordinate{32.6539, 48.7163}, Tz::Europe_Kiev, CountryId{"UA"}}, // Znamyanka
    {Coordinate{35.9883, 50.2737}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12107002
    {Coordinate{35.0202, 48.3997}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zustrichny
    {Coordinate{36.3031, 49.79}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12107263
    {Coordinate{29.0009, 50.8601}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yosypivka
    {Coordinate{30.7846, 49.8419}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kaharlyk
    {Coordinate{32.7614, 47.8806}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kazanka
    {Coordinate{24.3489, 49.0128}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kalush
    {Coordinate{26.9744, 49.4167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kamianetskyi Pereizd
    {Coordinate{31.7806, 51.8633}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kamka
    {Coordinate{24.9604, 51.6054}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12108257
    {Coordinate{34.9506, 47.8383}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12108331
    {Coordinate{35.8699, 49.9571}, Tz::Europe_Kiev, CountryId{"UA"}}, // Karavanna
    {Coordinate{30.832, 49.6371}, Tz::Europe_Kiev, CountryId{"UA"}}, // Karapyshi
    {Coordinate{34.7211, 48.4775}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12108762
    {Coordinate{34.0664, 48.4628}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12108950
    {Coordinate{33.4286, 46.7525}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12109158
    {Coordinate{32.6583, 50.8896}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12109192
    {Coordinate{35.7639, 49.2867}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12109390
    {Coordinate{36.4275, 45.3631}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Kerch Railway station
    {Coordinate{38.6958, 48.4386}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12109879
    {Coordinate{30.0164, 50.5813}, Tz::Europe_Kiev, CountryId{"UA"}}, // Klavdijeve
    {Coordinate{23.9803, 49.8556}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12110434
    {Coordinate{28.8618, 50.322}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12110675
    {Coordinate{28.8129, 48.4719}, Tz::Europe_Kiev, CountryId{"UA"}}, // Knyazheve
    {Coordinate{30.783, 50.495}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kniazhychi
    {Coordinate{34.1033, 49.2306}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12110816
    {Coordinate{31.5493, 50.8237}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kobyzhchi
    {Coordinate{24.7119, 51.2217}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kovel
    {Coordinate{28.6646, 50.1078}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kodnia
    {Coordinate{29.7315, 49.9811}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kozhanka
    {Coordinate{28.8865, 50.3224}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12111277
    {Coordinate{33.3284, 46.7846}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12111317
    {Coordinate{28.8389, 49.7114}, Tz::Europe_Kiev, CountryId{"UA"}}, // Koziatyn 1st
    {Coordinate{27.5033, 50.4281}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kolodyanka
    {Coordinate{28.3597, 50.365}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12111684
    {Coordinate{35.2177, 49.855}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kolomak
    {Coordinate{31.0172, 47.3036}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kolosivka Railway Station
    {Coordinate{27.6656, 49.1947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12111948
    {Coordinate{36.6961, 47.3286}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12111993
    {Coordinate{32.1067, 50.1775}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kononivka
    {Coordinate{28.7834, 49.64}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kordyshivka
    {Coordinate{33.0662, 48.7324}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korystivka
    {Coordinate{29.5172, 50.0419}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kornyn
    {Coordinate{28.6346, 50.9571}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korosten
    {Coordinate{29.0202, 50.3163}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12113210
    {Coordinate{30.1353, 50.1942}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12113323
    {Coordinate{31.5766, 50.8633}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kosmichna
    {Coordinate{34.0989, 51.1703}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12113964
    {Coordinate{27.0139, 49.6692}, Tz::Europe_Kiev, CountryId{"UA"}}, // Krasyliv Railway Station
    {Coordinate{24.6147, 49.9169}, Tz::Europe_Kiev, CountryId{"UA"}}, // Krasne
    {Coordinate{35.445, 49.3606}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12114235
    {Coordinate{28.62, 50.7697}, Tz::Europe_Kiev, CountryId{"UA"}}, // Krasnosilka
    {Coordinate{26.9508, 49.8603}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12114331
    {Coordinate{33.3097, 47.8789}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12114657
    {Coordinate{33.3764, 47.8783}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kryvyi Rih
    {Coordinate{26.7003, 50.3616}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kryvyn
    {Coordinate{28.8642, 48.3797}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kryzhopil'
    {Coordinate{33.3619, 51.5514}, Tz::Europe_Kiev, CountryId{"UA"}}, // Krolevets
    {Coordinate{28.6708, 50.2947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12115030
    {Coordinate{33.4356, 49.0344}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12115164
    {Coordinate{}, Timezone{}, CountryId{"UA"}}, // Kriukivshchyna
    {Coordinate{34.0489, 48.2739}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12115417
    {Coordinate{27.0872, 49.6806}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12115546
    {Coordinate{35.3091, 50.2307}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12115859
    {Coordinate{28.1189, 50.4308}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12115988
    {Coordinate{35.1969, 47.7197}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12116306
    {Coordinate{35.2736, 48.8767}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12116431
    {Coordinate{32.2604, 48.5238}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kropyvnytskyi
    {Coordinate{35.2183, 45.2272}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q12116617
    {Coordinate{32.6436, 50.0955}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lazirky
    {Coordinate{26.8505, 48.4311}, Tz::Europe_Kiev, CountryId{"UA"}}, // Larga
    {Coordinate{29.4858, 50.0647}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lypnyak
    {Coordinate{31.987, 50.8756}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12118462
    {Coordinate{29.3353, 50.1197}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lotos
    {Coordinate{33.4603, 50.3681}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12118512
    {Coordinate{39.2081, 48.4097}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12118937
    {Coordinate{35.9273, 49.9412}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ljubotin
    {Coordinate{28.8517, 50.1858}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lishchyn
    {Coordinate{27.3078, 50.2936}, Tz::Europe_Kiev, CountryId{"UA"}}, // Maidan-Vyla
    {Coordinate{31.3262, 50.748}, Tz::Europe_Kiev, CountryId{"UA"}}, // Makarivka
    {Coordinate{33.5894, 51.8261}, Tz::Europe_Kiev, CountryId{"UA"}}, // Makove
    {Coordinate{35.701, 50.0897}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12120655
    {Coordinate{29.9482, 50.6035}, Tz::Europe_Kiev, CountryId{"UA"}}, // Makiychukove
    {Coordinate{34.52, 49.3964}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mala Pereshchepynska
    {Coordinate{29.2949, 50.7746}, Tz::Europe_Kiev, CountryId{"UA"}}, // Malyn
    {Coordinate{26.5492, 51.0947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12120858
    {Coordinate{30.305, 50.2897}, Tz::Europe_Kiev, CountryId{"UA"}}, // Maliutianka
    {Coordinate{32.2672, 50.1481}, Tz::Europe_Kiev, CountryId{"UA"}}, // Marianivka
    {Coordinate{34.6214, 47.655}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12121308
    {Coordinate{31.2775, 50.7286}, Tz::Europe_Kiev, CountryId{"UA"}}, // Markivtsi
    {Coordinate{33.1464, 46.9188}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12121920
    {Coordinate{36.7361, 48.2506}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12122299
    {Coordinate{28.8692, 50.8892}, Tz::Europe_Kiev, CountryId{"UA"}}, // Meleni
    {Coordinate{35.7626, 50.0076}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12122785
    {Coordinate{36.2017, 47.9833}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12123151
    {Coordinate{24.5111, 51.3617}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12123208
    {Coordinate{32.0619, 46.9372}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mykolaiv
    {Coordinate{33.9628, 48.1994}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12123391
    {Coordinate{33.6256, 49.9492}, Tz::Europe_Kiev, CountryId{"UA"}}, // Myrhorod
    {Coordinate{30.9807, 49.6483}, Tz::Europe_Kiev, CountryId{"UA"}}, // Myronivka
    {Coordinate{27.6687, 50.0998}, Tz::Europe_Kiev, CountryId{"UA"}}, // Myropil
    {Coordinate{28.4694, 49.9536}, Tz::Europe_Kiev, CountryId{"UA"}}, // Myroslavka
    {Coordinate{27.4761, 50.3917}, Tz::Europe_Kiev, CountryId{"UA"}}, // Myroslavl
    {Coordinate{26.5572, 50.4152}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mohylyany
    {Coordinate{27.0642, 50.0592}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12124186
    {Coordinate{28.2761, 50.3892}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12128134
    {Coordinate{28.1119, 49.0339}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhmerynka
    {Coordinate{31.4345, 50.3356}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhovtnevyi
    {Coordinate{33.6436, 46.7903}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12129294
    {Coordinate{30.1053, 50.1822}, Tz::Europe_Kiev, CountryId{"UA"}}, // Motovylivka
    {Coordinate{36.4801, 49.8322}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12130339
    {Coordinate{33.4025, 47.9153}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mudrona
    {Coordinate{22.7114, 48.4294}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Mukachevo Railway Station
    {Coordinate{33.2039, 47.8867}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12130877
    {Coordinate{39.1383, 48.5767}, Tz::Europe_Kiev, CountryId{"UA"}}, // Milova
    {Coordinate{27.5744, 50.5564}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nalyvna
    {Coordinate{26.6211, 49.5085}, Tz::Europe_Kiev, CountryId{"UA"}}, // Narkevychi
    {Coordinate{38.4079, 48.9422}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12132512
    {Coordinate{28.2278, 50.4008}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12133058
    {Coordinate{30.087, 50.5617}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nemishajeve
    {Coordinate{33.8442, 51.9728}, Tz::Europe_Kiev, CountryId{"UA"}}, // Neplyujeve
    {Coordinate{34.7378, 45.4472}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q12133681
    {Coordinate{35.0636, 48.4981}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12133684
    {Coordinate{28.6243, 50.6912}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nova Borova
    {Coordinate{28.7428, 50.2311}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nova Bystra
    {Coordinate{28.5164, 50.3322}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12133825
    {Coordinate{29.7811, 50.0333}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nova Volytsya
    {Coordinate{28.7782, 50.9234}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novaki
    {Coordinate{33.2551, 51.9932}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novhorod-Siverskyi
    {Coordinate{33.4856, 47.9122}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12134026
    {Coordinate{27.5931, 50.5978}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novohrad-Volynskyi 1
    {Coordinate{27.7833, 50.5139}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12134061
    {Coordinate{35.4858, 48.0239}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12134069
    {Coordinate{35.2322, 48.6425}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12134139
    {Coordinate{34.6503, 46.2306}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novooleksiivka
    {Coordinate{30.6236, 50.1863}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novi Bezradychi
    {Coordinate{34.4042, 49.3281}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12134305
    {Coordinate{31.6041, 50.9028}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nosivka
    {Coordinate{34.3944, 47.5867}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nikopol Railway Station
    {Coordinate{30.7313, 50.0336}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ozernyi
    {Coordinate{26.035, 50.4578}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12135355
    {Coordinate{33.1325, 48.6739}, Tz::Europe_Kiev, CountryId{"UA"}}, // Oleksandriya
    {Coordinate{26.9283, 49.4708}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12135739
    {Coordinate{30.6489, 49.6581}, Tz::Europe_Kiev, CountryId{"UA"}}, // Olshanytsia
    {Coordinate{27.5614, 50.5053}, Tz::Europe_Kiev, CountryId{"UA"}}, // Orepy
    {Coordinate{36.0191, 48.9746}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12136461
    {Coordinate{26.9272, 49.4997}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12136731
    {Coordinate{26.4941, 50.437}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ostroh
    {Coordinate{34.9165, 50.3175}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12137017
    {Coordinate{33.6478, 48.4271}, Tz::Europe_Kiev, CountryId{"UA"}}, // P'yatykhatky-Stykova
    {Coordinate{33.7031, 48.4144}, Tz::Europe_Kiev, CountryId{"UA"}}, // P'yatykhatky
    {Coordinate{32.075, 49.5053}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12138703
    {Coordinate{30.9024, 50.5704}, Tz::Europe_Kiev, CountryId{"UA"}}, // Parnykova
    {Coordinate{27.0508, 50.0983}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12139250
    {Coordinate{29.3699, 50.7367}, Tz::Europe_Kiev, CountryId{"UA"}}, // Penyzevychi
    {Coordinate{31.1822, 47.2967}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12139466
    {Coordinate{30.8511, 48.0747}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12139476
    {Coordinate{38.5789, 48.6253}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12139477
    {Coordinate{37.6131, 49.3647}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12139564
    {Coordinate{35.3119, 49.0192}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12139842
    {Coordinate{31.6556, 50.2641}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pereyaslavska
    {Coordinate{27.8004, 50.0752}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pechanivka
    {Coordinate{35.8053, 49.9268}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pyrogova
    {Coordinate{32.5064, 50.2353}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12140595
    {Coordinate{29.2202, 50.8042}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pirizhkivskiy
    {Coordinate{33.601, 48.0161}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12140660
    {Coordinate{32.4403, 51.1028}, Tz::Europe_Kiev, CountryId{"UA"}}, // Plysky
    {Coordinate{36.2592, 47.4761}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12141807
    {Coordinate{27.4882, 50.1396}, Tz::Europe_Kiev, CountryId{"UA"}}, // Polonne
    {Coordinate{33.1642, 47.7644}, Tz::Europe_Kiev, CountryId{"UA"}}, // Poltavka-Kryvorizka
    {Coordinate{34.2233, 48.4431}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12142068
    {Coordinate{32.7012, 48.7089}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12142234
    {Coordinate{27.5248, 50.138}, Tz::Europe_Kiev, CountryId{"UA"}}, // Poninka
    {Coordinate{31.4983, 50.7978}, Tz::Europe_Kiev, CountryId{"UA"}}, // Popudrenko
    {Coordinate{29.4594, 49.9445}, Tz::Europe_Kiev, CountryId{"UA"}}, // Popilnia
    {Coordinate{33.8864, 48.1597}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12142876
    {Coordinate{34.6589, 48.5172}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12143209
    {Coordinate{34.7558, 48.2269}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12144085
    {Coordinate{32.0375, 51.0624}, Tz::Europe_Kiev, CountryId{"UA"}}, // Priosternij
    {Coordinate{35.0731, 48.4522}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145038
    {Coordinate{36.3764, 48.1175}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145067
    {Coordinate{28.7064, 50.1758}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145327
    {Coordinate{33.8497, 51.2025}, Tz::Europe_Kiev, CountryId{"UA"}}, // Putyvl
    {Coordinate{33.6036, 51.2131}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145664
    {Coordinate{30.0568, 50.166}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145835
    {Coordinate{26.1408, 49.5292}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145919
    {Coordinate{30.8936, 48.1092}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12145956
    {Coordinate{30.5542, 50.2668}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pidhirtsi
    {Coordinate{24.0339, 49.8511}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pidzamche
    {Coordinate{33.9264, 47.6328}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12146117
    {Coordinate{29.6454, 50.6946}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pisky
    {Coordinate{31.6852, 48.8874}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12146564
    {Coordinate{27.395, 50.3578}, Tz::Europe_Kiev, CountryId{"UA"}}, // Radulyn
    {Coordinate{33.5147, 47.8194}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12146659
    {Coordinate{37.6061, 49.2697}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12146685
    {Coordinate{27.7149, 49.1777}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12146727
    {Coordinate{27.9558, 50.0526}, Tz::Europe_Kiev, CountryId{"UA"}}, // Razine
    {Coordinate{36.0937, 49.95}, Tz::Europe_Kiev, CountryId{"UA"}}, // Raj-Olenivka
    {Coordinate{28.5122, 49.9452}, Tz::Europe_Kiev, CountryId{"UA"}}, // Raiky
    {Coordinate{27.0594, 49.4025}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rakove
    {Coordinate{31.7181, 50.2397}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rankovyi
    {Coordinate{30.7743, 49.9434}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rasava
    {Coordinate{34.5163, 47.6204}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12147209
    {Coordinate{}, Timezone{}, CountryId{"UA"}}, // Q12147742
    {Coordinate{34.1433, 49.6372}, Tz::Europe_Kiev, CountryId{"UA"}}, // Reshetylivka
    {Coordinate{28.636, 50.0128}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12147811
    {Coordinate{29.3031, 49.4928}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rzhevuska
    {Coordinate{36.1149, 49.9578}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ryzhiv
    {Coordinate{35.5542, 49.3799}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12148412
    {Coordinate{30.5073, 49.6957}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rokytne
    {Coordinate{33.4786, 48.0439}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rokuvata
    {Coordinate{33.3236, 49.9914}, Tz::Europe_Kiev, CountryId{"UA"}}, // Romodan
    {Coordinate{27.0469, 49.7722}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12148838
    {Coordinate{28.9344, 48.2606}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rudnytsya
    {Coordinate{23.9233, 49.8364}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rudno
    {Coordinate{29.5464, 49.9562}, Tz::Europe_Kiev, CountryId{"UA"}}, // Savertsi
    {Coordinate{37.0372, 49.3932}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12149977
    {Coordinate{27.22, 50.2203}, Tz::Europe_Kiev, CountryId{"UA"}}, // Savychi
    {Coordinate{33.6267, 48.2947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12150023
    {Coordinate{33.5856, 48.0664}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12150237
    {Coordinate{28.5343, 49.3857}, Tz::Europe_Kiev, CountryId{"UA"}}, // Salnitsky
    {Coordinate{35.8722, 49.1494}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12150831
    {Coordinate{33.9422, 51.9564}, Tz::Europe_Kiev, CountryId{"UA"}}, // Svesa
    {Coordinate{37.5556, 49.1244}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12151155
    {Coordinate{31.2863, 50.3511}, Tz::Europe_Kiev, CountryId{"UA"}}, // Selychivka
    {Coordinate{32.5828, 52.2039}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12151992
    {Coordinate{31.0614, 50.6603}, Tz::Europe_Kiev, CountryId{"UA"}}, // Semypolky
    {Coordinate{38.7496, 48.669}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12152121
    {Coordinate{33.4422, 50.1981}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sencha
    {Coordinate{28.8936, 49.7499}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sestrynivka
    {Coordinate{21.6281, 47.5206}, Tz::Europe_Budapest, CountryId{"HU"}}, // Debrecen Railway Station
    {Coordinate{34.4869, 45.9681}, Tz::Europe_Kiev, CountryId{"UA"}}, // Syvash
    {Coordinate{35.5275, 48.3211}, Tz::Europe_Kiev, CountryId{"UA"}}, // Synelnykove 1st
    {Coordinate{35.5106, 48.3339}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12152813
    {Coordinate{34.8642, 50.7975}, Tz::Europe_Kiev, CountryId{"UA"}}, // Syrovatka
    {Coordinate{30.1992, 50.5335}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sklozavodskya
    {Coordinate{23.9308, 49.8169}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153286
    {Coordinate{37.6961, 49.5631}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153350
    {Coordinate{29.3853, 50.1}, Tz::Europe_Kiev, CountryId{"UA"}}, // Skochyshche
    {Coordinate{29.735, 50.0414}, Tz::Europe_Kiev, CountryId{"UA"}}, // Skryhalivka
    {Coordinate{35.5111, 48.1244}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153542
    {Coordinate{26.8851, 50.3207}, Tz::Europe_Kiev, CountryId{"UA"}}, // Slavuta 1
    {Coordinate{36.1543, 50.2095}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153593
    {Coordinate{32.3893, 50.1264}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sloboda-Petrivka
    {Coordinate{29.3442, 47.8851}, Tz::Europe_Kiev, CountryId{"UA"}}, // Slobidka
    {Coordinate{37.5903, 48.8467}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153721
    {Coordinate{37.5558, 48.8325}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153723
    {Coordinate{27.66, 50.5478}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153972
    {Coordinate{34.9685, 50.4819}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12153994
    {Coordinate{31.8763, 49.2415}, Tz::Europe_Kiev, CountryId{"UA"}}, // Smila
    {Coordinate{32.7797, 47.0653}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12154073
    {Coordinate{29.9789, 50.1094}, Tz::Europe_Kiev, CountryId{"UA"}}, // Snitynka
    {Coordinate{35.8502, 49.9532}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ljubotin-Zahidny
    {Coordinate{33.8361, 48.0978}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12156907
    {Coordinate{29.6033, 50.0294}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stavyshche
    {Coordinate{28.7911, 50.2031}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stanyshivka
    {Coordinate{31.9756, 46.9575}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mykolaiv-Vantazhnyi
    {Coordinate{38.9275, 49.2772}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12157377
    {Coordinate{27.1672, 49.7506}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12157413
    {Coordinate{26.9708, 49.9544}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stari Beizymy
    {Coordinate{38.5855, 48.5192}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12157568
    {Coordinate{29.0994, 50.1383}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stepok
    {Coordinate{33.9228, 45.1594}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q12158034
    {Coordinate{28.8106, 50.912}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stremyhorod
    {Coordinate{28.1819, 50.4125}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12158187
    {Coordinate{28.974, 50.3231}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12158200
    {Coordinate{23.8417, 49.2594}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12158201
    {Coordinate{28.6921, 50.3683}, Tz::Europe_Kiev, CountryId{"UA"}}, // Strokovytsi
    {Coordinate{30.739, 50.1505}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stuhna
    {Coordinate{27.1322, 50.1803}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sudylkiv
    {Coordinate{33.4006, 50.3992}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sula
    {Coordinate{34.9083, 48.3319}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12158819
    {Coordinate{30.3675, 49.7384}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sukholisy
    {Coordinate{35.2842, 47.4378}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12159700
    {Coordinate{31.1292, 49.5702}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tahancha
    {Coordinate{30.3025, 50.3442}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tarasivka
    {Coordinate{30.6621, 50.1743}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tatsenky
    {Coordinate{25.6994, 49.3006}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12160673
    {Coordinate{33.4814, 51.7642}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tereshenska
    {Coordinate{33.5344, 48.1786}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12160818
    {Coordinate{36.3492, 49.8536}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12160819
    {Coordinate{25.6, 49.55}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ternopil Railway Station
    {Coordinate{29.5994, 50.6986}, Tz::Europe_Kiev, CountryId{"UA"}}, // Teteriv
    {Coordinate{27.9478, 50.4733}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12161011
    {Coordinate{29.0696, 50.8448}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tyshiv
    {Coordinate{28.667, 50.5375}, Tz::Europe_Kiev, CountryId{"UA"}}, // Toporyshche
    {Coordinate{31.0762, 50.365}, Tz::Europe_Kiev, CountryId{"UA"}}, // Travneva
    {Coordinate{31.3053, 47.7053}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12162399
    {Coordinate{29.8322, 50.0098}, Tz::Europe_Kiev, CountryId{"UA"}}, // Trylisy
    {Coordinate{30.7531, 50.1398}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tripillya-Dniprovske
    {Coordinate{37.5271, 49.1371}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12162474
    {Coordinate{31.195, 50.7036}, Tz::Europe_Kiev, CountryId{"UA"}}, // Trubizh
    {Coordinate{31.671, 48.8617}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12163031
    {Coordinate{28.4885, 49.1506}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tjushki
    {Coordinate{33.9264, 47.6328}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12163177
    {Coordinate{30.2042, 48.7331}, Tz::Europe_Kiev, CountryId{"UA"}}, // Uman
    {Coordinate{29.8283, 50.0378}, Tz::Europe_Kiev, CountryId{"UA"}}, // Unava
    {Coordinate{28.5891, 50.8626}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ushomyr
    {Coordinate{29.9431, 50.0529}, Tz::Europe_Kiev, CountryId{"UA"}}, // Fastiv 2nd
    {Coordinate{35.9492, 50.141}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12165665
    {Coordinate{28.4092, 45.4397}, Tz::Europe_Kiev, CountryId{"UA"}}, // Frycatzey
    {Coordinate{32.9958, 51.2028}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khalymonove
    {Coordinate{36.1813, 50.0262}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12166913
    {Coordinate{29.3407, 49.9515}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kharliivka
    {Coordinate{36.1412, 49.9573}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khvylynka
    {Coordinate{27.9819, 50.4633}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12167448
    {Coordinate{31.4931, 52.0297}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khorobychi
    {Coordinate{32.2681, 51.0851}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khoroshe Ozero
    {Coordinate{27.2443, 50.1507}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khrolyn
    {Coordinate{29.8537, 50.637}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khutir Hai
    {Coordinate{26.9541, 50.2572}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tsvitokha
    {Coordinate{37.2696, 49.3083}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12168763
    {Coordinate{36.2364, 48.1278}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12169135
    {Coordinate{33.2981, 47.9386}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12169607
    {Coordinate{31.7587, 50.9704}, Tz::Europe_Kiev, CountryId{"UA"}}, // Volodkova Divytsia
    {Coordinate{32.6223, 51.1266}, Tz::Europe_Kiev, CountryId{"UA"}}, // Cheremushky
    {Coordinate{26.9233, 49.5172}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12169734
    {Coordinate{29.6191, 49.9661}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chernyavka
    {Coordinate{31.2489, 51.5197}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12170040
    {Coordinate{28.9393, 50.8739}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chepovychi
    {Coordinate{26.7429, 49.4955}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chornyi Ostriv
    {Coordinate{38.4906, 48.3294}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12170600
    {Coordinate{27.0117, 50.0278}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12170667
    {Coordinate{30.3544, 46.14}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shabo
    {Coordinate{28.7108, 50.9358}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shatrishche
    {Coordinate{27.0753, 50.1639}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12171670
    {Coordinate{23.5549, 49.9701}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12171997
    {Coordinate{30.3136, 50.2711}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shliakhova
    {Coordinate{33.405, 47.9583}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shmakovo
    {Coordinate{33.4689, 51.8633}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12172245
    {Coordinate{33.3944, 48.5944}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shchaslyva
    {Coordinate{29.3482, 50.7484}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shebzavod
    {Coordinate{31.9447, 51.8142}, Tz::Europe_Kiev, CountryId{"UA"}}, // Snovsk
    {Coordinate{28.3294, 50.3728}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12172951
    {Coordinate{33.3317, 50.4708}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q12173151
    {Coordinate{35.1639, 46.6805}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Yakymivka
    {Coordinate{30.7573, 50.4787}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yalynka
    {Coordinate{33.7447, 51.9119}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yampil
    {Coordinate{35.3564, 47.9081}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q12173803
    {Coordinate{25.5511, 52.1289}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yanaw-Palyeski
    {Coordinate{28.4461, 49.1248}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yaryshivka
    {Coordinate{34.0277, 45.1166}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q12173902
    {Coordinate{29.2703, 50.1247}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yaropovychi
    {Coordinate{31.2286, 50.7124}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yaroslavka
    {Coordinate{28.268, 48.9023}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yaroshenka
    {Coordinate{7.27097, 46.2085}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174781
    {Coordinate{6.55944, 46.6875}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bavois
    {Coordinate{7.00083, 46.2514}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174783
    {Coordinate{7.24056, 46.1886}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174786
    {Coordinate{6.56816, 46.7101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chavornay
    {Coordinate{7.30472, 46.216}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174788
    {Coordinate{7.12639, 46.1269}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174790
    {Coordinate{6.94875, 46.2713}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174791
    {Coordinate{6.5525, 46.6572}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eclépens
    {Coordinate{6.6075, 46.7464}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ependes
    {Coordinate{6.58056, 46.7278}, Tz::Europe_Zurich, CountryId{"CH"}}, // Essert-Pittet
    {Coordinate{7.7475, 46.3067}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174800
    {Coordinate{8.86578, 46.1791}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174801
    {Coordinate{6.85347, 46.3859}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174805
    {Coordinate{6.87947, 46.3632}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Évouettes station
    {Coordinate{6.98556, 46.2414}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174808
    {Coordinate{8.37417, 47.045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174810
    {Coordinate{8.40903, 47.0676}, Tz::Europe_Zurich, CountryId{"CH"}}, // Merlischachen station
    {Coordinate{8.38306, 47.05}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174812
    {Coordinate{6.95523, 46.2556}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174813
    {Coordinate{7.80139, 46.3064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174816
    {Coordinate{7.21778, 46.1725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174817
    {Coordinate{8.88532, 46.1755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174819
    {Coordinate{6.80616, 46.3922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174821
    {Coordinate{7.57917, 46.3094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174824
    {Coordinate{7.41944, 46.2514}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174826
    {Coordinate{7.17333, 46.1494}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174829
    {Coordinate{8.94337, 47.2252}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schmerikon railway station
    {Coordinate{8.85056, 46.1775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174832
    {Coordinate{7.69972, 46.3094}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q12174833
    {Coordinate{8.98068, 47.2243}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uznach railway station
    {Coordinate{6.91625, 46.315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vionnaz
    {Coordinate{6.89806, 46.3369}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vouvry
    {Coordinate{6.64083, 46.7785}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yverdon-les-Bains
    {Coordinate{26.4223, 58.2243}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12362022
    {Coordinate{26.4014, 58.7456}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Jõgeva railway station
    {Coordinate{24.6856, 59.2383}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12366959
    {Coordinate{24.9989, 58.9617}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12367397
    {Coordinate{25.0086, 58.85}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12368493
    {Coordinate{24.7231, 59.3875}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12368762
    {Coordinate{24.7872, 59.1153}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12368930
    {Coordinate{25.5392, 58.6686}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12371442
    {Coordinate{27.0913, 58.07}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12373188
    {Coordinate{24.6989, 59.3342}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12374605
    {Coordinate{25.5444, 58.4669}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12375980
    {Coordinate{24.7459, 59.4127}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12376116
    {Coordinate{25.4242, 58.8047}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12377636
    {Coordinate{24.7135, 59.2009}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12378648
    {Coordinate{25.5617, 58.6294}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q12379075
    {Coordinate{30.3289, 59.92}, Tz::Europe_Moscow, CountryId{"RU"}}, // Vitebsky railway station
    {Coordinate{48.8942, 55.8161}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q124288
    {Coordinate{3.61522, 51.1544}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waarschoot railway station
    {Coordinate{3.57417, 51.1814}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eeklo railway station
    {Coordinate{8.34944, 49.5353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankenthal Central Station
    {Coordinate{4.96806, 51.8339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gorinchem railway station
    {Coordinate{19.0894, 47.5253}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákosrendező railway station
    {Coordinate{11.32, 50.2394}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kronach station
    {Coordinate{6.99056, 49.2414}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarbrücken Central Station
    {Coordinate{7.90778, 46.5983}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lauterbrunnen railway station
    {Coordinate{7.95944, 46.5844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kleine Scheidegg railway station
    {Coordinate{53.4486, 56.8686}, Tz::Europe_Samara, CountryId{"RU"}}, // Q1279157
    {Coordinate{54.0172, 57.0417}, Tz::Europe_Samara, CountryId{"RU"}}, // Q1279171
    {Coordinate{7.26331, 47.6416}, Tz::Europe_Paris, CountryId{"FR"}}, // Q128074
    {Coordinate{8.5804, 49.4487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim-Friedrichsfeld station
    {Coordinate{21.2297, 48.5083}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hidasnémeti railway station
    {Coordinate{17.7948, 46.3529}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposvár railway station
    {Coordinate{17.1925, 47.9942}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rajka railway station
    {Coordinate{19.1742, 47.4887}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákos railway station
    {Coordinate{19.2581, 47.4861}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákosliget railway station
    {Coordinate{20.1758, 47.1789}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szolnok railway station
    {Coordinate{18.3932, 47.5856}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tatabánya railway station
    {Coordinate{69.2861, 41.2921}, Tz::Asia_Tashkent, CountryId{"UZ"}}, // Toshkent Passenger
    {Coordinate{1.51179, 44.3333}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1283201
    {Coordinate{6.26389, 50.8148}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q129311
    {Coordinate{13.7664, 51.1244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Flughafen railway station
    {Coordinate{20.1428, 46.2397}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szeged railway station
    {Coordinate{3.33184, 50.2781}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bouchain
    {Coordinate{30.4033, 53.8769}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lupolava
    {Coordinate{9.27, 48.82}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fellbach station
    {Coordinate{9.23472, 48.8061}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Nürnberger Straße station
    {Coordinate{6.43971, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheydt Central Station
    {Coordinate{75.2131, 43.54}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Otar
    {Coordinate{7.25396, 52.1623}, Tz::Europe_Berlin, CountryId{"DE"}}, // Metelen Land station
    {Coordinate{}, Timezone{}, CountryId{"KZ"}}, // Kundyzdy
    {Coordinate{}, Timezone{}, CountryId{"KZ"}}, // Taskaras
    {Coordinate{77.0161, 43.4253}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Zhety-Su station
    {Coordinate{6.62735, 46.5099}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jordils
    {Coordinate{37.6572, 55.7764}, Tz::Europe_Moscow, CountryId{"RU"}}, // Moscow Yaroslavsky railway station
    {Coordinate{28.5971, 49.9183}, Tz::Europe_Kiev, CountryId{"UA"}}, // Berdychiv-Zhytomyrskyi
    {Coordinate{32.8184, 51.1785}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360789
    {Coordinate{32.4274, 51.4033}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bondarivka
    {Coordinate{27.7013, 50.6465}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360796
    {Coordinate{33.1728, 51.2629}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyrivka
    {Coordinate{27.9332, 50.7675}, Tz::Europe_Kiev, CountryId{"UA"}}, // Virivka
    {Coordinate{28.3854, 50.915}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360800
    {Coordinate{29.8059, 49.3079}, Tz::Europe_Kiev, CountryId{"UA"}}, // Denhofivka
    {Coordinate{32.5788, 51.316}, Tz::Europe_Kiev, CountryId{"UA"}}, // Doch
    {Coordinate{30.0973, 49.2433}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhashkiv
    {Coordinate{29.1978, 49.6461}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zarudyntsi
    {Coordinate{28.5936, 50.9565}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korosten-Zhytomyrskyi
    {Coordinate{32.2438, 51.7621}, Tz::Europe_Kiev, CountryId{"UA"}}, // Koriukivka
    {Coordinate{32.3316, 51.4645}, Tz::Europe_Kiev, CountryId{"UA"}}, // Makoshyne
    {Coordinate{28.9143, 49.7278}, Tz::Europe_Kiev, CountryId{"UA"}}, // Makharyntsi
    {Coordinate{33.152, 51.368}, Tz::Europe_Kiev, CountryId{"UA"}}, // Melnya
    {Coordinate{32.2348, 51.5323}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mena
    {Coordinate{32.0748, 51.6714}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360815
    {Coordinate{28.5648, 50.9638}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360816
    {Coordinate{28.2925, 50.8982}, Tz::Europe_Kiev, CountryId{"UA"}}, // Omelyanivka
    {Coordinate{27.8193, 50.7069}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360831
    {Coordinate{29.6495, 49.3754}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360833
    {Coordinate{29.7103, 49.3663}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tetiiv
    {Coordinate{28.1975, 50.8584}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360836
    {Coordinate{32.6992, 51.2422}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360838
    {Coordinate{28.0664, 50.8061}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13360839
    {Coordinate{26.8042, 49.1789}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yarmolyntsi
    {Coordinate{34.0277, 45.1166}, Tz::Europe_Simferopol, CountryId{"RU"}}, // Saky railway station
    {Coordinate{34.8008, 48.4403}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13361022
    {Coordinate{32.0678, 49.0492}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kamyanka
    {Coordinate{32.1708, 49.0119}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kosari
    {Coordinate{31.3974, 48.9954}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13361319
    {Coordinate{23.2981, 48.1617}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Khust
    {Coordinate{34.4577, 51.2405}, Tz::Europe_Kiev, CountryId{"UA"}}, // Volfine
    {Coordinate{33.3259, 51.8839}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{33.4165, 51.2017}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13361354
    {Coordinate{33.3496, 51.2009}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13361355
    {Coordinate{33.2302, 51.2192}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13361359
    {Coordinate{33.5007, 51.2146}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13361360
    {Coordinate{33.7993, 51.9439}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ivotka
    {Coordinate{33.2981, 51.2032}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kalynivka
    {Coordinate{33.1243, 51.2154}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kukilka
    {Coordinate{33.4519, 51.7033}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pyrotchyne
    {Coordinate{28.5894, 50.9762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chyhyri
    {Coordinate{33.985, 52.1162}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shalymivka
    {Coordinate{32.9224, 51.1954}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khutir Khalimonove
    {Coordinate{22.8534, 56.6916}, Tz::Europe_Riga, CountryId{"LV"}}, // Josta Station
    {Coordinate{7.4102, 49.5382}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kusel station
    {Coordinate{7.4448, 49.4702}, Tz::Europe_Berlin, CountryId{"DE"}}, // Glan-Münchweiler station
    {Coordinate{8.85501, 47.6561}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stein am Rhein railway station
    {Coordinate{44.7978, 41.7233}, Tz::Asia_Tbilisi, CountryId{"GE"}}, // Tbilisi railway station
    {Coordinate{9.20278, 45.3389}, Tz::Europe_Rome, CountryId{"IT"}}, // Pieve Emanuele railway halt
    {Coordinate{6.72258, 49.3526}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dillingen (Saar) station
    {Coordinate{31.7833, 51.3271}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423553
    {Coordinate{31.8823, 51.1762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423559
    {Coordinate{31.1125, 51.7786}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423562
    {Coordinate{8.58663, 47.5206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Embrach-Rorbas railway station
    {Coordinate{31.1566, 51.9661}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423579
    {Coordinate{31.3172, 51.4307}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423580
    {Coordinate{31.2146, 51.5981}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423581
    {Coordinate{31.5542, 51.4262}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423583
    {Coordinate{31.9047, 51.0972}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423584
    {Coordinate{28.6419, 51.0197}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q13423592
    {Coordinate{28.6131, 50.9846}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korosten-Podilskyi
    {Coordinate{2.94946, 48.9602}, Tz::Europe_Paris, CountryId{"FR"}}, // Q13427283
    {Coordinate{37.6553, 55.7763}, Tz::Europe_Moscow, CountryId{"RU"}}, // Leningradsky railway station
    {Coordinate{6.8133, 51.3768}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg-Entenfang station
    {Coordinate{6.32083, 50.8244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q134564
    {Coordinate{8.65502, 50.1582}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt Eschersheim station
    {Coordinate{4.49278, 52.0464}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zoetermeer Oost railway station
    {Coordinate{6.90833, 51.1333}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Hellerhof station
    {Coordinate{11.7388, 53.1607}, Tz::Europe_Berlin, CountryId{"DE"}}, // Karstädt station
    {Coordinate{11.9608, 50.4197}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gutenfürst station
    {Coordinate{28.5917, 50.9753}, Tz::Europe_Kiev, CountryId{"UA"}}, // Post-Pivdenny
    {Coordinate{7.01389, 51.4514}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Central Station
    {Coordinate{5.88089, 45.2345}, Tz::Europe_Paris, CountryId{"FR"}}, // Lancey
    {Coordinate{4.61778, 51.1508}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kessel railway station
    {Coordinate{23.4642, 56.7025}, Tz::Europe_Riga, CountryId{"LV"}}, // Līvbērze Station
    {Coordinate{6.47226, 51.1996}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mönchengladbach-Lürrip station
    {Coordinate{37.5803, 55.7764}, Tz::Europe_Moscow, CountryId{"RU"}}, // Belorussky railway station
    {Coordinate{10.5778, 49.2983}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ansbach station
    {Coordinate{12.0994, 49.0122}, Tz::Europe_Berlin, CountryId{"DE"}}, // Regensburg Hauptbahnhof
    {Coordinate{30.3622, 59.9298}, Tz::Europe_Moscow, CountryId{"RU"}}, // Moskovsky railway station
    {Coordinate{37.6392, 55.7294}, Tz::Europe_Moscow, CountryId{"RU"}}, // Paveletsky railway station
    {Coordinate{9.35444, 48.8681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwaikheim station
    {Coordinate{15.9789, 45.8047}, Tz::Europe_Zagreb, CountryId{"HR"}}, // Zagreb Main Station
    {Coordinate{11.1191, 46.0726}, Tz::Europe_Rome, CountryId{"IT"}}, // Trento railway station
    {Coordinate{13.4311, 52.4675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hermannstraße railway station
    {Coordinate{37.6562, 55.7733}, Tz::Europe_Moscow, CountryId{"RU"}}, // Kazansky railway station
    {Coordinate{15.0203, 51.1531}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zgorzelec Miasto
    {Coordinate{4.02472, 50.9483}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aalst-Kerrebroek railway station
    {Coordinate{3.92238, 50.9071}, Tz::Europe_Brussels, CountryId{"BE"}}, // Burst railway station
    {Coordinate{7.3509, 51.4959}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Somborn station
    {Coordinate{6.20143, 50.8345}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eschweiler-St. Jöris station
    {Coordinate{4.90214, 51.174}, Tz::Europe_Brussels, CountryId{"BE"}}, // Olen railway station
    {Coordinate{4.65361, 50.8358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oud-Heverlee railway station
    {Coordinate{13.7513, 52.4296}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkner railway station
    {Coordinate{24.3986, 57.225}, Tz::Europe_Riga, CountryId{"LV"}}, // Inčupe Station
    {Coordinate{6.84229, 46.7078}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q14475054
    {Coordinate{6.89438, 46.7588}, Tz::Europe_Zurich, CountryId{"CH"}}, // Granges-Marnand railway station
    {Coordinate{6.68628, 50.9381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14506318
    {Coordinate{10.9306, 44.6539}, Tz::Europe_Rome, CountryId{"IT"}}, // Modena railway station
    {Coordinate{9.04722, 51.5247}, Tz::Europe_Berlin, CountryId{"DE"}}, // Scherfede station
    {Coordinate{14.435, 50.0875}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha Masarykovo nádraží
    {Coordinate{6.79722, 50.9981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pulheim station
    {Coordinate{16.4069, 48.1753}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Geiselbergstraße railway station
    {Coordinate{7.21945, 50.6395}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Honnef (Rhein) station
    {Coordinate{10.6295, 47.8756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14544357
    {Coordinate{7.21023, 50.6581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rhöndorf station
    {Coordinate{8.91449, 49.1362}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eppingen station
    {Coordinate{8.86361, 52.1719}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vlotho station
    {Coordinate{12.6747, 48.2215}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altötting station
    {Coordinate{11.1079, 47.9503}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Dießen
    {Coordinate{9.82944, 52.9831}, Tz::Europe_Berlin, CountryId{"DE"}}, // Soltau (Han) station
    {Coordinate{12.0838, 52.9032}, Tz::Europe_Berlin, CountryId{"DE"}}, // Glöwen station
    {Coordinate{10.3321, 47.7313}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14550974
    {Coordinate{11.8524, 53.0714}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q14551300
    {Coordinate{10.988, 48.263}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mering station
    {Coordinate{8.76033, 47.4652}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sennhof-Kyburg railway station
    {Coordinate{24.5058, 56.8396}, Tz::Europe_Riga, CountryId{"LV"}}, // Ikšķile
    {Coordinate{8.41639, 45.3298}, Tz::Europe_Rome, CountryId{"IT"}}, // Vercelli railway station
    {Coordinate{18.9588, 47.5059}, Tz::Europe_Budapest, CountryId{"HU"}}, // Virágvölgy
    {Coordinate{37.5017, 47.5972}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q14629819
    {Coordinate{37.6325, 55.7928}, Tz::Europe_Moscow, CountryId{"RU"}}, // Rizhsky railway station
    {Coordinate{7.59972, 50.3169}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederlahnstein station
    {Coordinate{8.05689, 50.0137}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hattenheim station
    {Coordinate{10.8665, 53.9589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck-Travemünde Hafen station
    {Coordinate{13.4809, 54.3563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Putbus railway station
    {Coordinate{12.2373, 51.8843}, Tz::Europe_Berlin, CountryId{"DE"}}, // Roßlau (Elbe) station
    {Coordinate{8.54825, 49.0876}, Tz::Europe_Berlin, CountryId{"DE"}}, // Untergrombach station
    {Coordinate{8.26764, 50.4864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weilburg station
    {Coordinate{7.61046, 49.5841}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Wolfstein
    {Coordinate{12.3466, 51.5198}, Tz::Europe_Berlin, CountryId{"DE"}}, // Delitzsch oberer Bahnhof
    {Coordinate{16.3996, 48.1879}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q14906766
    {Coordinate{11.4158, 47.1935}, Tz::Europe_Vienna, CountryId{"AT"}}, // Patsch railway station
    {Coordinate{4.6062, 45.5243}, Tz::Europe_Paris, CountryId{"FR"}}, // Q14918105
    {Coordinate{37.515, 55.7444}, Tz::Europe_Moscow, CountryId{"RU"}}, // Fili railway station
    {Coordinate{37.3973, 55.7237}, Tz::Europe_Moscow, CountryId{"RU"}}, // Setun' railway station
    {Coordinate{37.5539, 55.8053}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927375
    {Coordinate{37.5533, 55.8973}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927379
    {Coordinate{37.2467, 55.8233}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927503
    {Coordinate{35.3789, 55.5131}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927504
    {Coordinate{42.0228, 58.4252}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927507
    {Coordinate{45.0122, 53.2042}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927508
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyebyadziny
    {Coordinate{40.1906, 48.1555}, Tz::Europe_Moscow, CountryId{"RU"}}, // Lykha
    {Coordinate{31.0615, 59.7556}, Tz::Europe_Moscow, CountryId{"RU"}}, // Mga
    {Coordinate{38.1362, 56.1088}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927513
    {Coordinate{38.0309, 54.987}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927517
    {Coordinate{49.3302, 55.9423}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927518
    {Coordinate{59.9778, 56.8889}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927533
    {Coordinate{30.9341, 59.976}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927534
    {Coordinate{27.0659, 54.2537}, Tz::Europe_Minsk, CountryId{"BY"}}, // Usha
    {Coordinate{48.0483, 56.5125}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927539
    {Coordinate{29.1541, 60.552}, Tz::Europe_Moscow, CountryId{"RU"}}, // Leypyasuo
    {Coordinate{40.035, 57.7686}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927543
    {Coordinate{28.7136, 60.5825}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927545
    {Coordinate{35.7175, 56.9533}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927549
    {Coordinate{38.9181, 55.0264}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927574
    {Coordinate{43.1415, 44.2134}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927597
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q14927598
    {Coordinate{38.666, 47.6978}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927599
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q14927601
    {Coordinate{109.342, 55.6328}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q14927612
    {Coordinate{29.5424, 55.8469}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927614
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Kungur Railway Station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q14927616
    {Coordinate{35.7871, 55.9942}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927617
    {Coordinate{37.2661, 55.6099}, Tz::Europe_Moscow, CountryId{"RU"}}, // Aeroport
    {Coordinate{39.2114, 56.7063}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927621
    {Coordinate{45.4122, 53.1141}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927622
    {Coordinate{37.4616, 54.9949}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927623
    {Coordinate{75.3408, 43.5347}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Q14927624
    {Coordinate{75.4881, 43.535}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Q14927625
    {Coordinate{}, Timezone{}, CountryId{"KZ"}}, // Ortakudyk
    {Coordinate{}, Timezone{}, CountryId{"KZ"}}, // Aydarly
    {Coordinate{55.9204, 53.4658}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927628
    {Coordinate{55.9256, 53.5367}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927629
    {Coordinate{55.9137, 53.5556}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927630
    {Coordinate{55.9196, 53.608}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927631
    {Coordinate{55.91, 53.5669}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927632
    {Coordinate{38.4278, 48.3411}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q14927633
    {Coordinate{37.4583, 56.1258}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927634
    {Coordinate{126.75, 52.6311}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q14927635
    {Coordinate{45.1906, 54.1956}, Tz::Europe_Moscow, CountryId{"RU"}}, // Saransk railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q14927637
    {Coordinate{32.3844, 55.5944}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927638
    {Coordinate{38.3264, 55.1019}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927639
    {Coordinate{35.8914, 56.8358}, Tz::Europe_Moscow, CountryId{"RU"}}, // Tver railway station
    {Coordinate{36.7578, 54.515}, Tz::Europe_Moscow, CountryId{"RU"}}, // Ferzikovo railway station
    {Coordinate{52.1845, 56.9893}, Tz::Europe_Samara, CountryId{"RU"}}, // Q14927642
    {Coordinate{52.3872, 56.9833}, Tz::Europe_Samara, CountryId{"RU"}}, // Q14927643
    {Coordinate{52.8693, 56.9673}, Tz::Europe_Samara, CountryId{"RU"}}, // Q14927644
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q14927645
    {Coordinate{26.2965, 53.2044}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ivatsevichy
    {Coordinate{26.2965, 53.2044}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kosava-Palyeskaye
    {Coordinate{26.2965, 53.2044}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bronnaya Hara
    {Coordinate{53.7375, 63.5572}, Tz::Europe_Moscow, CountryId{"RU"}}, // Uhta
    {Coordinate{50.0752, 62.3599}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927650
    {Coordinate{55.0747, 51.7763}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927651
    {Coordinate{36.1964, 52.9372}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927652
    {Coordinate{35.18, 53.1403}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927653
    {Coordinate{40.1167, 47.4042}, Tz::Europe_Moscow, CountryId{"RU"}}, // Novocherkassk railway station
    {Coordinate{34.9817, 53.1344}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927655
    {Coordinate{34.3081, 53.3142}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927656
    {Coordinate{32.9853, 53.8914}, Tz::Europe_Moscow, CountryId{"BY"}}, // Krychaw II
    {Coordinate{31.7089, 53.7403}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krychaw I
    {Coordinate{59.5955, 57.5428}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q14927659
    {Coordinate{34.8325, 53.1769}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927660
    {Coordinate{34.2353, 53.1117}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927661
    {Coordinate{33.4633, 52.9139}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927662
    {Coordinate{33.1347, 52.8792}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927663
    {Coordinate{32.6783, 52.8428}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927664
    {Coordinate{32.2333, 52.735}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927665
    {Coordinate{31.9469, 52.5228}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927666
    {Coordinate{31.165, 52.3881}, Tz::Europe_Minsk, CountryId{"BY"}}, // Laryshchava
    {Coordinate{30.7536, 52.3986}, Tz::Europe_Minsk, CountryId{"BY"}}, // Prybar
    {Coordinate{30.3928, 52.3486}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rechytsa
    {Coordinate{30.2031, 52.3361}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyemyakhi
    {Coordinate{29.8311, 52.2539}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vasilyevichy
    {Coordinate{29.6728, 52.2217}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nakhaw
    {Coordinate{29.4992, 52.1622}, Tz::Europe_Minsk, CountryId{"BY"}}, // Halyavitsy
    {Coordinate{57.2351, 65.1582}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927688
    {Coordinate{41.5459, 58.4671}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927689
    {Coordinate{41.1154, 57.245}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927690
    {Coordinate{47.5076, 58.2823}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q14927692
    {Coordinate{43.3911, 58.3394}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927693
    {Coordinate{41.6771, 57.9251}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q14927694
    {Coordinate{7.6681, 45.0004}, Tz::Europe_Rome, CountryId{"IT"}}, // Moncalieri Sangone railway station
    {Coordinate{7.642, 44.9914}, Tz::Europe_Rome, CountryId{"IT"}}, // Nichelino railway station
    {Coordinate{7.599, 44.9611}, Tz::Europe_Rome, CountryId{"IT"}}, // Candiolo railway station
    {Coordinate{11.3996, 48.1377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Freiham station
    {Coordinate{12.5644, 55.6728}, Tz::Europe_Copenhagen, CountryId{"DK"}}, // Copenhagen Central Station
    {Coordinate{27.4679, 57.84}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q14955583
    {Coordinate{-0.1609, 51.1565}, Tz::Europe_London, CountryId{"GB"}}, // Gatwick Airport railway station
    {Coordinate{10.2431, 50.0461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schweinfurt Stadt station
    {Coordinate{12.6334, 42.2422}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggio Mirteto railway station
    {Coordinate{12.5961, 42.0639}, Tz::Europe_Rome, CountryId{"IT"}}, // Monterotondo-Mentana railway station
    {Coordinate{9.43698, 45.0632}, Tz::Europe_Rome, CountryId{"IT"}}, // Castel San Giovanni railway station
    {Coordinate{11.3764, 44.4817}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna Mazzini railway halt
    {Coordinate{11.842, 44.6165}, Tz::Europe_Rome, CountryId{"IT"}}, // Argenta railway station
    {Coordinate{12.4609, 44.1502}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15070218
    {Coordinate{12.0401, 44.5116}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15070219
    {Coordinate{12.0983, 44.4628}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15070225
    {Coordinate{7.7555, 46.3674}, Tz::Europe_Zurich, CountryId{"CH"}}, // Goppenstein railway station
    {Coordinate{8.78478, 47.3671}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pfäffikon ZH railway station
    {Coordinate{8.75027, 47.3851}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fehraltorf railway station
    {Coordinate{8.70475, 47.4517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kemptthal railway station
    {Coordinate{8.93236, 47.354}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steg railway station
    {Coordinate{8.92318, 47.3334}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fischenthal railway station
    {Coordinate{8.62656, 47.4383}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bassersdorf railway station
    {Coordinate{8.91566, 47.3134}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gibswil railway station
    {Coordinate{8.8526, 47.2685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tann-Dürnten railway station
    {Coordinate{8.84238, 47.2237}, Tz::Europe_Zurich, CountryId{"CH"}}, // Blumenau railway station
    {Coordinate{8.85488, 47.3938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saland railway station
    {Coordinate{8.84359, 47.4373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Turbenthal railway station
    {Coordinate{8.81892, 47.4416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rämismühle-Zell railway station
    {Coordinate{8.81892, 47.4416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Hegi station
    {Coordinate{8.6132, 47.2815}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herrliberg-Feldmeilen railway station
    {Coordinate{8.59892, 47.2974}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winkel am Zürichsee railway station
    {Coordinate{8.59161, 47.3053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Erlenbach ZH railway station
    {Coordinate{8.80066, 47.2136}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hurden railway station
    {Coordinate{8.75938, 47.2042}, Tz::Europe_Zurich, CountryId{"CH"}}, // Freienbach SOB railway station
    {Coordinate{8.7562, 47.2073}, Tz::Europe_Zurich, CountryId{"CH"}}, // Freienbach SBB railway station
    {Coordinate{8.82279, 47.1943}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altendorf railway station
    {Coordinate{8.64629, 47.516}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pfungen-Neftenbach railway station
    {Coordinate{8.50364, 47.4874}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederglatt railway station
    {Coordinate{8.5106, 47.4702}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberglatt Station
    {Coordinate{8.37371, 47.5653}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rümikon AG railway station
    {Coordinate{8.3528, 47.5684}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mellikon railway station
    {Coordinate{8.32704, 47.5695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rekingen AG railway station
    {Coordinate{8.27793, 47.6005}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rietheim railway station
    {Coordinate{8.23999, 47.6093}, Tz::Europe_Zurich, CountryId{"CH"}}, // Koblenz Dorf railway station
    {Coordinate{8.62586, 47.6829}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuhausen railway station
    {Coordinate{13.6618, 51.0132}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freital-Potschappel station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Anrath station
    {Coordinate{7.64556, 50.6872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenkirchen (Westerw) station
    {Coordinate{7.96625, 49.2053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Annweiler am Trifels station
    {Coordinate{8.0028, 49.1031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107129
    {Coordinate{7.69807, 47.9197}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Krozingen station
    {Coordinate{13.4785, 52.5012}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Rummelsburg railway station
    {Coordinate{11.4085, 47.7235}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107135
    {Coordinate{13.22, 47.4173}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bischofshofen railway station
    {Coordinate{12.9521, 50.8612}, Tz::Europe_Berlin, CountryId{"DE"}}, // Chemnitz-Hilbersdorf station
    {Coordinate{7.4283, 49.2454}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107147
    {Coordinate{10.138, 50.1312}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebenhausen (Unterfr) station
    {Coordinate{7.89941, 49.4903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Enkenbach station
    {Coordinate{6.82356, 50.8104}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erftstadt station
    {Coordinate{8.09867, 47.8716}, Tz::Europe_Berlin, CountryId{"DE"}}, // Feldberg-Bärental Station
    {Coordinate{7.77304, 49.2031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hinterweidenthal Ost station
    {Coordinate{8.89617, 49.4428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107186
    {Coordinate{7.89667, 49.4428}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochspeyer station
    {Coordinate{13.2714, 52.6725}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hohen Neuendorf West station
    {Coordinate{14.9024, 51.3039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Horka Pbf station
    {Coordinate{9.7628, 50.6733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107193
    {Coordinate{9.60415, 50.2326}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107198
    {Coordinate{8.1977, 49.0792}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107199
    {Coordinate{7.701, 49.5001}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107201
    {Coordinate{10.098, 54.3112}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kiel-Hassee CITTI-PARK station
    {Coordinate{11.9884, 51.7522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köthen railway station
    {Coordinate{8.07436, 49.3733}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lambrecht (Pfalz) station
    {Coordinate{11.8527, 48.4381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenbach station
    {Coordinate{8.5037, 49.5016}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim-Käfertal station
    {Coordinate{8.81304, 49.3208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meckesheim station
    {Coordinate{9.14667, 49.3522}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mosbach (Baden) station
    {Coordinate{11.193, 47.6823}, Tz::Europe_Berlin, CountryId{"DE"}}, // Murnau station
    {Coordinate{9.02861, 50.6167}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mücke (Hesse) station
    {Coordinate{7.90111, 50.6247}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nistertal-Bad Marienberg station
    {Coordinate{7.42624, 51.8922}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nottuln-Appelhülsen station
    {Coordinate{7.65284, 49.5381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107260
    {Coordinate{7.4442, 49.5421}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107280
    {Coordinate{7.4404, 49.4852}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107282
    {Coordinate{7.24275, 51.2153}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remscheid-Lüttringhausen station
    {Coordinate{11.0971, 47.9825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107284
    {Coordinate{8.1414, 49.1379}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rohrbach Station
    {Coordinate{8.829, 49.9732}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rödermark-Ober-Roden station
    {Coordinate{11.09, 48.0529}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Schondorf (Bay)
    {Coordinate{7.68757, 49.3591}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schopp station
    {Coordinate{7.44845, 49.5191}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15107299
    {Coordinate{8.2732, 49.0455}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wörth (Rhein) station
    {Coordinate{8.66468, 47.7173}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herblingen railway station
    {Coordinate{8.70389, 47.7453}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thayngen railway station
    {Coordinate{8.53276, 47.4543}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rümlang railway station
    {Coordinate{8.48841, 47.4786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederhasli railway station
    {Coordinate{8.44684, 47.49}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinmaur railway station
    {Coordinate{16.4654, 48.146}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Kaiserebersdorf railway station
    {Coordinate{6.975, 50.9408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln Messe/Deutz station
    {Coordinate{18.3275, 47.6647}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tata railway station
    {Coordinate{18.1136, 47.7494}, Tz::Europe_Budapest, CountryId{"HU"}}, // Komárom railway station
    {Coordinate{18.0039, 47.717}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ács railway station
    {Coordinate{12.3746, 51.3403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Markt station
    {Coordinate{17.1914, 47.1825}, Tz::Europe_Budapest, CountryId{"HU"}}, // Boba railway station
    {Coordinate{7.76528, 45.9844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rotenboden railway station
    {Coordinate{7.4834, 44.928}, Tz::Europe_Rome, CountryId{"IT"}}, // Airasca railway station
    {Coordinate{7.30176, 43.7347}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de l'Ariane - La Trinité
    {Coordinate{7.19454, 43.6624}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Laurent-du-Var
    {Coordinate{13.5382, 52.4525}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberspree station
    {Coordinate{7.75917, 53.2209}, Tz::Europe_Berlin, CountryId{"DE"}}, // Augustfehn railway station
    {Coordinate{7.84282, 46.3125}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ausserberg railway station
    {Coordinate{13.6734, 52.5183}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hoppegarten (Mark) station
    {Coordinate{13.7625, 52.5265}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fredersdorf station
    {Coordinate{7.13443, 43.6298}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villeneuve-Loubet-plage
    {Coordinate{5.09142, 43.6999}, Tz::Europe_Paris, CountryId{"FR"}}, // Lamanon
    {Coordinate{7.33956, 51.3238}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gevelsberg Hauptbahnhof
    {Coordinate{13.8206, 52.8728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Britz
    {Coordinate{8.33269, 44.3362}, Tz::Europe_Rome, CountryId{"IT"}}, // Altare
    {Coordinate{8.19189, 44.3907}, Tz::Europe_Rome, CountryId{"IT"}}, // Cengio
    {Coordinate{8.5428, 44.3423}, Tz::Europe_Rome, CountryId{"IT"}}, // Celle Ligure railway halt
    {Coordinate{13.0334, 52.3237}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dallgow-Döberitz railway station
    {Coordinate{13.5642, 51.6206}, Tz::Europe_Berlin, CountryId{"DE"}}, // Doberlug-Kirchhain railway station
    {Coordinate{9.19753, 47.2267}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nesslau-Neu St. Johann Station
    {Coordinate{7.88116, 46.3065}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eggerberg railway station
    {Coordinate{13.0001, 52.3251}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elstal railway station
    {Coordinate{9.07723, 47.033}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ennenda railway station
    {Coordinate{24.2987, 56.921}, Tz::Europe_Riga, CountryId{"LV"}}, // Acone railway station
    {Coordinate{25.5775, 56.6336}, Tz::Europe_Riga, CountryId{"LV"}}, // Alotene
    {Coordinate{26.4075, 56.5303}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15218596
    {Coordinate{25.2442, 56.5083}, Tz::Europe_Riga, CountryId{"LV"}}, // Daudzeva
    {Coordinate{25.0436, 56.6583}, Tz::Europe_Riga, CountryId{"LV"}}, // Dendrārijs
    {Coordinate{26.6984, 57.1028}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15218900
    {Coordinate{23.9492, 56.6506}, Tz::Europe_Riga, CountryId{"LV"}}, // Garoza
    {Coordinate{24.2347, 56.6286}, Tz::Europe_Riga, CountryId{"LV"}}, // Iecava
    {Coordinate{25.9763, 56.6871}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219021
    {Coordinate{23.7567, 56.6508}, Tz::Europe_Riga, CountryId{"LV"}}, // Jelgava II
    {Coordinate{26.0187, 56.7339}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219083
    {Coordinate{22.7426, 57.1018}, Tz::Europe_Riga, CountryId{"LV"}}, // Līgciems Station
    {Coordinate{22.4194, 57.178}, Tz::Europe_Riga, CountryId{"LV"}}, // Līči Station
    {Coordinate{25.1008, 56.5375}, Tz::Europe_Riga, CountryId{"LV"}}, // Menta
    {Coordinate{24.3964, 56.5914}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219390
    {Coordinate{21.9314, 57.3089}, Tz::Europe_Riga, CountryId{"LV"}}, // Puze Station
    {Coordinate{24.2292, 56.9208}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219689
    {Coordinate{22.4846, 57.1319}, Tz::Europe_Riga, CountryId{"LV"}}, // Sabile Station
    {Coordinate{25.3703, 56.5106}, Tz::Europe_Riga, CountryId{"LV"}}, // Sece
    {Coordinate{23.2911, 56.8442}, Tz::Europe_Riga, CountryId{"LV"}}, // Slampe Station
    {Coordinate{25.8254, 56.6616}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219800
    {Coordinate{24.9281, 56.5625}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219879
    {Coordinate{26.7689, 56.5608}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219970
    {Coordinate{24.5367, 56.5903}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15219998
    {Coordinate{26.9383, 56.5608}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15220042
    {Coordinate{28.1161, 56.3917}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15220101
    {Coordinate{24.0856, 56.6414}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15220138
    {Coordinate{7.78222, 45.9833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gornergrat railway station
    {Coordinate{11.4067, 52.2847}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haldensleben station
    {Coordinate{9.38861, 52.3792}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haste (Han) station
    {Coordinate{8.66833, 52.1581}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hiddenhausen-Schweicheln station
    {Coordinate{7.76459, 46.3224}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hohtenn railway station
    {Coordinate{8.58934, 47.2585}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horgen Oberdorf railway station
    {Coordinate{11.7192, 48.0188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Höhenkirchen-Siegertsbrunn station
    {Coordinate{7.66061, 51.585}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kamen station
    {Coordinate{7.67148, 46.4952}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kandersteg railway station
    {Coordinate{13.62, 53.925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Klein Bünzow railway station
    {Coordinate{7.21349, 45.7066}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15241314
    {Coordinate{7.90852, 46.3014}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lalden railway station
    {Coordinate{9.70722, 46.8192}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langwies (Rhaetian Railway station)
    {Coordinate{9.61333, 46.8317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lüen-Castiel
    {Coordinate{7.27056, 53.5208}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marienhafe railway station
    {Coordinate{8.27545, 47.4279}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mellingen Heitersberg railway station
    {Coordinate{9.08142, 47.01}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mitlödi railway station
    {Coordinate{59.3831, 56.2208}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Araslanovo (railroad station in p.Araslanovo)
    {Coordinate{11.7858, 48.3537}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Airport Terminal station
    {Coordinate{2.32556, 48.8606}, Tz::Europe_Paris, CountryId{"FR"}}, // Musée d'Orsay
    {Coordinate{8.23507, 47.4145}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mägenwil railway station
    {Coordinate{7.69077, 46.6385}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mülenen railway station
    {Coordinate{13.9033, 53.4417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nechlin railway station
    {Coordinate{9.05954, 47.064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Netstal railway station
    {Coordinate{9.78722, 53.4728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neu Wulmstorf station
    {Coordinate{8.02207, 51.8017}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubeckum station
    {Coordinate{8.33131, 47.4504}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuenhof railway station
    {Coordinate{14.2139, 51.0211}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt (Sachs) railway station
    {Coordinate{9.455, 52.5028}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt am Rübenberge station
    {Coordinate{9.06211, 47.1223}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nieder- and Oberurnen railway station
    {Coordinate{7.54, 44.938}, Tz::Europe_Rome, CountryId{"IT"}}, // None railway station
    {Coordinate{9.06947, 47.0988}, Tz::Europe_Zurich, CountryId{"CH"}}, // Näfels-Mollis railway station
    {Coordinate{7.03056, 49.3044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fischbach-Camphausen
    {Coordinate{6.95667, 49.2419}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarbrücken-Burbach
    {Coordinate{7.00444, 49.2653}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jägersfreude
    {Coordinate{8.8107, 53.2833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oldenbüttel station
    {Coordinate{8.21477, 47.4071}, Tz::Europe_Zurich, CountryId{"CH"}}, // Othmarsingen railway station
    {Coordinate{9.67167, 46.8294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Peist (Rhaetian Railway station)
    {Coordinate{7.4255, 44.9217}, Tz::Europe_Rome, CountryId{"IT"}}, // Piscina di Pinerolo railway station
    {Coordinate{7.69077, 46.6249}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reichenbach im Kandertal railway station
    {Coordinate{8.71208, 47.1968}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riedmatt railway station
    {Coordinate{7.7822, 45.2186}, Tz::Europe_Rome, CountryId{"IT"}}, // San Benigno Canavese railway station
    {Coordinate{9.65389, 46.8289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sankt Peter-Molinis station
    {Coordinate{24.6171, 56.8082}, Tz::Europe_Riga, CountryId{"LV"}}, // Pārogre Station
    {Coordinate{7.045, 49.1431}, Tz::Europe_Berlin, CountryId{"DE"}}, // Auersmacher
    {Coordinate{7.03472, 49.1794}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bübingen
    {Coordinate{7.03083, 49.1975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Güdingen
    {Coordinate{7.04917, 49.2278}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schafbrücke
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Renchen
    {Coordinate{7.05764, 47.4398}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courchavon
    {Coordinate{7.12833, 47.4241}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alle station
    {Coordinate{7.01653, 47.4925}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boncourt
    {Coordinate{6.47939, 46.9053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Verrières
    {Coordinate{9.74917, 47.505}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bregenz railway station
    {Coordinate{8.00294, 49.4143}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weidenthal station
    {Coordinate{7.80615, 49.1024}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15297228
    {Coordinate{8.12722, 49.2839}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Edenkoben
    {Coordinate{4.47068, 46.3914}, Tz::Europe_Paris, CountryId{"FR"}}, // Q15300177
    {Coordinate{4.88409, 46.4509}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fleurville - Pont-de-Vaux
    {Coordinate{9.65073, 46.6712}, Tz::Europe_Zurich, CountryId{"CH"}}, // Alvaneu
    {Coordinate{7.84079, 49.8067}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15303880
    {Coordinate{37.3815, 55.6395}, Tz::Europe_Moscow, CountryId{"RU"}}, // Новопеределкино (платформа)
    {Coordinate{12.4297, 50.8928}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gößnitz station
    {Coordinate{6.23055, 50.7643}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q153200
    {Coordinate{8.07051, 49.5545}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Eisenberg, Rhineland-Palatinate
    {Coordinate{}, Tz::Europe_Paris, CountryId{"FR"}}, // Q15401642
    {Coordinate{}, Tz::Europe_Paris, CountryId{"FR"}}, // Q15401655
    {Coordinate{}, Tz::Europe_Paris, CountryId{"FR"}}, // Q15401658
    {Coordinate{12.4587, 52.4996}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Pritzerbe
    {Coordinate{11.94, 48.0433}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grafing Bahnhof
    {Coordinate{15.4484, 47.0538}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1544082
    {Coordinate{13.5204, 51.2963}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großenhain Berliner Bahnhof
    {Coordinate{11.5308, 48.071}, Tz::Europe_Berlin, CountryId{"DE"}}, // Grosshesselohe Isartal station
    {Coordinate{25.6436, 56.8972}, Tz::Europe_Riga, CountryId{"LV"}}, // Q15494548
    {Coordinate{7.75058, 49.1975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15496747
    {Coordinate{12.5197, 48.2482}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühldorf (Oberbayern) station
    {Coordinate{13.2476, 51.5833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Falkenberg (Elster) station
    {Coordinate{30.7711, 50.4125}, Tz::Europe_Kiev, CountryId{"UA"}}, // Imeni Heorhiya Kirpy
    {Coordinate{13.6559, 51.1031}, Tz::Europe_Berlin, CountryId{"DE"}}, // Radebeul-Weintraube station
    {Coordinate{6.09407, 46.2206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vernier
    {Coordinate{6.07723, 46.2223}, Tz::Europe_Zurich, CountryId{"CH"}}, // Meyrin
    {Coordinate{6.06578, 46.2212}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zimeysa
    {Coordinate{13.0709, 42.41}, Tz::Europe_Rome, CountryId{"IT"}}, // Antrodoco-Borgo Velino railway station
    {Coordinate{13.0763, 42.4154}, Tz::Europe_Rome, CountryId{"IT"}}, // Antrodoco Centro railway halt
    {Coordinate{13.096, 42.398}, Tz::Europe_Rome, CountryId{"IT"}}, // Rocca di Fondi railway station
    {Coordinate{13.1443, 42.3884}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617142
    {Coordinate{13.19, 42.3606}, Tz::Europe_Rome, CountryId{"IT"}}, // Sella di Corno railway station
    {Coordinate{13.5629, 42.2507}, Tz::Europe_Rome, CountryId{"IT"}}, // Fagnano-Campana railway station
    {Coordinate{13.6044, 42.2228}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617152
    {Coordinate{13.642, 42.2049}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617153
    {Coordinate{13.6609, 42.1974}, Tz::Europe_Rome, CountryId{"IT"}}, // Beffi railway station
    {Coordinate{13.8091, 42.0981}, Tz::Europe_Rome, CountryId{"IT"}}, // Raiano railway station
    {Coordinate{13.7397, 42.1436}, Tz::Europe_Rome, CountryId{"IT"}}, // Molina-Castelvecchio Subequo railway station
    {Coordinate{13.8719, 42.0804}, Tz::Europe_Rome, CountryId{"IT"}}, // Pratola Peligna Superiore railway station
    {Coordinate{13.7111, 42.1767}, Tz::Europe_Rome, CountryId{"IT"}}, // Acciano railway station
    {Coordinate{10.6475, 45.1443}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellucchio railway station
    {Coordinate{10.6043, 45.1298}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617293
    {Coordinate{10.5735, 45.1225}, Tz::Europe_Rome, CountryId{"IT"}}, // San Michele in Bosco railway halt
    {Coordinate{10.5337, 45.1244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15617296
    {Coordinate{14.25, 51.4333}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hoyerswerda railway station
    {Coordinate{7.05539, 49.2994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sulzbach (Saar) station
    {Coordinate{11.189, 54.4436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15635107
    {Coordinate{9.59111, 47.4669}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rheineck railway station
    {Coordinate{9.50521, 47.4778}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rorschach station
    {Coordinate{9.63834, 47.4534}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15639432
    {Coordinate{10.0061, 44.6247}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15639770
    {Coordinate{9.92705, 44.1735}, Tz::Europe_Rome, CountryId{"IT"}}, // Q15639791
    {Coordinate{14.1, 51.2667}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kamenz railway station
    {Coordinate{7.6349, 51.1084}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15648785
    {Coordinate{39.9743, 43.412}, Tz::Europe_Moscow, CountryId{"RU"}}, // Olympic Park
    {Coordinate{8.71083, 49.2194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Odenheim train station
    {Coordinate{14.4489, 50.0642}, Tz::Europe_Prague, CountryId{"CZ"}}, // Praha-Vršovice railway station
    {Coordinate{24.8453, 48.7364}, Tz::Europe_Kiev, CountryId{"UA"}}, // Otynia
    {Coordinate{25.9294, 48.3011}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chernivtsi
    {Coordinate{8.1128, 53.144}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rastede railway station
    {Coordinate{8.09, 53.2356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Varel railway station
    {Coordinate{8.03183, 53.4899}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sande railway station
    {Coordinate{8.11479, 53.5187}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wilhelmshaven railway station
    {Coordinate{8.201, 53.0705}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wüsting railway station
    {Coordinate{8.4051, 53.0324}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heidkrug railway station
    {Coordinate{8.3157, 53.0556}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bookholzberg railway station
    {Coordinate{8.3447, 53.0503}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schierbrok railway station
    {Coordinate{8.5989, 53.0695}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hoykenkamp railway station
    {Coordinate{11.3677, 44.5777}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelmaggiore railway station
    {Coordinate{11.3789, 44.6467}, Tz::Europe_Rome, CountryId{"IT"}}, // San Giorgio di Piano railway station
    {Coordinate{11.4046, 44.698}, Tz::Europe_Rome, CountryId{"IT"}}, // San Pietro in Casale railway station
    {Coordinate{11.4417, 44.7377}, Tz::Europe_Rome, CountryId{"IT"}}, // Galliera railway station
    {Coordinate{11.5439, 44.7958}, Tz::Europe_Rome, CountryId{"IT"}}, // Coronella railway station
    {Coordinate{10.9779, 44.1558}, Tz::Europe_Rome, CountryId{"IT"}}, // Porretta Terme railway station
    {Coordinate{10.9807, 44.1776}, Tz::Europe_Rome, CountryId{"IT"}}, // Silla railway station
    {Coordinate{11.0535, 44.23}, Tz::Europe_Rome, CountryId{"IT"}}, // Riola railway station
    {Coordinate{11.1141, 44.2828}, Tz::Europe_Rome, CountryId{"IT"}}, // Vergato railway station
    {Coordinate{11.1618, 44.3106}, Tz::Europe_Rome, CountryId{"IT"}}, // Pioppe di Salvaro railway station
    {Coordinate{41.3792, 56.3897}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q15714625
    {Coordinate{11.5171, 50.3572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dürrenwaid station
    {Coordinate{7.59, 50.3575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Koblenz Stadtmitte station
    {Coordinate{10.6981, 53.8022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübeck-Flughafen station
    {Coordinate{7.01861, 49.2303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Saarbrücken-Ost station
    {Coordinate{16.3064, 48.1982}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572413
    {Coordinate{16.329, 48.2313}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Gersthof
    {Coordinate{16.3411, 48.2401}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572420
    {Coordinate{16.3586, 48.1802}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Matzleinsdorfer Platz railway station
    {Coordinate{16.3443, 48.2444}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572425
    {Coordinate{16.3818, 48.188}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Quartier Belvedere train station
    {Coordinate{16.3834, 48.2348}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q1572428
    {Coordinate{8.74076, 48.7086}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15725866
    {Coordinate{12.3864, 51.3008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig-Connewitz railway station
    {Coordinate{8.52271, 45.4027}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponzana railway station
    {Coordinate{9.46722, 51.23}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785148
    {Coordinate{7.28184, 49.2619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785154
    {Coordinate{7.77131, 49.1547}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785159
    {Coordinate{8.10822, 49.564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785163
    {Coordinate{7.45633, 49.4948}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785166
    {Coordinate{13.5184, 51.4722}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elsterwerda-Biehla station
    {Coordinate{8.21066, 49.4884}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erpolzheim station
    {Coordinate{7.96985, 49.439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankenstein (Pfalz) station
    {Coordinate{9.59564, 49.6981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785172
    {Coordinate{11.5014, 47.2769}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q15785173
    {Coordinate{8.67521, 49.3799}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heidelberg-Kirchheim/Rohrbach station
    {Coordinate{8.72357, 48.4823}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Hochdorf (b Horb)
    {Coordinate{7.74978, 49.4475}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Kaiserslautern West
    {Coordinate{7.83509, 48.3403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lahr (Schwarzw) station
    {Coordinate{7.56602, 49.4163}, Tz::Europe_Berlin, CountryId{"DE"}}, // Landstuhl station
    {Coordinate{9.14595, 49.0764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785185
    {Coordinate{8.13336, 50.3776}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindenholzhausen station
    {Coordinate{8.84145, 49.4048}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785188
    {Coordinate{8.16125, 50.3593}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederbrechen station
    {Coordinate{8.18806, 50.3546}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberbrechen station
    {Coordinate{7.7139, 47.2889}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15785193
    {Coordinate{13.0786, 47.7888}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q15785197
    {Coordinate{10.1739, 51.8875}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seesen station
    {Coordinate{11.0482, 48.0946}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15785204
    {Coordinate{7.16564, 49.467}, Tz::Europe_Berlin, CountryId{"DE"}}, // St. Wendel station
    {Coordinate{10.5627, 51.9552}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vienenburg station
    {Coordinate{26.3108, 56.1844}, Tz::Europe_Riga, CountryId{"LV"}}, // Sergunta
    {Coordinate{26.478, 55.9338}, Tz::Europe_Riga, CountryId{"LV"}}, // 383. kilometers
    {Coordinate{26.4997, 55.8954}, Tz::Europe_Riga, CountryId{"LV"}}, // 387. kilometers
    {Coordinate{7.31855, 49.2683}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15792329
    {Coordinate{8.78281, 48.4798}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eutingen im Gäu station
    {Coordinate{8.1813, 49.5372}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15792331
    {Coordinate{8.28764, 49.1595}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rülzheim station
    {Coordinate{9.73397, 49.1082}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwäbisch Hall station
    {Coordinate{9.36794, 49.5783}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15792337
    {Coordinate{24.2532, 56.883}, Tz::Europe_Riga, CountryId{"LV"}}, // Rumbula Station
    {Coordinate{24.3242, 56.8644}, Tz::Europe_Riga, CountryId{"LV"}}, // Dole
    {Coordinate{24.6536, 56.7821}, Tz::Europe_Riga, CountryId{"LV"}}, // Ciemupe
    {Coordinate{25.206, 56.6311}, Tz::Europe_Riga, CountryId{"LV"}}, // Muldakmens
    {Coordinate{14.3979, 52.3369}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pillgram
    {Coordinate{14.2814, 52.3464}, Tz::Europe_Berlin, CountryId{"DE"}}, // Briesen (Mark) station
    {Coordinate{14.1653, 52.3571}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berkenbrück station
    {Coordinate{13.922, 52.4}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hangelsberg station
    {Coordinate{13.8716, 53.5283}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blumenhagen
    {Coordinate{14.148, 53.9529}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heringsdorf Neuhof railway station
    {Coordinate{13.694, 52.7746}, Tz::Europe_Berlin, CountryId{"DE"}}, // Melchow
    {Coordinate{13.9287, 52.8307}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederfinow
    {Coordinate{13.6752, 52.7558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Biesenthal
    {Coordinate{30.6058, 46.5247}, Tz::Europe_Kiev, CountryId{"UA"}}, // Usatove
    {Coordinate{29.5361, 45.9889}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hnadental
    {Coordinate{10.902, 47.8126}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Schongau
    {Coordinate{6.12531, 46.1888}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lancy-Pont-Rouge
    {Coordinate{12.3791, 51.2501}, Tz::Europe_Berlin, CountryId{"DE"}}, // Markkleeberg-Gaschwitz railway station
    {Coordinate{11.2729, 43.3856}, Tz::Europe_Rome, CountryId{"IT"}}, // Badesse
    {Coordinate{11.4063, 43.2944}, Tz::Europe_Rome, CountryId{"IT"}}, // Arbia
    {Coordinate{10.4706, 43.5865}, Tz::Europe_Rome, CountryId{"IT"}}, // Collesalvetti railway station
    {Coordinate{8.56693, 44.3568}, Tz::Europe_Rome, CountryId{"IT"}}, // Varazze railway station
    {Coordinate{2.8411, 50.3352}, Tz::Europe_Paris, CountryId{"FR"}}, // Q15865337
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neustadt (Weinstr) Böbig station
    {Coordinate{12.843, 50.8156}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15886751
    {Coordinate{8.35117, 49.0145}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q15891050
    {Coordinate{38.035, 48.7153}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q1590535
    {Coordinate{16.4261, 48.1542}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Zentralfriedhof
    {Coordinate{8.2831, 45.7163}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgosesia railway station
    {Coordinate{11.6305, 52.1093}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Magdeburg-Buckau
    {Coordinate{7.5631, 52.0218}, Tz::Europe_Berlin, CountryId{"DE"}}, // Münster-Häger
    {Coordinate{7.48186, 52.0515}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenberge
    {Coordinate{7.18419, 52.2016}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ochtrup
    {Coordinate{7.37545, 52.1232}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinfurt-Grottenkamp
    {Coordinate{7.39696, 52.1188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinfurt-Borghorst
    {Coordinate{7.46133, 52.0778}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nordwalde station
    {Coordinate{7.78105, 51.9811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Telgte
    {Coordinate{7.5282, 51.9146}, Tz::Europe_Berlin, CountryId{"DE"}}, // Münster-Albachten
    {Coordinate{7.59895, 51.8841}, Tz::Europe_Berlin, CountryId{"DE"}}, // Münster-Amelsbüren
    {Coordinate{7.59877, 51.8171}, Tz::Europe_Berlin, CountryId{"DE"}}, // Davensberg
    {Coordinate{7.6892, 51.8446}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rinkerode
    {Coordinate{9.015, 53.0057}, Tz::Europe_Berlin, CountryId{"DE"}}, // Achim railway station
    {Coordinate{9.2464, 52.8469}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dörverden railway station
    {Coordinate{9.23139, 52.7829}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eystrup railway station
    {Coordinate{9.87639, 53.3244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buchholz (Nordheide) railway station
    {Coordinate{9.19497, 52.9779}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langwedel railway station
    {Coordinate{9.6988, 52.4585}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover Flughafen railway station
    {Coordinate{10.0636, 52.2117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hämelerwald station
    {Coordinate{9.8429, 52.2328}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sarstedt railway station
    {Coordinate{9.45102, 52.4222}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wunstorf station
    {Coordinate{7.88684, 53.2022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Westerstede-Ocholt railway station
    {Coordinate{9.7319, 53.2717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tostedt railway station
    {Coordinate{10.359, 52.2579}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vechelde station
    {Coordinate{8.25528, 53.0545}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sandkrug
    {Coordinate{8.26644, 52.9905}, Tz::Europe_Berlin, CountryId{"DE"}}, // Huntlosen
    {Coordinate{8.01466, 53.5074}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sanderbusch
    {Coordinate{8.8871, 53.054}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremen-Hemelingen
    {Coordinate{9.08192, 53.0077}, Tz::Europe_Berlin, CountryId{"DE"}}, // Baden
    {Coordinate{9.1241, 52.9991}, Tz::Europe_Berlin, CountryId{"DE"}}, // Etelsen
    {Coordinate{7.7496, 44.9204}, Tz::Europe_Rome, CountryId{"IT"}}, // Villastellone
    {Coordinate{8.55138, 44.8648}, Tz::Europe_Rome, CountryId{"IT"}}, // Cantalupo railway station
    {Coordinate{8.85581, 44.8106}, Tz::Europe_Rome, CountryId{"IT"}}, // Villalvernia railway station
    {Coordinate{6.01755, 46.1878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Russin
    {Coordinate{8.60861, 46.5275}, Tz::Europe_Zurich, CountryId{"CH"}}, // Airolo railway station
    {Coordinate{8.69015, 46.5106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ambrì-Piotta railway station
    {Coordinate{8.69611, 47.1317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altmatt station
    {Coordinate{8.66917, 47.0933}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biberegg station
    {Coordinate{6.51889, 46.6981}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964055
    {Coordinate{7.10611, 46.8169}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964056
    {Coordinate{7.10917, 46.8219}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964057
    {Coordinate{6.81167, 46.9297}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bevaix
    {Coordinate{6.87778, 46.9797}, Tz::Europe_Zurich, CountryId{"CH"}}, // Auvernier
    {Coordinate{7.2725, 47.1447}, Tz::Europe_Zurich, CountryId{"CH"}}, // Biel Mett
    {Coordinate{7.42806, 47.1947}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bettlach station
    {Coordinate{7.495, 47.2083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bellach station
    {Coordinate{8.36556, 47.2469}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964066
    {Coordinate{8.51694, 47.1831}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964067
    {Coordinate{7.90833, 47.3203}, Tz::Europe_Zurich, CountryId{"CH"}}, // Aarburg-Oftringen station
    {Coordinate{9.50522, 47.0103}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bad Ragaz station
    {Coordinate{9.55667, 47.3742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altstätten SG station
    {Coordinate{9.64139, 47.4361}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964071
    {Coordinate{9.43333, 47.5106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964072
    {Coordinate{9.42472, 47.5214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964073
    {Coordinate{9.26611, 47.6214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Altnau station
    {Coordinate{9.02194, 47.6731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Berlingen station
    {Coordinate{7.49833, 46.8892}, Tz::Europe_Zurich, CountryId{"CH"}}, // Belp railway station
    {Coordinate{7.55944, 47.0956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964077
    {Coordinate{6.52368, 46.606}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cossonay
    {Coordinate{6.47472, 46.715}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964082
    {Coordinate{6.69917, 46.5097}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964083
    {Coordinate{6.77861, 46.4811}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964085
    {Coordinate{7.00056, 46.7492}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964086
    {Coordinate{6.78639, 46.8169}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964087
    {Coordinate{6.95722, 46.8289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964088
    {Coordinate{6.72306, 46.8508}, Tz::Europe_Zurich, CountryId{"CH"}}, // Concise
    {Coordinate{6.835, 46.9594}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boudry
    {Coordinate{6.84889, 46.9678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Colombier
    {Coordinate{7.02361, 47.0386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cornaux
    {Coordinate{8.31472, 47.3053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964093
    {Coordinate{8.45722, 47.1781}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964094
    {Coordinate{8.47111, 47.1822}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cham Alpenblick train station
    {Coordinate{8.35639, 47.0936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964096
    {Coordinate{7.95694, 47.2628}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964097
    {Coordinate{9.47878, 47.1688}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buchs station
    {Coordinate{6.47819, 46.6967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964103
    {Coordinate{6.54083, 46.5292}, Tz::Europe_Zurich, CountryId{"CH"}}, // Denges-Echandens
    {Coordinate{9.34806, 47.0967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964105
    {Coordinate{6.81111, 46.6106}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964106
    {Coordinate{7.035, 46.7513}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964107
    {Coordinate{6.84306, 46.8444}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964108
    {Coordinate{6.88917, 46.8161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964109
    {Coordinate{6.9775, 46.8186}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cousset Station
    {Coordinate{7.1225, 46.8678}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964111
    {Coordinate{7.14972, 46.9}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964112
    {Coordinate{7.03972, 47.0519}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cressier railway station
    {Coordinate{7.61889, 47.2183}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964114
    {Coordinate{7.79889, 47.3147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964115
    {Coordinate{7.94667, 47.3542}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dulliken train station
    {Coordinate{7.97833, 47.3564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Däniken Train Station
    {Coordinate{8.235, 47.3736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964118
    {Coordinate{8.34222, 47.0842}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964121
    {Coordinate{7.97889, 47.2175}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964122
    {Coordinate{9.383, 47.544}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964123
    {Coordinate{8.87639, 47.6456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964125
    {Coordinate{9.08583, 47.67}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964126
    {Coordinate{8.7525, 47.6853}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964127
    {Coordinate{7.31944, 46.8885}, Tz::Europe_Zurich, CountryId{"CH"}}, // Flamatt railway station
    {Coordinate{6.72306, 46.4969}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964134
    {Coordinate{6.87, 46.735}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964135
    {Coordinate{7.06611, 46.8319}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964136
    {Coordinate{6.64167, 46.8061}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grandson
    {Coordinate{7.12528, 46.8167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964138
    {Coordinate{6.78111, 46.8992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gorgier-Saint-Aubin
    {Coordinate{7.84389, 47.3303}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964141
    {Coordinate{8.16667, 47.4286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964142
    {Coordinate{8.2075, 47.3894}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hendschiken train station
    {Coordinate{8.44972, 47.1692}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964144
    {Coordinate{8.45028, 47.1736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964145
    {Coordinate{8.39417, 47.1208}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964146
    {Coordinate{9.6275, 47.4103}, Tz::Europe_Zurich, CountryId{"CH"}}, // Heerbrugg Station
    {Coordinate{9.46333, 47.4903}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horn station
    {Coordinate{9.46667, 47.4739}, Tz::Europe_Zurich, CountryId{"CH"}}, // Goldach station
    {Coordinate{9.2925, 47.6086}, Tz::Europe_Zurich, CountryId{"CH"}}, // Güttingen station
    {Coordinate{9.27667, 47.39}, Tz::Europe_Zurich, CountryId{"CH"}}, // Herisau railway station
    {Coordinate{7.65556, 47.0161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964153
    {Coordinate{7.38944, 47.1917}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grenchen Nord
    {Coordinate{7.23444, 46.9422}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gümmenen station
    {Coordinate{8.83974, 46.4409}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lavorgo railway station
    {Coordinate{6.51722, 46.6589}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964160
    {Coordinate{6.67833, 46.5131}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964161
    {Coordinate{7.06639, 47.0567}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Landeron
    {Coordinate{7.09528, 47.0628}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Neuveville
    {Coordinate{7.13476, 47.0837}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ligerz
    {Coordinate{7.36667, 47.1794}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lengnau
    {Coordinate{7.94222, 47.3072}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964166
    {Coordinate{8.01917, 47.3247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964167
    {Coordinate{8.02653, 47.3372}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964168
    {Coordinate{9.3175, 47.5956}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964169
    {Coordinate{8.66222, 47.6833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964170
    {Coordinate{7.78417, 46.9392}, Tz::Europe_Zurich, CountryId{"CH"}}, // Langnau im Emmental railway station
    {Coordinate{7.62139, 46.8806}, Tz::Europe_Zurich, CountryId{"CH"}}, // Konolfingen Station
    {Coordinate{7.23802, 46.9026}, Tz::Europe_Zurich, CountryId{"CH"}}, // Laupen railway station
    {Coordinate{8.85028, 46.1453}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964178
    {Coordinate{6.50806, 46.5181}, Tz::Europe_Zurich, CountryId{"CH"}}, // Morges-St-Jean
    {Coordinate{6.51944, 46.5231}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lonay-Préverenges
    {Coordinate{9.17306, 47.1179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964181
    {Coordinate{9.215, 47.1133}, Tz::Europe_Zurich, CountryId{"CH"}}, // Murg station
    {Coordinate{9.27639, 47.1131}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964183
    {Coordinate{9.41778, 47.0539}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mels railway station
    {Coordinate{6.78583, 46.5086}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964185
    {Coordinate{6.80278, 46.6681}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964186
    {Coordinate{7.09639, 46.7889}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964187
    {Coordinate{7.01167, 46.8283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964188
    {Coordinate{7.58361, 47.2172}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964189
    {Coordinate{8.34, 47.2767}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964190
    {Coordinate{8.38833, 47.225}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964191
    {Coordinate{8.91417, 47.6442}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964193
    {Coordinate{9.05278, 47.6736}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mannenbach-Salenstein  station
    {Coordinate{9.41444, 47.4747}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964195
    {Coordinate{7.8321, 47.2654}, Tz::Europe_Zurich, CountryId{"CH"}}, // Murgenthal station
    {Coordinate{7.01083, 47.0092}, Tz::Europe_Zurich, CountryId{"CH"}}, // Marin-Epagnier
    {Coordinate{7.30639, 47.0764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964198
    {Coordinate{7.65556, 47.0161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964199
    {Coordinate{8.88722, 46.1511}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964201
    {Coordinate{6.65806, 46.5147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964202
    {Coordinate{6.76583, 46.4939}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964203
    {Coordinate{6.83722, 46.5725}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964205
    {Coordinate{7.06514, 46.7661}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964206
    {Coordinate{7.1375, 46.8431}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964207
    {Coordinate{7.11444, 46.9119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964208
    {Coordinate{6.90333, 46.9839}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuchâtel-Serrières
    {Coordinate{7.34028, 47.1714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pieterlen
    {Coordinate{7.77194, 47.3053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964211
    {Coordinate{7.8975, 47.3486}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964212
    {Coordinate{8.40472, 47.1661}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964213
    {Coordinate{8.13861, 47.1389}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964214
    {Coordinate{8.11417, 47.1553}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964215
    {Coordinate{7.9775, 47.1922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nebikon train station
    {Coordinate{7.96876, 47.2415}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reiden Station
    {Coordinate{8.04833, 47.3564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964219
    {Coordinate{8.08222, 47.3714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964220
    {Coordinate{9.57139, 47.3236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberriet station
    {Coordinate{9.58667, 47.3925}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964222
    {Coordinate{8.67472, 47.1058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rothenthurm station
    {Coordinate{8.6275, 47.08}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sattel-Aegeri station
    {Coordinate{8.97417, 46.1606}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sant'Antonino
    {Coordinate{8.80694, 46.135}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964229
    {Coordinate{7.06208, 46.7825}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964231
    {Coordinate{6.9825, 47.0147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Blaise CFF
    {Coordinate{8.12694, 47.4033}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964233
    {Coordinate{8.27306, 47.0908}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964235
    {Coordinate{8.24917, 47.0883}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964236
    {Coordinate{8.37361, 47.1047}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964237
    {Coordinate{7.98333, 47.3218}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964238
    {Coordinate{9.48528, 47.15}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964239
    {Coordinate{9.5025, 47.2417}, Tz::Europe_Zurich, CountryId{"CH"}}, // Salez-Sennwald train station
    {Coordinate{9.53611, 47.2867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964241
    {Coordinate{9.49389, 47.4786}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rorschach Hafen station
    {Coordinate{9.48944, 47.4756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964244
    {Coordinate{9.33806, 47.4078}, Tz::Europe_Zurich, CountryId{"CH"}}, // St. Gallen Haggen station
    {Coordinate{7.87917, 47.3064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rothrist station
    {Coordinate{7.81472, 47.2517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roggwil-Wynau station
    {Coordinate{6.98472, 47.0119}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Blaise-Lac
    {Coordinate{8.60722, 47.0478}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinen station
    {Coordinate{8.58528, 47.0522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinerberg station
    {Coordinate{6.88528, 46.6592}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964255
    {Coordinate{7.45667, 47.2006}, Tz::Europe_Zurich, CountryId{"CH"}}, // Selzach station
    {Coordinate{8, 47.3714}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönenwerd railway station
    {Coordinate{8.16694, 47.4517}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964258
    {Coordinate{8.39778, 47.1883}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964259
    {Coordinate{8.19583, 47.1161}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964260
    {Coordinate{8.07444, 47.18}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964261
    {Coordinate{9.49389, 47.1256}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sevelen Station
    {Coordinate{9.53639, 47.4808}, Tz::Europe_Zurich, CountryId{"CH"}}, // Staad station
    {Coordinate{9.44222, 47.5008}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964266
    {Coordinate{8.98111, 47.6644}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steckborn Station
    {Coordinate{8.77036, 47.6669}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964269
    {Coordinate{8.73194, 47.6875}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964270
    {Coordinate{8.6875, 47.6794}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964271
    {Coordinate{8.73444, 47.1976}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{6.53056, 46.5764}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vufflens-la-Ville
    {Coordinate{9.09472, 47.1299}, Tz::Europe_Zurich, CountryId{"CH"}}, // Weesen station
    {Coordinate{9.25501, 47.1139}, Tz::Europe_Zurich, CountryId{"CH"}}, // Unterterzen railway station
    {Coordinate{9.31306, 47.1197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964276
    {Coordinate{6.91625, 46.78}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964277
    {Coordinate{6.85014, 46.6214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964278
    {Coordinate{6.96056, 46.7206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964279
    {Coordinate{7.11667, 46.7897}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964280
    {Coordinate{6.7575, 46.8778}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vaumarcus
    {Coordinate{7.15667, 47.0936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Twann
    {Coordinate{7.19694, 47.1147}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tüscherz
    {Coordinate{7.65639, 47.2319}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964284
    {Coordinate{7.86861, 47.3414}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964285
    {Coordinate{8.16306, 47.4156}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964286
    {Coordinate{8.505, 47.1083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Walchwil Hörndli station
    {Coordinate{8.01889, 47.1839}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964288
    {Coordinate{8.51694, 47.0989}, Tz::Europe_Zurich, CountryId{"CH"}}, // Walchwil station
    {Coordinate{7.96333, 47.32}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964290
    {Coordinate{9.48033, 47.0716}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964291
    {Coordinate{9.50167, 47.0914}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964292
    {Coordinate{9.34028, 47.5858}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uttwil station
    {Coordinate{7.49611, 46.8586}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964294
    {Coordinate{7.55583, 47.1522}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964295
    {Coordinate{7.55361, 47.1283}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964296
    {Coordinate{8.72476, 47.1954}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wollerau railway station
    {Coordinate{6.6625, 46.7822}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yverdon-Champ Pittet
    {Coordinate{6.74249, 46.8003}, Tz::Europe_Zurich, CountryId{"CH"}}, // Yvonand
    {Coordinate{8.48611, 47.1803}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964302
    {Coordinate{8.48611, 47.1803}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964303
    {Coordinate{8.51694, 47.1683}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964304
    {Coordinate{8.515, 47.1622}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964305
    {Coordinate{8.51222, 47.1564}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964306
    {Coordinate{9.38861, 47.4631}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964309
    {Coordinate{7.46306, 47.0019}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964310
    {Coordinate{7.37528, 46.5531}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q15964311
    {Coordinate{9.2409, 51.3234}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hofgeismar-Hümme railway station
    {Coordinate{9.4749, 53.5961}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stade station
    {Coordinate{30.755, 46.554}, Tz::Europe_Kiev, CountryId{"UA"}}, // Odesa-Sortuvalna
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Ряжск I
    {Coordinate{7.06622, 51.6102}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gelsenkirchen-Hassel station
    {Coordinate{7.1005, 51.6541}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marl Mitte station
    {Coordinate{7.1311, 51.6826}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marl-Hamm station
    {Coordinate{8.66111, 49.2111}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Schönborn Süd station
    {Coordinate{8.66111, 49.2111}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Schönborn-Kronau station
    {Coordinate{19.0485, 47.5681}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aquincum HÉV station
    {Coordinate{30.4095, 59.0808}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16022985
    {Coordinate{7.817, 49.7272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsenz station
    {Coordinate{11.7761, 49.87}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16054528
    {Coordinate{8.27426, 49.1196}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinzabern station
    {Coordinate{12.5741, 48.8773}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Straubing
    {Coordinate{9.01229, 51.6218}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16054534
    {Coordinate{6.5731, 49.6953}, Tz::Europe_Berlin, CountryId{"DE"}}, // Konz
    {Coordinate{6.57667, 49.7039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kreuz Konz
    {Coordinate{6.53739, 49.7083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wasserliesch
    {Coordinate{6.57414, 49.6693}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kanzem
    {Coordinate{6.68347, 49.7797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pfalzel
    {Coordinate{6.37264, 49.5044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Besch
    {Coordinate{6.37606, 49.5388}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nennig
    {Coordinate{6.37225, 49.565}, Tz::Europe_Berlin, CountryId{"DE"}}, // Palzem
    {Coordinate{6.40665, 49.6084}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wincheringen
    {Coordinate{6.44101, 49.654}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nittel
    {Coordinate{6.46225, 49.6883}, Tz::Europe_Berlin, CountryId{"DE"}}, // Temmels
    {Coordinate{6.5119, 49.7101}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberbillig
    {Coordinate{6.5942, 49.3438}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niedaltdorf
    {Coordinate{6.6659, 49.3617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Siersburg
    {Coordinate{6.94494, 49.2436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Burbach Mitte
    {Coordinate{6.6485, 49.4096}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fremersdorf
    {Coordinate{6.55202, 46.5474}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bussigny station
    {Coordinate{9.02256, 53.0841}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sagehorn station
    {Coordinate{9.13356, 53.0969}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ottersberg railway station
    {Coordinate{9.25017, 53.1012}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sottrum railway station
    {Coordinate{9.5643, 53.197}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauenbrück railway station
    {Coordinate{9.81253, 53.3094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sprötze railway station
    {Coordinate{9.85524, 53.3159}, Tz::Europe_Berlin, CountryId{"DE"}}, // Suerhop station
    {Coordinate{9.92919, 53.3661}, Tz::Europe_Berlin, CountryId{"DE"}}, // Klecken railway station
    {Coordinate{9.97446, 53.4036}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hittfeld railway station
    {Coordinate{2.03417, 49.0494}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cergy – Saint-Christophe
    {Coordinate{9.75725, 53.5832}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rissen
    {Coordinate{9.79757, 53.5811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sülldorf
    {Coordinate{9.81446, 53.5764}, Tz::Europe_Berlin, CountryId{"DE"}}, // Iserbrook
    {Coordinate{10.0377, 53.5609}, Tz::Europe_Berlin, CountryId{"DE"}}, // Landwehr
    {Coordinate{10.044, 53.5384}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rothenburgsort
    {Coordinate{9.76062, 53.6751}, Tz::Europe_Berlin, CountryId{"DE"}}, // Prisdorf
    {Coordinate{9.71538, 53.6969}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tornesch
    {Coordinate{11.478, 48.1643}, Tz::Europe_Berlin, CountryId{"DE"}}, // München-Obermenzing
    {Coordinate{11.6989, 48.1183}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gronsdorf station
    {Coordinate{11.1966, 44.551}, Tz::Europe_Rome, CountryId{"IT"}}, // Anzola dell’Emilia railway station
    {Coordinate{10.1176, 44.8371}, Tz::Europe_Rome, CountryId{"IT"}}, // Borghetto Parmense railway station
    {Coordinate{11.2751, 44.4437}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgonuovo railway halt
    {Coordinate{11.0961, 44.2469}, Tz::Europe_Rome, CountryId{"IT"}}, // Carbona railway station
    {Coordinate{12.1019, 44.8365}, Tz::Europe_Rome, CountryId{"IT"}}, // Codigoro railway station
    {Coordinate{10.3828, 44.9279}, Tz::Europe_Rome, CountryId{"IT"}}, // Colorno railway station
    {Coordinate{11.8318, 44.5111}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268787
    {Coordinate{10.8154, 44.9392}, Tz::Europe_Rome, CountryId{"IT"}}, // Gonzaga-Reggiolo railway station
    {Coordinate{10.1402, 44.7493}, Tz::Europe_Rome, CountryId{"IT"}}, // Medesano railway station
    {Coordinate{11.11, 44.5104}, Tz::Europe_Rome, CountryId{"IT"}}, // Muffa railway station
    {Coordinate{10.1471, 44.8099}, Tz::Europe_Rome, CountryId{"IT"}}, // Noceto railway station
    {Coordinate{11.189, 44.3324}, Tz::Europe_Rome, CountryId{"IT"}}, // Pian di Venola railway station
    {Coordinate{11.2295, 44.4882}, Tz::Europe_Rome, CountryId{"IT"}}, // Pilastrino railway station
    {Coordinate{11.2693, 44.423}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontecchio Marconi railway station
    {Coordinate{11.241, 44.4855}, Tz::Europe_Rome, CountryId{"IT"}}, // Riale railway station
    {Coordinate{10.8677, 44.8857}, Tz::Europe_Rome, CountryId{"IT"}}, // Rolo-Novi-Fabbrico railway station
    {Coordinate{11.8258, 44.4903}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268803
    {Coordinate{11.0332, 44.4832}, Tz::Europe_Rome, CountryId{"IT"}}, // Savignano Comune railway station
    {Coordinate{11.047, 44.494}, Tz::Europe_Rome, CountryId{"IT"}}, // Savignano Mulino railway station
    {Coordinate{10.4463, 44.8432}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16268807
    {Coordinate{11.5231, 44.4368}, Tz::Europe_Rome, CountryId{"IT"}}, // Varignana railway station
    {Coordinate{11.0085, 44.4817}, Tz::Europe_Rome, CountryId{"IT"}}, // Vignola railway station
    {Coordinate{10.8421, 44.9158}, Tz::Europe_Rome, CountryId{"IT"}}, // Villanova di Reggiolo railway halt
    {Coordinate{11.218, 44.4926}, Tz::Europe_Rome, CountryId{"IT"}}, // Zola Centro railway station
    {Coordinate{11.2095, 44.4942}, Tz::Europe_Rome, CountryId{"IT"}}, // Zola Chiesa railway station
    {Coordinate{40.2886, 48.2625}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271814
    {Coordinate{40.2508, 48.2236}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271822
    {Coordinate{40.2244, 48.1989}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271826
    {Coordinate{37.4153, 54.8719}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271829
    {Coordinate{47.8636, 56.6289}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271835
    {Coordinate{37.4761, 54.6781}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271843
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16271848
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16271850
    {Coordinate{37.6228, 54.5253}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271868
    {Coordinate{55.9022, 54.7115}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16271872
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16271880
    {Coordinate{37.5811, 54.2308}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271896
    {Coordinate{31.1125, 59.7578}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271906
    {Coordinate{38.9431, 55.4444}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271910
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16271915
    {Coordinate{43.6692, 56.2589}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271929
    {Coordinate{31.7983, 59.5247}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271942
    {Coordinate{31.8442, 59.5025}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16271947
    {Coordinate{53.3405, 56.8377}, Tz::Europe_Samara, CountryId{"RU"}}, // Q16271951
    {Coordinate{85.1111, 56.3892}, Tz::Asia_Tomsk, CountryId{"RU"}}, // Q16271959
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16271977
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16271986
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16271992
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16271996
    {Coordinate{53.3911, 53.4143}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16272065
    {Coordinate{55.7689, 54.65}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16272081
    {Coordinate{132.058, 43.3333}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Q16273069
    {Coordinate{33.0696, 68.9724}, Tz::Europe_Moscow, CountryId{"RU"}}, // Apatity-1 railway station
    {Coordinate{43.7899, 55.4092}, Tz::Europe_Moscow, CountryId{"RU"}}, // Arzamas-I
    {Coordinate{33.7023, 46.1161}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Armyansk
    {Coordinate{23.3031, 56.5478}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16273440
    {Coordinate{37.66, 54.3244}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16273636
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16273742
    {Coordinate{43.16, 51.535}, Tz::Europe_Saratov, CountryId{"RU"}}, // Q16273755
    {Coordinate{131.957, 43.695}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Banevurovo
    {Coordinate{89.3054, 56.1228}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Bogotol
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16274588
    {Coordinate{25.9708, 53.119}, Tz::Europe_Minsk, CountryId{"BY"}}, // Borki
    {Coordinate{52.4838, 54.3114}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16274648
    {Coordinate{30.5675, 52.7126}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q16274652
    {Coordinate{32.4655, 58.7274}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16274664
    {Coordinate{8.30536, 49.38}, Tz::Europe_Berlin, CountryId{"DE"}}, // Böhl-Iggelheim station
    {Coordinate{8.39066, 49.4242}, Tz::Europe_Berlin, CountryId{"DE"}}, // Limburgerhof station
    {Coordinate{11.6602, 48.0757}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubiberg station
    {Coordinate{1.78424, 44.9216}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Puybrun
    {Coordinate{27.9589, 56.4307}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16347889
    {Coordinate{26.4917, 55.8765}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16349670
    {Coordinate{24.5774, 57.395}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16353013
    {Coordinate{34.4492, 45.884}, Tz::Europe_Simferopol, CountryId{"RU"}}, // Solone Ozero
    {Coordinate{1.73379, 44.9429}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bétaille
    {Coordinate{24.7221, 57.5089}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16362569
    {Coordinate{22.35, 56.6977}, Tz::Europe_Riga, CountryId{"LV"}}, // Lutriņi Station
    {Coordinate{23.4097, 56.6025}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16362840
    {Coordinate{33.5981, 44.6072}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16389195
    {Coordinate{10.7772, 44.9722}, Tz::Europe_Rome, CountryId{"IT"}}, // Palidano railway halt
    {Coordinate{13.3165, 46.4453}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16469209
    {Coordinate{133.52, 45.62}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Prokhasko
    {Coordinate{13.4179, 52.5148}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Jannowitzbrücke station
    {Coordinate{12.635, 41.5521}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16482098
    {Coordinate{}, Timezone{}, CountryId{"PT"}}, // Q16483793
    {Coordinate{40.2886, 48.2625}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16484388
    {Coordinate{35.5869, 56.0224}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16484826
    {Coordinate{1.93155, 44.9512}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laval-de-Cère
    {Coordinate{37.4973, 56.4185}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16486623
    {Coordinate{30.4095, 59.0808}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16486682
    {Coordinate{16.0213, 40.5747}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16487703
    {Coordinate{104.265, 52.2547}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q16487861
    {Coordinate{43.45, 56.2333}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16495703
    {Coordinate{1.84428, 44.9276}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bretenoux - Biars
    {Coordinate{19.0393, 47.5068}, Tz::Europe_Budapest, CountryId{"HU"}}, // Batthyány tér HÉV station
    {Coordinate{19.0549, 47.5985}, Tz::Europe_Budapest, CountryId{"HU"}}, // Békásmegyer HÉV station
    {Coordinate{4.92156, 44.0053}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Entraigues-sur-la-Sorgue
    {Coordinate{5.04553, 43.7859}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16507943
    {Coordinate{6.53029, 46.7242}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16507967
    {Coordinate{19.0393, 47.5148}, Tz::Europe_Budapest, CountryId{"HU"}}, // Margit híd HÉV station
    {Coordinate{19.0463, 47.5519}, Tz::Europe_Budapest, CountryId{"HU"}}, // Filatorigát HÉV station
    {Coordinate{19.0453, 47.5569}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaszásdűlő HÉV station
    {Coordinate{19.0447, 47.5858}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csillaghegy HÉV station
    {Coordinate{19.0549, 47.6162}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budakalász HÉV station
    {Coordinate{19.0467, 47.6217}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budakalász, Lenfonó HÉV station
    {Coordinate{4.95693, 43.9298}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508003
    {Coordinate{2.83094, 50.3575}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508004
    {Coordinate{6.5394, 46.5271}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16508009
    {Coordinate{7.06194, 45.7446}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16508010
    {Coordinate{7.12395, 47.2972}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bollement Railway Station
    {Coordinate{18.9902, 47.3909}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kastélypark railway station
    {Coordinate{19.0401, 47.5273}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szépvölgyi út HÉV station
    {Coordinate{19.0442, 47.5336}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tímár utca HÉV station
    {Coordinate{19.0472, 47.5397}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentlélek Square HÉV station
    {Coordinate{19.0485, 47.5753}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rómaifürdő HÉV station
    {Coordinate{19.0433, 47.6288}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentistvántelep HÉV station
    {Coordinate{19.0324, 47.643}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pomáz HÉV station
    {Coordinate{19.065, 47.6523}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pannóniatelep HÉV station
    {Coordinate{19.0754, 47.6609}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentendre HÉV station
    {Coordinate{4.99483, 44.0374}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monteux
    {Coordinate{4.87399, 43.9325}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508050
    {Coordinate{5.07323, 43.7409}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508051
    {Coordinate{7.25843, 45.7178}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16508066
    {Coordinate{7.41461, 45.7414}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16508067
    {Coordinate{7.87801, 45.2787}, Tz::Europe_Rome, CountryId{"IT"}}, // Rodallo railway station
    {Coordinate{2.61075, 46.5363}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508093
    {Coordinate{4.99638, 43.9265}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508095
    {Coordinate{2.60008, 46.4145}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16508099
    {Coordinate{7.64659, 47.5362}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16508111
    {Coordinate{6.54132, 46.721}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Granges (Orbe) station
    {Coordinate{6.532, 46.7206}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q16508242
    {Coordinate{6.96511, 46.4546}, Tz::Europe_Zurich, CountryId{"CH"}}, // Halte de Jor
    {Coordinate{19.2712, 47.4872}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákoscsaba-Újtelep railway station
    {Coordinate{18.6722, 47.1247}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zichyújfalu railway station
    {Coordinate{53.3405, 56.8377}, Tz::Europe_Samara, CountryId{"RU"}}, // Q16525083
    {Coordinate{}, Timezone{}, CountryId{"PT"}}, // Q16531542
    {Coordinate{}, Timezone{}, CountryId{"PT"}}, // Q16531622
    {Coordinate{8.6625, 50.1069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt (Main) Hauptbahnhof
    {Coordinate{13.7774, 51.1282}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Grenzstraße railway station
    {Coordinate{34.2942, 45.5022}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16580618
    {Coordinate{34.1786, 45.3525}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16582012
    {Coordinate{9.64389, 47.9533}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aulendorf station
    {Coordinate{7.16167, 53.6211}, Tz::Europe_Berlin, CountryId{"DE"}}, // Norddeich railway station
    {Coordinate{3.39379, 50.3846}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1660435
    {Coordinate{14.4255, 36.9968}, Tz::Europe_Rome, CountryId{"IT"}}, // Acate railway station
    {Coordinate{15.9562, 39.4865}, Tz::Europe_Rome, CountryId{"IT"}}, // Acquappesa railway halt
    {Coordinate{15.0016, 40.3515}, Tz::Europe_Rome, CountryId{"IT"}}, // Agropoli-Castellabate railway station
    {Coordinate{10.9965, 45.7591}, Tz::Europe_Rome, CountryId{"IT"}}, // Ala railway station
    {Coordinate{11.9444, 45.9026}, Tz::Europe_Rome, CountryId{"IT"}}, // Alano-Fener-Valdobbiadene railway station
    {Coordinate{14.1285, 40.9963}, Tz::Europe_Rome, CountryId{"IT"}}, // Albanova railway station
    {Coordinate{11.4542, 45.5118}, Tz::Europe_Rome, CountryId{"IT"}}, // Altavilla-Tavernelle railway station
    {Coordinate{10.6726, 43.8174}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608737
    {Coordinate{13.5208, 43.5664}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608740
    {Coordinate{13.4559, 43.6101}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608743
    {Coordinate{13.8357, 42.0175}, Tz::Europe_Rome, CountryId{"IT"}}, // Anversa-Villalago-Scanno railway station
    {Coordinate{12.6161, 41.4617}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608749
    {Coordinate{15.1723, 40.141}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608758
    {Coordinate{9.97055, 44.2097}, Tz::Europe_Rome, CountryId{"IT"}}, // Aulla
    {Coordinate{10.9561, 45.7337}, Tz::Europe_Rome, CountryId{"IT"}}, // Avio railway station
    {Coordinate{15.126, 36.9075}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608770
    {Coordinate{10.5518, 44.0035}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608773
    {Coordinate{15.4954, 40.65}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608776
    {Coordinate{7.81947, 44.722}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608779
    {Coordinate{10.4521, 44.0681}, Tz::Europe_Rome, CountryId{"IT"}}, // Barga-Gallicano
    {Coordinate{12.1525, 42.2124}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608802
    {Coordinate{8.50238, 45.9092}, Tz::Europe_Rome, CountryId{"IT"}}, // Baveno railway halt
    {Coordinate{8.57108, 45.8433}, Tz::Europe_Rome, CountryId{"IT"}}, // Belgirate railway station
    {Coordinate{15.8532, 39.6166}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608814
    {Coordinate{16.6823, 40.3977}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608817
    {Coordinate{8.28954, 46.0684}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608820
    {Coordinate{7.28715, 44.8097}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608823
    {Coordinate{11.3728, 44.4961}, Tz::Europe_Rome, CountryId{"IT"}}, // Bologna San Vitale railway halt
    {Coordinate{8.26456, 45.4554}, Tz::Europe_Rome, CountryId{"IT"}}, // Bolzano Novarese railway halt
    {Coordinate{11.4114, 44.9019}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608841
    {Coordinate{10.9269, 45.6968}, Tz::Europe_Rome, CountryId{"IT"}}, // Borghetto sull'Adige
    {Coordinate{10.5412, 43.9774}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo a Mozzano
    {Coordinate{16.8574, 38.9341}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608857
    {Coordinate{7.30837, 44.8256}, Tz::Europe_Rome, CountryId{"IT"}}, // Bricherasio railway station
    {Coordinate{12.7932, 37.9469}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608863
    {Coordinate{15.3742, 40.6009}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608869
    {Coordinate{13.8633, 42.0316}, Tz::Europe_Rome, CountryId{"IT"}}, // Bugnara railway station
    {Coordinate{8.26661, 45.4719}, Tz::Europe_Rome, CountryId{"IT"}}, // Buronzo railway station
    {Coordinate{11.9795, 46.04}, Tz::Europe_Rome, CountryId{"IT"}}, // Busche-Lentiai-Mel railway station
    {Coordinate{13.849, 42.1941}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608882
    {Coordinate{14.1718, 37.1452}, Tz::Europe_Rome, CountryId{"IT"}}, // Butera railway station
    {Coordinate{10.9883, 45.3389}, Tz::Europe_Rome, CountryId{"IT"}}, // Buttapietra
    {Coordinate{12.8561, 37.9389}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608890
    {Coordinate{9.84164, 45.5328}, Tz::Europe_Rome, CountryId{"IT"}}, // Calcio railway halt
    {Coordinate{11.1698, 45.4144}, Tz::Europe_Rome, CountryId{"IT"}}, // Caldiero railway station
    {Coordinate{16.8192, 39.579}, Tz::Europe_Rome, CountryId{"IT"}}, // Calopezzati Railway Station
    {Coordinate{13.8771, 37.9925}, Tz::Europe_Rome, CountryId{"IT"}}, // Campofelice di Roccella railway station
    {Coordinate{10.3346, 44.1614}, Tz::Europe_Rome, CountryId{"IT"}}, // Camporgiano
    {Coordinate{8.10031, 45.5474}, Tz::Europe_Rome, CountryId{"IT"}}, // Candelo railway halt
    {Coordinate{8.41986, 45.9776}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608930
    {Coordinate{13.0291, 42.3916}, Tz::Europe_Rome, CountryId{"IT"}}, // Canetra railway halt
    {Coordinate{18.3729, 40.156}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608936
    {Coordinate{15.0137, 40.4545}, Tz::Europe_Rome, CountryId{"IT"}}, // Capaccio-Roccadaspide railway station
    {Coordinate{15.8742, 39.5584}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608942
    {Coordinate{13.2046, 41.4006}, Tz::Europe_Rome, CountryId{"IT"}}, // Capocroce railway halt
    {Coordinate{16.9236, 41.0492}, Tz::Europe_Rome, CountryId{"IT"}}, // Capurso railway station
    {Coordinate{8.85391, 44.8602}, Tz::Europe_Rome, CountryId{"IT"}}, // Carbonara Scrivia railway station
    {Coordinate{16.952, 39.4968}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608954
    {Coordinate{8.21235, 45.4033}, Tz::Europe_Rome, CountryId{"IT"}}, // Carisio railway station
    {Coordinate{8.42286, 45.529}, Tz::Europe_Rome, CountryId{"IT"}}, // Carpignano Sesia railway station
    {Coordinate{8.49034, 45.4912}, Tz::Europe_Rome, CountryId{"IT"}}, // Casaleggio railway station
    {Coordinate{16.9147, 40.9542}, Tz::Europe_Rome, CountryId{"IT"}}, // Casamassima railway station
    {Coordinate{8.85898, 44.7626}, Tz::Europe_Rome, CountryId{"IT"}}, // Cassano Spinola railway station
    {Coordinate{15.1918, 36.9628}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16608984
    {Coordinate{17.1658, 40.8869}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellana Grotte railway station
    {Coordinate{10.7585, 45.431}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelnuovo del Garda railway halt
    {Coordinate{10.455, 44.0901}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelvecchio Pascoli
    {Coordinate{9.80804, 46.1615}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609005
    {Coordinate{16.4671, 38.344}, Tz::Europe_Rome, CountryId{"IT"}}, // Caulonia railway station
    {Coordinate{15.3946, 40.1028}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609017
    {Coordinate{15.3467, 40.0905}, Tz::Europe_Rome, CountryId{"IT"}}, // Centola-Palinuro-Marina di Camerota railway halt
    {Coordinate{12.3914, 44.2007}, Tz::Europe_Rome, CountryId{"IT"}}, // Cesenatico railway station
    {Coordinate{15.9394, 39.5127}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609028
    {Coordinate{9.92641, 45.5399}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiari railway halt
    {Coordinate{15.1567, 41.9218}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609034
    {Coordinate{9.84695, 45.6505}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiuduno railway halt
    {Coordinate{13.3107, 46.4094}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiusaforte railway station
    {Coordinate{12.9429, 42.3879}, Tz::Europe_Rome, CountryId{"IT"}}, // Cittaducale railway station
    {Coordinate{8.68996, 45.8603}, Tz::Europe_Rome, CountryId{"IT"}}, // Cocquio-Trevisago railway station
    {Coordinate{13.7766, 42.0408}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609064
    {Coordinate{13.6293, 42.0604}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609067
    {Coordinate{11.4416, 46.9381}, Tz::Europe_Rome, CountryId{"IT"}}, // Colle Isarco railway station
    {Coordinate{9.93551, 45.5767}, Tz::Europe_Rome, CountryId{"IT"}}, // Cologne railway halt
    {Coordinate{8.56611, 45.7143}, Tz::Europe_Rome, CountryId{"IT"}}, // Comignago railway station
    {Coordinate{14.6005, 36.9472}, Tz::Europe_Rome, CountryId{"IT"}}, // Comiso railway station
    {Coordinate{15.5356, 38.1503}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609084
    {Coordinate{17.1153, 40.9711}, Tz::Europe_Rome, CountryId{"IT"}}, // Conversano railway station
    {Coordinate{16.5148, 39.6281}, Tz::Europe_Rome, CountryId{"IT"}}, // Corigliano Calabro railway station
    {Coordinate{12.0127, 45.8338}, Tz::Europe_Rome, CountryId{"IT"}}, // Cornuda railway station
    {Coordinate{9.52521, 46.1355}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609105
    {Coordinate{8.49826, 45.6463}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609111
    {Coordinate{16.8134, 38.9221}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609117
    {Coordinate{17.0406, 39.4496}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609120
    {Coordinate{8.4566, 45.6725}, Tz::Europe_Rome, CountryId{"IT"}}, // Cureggio railway station
    {Coordinate{16.9639, 39.0259}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609129
    {Coordinate{8.37327, 45.9935}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609132
    {Coordinate{9.46128, 46.1386}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609137
    {Coordinate{10.5077, 43.9596}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609140
    {Coordinate{14.5689, 36.8822}, Tz::Europe_Rome, CountryId{"IT"}}, // Donnafugata railway station
    {Coordinate{8.58222, 45.7234}, Tz::Europe_Rome, CountryId{"IT"}}, // Dormelletto railway halt
    {Coordinate{10.3294, 46.177}, Tz::Europe_Rome, CountryId{"IT"}}, // Edolo
    {Coordinate{11.2574, 46.3194}, Tz::Europe_Rome, CountryId{"IT"}}, // Egna-Termeno railway station
    {Coordinate{9.06296, 39.2572}, Tz::Europe_Rome, CountryId{"IT"}}, // Elmas Aeroporto railway station
    {Coordinate{14.0526, 37.1135}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609169
    {Coordinate{11.9919, 45.7083}, Tz::Europe_Rome, CountryId{"IT"}}, // Fanzolo railway station
    {Coordinate{8.86285, 45.1119}, Tz::Europe_Rome, CountryId{"IT"}}, // Ferrera Lomellina railway halt
    {Coordinate{14.8089, 37.3112}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609182
    {Coordinate{15.544, 38.161}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiumara Gazzi railway halt
    {Coordinate{9.29277, 45.9991}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiumelatte railway halt
    {Coordinate{13.7749, 37.9666}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiumetorto railway station
    {Coordinate{13.4249, 41.3378}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609197
    {Coordinate{15.2114, 36.9691}, Tz::Europe_Rome, CountryId{"IT"}}, // Fontane Bianche railway halt
    {Coordinate{10.4733, 44.0454}, Tz::Europe_Rome, CountryId{"IT"}}, // Fornaci di Barga
    {Coordinate{11.6103, 46.7889}, Tz::Europe_Rome, CountryId{"IT"}}, // Fortezza railway station
    {Coordinate{10.4443, 44.1187}, Tz::Europe_Rome, CountryId{"IT"}}, // Fosciandora-Ceserana
    {Coordinate{15.6245, 40.6786}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609213
    {Coordinate{13.2007, 41.3659}, Tz::Europe_Rome, CountryId{"IT"}}, // Frasso railway halt
    {Coordinate{16.0118, 39.4097}, Tz::Europe_Rome, CountryId{"IT"}}, // Fuscaldo railway station
    {Coordinate{11.6711, 44.7781}, Tz::Europe_Rome, CountryId{"IT"}}, // Gaibanella railway station
    {Coordinate{15.5054, 38.1046}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609231
    {Coordinate{11.8277, 45.6528}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609236
    {Coordinate{17.9883, 40.0574}, Tz::Europe_Rome, CountryId{"IT"}}, // Gallipoli railway station
    {Coordinate{8.36467, 45.6114}, Tz::Europe_Rome, CountryId{"IT"}}, // Gattinara railway station
    {Coordinate{8.37946, 45.5261}, Tz::Europe_Rome, CountryId{"IT"}}, // Ghislarengo railway halt
    {Coordinate{10.5103, 44.0278}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609254
    {Coordinate{15.4797, 38.0639}, Tz::Europe_Rome, CountryId{"IT"}}, // Giampilieri railway station
    {Coordinate{18.4395, 40.1428}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609260
    {Coordinate{13.7829, 42.0827}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609265
    {Coordinate{8.44057, 45.7446}, Tz::Europe_Rome, CountryId{"IT"}}, // Gozzano railway station
    {Coordinate{16.2408, 40.5931}, Tz::Europe_Rome, CountryId{"IT"}}, // Grassano-Garaguso railway station
    {Coordinate{8.42863, 45.9341}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609273
    {Coordinate{8.33367, 45.6828}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609279
    {Coordinate{15.8212, 39.7398}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609282
    {Coordinate{17.4244, 40.5291}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609285
    {Coordinate{9.8629, 45.6342}, Tz::Europe_Rome, CountryId{"IT"}}, // Grumello del Monte railway station
    {Coordinate{16.5744, 38.4372}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609291
    {Coordinate{14.9142, 36.7782}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609304
    {Coordinate{8.62113, 45.8117}, Tz::Europe_Rome, CountryId{"IT"}}, // Ispra railway station
    {Coordinate{13.1988, 41.3331}, Tz::Europe_Rome, CountryId{"IT"}}, // La Fiora railway halt
    {Coordinate{11.1824, 46.6074}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Lana-Postal
    {Coordinate{13.9288, 38.0116}, Tz::Europe_Rome, CountryId{"IT"}}, // Lascari-Gratteri railway station
    {Coordinate{8.55896, 45.8256}, Tz::Europe_Rome, CountryId{"IT"}}, // Lesa railway station
    {Coordinate{7.94153, 44.3857}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609340
    {Coordinate{12.0066, 45.8502}, Tz::Europe_Rome, CountryId{"IT"}}, // Levada railway halt
    {Coordinate{12.626, 41.5006}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609347
    {Coordinate{9.30283, 45.9609}, Tz::Europe_Rome, CountryId{"IT"}}, // Lierna railway station
    {Coordinate{8.79912, 45.1174}, Tz::Europe_Rome, CountryId{"IT"}}, // Lomello railway station
    {Coordinate{10.4872, 45.4575}, Tz::Europe_Rome, CountryId{"IT"}}, // Lonato railway station
    {Coordinate{13.6203, 43.4481}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609362
    {Coordinate{7.24765, 44.8158}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609368
    {Coordinate{7.7477, 44.6954}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609371
    {Coordinate{7.77686, 44.4466}, Tz::Europe_Rome, CountryId{"IT"}}, // Magliano-Crava-Morozzo railway station
    {Coordinate{18.2997, 40.1258}, Tz::Europe_Rome, CountryId{"IT"}}, // Maglie railway station
    {Coordinate{11.1824, 45.0022}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609379
    {Coordinate{16.8931, 39.5253}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609385
    {Coordinate{12.1348, 42.1282}, Tz::Europe_Rome, CountryId{"IT"}}, // Manziana-Canale Monterano
    {Coordinate{15.8229, 39.7669}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609394
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Masserano railway station
    {Coordinate{8.74251, 45.0951}, Tz::Europe_Rome, CountryId{"IT"}}, // Mede railway halt
    {Coordinate{8.53576, 45.7945}, Tz::Europe_Rome, CountryId{"IT"}}, // Meina railway station
    {Coordinate{18.2772, 40.1479}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609411
    {Coordinate{8.44101, 45.9615}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609418
    {Coordinate{8.93015, 44.5389}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609424
    {Coordinate{15.5181, 38.1244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609427
    {Coordinate{9.45005, 45.162}, Tz::Europe_Rome, CountryId{"IT"}}, // Miradolo Terme railway station
    {Coordinate{16.7773, 39.6047}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609433
    {Coordinate{13.3471, 41.3461}, Tz::Europe_Rome, CountryId{"IT"}}, // Monte San Biagio-Terracina Mare railway station
    {Coordinate{13.3466, 43.6513}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609458
    {Coordinate{7.96495, 44.7038}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609461
    {Coordinate{10.2393, 45.4513}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609464
    {Coordinate{9.56869, 46.1366}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609467
    {Coordinate{7.53043, 44.7655}, Tz::Europe_Rome, CountryId{"IT"}}, // Moretta railway station
    {Coordinate{18.3349, 40.0988}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609478
    {Coordinate{8.01667, 44.7134}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609481
    {Coordinate{17.2577, 40.5082}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609484
    {Coordinate{8.55804, 45.4814}, Tz::Europe_Rome, CountryId{"IT"}}, // Nibbia railway halt
    {Coordinate{8.67129, 45.2756}, Tz::Europe_Rome, CountryId{"IT"}}, // Nicorvo railway halt
    {Coordinate{12.7668, 43.1007}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609494
    {Coordinate{16.6439, 40.1304}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609506
    {Coordinate{8.41313, 45.8719}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609515
    {Coordinate{8.41413, 45.8981}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609518
    {Coordinate{15.1345, 40.2527}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609521
    {Coordinate{11.2972, 46.361}, Tz::Europe_Rome, CountryId{"IT"}}, // Ora railway station
    {Coordinate{8.42125, 45.7959}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609532
    {Coordinate{13.5471, 43.4968}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609534
    {Coordinate{7.72066, 43.7999}, Tz::Europe_Rome, CountryId{"IT"}}, // Ospedaletti Ligure railway station
    {Coordinate{10.0745, 45.546}, Tz::Europe_Rome, CountryId{"IT"}}, // Ospitaletto-Travagliato railway station
    {Coordinate{18.4816, 40.1495}, Tz::Europe_Rome, CountryId{"IT"}}, // Otranto railway station
    {Coordinate{12.6293, 41.5136}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609551
    {Coordinate{17.0591, 40.5172}, Tz::Europe_Rome, CountryId{"IT"}}, // Palagiona-Chiatona railway station
    {Coordinate{14.8925, 37.3182}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609557
    {Coordinate{8.5344, 45.3072}, Tz::Europe_Rome, CountryId{"IT"}}, // Palestro railway halt
    {Coordinate{8.26058, 46.0436}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609566
    {Coordinate{13.4298, 43.6171}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609569
    {Coordinate{13.8443, 43.094}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609574
    {Coordinate{11.9651, 45.8772}, Tz::Europe_Rome, CountryId{"IT"}}, // Pederobba-Cavaso-Possagno railway halt
    {Coordinate{10.9006, 45.6583}, Tz::Europe_Rome, CountryId{"IT"}}, // Peri railway station
    {Coordinate{13.669, 42.0374}, Tz::Europe_Rome, CountryId{"IT"}}, // Pescina railway station
    {Coordinate{10.5027, 43.9372}, Tz::Europe_Rome, CountryId{"IT"}}, // Piaggione
    {Coordinate{13.9516, 42.2544}, Tz::Europe_Rome, CountryId{"IT"}}, // Piano d'Orta Bolognano railway station
    {Coordinate{15.6417, 40.6403}, Tz::Europe_Rome, CountryId{"IT"}}, // railway station of Picerno
    {Coordinate{8.26106, 46.0244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609602
    {Coordinate{15.7921, 40.7533}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609605
    {Coordinate{8.95968, 45.1162}, Tz::Europe_Rome, CountryId{"IT"}}, // Pieve Albignola railway halt
    {Coordinate{8.27625, 46.0098}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609611
    {Coordinate{12.4102, 43.0951}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609613
    {Coordinate{15.2435, 40.0914}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609617
    {Coordinate{16.5521, 40.4207}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609621
    {Coordinate{7.89254, 44.7011}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609623
    {Coordinate{18.3705, 40.0517}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609629
    {Coordinate{16.2669, 40.9351}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggiorsini railway station
    {Coordinate{16.0839, 38.4071}, Tz::Europe_Rome, CountryId{"IT"}}, // Polistena railway station
    {Coordinate{8.63684, 45.6496}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609641
    {Coordinate{15.3901, 40.6087}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609644
    {Coordinate{10.4092, 45.4739}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte San Marco-Calcinato railway station
    {Coordinate{15.5028, 38.0961}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609651
    {Coordinate{15.4943, 38.0809}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609654
    {Coordinate{10.3873, 44.1327}, Tz::Europe_Rome, CountryId{"IT"}}, // Pontecosi
    {Coordinate{13.6617, 43.4338}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609672
    {Coordinate{15.7771, 40.7811}, Tz::Europe_Rome, CountryId{"IT"}}, // Possidente railway station
    {Coordinate{12.1484, 45.716}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609682
    {Coordinate{13.698, 43.3602}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609685
    {Coordinate{14.8472, 36.7335}, Tz::Europe_Rome, CountryId{"IT"}}, // Pozzallo railway station
    {Coordinate{9.39771, 46.3078}, Tz::Europe_Rome, CountryId{"IT"}}, // Prata Camportaccio railway halt
    {Coordinate{8.37042, 45.6464}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609697
    {Coordinate{8.32718, 46.0024}, Tz::Europe_Rome, CountryId{"IT"}}, // Premosello-Chiovenda railway station
    {Coordinate{13.8345, 42.0537}, Tz::Europe_Rome, CountryId{"IT"}}, // Prezza railway station
    {Coordinate{8.26655, 45.7635}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609706
    {Coordinate{11.92, 45.9396}, Tz::Europe_Rome, CountryId{"IT"}}, // Quero-Vas railway station
    {Coordinate{9.29207, 46.0305}, Tz::Europe_Rome, CountryId{"IT"}}, // Regoledo railway halt
    {Coordinate{13.2147, 46.3945}, Tz::Europe_Rome, CountryId{"IT"}}, // Resiutta railway station
    {Coordinate{16.5281, 38.3892}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609720
    {Coordinate{11.6698, 46.7972}, Tz::Europe_Rome, CountryId{"IT"}}, // Rio di Pusteria
    {Coordinate{8.59703, 45.2934}, Tz::Europe_Rome, CountryId{"IT"}}, // Robbio railway station
    {Coordinate{16.9005, 38.9423}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609729
    {Coordinate{16.5744, 38.4372}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609738
    {Coordinate{9.48741, 46.1388}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609741
    {Coordinate{15.4476, 40.6102}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609744
    {Coordinate{9.75352, 45.5238}, Tz::Europe_Rome, CountryId{"IT"}}, // Romano railway station
    {Coordinate{14.9528, 36.8161}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609750
    {Coordinate{16.6408, 39.6029}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609753
    {Coordinate{11.7849, 45.7022}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609756
    {Coordinate{17.0084, 41.0116}, Tz::Europe_Rome, CountryId{"IT"}}, // Rutigliano railway station
    {Coordinate{9.03064, 45.1339}, Tz::Europe_Rome, CountryId{"IT"}}, // Sairano-Zinasco railway halt
    {Coordinate{16.3515, 40.5834}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609768
    {Coordinate{8.08233, 44.3963}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609770
    {Coordinate{8.17278, 44.4045}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609777
    {Coordinate{11.2029, 46.2457}, Tz::Europe_Rome, CountryId{"IT"}}, // Salorno railway station
    {Coordinate{9.42375, 46.2465}, Tz::Europe_Rome, CountryId{"IT"}}, // Samolaco railway halt
    {Coordinate{14.7446, 36.732}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609786
    {Coordinate{11.2742, 45.4024}, Tz::Europe_Rome, CountryId{"IT"}}, // San Bonifacio railway station
    {Coordinate{9.39769, 46.2742}, Tz::Europe_Rome, CountryId{"IT"}}, // San Cassiano Valchiavenna railway halt
    {Coordinate{14.1721, 40.9923}, Tz::Europe_Rome, CountryId{"IT"}}, // San Marcellino-Frignano railway station
    {Coordinate{12.1082, 42.382}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609814
    {Coordinate{15.4883, 38.0712}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609817
    {Coordinate{11.0175, 44.9971}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609826
    {Coordinate{18.3474, 40.0836}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609832
    {Coordinate{8.08119, 45.5195}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609835
    {Coordinate{8.90513, 45.1055}, Tz::Europe_Rome, CountryId{"IT"}}, // Sannazzaro railway station
    {Coordinate{12.3292, 46.0939}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609850
    {Coordinate{12.043, 46.0778}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609853
    {Coordinate{7.91608, 44.6959}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609856
    {Coordinate{8.4932, 44.3098}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609869
    {Coordinate{13.9983, 42.2674}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609875
    {Coordinate{15.8012, 39.8082}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609878
    {Coordinate{16.7054, 40.2536}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609881
    {Coordinate{14.6989, 36.7899}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609884
    {Coordinate{12.8282, 37.9495}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609890
    {Coordinate{16.7647, 38.9039}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609893
    {Coordinate{11.0153, 45.8083}, Tz::Europe_Rome, CountryId{"IT"}}, // Serravalle all'Adige railway station
    {Coordinate{8.44502, 45.5213}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609905
    {Coordinate{15.8959, 41.6131}, Tz::Europe_Rome, CountryId{"IT"}}, // Siponto railway halt
    {Coordinate{8.57907, 45.5396}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609916
    {Coordinate{7.77725, 44.7708}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609919
    {Coordinate{12.997, 42.3642}, Tz::Europe_Rome, CountryId{"IT"}}, // Sorgenti del Peschiera railway halt
    {Coordinate{18.3594, 40.014}, Tz::Europe_Rome, CountryId{"IT"}}, // Spongano railway halt
    {Coordinate{8.86516, 44.7194}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazzano-Serravalle railway station
    {Coordinate{17.1081, 39.2281}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609932
    {Coordinate{8.6058, 45.7724}, Tz::Europe_Rome, CountryId{"IT"}}, // Taino-Angera railway halt
    {Coordinate{9.60031, 46.1399}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609941
    {Coordinate{10.5705, 43.8342}, Tz::Europe_Rome, CountryId{"IT"}}, // Tassignano-Capannori
    {Coordinate{13.2418, 41.2976}, Tz::Europe_Rome, CountryId{"IT"}}, // Terracina railway halt
    {Coordinate{9.95958, 44.2373}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609956
    {Coordinate{18.3579, 39.9047}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609958
    {Coordinate{13.9047, 42.2267}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609961
    {Coordinate{7.57121, 45.0311}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609964
    {Coordinate{17.1083, 39.3044}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609970
    {Coordinate{15.4812, 40.0991}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609973
    {Coordinate{7.22602, 44.819}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609976
    {Coordinate{13.9375, 42.244}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609978
    {Coordinate{16.7073, 39.6075}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609984
    {Coordinate{15.5269, 38.1381}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609990
    {Coordinate{12.1038, 45.7474}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609993
    {Coordinate{18.3526, 39.9334}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16609996
    {Coordinate{16.9164, 41.0642}, Tz::Europe_Rome, CountryId{"IT"}}, // Triggiano railway station
    {Coordinate{15.9978, 40.5886}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610005
    {Coordinate{15.1584, 40.2296}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610017
    {Coordinate{8.25926, 45.8143}, Tz::Europe_Rome, CountryId{"IT"}}, // Varallo Sesia railway station
    {Coordinate{13.5232, 43.5748}, Tz::Europe_Rome, CountryId{"IT"}}, // Varano railway station
    {Coordinate{8.88709, 45.7773}, Tz::Europe_Rome, CountryId{"IT"}}, // Vedano Olona railway station
    {Coordinate{8.89507, 45.7367}, Tz::Europe_Rome, CountryId{"IT"}}, // Venegono Inferiore railway station
    {Coordinate{8.89025, 45.7581}, Tz::Europe_Rome, CountryId{"IT"}}, // Venegono Superiore-Castiglione railway station
    {Coordinate{9.4586, 46.2027}, Tz::Europe_Rome, CountryId{"IT"}}, // Verceia railway halt
    {Coordinate{10.332, 45.3738}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610048
    {Coordinate{7.89567, 44.3738}, Tz::Europe_Rome, CountryId{"IT"}}, // Vicoforte-San Michele train station
    {Coordinate{12.6171, 41.4844}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610056
    {Coordinate{8.26455, 46.0642}, Tz::Europe_Rome, CountryId{"IT"}}, // Villadossola railway station
    {Coordinate{11.4402, 46.8957}, Tz::Europe_Rome, CountryId{"IT"}}, // Vipiteno-Val di Vizze railway station
    {Coordinate{10.3633, 45.3154}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610082
    {Coordinate{14.525, 36.9587}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610085
    {Coordinate{8.29471, 46.0058}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610090
    {Coordinate{11.9361, 44.5404}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16610093
    {Coordinate{20.8686, 52.1911}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Ursus Niedźwiadek railway station
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16629882
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16631178
    {Coordinate{5.3675, 43.3134}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16638550
    {Coordinate{-0.607064, 43.1792}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16638563
    {Coordinate{2.19281, 44.9641}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16638572
    {Coordinate{-0.604883, 43.1207}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16638575
    {Coordinate{1.3976, 45.3131}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vignols-St-Solve
    {Coordinate{1.42965, 45.2158}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Le Burg
    {Coordinate{131.376, 44.4138}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Grodekovo railway station
    {Coordinate{43.45, 56.2333}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16643982
    {Coordinate{39.4477, 54.8217}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16644117
    {Coordinate{26.2965, 53.2044}, Tz::Europe_Minsk, CountryId{"BY"}}, // Damanava
    {Coordinate{33.4986, 53.6897}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16646722
    {Coordinate{38.1253, 53.15}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16650766
    {Coordinate{32.2694, 55.8514}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16651249
    {Coordinate{31.6419, 59.5656}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16651331
    {Coordinate{94.4159, 55.5716}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Zaozyorny train station
    {Coordinate{40.115, 48.0203}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16653670
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16653716
    {Coordinate{40.304, 46.8465}, Tz::Europe_Moscow, CountryId{"RU"}}, // Zernograd
    {Coordinate{11.5933, 50.8838}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jena-Göschwitz station
    {Coordinate{40.2531, 52.6328}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16655143
    {Coordinate{80.1956, 44.1371}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Yintal
    {Coordinate{96.0711, 56.2394}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Ilanskaya train station
    {Coordinate{42.9167, 45.7072}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16656069
    {Coordinate{69.5126, 56.112}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Ishim station
    {Coordinate{53.3405, 56.8377}, Tz::Europe_Samara, CountryId{"RU"}}, // Q16656563
    {Coordinate{37.5146, 56.3844}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16661279
    {Coordinate{95.4202, 56.1155}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Kansk train station
    {Coordinate{42.7717, 43.9619}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16661998
    {Coordinate{41.3236, 54.8958}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16662206
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16663003
    {Coordinate{51.505, 56.2802}, Tz::Europe_Samara, CountryId{"RU"}}, // Q16663312
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16663489
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16663546
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16663645
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16663694
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16663753
    {Coordinate{52.3469, 58.1761}, Tz::Europe_Samara, CountryId{"RU"}}, // Q16664469
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16664670
    {Coordinate{35.1332, 55.5304}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16664696
    {Coordinate{43.45, 56.2333}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16665322
    {Coordinate{48.1917, 58.1908}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16666433
    {Coordinate{46.6528, 61.2117}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16666452
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16666512
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16667393
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16668591
    {Coordinate{43.8678, 56.2591}, Tz::Europe_Moscow, CountryId{"RU"}}, // Kustovaya
    {Coordinate{37.4183, 56.7699}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16670303
    {Coordinate{55.885, 54.7083}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16670346
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16670672
    {Coordinate{105.741, 56.7808}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q16670677
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16670942
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16670989
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16671349
    {Coordinate{32.9853, 53.8914}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16671472
    {Coordinate{33.556, 60.7281}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16671932
    {Coordinate{38.7425, 54.5383}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16672216
    {Coordinate{36.1, 52.9319}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16672319
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16673847
    {Coordinate{36.2163, 56.0183}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16674812
    {Coordinate{52.2057, 56.4465}, Tz::Europe_Samara, CountryId{"RU"}}, // Q16677287
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Mohovye Gory station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Mysovaya railway station
    {Coordinate{71.2109, 55.3405}, Tz::Asia_Omsk, CountryId{"RU"}}, // Q16679443
    {Coordinate{124.757, 56.65}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q16680396
    {Coordinate{99.0125, 54.5343}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Nizhneudinsk train station
    {Coordinate{43.854, 56.2859}, Tz::Europe_Moscow, CountryId{"RU"}}, // Nizhny Novgorod sorting
    {Coordinate{39.2228, 51.3114}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16681310
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16681385
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16681950
    {Coordinate{45.0122, 53.2042}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16685336
    {Coordinate{45.0328, 53.1847}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16685338
    {Coordinate{41.9564, 52.7167}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16686496
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16686497
    {Coordinate{87.3263, 53.9016}, Tz::Asia_Novokuznetsk, CountryId{"RU"}}, // Q16686898
    {Coordinate{30.6363, 46.3834}, Tz::Europe_Kiev, CountryId{"UA"}}, // 13 km
    {Coordinate{33.6083, 44.5956}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16687091
    {Coordinate{33.2309, 49.9928}, Tz::Europe_Kiev, CountryId{"UA"}}, // 200 km
    {Coordinate{30.591, 46.3466}, Tz::Europe_Kiev, CountryId{"UA"}}, // 22 km
    {Coordinate{33.386, 48.9959}, Tz::Europe_Kiev, CountryId{"UA"}}, // 270 km
    {Coordinate{32.0422, 50.8304}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16687193
    {Coordinate{32.2409, 46.9811}, Tz::Europe_Kiev, CountryId{"UA"}}, // 44 km
    {Coordinate{33.7893, 47.6319}, Tz::Europe_Kiev, CountryId{"UA"}}, // 47 km
    {Coordinate{32.48, 50.8909}, Tz::Europe_Kiev, CountryId{"UA"}}, // 702 km
    {Coordinate{32.3642, 50.7498}, Tz::Europe_Kiev, CountryId{"UA"}}, // 720 km
    {Coordinate{32.3282, 50.6782}, Tz::Europe_Kiev, CountryId{"UA"}}, // 729 km
    {Coordinate{32.3372, 50.6514}, Tz::Europe_Kiev, CountryId{"UA"}}, // 732 km
    {Coordinate{32.3658, 50.5883}, Tz::Europe_Kiev, CountryId{"UA"}}, // 738 km
    {Coordinate{32.395, 50.5463}, Tz::Europe_Kiev, CountryId{"UA"}}, // 746 km
    {Coordinate{32.0467, 49.4845}, Tz::Europe_Kiev, CountryId{"UA"}}, // 882 km
    {Coordinate{32.0197, 49.3986}, Tz::Europe_Kiev, CountryId{"UA"}}, // 894 km
    {Coordinate{31.996, 49.3699}, Tz::Europe_Kiev, CountryId{"UA"}}, // 898 km
    {Coordinate{40.0908, 48.0619}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16687943
    {Coordinate{32.8193, 47.0927}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16689312
    {Coordinate{30.5993, 48.3388}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yemylivka
    {Coordinate{30.2697, 46.7192}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yeremiivka
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16689629
    {Coordinate{38.0947, 56.1156}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16689647
    {Coordinate{32.8595, 47.0357}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16689659
    {Coordinate{29.9387, 47.1821}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ivanivka
    {Coordinate{24.0581, 50.8285}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16689895
    {Coordinate{30.6293, 46.3223}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16689983
    {Coordinate{23.0455, 48.3162}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16690359
    {Coordinate{31.2177, 48.9913}, Tz::Europe_Kiev, CountryId{"UA"}}, // Iskrene
    {Coordinate{34.3486, 49.6078}, Tz::Europe_Kiev, CountryId{"UA"}}, // Abazivka
    {Coordinate{32.3694, 50.7789}, Tz::Europe_Kiev, CountryId{"UA"}}, // Avhustivskyi
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16690769
    {Coordinate{31.4804, 48.3544}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16691145
    {Coordinate{27.6715, 49.6683}, Tz::Europe_Kiev, CountryId{"UA"}}, // Adampil
    {Coordinate{34.1789, 48.3967}, Tz::Europe_Kiev, CountryId{"UA"}}, // Adamivske
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Rassipnaya Padi
    {Coordinate{34.5686, 45.5878}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16691435
    {Coordinate{37.6631, 54.3633}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16691508
    {Coordinate{30.5607, 46.3336}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16691530
    {Coordinate{29.1875, 45.7903}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16691763
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16691815
    {Coordinate{33.374, 50.5626}, Tz::Europe_Kiev, CountryId{"UA"}}, // Andriyashivka
    {Coordinate{32.7599, 46.6762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Antonivka
    {Coordinate{26.3031, 51.3117}, Tz::Europe_Kiev, CountryId{"UA"}}, // Antonivka
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16691925
    {Coordinate{37.5803, 47.2481}, Tz::Europe_Kiev, CountryId{"UA"}}, // Aslanove
    {Coordinate{31.0459, 49.0174}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bahacheve
    {Coordinate{31.9328, 47.0913}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692280
    {Coordinate{31.034, 48.1243}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692314
    {Coordinate{27.7226, 49.0361}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bar
    {Coordinate{30.5236, 46.2533}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692330
    {Coordinate{22.4901, 48.3681}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16692372
    {Coordinate{22.3858, 48.3614}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Batiovo
    {Coordinate{22.6306, 48.2019}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16692574
    {Coordinate{29.206, 46.2303}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692604
    {Coordinate{32.9922, 47.2443}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692608
    {Coordinate{30.942, 47.1924}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692644
    {Coordinate{29.5477, 48.3404}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bershad Railway Station
    {Coordinate{23.3273, 48.7627}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16692709
    {Coordinate{28.6771, 51.0729}, Tz::Europe_Kiev, CountryId{"UA"}}, // Behy
    {Coordinate{33.4408, 47.4093}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692794
    {Coordinate{33.0225, 50.8538}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692814
    {Coordinate{30.8857, 49.5644}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16692871
    {Coordinate{33.4578, 50.2916}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bodakva
    {Coordinate{34.7906, 49.6592}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bozhkiv
    {Coordinate{28.6027, 45.7362}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bolgrad
    {Coordinate{22.7193, 48.1646}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16692989
    {Coordinate{24.2564, 49.8605}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16693099
    {Coordinate{34.038, 49.6788}, Tz::Europe_Kiev, CountryId{"UA"}}, // Brateshky
    {Coordinate{33.1592, 46.4237}, Tz::Europe_Kiev, CountryId{"UA"}}, // Brylivka
    {Coordinate{39.5038, 54.7305}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16693224
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16693286
    {Coordinate{33.3177, 48.9759}, Tz::Europe_Kiev, CountryId{"UA"}}, // Burty
    {Coordinate{23.4942, 48.0561}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16693532
    {Coordinate{30.7194, 46.9108}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16693536
    {Coordinate{33.1961, 47.3517}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16693614
    {Coordinate{26.6234, 50.033}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bilhorodka
    {Coordinate{33.4886, 50.6552}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bilovody
    {Coordinate{31.9511, 49.3082}, Tz::Europe_Kiev, CountryId{"UA"}}, // Biloziria
    {Coordinate{28.0507, 51.1174}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bilokorovychi
    {Coordinate{32.5686, 50.989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16693765
    {Coordinate{23.9424, 49.3898}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16693771
    {Coordinate{33.5978, 46.1825}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vadym
    {Coordinate{34.627, 49.6154}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vakulintsi
    {Coordinate{23.1071, 49.483}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16693941
    {Coordinate{22.458, 48.8985}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16694102
    {Coordinate{32.9945, 46.5075}, Tz::Europe_Kiev, CountryId{"UA"}}, // Velyki Kopani
    {Coordinate{28.4939, 51.2953}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694178
    {Coordinate{27.7798, 48.6073}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694183
    {Coordinate{25.5958, 50.2808}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694212
    {Coordinate{24.6933, 51.2339}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694222
    {Coordinate{23.5883, 49.0922}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694309
    {Coordinate{33.1877, 49.6032}, Tz::Europe_Kiev, CountryId{"UA"}}, // Veselyi Podil
    {Coordinate{31.2259, 47.3625}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694347
    {Coordinate{32.8101, 50.0561}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyly
    {Coordinate{23.0271, 48.134}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16694486
    {Coordinate{33.5297, 47.4834}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694526
    {Coordinate{31.4498, 48.1615}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694534
    {Coordinate{23.0829, 48.6048}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Vovchyi
    {Coordinate{31.3236, 47.5735}, Tz::Europe_Kiev, CountryId{"UA"}}, // Voznesensk
    {Coordinate{23.1842, 48.7136}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16694820
    {Coordinate{31.6929, 49.1888}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694848
    {Coordinate{22.8083, 48.9818}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16694873
    {Coordinate{28.7117, 49.1237}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16694954
    {Coordinate{34.0044, 45.8708}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16695005
    {Coordinate{35.9286, 52.9272}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16695020
    {Coordinate{38.2736, 48.3167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16695089
    {Coordinate{52.2083, 58.6811}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16695263
    {Coordinate{26.6004, 49.1685}, Tz::Europe_Kiev, CountryId{"UA"}}, // Victoria
    {Coordinate{40.2844, 48.2456}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16695774
    {Coordinate{29.8545, 48.3401}, Tz::Europe_Kiev, CountryId{"UA"}}, // Haivoron
    {Coordinate{32.7557, 46.9597}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16695974
    {Coordinate{33.7541, 49.1708}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16695988
    {Coordinate{33.9004, 49.2371}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696072
    {Coordinate{29.2215, 45.8606}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hlavani
    {Coordinate{25.5332, 49.6171}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hlybochok-Velykyi
    {Coordinate{23.897, 49.7374}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696424
    {Coordinate{33.2268, 49.3999}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696434
    {Coordinate{25.3195, 50.6909}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696492
    {Coordinate{25.0064, 51.0835}, Tz::Europe_Kiev, CountryId{"UA"}}, // Holoby
    {Coordinate{30.3967, 48.3599}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696551
    {Coordinate{30.6507, 48.9045}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hordyshivka
    {Coordinate{31.4328, 49.2677}, Tz::Europe_Kiev, CountryId{"UA"}}, // Horodyshche
    {Coordinate{23.6297, 49.7897}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696770
    {Coordinate{32.5006, 47.448}, Tz::Europe_Kiev, CountryId{"UA"}}, // Horozhene
    {Coordinate{32.1497, 46.9933}, Tz::Europe_Kiev, CountryId{"UA"}}, // Horokhivka
    {Coordinate{32.4052, 50.365}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16696866
    {Coordinate{32.3032, 47.1138}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hreihove
    {Coordinate{30.238, 48.3249}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16697037
    {Coordinate{29.3634, 48.6214}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hubnyk
    {Coordinate{26.606, 48.7699}, Tz::Europe_Kiev, CountryId{"UA"}}, // Humentsi
    {Coordinate{30.779, 48.9189}, Tz::Europe_Kiev, CountryId{"UA"}}, // Husakove
    {Coordinate{29.2722, 45.9453}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16697379
    {Coordinate{30.5469, 46.5807}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dachne
    {Coordinate{29.0855, 48.5712}, Tz::Europe_Kiev, CountryId{"UA"}}, // Demkivka
    {Coordinate{31.4645, 52.1181}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16697604
    {Coordinate{29.736, 48.4575}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dzhulynka
    {Coordinate{32.6701, 47.7831}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dobrovilskyi
    {Coordinate{22.3358, 48.6376}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16698146
    {Coordinate{32.2906, 49.945}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16698284
    {Coordinate{23.5436, 49.355}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16698333
    {Coordinate{30.4928, 46.1005}, Tz::Europe_Kiev, CountryId{"UA"}}, // Druzhba
    {Coordinate{33.6186, 47.57}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16698501
    {Coordinate{25.7528, 50.3867}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16698510
    {Coordinate{22.4876, 48.8096}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16698540
    {Coordinate{45.0394, 43.3322}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16698554
    {Coordinate{26.5951, 51.5607}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dubrovytsya
    {Coordinate{29.5075, 48.6024}, Tz::Europe_Kiev, CountryId{"UA"}}, // Duklia
    {Coordinate{23.0082, 48.0129}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16698664
    {Coordinate{27.9708, 51.1558}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dibrova-Olevska
    {Coordinate{34.1322, 45.2914}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16698869
    {Coordinate{22.314, 48.3951}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16699007
    {Coordinate{132.026, 43.3358}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Q16699151
    {Coordinate{29.8763, 47.8365}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zherebkove
    {Coordinate{23.9675, 50.0495}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhovkva
    {Coordinate{23.0215, 49.2109}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699304
    {Coordinate{22.633, 48.9869}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16699338
    {Coordinate{31.0123, 51.5024}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699374
    {Coordinate{31.1569, 59.7281}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16699435
    {Coordinate{24.2517, 51.6292}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699507
    {Coordinate{24.9764, 50.0378}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699508
    {Coordinate{24.4406, 49.8778}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699647
    {Coordinate{26.3204, 49.1119}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zakupne
    {Coordinate{24.2238, 49.9214}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699881
    {Coordinate{32.4209, 47.025}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16699993
    {Coordinate{29.8787, 47.336}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zatyshshya
    {Coordinate{23.6756, 49.8403}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zatoka
    {Coordinate{32.3368, 50.6017}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700068
    {Coordinate{25.1328, 49.6918}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700084
    {Coordinate{30.9833, 48.9824}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zvenyhorodka
    {Coordinate{24.9091, 50.518}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700109
    {Coordinate{32.7576, 48.0617}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhoda
    {Coordinate{26.2597, 50.5094}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zdolbuniv
    {Coordinate{33.5025, 48.5081}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zelena
    {Coordinate{31.6056, 47.2518}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700166
    {Coordinate{32.0775, 49.6567}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zolotonosha 1
    {Coordinate{24.8914, 49.7889}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zolochiv
    {Coordinate{29.4447, 48.7103}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ziatkivtsi
    {Coordinate{30.5206, 51.4964}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yolcha
    {Coordinate{30.732, 48.2472}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700505
    {Coordinate{31.2727, 47.9101}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700548
    {Coordinate{33.4619, 49.1411}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700552
    {Coordinate{33.4664, 46.2544}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kalanchak
    {Coordinate{23.2947, 49.5578}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700661
    {Coordinate{28.4761, 49.4565}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700669
    {Coordinate{32.9467, 47.162}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700722
    {Coordinate{30.7859, 47.9123}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700746
    {Coordinate{25.7, 50.3511}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700748
    {Coordinate{22.4144, 48.6924}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16700752
    {Coordinate{30.0806, 46.1114}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kantemyr
    {Coordinate{31.5513, 48.4715}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16700899
    {Coordinate{33.0119, 51.5451}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16701067
    {Coordinate{30.5322, 46.1447}, Tz::Europe_Kiev, CountryId{"UA"}}, // Karolina-Buhaz
    {Coordinate{28.9606, 48.926}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16701098
    {Coordinate{30.3328, 46.6872}, Tz::Europe_Kiev, CountryId{"UA"}}, // Karpove
    {Coordinate{33.4687, 49.9459}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kybyntsi
    {Coordinate{28.9934, 48.5786}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kyrnasivka
    {Coordinate{30.4109, 50.4523}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16701527
    {Coordinate{26.0275, 50.7511}, Tz::Europe_Kiev, CountryId{"UA"}}, // Klevan
    {Coordinate{26.7594, 50.0567}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16701606
    {Coordinate{26.8916, 51.3115}, Tz::Europe_Kiev, CountryId{"UA"}}, // Klesiv
    {Coordinate{28.4974, 50.9979}, Tz::Europe_Kiev, CountryId{"UA"}}, // Klochki
    {Coordinate{22.6415, 48.4092}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16701705
    {Coordinate{31.3797, 59.6383}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16701735
    {Coordinate{29.1214, 48.0912}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kodyma
    {Coordinate{33.8452, 49.2199}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16701984
    {Coordinate{28.7832, 49.7571}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kozyatyn 2
    {Coordinate{24.2752, 50.0018}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702132
    {Coordinate{32.3597, 50.7232}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702146
    {Coordinate{22.7693, 48.4654}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16702209
    {Coordinate{23.68, 49.6577}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702240
    {Coordinate{23.7515, 49.2156}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702504
    {Coordinate{27.7544, 48.8838}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kopai
    {Coordinate{32.3074, 46.8096}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kopani
    {Coordinate{23.1407, 48.1534}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Korolevo station
    {Coordinate{33.2233, 48.5761}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korolivka
    {Coordinate{32.9801, 51.5611}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korop
    {Coordinate{23.5705, 49.6687}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702763
    {Coordinate{31.3117, 49.4301}, Tz::Europe_Kiev, CountryId{"UA"}}, // Korsun
    {Coordinate{22.4664, 48.287}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16702836
    {Coordinate{26.4439, 50.8711}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702895
    {Coordinate{22.6008, 48.945}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16702901
    {Coordinate{28.9764, 45.6268}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702947
    {Coordinate{32.1808, 46.8661}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kotlyareve
    {Coordinate{27.7535, 48.7883}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16702979
    {Coordinate{42.7717, 43.9619}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16703021
    {Coordinate{34.9697, 49.7419}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kochubejivka
    {Coordinate{40.0928, 47.8811}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16703095
    {Coordinate{30.3104, 47.0078}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16703206
    {Coordinate{34.2164, 45.4017}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16703220
    {Coordinate{30.7846, 46.7373}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16703310
    {Coordinate{28.2433, 51.0751}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kremne
    {Coordinate{34.5894, 49.6022}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kryvokhatky
    {Coordinate{46.4797, 58.3464}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q16703417
    {Coordinate{24.3769, 51.5343}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16703438
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16703602
    {Coordinate{30.6215, 46.3633}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16703703
    {Coordinate{29.647, 48.6738}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kublych
    {Coordinate{48.4819, 53.1707}, Tz::Europe_Samara, CountryId{"RU"}}, // Syzran-Gorod railway station
    {Coordinate{29.913, 46.0402}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kulevcha
    {Coordinate{34.007, 49.2254}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704032
    {Coordinate{30.7931, 46.6337}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704044
    {Coordinate{32.0694, 46.9155}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kulbakyne
    {Coordinate{114.834, 56.3594}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Taksimo
    {Coordinate{30.0025, 46.7538}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704324
    {Coordinate{25.4728, 50.8317}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kivertsi
    {Coordinate{30.8447, 47.9672}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kinetspil
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16704452
    {Coordinate{23.3576, 48.8106}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704471
    {Coordinate{29.24, 48.6304}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ladyzhyn
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16704653
    {Coordinate{26.7496, 48.5224}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704793
    {Coordinate{26.2149, 49.9555}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704842
    {Coordinate{33.0668, 47.3001}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704844
    {Coordinate{30.5129, 46.129}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704896
    {Coordinate{32.376, 50.4725}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16704911
    {Coordinate{29.2284, 49.2475}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lypovets
    {Coordinate{32.377, 47.2048}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lotskyne
    {Coordinate{28.3798, 51.035}, Tz::Europe_Kiev, CountryId{"UA"}}, // Luhyny
    {Coordinate{25.3511, 50.758}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lutsk Railway Station
    {Coordinate{23.6951, 49.1498}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16705489
    {Coordinate{24.8255, 51.1619}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lyubytiv
    {Coordinate{24.6206, 51.1797}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lyublynets-Volynskiy
    {Coordinate{26.3744, 50.7681}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16705510
    {Coordinate{24.0408, 51.2156}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lyuboml
    {Coordinate{23.7317, 49.7153}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16705527
    {Coordinate{31.4481, 48.0288}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16705546
    {Coordinate{}, Tz::Asia_Tokyo, CountryId{"JP"}}, // Q16705556
    {Coordinate{33.1637, 48.8217}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16705656
    {Coordinate{26.4712, 49.1466}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lisovody
    {Coordinate{34.2669, 49.2602}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lischynivka
    {Coordinate{25.9083, 49.5966}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16706011
    {Coordinate{32.83, 48.0517}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tymkove
    {Coordinate{25.5334, 51.2931}, Tz::Europe_Kiev, CountryId{"UA"}}, // Manevychi railway station
    {Coordinate{29.7391, 47.5364}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mardarivka
    {Coordinate{31.2791, 47.4687}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16706407
    {Coordinate{27.9469, 49.0401}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mateikove
    {Coordinate{33.8542, 49.8554}, Tz::Europe_Kiev, CountryId{"UA"}}, // Matyashivka
    {Coordinate{24.3642, 51.2406}, Tz::Europe_Kiev, CountryId{"UA"}}, // Matseiv
    {Coordinate{32.2315, 49.8676}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mekhedivka
    {Coordinate{30.0483, 46.9869}, Tz::Europe_Kiev, CountryId{"UA"}}, // Myhajeve
    {Coordinate{23.9535, 49.5116}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707010
    {Coordinate{33.7507, 49.9356}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mylashenkove
    {Coordinate{26.7228, 51.6961}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mylyachi
    {Coordinate{34.7108, 49.5086}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707070
    {Coordinate{27.775, 48.4577}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707260
    {Coordinate{26.515, 50.9847}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707329
    {Coordinate{29.7127, 49.006}, Tz::Europe_Kiev, CountryId{"UA"}}, // Monastyrysche
    {Coordinate{23.8746, 49.1501}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707509
    {Coordinate{23.1292, 49.8183}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707535
    {Coordinate{23.0328, 49.8167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mostyska II
    {Coordinate{24.6189, 51.2913}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16707606
    {Coordinate{37.5151, 56.1209}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16708123
    {Coordinate{23.7756, 49.83}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mshana
    {Coordinate{32.0902, 46.979}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16708427
    {Coordinate{31.2419, 59.6908}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16708683
    {Coordinate{30.637, 51.5117}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nedanchychi
    {Coordinate{27.7588, 48.6824}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16708915
    {Coordinate{28.875, 48.9902}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nemyriv
    {Coordinate{26.5739, 51.2019}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16708937
    {Coordinate{25.156, 50.6114}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16708979
    {Coordinate{23.6406, 49.1034}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709066
    {Coordinate{32.7689, 47.9639}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novodanylivka
    {Coordinate{33.3261, 47.3748}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709201
    {Coordinate{31.3996, 47.299}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709210
    {Coordinate{33.3137, 46.3387}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novokyivka
    {Coordinate{32.6039, 47.0608}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709243
    {Coordinate{32.5174, 47.5386}, Tz::Europe_Kiev, CountryId{"UA"}}, // Novopoltavka
    {Coordinate{26.6076, 48.8263}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709460
    {Coordinate{26.1796, 50.6762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Obariv
    {Coordinate{23.8926, 49.7813}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709645
    {Coordinate{29.5247, 47.8551}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709672
    {Coordinate{24.3853, 50.9283}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709684
    {Coordinate{28.818, 51.3248}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709694
    {Coordinate{30.6542, 46.4782}, Tz::Europe_Kiev, CountryId{"UA"}}, // Odesa-Zastava 1st
    {Coordinate{30.6535, 46.4387}, Tz::Europe_Kiev, CountryId{"UA"}}, // Odessa-Zakhidna
    {Coordinate{30.7264, 46.525}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709739
    {Coordinate{30.7871, 46.5953}, Tz::Europe_Kiev, CountryId{"UA"}}, // Odesa-Skhidna
    {Coordinate{25.3983, 49.6106}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709810
    {Coordinate{27.6479, 51.2284}, Tz::Europe_Kiev, CountryId{"UA"}}, // Olevsk
    {Coordinate{48.203, 54.1642}, Tz::Europe_Ulyanovsk, CountryId{"RU"}}, // Q16709927
    {Coordinate{31.3005, 47.6424}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16709938
    {Coordinate{25.7391, 50.7833}, Tz::Europe_Kiev, CountryId{"UA"}}, // Olyka
    {Coordinate{31.4828, 48.0989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16710075
    {Coordinate{29.3902, 49.1753}, Tz::Europe_Kiev, CountryId{"UA"}}, // Orativ
    {Coordinate{30.9229, 48.0498}, Tz::Europe_Kiev, CountryId{"UA"}}, // Orlyk
    {Coordinate{27.3683, 51.263}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ostky
    {Coordinate{103.391, 52.4333}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Usolye-Siberian
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16710638
    {Coordinate{58.1011, 54.5615}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16710652
    {Coordinate{33.3389, 48.9117}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pavlysh
    {Coordinate{104.061, 51.5414}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q16710729
    {Coordinate{32.1531, 49.761}, Tz::Europe_Kiev, CountryId{"UA"}}, // Palmira
    {Coordinate{32.8835, 48.6759}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pantaivka
    {Coordinate{94.1943, 55.4818}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q16710966
    {Coordinate{32.3523, 50.1329}, Tz::Europe_Kiev, CountryId{"UA"}}, // Parijskaya Kommuna
    {Coordinate{31.7625, 49.2214}, Tz::Europe_Kiev, CountryId{"UA"}}, // Perehonivka
    {Coordinate{29.7319, 47.8729}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16711280
    {Coordinate{25.1554, 50.9887}, Tz::Europe_Kiev, CountryId{"UA"}}, // Perespa
    {Coordinate{29.7954, 47.4385}, Tz::Europe_Kiev, CountryId{"UA"}}, // Perekhrestove
    {Coordinate{22.4782, 48.733}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16711348
    {Coordinate{32.3419, 50.025}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16711626
    {Coordinate{29.5141, 47.8096}, Tz::Europe_Kiev, CountryId{"UA"}}, // Poberezhzhya
    {Coordinate{25.1322, 51.2719}, Tz::Europe_Kiev, CountryId{"UA"}}, // Povorsk
    {Coordinate{29.2948, 49.4383}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pohrebysche 1
    {Coordinate{30.2082, 48.93}, Tz::Europe_Kiev, CountryId{"UA"}}, // Podibne
    {Coordinate{28.9757, 48.2152}, Tz::Europe_Kiev, CountryId{"UA"}}, // Popelyukhy
    {Coordinate{28.7681, 51.2255}, Tz::Europe_Kiev, CountryId{"UA"}}, // Potapovychi
    {Coordinate{30.3289, 48.9201}, Tz::Europe_Kiev, CountryId{"UA"}}, // Potash
    {Coordinate{33.6198, 49.1265}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16712474
    {Coordinate{27.8068, 51.2058}, Tz::Europe_Kiev, CountryId{"UA"}}, // Poyasky
    {Coordinate{34.0714, 45.2017}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16713308
    {Coordinate{31.2691, 48.9945}, Tz::Europe_Kiev, CountryId{"UA"}}, // Prudianka
    {Coordinate{23.9085, 49.7165}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16713541
    {Coordinate{31.2629, 47.82}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pivdennoukrainska
    {Coordinate{24.1287, 49.8473}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16713656
    {Coordinate{23.9562, 49.4497}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16713837
    {Coordinate{32.9443, 46.5639}, Tz::Europe_Kiev, CountryId{"UA"}}, // Radenske
    {Coordinate{24.6256, 50.2842}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16713914
    {Coordinate{31.9993, 49.0967}, Tz::Europe_Kiev, CountryId{"UA"}}, // Raihorod
    {Coordinate{30.8317, 47.1699}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714076
    {Coordinate{25.9989, 51.3067}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rafalivka
    {Coordinate{28.472, 48.7888}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rakhny
    {Coordinate{29.2793, 51.3524}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714098
    {Coordinate{26.2797, 50.7056}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714318
    {Coordinate{33.3129, 50.8166}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rohyntsi
    {Coordinate{23.5114, 49.7931}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714477
    {Coordinate{25.2607, 50.9097}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozhyshche
    {Coordinate{32.5202, 50.9365}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714526
    {Coordinate{30.0447, 46.8889}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozdilna-Sortuvalna
    {Coordinate{30.0739, 46.8504}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozdilna 1st
    {Coordinate{29.791, 48.7531}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozkoshivka
    {Coordinate{30.8571, 48.9554}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozsokhuvatka
    {Coordinate{30.0504, 48.7771}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozsishky
    {Coordinate{27.2207, 51.2712}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rokytne-Volynske
    {Coordinate{23.1783, 48.1949}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16714630
    {Coordinate{33.4684, 50.7491}, Tz::Europe_Kiev, CountryId{"UA"}}, // Romny
    {Coordinate{30.4496, 46.9915}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714791
    {Coordinate{5.65167, 53.0322}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sneek railway station
    {Coordinate{32.9449, 50.9374}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rubanka
    {Coordinate{33.3343, 49.2508}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714834
    {Coordinate{23.4983, 49.6414}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714868
    {Coordinate{28.9344, 48.2606}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rudnytsia
    {Coordinate{25.4978, 50.223}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16714886
    {Coordinate{23.2122, 49.5167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16715280
    {Coordinate{29.079, 48.873}, Tz::Europe_Kiev, CountryId{"UA"}}, // Samchyntsi
    {Coordinate{24.3379, 50.084}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16715391
    {Coordinate{29.6794, 46.0158}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sarata
    {Coordinate{26.6029, 51.3388}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sarny
    {Coordinate{22.988, 48.5516}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16715494
    {Coordinate{34.6894, 49.625}, Tz::Europe_Kiev, CountryId{"UA"}}, // Svynkivka
    {Coordinate{27.001, 50.2254}, Tz::Europe_Kiev, CountryId{"UA"}}, // Selo Kam'yanka
    {Coordinate{30.1059, 51.3957}, Tz::Europe_Kiev, CountryId{"UA"}}, // Semikhody
    {Coordinate{30.7535, 47.0084}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16716000
    {Coordinate{31.3974, 48.9954}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16716150
    {Coordinate{29.1835, 48.9036}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sytkivtsi
    {Coordinate{30.4122, 59.0833}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16716404
    {Coordinate{23.5046, 49.0341}, Tz::Europe_Kiev, CountryId{"UA"}}, // Skole
    {Coordinate{35.0678, 49.7781}, Tz::Europe_Kiev, CountryId{"UA"}}, // Skorohodove
    {Coordinate{23.2638, 48.7263}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16716628
    {Coordinate{23.4446, 48.8486}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16716695
    {Coordinate{30.753, 51.5153}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16716710
    {Coordinate{24.2567, 50.4644}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717090
    {Coordinate{22.8878, 49.0831}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717108
    {Coordinate{33.0365, 49.9812}, Tz::Europe_Kiev, CountryId{"UA"}}, // Solonytska
    {Coordinate{23.877, 47.9498}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Solotvyno 1
    {Coordinate{23.882, 47.9589}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Solotvyno 2
    {Coordinate{22.5378, 48.9512}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16717217
    {Coordinate{33.4798, 45.1611}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16717243
    {Coordinate{30.48, 46.0875}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717253
    {Coordinate{34.0037, 48.2422}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717279
    {Coordinate{24.2628, 50.2917}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717330
    {Coordinate{31.203, 49.49}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sotnyky
    {Coordinate{31.8906, 49.1355}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sofiivka
    {Coordinate{22.7063, 48.9923}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16717716
    {Coordinate{23.8487, 49.7452}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717727
    {Coordinate{36.3489, 54.1017}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16717830
    {Coordinate{23.0037, 49.4412}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16717852
    {Coordinate{27.2789, 49.7336}, Tz::Europe_Kiev, CountryId{"UA"}}, // Starokostiantyniv-II
    {Coordinate{31.973, 49.3365}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stepanky
    {Coordinate{23.6746, 49.1276}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718137
    {Coordinate{24.6666, 50.378}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718200
    {Coordinate{22.5662, 48.3875}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16718203
    {Coordinate{26.7545, 51.3302}, Tz::Europe_Kiev, CountryId{"UA"}}, // Strashiv
    {Coordinate{32.6942, 46.7841}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718320
    {Coordinate{22.2447, 48.5122}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16718381
    {Coordinate{22.9897, 49.3366}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718403
    {Coordinate{26.5847, 51.432}, Tz::Europe_Kiev, CountryId{"UA"}}, // Strilsk
    {Coordinate{30.5569, 46.1653}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718435
    {Coordinate{23.3844, 49.7992}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sudova Vyshnia
    {Coordinate{34.5075, 46.012}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chonhar
    {Coordinate{27.7037, 48.49}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718594
    {Coordinate{34.4757, 49.5894}, Tz::Europe_Kiev, CountryId{"UA"}}, // Suprunivka
    {Coordinate{26.3815, 49.9994}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sukhovolya
    {Coordinate{22.902, 49.0232}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718801
    {Coordinate{34.3746, 46.9423}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16718889
    {Coordinate{33.1412, 50.8466}, Tz::Europe_Kiev, CountryId{"UA"}}, // Talalaivka
    {Coordinate{30.7231, 48.8954}, Tz::Europe_Kiev, CountryId{"UA"}}, // Talne
    {Coordinate{33.1555, 49.987}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tarnavshchyna
    {Coordinate{30.1025, 48.3771}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16719214
    {Coordinate{28.9221, 45.5185}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16719233
    {Coordinate{46.6172, 57.6719}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16719684
    {Coordinate{23.6999, 47.9959}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16719717
    {Coordinate{32.9856, 49.9784}, Tz::Europe_Kiev, CountryId{"UA"}}, // Terny
    {Coordinate{31.9567, 47.0561}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16719828
    {Coordinate{33.5189, 45.1428}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q16719918
    {Coordinate{28.8754, 51.3863}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720129
    {Coordinate{27.0688, 51.3017}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tomashhorod
    {Coordinate{31.8144, 47.149}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720371
    {Coordinate{25.3375, 51.2885}, Tz::Europe_Kiev, CountryId{"UA"}}, // Troyanivka
    {Coordinate{23.512, 49.2827}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720460
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16720463
    {Coordinate{23.0239, 49.1519}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720551
    {Coordinate{32.8825, 47.0957}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720560
    {Coordinate{24.5328, 51.0797}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720582
    {Coordinate{23.478, 48.92}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720590
    {Coordinate{23.5759, 48.0148}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16720627
    {Coordinate{23.8964, 49.3236}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16720705
    {Coordinate{26.7504, 51.7473}, Tz::Europe_Kiev, CountryId{"UA"}}, // Udryts'k
    {Coordinate{22.3005, 48.6095}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Uzhhorod railway station
    {Coordinate{28.204, 49.5074}, Tz::Europe_Kiev, CountryId{"UA"}}, // Uladivka
    {Coordinate{34.274, 49.6257}, Tz::Europe_Kiev, CountryId{"UA"}}, // Umantsivka
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16721052
    {Coordinate{37.5947, 54.5747}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q16721153
    {Coordinate{32.985, 47.9556}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16721214
    {Coordinate{33.9267, 49.7712}, Tz::Europe_Kiev, CountryId{"UA"}}, // Fedunka
    {Coordinate{28.8548, 49.0708}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ferdynandivka
    {Coordinate{133.78, 46.0384}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Q16721614
    {Coordinate{29.9584, 48.3149}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16722009
    {Coordinate{32.6616, 46.693}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16722048
    {Coordinate{31.4631, 49.201}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khlystunivka
    {Coordinate{27.9845, 49.5591}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16722127
    {Coordinate{28.3468, 49.4918}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kholonivska
    {Coordinate{33.2074, 49.7844}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16722260
    {Coordinate{29.9726, 48.8152}, Tz::Europe_Kiev, CountryId{"UA"}}, // Khrystynivka
    {Coordinate{31.5292, 49.1537}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tsvitkove
    {Coordinate{32.4123, 48.8442}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tsybuleve
    {Coordinate{25.8839, 50.7732}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tsuman
    {Coordinate{32.8346, 46.6312}, Tz::Europe_Kiev, CountryId{"UA"}}, // Oleshky
    {Coordinate{84.8417, 55.7128}, Tz::Asia_Novokuznetsk, CountryId{"RU"}}, // Yurga I
    {Coordinate{32.0747, 49.572}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16722826
    {Coordinate{24.2289, 50.3967}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16723109
    {Coordinate{23.9018, 49.5834}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16723173
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q16723195
    {Coordinate{55.9785, 53.6815}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q16723277
    {Coordinate{32.4189, 46.7672}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chekhovychi
    {Coordinate{22.8478, 48.4926}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16723371
    {Coordinate{22.8152, 48.4827}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16723373
    {Coordinate{52.1111, 58.2486}, Tz::Europe_Samara, CountryId{"RU"}}, // Yar
    {Coordinate{22.2056, 48.4328}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Chop
    {Coordinate{32.5293, 46.7182}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chornobaivka
    {Coordinate{30.76, 46.8278}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chornomorska
    {Coordinate{25.8344, 51.2996}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chortoryisk
    {Coordinate{29.5834, 47.6521}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chubivka
    {Coordinate{26.5975, 57.0619}, Tz::Europe_Riga, CountryId{"LV"}}, // Q16723542
    {Coordinate{30.5342, 48.9185}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16723616
    {Coordinate{34.557, 49.6308}, Tz::Europe_Kiev, CountryId{"UA"}}, // Shvedska Mohyla
    {Coordinate{22.8186, 49.008}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Q16723963
    {Coordinate{23.8594, 49.6465}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16723966
    {Coordinate{23.8701, 49.6558}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16723967
    {Coordinate{28.5798, 48.7015}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yurkivka
    {Coordinate{32.4704, 47.3193}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yavkyne
    {Coordinate{23.0724, 49.1869}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16724083
    {Coordinate{23.8958, 51.1981}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yahodyn
    {Coordinate{33.6178, 48.4524}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yakovlivka
    {Coordinate{33.8832, 49.8152}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yaresky
    {Coordinate{30.117, 48.9124}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yarovatka
    {Coordinate{22.9795, 49.276}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16724256
    {Coordinate{31.7171, 47.1876}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16724261
    {Coordinate{32.093, 50.7947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q16724277
    {Coordinate{8.26995, 47.3484}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wohlen railway station
    {Coordinate{4.63635, 49.6501}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Poix-Terron
    {Coordinate{107.68, 51.8242}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Zaudinskiy station
    {Coordinate{9.72278, 52.3527}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Linden station
    {Coordinate{8.72782, 48.5555}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830552
    {Coordinate{11.5804, 50.0937}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830553
    {Coordinate{11.5954, 49.8106}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q16830554
    {Coordinate{8.5302, 49.2919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neulußheim station
    {Coordinate{11.5936, 50.9368}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jena Saalbahnhof
    {Coordinate{8.23008, 50.3327}, Tz::Europe_Berlin, CountryId{"DE"}}, // Niederselters station
    {Coordinate{10.91, 52.2138}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frellstedt railway station
    {Coordinate{10.8125, 52.2572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Königslutter railway station
    {Coordinate{12.1605, 51.1855}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Miltitzer Allee railway station
    {Coordinate{12.3864, 51.3199}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig MDR railway station
    {Coordinate{10.6857, 52.2673}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schandelah railway station
    {Coordinate{8.47818, 47.1945}, Tz::Europe_Zurich, CountryId{"CH"}}, // Steinhausen railway station
    {Coordinate{13.1072, 54.305}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stralsund Rügendamm railway station
    {Coordinate{11.97, 52.5458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tangermünde station
    {Coordinate{18.2256, 46.0667}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pécs railway station
    {Coordinate{10.1008, 52.2007}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vöhrum station
    {Coordinate{10.6243, 52.2693}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weddel railway station
    {Coordinate{9.27942, 47.3755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{8.76097, 47.5167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Winterthur Wallrüti railway station
    {Coordinate{13.7547, 52.9639}, Tz::Europe_Berlin, CountryId{"DE"}}, // Joachimsthal Kaiserbahnhof
    {Coordinate{25.1895, 62.2568}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Petäjävesi railway station
    {Coordinate{8.78267, 44.7974}, Tz::Europe_Rome, CountryId{"IT"}}, // Q16912683
    {Coordinate{6.9948, 51.5756}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haltepunkt Gladbeck Ost
    {Coordinate{9.1275, 48.705}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberaichen station
    {Coordinate{9.37028, 48.8131}, Tz::Europe_Berlin, CountryId{"DE"}}, // Endersbach station
    {Coordinate{0.77502, 49.7201}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16964672
    {Coordinate{4.39987, 50.8391}, Tz::Europe_Brussels, CountryId{"BE"}}, // Merode railway station
    {Coordinate{0.70513, 49.7597}, Tz::Europe_Paris, CountryId{"FR"}}, // Q16964682
    {Coordinate{16.4994, 41.2353}, Tz::Europe_Rome, CountryId{"IT"}}, // Bisceglie railway station
    {Coordinate{29.1381, 63.5411}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Nurmes railway station
    {Coordinate{8.57853, 49.3834}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwetzingen train station
    {Coordinate{12.876, 46.0203}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056852
    {Coordinate{12.5509, 37.9914}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056890
    {Coordinate{12.5042, 37.9265}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056891
    {Coordinate{12.4772, 37.8363}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056893
    {Coordinate{12.4432, 37.7932}, Tz::Europe_Rome, CountryId{"IT"}}, // Marsala railway station
    {Coordinate{12.4807, 37.7486}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056895
    {Coordinate{12.7333, 37.6363}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056899
    {Coordinate{12.8657, 37.8067}, Tz::Europe_Rome, CountryId{"IT"}}, // Salemi-Gibellina railway station
    {Coordinate{12.9489, 37.8579}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056904
    {Coordinate{12.9157, 37.9789}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056905
    {Coordinate{12.4991, 37.8849}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17056946
    {Coordinate{67.8902, 55.0711}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q17057303
    {Coordinate{58.1141, 53.9104}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q17057339
    {Coordinate{58.1796, 53.9168}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q17057342
    {Coordinate{58.2398, 53.9223}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q17057343
    {Coordinate{7.74861, 46.0097}, Tz::Europe_Zurich, CountryId{"CH"}}, // Findelbach railway station
    {Coordinate{7.61904, 51.5047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holzwickede station
    {Coordinate{7.68, 46.6861}, Tz::Europe_Zurich, CountryId{"CH"}}, // Spiez railway station
    {Coordinate{13.2271, 50.7067}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pockau-Lengefeld station
    {Coordinate{17.1231, 40.8564}, Tz::Europe_Rome, CountryId{"IT"}}, // Putignano railway station
    {Coordinate{7.75389, 46.0047}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riffelalp railway station
    {Coordinate{7.755, 45.9928}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riffelberg railway station
    {Coordinate{7.68634, 45.0995}, Tz::Europe_Rome, CountryId{"IT"}}, // Torino Rebaudengo Fossata railway station
    {Coordinate{16.4178, 41.2725}, Tz::Europe_Rome, CountryId{"IT"}}, // Trani railway station
    {Coordinate{17.0174, 40.9142}, Tz::Europe_Rome, CountryId{"IT"}}, // Turi railway station
    {Coordinate{10.8376, 48.2665}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17122383
    {Coordinate{13.5628, 47.4076}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q17122384
    {Coordinate{8.99, 49.6568}, Tz::Europe_Berlin, CountryId{"DE"}}, // Railway Station Erbach (Odenw)
    {Coordinate{6.97326, 51.6145}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17123492
    {Coordinate{27.6892, 62.2103}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Huutokoski railway station
    {Coordinate{25.3339, 63.7544}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Haapajärvi railway station
    {Coordinate{12.9862, 43.3458}, Tz::Europe_Rome, CountryId{"IT"}}, // Albacina railway station
    {Coordinate{12.8588, 43.3452}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17145113
    {Coordinate{12.8183, 43.4621}, Tz::Europe_Rome, CountryId{"IT"}}, // Monterosso Marche railway station
    {Coordinate{12.8513, 43.4364}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17145115
    {Coordinate{16.6479, 40.7989}, Tz::Europe_Rome, CountryId{"IT"}}, // Casal Sabini
    {Coordinate{29.2369, 62.6414}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Wine Lake Station area
    {Coordinate{13.6748, 37.5704}, Tz::Europe_Rome, CountryId{"IT"}}, // Acquaviva-Casteltermini railway station
    {Coordinate{12.8242, 43.5202}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146356
    {Coordinate{11.6024, 44.0684}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Biforco
    {Coordinate{13.6867, 37.5101}, Tz::Europe_Rome, CountryId{"IT"}}, // Campofranco railway station
    {Coordinate{14.2105, 41.1014}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146361
    {Coordinate{13.7847, 37.9539}, Tz::Europe_Rome, CountryId{"IT"}}, // Cerda railway station
    {Coordinate{13.653, 37.4238}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146370
    {Coordinate{11.5482, 44.0418}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Crespino del Lamone
    {Coordinate{15.8241, 39.6769}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146374
    {Coordinate{13.838, 42.7059}, Tz::Europe_Rome, CountryId{"IT"}}, // Bellante-Ripattone railway station
    {Coordinate{13.7929, 42.6957}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146388
    {Coordinate{12.757, 43.2839}, Tz::Europe_Rome, CountryId{"IT"}}, // Fossato di Vico-Gubbio train station
    {Coordinate{12.7673, 43.2334}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146397
    {Coordinate{13.6933, 37.859}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146400
    {Coordinate{13.8763, 42.7067}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146404
    {Coordinate{8.41581, 45.9702}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146415
    {Coordinate{8.40675, 45.8205}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146417
    {Coordinate{11.6364, 44.093}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146420
    {Coordinate{13.8968, 42.9127}, Tz::Europe_Rome, CountryId{"IT"}}, // Porto d'Ascoli train station
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146425
    {Coordinate{11.8713, 44.5956}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146426
    {Coordinate{12.8819, 46.045}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146427
    {Coordinate{13.7742, 37.9031}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146430
    {Coordinate{12.8986, 46.108}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146434
    {Coordinate{12.918, 46.1526}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146438
    {Coordinate{12.8711, 46.0004}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146441
    {Coordinate{13.0666, 46.2193}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17146446
    {Coordinate{11.0025, 45.8613}, Tz::Europe_Rome, CountryId{"IT"}}, // Mori railway halt
    {Coordinate{9.79117, 48.4039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17148684
    {Coordinate{14.6355, 50.6816}, Tz::Europe_Prague, CountryId{"CZ"}}, // Zákupy (train station)
    {Coordinate{61.3712, 56.7305}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q17154677
    {Coordinate{24.8436, 60.295}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vehkala railway station
    {Coordinate{15.6506, 41.4081}, Tz::Europe_Rome, CountryId{"IT"}}, // Incoronata railway station
    {Coordinate{55.9228, 53.4492}, Tz::Asia_Yekaterinburg, CountryId{}}, // Q17266153
    {Coordinate{19.2936, 48.0714}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balassagyarmat railway station
    {Coordinate{8.06528, 48.6336}, Tz::Europe_Berlin, CountryId{"DE"}}, // Achern station
    {Coordinate{8.99028, 49.3539}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aglasterhausen station
    {Coordinate{7.72864, 50.3276}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Ems station
    {Coordinate{8.29456, 49.1883}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bellheim station
    {Coordinate{8.4107, 48.4675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freudenstadt Stadt station
    {Coordinate{11.1852, 53.429}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagenow Stadt railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q17333373
    {Coordinate{17.9283, 62.635}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Härnösand railway station
    {Coordinate{8.179, 49.5807}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17353341
    {Coordinate{8.27233, 49.0925}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jockgrim station
    {Coordinate{8.28348, 49.5119}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17353766
    {Coordinate{8.24987, 49.5139}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q17354278
    {Coordinate{17.3297, 62.4864}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Timrå railway station
    {Coordinate{16.5631, 48.1208}, Tz::Europe_Vienna, CountryId{"AT"}}, // Vienna Airport
    {Coordinate{6.71472, 51.9681}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winterswijk railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q17385159
    {Coordinate{6.16108, 52.257}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deventer railway station
    {Coordinate{13.2879, 43.6773}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17462133
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q17462325
    {Coordinate{7.14222, 51.4264}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bochum-Dahlhausen station
    {Coordinate{4.78583, 43.9217}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avignon TGV
    {Coordinate{11.9905, 51.3569}, Tz::Europe_Berlin, CountryId{"DE"}}, // Merseburg railway station
    {Coordinate{8.28311, 45.7163}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494287
    {Coordinate{8.4177, 45.5955}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494292
    {Coordinate{8.43602, 45.5738}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494294
    {Coordinate{12.1028, 45.6767}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494296
    {Coordinate{12.0144, 45.6703}, Tz::Europe_Rome, CountryId{"IT"}}, // Albaredo railway halt
    {Coordinate{11.8573, 45.6558}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494300
    {Coordinate{11.7489, 45.6349}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494303
    {Coordinate{11.7148, 45.6215}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494305
    {Coordinate{8.47884, 45.5387}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494314
    {Coordinate{12.5337, 44.0883}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494364
    {Coordinate{12.0756, 44.4833}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17494366
    {Coordinate{8.94689, 46.0055}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lugano railway station
    {Coordinate{32.6514, 46.6825}, Tz::Europe_Kiev, CountryId{"UA"}}, // Puteiska
    {Coordinate{13.3343, 52.597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Wittenau station
    {Coordinate{12.8817, 47.7308}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Bad Reichenhall
    {Coordinate{10.3301, 51.6439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzberg (Harz) station
    {Coordinate{7.03361, 49.1578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kleinblittersdorf
    {Coordinate{8.42117, 49.4617}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigshafen-Mundenheim station
    {Coordinate{30.438, 60.0331}, Tz::Europe_Moscow, CountryId{"RU"}}, // Murino
    {Coordinate{8.36036, 49.195}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sondernheim station
    {Coordinate{-8.43205, 40.2088}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Coimbra-A railway station
    {Coordinate{36.6114, 45.3636}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Krym
    {Coordinate{15.3822, 41.7786}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637099
    {Coordinate{12.2947, 42.518}, Tz::Europe_Rome, CountryId{"IT"}}, // Attigliano-Bomarzo railway station
    {Coordinate{8.7144, 46.2398}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637112
    {Coordinate{13.6876, 45.754}, Tz::Europe_Rome, CountryId{"IT"}}, // Aurisina railway station
    {Coordinate{8.74292, 46.2058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637118
    {Coordinate{11.9694, 44.4123}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637120
    {Coordinate{11.9954, 45.0608}, Tz::Europe_Rome, CountryId{"IT"}}, // Baricetta train station
    {Coordinate{8.60747, 46.3393}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637133
    {Coordinate{8.62239, 46.1584}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637136
    {Coordinate{9.05639, 40.8919}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637145
    {Coordinate{8.45164, 46.1358}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637147
    {Coordinate{8.61108, 46.1548}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637154
    {Coordinate{12.2492, 45.1112}, Tz::Europe_Rome, CountryId{"IT"}}, // Cavanella d’Adige railway station
    {Coordinate{11.5702, 45.5963}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637176
    {Coordinate{8.72123, 46.1837}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cavigliano train station
    {Coordinate{8.39867, 46.1266}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637193
    {Coordinate{12.779, 42.412}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637204
    {Coordinate{8.67516, 46.1688}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637209
    {Coordinate{8.32562, 46.1241}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637214
    {Coordinate{7.36991, 44.4627}, Tz::Europe_Rome, CountryId{"IT"}}, // Dronero railway station
    {Coordinate{8.43367, 46.133}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637235
    {Coordinate{11.5463, 45.6351}, Tz::Europe_Rome, CountryId{"IT"}}, // Dueville railway station
    {Coordinate{8.55804, 46.1343}, Tz::Europe_Rome, CountryId{"IT"}}, // Folsogno-Dissimo railway station
    {Coordinate{8.41983, 46.1288}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637269
    {Coordinate{16.6689, 41.1808}, Tz::Europe_Rome, CountryId{"IT"}}, // Giovinazzo railway station
    {Coordinate{12.0712, 44.3894}, Tz::Europe_Rome, CountryId{"IT"}}, // Godo railway halt
    {Coordinate{8.74185, 46.2249}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637281
    {Coordinate{12.7768, 42.4628}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637283
    {Coordinate{8.70222, 46.1775}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637306
    {Coordinate{12.7463, 42.5061}, Tz::Europe_Rome, CountryId{"IT"}}, // Labro-Moggio railway station
    {Coordinate{11.913, 45.0434}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637327
    {Coordinate{8.80101, 46.1727}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locarno FART station
    {Coordinate{8.78614, 46.1689}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locarno Sant'Antonio train station
    {Coordinate{8.6904, 46.2613}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637337
    {Coordinate{12.1916, 45.0595}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637338
    {Coordinate{8.94771, 46.0045}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lugano FPL railway station
    {Coordinate{8.49935, 46.1292}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637358
    {Coordinate{11.4246, 45.7068}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637360
    {Coordinate{14.2879, 41.0359}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637363
    {Coordinate{12.7151, 42.5474}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637371
    {Coordinate{8.33342, 46.1226}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637373
    {Coordinate{8.32403, 46.132}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637376
    {Coordinate{8.98305, 45.8774}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637381
    {Coordinate{10.3987, 44.9667}, Tz::Europe_Rome, CountryId{"IT"}}, // Mezzani-Rondani railway halt
    {Coordinate{16.5964, 41.1958}, Tz::Europe_Rome, CountryId{"IT"}}, // Molfetta railway station
    {Coordinate{8.54342, 39.2446}, Tz::Europe_Rome, CountryId{"IT"}}, // Monte Arcau railway station
    {Coordinate{14.7575, 40.82}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637409
    {Coordinate{10.8237, 45.3067}, Tz::Europe_Rome, CountryId{"IT"}}, // Mozzecane railway station
    {Coordinate{8.06125, 44.339}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637417
    {Coordinate{11.6065, 45.2217}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637425
    {Coordinate{8.63095, 46.1611}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637428
    {Coordinate{15.3507, 41.8077}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637455
    {Coordinate{8.75327, 46.1858}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637457
    {Coordinate{8.29269, 46.1456}, Tz::Europe_Rome, CountryId{"IT"}}, // Preglia railway station
    {Coordinate{8.4796, 46.1331}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637478
    {Coordinate{10.9119, 44.6913}, Tz::Europe_Rome, CountryId{"IT"}}, // Quattro Ville railway halt
    {Coordinate{8.5395, 46.1273}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637487
    {Coordinate{14.3034, 41.0623}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637491
    {Coordinate{8.60177, 46.1543}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637494
    {Coordinate{15.49, 41.5792}, Tz::Europe_Rome, CountryId{"IT"}}, // Rignano Garganico railway station
    {Coordinate{12.2195, 42.2825}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637520
    {Coordinate{12.2397, 45.0755}, Tz::Europe_Rome, CountryId{"IT"}}, // Rosolina railway halt
    {Coordinate{8.5442, 45.5111}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637527
    {Coordinate{8.77037, 46.172}, Tz::Europe_Zurich, CountryId{"CH"}}, // San Martino train station
    {Coordinate{8.4605, 46.1364}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637544
    {Coordinate{11.8491, 44.3565}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637559
    {Coordinate{8.77759, 46.1695}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solduno train station
    {Coordinate{10.9061, 44.7227}, Tz::Europe_Rome, CountryId{"IT"}}, // Soliera Modenese railway station
    {Coordinate{8.6619, 46.2867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637569
    {Coordinate{14.093, 41.1858}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637573
    {Coordinate{12.6538, 42.518}, Tz::Europe_Rome, CountryId{"IT"}}, // Stroncone railway station
    {Coordinate{8.74278, 46.1861}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637585
    {Coordinate{12.625, 42.5496}, Tz::Europe_Rome, CountryId{"IT"}}, // Terni Cospea railway station
    {Coordinate{12.7828, 42.4363}, Tz::Europe_Rome, CountryId{"IT"}}, // Terria train station
    {Coordinate{11.4767, 45.6999}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637595
    {Coordinate{12.1833, 41.9243}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637600
    {Coordinate{10.3627, 44.8857}, Tz::Europe_Rome, CountryId{"IT"}}, // Torrile-San Polo railway station
    {Coordinate{8.33354, 46.1226}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637611
    {Coordinate{8.24491, 46.2063}, Tz::Europe_Rome, CountryId{"IT"}}, // Varzo railway station
    {Coordinate{8.64939, 46.1652}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q17637629
    {Coordinate{8.35215, 46.1219}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637630
    {Coordinate{8.72987, 46.1846}, Tz::Europe_Zurich, CountryId{"CH"}}, // Verscio train station
    {Coordinate{11.5241, 45.6569}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637637
    {Coordinate{8.49076, 46.1296}, Tz::Europe_Rome, CountryId{"IT"}}, // Q17637645
    {Coordinate{12.0825, 50.0044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marktredwitz station
    {Coordinate{24.7337, 59.4114}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Tondi railway station
    {Coordinate{32.0503, 49.4261}, Tz::Europe_Kiev, CountryId{"UA"}}, // Cherkasy
    {Coordinate{8.58297, 47.4482}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kloten railway station
    {Coordinate{8.56174, 47.4292}, Tz::Europe_Zurich, CountryId{"CH"}}, // Opfikon railway station
    {Coordinate{8.47208, 47.4368}, Tz::Europe_Zurich, CountryId{"CH"}}, // Regensdorf-Watt railway station
    {Coordinate{8.50824, 47.421}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Affoltern railway station
    {Coordinate{8.43522, 47.4539}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buchs-Dällikon railway station
    {Coordinate{2.34028, 48.8467}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Luxembourg
    {Coordinate{15.2231, 51.2901}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Węgliniec railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q17749204
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q17749214
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q17749510
    {Coordinate{15.1383, 50.5869}, Tz::Europe_Prague, CountryId{"CZ"}}, // Turnov
    {Coordinate{16.4856, 48.2334}, Tz::Europe_Vienna, CountryId{"AT"}}, // Hausfeldstraße
    {Coordinate{13.6311, 52.2966}, Tz::Europe_Berlin, CountryId{"DE"}}, // Königs Wusterhausen station
    {Coordinate{8.51556, 47.1742}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zug railway station
    {Coordinate{9.145, 45.1889}, Tz::Europe_Rome, CountryId{"IT"}}, // Pavia railway station
    {Coordinate{5.54944, 53.1822}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Franeker railway station
    {Coordinate{6.56389, 53.2106}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Groningen railway station
    {Coordinate{6.58444, 53.205}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Groningen Europapark railway station
    {Coordinate{6.55639, 53.23}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Groningen Noord railway station
    {Coordinate{5.79324, 53.1965}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leeuwarden railway station
    {Coordinate{5.84167, 53.2019}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leeuwarden Camminghaburen railway station
    {Coordinate{5.81639, 53.1989}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leeuwarden Achter de Hoven railway station
    {Coordinate{6.51861, 53.3614}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Baflo railway station
    {Coordinate{6.51972, 53.3306}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winsum railway station
    {Coordinate{11.7292, 45.9197}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18005296
    {Coordinate{14.3959, 41.0486}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18005298
    {Coordinate{8.79518, 40.7776}, Tz::Europe_Rome, CountryId{"IT"}}, // Martis train station
    {Coordinate{12.7954, 42.3958}, Tz::Europe_Rome, CountryId{"IT"}}, // Poggio Fidoni railway halt
    {Coordinate{11.7247, 45.7945}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18005304
    {Coordinate{11.6914, 45.8381}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18005310
    {Coordinate{8.2126, 48.9806}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Berg (Pfalz)
    {Coordinate{19.1272, 47.4829}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőbánya alsó railway station
    {Coordinate{19.1338, 47.4918}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőbánya felső railway station
    {Coordinate{8.23852, 48.9923}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18005407
    {Coordinate{19.097, 47.4338}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pesterzsébet railway station
    {Coordinate{19.1881, 47.4025}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pestszentimre railway station
    {Coordinate{19.1731, 47.414}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pestszentimre felső railway station
    {Coordinate{19.1823, 47.455}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pestszentlőrinc railway station
    {Coordinate{19.1223, 47.5777}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákospalota-Kertváros railway station
    {Coordinate{19.1462, 47.5212}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákosszentmihály railway station
    {Coordinate{1.61806, 43.7506}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Roqueserière-Buzet
    {Coordinate{19.1232, 47.4023}, Tz::Europe_Budapest, CountryId{"HU"}}, // Soroksár railway station
    {Coordinate{19.0836, 47.4575}, Tz::Europe_Budapest, CountryId{"HU"}}, // Soroksári út railway station
    {Coordinate{19.2128, 47.444}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szemeretelep railway station
    {Coordinate{11.7908, 50.1891}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18018567
    {Coordinate{9.76691, 49.0968}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwäbisch Hall-Hessental station
    {Coordinate{12.4317, 52.0989}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18018576
    {Coordinate{-0.296208, 46.3605}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1808439
    {Coordinate{6.78213, 51.1235}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nievenheim station
    {Coordinate{7.63829, 48.4231}, Tz::Europe_Paris, CountryId{"FR"}}, // Erstein
    {Coordinate{2.4592, 49.8993}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Daours
    {Coordinate{16.2839, 48.1347}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Hetzendorf railway station
    {Coordinate{6.42083, 52.2839}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Holten railway station
    {Coordinate{2.75125, 48.4872}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1810022
    {Coordinate{-3.15721, 48.7056}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1810028
    {Coordinate{7.83152, 48.9163}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1810354
    {Coordinate{6.4161, 48.2446}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1810836
    {Coordinate{7.39768, 51.3417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagen-Westerbauer station
    {Coordinate{-0.368163, 48.7019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Briouze
    {Coordinate{-0.814986, 44.71}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1811485
    {Coordinate{1.205, 45.7783}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de l'Aiguille
    {Coordinate{8.58681, 50.2833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Saalburg
    {Coordinate{7.09398, 47.8132}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1812780
    {Coordinate{7.22127, 51.2742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Oberbarmen station
    {Coordinate{1.5628, 46.6947}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1813754
    {Coordinate{0.675851, 44.2328}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-du-Casse
    {Coordinate{1.74238, 43.744}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1814219
    {Coordinate{3.45139, 50.5694}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antoing railway station
    {Coordinate{12.3817, 51.3292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leipzig Bayerischer Bahnhof
    {Coordinate{5.70493, 43.1873}, Tz::Europe_Paris, CountryId{"FR"}}, // Station Saint-Cyr-les-Lecques-la-Cadière
    {Coordinate{2.29167, 48.9797}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Champ de courses d'Enghien
    {Coordinate{16.7192, 41.0151}, Tz::Europe_Rome, CountryId{"IT"}}, // Grumo Appula railway station
    {Coordinate{12.0497, 45.1978}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18170171
    {Coordinate{2.48443, 47.0965}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1817161
    {Coordinate{7.3391, 48.5258}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1817356
    {Coordinate{14.5131, 46.0589}, Tz::Europe_Ljubljana, CountryId{"SI"}}, // Ljubljana railway station
    {Coordinate{-1.11561, 46.1081}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1817868
    {Coordinate{2.40887, 50.7307}, Tz::Europe_Paris, CountryId{"FR"}}, // Ebblinghem
    {Coordinate{16.1522, 50.2892}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q18180189
    {Coordinate{15.2603, 50.3339}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q18180332
    {Coordinate{4.58754, 48.7179}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vitry-le-François
    {Coordinate{3.57556, 51.0644}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landegem railway station
    {Coordinate{3.49635, 50.5472}, Tz::Europe_Brussels, CountryId{"BE"}}, // Maubray railway station
    {Coordinate{4.15593, 50.5628}, Tz::Europe_Brussels, CountryId{"BE"}}, // Écaussinnes railway station
    {Coordinate{6.66447, 49.0517}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1820464
    {Coordinate{4.28306, 51.0772}, Tz::Europe_Brussels, CountryId{"BE"}}, // Puurs railway station
    {Coordinate{2.27333, 48.7347}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Massy-Verrières
    {Coordinate{2.4275, 44.2703}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Baraqueville
    {Coordinate{5.58186, 45.322}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moirans
    {Coordinate{7.3806, 48.9201}, Tz::Europe_Paris, CountryId{"FR"}}, // Wingen-sur-Moder
    {Coordinate{3.41078, 44.4996}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Barjac
    {Coordinate{2.25083, 48.5181}, Tz::Europe_Paris, CountryId{"FR"}}, // Lardy (Paris RER)
    {Coordinate{1.94028, 42.4572}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ur-Les Escaldes
    {Coordinate{11.8033, 43.48}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18223645
    {Coordinate{14.3801, 41.0362}, Tz::Europe_Rome, CountryId{"IT"}}, // Maddaloni Inferiore railway station
    {Coordinate{14.0771, 41.232}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18224699
    {Coordinate{3.91142, 50.3912}, Tz::Europe_Brussels, CountryId{"BE"}}, // Genly railway station
    {Coordinate{4.36167, 50.7942}, Tz::Europe_Brussels, CountryId{"BE"}}, // Saint-Job railway station
    {Coordinate{4.27382, 50.7664}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lot railway station
    {Coordinate{5.86417, 50.5908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Verviers-Palais railway station
    {Coordinate{3.78167, 50.9367}, Tz::Europe_Brussels, CountryId{"BE"}}, // Scheldewindeke railway station
    {Coordinate{5.13455, 48.1095}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chaumont
    {Coordinate{1.79736, 47.3693}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1826289
    {Coordinate{1.58147, 49.0387}, Tz::Europe_Paris, CountryId{"FR"}}, // Bonnières
    {Coordinate{-1.38983, 47.9132}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1826665
    {Coordinate{3.00652, 49.577}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Noyon
    {Coordinate{1.13979, 48.4786}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1828187
    {Coordinate{3.44861, 50.0911}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bertry
    {Coordinate{7.55583, 50.1558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18286822
    {Coordinate{8.43143, 50.0173}, Tz::Europe_Berlin, CountryId{"DE"}}, // Flörsheim (Main) station
    {Coordinate{8.67651, 39.2885}, Tz::Europe_Rome, CountryId{"IT"}}, // Musei railway station
    {Coordinate{12.0852, 45.1479}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18289214
    {Coordinate{12.0915, 45.1361}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18289217
    {Coordinate{3.40972, 50.1114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Caudry
    {Coordinate{0.387395, 43.1142}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lannemezan
    {Coordinate{5.83944, 51.995}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oosterbeek railway station
    {Coordinate{1.25139, 43.3558}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longages-Noé
    {Coordinate{7.31256, 47.9603}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rouffach
    {Coordinate{2.17214, 50.4248}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1832264
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18325042
    {Coordinate{14.3497, 53.2708}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tantow railway station
    {Coordinate{2.92028, 45.8606}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1832854
    {Coordinate{38.374, 49.0027}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q18340062
    {Coordinate{10.3216, 51.3876}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leinefelde station
    {Coordinate{7.585, 51.5569}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Kurl station
    {Coordinate{5.40647, 43.2962}, Tz::Europe_Paris, CountryId{"FR"}}, // Marseille-Blancarde
    {Coordinate{17.1079, 40.5828}, Tz::Europe_Rome, CountryId{"IT"}}, // Massafra railway station
    {Coordinate{-3.16438, 48.698}, Tz::Europe_Paris, CountryId{"FR"}}, // Halte de Pontrieux
    {Coordinate{5.05495, 47.3228}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dijon-Porte-Neuve
    {Coordinate{1.03959, 49.5133}, Tz::Europe_Paris, CountryId{"FR"}}, // Malaunay-Le Houlme
    {Coordinate{108.037, 51.915}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Onohoy station
    {Coordinate{5.19345, 45.9019}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1837811
    {Coordinate{2.31518, 44.1004}, Tz::Europe_Paris, CountryId{"FR"}}, // Q18380048
    {Coordinate{5.25685, 43.3402}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Niolon
    {Coordinate{-4.28514, 48.3922}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1838040
    {Coordinate{16.9845, 40.6067}, Tz::Europe_Rome, CountryId{"IT"}}, // Palagianello railway station
    {Coordinate{9.02239, 47.2179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaltbrunn railway station
    {Coordinate{2.77722, 49.3866}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1838995
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18394946
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18395256
    {Coordinate{34.217, 46.8981}, Tz::Europe_Kiev, CountryId{"UA"}}, // 90 km
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18396312
    {Coordinate{12.7551, 43.0569}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18397591
    {Coordinate{12.7541, 43.0268}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18397592
    {Coordinate{12.7377, 42.9839}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18397595
    {Coordinate{15.1006, 50.6672}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q18398041
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18398515
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18398720
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18398773
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18398795
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18398978
    {Coordinate{}, Tz::Europe_Riga, CountryId{"LV"}}, // Q18398992
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Klimavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rechytsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yakawchytsy
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18399209
    {Coordinate{}, Tz::Europe_Riga, CountryId{"LV"}}, // Q18399262
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18399325
    {Coordinate{32.0594, 53.3781}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q18399428
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18399596
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Koshalyeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsukrovy Zavod
    {Coordinate{38.1653, 49.4086}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q18399974
    {Coordinate{38.2369, 49.0536}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q18400018
    {Coordinate{38.8501, 56.5077}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q18400055
    {Coordinate{33.5288, 44.5952}, Tz::Europe_Simferopol, CountryId{"RU"}}, // Sevastopol
    {Coordinate{35.5711, 45.2431}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q18400357
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Semyonov station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18400466
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byelaazyorsk
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18400852
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18400930
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18400965
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18400996
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18401016
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18401116
    {Coordinate{23.7317, 52.1117}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q18401257
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18401312
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyasy
    {Coordinate{60.5539, 56.8581}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q18401552
    {Coordinate{34.4255, 45.7946}, Tz::Europe_Simferopol, CountryId{"RU"}}, // Mamut
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Stawpy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Matsyeyevichy
    {Coordinate{38.5871, 56.3789}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q18402003
    {Coordinate{3.96161, 50.5364}, Tz::Europe_Brussels, CountryId{"BE"}}, // Masnuy-Saint-Pierre railway station
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q18404556
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vaytsyeshyn
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18404908
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18404969
    {Coordinate{37.6244, 55.8033}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q18405077
    {Coordinate{25.9708, 53.119}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kharytony
    {Coordinate{36.1581, 54.6191}, Tz::Europe_Moscow, CountryId{"RU"}}, // Muratovka
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18405474
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Naharany
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18405718
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18405747
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Aranchytsy
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18406895
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18406986
    {Coordinate{35.9078, 45.3297}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q18407043
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pawlavichy
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18407403
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Shartash Railway Station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18407889
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18408010
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18408133
    {Coordinate{33.61, 44.5889}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q18408450
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Prylutchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kabaki
    {Coordinate{38.0833, 49.4}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q18408698
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18408758
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Kamensk-Uralsky train station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18409141
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18409162
    {Coordinate{35.3489, 54.1162}, Tz::Europe_Moscow, CountryId{"RU"}}, // Sukhinichi
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18409379
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tkachy
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18409871
    {Coordinate{6.6078, 51.7697}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Dingden
    {Coordinate{7.80935, 48.8861}, Tz::Europe_Paris, CountryId{"FR"}}, // Walbourg
    {Coordinate{2.54806, 48.8406}, Tz::Europe_Paris, CountryId{"FR"}}, // Noisy-le-Grand – Mont d'Est
    {Coordinate{15.1914, 37.6889}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18420506
    {Coordinate{15.7581, 40.7877}, Tz::Europe_Rome, CountryId{"IT"}}, // Castel Lagopesole railway station
    {Coordinate{15.7523, 40.8372}, Tz::Europe_Rome, CountryId{"IT"}}, // Filiano railway station
    {Coordinate{8.51199, 40.2725}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18420518
    {Coordinate{15.6054, 41.3716}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18420523
    {Coordinate{8.94449, 45.8498}, Tz::Europe_Zurich, CountryId{"CH"}}, // Stabio railway station
    {Coordinate{-1.24499, 49.3023}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carentan
    {Coordinate{15.9768, 38.713}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18434303
    {Coordinate{14.7777, 41.0501}, Tz::Europe_Rome, CountryId{"IT"}}, // Chianche-Ceppaloni railway station
    {Coordinate{14.5722, 41.2105}, Tz::Europe_Rome, CountryId{"IT"}}, // stazione di Solopaca
    {Coordinate{0.803018, 44.38}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Penne-d'Agenais
    {Coordinate{5.79917, 49.5636}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aubange railway station
    {Coordinate{3.3435, 50.3102}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1845098
    {Coordinate{8.63891, 40.6814}, Tz::Europe_Rome, CountryId{"IT"}}, // Campomela railway station
    {Coordinate{24.7275, 59.4255}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Lilleküla railway station
    {Coordinate{5.10767, 50.2677}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leignon railway station
    {Coordinate{7.78227, 48.8135}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Haguenau
    {Coordinate{2.32126, 43.1305}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Verzeille
    {Coordinate{-0.910766, 43.5245}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Puyoô
    {Coordinate{2.13817, 48.8427}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1847150
    {Coordinate{6.03222, 51.235}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Swalmen railway station
    {Coordinate{-8.45265, 40.6723}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Sernada do Vouga railway station
    {Coordinate{4.86463, 51.0026}, Tz::Europe_Brussels, CountryId{"BE"}}, // Langdorp railway station
    {Coordinate{6.16241, 47.2001}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1848176
    {Coordinate{-8.31953, 41.4031}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Q18483120
    {Coordinate{-1.38926, 47.2929}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1848535
    {Coordinate{12.2606, 42.5895}, Tz::Europe_Rome, CountryId{"IT"}}, // Stazione di Alviano
    {Coordinate{2.5425, 48.5644}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Fargeau railway station
    {Coordinate{4.34, 51.1256}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schelle railway station
    {Coordinate{37.5881, 55.7942}, Tz::Europe_Moscow, CountryId{"RU"}}, // Savyolovsky railway station
    {Coordinate{14.426, 41.0876}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18510373
    {Coordinate{4.83977, 45.0723}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1851214
    {Coordinate{11.3745, 53.3863}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jasnitz railway station
    {Coordinate{27.216, 59.3612}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q185172
    {Coordinate{27.0547, 59.3587}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q185181
    {Coordinate{4.76879, 45.7347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1852144
    {Coordinate{5.58944, 52.1408}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barneveld Centrum railway station
    {Coordinate{6.669, 51.4135}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q1852663
    {Coordinate{26.9551, 59.3528}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Kiviõli railway station
    {Coordinate{4.59757, 50.7074}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bierges-Walibi railway station
    {Coordinate{2.26806, 48.5911}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Norville - Saint-Germain-lès-Arpajon
    {Coordinate{4.21302, 50.3212}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fontaine-Valmont railway station
    {Coordinate{6.49261, 47.6831}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1855889
    {Coordinate{1.10915, 46.0247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1856227
    {Coordinate{-0.501579, 45.4778}, Tz::Europe_Paris, CountryId{"FR"}}, // Clion-sur-Seugne
    {Coordinate{6.89348, 51.3415}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hösel station
    {Coordinate{14.2081, 53.2133}, Tz::Europe_Berlin, CountryId{"DE"}}, // Casekow station
    {Coordinate{5.36688, 50.67}, Tz::Europe_Brussels, CountryId{"BE"}}, // Momalle railway station
    {Coordinate{2.37167, 48.7478}, Tz::Europe_Paris, CountryId{"FR"}}, // Pont de Rungis – Aéroport d'Orly
    {Coordinate{2.82529, 49.4228}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Compiègne
    {Coordinate{2.30083, 48.8625}, Tz::Europe_Paris, CountryId{"FR"}}, // Pont de l'Alma
    {Coordinate{15.4654, 38.0464}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18590151
    {Coordinate{15.4043, 37.9861}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18590155
    {Coordinate{2.54222, 48.8231}, Tz::Europe_Paris, CountryId{"FR"}}, // Villiers-sur-Marne - Le Plessis-Trévise station
    {Coordinate{-2.24225, 53.4739}, Tz::Europe_London, CountryId{"GB"}}, // Manchester Oxford Road railway station
    {Coordinate{-2.24453, 53.4872}, Tz::Europe_London, CountryId{"GB"}}, // Manchester Victoria station
    {Coordinate{2.4357, 44.921}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aurillac
    {Coordinate{11.2655, 47.4403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mittenwald station
    {Coordinate{9.16317, 49.2304}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Wimpfen train station
    {Coordinate{6.49241, 47.0508}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gilley
    {Coordinate{11.7784, 45.2915}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18613410
    {Coordinate{10.4208, 50.5742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meiningen station
    {Coordinate{2.63389, 48.8389}, Tz::Europe_Paris, CountryId{"FR"}}, // Lognes
    {Coordinate{2.44933, 49.2927}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1861624
    {Coordinate{34.5697, 48.1833}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ryasna
    {Coordinate{8.24932, 50.4003}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aumenau station
    {Coordinate{9.10134, 49.2377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Rappenau station
    {Coordinate{12.5307, 52.4118}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616521
    {Coordinate{13.8822, 53.6597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ferdinandshof railway station
    {Coordinate{10.4217, 51.9111}, Tz::Europe_Berlin, CountryId{"DE"}}, // Goslar railway station
    {Coordinate{6.60694, 51.2228}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kaarster Bahnhof station
    {Coordinate{6.59389, 51.2266}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616527
    {Coordinate{8.78175, 48.9837}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q18616528
    {Coordinate{16.2293, 46.9455}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Mogersdorf
    {Coordinate{7.28874, 50.9329}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Overath
    {Coordinate{21.7781, 57.3544}, Tz::Europe_Riga, CountryId{"LV"}}, // Elkšķene Station
    {Coordinate{4.4325, 51.2817}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kapellen railway station
    {Coordinate{10.3142, 53.5297}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aumühle railway station
    {Coordinate{10.0964, 53.5158}, Tz::Europe_Berlin, CountryId{"DE"}}, // Billwerder-Moorfleet station
    {Coordinate{10.1317, 53.4978}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mittlerer Landweg station
    {Coordinate{10.1811, 53.4878}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nettelnburg station
    {Coordinate{10.0658, 53.5311}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tiefstack station
    {Coordinate{22.5686, 51.2316}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Lublin
    {Coordinate{7.31428, 43.707}, Tz::Europe_Paris, CountryId{"FR"}}, // Villefranche-sur-Mer railway station
    {Coordinate{0.573483, 43.078}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montréjeau-Gourdan-Polignan
    {Coordinate{7.07957, 51.1638}, Tz::Europe_Berlin, CountryId{"DE"}}, // Solingen Grünewald station
    {Coordinate{2.29074, 48.5651}, Tz::Europe_Paris, CountryId{"FR"}}, // Marolles-en-Hurepoix (Paris RER)
    {Coordinate{7.40799, 50.9868}, Tz::Europe_Berlin, CountryId{"DE"}}, // Engelskirchen station
    {Coordinate{2.02757, 48.9704}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1864282
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18643833
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18643860
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18643862
    {Coordinate{3.34558, 44.474}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1865145
    {Coordinate{8.61002, 46.9992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brunnen railway station
    {Coordinate{0.900523, 45.8814}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1865229
    {Coordinate{4.43472, 51.2914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Mariaburg railway station
    {Coordinate{6.02552, 48.9855}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1865759
    {Coordinate{2.17532, 49.0705}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1865785
    {Coordinate{4.25944, 51.2083}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beveren railway station
    {Coordinate{27.175, 62.4522}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18658791
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Hamina railway station
    {Coordinate{25.0726, 60.3399}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18658843
    {Coordinate{27.22, 66.6967}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18658855
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18658867
    {Coordinate{26.7878, 61.1953}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18659086
    {Coordinate{28.8849, 61.2477}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18659345
    {Coordinate{22.6551, 63.4084}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18659468
    {Coordinate{27.1179, 60.8999}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kaipiainen railway station
    {Coordinate{24.7128, 64.1433}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kangas railway station
    {Coordinate{29.114, 61.8614}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18659988
    {Coordinate{24.9617, 64.3464}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kilpua railway station
    {Coordinate{29.2878, 63.5147}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660102
    {Coordinate{26.6019, 60.8472}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660156
    {Coordinate{29.7533, 63.3617}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660359
    {Coordinate{22.9359, 61.9804}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660483
    {Coordinate{28.26, 61.0668}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660512
    {Coordinate{29.9925, 63.1522}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660555
    {Coordinate{-1.6725, 48.1033}, Tz::Europe_Paris, CountryId{"FR"}}, // Rennes railway station
    {Coordinate{25.4948, 60.7997}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Henna railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660761
    {Coordinate{28.3371, 61.0867}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660892
    {Coordinate{21.513, 61.5904}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Mäntyluoto railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660944
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18660971
    {Coordinate{25.375, 60.3822}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Olli points
    {Coordinate{22.5158, 60.4233}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Piikkiö railway station
    {Coordinate{29.7416, 61.7904}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661412
    {Coordinate{27.9731, 60.9272}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Pulsa railway station
    {Coordinate{29.3825, 61.7611}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Punkaharju railway station
    {Coordinate{28.6875, 61.1785}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661641
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661662
    {Coordinate{28.3181, 63.0631}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661665
    {Coordinate{30.0486, 62.1428}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661666
    {Coordinate{21.4889, 61.1314}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Rauma railway station
    {Coordinate{28.8028, 60.7322}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q18661669
    {Coordinate{24.1619, 65.7608}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661801
    {Coordinate{27.2856, 62.6758}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18661835
    {Coordinate{26.9394, 60.4681}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kotka port railway station
    {Coordinate{23.3128, 61.8361}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662004
    {Coordinate{23.4428, 59.9794}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Tammisaari railway station
    {Coordinate{28.0961, 61.0178}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662288
    {Coordinate{26.9544, 60.5733}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662311
    {Coordinate{27.9973, 61.0094}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662535
    {Coordinate{25.8792, 62.2478}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vaajakoski railway station
    {Coordinate{23.2272, 61.9174}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662650
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662782
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662802
    {Coordinate{26.795, 61.0956}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18662950
    {Coordinate{29.9925, 63.1522}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Vuonislahti railway station
    {Coordinate{22.5328, 62.9181}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18663108
    {Coordinate{22.7066, 61.2968}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18663135
    {Coordinate{2.11661, 49.3472}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sulpice-Auteuil
    {Coordinate{2.64037, 50.5212}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1866833
    {Coordinate{-2.7525, 47.6653}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vannes
    {Coordinate{-1.94139, 46.6964}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Gilles-Croix-de-Vie
    {Coordinate{11.9975, 53.837}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bützow station
    {Coordinate{11.9863, 51.9934}, Tz::Europe_Berlin, CountryId{"DE"}}, // Güterglück railway station
    {Coordinate{2.41917, 48.7253}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1867611
    {Coordinate{9.3927, 49.4214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Adelsheim Nord
    {Coordinate{9.027, 48.21}, Tz::Europe_Berlin, CountryId{"DE"}}, // Albstadt-Ebingen
    {Coordinate{9.38237, 48.7204}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altbach
    {Coordinate{27.8089, 62.175}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18681899
    {Coordinate{22.0886, 61.2095}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kiukainen railway station
    {Coordinate{25.2069, 66.1697}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Koivu railway station
    {Coordinate{24.3756, 61.8077}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682054
    {Coordinate{22.7489, 60.7028}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kyrö railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682154
    {Coordinate{26.1961, 62.26}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Lievestuore Railway Station
    {Coordinate{27.2628, 64.5347}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682185
    {Coordinate{28.6739, 62.9278}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682203
    {Coordinate{27.7606, 60.9444}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Luumäki railway station
    {Coordinate{8.84099, 47.7589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Singen (Hohentwiel) station
    {Coordinate{26.1855, 60.9164}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682240
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682293
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682313
    {Coordinate{30.6003, 62.1747}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Niirala railway station
    {Coordinate{24.3661, 61.05}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682401
    {Coordinate{28.2775, 62.0139}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Rantasalmi railway station
    {Coordinate{27.8975, 60.9778}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682507
    {Coordinate{26.4783, 62.3026}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Hankasalmi Railway Station
    {Coordinate{29.085, 61.3008}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682514
    {Coordinate{23.6267, 61.0633}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682515
    {Coordinate{28.8001, 63.6864}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Valtimo railway station
    {Coordinate{28.1867, 64.4886}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682528
    {Coordinate{24.3651, 61.7969}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Juupajoki stop
    {Coordinate{25.0606, 65.6633}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Simo railway station
    {Coordinate{29.3719, 61.425}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682635
    {Coordinate{30.1208, 62.3179}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Säkäniemi railway point
    {Coordinate{27.5592, 60.9131}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Taavetti railway station
    {Coordinate{25.2903, 64.7703}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Tikkaperä railway station
    {Coordinate{25.0283, 64.6083}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Tuomioja railway station
    {Coordinate{26.4139, 64.7589}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Utajärvi railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682850
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18682873
    {Coordinate{8.98453, 49.4654}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eberbach railway station
    {Coordinate{9.27581, 48.747}, Tz::Europe_Berlin, CountryId{"DE"}}, // Esslingen-Mettingen
    {Coordinate{4.06923, 50.5731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Soignies railway station
    {Coordinate{1.21219, 45.6213}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Meyze
    {Coordinate{4.25361, 51.9164}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maassluis railway station
    {Coordinate{12.9817, 52.9615}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindow (Mark) railway station
    {Coordinate{12.9001, 53.0929}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinsberg (Mark) railway station
    {Coordinate{0.830346, 44.8625}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Trémolat
    {Coordinate{2.79944, 48.3783}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moret-Veneux-les-Sablons
    {Coordinate{1.98, 45.3544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montaignac-Saint-Hippolyte
    {Coordinate{23.42, 62.6422}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q18691335
    {Coordinate{4.25776, 50.7507}, Tz::Europe_Brussels, CountryId{"BE"}}, // Buizingen railway station
    {Coordinate{6.88229, 51.0372}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Blumenberg station
    {Coordinate{2.43109, 50.4802}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1869616
    {Coordinate{4.76405, 52.9326}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Helder Zuid railway station
    {Coordinate{1.27639, 49.5567}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longuerue-Vieux-Manoir
    {Coordinate{0.330393, 49.5607}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1870462
    {Coordinate{-0.441667, 45.4389}, Tz::Europe_Paris, CountryId{"FR"}}, // Jonzac
    {Coordinate{25.7544, 64.9125}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Pikkarala railway station
    {Coordinate{6.4825, 46.3692}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thonon-les-Bains
    {Coordinate{5.48294, 43.2863}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de la Barasse
    {Coordinate{23.5815, 49.9355}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q18712024
    {Coordinate{6.77056, 43.4228}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1871873
    {Coordinate{6.57556, 52.4414}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Daarlerveen railway station
    {Coordinate{2.52018, 49.2979}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1872396
    {Coordinate{24.185, 65.8508}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q1873186
    {Coordinate{4.70396, 44.3749}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1873503
    {Coordinate{11.1527, 51.7853}, Tz::Europe_Berlin, CountryId{"DE"}}, // Quedlinburg station
    {Coordinate{6.9916, 51.0316}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leverkusen Mitte station
    {Coordinate{14.9971, 37.4558}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18747427
    {Coordinate{9.87722, 53.4731}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuwiedenthal station
    {Coordinate{7.29143, 43.7222}, Tz::Europe_Paris, CountryId{"FR"}}, // Q18749562
    {Coordinate{2.4593, 50.7878}, Tz::Europe_Paris, CountryId{"FR"}}, // Cassel
    {Coordinate{10.0331, 53.6064}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rübenkamp station
    {Coordinate{2.3536, 48.9846}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Groslay
    {Coordinate{3.43053, 46.2091}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-des-Fossés
    {Coordinate{16.3677, 48.2606}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q18762414
    {Coordinate{0.693611, 47.3897}, Tz::Europe_Paris, CountryId{"FR"}}, // Tours railway station
    {Coordinate{5.67278, 51.9222}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hemmen-Dodewaard railway station
    {Coordinate{1.80892, 48.983}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1877088
    {Coordinate{6.899, 45.9505}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1877475
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q18776148
    {Coordinate{8.9409, 49.8331}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß-Umstadt Wiebelsbach station
    {Coordinate{0.549316, 46.8186}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1878152
    {Coordinate{9.08601, 40.9083}, Tz::Europe_Rome, CountryId{"IT"}}, // Aggius train station
    {Coordinate{8.46148, 45.3592}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo Vercelli railway halt
    {Coordinate{10.9681, 43.6054}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18785594
    {Coordinate{11.7908, 42.0918}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18785596
    {Coordinate{15.5955, 41.0621}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18785602
    {Coordinate{10.6966, 44.9591}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18785604
    {Coordinate{8.89871, 46.1731}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riazzino-Cugnasco train station
    {Coordinate{11.8746, 44.767}, Tz::Europe_Rome, CountryId{"IT"}}, // Rovereto-San Vito-Medelana railway station
    {Coordinate{7.27002, 48.5075}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1879120
    {Coordinate{6.01771, 49.225}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1879204
    {Coordinate{8.83056, 54.3342}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q1879381
    {Coordinate{2.11309, 42.5021}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1879424
    {Coordinate{6.30278, 45.353}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Avre - La Chambre
    {Coordinate{4.60778, 52.3908}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Overveen railway station
    {Coordinate{1.65722, 44.8183}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rocamadour-Padirac
    {Coordinate{37.8717, 48.1208}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yasynuvata
    {Coordinate{1.71532, 48.9836}, Tz::Europe_Paris, CountryId{"FR"}}, // Mantes-Station
    {Coordinate{5.5242, 50.4027}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sy railway station
    {Coordinate{2.57806, 48.8425}, Tz::Europe_Paris, CountryId{"FR"}}, // Noisy - Champs Station
    {Coordinate{2.2282, 48.8197}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bellevue
    {Coordinate{6.14667, 52.0906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Brummen railway station
    {Coordinate{4.32583, 51.0811}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ruisbroek-Sauvegarde railway station
    {Coordinate{15.38, 37.9617}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18844698
    {Coordinate{15.3914, 37.9729}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18844701
    {Coordinate{15.3677, 37.9463}, Tz::Europe_Rome, CountryId{"IT"}}, // Santa Teresa di Riva railway station
    {Coordinate{3.7936, 50.6612}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rebaix railway station
    {Coordinate{-1.51083, 47.2067}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sébastien-Pas-Enchantés
    {Coordinate{3.97351, 47.8596}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1885176
    {Coordinate{15.8175, 52.2419}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zbąszynek
    {Coordinate{4.08389, 51.1492}, Tz::Europe_Brussels, CountryId{"BE"}}, // Belsele railway station
    {Coordinate{6.98788, 51.2508}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mettmann Stadtwald station
    {Coordinate{5.92361, 46.8592}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1886762
    {Coordinate{3.51694, 50.3633}, Tz::Europe_Paris, CountryId{"FR"}}, // Valenciennes railway station
    {Coordinate{6.87763, 48.1984}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1888255
    {Coordinate{7.23919, 47.6273}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1888534
    {Coordinate{3.44608, 50.0397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Busigny
    {Coordinate{0.192021, 49.2871}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-l'Évêque
    {Coordinate{1.66695, 50.6609}, Tz::Europe_Paris, CountryId{"FR"}}, // Hesdigneul
    {Coordinate{7.42451, 48.5332}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1889469
    {Coordinate{2.99527, 50.7082}, Tz::Europe_Paris, CountryId{"FR"}}, // Quesnoy-sur-Deûle
    {Coordinate{2.18167, 48.6975}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Orsay-Ville
    {Coordinate{2.08939, 43.6241}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1890161
    {Coordinate{1.97052, 49.0997}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1890901
    {Coordinate{7.07, 46.0931}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q1891056
    {Coordinate{7.73944, 50.7831}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q1891076
    {Coordinate{3.89257, 45.0428}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Puy-en-Velay railway station
    {Coordinate{-3.19321, 47.7822}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1891517
    {Coordinate{6.73267, 43.432}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fréjus
    {Coordinate{6.07081, 50.7491}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aachen Süd railway station
    {Coordinate{2.32778, 48.7983}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1892192
    {Coordinate{1.00049, 47.1305}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1892240
    {Coordinate{12.3185, 43.0947}, Tz::Europe_Rome, CountryId{"IT"}}, // Q18923658
    {Coordinate{12.3559, 43.1024}, Tz::Europe_Rome, CountryId{"IT"}}, // Perugia Capitini railway station
    {Coordinate{5.19434, 44.6945}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1892411
    {Coordinate{4.18049, 50.4782}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Louvière-Centre railway station
    {Coordinate{4.97694, 52.2786}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Abcoude railway station
    {Coordinate{-1.84306, 48.5939}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1893283
    {Coordinate{5.29194, 51.6547}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vught railway station
    {Coordinate{3.98732, 50.911}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ede railway station
    {Coordinate{2.58139, 49.5625}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tricot
    {Coordinate{6.94111, 50.9686}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln Geldernstraße Parkgürtel station
    {Coordinate{-2.44972, 47.6833}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1895691
    {Coordinate{3.24916, 50.4772}, Tz::Europe_Paris, CountryId{"FR"}}, // Orchies
    {Coordinate{2.42278, 42.6181}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1897049
    {Coordinate{0.631366, 42.9629}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1897337
    {Coordinate{4.63194, 43.6847}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Arles
    {Coordinate{0.707778, 45.1874}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Périgueux
    {Coordinate{-1.55, 47.1842}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rezé-Pont-Rousseau
    {Coordinate{7.20966, 51.4725}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bochum-Ehrenfeld station
    {Coordinate{2.09905, 47.2101}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1901288
    {Coordinate{3.18966, 50.6116}, Tz::Europe_Paris, CountryId{"FR"}}, // Tressin
    {Coordinate{1.64166, 45.1818}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aubazine-Saint-Hilaire
    {Coordinate{8.88889, 40.8254}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060534
    {Coordinate{11.6753, 44.923}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060595
    {Coordinate{11.7386, 44.961}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060596
    {Coordinate{11.7492, 45.1322}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19060599
    {Coordinate{131.969, 43.3997}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Q19060782
    {Coordinate{-0.673809, 46.1997}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1906409
    {Coordinate{5.49796, 50.6185}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemeppe-sur-Meuse railway station
    {Coordinate{4.14417, 51.1719}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Niklaas railway station
    {Coordinate{-3.88221, 48.5079}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pleyber-Christ
    {Coordinate{5.66222, 53.0397}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sneek Noord railway station
    {Coordinate{5.32146, 43.3635}, Tz::Europe_Paris, CountryId{"FR"}}, // L'Estaque
    {Coordinate{-5.4286, 57.4228}, Tz::Europe_London, CountryId{"GB"}}, // Strathcarron railway station
    {Coordinate{3.27547, 50.1918}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1910819
    {Coordinate{4.67194, 51.0947}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melkouwen railway station
    {Coordinate{3.20182, 51.2231}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brugge-Sint-Pieters railway station
    {Coordinate{7.10172, 51.2543}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Rosenhügel station
    {Coordinate{3.12106, 49.5807}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1912185
    {Coordinate{7.10958, 51.4417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Eiberg station
    {Coordinate{-0.538965, 45.5781}, Tz::Europe_Paris, CountryId{"FR"}}, // Pons
    {Coordinate{2.82753, 45.7637}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1914494
    {Coordinate{5.17944, 52.0169}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Houten Castellum railway station
    {Coordinate{4.6325, 51.3569}, Tz::Europe_Brussels, CountryId{"BE"}}, // Noorderkempen railway station
    {Coordinate{2.20972, 49.0358}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bessancourt
    {Coordinate{-1.96191, 48.4995}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pleudihen
    {Coordinate{6.93332, 46.0325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vallorcine
    {Coordinate{7.45762, 43.7607}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1917107
    {Coordinate{3.34876, 50.4564}, Tz::Europe_Paris, CountryId{"FR"}}, // Rosult
    {Coordinate{2.36389, 49.7544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ailly-sur-Noye
    {Coordinate{3.88868, 50.508}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erbisœul railway station
    {Coordinate{7.1284, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Solingen-Schaberg
    {Coordinate{4.8132, 45.7174}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Oullins
    {Coordinate{-0.227205, 44.5686}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Macaire
    {Coordinate{4.41176, 50.3527}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jamioulx railway station
    {Coordinate{3.38599, 45.8212}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1921700
    {Coordinate{6.67444, 53.4094}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Uithuizen railway station
    {Coordinate{5.56944, 51.3853}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heeze railway station
    {Coordinate{7.51607, 43.9441}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Breil-sur-Roya
    {Coordinate{5.50972, 50.6197}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pont-de-Seraing railway station
    {Coordinate{18.9151, 50.3434}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Bytom
    {Coordinate{4.80427, 45.8886}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-au-Mont-d'Or
    {Coordinate{7.56613, 48.5454}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1922941
    {Coordinate{7.48756, 47.6349}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bartenheim
    {Coordinate{2.6991, 49.0321}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1923376
    {Coordinate{2.46389, 48.8436}, Tz::Europe_Paris, CountryId{"FR"}}, // Fontenay-sous-Bois (Paris RER)
    {Coordinate{-3.11806, 48.7618}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1923442
    {Coordinate{-0.220278, 47.3622}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1925026
    {Coordinate{4.63876, 50.958}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wespelaar-Tildonk railway station
    {Coordinate{5.43694, 51.2214}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neerpelt railway station
    {Coordinate{3.12734, 51.025}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lichtervelde railway station
    {Coordinate{2.79925, 48.4067}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1925713
    {Coordinate{7.21605, 48.4801}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1926234
    {Coordinate{3.01271, 48.5614}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nangis
    {Coordinate{4.77837, 45.9069}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1926670
    {Coordinate{2.79439, 49.1428}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1927198
    {Coordinate{6.76454, 50.5592}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Münstereifel station
    {Coordinate{6.68544, 49.802}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ehrang station
    {Coordinate{13.6152, 52.3715}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eichwalde station
    {Coordinate{8.783, 50.6053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großen Buseck station
    {Coordinate{13.2675, 52.2986}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ludwigsfelde railway station
    {Coordinate{11.1328, 51.6703}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274496
    {Coordinate{6.35789, 51.1505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19274497
    {Coordinate{14.1008, 52.5244}, Tz::Europe_Berlin, CountryId{"DE"}}, // Müncheberg
    {Coordinate{14.4492, 51.8441}, Tz::Europe_Berlin, CountryId{"DE"}}, // Peitz Ost station
    {Coordinate{13.9228, 52.5283}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rehfelde station
    {Coordinate{10.3722, 52.0496}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzgitter-Bad station
    {Coordinate{14.3517, 52.5594}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seelow-Gusow station
    {Coordinate{13.7453, 53.515}, Tz::Europe_Berlin, CountryId{"DE"}}, // Strasburg (Uckerm) railway station
    {Coordinate{13.1722, 52.685}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velten
    {Coordinate{7.95654, 51.6163}, Tz::Europe_Berlin, CountryId{"DE"}}, // Welver station
    {Coordinate{14.4056, 52.565}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werbig station
    {Coordinate{10.5319, 52.1589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolfenbüttel station
    {Coordinate{6.59199, 51.5424}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinberg (Rheinland)
    {Coordinate{2.50472, 48.7525}, Tz::Europe_Paris, CountryId{"FR"}}, // Boissy-Saint-Léger
    {Coordinate{-0.34187, 47.8417}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sablé
    {Coordinate{6.985, 51.589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19284709
    {Coordinate{6.65956, 48.5049}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1928764
    {Coordinate{1.80869, 48.9632}, Tz::Europe_Paris, CountryId{"FR"}}, // Épône - Mézières
    {Coordinate{7.58717, 48.5441}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Duppigheim
    {Coordinate{7.6534, 48.9052}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1930766
    {Coordinate{1.38322, 43.5965}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1931292
    {Coordinate{5.72944, 51.8111}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wijchen railway station
    {Coordinate{1.69183, 47.8136}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1931469
    {Coordinate{2.82481, 48.6446}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Verneuil-l'Étang
    {Coordinate{5.52448, 45.5446}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1932215
    {Coordinate{3.82694, 50.8158}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lierde railway station
    {Coordinate{4.40816, 50.7947}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boitsfort railway station
    {Coordinate{2.8374, 49.2001}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1934115
    {Coordinate{6.62806, 52.5725}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hardenberg railway station
    {Coordinate{0.334675, 48.0195}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1934692
    {Coordinate{5.7175, 50.8378}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maastricht Randwyck railway station
    {Coordinate{13.7692, 54.0439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolgast railway station
    {Coordinate{3.85723, 44.7327}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1935573
    {Coordinate{4.39045, 51.1975}, Tz::Europe_Brussels, CountryId{"BE"}}, // Antwerp-South railway station
    {Coordinate{10.0833, 54.3311}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19361135
    {Coordinate{10.0909, 54.3492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19361144
    {Coordinate{9.97891, 54.4098}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19361648
    {Coordinate{9.82056, 54.5418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19361996
    {Coordinate{5.42317, 45.3967}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Grand-Lemps
    {Coordinate{9.77118, 54.6371}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19362007
    {Coordinate{10.1817, 54.2867}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kiel-Elmschenhagen
    {Coordinate{10.0626, 54.2431}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19366881
    {Coordinate{9.99788, 54.1293}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19368418
    {Coordinate{9.82354, 53.99}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19368505
    {Coordinate{9.68078, 53.8526}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19368562
    {Coordinate{9.64506, 53.8049}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19368581
    {Coordinate{2.73774, 42.6774}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1937209
    {Coordinate{-0.505715, 44.7168}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Médard-d'Eyrans
    {Coordinate{6.56941, 48.1088}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1938345
    {Coordinate{4.07259, 50.8914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Denderleeuw railway station
    {Coordinate{0.855388, 49.0037}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1938997
    {Coordinate{16.1211, 50.2844}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q19400572
    {Coordinate{19.5444, 51.7631}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Łódź Widzew railway station
    {Coordinate{0.569167, 46.8747}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1940437
    {Coordinate{10.0574, 53.5767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedrichsberg station
    {Coordinate{1.69964, 46.8097}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Châteauroux
    {Coordinate{12.7131, 52.6758}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Paulinenaue
    {Coordinate{4.27509, 50.8897}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zellik railway station
    {Coordinate{6.92631, 45.9819}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1943343
    {Coordinate{7.26948, 51.2855}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwelm West station
    {Coordinate{5.57389, 52.0458}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenendaal-De Klomp railway station
    {Coordinate{4.3625, 50.5128}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pont-à-Celles railway station
    {Coordinate{10.0356, 53.5975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alte Wöhr station
    {Coordinate{6.60017, 48.0871}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1946266
    {Coordinate{10.0544, 53.6325}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kornweg station
    {Coordinate{2.3626, 49.167}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boran-sur-Oise
    {Coordinate{6.696, 48.4913}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1947085
    {Coordinate{5.73639, 50.8969}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bunde railway station
    {Coordinate{5.42056, 50.9106}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diepenbeek railway station
    {Coordinate{3.1485, 50.5605}, Tz::Europe_Paris, CountryId{"FR"}}, // Fretin
    {Coordinate{5.39757, 46.1943}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1947731
    {Coordinate{6.22222, 52.4267}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heino railway station
    {Coordinate{8.54392, 47.4117}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Oerlikon railway station
    {Coordinate{6.57753, 46.3979}, Tz::Europe_Paris, CountryId{"FR"}}, // Évian-les-Bains
    {Coordinate{4.4288, 50.2693}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pry railway station
    {Coordinate{4.86247, 50.4691}, Tz::Europe_Brussels, CountryId{"BE"}}, // Namur railway station
    {Coordinate{5.61972, 52.3375}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Harderwijk railway station
    {Coordinate{4.01119, 51.0031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schoonaarde railway station
    {Coordinate{6.95806, 50.9425}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cologne Central Station
    {Coordinate{12.5004, 45.6242}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19545547
    {Coordinate{12.7594, 45.7519}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19545550
    {Coordinate{8.94654, 46.0064}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q19545551
    {Coordinate{8.95158, 46.0029}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q19545553
    {Coordinate{14.6483, 41.2198}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19545569
    {Coordinate{10.6843, 44.9318}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19545574
    {Coordinate{8.5593, 45.179}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19545576
    {Coordinate{18.9889, 47.3987}, Tz::Europe_Budapest, CountryId{"HU"}}, // Barosstelep railway station
    {Coordinate{3.12522, 48.9509}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1956946
    {Coordinate{19.0976, 47.5449}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vasútmúzeum railway station
    {Coordinate{19.2956, 47.4566}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákoskert railway station
    {Coordinate{19.2448, 47.468}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákoshegy railway station
    {Coordinate{18.9494, 47.5959}, Tz::Europe_Budapest, CountryId{"HU"}}, // Solymár railway station
    {Coordinate{19.0142, 47.575}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aranyvölgy railway station
    {Coordinate{19.2843, 47.4921}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákoscsaba railway station
    {Coordinate{10.0681, 53.6356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hoheneichen station
    {Coordinate{10.0825, 53.6411}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wellingsbüttel station
    {Coordinate{6.9816, 43.5514}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Bosquet
    {Coordinate{18.1664, 40.3039}, Tz::Europe_Rome, CountryId{"IT"}}, // San Cesario di Lecce railway station
    {Coordinate{18.1853, 40.2697}, Tz::Europe_Rome, CountryId{"IT"}}, // San Donato di Lecce railway station
    {Coordinate{18.2253, 40.2181}, Tz::Europe_Rome, CountryId{"IT"}}, // Sternatia railway station
    {Coordinate{9.1425, 48.6964}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leinfelden station
    {Coordinate{2.32111, 48.7931}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1958487
    {Coordinate{0.553106, 48.7436}, Tz::Europe_Paris, CountryId{"FR"}}, // Station Rai - Aube
    {Coordinate{5.27278, 45.5839}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1958669
    {Coordinate{-2.96056, 47.6783}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sainte-Anne
    {Coordinate{16.2126, 48.3825}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Stockerau
    {Coordinate{10.2528, 53.5083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reinbek station
    {Coordinate{10.2781, 53.5207}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wohltorf station
    {Coordinate{4.89235, 45.8039}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1959696
    {Coordinate{-1.5459, 43.4592}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Biarritz
    {Coordinate{10.0028, 52.4492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Burgdorf station
    {Coordinate{2.15139, 48.8069}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montreuil
    {Coordinate{6.56694, 53.3906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Warffum railway station
    {Coordinate{5.86833, 51.8267}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Heyendaal railway station
    {Coordinate{8.61959, 47.4205}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietlikon railway station
    {Coordinate{8.44786, 47.3986}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schlieren railway station
    {Coordinate{8.42136, 47.3987}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glanzenberg railway station
    {Coordinate{5.63444, 53.1778}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dronrijp railway station
    {Coordinate{8.62294, 47.4}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dübendorf railway station
    {Coordinate{2.09837, 48.9969}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Conflans-Sainte-Honorine
    {Coordinate{54.3653, 39.4964}, Tz::Asia_Ashgabat, CountryId{"TM"}}, // Q19613410
    {Coordinate{60.6406, 56.7925}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19614010
    {Coordinate{}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19614020
    {Coordinate{}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19614028
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19614195
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Divizionnaya station
    {Coordinate{27.829, 56.4822}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19616282
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19618666
    {Coordinate{60.6669, 56.8169}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19618876
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19619183
    {Coordinate{2.29778, 48.8853}, Tz::Europe_Paris, CountryId{"FR"}}, // Pereire – Levallois
    {Coordinate{2.48583, 48.8053}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Parc de Saint-Maur (Paris RER)
    {Coordinate{5.15194, 52.3428}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Almere Poort railway station
    {Coordinate{7.77925, 48.703}, Tz::Europe_Paris, CountryId{"FR"}}, // Hœrdt
    {Coordinate{11.7959, 45.7323}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622699
    {Coordinate{11.8776, 45.6881}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622702
    {Coordinate{13.633, 42.8443}, Tz::Europe_Rome, CountryId{"IT"}}, // Marino del Tronto-Folignano railway halt
    {Coordinate{13.8189, 42.8857}, Tz::Europe_Rome, CountryId{"IT"}}, // Monsampolo del Tronto railway station
    {Coordinate{13.8499, 42.8942}, Tz::Europe_Rome, CountryId{"IT"}}, // Monteprandone railway station
    {Coordinate{13.7202, 42.8621}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622710
    {Coordinate{13.7628, 42.8703}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19622714
    {Coordinate{7.25549, 48.9062}, Tz::Europe_Paris, CountryId{"FR"}}, // Station Tieffenbach - Struth
    {Coordinate{2.31194, 48.78}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourg-la-Reine
    {Coordinate{4.34417, 51.9031}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlaardingen Centrum railway station
    {Coordinate{6.73611, 51.4572}, Tz::Europe_Berlin, CountryId{"DE"}}, // Haltepunkt Duisburg-Ruhrort
    {Coordinate{6.9709, 51.713}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Deuten
    {Coordinate{-4.38813, 48.4095}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1963578
    {Coordinate{-2.22897, 48.5216}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1964745
    {Coordinate{-2.84359, 48.4993}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1965252
    {Coordinate{1.90462, 47.9078}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Orléans
    {Coordinate{4.92556, 50.8061}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tienen railway station
    {Coordinate{4.61694, 51.9653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nieuwerkerk aan den IJssel railway station
    {Coordinate{6.11904, 50.8874}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzogenrath August-Schmidt-Platz station
    {Coordinate{39.8353, 57.6256}, Tz::Europe_Moscow, CountryId{"RU"}}, // Yaroslavl railway station
    {Coordinate{7.14361, 46.0278}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q1968217
    {Coordinate{16.1506, 38.7264}, Tz::Europe_Rome, CountryId{"IT"}}, // Pizzo train station
    {Coordinate{2.26333, 48.9897}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ermont-Halte
    {Coordinate{7.05228, 48.7385}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1968912
    {Coordinate{43.9217, 40.1831}, Tz::Asia_Yerevan, CountryId{"AM"}}, // Q19689155
    {Coordinate{8.72933, 40.4559}, Tz::Europe_Rome, CountryId{"IT"}}, // Giave railway station
    {Coordinate{6.49661, 44.567}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1969231
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lakhva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikhanavichy
    {Coordinate{25.3745, 49.0612}, Tz::Europe_Kiev, CountryId{"UA"}}, // Buchach
    {Coordinate{3.11561, 50.6228}, Tz::Europe_Paris, CountryId{"FR"}}, // Hellemmes
    {Coordinate{3.23767, 45.7886}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1970035
    {Coordinate{-4.08217, 48.496}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1970255
    {Coordinate{10.704, 44.8131}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19702579
    {Coordinate{0.4965, 46.7597}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1970279
    {Coordinate{8.53032, 40.6893}, Tz::Europe_Rome, CountryId{"IT"}}, // Tissi-Usini railway station
    {Coordinate{27.485, 48.4056}, Tz::Europe_Chisinau, CountryId{"MD"}}, // Q19706103
    {Coordinate{1.58971, 46.7353}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1970651
    {Coordinate{6.4497, 48.56}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1971525
    {Coordinate{5.76833, 46.3569}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1971887
    {Coordinate{11.797, 51.1631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Naumburg (Saale) Hauptbahnhof
    {Coordinate{8.8712, 53.0185}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dreye railway station
    {Coordinate{8.8185, 52.9468}, Tz::Europe_Berlin, CountryId{"DE"}}, // Barrien railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19721733
    {Coordinate{34.5817, 46.0357}, Tz::Europe_Kiev, CountryId{"UA"}}, // 1334 km
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19721818
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19721821
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19721825
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19721827
    {Coordinate{13.5536, 52.5575}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mehrower Allee station
    {Coordinate{2.31194, 51.0022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grande-Synthe
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19742076
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19742671
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Kamennogorsk railway station
    {Coordinate{2.20056, 49.9283}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ailly-sur-Somme
    {Coordinate{4.60972, 51.6414}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zevenbergen railway station
    {Coordinate{18.9142, 47.6092}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vörösvárbánya railway station
    {Coordinate{18.9281, 47.6011}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szélhegy railway station
    {Coordinate{11.5551, 49.499}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof in Pommelsbrunn
    {Coordinate{4.22278, 50.955}, Tz::Europe_Brussels, CountryId{"BE"}}, // Merchtem railway station
    {Coordinate{-0.555143, 44.7994}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bègles
    {Coordinate{12.1352, 43.5698}, Tz::Europe_Rome, CountryId{"IT"}}, // Sansepolcro railway station
    {Coordinate{13.6647, 42.8449}, Tz::Europe_Rome, CountryId{"IT"}}, // Maltignano railway station
    {Coordinate{5.08168, 50.4972}, Tz::Europe_Brussels, CountryId{"BE"}}, // Château-de-Seilles railway station
    {Coordinate{6.87695, 48.3672}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Étival-Clairefontaine
    {Coordinate{3.18431, 51.3303}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zeebrugge-Strand railway station
    {Coordinate{15.7561, 50.9028}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q1978260
    {Coordinate{4.96472, 50.2106}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gendron-Celles railway station
    {Coordinate{7.5897, 48.0271}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19787796
    {Coordinate{0.6088, 46.9376}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1978811
    {Coordinate{60.025, 57.8531}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19788457
    {Coordinate{37.1583, 57.7806}, Tz::Europe_Moscow, CountryId{"RU"}}, // Sonkovo railway station
    {Coordinate{3.79528, 50.4358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boussu railway station
    {Coordinate{6.62349, 47.6991}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1981040
    {Coordinate{7.17667, 49.3531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neunkirchen Central Station
    {Coordinate{37.7463, 48.0439}, Tz::Europe_Kiev, CountryId{"UA"}}, // Donetsk Railway Station
    {Coordinate{4.72099, 50.5514}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lonzée railway station
    {Coordinate{7.02889, 49.2164}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brebach
    {Coordinate{5.31278, 51.2117}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lommel railway station
    {Coordinate{13.3577, 43.6072}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelferretti-Falconara Aeroporto delle Marche railway halt
    {Coordinate{13.3276, 43.5958}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiaravalle railway halt
    {Coordinate{13.2519, 43.5208}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819430
    {Coordinate{13.1828, 43.501}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819431
    {Coordinate{13.0847, 43.4816}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819433
    {Coordinate{13.0273, 43.445}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819434
    {Coordinate{12.9774, 43.403}, Tz::Europe_Rome, CountryId{"IT"}}, // Genga-San Vittore Terme railway station
    {Coordinate{12.7844, 43.1819}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819439
    {Coordinate{12.7339, 42.8763}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819440
    {Coordinate{12.7615, 42.8228}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819441
    {Coordinate{12.443, 42.479}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819444
    {Coordinate{14.061, 42.3059}, Tz::Europe_Rome, CountryId{"IT"}}, // Manoppello railway station
    {Coordinate{14.0196, 42.2872}, Tz::Europe_Rome, CountryId{"IT"}}, // Alanno railway station
    {Coordinate{13.8762, 42.1023}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19819467
    {Coordinate{8.59696, 40.6989}, Tz::Europe_Rome, CountryId{"IT"}}, // Scala di Giocca railway station
    {Coordinate{14.7243, 41.1721}, Tz::Europe_Rome, CountryId{"IT"}}, // Q19820610
    {Coordinate{6.36528, 51.9217}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Terborg railway station
    {Coordinate{12.0319, 48.0836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinhöring Station
    {Coordinate{6.94433, 51.2186}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochdahl station
    {Coordinate{8.70806, 50.1128}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt East station
    {Coordinate{1.91254, 48.1414}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Château-Gaillard
    {Coordinate{8.6505, 49.9506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835112
    {Coordinate{7.05007, 49.1188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hanweiler-Bad Rilchingen
    {Coordinate{9.7354, 52.4508}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenhagen Pferdemarkt station
    {Coordinate{8.32381, 48.8895}, Tz::Europe_Berlin, CountryId{"DE"}}, // Malsch station
    {Coordinate{12.4503, 52.8531}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835119
    {Coordinate{11.2274, 52.0307}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oschersleben
    {Coordinate{7.1629, 51.1691}, Tz::Europe_Berlin, CountryId{"DE"}}, // Remscheid-Güldenwerth station
    {Coordinate{8.11496, 49.8461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835127
    {Coordinate{13.3175, 52.9797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19835128
    {Coordinate{6.44639, 51.1381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheydt-Odenkirchen station
    {Coordinate{3.28832, 45.7845}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vertaizon
    {Coordinate{6.80819, 51.392}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg-Bissingheim station
    {Coordinate{6.7206, 45.9266}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1983989
    {Coordinate{3.00924, 50.7403}, Tz::Europe_Paris, CountryId{"FR"}}, // Sainte-Marguerite
    {Coordinate{10.5628, 50.8628}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reinhardsbrunn-Friedrichroda railway station
    {Coordinate{9.59053, 54.3926}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19850738
    {Coordinate{9.85188, 54.1671}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nortorf station
    {Coordinate{34.6333, 47.5019}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Enerhodar
    {Coordinate{3.64179, 49.0791}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1985272
    {Coordinate{8.81849, 40.6321}, Tz::Europe_Rome, CountryId{"IT"}}, // Ardara railway station
    {Coordinate{8.68706, 40.0206}, Tz::Europe_Rome, CountryId{"IT"}}, // Bauladu-Milis railway station
    {Coordinate{8.76067, 40.4178}, Tz::Europe_Rome, CountryId{"IT"}}, // Bonorva railway station
    {Coordinate{16.9552, 46.2494}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyékényes railway station
    {Coordinate{5.0559, 50.3582}, Tz::Europe_Brussels, CountryId{"BE"}}, // Florée railway station
    {Coordinate{9.65182, 52.3232}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ronnenberg station
    {Coordinate{9.63528, 52.2981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weetzen station
    {Coordinate{-1.9513, 47.3587}, Tz::Europe_Paris, CountryId{"FR"}}, // Savenay
    {Coordinate{2.29417, 48.7022}, Tz::Europe_Paris, CountryId{"FR"}}, // Longjumeau
    {Coordinate{3.00763, 48.9982}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1987750
    {Coordinate{34.3441, 61.7842}, Tz::Europe_Moscow, CountryId{"RU"}}, // Railway station Petrozavodsk
    {Coordinate{9.4037, 40.8377}, Tz::Europe_Rome, CountryId{"IT"}}, // Su Canale railway station
    {Coordinate{9.36734, 40.8309}, Tz::Europe_Rome, CountryId{"IT"}}, // Chirialza railway station
    {Coordinate{24.3528, 56.8606}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19886198
    {Coordinate{}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19886202
    {Coordinate{3.0754, 50.612}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lille-Porte-de-Douai
    {Coordinate{5.16823, 46.1306}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1989588
    {Coordinate{26.0597, 56.5403}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19896844
    {Coordinate{23.6778, 56.4089}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19896848
    {Coordinate{26.252, 56.5421}, Tz::Europe_Riga, CountryId{"LV"}}, // Mežāre railway station
    {Coordinate{26.6368, 56.5659}, Tz::Europe_Riga, CountryId{"LV"}}, // Q19896854
    {Coordinate{35.015, 48.4772}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dnipro Railway station
    {Coordinate{13.4006, 50.4572}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q1989836
    {Coordinate{16.3855, 48.2419}, Tz::Europe_Vienna, CountryId{"AT"}}, // Handelskai (Vienna U-Bahn)
    {Coordinate{5.57556, 52.2653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Putten railway station
    {Coordinate{2.06972, 48.7025}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Rémy-lès-Chevreuse
    {Coordinate{2.78139, 50.2869}, Tz::Europe_Paris, CountryId{"FR"}}, // Arras railway station
    {Coordinate{36.9003, 55.389}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q19906684
    {Coordinate{36.9099, 55.3791}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q19906689
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19906707
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19906710
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19906716
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19906742
    {Coordinate{60.6325, 56.8425}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19907082
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19907909
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19907914
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19908034
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19908213
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Dzhida railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19909285
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19909318
    {Coordinate{49.6014, 54.2261}, Tz::Europe_Ulyanovsk, CountryId{"RU"}}, // Q19909393
    {Coordinate{56.0783, 54.9258}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19909402
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19909419
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Port Kavkaz railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19909786
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19909810
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910061
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910124
    {Coordinate{107.497, 52.011}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q19910167
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910202
    {Coordinate{106.102, 50.3883}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Naushki railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910321
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910405
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910451
    {Coordinate{47.6467, 56.7758}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q19910454
    {Coordinate{131.9, 43.5142}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // Q19910463
    {Coordinate{131.951, 43.4508}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // 9230 km
    {Coordinate{131.951, 43.4414}, Tz::Asia_Vladivostok, CountryId{"RU"}}, // 9232 km
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910626
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910677
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910696
    {Coordinate{29.4306, 60.1725}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q19910802
    {Coordinate{28.63, 60.3653}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q19910809
    {Coordinate{59.9258, 56.8119}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19910901
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19910989
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Ryazanovka
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19911141
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19911145
    {Coordinate{35.7728, 45.2992}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q19911172
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19911257
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19911279
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19911370
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Tabashino
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19915880
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19915886
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916062
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916091
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Khuzhir railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916711
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916768
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916827
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916840
    {Coordinate{107.435, 52.1393}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q19916854
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19916882
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19917111
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q19917149
    {Coordinate{55.9631, 54.5578}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q19917179
    {Coordinate{4.61276, 50.6383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mont-Saint-Guibert railway station
    {Coordinate{4.82556, 45.7483}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Perrache
    {Coordinate{5.59776, 46.7628}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1992498
    {Coordinate{6.67698, 51.3978}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Rumeln
    {Coordinate{9.16944, 48.6919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Echterdingen station
    {Coordinate{18.9944, 51.5894}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zduńska Wola Karsznice
    {Coordinate{0.9325, 44.1019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pommevic
    {Coordinate{5.29247, 50.0196}, Tz::Europe_Brussels, CountryId{"BE"}}, // Poix-Saint-Hubert railway station
    {Coordinate{4.77365, 51.0373}, Tz::Europe_Brussels, CountryId{"BE"}}, // Booischot railway station
    {Coordinate{9.17937, 40.9239}, Tz::Europe_Rome, CountryId{"IT"}}, // Luras train station
    {Coordinate{0.421255, 46.7039}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1995058
    {Coordinate{18.1495, 46.37}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dombóvár railway station
    {Coordinate{4.06417, 51.0151}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oudegem railway station
    {Coordinate{18.8941, 47.6259}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szabadságliget railway station
    {Coordinate{18.8525, 47.6302}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pázmáneum railway station
    {Coordinate{18.8463, 47.6377}, Tz::Europe_Budapest, CountryId{"HU"}}, // Klotildliget railway station
    {Coordinate{18.8299, 47.6382}, Tz::Europe_Budapest, CountryId{"HU"}}, // Piliscsaba railway station
    {Coordinate{18.8184, 47.6478}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magdolnavölgy railway station
    {Coordinate{18.9022, 47.6142}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pilisvörösvár railway station
    {Coordinate{18.7964, 47.6562}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pilisjászfalu railway station
    {Coordinate{18.7913, 47.6739}, Tz::Europe_Budapest, CountryId{"HU"}}, // Piliscsév railway station
    {Coordinate{18.7719, 47.688}, Tz::Europe_Budapest, CountryId{"HU"}}, // Leányvár railway station
    {Coordinate{18.7329, 47.7233}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dorog railway station
    {Coordinate{18.7177, 47.7429}, Tz::Europe_Budapest, CountryId{"HU"}}, // Esztergom-Kertváros railway station
    {Coordinate{18.7445, 47.7756}, Tz::Europe_Budapest, CountryId{"HU"}}, // Esztergom railway station
    {Coordinate{14.0828, 52.7628}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Altranft
    {Coordinate{14.14, 52.7158}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wriezen station
    {Coordinate{6.70121, 45.9066}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Gervais-les-Bains-Le Fayet
    {Coordinate{6.94814, 51.7512}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19965709
    {Coordinate{6.9062, 51.8092}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q19971789
    {Coordinate{-0.882882, 48.8463}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vire
    {Coordinate{-1.59639, 48.0469}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1998060
    {Coordinate{6.80743, 48.206}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1998882
    {Coordinate{5.37548, 45.5611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1998901
    {Coordinate{1.87558, 48.8594}, Tz::Europe_Paris, CountryId{"FR"}}, // Q1999027
    {Coordinate{7.49314, 43.7748}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Menton
    {Coordinate{2.43528, 48.7717}, Tz::Europe_Paris, CountryId{"FR"}}, // Créteil-Pompadour (Paris RER)
    {Coordinate{13.5987, 42.8505}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20008429
    {Coordinate{9.58761, 41.0107}, Tz::Europe_Rome, CountryId{"IT"}}, // Cala Sabina railway station
    {Coordinate{9.43107, 40.8571}, Tz::Europe_Rome, CountryId{"IT"}}, // Enas railway station
    {Coordinate{9.04604, 40.672}, Tz::Europe_Rome, CountryId{"IT"}}, // Madonna di Castro railway station
    {Coordinate{10.723, 44.8457}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009260
    {Coordinate{8.98649, 40.6274}, Tz::Europe_Rome, CountryId{"IT"}}, // Ozieri-Fraigas railway station
    {Coordinate{9.53111, 40.9941}, Tz::Europe_Rome, CountryId{"IT"}}, // Rudalza railway station
    {Coordinate{16.2074, 38.1757}, Tz::Europe_Rome, CountryId{"IT"}}, // Ardore railway station
    {Coordinate{8.01835, 45.19}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009382
    {Coordinate{8.52063, 45.0871}, Tz::Europe_Rome, CountryId{"IT"}}, // Borgo San Martino railway station
    {Coordinate{15.9239, 37.9303}, Tz::Europe_Rome, CountryId{"IT"}}, // Bova Marina railway station
    {Coordinate{8.44053, 45.1604}, Tz::Europe_Rome, CountryId{"IT"}}, // Casale Popolo railway station
    {Coordinate{16.8908, 40.4292}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellaneta Marina railway station
    {Coordinate{8.70356, 45.0766}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellaro railway halt
    {Coordinate{15.8749, 37.9277}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009393
    {Coordinate{8.10717, 45.1942}, Tz::Europe_Rome, CountryId{"IT"}}, // Crescentino railway station
    {Coordinate{16.1345, 38.0163}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009398
    {Coordinate{8.18873, 45.1912}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009400
    {Coordinate{14.2878, 42.4214}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009402
    {Coordinate{8.56095, 45.0561}, Tz::Europe_Rome, CountryId{"IT"}}, // Giarole railway station
    {Coordinate{16.8908, 40.4292}, Tz::Europe_Rome, CountryId{"IT"}}, // Ginosa railway station
    {Coordinate{12.5545, 45.7844}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009406
    {Coordinate{12.0134, 44.8041}, Tz::Europe_Rome, CountryId{"IT"}}, // Massafiscaglia railway station
    {Coordinate{11.9385, 44.7693}, Tz::Europe_Rome, CountryId{"IT"}}, // Migliarino railway station
    {Coordinate{11.975, 44.7951}, Tz::Europe_Rome, CountryId{"IT"}}, // Migliaro railway station
    {Coordinate{12.6972, 43.9774}, Tz::Europe_Rome, CountryId{"IT"}}, // Misano Adriatico railway station
    {Coordinate{13.6463, 43.2893}, Tz::Europe_Rome, CountryId{"IT"}}, // Montecosaro railway station
    {Coordinate{8.36619, 45.1707}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009420
    {Coordinate{13.5828, 43.2792}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009421
    {Coordinate{8.12018, 44.7228}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009422
    {Coordinate{8.23281, 45.189}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009427
    {Coordinate{15.9864, 37.9188}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009428
    {Coordinate{8.42675, 45.2333}, Tz::Europe_Rome, CountryId{"IT"}}, // Pertengo railway station
    {Coordinate{8.72806, 40.6613}, Tz::Europe_Rome, CountryId{"IT"}}, // Ploaghe railway station
    {Coordinate{12.4605, 45.7193}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009436
    {Coordinate{15.6517, 38.0672}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio di Calabria Aeroporto railway station
    {Coordinate{15.6386, 38.0057}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009443
    {Coordinate{15.651, 38.0587}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009445
    {Coordinate{16.6156, 40.1001}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009447
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Ronchi dei Legionari Sud railway station
    {Coordinate{12.3774, 45.6867}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009451
    {Coordinate{8.95603, 40.8692}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009457
    {Coordinate{13.8758, 41.1961}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009461
    {Coordinate{7.96952, 45.1931}, Tz::Europe_Rome, CountryId{"IT"}}, // Verolengo railway station
    {Coordinate{14.7278, 40.6742}, Tz::Europe_Rome, CountryId{"IT"}}, // Vietri sul Mare-Amalfi railway station
    {Coordinate{13.3955, 45.8132}, Tz::Europe_Rome, CountryId{"IT"}}, // Villa Vicentina railway station
    {Coordinate{10.698, 44.8058}, Tz::Europe_Rome, CountryId{"IT"}}, // Vezzola railway halt
    {Coordinate{16.3308, 38.3001}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009822
    {Coordinate{14.0687, 42.6077}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009824
    {Coordinate{14.0413, 42.6424}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009826
    {Coordinate{14.3397, 42.3939}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009827
    {Coordinate{16.144, 38.0527}, Tz::Europe_Rome, CountryId{"IT"}}, // Africo Nuovo railway station
    {Coordinate{16.5676, 38.5722}, Tz::Europe_Rome, CountryId{"IT"}}, // Badolato railway station
    {Coordinate{16.1532, 38.0891}, Tz::Europe_Rome, CountryId{"IT"}}, // Bianco railway station
    {Coordinate{8.80953, 40.2189}, Tz::Europe_Rome, CountryId{"IT"}}, // Borore train station
    {Coordinate{16.1806, 38.1491}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009909
    {Coordinate{16.1033, 37.9654}, Tz::Europe_Rome, CountryId{"IT"}}, // Brancaleone train station
    {Coordinate{13.0575, 43.2104}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009918
    {Coordinate{15.1329, 37.9013}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009948
    {Coordinate{15.66, 37.977}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009963
    {Coordinate{16.2648, 38.2332}, Tz::Europe_Rome, CountryId{"IT"}}, // Locri railway station
    {Coordinate{16.5977, 40.0408}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009982
    {Coordinate{16.5418, 38.7286}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009984
    {Coordinate{8.87589, 40.5559}, Tz::Europe_Rome, CountryId{"IT"}}, // Mores-Ittireddu railway station
    {Coordinate{16.6029, 39.9338}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20009991
    {Coordinate{8.74101, 39.6112}, Tz::Europe_Rome, CountryId{"IT"}}, // Pabillonis railway station
    {Coordinate{8.77582, 40.0773}, Tz::Europe_Rome, CountryId{"IT"}}, // Paulilatino railway station
    {Coordinate{15.7108, 37.9387}, Tz::Europe_Rome, CountryId{"IT"}}, // Saline di Reggio train station
    {Coordinate{16.302, 38.2708}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010034
    {Coordinate{8.6798, 39.9525}, Tz::Europe_Rome, CountryId{"IT"}}, // Solarussa railway station
    {Coordinate{12.6688, 42.9844}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010042
    {Coordinate{8.78162, 40.4827}, Tz::Europe_Rome, CountryId{"IT"}}, // Torralba railway station
    {Coordinate{16.5321, 39.8656}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010060
    {Coordinate{8.69631, 39.6926}, Tz::Europe_Rome, CountryId{"IT"}}, // Uras-Mogoro railway station
    {Coordinate{16.4906, 39.8105}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20010074
    {Coordinate{16.4794, 39.7906}, Tz::Europe_Rome, CountryId{"IT"}}, // Villapiana-Torre Cerchiara railway station
    {Coordinate{8.28278, 47.0706}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q20012446
    {Coordinate{6.62655, 46.5072}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ouchy station
    {Coordinate{7.79211, 47.5512}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q20020599
    {Coordinate{10.3827, 53.8054}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Oldesloe railway station
    {Coordinate{3.03161, 49.0217}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2002635
    {Coordinate{2.03517, 50.3783}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2002851
    {Coordinate{5.7875, 51.4561}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deurne railway station
    {Coordinate{2.88891, 48.6137}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mormant
    {Coordinate{6.77167, 45.6181}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourg-Saint-Maurice
    {Coordinate{2.39, 48.9761}, Tz::Europe_Paris, CountryId{"FR"}}, // Garges – Sarcelles
    {Coordinate{-1.10013, 49.1169}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Lô
    {Coordinate{-0.145023, 44.5803}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Caudrot
    {Coordinate{6.36965, 49.473}, Tz::Europe_Berlin, CountryId{"DE"}}, // Perl railway station
    {Coordinate{2.60222, 48.9528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villeparisis – Mitry-le-Neuf
    {Coordinate{-8.50094, 40.9094}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Arrifana railway halt
    {Coordinate{-8.53738, 40.9395}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Cavaco railway halt
    {Coordinate{-8.49422, 40.8681}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Couto de Cucujães railway halt
    {Coordinate{-8.45322, 40.6133}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Aguieira railway halt
    {Coordinate{-8.59188, 40.6399}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Azurva railway halt
    {Coordinate{-8.49807, 40.5872}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Cabanões railway halt
    {Coordinate{-8.45292, 40.6354}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Carvalhal da Portela railway halt
    {Coordinate{-8.61802, 40.6415}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Esgueira railway halt
    {Coordinate{-8.46016, 40.6053}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Mourisca do Vouga railway halt
    {Coordinate{-8.47673, 40.5722}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Oronhe railway halt
    {Coordinate{-8.54801, 40.6222}, Tz::Europe_Lisbon, CountryId{"PT"}}, // São João de Loure railway halt
    {Coordinate{-8.52437, 40.6011}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Taipa - Requeixo railway halt
    {Coordinate{-8.51444, 40.5942}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Travassô railway halt
    {Coordinate{-8.44995, 40.6242}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Valongo do Vouga railway halt
    {Coordinate{-8.51645, 40.9196}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Escapães railway halt
    {Coordinate{-8.60521, 40.9837}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Lapa railway halt
    {Coordinate{-8.62551, 40.9823}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Monte de Paramos railway halt
    {Coordinate{-8.57122, 40.9609}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Rio Meão railway halt
    {Coordinate{-8.59335, 40.984}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Sampaio - Oleiros railway halt
    {Coordinate{-8.53098, 40.9267}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Sanfins railway halt
    {Coordinate{-8.55116, 40.9555}, Tz::Europe_Lisbon, CountryId{"PT"}}, // São João de Ver railway halt
    {Coordinate{-8.63036, 40.9888}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Silvalde-Vouga railway halt
    {Coordinate{-8.48792, 40.5794}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Casal de Álvaro railway halt
    {Coordinate{-8.64353, 41.0022}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Espinho-Vouga railway station
    {Coordinate{-8.53161, 40.6095}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Eirol railway station
    {Coordinate{-8.56816, 40.6311}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Eixo railway station
    {Coordinate{-8.58451, 40.972}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Paços de Brandão railway station
    {Coordinate{-8.49513, 40.8986}, Tz::Europe_Lisbon, CountryId{"PT"}}, // São João da Madeira railway station
    {Coordinate{18.7614, 47.1395}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztaszabolcs railway station
    {Coordinate{-8.49493, 40.8792}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Faria railway halt
    {Coordinate{-8.4896, 40.8513}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Santiago de Riba - Ul railway halt
    {Coordinate{-8.45831, 40.6532}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Macinhata do Vouga railway station
    {Coordinate{-8.48168, 40.8402}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Oliveira de Azeméis railway station
    {Coordinate{-8.53556, 40.9242}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Vila da Feira railway station
    {Coordinate{4.24441, 50.8662}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dilbeek railway station
    {Coordinate{1.76804, 47.2948}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2006291
    {Coordinate{2.32623, 49.1552}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2006647
    {Coordinate{4.32389, 52.0811}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Centraal
    {Coordinate{33.0897, 46.9431}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lvivski Otruby
    {Coordinate{33.5313, 48.0518}, Tz::Europe_Kiev, CountryId{"UA"}}, // 54 km
    {Coordinate{32.6077, 51.0285}, Tz::Europe_Kiev, CountryId{"UA"}}, // 684 km
    {Coordinate{34.1603, 47.6182}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20071999
    {Coordinate{36.054, 49.8391}, Tz::Europe_Kiev, CountryId{"UA"}}, // Artemivka
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q20072984
    {Coordinate{36.7708, 46.7942}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20073062
    {Coordinate{36.8039, 46.751}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20073063
    {Coordinate{25.605, 49.4908}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20073102
    {Coordinate{31.3797, 48.19}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20073147
    {Coordinate{36.4011, 46.9486}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20073318
    {Coordinate{108.509, 51.7197}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Ilka station
    {Coordinate{3.25557, 50.9137}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ingelmunster railway station
    {Coordinate{32.1659, 48.0957}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20073774
    {Coordinate{34.2717, 45.774}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q20073795
    {Coordinate{24.1947, 49.0008}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20073948
    {Coordinate{35.3297, 47.3583}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20074179
    {Coordinate{36.49, 47.2652}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Bilmanka
    {Coordinate{34.0597, 46.8564}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20074359
    {Coordinate{35.7189, 47.2336}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20074370
    {Coordinate{36.3, 47.2203}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20074505
    {Coordinate{29.832, 49.2606}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vysoke
    {Coordinate{36.1267, 47.8272}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20075375
    {Coordinate{25.125, 48.5503}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20075439
    {Coordinate{25.4768, 48.682}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20075841
    {Coordinate{29.8915, 49.2362}, Tz::Europe_Kiev, CountryId{"UA"}}, // Horoshkiv
    {Coordinate{37.3539, 49.666}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20075959
    {Coordinate{36.1656, 47.6478}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20076019
    {Coordinate{36.3736, 47.4694}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20076027
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q20076031
    {Coordinate{}, Timezone{}, CountryId{"MN"}}, // Darkhan I railway station
    {Coordinate{24.6167, 48.5167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20076155
    {Coordinate{}, Timezone{}, CountryId{"MN"}}, // Q20076295
    {Coordinate{35.0256, 47.81}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Dniprobud 2
    {Coordinate{32.7939, 46.6792}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dniprovska
    {Coordinate{34.9614, 47.1744}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20076374
    {Coordinate{29.5279, 49.3927}, Tz::Europe_Kiev, CountryId{"UA"}}, // Drutska
    {Coordinate{32.9119, 46.5894}, Tz::Europe_Kiev, CountryId{"UA"}}, // Express
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q20076935
    {Coordinate{25.7385, 48.6454}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zalishchyky
    {Coordinate{37.1978, 47.47}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20077093
    {Coordinate{108.277, 51.8406}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Zaigraevo station
    {Coordinate{2.17056, 49.2042}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Esches
    {Coordinate{32.73, 46.8892}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20077285
    {Coordinate{35.2489, 47.6531}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20077473
    {Coordinate{35.0289, 47.3825}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20077572
    {Coordinate{36.335, 47.33}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20077651
    {Coordinate{35.4672, 47.8072}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Kyrpotyne
    {Coordinate{25.06, 48.5344}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20077869
    {Coordinate{29.9407, 49.2249}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kryvchunka
    {Coordinate{31.5252, 48.1179}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20078340
    {Coordinate{4.85944, 45.7606}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Part-Dieu
    {Coordinate{108.883, 51.4569}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Kizha station
    {Coordinate{35.3555, 47.8092}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20081561
    {Coordinate{36.5119, 47.4311}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20081859
    {Coordinate{34.9806, 47.2553}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20081910
    {Coordinate{35.9144, 47.5275}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20081911
    {Coordinate{37.2217, 48.4228}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20082172
    {Coordinate{35.6133, 47.2017}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20082386
    {Coordinate{29.4287, 49.4075}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nakaznyi Post
    {Coordinate{36.163, 47.2137}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20082883
    {Coordinate{34.8803, 47.0247}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20082942
    {Coordinate{36.0433, 47.5092}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20082979
    {Coordinate{31.5161, 48.3327}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20083082
    {Coordinate{108.701, 51.6764}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Novoilinsky station
    {Coordinate{33.935, 46.8417}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20083101
    {Coordinate{35.6606, 47.6692}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20083186
    {Coordinate{35.325, 46.9333}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Obilna
    {Coordinate{35.7883, 47.5594}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20083381
    {Coordinate{31.8861, 48.1025}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20083386
    {Coordinate{34.7497, 46.3297}, Tz::Europe_Kiev, CountryId{"UA"}}, // Partyzany
    {Coordinate{34.1616, 45.8303}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q20091077
    {Coordinate{35.2239, 47.8189}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Peredatna
    {Coordinate{35.3275, 47.5661}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20091313
    {Coordinate{28.89, 49.7345}, Tz::Europe_Kiev, CountryId{"UA"}}, // Planovyi
    {Coordinate{35.3119, 47.1656}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20091341
    {Coordinate{32.8158, 46.6436}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20091442
    {Coordinate{35.325, 47.2589}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20091902
    {Coordinate{24.2089, 48.0547}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Rakhiv station
    {Coordinate{28.2647, 45.4586}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20092356
    {Coordinate{29.3577, 49.4238}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozkopane
    {Coordinate{37.0647, 47.3744}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20092484
    {Coordinate{29.0131, 49.7022}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20092519
    {Coordinate{35.2831, 47.8089}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20092520
    {Coordinate{29.3046, 49.5253}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ros'
    {Coordinate{33.9819, 49.7296}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sahaidak
    {Coordinate{28.9575, 49.7185}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sadovyi
    {Coordinate{35.5072, 47.0772}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20092823
    {Coordinate{32.5359, 48.1253}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20092842
    {Coordinate{36.3153, 47.275}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20093005
    {Coordinate{34.9478, 46.4994}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sokolohirne
    {Coordinate{32.7008, 46.8047}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20093229
    {Coordinate{32.4352, 50.2857}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20093245
    {Coordinate{29.2547, 49.5868}, Tz::Europe_Kiev, CountryId{"UA"}}, // Staroustyntsi
    {Coordinate{25.6875, 48.6183}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20093594
    {Coordinate{36.0178, 47.2125}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20093678
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q20093718
    {Coordinate{34.6066, 49.5993}, Tz::Europe_Kiev, CountryId{"UA"}}, // Skhidny
    {Coordinate{107.783, 51.8478}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Taltsy station
    {Coordinate{32.6825, 46.7436}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20093910
    {Coordinate{35.01, 47.0328}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20095877
    {Coordinate{35.5345, 47.7241}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20095951
    {Coordinate{37.4103, 47.4864}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20095981
    {Coordinate{25.7889, 49.0272}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chortkiv
    {Coordinate{34.1256, 47.62}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20096147
    {Coordinate{36.595, 47.3092}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20096199
    {Coordinate{24.5525, 48.4822}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q20096233
    {Coordinate{36.1314, 47.4936}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q20096255
    {Coordinate{32.5198, 48.7486}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chornoliska
    {Coordinate{24.3539, 48.2562}, Tz::Europe_Uzhgorod, CountryId{"UA"}}, // Yasinia
    {Coordinate{31.025, 49.6229}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yakhny
    {Coordinate{5.65923, 47.1502}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2009927
    {Coordinate{2.73472, 48.1819}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Souppes–Château-Landon
    {Coordinate{3.44282, 49.9884}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2010433
    {Coordinate{5.3031, 46.0957}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2010435
    {Coordinate{3.80002, 50.6144}, Tz::Europe_Brussels, CountryId{"BE"}}, // Maffle railway station
    {Coordinate{5.32581, 46.1834}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ceyzériat
    {Coordinate{4.80378, 45.7801}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Vaise
    {Coordinate{2.21139, 48.7058}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lozère
    {Coordinate{5.94377, 46.6546}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2011910
    {Coordinate{}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sterpenich railway station
    {Coordinate{6.23351, 47.299}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2012830
    {Coordinate{4.97833, 49.9844}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gedinne railway station
    {Coordinate{2.03835, 42.4912}, Tz::Europe_Paris, CountryId{"FR"}}, // Font-Romeu-Odeillo-Via train station
    {Coordinate{3.64583, 50.2503}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Quesnoy
    {Coordinate{1.84578, 48.9922}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2014665
    {Coordinate{2.0775, 48.97}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Achères – Ville
    {Coordinate{-0.713757, 48.1092}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2014983
    {Coordinate{4.82695, 45.766}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Saint-Paul
    {Coordinate{2.97194, 42.6011}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Elne
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q20160499
    {Coordinate{1.08934, 43.6172}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2016061
    {Coordinate{6.27401, 51.0331}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hückelhoven-Baal station
    {Coordinate{15.2777, 41.2419}, Tz::Europe_Rome, CountryId{"IT"}}, // Orsara di Puglia railway station
    {Coordinate{6.25722, 51.8342}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emmerich station
    {Coordinate{13.1411, 54.3228}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altefähr railway station
    {Coordinate{8.33863, 48.9648}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q20170857
    {Coordinate{1.85717, 48.9092}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2018357
    {Coordinate{7.89989, 49.9013}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenlonsheim station
    {Coordinate{13.1124, 52.5349}, Tz::Europe_Berlin, CountryId{"DE"}}, // Löwenberg (Mark) railway station
    {Coordinate{13.7385, 52.6375}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werneuchen station
    {Coordinate{7.59238, 50.8072}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schladern station
    {Coordinate{3.00985, 50.7609}, Tz::Europe_Paris, CountryId{"FR"}}, // Comines
    {Coordinate{2.22297, 43.0564}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Limoux
    {Coordinate{1.54619, 47.2818}, Tz::Europe_Paris, CountryId{"FR"}}, // Selles-sur-Cher station
    {Coordinate{7.41289, 51.5192}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Wischlingen station
    {Coordinate{1.97055, 50.3946}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2022268
    {Coordinate{7.58411, 48.3736}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Benfeld
    {Coordinate{2.15999, 42.5064}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2022900
    {Coordinate{4.72321, 50.0828}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2022973
    {Coordinate{-1.66102, 43.3857}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Jean-de-Luz-Ciboure
    {Coordinate{30.2585, 58.3485}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q20233905
    {Coordinate{-0.0982976, 48.9236}, Tz::Europe_Paris, CountryId{"FR"}}, // Coulibœuf
    {Coordinate{36.2043, 49.9896}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kharkiv-Pasazhyrskiy
    {Coordinate{5.71778, 50.8708}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maastricht Noord railway station
    {Coordinate{6.70125, 47.7032}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2024940
    {Coordinate{4.81969, 44.1375}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2025211
    {Coordinate{19.4297, 51.7581}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Łódź Kaliska railway station
    {Coordinate{5.39746, 50.6642}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fexhe-le-Haut-Clocher railway station
    {Coordinate{4.53332, 50.7114}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rixensart railway station
    {Coordinate{3.22993, 49.2726}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2027393
    {Coordinate{5.44124, 43.2905}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2027721
    {Coordinate{39.6908, 47.2184}, Tz::Europe_Moscow, CountryId{"RU"}}, // Rostov-Glavny
    {Coordinate{7.15583, 52.3097}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Bentheim station
    {Coordinate{3.46528, 43.3175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Agde
    {Coordinate{13.5814, 51.9156}, Tz::Europe_Berlin, CountryId{"DE"}}, // Drahnsdorf railway station
    {Coordinate{2.68039, 49.0083}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thieux - Nantouillet
    {Coordinate{4.505, 50.8831}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nossegem railway station
    {Coordinate{4.53097, 52.3758}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zandvoort aan Zee railway station
    {Coordinate{3.65598, 49.6308}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2029724
    {Coordinate{7.22456, 47.781}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Graffenwald
    {Coordinate{6.31944, 51.5131}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2030582
    {Coordinate{0.33329, 46.5203}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2030786
    {Coordinate{26.0425, 53.1292}, Tz::Europe_Minsk, CountryId{"BY"}}, // Baranavichy-Palyeskiya
    {Coordinate{2.23056, 49.0214}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vaucelles
    {Coordinate{24.2181, 59.3246}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2031564
    {Coordinate{3.29716, 49.8397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Quentin
    {Coordinate{3.48933, 50.3317}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2031918
    {Coordinate{8.44604, 47.2759}, Tz::Europe_Zurich, CountryId{"CH"}}, // Affoltern am Albis railway station
    {Coordinate{8.79227, 47.317}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wetzikon railway station
    {Coordinate{4.54372, 50.4821}, Tz::Europe_Brussels, CountryId{"BE"}}, // Fleurus railway station
    {Coordinate{8.68662, 47.3691}, Tz::Europe_Zurich, CountryId{"CH"}}, // Nänikon-Greifensee railway station
    {Coordinate{6.20641, 45.5576}, Tz::Europe_Paris, CountryId{"FR"}}, // Chamousset
    {Coordinate{5.78444, 52.3708}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nunspeet railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q2034917
    {Coordinate{25.9938, 53.1323}, Tz::Europe_Minsk, CountryId{"BY"}}, // Baranavichy-Tsentral′nyya
    {Coordinate{2.32278, 49.0453}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bouffémont - Moisselles
    {Coordinate{5.3425, 45.9539}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ambérieu
    {Coordinate{9.14361, 49.9803}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aschaffenburg Central Station
    {Coordinate{4.47194, 50.9781}, Tz::Europe_Brussels, CountryId{"BE"}}, // Weerde railway station
    {Coordinate{7.38738, 51.508}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Marten Süd station
    {Coordinate{4.60194, 45.8118}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sain-Bel
    {Coordinate{7.3273, 51.3195}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gevelsberg-Kipp station
    {Coordinate{1.3892, 48.4382}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2040993
    {Coordinate{5.64415, 46.8233}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2041345
    {Coordinate{2.59889, 49.965}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2041436
    {Coordinate{2.4075, 48.6361}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2041479
    {Coordinate{5.53944, 43.6439}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2041563
    {Coordinate{4.11944, 51.9817}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoek van Holland Strand railway station
    {Coordinate{27.8, 47.2035}, Tz::Europe_Chisinau, CountryId{"MD"}}, // Q20429826
    {Coordinate{6.1025, 52.0447}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dieren railway station
    {Coordinate{2.24902, 42.529}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2043100
    {Coordinate{5.80951, 49.6803}, Tz::Europe_Brussels, CountryId{"BE"}}, // Arlon railway station
    {Coordinate{3.97305, 49.4081}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2043286
    {Coordinate{6.12167, 45.9022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Annecy
    {Coordinate{4.43892, 50.4043}, Tz::Europe_Brussels, CountryId{"BE"}}, // Charleroi-South railway station
    {Coordinate{12.9122, 38.0244}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellammare del Golfo railway station
    {Coordinate{13.0969, 38.1553}, Tz::Europe_Rome, CountryId{"IT"}}, // Cinisi-Terrasini railway station
    {Coordinate{13.0369, 38.0653}, Tz::Europe_Rome, CountryId{"IT"}}, // Trappeto railway station
    {Coordinate{13.0074, 38.0533}, Tz::Europe_Rome, CountryId{"IT"}}, // Balestrate railway station
    {Coordinate{13.109, 38.0585}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20439873
    {Coordinate{4.08455, 49.9144}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2044263
    {Coordinate{5.44077, 50.284}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melreux-Hotton railway station
    {Coordinate{-2.09722, 47.1144}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pornic
    {Coordinate{4.38306, 51.9225}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schiedam Nieuwland railway station
    {Coordinate{2.42639, 48.7394}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villeneuve-le-Roi
    {Coordinate{-0.1918, 51.5473}, Tz::Europe_London, CountryId{"GB"}}, // West Hampstead railway station
    {Coordinate{5.28111, 52.2081}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Baarn railway station
    {Coordinate{0.913333, 43.1189}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lestelle
    {Coordinate{4.46718, 48.2402}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2046189
    {Coordinate{6.92047, 46.0191}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Buet (Vallorcine)
    {Coordinate{1.38889, 43.5278}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Portet-Saint-Simon
    {Coordinate{7.05861, 46.0867}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2047644
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Schwarzach-St. Veit
    {Coordinate{3.28733, 48.5456}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Champbenoist-Poigny
    {Coordinate{3.91002, 50.5302}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jurbise railway station
    {Coordinate{2.51444, 48.9736}, Tz::Europe_Paris, CountryId{"FR"}}, // Parc des Expositions
    {Coordinate{2.46083, 48.5931}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2048752
    {Coordinate{5.50095, 45.9228}, Tz::Europe_Paris, CountryId{"FR"}}, // Tenay - Hauteville
    {Coordinate{21.2975, 52.2408}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Sulejówek Miłosna train station
    {Coordinate{2.14667, 48.7708}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2050729
    {Coordinate{2.35278, 49.8642}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longueau
    {Coordinate{2.5107, 50.6814}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2051204
    {Coordinate{17.8184, 40.6502}, Tz::Europe_Rome, CountryId{"IT"}}, // San Vito dei Normanni railway station
    {Coordinate{6.19685, 50.8558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf Poststraße station
    {Coordinate{6.58165, 48.0458}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2051806
    {Coordinate{4.26167, 50.3461}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lobbes railway station
    {Coordinate{6.133, 47.2841}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2051959
    {Coordinate{6.34225, 47.1498}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2052258
    {Coordinate{4.97861, 44.9917}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Valence TGV
    {Coordinate{6.21328, 46.8702}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2052516
    {Coordinate{4.76997, 45.4503}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Clair - Les Roches
    {Coordinate{4.575, 50.6908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Limal railway station
    {Coordinate{13.0397, 52.7539}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kremmen railway station
    {Coordinate{2.91755, 42.8355}, Tz::Europe_Paris, CountryId{"FR"}}, // Salses
    {Coordinate{2.0652, 45.4022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Égletons
    {Coordinate{6.75145, 48.1856}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2054652
    {Coordinate{6.41685, 46.0779}, Tz::Europe_Paris, CountryId{"FR"}}, // Bonneville
    {Coordinate{5.17583, 50.8172}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Truiden railway station
    {Coordinate{3.04359, 51.0251}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kortemark railway station
    {Coordinate{1.86283, 46.8826}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2055777
    {Coordinate{3.76689, 50.428}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hainin railway station
    {Coordinate{-0.924011, 53.7729}, Tz::Europe_London, CountryId{"GB"}}, // Wressle railway station
    {Coordinate{7.18537, 48.9406}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2057826
    {Coordinate{0.223626, 49.5637}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2058851
    {Coordinate{4.80479, 45.7661}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lyon-Gorge-de-Loup
    {Coordinate{3.98556, 50.9706}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lede railway station
    {Coordinate{31.2672, 51.4858}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chernihiv
    {Coordinate{30.3767, 54.5208}, Tz::Europe_Minsk, CountryId{"BY"}}, // Orsha-Tsentral′naya
    {Coordinate{4.37583, 50.6842}, Tz::Europe_Brussels, CountryId{"BE"}}, // Braine-l'Alleud railway station
    {Coordinate{2.3377, 48.9758}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Deuil - Montmagny
    {Coordinate{5.91011, 46.7494}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2060905
    {Coordinate{30.185, 55.1961}, Tz::Europe_Minsk, CountryId{"BY"}}, // Viciebsk station
    {Coordinate{9.36753, 53.6124}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hammah
    {Coordinate{9.16611, 53.6839}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hemmoor
    {Coordinate{9.31019, 53.6234}, Tz::Europe_Berlin, CountryId{"DE"}}, // Himmelpforten
    {Coordinate{6.88819, 50.9482}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Müngersdorf Technologiepark station
    {Coordinate{4.43599, 50.2591}, Tz::Europe_Brussels, CountryId{"BE"}}, // Walcourt railway station
    {Coordinate{3.01316, 42.9325}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2062228
    {Coordinate{34.0823, 44.9616}, Tz::Europe_Simferopol, CountryId{"RU"}}, // Simferopol Passenger.
    {Coordinate{2.57306, 48.5292}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2063001
    {Coordinate{20.8817, 51.1158}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Skarżysko-Kamienna
    {Coordinate{18.237, 40.1989}, Tz::Europe_Rome, CountryId{"IT"}}, // Zollino railway station
    {Coordinate{12.1845, 53.1461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pritzwalk station
    {Coordinate{12.8578, 52.0919}, Tz::Europe_Berlin, CountryId{"DE"}}, // Treuenbrietzen station
    {Coordinate{2.94121, 50.3164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2064695
    {Coordinate{4.63278, 52.4339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Santpoort Noord railway station
    {Coordinate{14.6458, 50.9864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eibau station
    {Coordinate{14.7267, 41.2859}, Tz::Europe_Rome, CountryId{"IT"}}, // Q20657363
    {Coordinate{5.83278, 50.8692}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Valkenburg railway station
    {Coordinate{6.41694, 52.5097}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ommen railway station
    {Coordinate{5.56861, 50.6983}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liers railway station
    {Coordinate{14.0074, 51.028}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dürrröhrsdorf station
    {Coordinate{10.6756, 44.7608}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagnolo in Piano railway station
    {Coordinate{43.3619, 51.8822}, Tz::Europe_Saratov, CountryId{"RU"}}, // Letyazhevka railway station
    {Coordinate{-2.29555, 47.6758}, Tz::Europe_Paris, CountryId{"FR"}}, // Malansac
    {Coordinate{6.77341, 51.4024}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg Schlenk station
    {Coordinate{4.8051, 52.4693}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaandijk Zaanse Schans railway station
    {Coordinate{25.8596, 56.5206}, Tz::Europe_Riga, CountryId{"LV"}}, // Krustpils Station
    {Coordinate{-3.27428, 48.4799}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2068634
    {Coordinate{5.70216, 45.0437}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2068835
    {Coordinate{1.95389, 49.5714}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marseille-en-Beauvaisis
    {Coordinate{30.9911, 52.4308}, Tz::Europe_Minsk, CountryId{"BY"}}, // Homyel′-Pasazhyrski
    {Coordinate{5.48028, 50.605}, Tz::Europe_Brussels, CountryId{"BE"}}, // Flémalle-Grande railway station
    {Coordinate{4.49306, 51.0914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Duffel railway station
    {Coordinate{5.08846, 43.639}, Tz::Europe_Paris, CountryId{"FR"}}, // Salon
    {Coordinate{6.07796, 49.0743}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2071376
    {Coordinate{7.16611, 51.9511}, Tz::Europe_Berlin, CountryId{"DE"}}, // Coesfeld Schulzentrum station
    {Coordinate{7.08889, 52.0347}, Tz::Europe_Berlin, CountryId{"DE"}}, // Legden station
    {Coordinate{7.1225, 51.9981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rosendahl-Holtwick station
    {Coordinate{-0.626062, 44.8272}, Tz::Europe_Paris, CountryId{"FR"}}, // Mérignac-Arlac
    {Coordinate{2.43778, 48.7464}, Tz::Europe_Paris, CountryId{"FR"}}, // Villeneuve-Triage
    {Coordinate{5.1, 45.6382}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2072293
    {Coordinate{3.29027, 48.1375}, Tz::Europe_Paris, CountryId{"FR"}}, // Étigny-Véron station
    {Coordinate{12.3743, 52.3852}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Wusterwitz
    {Coordinate{14.0301, 52.7873}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Bad Freienwalde (Oder)
    {Coordinate{4.49528, 51.1631}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boechout railway station
    {Coordinate{1.99, 49.7781}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Poix-de-Picardie
    {Coordinate{-0.501714, 46.0434}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2073351
    {Coordinate{4.86906, 50.3488}, Tz::Europe_Brussels, CountryId{"BE"}}, // Godinne railway station
    {Coordinate{7.16553, 48.4076}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2074825
    {Coordinate{9.27383, 51.492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q20754313
    {Coordinate{7.16998, 49.6056}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubrücke (Nahe) station
    {Coordinate{4.53306, 51.5875}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oudenbosch railway station
    {Coordinate{4.04234, 51.0731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zele railway station
    {Coordinate{1.35294, 43.6026}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Ramassiers
    {Coordinate{4.82435, 45.7068}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2076776
    {Coordinate{26.8393, 54.3162}, Tz::Europe_Minsk, CountryId{"BY"}}, // Maladzyechna
    {Coordinate{4.94796, 48.6426}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2077891
    {Coordinate{5.18722, 52.2164}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hilversum Sportpark railway station
    {Coordinate{6.37254, 47.8148}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2078765
    {Coordinate{27.4037, 59.3557}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q207883
    {Coordinate{5.17389, 52.2378}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hilversum Media Park railway station
    {Coordinate{4.69056, 50.5702}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gembloux railway station
    {Coordinate{3.11812, 50.5906}, Tz::Europe_Paris, CountryId{"FR"}}, // Lesquin
    {Coordinate{4.54374, 50.4241}, Tz::Europe_Brussels, CountryId{"BE"}}, // Campinaire railway station
    {Coordinate{5.28139, 51.0383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heusden railway station
    {Coordinate{5.44995, 45.5601}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2082423
    {Coordinate{13.1086, 51.2975}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oschatz station
    {Coordinate{6.04333, 50.7089}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hergenrath railway station
    {Coordinate{7.98806, 46.3194}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brig railway station
    {Coordinate{0.74977, 44.2875}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laroque-Timbaut
    {Coordinate{14.7088, 50.9661}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberoderwitz station
    {Coordinate{5.43855, 45.9474}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Rambert-en-Bugey
    {Coordinate{3.96016, 49.0465}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Épernay
    {Coordinate{4.12653, 50.4743}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bracquegnies railway station
    {Coordinate{4.76334, 49.8584}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bogny-sur-Meuse
    {Coordinate{1.61139, 43.1892}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Vernet-d'Ariège
    {Coordinate{11.1893, 47.3289}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Seefeld in Tirol
    {Coordinate{6.859, 45.9165}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2087709
    {Coordinate{0.971667, 44.0881}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Malause
    {Coordinate{1.48113, 48.4483}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chartres
    {Coordinate{4.58556, 50.8964}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erps-Kwerps railway station
    {Coordinate{4.17652, 50.6513}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hennuyères railway station
    {Coordinate{2.31417, 48.92}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Grésillons
    {Coordinate{4.26614, 50.7517}, Tz::Europe_Brussels, CountryId{"BE"}}, // Huizingen railway station
    {Coordinate{3.32919, 51.1282}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beernem railway station
    {Coordinate{5.8208, 47.0588}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2090314
    {Coordinate{5.92944, 50.8867}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voerendaal railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q20916960
    {Coordinate{4.97701, 45.8274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Maurice-de-Beynost
    {Coordinate{7.48899, 48.4621}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2092112
    {Coordinate{2.38639, 48.6761}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2092521
    {Coordinate{5.98194, 49.6386}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Capellen railway station
    {Coordinate{13.592, 50.983}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tharandt station
    {Coordinate{13.2932, 51.0609}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nossen station
    {Coordinate{30.6448, 50.4314}, Tz::Europe_Kiev, CountryId{"UA"}}, // Darnytsia
    {Coordinate{2.31778, 48.6853}, Tz::Europe_Paris, CountryId{"FR"}}, // Gravigny – Balizy Station
    {Coordinate{2.13686, 42.5009}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2093892
    {Coordinate{23.3208, 42.7122}, Tz::Europe_Sofia, CountryId{"BG"}}, // Sofia Central Station
    {Coordinate{1.87688, 47.2691}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2095460
    {Coordinate{4.365, 51.9906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delft Zuid railway station
    {Coordinate{3.83435, 50.5998}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mévergnies-Attre railway station
    {Coordinate{1.94334, 48.8318}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2096833
    {Coordinate{6.72387, 51.4018}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinhausen Ost station
    {Coordinate{8.65116, 44.751}, Tz::Europe_Rome, CountryId{"IT"}}, // Predosa railway station
    {Coordinate{8.58958, 44.8434}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellazzo-Casalcermelli railway station
    {Coordinate{8.65612, 44.6752}, Tz::Europe_Rome, CountryId{"IT"}}, // Roccagrimalda railway halt
    {Coordinate{8.64464, 44.6466}, Tz::Europe_Rome, CountryId{"IT"}}, // Ovada Nord railway station
    {Coordinate{7.88645, 45.3534}, Tz::Europe_Rome, CountryId{"IT"}}, // Mercenasco railway station
    {Coordinate{7.88796, 45.3825}, Tz::Europe_Rome, CountryId{"IT"}}, // Strambino railway station
    {Coordinate{7.87635, 45.4615}, Tz::Europe_Rome, CountryId{"IT"}}, // Ivrea railway station
    {Coordinate{7.89189, 45.3299}, Tz::Europe_Rome, CountryId{"IT"}}, // Candia Canavese railway station
    {Coordinate{7.90259, 45.3032}, Tz::Europe_Rome, CountryId{"IT"}}, // Caluso railway station
    {Coordinate{7.85836, 45.2327}, Tz::Europe_Rome, CountryId{"IT"}}, // Montanaro railway station
    {Coordinate{7.91418, 44.1502}, Tz::Europe_Rome, CountryId{"IT"}}, // Ormea railway station
    {Coordinate{7.99445, 44.1854}, Tz::Europe_Rome, CountryId{"IT"}}, // Trappa railway station
    {Coordinate{8.01653, 44.2006}, Tz::Europe_Rome, CountryId{"IT"}}, // Garessio railway station
    {Coordinate{8.0234, 44.2487}, Tz::Europe_Rome, CountryId{"IT"}}, // Priola railway station
    {Coordinate{8.02602, 44.2625}, Tz::Europe_Rome, CountryId{"IT"}}, // Pievetta railway station
    {Coordinate{8.04615, 44.3033}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagnasco railway halt
    {Coordinate{13.4742, 46.5098}, Tz::Europe_Rome, CountryId{"IT"}}, // Ugovizza railway station
    {Coordinate{15.7109, 38.2513}, Tz::Europe_Rome, CountryId{"IT"}}, // Scilla railway halt
    {Coordinate{15.8004, 38.2827}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagnara railway station
    {Coordinate{5.95131, 46.5748}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2097368
    {Coordinate{6.80833, 43.4164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2097781
    {Coordinate{13.6376, 50.9887}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freital-Hainsberg station
    {Coordinate{2.87667, 50.8478}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ieper railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // 133 km railway platform (October railway)
    {Coordinate{5.11859, 49.8953}, Tz::Europe_Brussels, CountryId{"BE"}}, // Paliseul railway station
    {Coordinate{12.1292, 50.4864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2098942
    {Coordinate{14.5789, 51.0044}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebersbach (Sachs) station
    {Coordinate{-1.30054, 43.4993}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Urt
    {Coordinate{2.69512, 48.4871}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2099787
    {Coordinate{2.51694, 50.505}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vis-à-Marles
    {Coordinate{2.56465, 50.5382}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2100569
    {Coordinate{4.39361, 50.8019}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boondael railway station
    {Coordinate{-0.241589, 43.1819}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Coarraze-Nay
    {Coordinate{8.53222, 51.1986}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21009598
    {Coordinate{1.01091, 48.4738}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2101016
    {Coordinate{8.8987, 53.8078}, Tz::Europe_Berlin, CountryId{"DE"}}, // Otterndorf
    {Coordinate{9.05832, 53.768}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cadenberge
    {Coordinate{9.22824, 53.6387}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hechthausen
    {Coordinate{9.09817, 53.7452}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wingst
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Siuro station area
    {Coordinate{4.94944, 52.3531}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Amsterdam Science Park railway station
    {Coordinate{7.44961, 51.3533}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagen-Wehringhausen station
    {Coordinate{-1.63432, 48.1814}, Tz::Europe_Paris, CountryId{"FR"}}, // Betton railway station
    {Coordinate{13.5009, 50.9259}, Tz::Europe_Berlin, CountryId{"DE"}}, // Klingenberg-Colmnitz station
    {Coordinate{6.4453, 51.6597}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21035431
    {Coordinate{14.2164, 52.5381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trebnitz
    {Coordinate{11.3221, 49.5204}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Neunkirchen a Sand
    {Coordinate{7.07861, 49.3692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21035438
    {Coordinate{7.84988, 47.7057}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zell (Wiesental) station
    {Coordinate{7.97028, 51.4381}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21035442
    {Coordinate{14.4803, 51.0424}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21036573
    {Coordinate{7.07466, 51.458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Kray Süd station
    {Coordinate{5.13056, 45.8514}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La-Valbonne
    {Coordinate{30.489, 50.4404}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kiev Passenger Railway Station
    {Coordinate{6.00222, 52.4536}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wezep railway station
    {Coordinate{-4.08604, 48.2543}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2105624
    {Coordinate{9.99105, 44.8929}, Tz::Europe_Rome, CountryId{"IT"}}, // Alseno railway station
    {Coordinate{2.32833, 48.9583}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Épinay-Villetaneuse
    {Coordinate{5.79343, 43.8231}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2106331
    {Coordinate{1.55349, 49.6138}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2106514
    {Coordinate{7.58667, 47.7897}, Tz::Europe_Berlin, CountryId{"DE"}}, // Auggen
    {Coordinate{5.63034, 46.239}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bellignat
    {Coordinate{1.85056, 50.9533}, Tz::Europe_Paris, CountryId{"FR"}}, // Calais-Ville railway station
    {Coordinate{6.70361, 51.9744}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Winterswijk West railway station
    {Coordinate{2.23694, 48.7075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Palaiseau-Villebon
    {Coordinate{1.89816, 50.9454}, Tz::Europe_Paris, CountryId{"FR"}}, // Beau-Marais
    {Coordinate{-3.24354, 48.5075}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2109565
    {Coordinate{6.38608, 48.5652}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2110347
    {Coordinate{8.54879, 47.3241}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kilchberg railway station
    {Coordinate{8.57825, 47.2796}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberrieden railway station
    {Coordinate{8.55577, 47.3063}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rüschlikon railway station
    {Coordinate{-1.24455, 49.068}, Tz::Europe_Paris, CountryId{"FR"}}, // Carantilly - Marigny
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q211071
    {Coordinate{142.498, 48.0253}, Tz::Asia_Sakhalin, CountryId{"RU"}}, // Q211079
    {Coordinate{7.1625, 46.0828}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2110844
    {Coordinate{4.23505, 50.506}, Tz::Europe_Brussels, CountryId{"BE"}}, // Manage railway station
    {Coordinate{6.06846, 43.1451}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2110920
    {Coordinate{1.60929, 50.7274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boulogne-Tintelleries
    {Coordinate{16.0764, 51.6706}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Głogów
    {Coordinate{4.44331, 50.8904}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diegem railway station
    {Coordinate{13.7103, 45.7133}, Tz::Europe_Rome, CountryId{"IT"}}, // Grignano railway station
    {Coordinate{8.6663, 45.3856}, Tz::Europe_Rome, CountryId{"IT"}}, // Garbagna train station
    {Coordinate{4.81972, 52.4567}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaandam Kogerveld railway station
    {Coordinate{-3.98738, 48.6769}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Pol-de-Léon
    {Coordinate{2.5625, 49.6417}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montdidier
    {Coordinate{10.7722, 52.1406}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schöppenstedt station
    {Coordinate{14.5876, 38.0583}, Tz::Europe_Rome, CountryId{"IT"}}, // Acquedolci-San Fratello train station
    {Coordinate{2.21528, 48.7511}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2115505
    {Coordinate{2.436, 49.2511}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montataire
    {Coordinate{7.67865, 48.5595}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116031
    {Coordinate{5.86824, 49.1665}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116516
    {Coordinate{24.7931, 59.4234}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2116583
    {Coordinate{4.76099, 50.1039}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116916
    {Coordinate{7.71139, 53.6064}, Tz::Europe_Berlin, CountryId{"DE"}}, // train station Burhafe
    {Coordinate{7.61583, 53.6361}, Tz::Europe_Berlin, CountryId{"DE"}}, // train station Esens (Ostfriesland)
    {Coordinate{7.89306, 53.5686}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jever train station
    {Coordinate{7.78889, 53.5794}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wittmund train station
    {Coordinate{7.94639, 53.5419}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schortens-Heidmühle train station
    {Coordinate{4.12534, 45.8859}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2116993
    {Coordinate{13.1603, 52.0906}, Tz::Europe_Berlin, CountryId{"DE"}}, // Luckenwalde station
    {Coordinate{0.41765, 49.6036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bréauté-Beuzeville
    {Coordinate{2.94306, 48.3794}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montereau
    {Coordinate{1.60667, 42.97}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Foix
    {Coordinate{16.0685, 39.1343}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21184964
    {Coordinate{8.40079, 45.1741}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21184970
    {Coordinate{16.0645, 39.1643}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21184974
    {Coordinate{15.3692, 41.2782}, Tz::Europe_Rome, CountryId{"IT"}}, // Bovino-Deliceto train station
    {Coordinate{13.3292, 46.0126}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21184981
    {Coordinate{12.6286, 43.0196}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21184987
    {Coordinate{15.6532, 38.2342}, Tz::Europe_Rome, CountryId{"IT"}}, // Villa San Giovanni-Cannitello railway station
    {Coordinate{13.5175, 45.9388}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21184991
    {Coordinate{7.93283, 45.2019}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelrosso railway halt
    {Coordinate{15.5955, 41.3975}, Tz::Europe_Rome, CountryId{"IT"}}, // Cervaro train station
    {Coordinate{14.7874, 41.2114}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185007
    {Coordinate{12.2598, 42.5919}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185009
    {Coordinate{16.1499, 38.9707}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185013
    {Coordinate{16.059, 39.2464}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185021
    {Coordinate{14.7648, 41.2472}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185023
    {Coordinate{11.7109, 45.4866}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185030
    {Coordinate{13.3455, 46.5117}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185036
    {Coordinate{11.6358, 45.5188}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185042
    {Coordinate{15.2886, 41.8393}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185044
    {Coordinate{16.0612, 39.2115}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185046
    {Coordinate{12.2024, 43.1374}, Tz::Europe_Rome, CountryId{"IT"}}, // Magione
    {Coordinate{12.1879, 43.1584}, Tz::Europe_Rome, CountryId{"IT"}}, // Torricella railway station
    {Coordinate{13.3751, 45.9881}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185052
    {Coordinate{16.4669, 38.9233}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185054
    {Coordinate{11.7739, 45.458}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185058
    {Coordinate{13.1769, 46.3973}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185060
    {Coordinate{15.0275, 41.2156}, Tz::Europe_Rome, CountryId{"IT"}}, // Montecalvo-Buonalbergo-Casalbore railway station
    {Coordinate{14.6775, 41.3405}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185069
    {Coordinate{14.7187, 41.3176}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185071
    {Coordinate{13.5475, 45.9351}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185073
    {Coordinate{16.1196, 39.0159}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185075
    {Coordinate{13.3663, 38.127}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185086
    {Coordinate{12.1332, 43.1884}, Tz::Europe_Rome, CountryId{"IT"}}, // Passignano sul Trasimeno
    {Coordinate{14.1607, 41.1739}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185094
    {Coordinate{14.7122, 41.2957}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185096
    {Coordinate{8.22448, 44.9577}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185098
    {Coordinate{8.39734, 40.8379}, Tz::Europe_Rome, CountryId{"IT"}}, // Porto Torres Marittima railway station
    {Coordinate{10.6673, 44.7423}, Tz::Europe_Rome, CountryId{"IT"}}, // Pratofontana railway halt
    {Coordinate{15.6588, 38.1507}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio di Calabria Archi railway halt
    {Coordinate{15.6412, 38.1857}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio di Calabria Catona railway halt
    {Coordinate{15.6507, 38.1653}, Tz::Europe_Rome, CountryId{"IT"}}, // Reggio di Calabria Gallico railway station
    {Coordinate{13.5059, 45.8302}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185115
    {Coordinate{13.4838, 45.8723}, Tz::Europe_Rome, CountryId{"IT"}}, // Sagrado railway station
    {Coordinate{8.01702, 45.2345}, Tz::Europe_Rome, CountryId{"IT"}}, // Saluggia railway halt
    {Coordinate{8.24989, 45.3535}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185123
    {Coordinate{10.6584, 44.8946}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185125
    {Coordinate{13.3975, 45.9761}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185132
    {Coordinate{16.7536, 40.9586}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185136
    {Coordinate{14.6667, 41.3996}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185150
    {Coordinate{16.5105, 38.9027}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185154
    {Coordinate{7.85481, 45.5148}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185158
    {Coordinate{16.5497, 38.8925}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185166
    {Coordinate{12.634, 45.6883}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185169
    {Coordinate{15.2351, 41.2353}, Tz::Europe_Rome, CountryId{"IT"}}, // Montaguto-Panni railway station
    {Coordinate{12.3133, 46.0509}, Tz::Europe_Rome, CountryId{"IT"}}, // Nove railway station
    {Coordinate{13.4723, 42.0571}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185183
    {Coordinate{15.167, 41.2307}, Tz::Europe_Rome, CountryId{"IT"}}, // Savignano-Greci railway station
    {Coordinate{17.1767, 40.5167}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21185194
    {Coordinate{7.97025, 45.212}, Tz::Europe_Rome, CountryId{"IT"}}, // Torrazza Piemonte railway halt
    {Coordinate{12.0796, 43.1967}, Tz::Europe_Rome, CountryId{"IT"}}, // Tuoro sul Trasimeno
    {Coordinate{6.63229, 48.5196}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2118662
    {Coordinate{2.28722, 48.7394}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Baconnets
    {Coordinate{7.34938, 50.7683}, Tz::Europe_Berlin, CountryId{"DE"}}, // Blankenberg station
    {Coordinate{6.61051, 51.3299}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Oppum station
    {Coordinate{8.17872, 53.1517}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oldenburg-Wechloy railway station
    {Coordinate{12.3308, 43.3041}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21192986
    {Coordinate{49.6514, 58.5783}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q21193149
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21193912
    {Coordinate{44.5118, 48.5196}, Tz::Europe_Volgograd, CountryId{"RU"}}, // Sarepta
    {Coordinate{34.5743, 46.0759}, Tz::Europe_Kiev, CountryId{"UA"}}, // 1328 km
    {Coordinate{30.021, 57.8484}, Tz::Europe_Moscow, CountryId{}}, // Q21195544
    {Coordinate{8.47533, 53.3053}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirchhammelwarden station
    {Coordinate{0.808218, 45.1383}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Niversac
    {Coordinate{2.5125, 48.8889}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Raincy – Villemomble – Montfermeil
    {Coordinate{6.15631, 45.5574}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-d'Albigny railway station
    {Coordinate{-4.3145, 55.9412}, Tz::Europe_London, CountryId{"GB"}}, // Milngavie railway station
    {Coordinate{4.04333, 50.2842}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2122876
    {Coordinate{7.14088, 49.0559}, Tz::Europe_Paris, CountryId{"FR"}}, // Wittring
    {Coordinate{1.9929, 48.8238}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2123084
    {Coordinate{5.68833, 50.5731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Trooz railway station
    {Coordinate{6.56917, 52.4575}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vroomshoop railway station
    {Coordinate{-3.83265, 48.5779}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Morlaix
    {Coordinate{3.53549, 43.3182}, Tz::Europe_Paris, CountryId{"FR"}}, // Marseillan-Plage
    {Coordinate{2.40278, 48.7417}, Tz::Europe_Paris, CountryId{"FR"}}, // Orly-Ville
    {Coordinate{5.41056, 52.9028}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Koudum-Molkwerum railway station
    {Coordinate{3.40949, 49.038}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Château-Thierry
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280545
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280549
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280552
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280554
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280559
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280560
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280563
    {Coordinate{23.471, 61.6819}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280568
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280606
    {Coordinate{23.527, 61.6255}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21280612
    {Coordinate{23.7512, 61.4249}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Sääksjärvi railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21282081
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21282188
    {Coordinate{23.6795, 61.5096}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Lielahti railway station
    {Coordinate{5.57806, 51.9581}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rhenen railway station
    {Coordinate{4.45611, 51.1708}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel-Oude-God railway station
    {Coordinate{12.413, 51.1505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neukieritzsch station
    {Coordinate{12.6976, 51.0582}, Tz::Europe_Berlin, CountryId{"DE"}}, // Geithain station
    {Coordinate{12.4862, 51.118}, Tz::Europe_Berlin, CountryId{"DE"}}, // Borna (b Leipzig) railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langebrück (Sachs) station
    {Coordinate{11.1494, 51.73}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2129519
    {Coordinate{0.971667, 43.1789}, Tz::Europe_Paris, CountryId{"FR"}}, // Boussens train station
    {Coordinate{-1.3955, 43.3241}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Itxassou
    {Coordinate{2.35194, 43.2181}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carcassonne
    {Coordinate{2.93644, 50.5745}, Tz::Europe_Paris, CountryId{"FR"}}, // Wavrin
    {Coordinate{4.98027, 43.5154}, Tz::Europe_Paris, CountryId{"FR"}}, // Istres
    {Coordinate{2.86717, 50.5481}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2130876
    {Coordinate{6.23639, 46.1994}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Annemasse
    {Coordinate{19.8422, 54.3811}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2131055
    {Coordinate{6.95357, 51.3634}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kettwig station
    {Coordinate{8.49892, 47.9478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Donaueschingen station
    {Coordinate{5.03667, 50.7636}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neerwinden railway station
    {Coordinate{4.18808, 50.4654}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Louvière-South railway station
    {Coordinate{24.06, 59.3445}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Paldiski train station
    {Coordinate{3.94621, 50.1197}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2133341
    {Coordinate{5.04662, 46.2349}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2133524
    {Coordinate{5.7225, 51.9194}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zetten-Andelst railway station
    {Coordinate{2.09222, 48.955}, Tz::Europe_Paris, CountryId{"FR"}}, // Achères - Grand-Cormier
    {Coordinate{4.8145, 45.1857}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2134090
    {Coordinate{6.43387, 43.4309}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vidauban
    {Coordinate{2.07356, 48.799}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Saint-Cyr
    {Coordinate{2.55389, 44.2908}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Luc-Primaube
    {Coordinate{21.1353, 52.2369}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Gocławek railway station
    {Coordinate{4.01043, 50.5434}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neufvilles railway station
    {Coordinate{2.36865, 48.9957}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sarcelles-Saint-Brice
    {Coordinate{2.095, 49.046}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pontoise
    {Coordinate{1.77444, 49.6856}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Abancourt
    {Coordinate{4.46889, 51.1692}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel-Liersesteenweg railway station
    {Coordinate{-1.78134, 46.4998}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Sables-d'Olonne
    {Coordinate{4.55197, 50.5571}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tilly railway station
    {Coordinate{-1.3714, 47.7174}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2137673
    {Coordinate{3.83679, 50.7126}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lessines railway station
    {Coordinate{-0.867991, 47.4102}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2140129
    {Coordinate{1.64251, 50.5171}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Étaples-Le Touquet
    {Coordinate{9.86992, 53.2848}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holm-Seppensen station
    {Coordinate{6.99728, 50.9356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Trimbornstraße station
    {Coordinate{8.57583, 53.6889}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21416449
    {Coordinate{6.14447, 48.7554}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2142149
    {Coordinate{8.62127, 53.7786}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q21421807
    {Coordinate{3.32984, 50.2255}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2142874
    {Coordinate{5.79918, 46.9771}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mouchard
    {Coordinate{2.42889, 48.6256}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2144093
    {Coordinate{2.45889, 48.8961}, Tz::Europe_Paris, CountryId{"FR"}}, // Noisy-le-Sec
    {Coordinate{2.33889, 48.8206}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cité Universitaire
    {Coordinate{7.43883, 51.5097}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund West railway station
    {Coordinate{1.45305, 48.4368}, Tz::Europe_Paris, CountryId{"FR"}}, // Lucé railway station
    {Coordinate{5.74229, 45.0855}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2145513
    {Coordinate{6.97693, 51.4802}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Bergeborbeck station
    {Coordinate{5.26778, 49.8528}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bertrix railway station
    {Coordinate{1.62583, 49.9325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Blangy-sur-Bresle
    {Coordinate{9.2092, 48.496}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reutlingen Central Railway Station
    {Coordinate{22.9818, 61.4045}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q21470242
    {Coordinate{4.40035, 50.462}, Tz::Europe_Brussels, CountryId{"BE"}}, // Courcelles-Motte railway station
    {Coordinate{8.3769, 40.6499}, Tz::Europe_Rome, CountryId{"IT"}}, // Olmedo railway station
    {Coordinate{7.45874, 47.6557}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sierentz
    {Coordinate{8.24096, 52.9448}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großenkneten
    {Coordinate{8.20957, 52.8996}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ahlhorn
    {Coordinate{8.05587, 52.844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Cloppenburg
    {Coordinate{7.94544, 52.7236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen (Oldb)
    {Coordinate{2.39278, 48.3931}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2148825
    {Coordinate{6.72056, 53.4139}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Uithuizermeeden railway station
    {Coordinate{0.411509, 46.5263}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2149362
    {Coordinate{-1.57537, 47.9852}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2150105
    {Coordinate{8.29247, 52.7485}, Tz::Europe_Berlin, CountryId{"DE"}}, // Station Vechta Stoppelmarkt
    {Coordinate{13.5475, 52.5506}, Tz::Europe_Berlin, CountryId{"DE"}}, // Raoul-Wallenberg-Straße railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Arsbeck station
    {Coordinate{2.39889, 49.1189}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Seugy
    {Coordinate{10.0298, 53.4243}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meckelfeld station
    {Coordinate{10.066, 53.4035}, Tz::Europe_Berlin, CountryId{"DE"}}, // Maschen station
    {Coordinate{10.1091, 53.3877}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stelle station
    {Coordinate{10.145, 53.3688}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ashausen station
    {Coordinate{10.2901, 53.3177}, Tz::Europe_Berlin, CountryId{"DE"}}, // Radbruch station
    {Coordinate{10.3723, 53.2903}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bardowick station
    {Coordinate{10.2085, 53.3535}, Tz::Europe_Berlin, CountryId{"DE"}}, // Winsen station
    {Coordinate{9.85857, 53.2696}, Tz::Europe_Berlin, CountryId{"DE"}}, // Büsenbachtal station
    {Coordinate{9.84476, 53.2418}, Tz::Europe_Berlin, CountryId{"DE"}}, // Handeloh station
    {Coordinate{9.82863, 53.1861}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wintermoor station
    {Coordinate{6.23454, 49.3804}, Tz::Europe_Paris, CountryId{"FR"}}, // Basse-Ham
    {Coordinate{5.65334, 46.2597}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Oyonnax
    {Coordinate{6.15765, 46.8577}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Frasne
    {Coordinate{6.47056, 52.3656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijverdal railway station
    {Coordinate{6.8725, 52.7475}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Emmen Zuid railway station
    {Coordinate{2.14417, 48.9458}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Maisons-Laffitte
    {Coordinate{34.3769, 54.0681}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21538485
    {Coordinate{-2.35209, 48.376}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2154264
    {Coordinate{19.9472, 50.0656}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Kraków Główny railway station
    {Coordinate{5.32972, 51.0336}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zolder railway station
    {Coordinate{3.20476, 46.0976}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2154970
    {Coordinate{6.96528, 51.455}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Frohnhausen station
    {Coordinate{1.37019, 48.7314}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dreux
    {Coordinate{1.62091, 48.2744}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2155896
    {Coordinate{13.5328, 43.2874}, Tz::Europe_Rome, CountryId{"IT"}}, // San Claudio railway station
    {Coordinate{13.4778, 43.2816}, Tz::Europe_Rome, CountryId{"IT"}}, // Corridonia-Mogliano railway station
    {Coordinate{13.4408, 43.2926}, Tz::Europe_Rome, CountryId{"IT"}}, // Macerata Fontescodella railway station
    {Coordinate{13.417, 43.2575}, Tz::Europe_Rome, CountryId{"IT"}}, // Urbisaglia-Sforzacosta railway station
    {Coordinate{13.367, 43.2409}, Tz::Europe_Rome, CountryId{"IT"}}, // Pollenza railway station
    {Coordinate{13.1835, 43.23}, Tz::Europe_Rome, CountryId{"IT"}}, // San Severino Marche railway station
    {Coordinate{13.0753, 43.2202}, Tz::Europe_Rome, CountryId{"IT"}}, // Gagliole railway station
    {Coordinate{13.0151, 43.2539}, Tz::Europe_Rome, CountryId{"IT"}}, // Matelica railway station
    {Coordinate{4.08545, 46.0239}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Coteau
    {Coordinate{-0.368059, 45.2119}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2156458
    {Coordinate{19.8222, 49.9772}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2156575
    {Coordinate{2.97922, 45.1254}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2156841
    {Coordinate{38.9858, 45.0711}, Tz::Europe_Moscow, CountryId{"RU"}}, // ZIP (Krasnodar)
    {Coordinate{25.9581, 48.0239}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vadul Siret
    {Coordinate{4.45111, 51.4625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Essen railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Raippo railway station
    {Coordinate{3.07184, 48.3426}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2157274
    {Coordinate{8.5969, 47.2615}, Tz::Europe_Zurich, CountryId{"CH"}}, // Horgen railway station
    {Coordinate{8.69286, 47.2087}, Tz::Europe_Zurich, CountryId{"CH"}}, // Burghalden railway station
    {Coordinate{8.64358, 47.2468}, Tz::Europe_Zurich, CountryId{"CH"}}, // Au ZH railway station
    {Coordinate{8.67528, 47.2294}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wädenswil railway station
    {Coordinate{0.189471, 49.543}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montivilliers
    {Coordinate{1.90611, 42.4586}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Latour-de-Carol-Enveitg
    {Coordinate{4.65014, 50.7365}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gastuche railway station
    {Coordinate{5.62412, 52.0847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lunteren railway station
    {Coordinate{8.61348, 52.3787}, Tz::Europe_Berlin, CountryId{"DE"}}, // Espelkamp station
    {Coordinate{8.54599, 52.2891}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holzhausen-Heddinghausen station
    {Coordinate{8.52086, 52.2637}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neue Mühle station
    {Coordinate{8.51689, 52.2393}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bieren-Rödinghausen station
    {Coordinate{3.9219, 51.0031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schellebelle railway station
    {Coordinate{11.6782, 58.4846}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Munkedal railway station
    {Coordinate{0.873825, 46.4175}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2160554
    {Coordinate{1.55235, 46.4405}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2161232
    {Coordinate{4.70446, 44.4433}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2161382
    {Coordinate{2.31639, 48.9664}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Barre - Ormesson
    {Coordinate{10.1056, 45.8066}, Tz::Europe_Rome, CountryId{"IT"}}, // Pisogne
    {Coordinate{7.33837, 43.764}, Tz::Europe_Paris, CountryId{"FR"}}, // Q21619066
    {Coordinate{5.78583, 50.9469}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Beek-Elsloo railway station
    {Coordinate{23.6003, 62.6175}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Alavus railway station
    {Coordinate{4.49185, 50.0564}, Tz::Europe_Brussels, CountryId{"BE"}}, // Couvin railway station
    {Coordinate{2.76361, 48.3942}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thomery
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21634863
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21634865
    {Coordinate{43.5028, 51.9381}, Tz::Europe_Saratov, CountryId{"RU"}}, // Q21635617
    {Coordinate{46.8528, 45.4414}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21635631
    {Coordinate{59.7903, 56.9439}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21636133
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Bogolyubovo railway station
    {Coordinate{106.07, 51.8489}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21636455
    {Coordinate{1.88304, 48.081}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Artenay
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21636685
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21636760
    {Coordinate{59.955, 57.345}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21636884
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21637320
    {Coordinate{43.6311, 56.2567}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21637408
    {Coordinate{104.646, 51.4467}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21637566
    {Coordinate{42.1686, 56.2022}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21637624
    {Coordinate{5.06833, 52.0986}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Leidsche Rijn railway station
    {Coordinate{108.793, 51.5597}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Gorkhon station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21638430
    {Coordinate{40.2475, 61.9328}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21638468
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21638736
    {Coordinate{43.0508, 45.8114}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21638768
    {Coordinate{43.3394, 45.8975}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21638881
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21638934
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21639107
    {Coordinate{60.0869, 57.4297}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21639222
    {Coordinate{33.1695, 54.5745}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21639262
    {Coordinate{33.3877, 54.5412}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21639403
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21639790
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21639903
    {Coordinate{104.929, 51.5103}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21640181
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640266
    {Coordinate{105.736, 51.6842}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21640274
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640338
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640365
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640457
    {Coordinate{39.8822, 59.2069}, Tz::Europe_Moscow, CountryId{"RU"}}, // Konosha I railway station
    {Coordinate{33.4848, 54.5202}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21640516
    {Coordinate{28.7572, 59.6125}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21640568
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640632
    {Coordinate{49.6514, 58.5783}, Tz::Europe_Kirov, CountryId{"RU"}}, // Krasnoselsky passing
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640692
    {Coordinate{38.9542, 44.9889}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21640779
    {Coordinate{124.217, 55.1911}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21640847
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21640913
    {Coordinate{123.119, 55.4994}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21641032
    {Coordinate{107.249, 52.1158}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21641137
    {Coordinate{122.769, 55.7667}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21641237
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21641457
    {Coordinate{34.3017, 63.1506}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21641511
    {Coordinate{30.3456, 57.8936}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21641806
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21641887
    {Coordinate{3.30298, 48.5556}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Provins
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643429
    {Coordinate{54.2431, 56.1036}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21643453
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643540
    {Coordinate{76.6903, 66.0903}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21643552
    {Coordinate{120.736, 57.0203}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21643615
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643657
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643748
    {Coordinate{40.7133, 56.9347}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21643786
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643792
    {Coordinate{105.253, 51.5792}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21643811
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643818
    {Coordinate{106.402, 51.9756}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21643847
    {Coordinate{108.86, 51.2946}, Tz::Asia_Chita, CountryId{"RU"}}, // Petrovsky Zavod station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21643894
    {Coordinate{29.9344, 57.3817}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21643931
    {Coordinate{45.8281, 52.2614}, Tz::Europe_Saratov, CountryId{"RU"}}, // Q21643983
    {Coordinate{61.1103, 55.0292}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21644002
    {Coordinate{30.1489, 57.8567}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644008
    {Coordinate{106.354, 51.9689}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21644031
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644075
    {Coordinate{54.9322, 54.0608}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21644158
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644169
    {Coordinate{61.4317, 57.365}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21644187
    {Coordinate{97.2067, 56.1578}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q21644202
    {Coordinate{29.7381, 57.8039}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644239
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644277
    {Coordinate{40.5525, 56.8011}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644332
    {Coordinate{42.0228, 56.2236}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644365
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644440
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644466
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644470
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644483
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644579
    {Coordinate{40.2475, 61.9328}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644604
    {Coordinate{105.112, 51.5547}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21644619
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644622
    {Coordinate{40.5642, 56.8575}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644639
    {Coordinate{40.8903, 56.9983}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644640
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644648
    {Coordinate{106.616, 52.0039}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21644657
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644722
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644754
    {Coordinate{46.8528, 45.4414}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644784
    {Coordinate{43.7753, 46.075}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644801
    {Coordinate{28.3058, 59.6489}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21644880
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21644920
    {Coordinate{119.956, 56.9144}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21645051
    {Coordinate{43.9833, 46.3106}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21645070
    {Coordinate{40.2475, 61.9328}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21645073
    {Coordinate{123.761, 55.3742}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21645165
    {Coordinate{99.6331, 54.7047}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q21645201
    {Coordinate{108.39, 51.7606}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Chelutai station
    {Coordinate{56.0169, 54.6265}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Chernoye Ozero
    {Coordinate{122.409, 56.0008}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21645651
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21645802
    {Coordinate{54.6022, 56.2442}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q21645804
    {Coordinate{121.63, 56.5944}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q21645817
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q21645882
    {Coordinate{7.17367, 47.8019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cernay
    {Coordinate{5.55559, 50.6108}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sclessin railway station
    {Coordinate{51.3089, 43.6969}, Tz::Asia_Aqtau, CountryId{"KZ"}}, // Q21659355
    {Coordinate{32.7789, 56.2211}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21661170
    {Coordinate{8.68188, 40.7491}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21662090
    {Coordinate{1.40111, 43.6842}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fenouillet-Saint-Alban
    {Coordinate{61.5703, 54.1131}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Troitsk
    {Coordinate{1.06992, 49.5513}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2166681
    {Coordinate{-1.05038, 43.7208}, Tz::Europe_Paris, CountryId{"FR"}}, // Dax
    {Coordinate{9.00976, 52.3681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Petershagen-Lahde railway station
    {Coordinate{9.1105, 52.5096}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leese-Stolzenau railway station
    {Coordinate{8.84175, 40.8133}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21675364
    {Coordinate{1.17006, 45.9598}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2167746
    {Coordinate{1.9581, 47.3837}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2167825
    {Coordinate{3.10083, 45.7786}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clermont-Ferrand
    {Coordinate{8.93761, 53.0871}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bremen-Oberneuland station
    {Coordinate{2.25237, 46.9921}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2168788
    {Coordinate{3.06972, 49.7397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ham
    {Coordinate{4.00797, 50.4698}, Tz::Europe_Brussels, CountryId{"BE"}}, // Obourg railway station
    {Coordinate{3.33361, 50.1283}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cattenières
    {Coordinate{2.28355, 49.8932}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Roch
    {Coordinate{5.22722, 51.9472}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Culemborg railway station
    {Coordinate{8.80146, 51.9915}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lage (Lippe) railway station
    {Coordinate{4.38, 50.5072}, Tz::Europe_Brussels, CountryId{"BE"}}, // Luttre railway station
    {Coordinate{14.0877, 51.1022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großharthau railway station
    {Coordinate{3.18228, 50.811}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wevelgem railway station
    {Coordinate{11.1732, 58.9363}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Strömstad
    {Coordinate{3.52621, 50.5273}, Tz::Europe_Brussels, CountryId{"BE"}}, // Callenelle railway station
    {Coordinate{3.8095, 50.1981}, Tz::Europe_Paris, CountryId{"FR"}}, // Berlaimont
    {Coordinate{7.4077, 51.9666}, Tz::Europe_Berlin, CountryId{"DE"}}, // Havixbeck station
    {Coordinate{4.81556, 51.8294}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hardinxveld Blauwe Zoom railway station
    {Coordinate{4.53422, 50.5778}, Tz::Europe_Brussels, CountryId{"BE"}}, // Villers-la-Ville railway station
    {Coordinate{7.65783, 48.9308}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2173596
    {Coordinate{5.56194, 50.6408}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liège-Carré railway station
    {Coordinate{6.30435, 46.0667}, Tz::Europe_Paris, CountryId{"FR"}}, // La Roche-sur-Foron
    {Coordinate{2.73464, 50.0957}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Miraumont
    {Coordinate{9.10549, 40.8976}, Tz::Europe_Rome, CountryId{"IT"}}, // Tempio Pausania Station
    {Coordinate{14.1512, 51.1109}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weickersdorf (Sachs) railway station
    {Coordinate{14.2396, 51.1422}, Tz::Europe_Berlin, CountryId{"DE"}}, // Demitz-Thumitz railway station
    {Coordinate{14.325, 51.1536}, Tz::Europe_Berlin, CountryId{"DE"}}, // Seitschen railway station
    {Coordinate{14.5094, 51.1656}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kubschütz railway station
    {Coordinate{14.5754, 51.1592}, Tz::Europe_Berlin, CountryId{"DE"}}, // Pommritz railway station
    {Coordinate{14.6229, 51.1386}, Tz::Europe_Berlin, CountryId{"DE"}}, // Breitendorf railway station
    {Coordinate{14.751, 51.1236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zoblitz railway station
    {Coordinate{2.78681, 50.7129}, Tz::Europe_Paris, CountryId{"FR"}}, // Steenwerck
    {Coordinate{10.5822, 43.3394}, Tz::Europe_Rome, CountryId{"IT"}}, // Riparbella railway station
    {Coordinate{10.7423, 43.3351}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte Ginori railway station
    {Coordinate{2.13472, 48.8097}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Versailles-Rive-Droite
    {Coordinate{7.51534, 51.5134}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Körne station
    {Coordinate{2.43278, 48.5708}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2176143
    {Coordinate{1.8315, 48.6437}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rambouillet
    {Coordinate{4.4575, 50.9586}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eppegem railway station
    {Coordinate{1.83083, 49.6544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Feuquières-Broquiers
    {Coordinate{2.05111, 48.8678}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Nom-la-Bretèche – Forêt de Marly
    {Coordinate{6.93405, 45.9967}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2177034
    {Coordinate{6.40556, 53.2483}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zuidhorn railway station
    {Coordinate{4.70164, 50.9226}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wijgmaal railway station
    {Coordinate{13.3679, 52.4924}, Tz::Europe_Berlin, CountryId{"DE"}}, // Yorckstraße (Großgörschenstraße) station
    {Coordinate{13.3721, 52.4918}, Tz::Europe_Berlin, CountryId{"DE"}}, // Yorckstraße station
    {Coordinate{9.19009, 40.9265}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21779001
    {Coordinate{7.25119, 48.7296}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2177940
    {Coordinate{-3.12855, 48.7276}, Tz::Europe_Paris, CountryId{"FR"}}, // Halte de Frynaudour
    {Coordinate{6.17361, 48.6897}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nancy-Ville
    {Coordinate{4.0861, 49.9291}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2178893
    {Coordinate{-1.36222, 43.3055}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Louhossoa
    {Coordinate{4.40707, 50.285}, Tz::Europe_Brussels, CountryId{"BE"}}, // Berzée railway station
    {Coordinate{2.61667, 48.8433}, Tz::Europe_Paris, CountryId{"FR"}}, // Noisiel
    {Coordinate{2.25483, 50.4469}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Anvin
    {Coordinate{1.45028, 43.5797}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulouse-Saint-Agne
    {Coordinate{6.95083, 52.2211}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Enschede De Eschmarke railway station
    {Coordinate{-1.54167, 47.2167}, Tz::Europe_Paris, CountryId{"FR"}}, // Nantes station
    {Coordinate{3.75665, 51.0383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gentbrugge railway station
    {Coordinate{4.80528, 52.7861}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schagen railway station
    {Coordinate{4.17695, 50.5463}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marche-lez-Écaussinnes railway station
    {Coordinate{13.5356, 52.5356}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Poelchaustraße station
    {Coordinate{2.70944, 48.8364}, Tz::Europe_Paris, CountryId{"FR"}}, // Bussy-Saint-Georges Station
    {Coordinate{5.06138, 50.343}, Tz::Europe_Brussels, CountryId{"BE"}}, // Natoye railway station
    {Coordinate{13.7032, 51.0296}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden-Plauen railway station
    {Coordinate{4.12064, 45.5544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Romain le Puy
    {Coordinate{-0.236448, 44.9159}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Libourne
    {Coordinate{-0.493586, 46.1527}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Prissé-la-Charrière
    {Coordinate{36.6728, 56.5758}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21821302
    {Coordinate{40.5836, 64.1531}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q21821327
    {Coordinate{2.46361, 48.6061}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2182178
    {Coordinate{1.82419, 50.1021}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Abbeville
    {Coordinate{1.94917, 42.4322}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourg-Madame
    {Coordinate{-0.292532, 48.1342}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2182950
    {Coordinate{-0.513033, 46.0987}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2183486
    {Coordinate{17.2969, 50.9311}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Oława railway station
    {Coordinate{6.79702, 45.8936}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2183736
    {Coordinate{1.44453, 44.092}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2183967
    {Coordinate{3.62378, 50.8703}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eine railway station
    {Coordinate{5.55133, 46.6685}, Tz::Europe_Paris, CountryId{"FR"}}, // Lons-le-Saunier railway station
    {Coordinate{37.6564, 55.7733}, Tz::Europe_Moscow, CountryId{"RU"}}, // Moskva-Passazirskaya-Kazanskaya
    {Coordinate{3.22353, 49.6111}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chauny
    {Coordinate{5.29972, 52.1833}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Soestdijk railway station
    {Coordinate{19.1329, 47.7826}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vác railway station
    {Coordinate{11.4721, 44.5035}, Tz::Europe_Rome, CountryId{"IT"}}, // Castenaso railway station
    {Coordinate{11.458, 44.5035}, Tz::Europe_Rome, CountryId{"IT"}}, // Castenaso Stellina railway station
    {Coordinate{11.5389, 44.5362}, Tz::Europe_Rome, CountryId{"IT"}}, // Budrio Centro railway station
    {Coordinate{9.37242, 41.0816}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21855978
    {Coordinate{4.93139, 52.495}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Purmerend Weidevenne railway station
    {Coordinate{2.65472, 48.8394}, Tz::Europe_Paris, CountryId{"FR"}}, // Torcy
    {Coordinate{19.1288, 47.6075}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunakeszi alsó railway station
    {Coordinate{19.1362, 47.6258}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunakeszi railway station
    {Coordinate{19.1348, 47.6434}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunakeszi-Gyártelep railway station
    {Coordinate{19.1347, 47.678}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsógöd railway station
    {Coordinate{19.1375, 47.6878}, Tz::Europe_Budapest, CountryId{"HU"}}, // Göd railway station
    {Coordinate{19.1432, 47.7055}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőgöd railway station
    {Coordinate{19.1549, 47.728}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sződ-Sződliget railway station
    {Coordinate{19.1495, 47.7732}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vác-Alsóváros railway station
    {Coordinate{19.0313, 47.8238}, Tz::Europe_Budapest, CountryId{"HU"}}, // Verőce railway station
    {Coordinate{19.0109, 47.8274}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kismaros railway station
    {Coordinate{18.956, 47.7858}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagymaros-Visegrád railway station
    {Coordinate{18.9517, 47.7799}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagymaros railway station
    {Coordinate{18.9176, 47.7705}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dömösi átkelés railway station
    {Coordinate{18.9091, 47.8007}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zebegény railway station
    {Coordinate{18.8691, 47.8181}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szob alsó railway station
    {Coordinate{18.862, 47.8211}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szob railway station
    {Coordinate{19.1137, 47.7954}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisvác railway station
    {Coordinate{19.1642, 47.7525}, Tz::Europe_Budapest, CountryId{"HU"}}, // Máriaudvar railway station
    {Coordinate{7.01944, 43.5539}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cannes
    {Coordinate{19.154, 47.6018}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alagimajor railway station
    {Coordinate{4.51722, 52.2153}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sassenheim railway station
    {Coordinate{6.4971, 48.5879}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2186882
    {Coordinate{3.38869, 50.3347}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Denain
    {Coordinate{1.54155, 45.5362}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Masseret
    {Coordinate{19.1818, 47.6114}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fót railway station
    {Coordinate{19.1928, 47.615}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fótújfalu railway station
    {Coordinate{19.2008, 47.6217}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fótfürdő railway station
    {Coordinate{19.2229, 47.6356}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csomád railway station
    {Coordinate{19.2742, 47.6418}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ivacs railway station
    {Coordinate{19.2888, 47.6491}, Tz::Europe_Budapest, CountryId{"HU"}}, // Veresegyház railway station
    {Coordinate{19.2959, 47.6622}, Tz::Europe_Budapest, CountryId{"HU"}}, // Erdőkertes railway station
    {Coordinate{19.2861, 47.6759}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vicziántelep railway station
    {Coordinate{19.284, 47.6856}, Tz::Europe_Budapest, CountryId{"HU"}}, // Őrbottyán railway station
    {Coordinate{19.2582, 47.7174}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rudnaykert railway station
    {Coordinate{19.2495, 47.7253}, Tz::Europe_Budapest, CountryId{"HU"}}, // Váchartán railway station
    {Coordinate{19.1963, 47.736}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csörög railway station
    {Coordinate{19.2179, 47.7328}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vácrátót railway station
    {Coordinate{4.34833, 51.1828}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hoboken-Polder railway station
    {Coordinate{19.0683, 47.8182}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fenyveshegy railway station
    {Coordinate{2.71111, 49.8225}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rosières
    {Coordinate{3.25001, 48.5135}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longueville
    {Coordinate{21.0815, 46.6697}, Tz::Europe_Budapest, CountryId{"HU"}}, // Békéscsaba railway station
    {Coordinate{17.9113, 47.119}, Tz::Europe_Budapest, CountryId{"HU"}}, // Veszprém railway station (Jutas)
    {Coordinate{18.1489, 47.1947}, Tz::Europe_Budapest, CountryId{"HU"}}, // Várpalota railway station
    {Coordinate{5.23389, 50.5272}, Tz::Europe_Brussels, CountryId{"BE"}}, // Huy railway station
    {Coordinate{16.8475, 46.8318}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaegerszeg railway station
    {Coordinate{16.6326, 47.2374}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szombathely railway station
    {Coordinate{18.7128, 46.3493}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szekszárd railway station
    {Coordinate{17.1962, 47.0406}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ukk railway station
    {Coordinate{7.31389, 50.773}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hennef im Siegbogen station
    {Coordinate{2.52611, 48.8833}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gagny
    {Coordinate{4.97321, 43.4966}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2187498
    {Coordinate{19.2058, 47.3894}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyál felső railway station
    {Coordinate{19.2202, 47.376}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyál railway station
    {Coordinate{19.2325, 47.3013}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ócsa railway station
    {Coordinate{19.2306, 47.3432}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőpakony railway station
    {Coordinate{19.3177, 47.2471}, Tz::Europe_Budapest, CountryId{"HU"}}, // Inárcs-Kakucs railway station
    {Coordinate{19.3291, 47.1947}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dabas railway station
    {Coordinate{19.3514, 47.1806}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyón railway station
    {Coordinate{19.4017, 47.1614}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hernád railway station
    {Coordinate{19.4471, 47.133}, Tz::Europe_Budapest, CountryId{"HU"}}, // Örkény railway station
    {Coordinate{19.479, 47.0988}, Tz::Europe_Budapest, CountryId{"HU"}}, // Táborfalva railway staton
    {Coordinate{19.4983, 47.069}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőlajos railway station
    {Coordinate{19.5424, 47.0284}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lajosmizse railway station
    {Coordinate{19.5502, 47.0228}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lajosmizse alsó railway station
    {Coordinate{17.1527, 47.2612}, Tz::Europe_Budapest, CountryId{"HU"}}, // Celldömölk railway station
    {Coordinate{17.4591, 47.3406}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pápa railway station
    {Coordinate{17.8186, 47.4434}, Tz::Europe_Budapest, CountryId{"HU"}}, // Veszprémvarsány railway station
    {Coordinate{17.8779, 47.2667}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zirc railway station
    {Coordinate{17.6635, 47.6845}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győr-Gyárváros railway station
    {Coordinate{17.6482, 47.6634}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győrszabadhegy railway station
    {Coordinate{17.6982, 47.5877}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyúl railway station
    {Coordinate{17.7407, 47.5476}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pannonhalma railway station
    {Coordinate{17.7596, 47.53}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ravazd railway station
    {Coordinate{17.8177, 47.396}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonyszentlászló railway station
    {Coordinate{17.8197, 47.3602}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vinye railway station
    {Coordinate{17.8414, 47.3269}, Tz::Europe_Budapest, CountryId{"HU"}}, // Porva-Csesznek railway station
    {Coordinate{17.9215, 47.1927}, Tz::Europe_Budapest, CountryId{"HU"}}, // Eplény railway station
    {Coordinate{17.8118, 47.4161}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonygyirót railway station
    {Coordinate{17.805, 47.4741}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonypéterd railway station
    {Coordinate{17.2493, 47.6021}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csorna railway station
    {Coordinate{16.8598, 47.5998}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fertőszentmiklós railway station
    {Coordinate{16.9289, 47.2589}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sárvár railway station
    {Coordinate{17.573, 47.106}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ajka railway station
    {Coordinate{16.5766, 46.8456}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalalövő railway station
    {Coordinate{16.833, 47.2388}, Tz::Europe_Budapest, CountryId{"HU"}}, // Porpác railway station
    {Coordinate{16.2633, 46.9573}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentgotthárd railway station
    {Coordinate{16.9873, 46.4408}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagykanizsa railway station
    {Coordinate{17.2478, 46.7583}, Tz::Europe_Budapest, CountryId{"HU"}}, // Keszthely railway station
    {Coordinate{17.2889, 46.6926}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonszentgyörgy railway station
    {Coordinate{17.5564, 46.7497}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fonyód railway station
    {Coordinate{18.0535, 46.9076}, Tz::Europe_Budapest, CountryId{"HU"}}, // Siófok railway station
    {Coordinate{17.4288, 46.877}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tapolca railway station
    {Coordinate{18.6014, 46.814}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rétszilas railway station
    {Coordinate{18.388, 47.1055}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szabadbattyán railway station
    {Coordinate{18.6187, 47.4841}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bicske railway station
    {Coordinate{18.965, 47.4475}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budaörs railway station
    {Coordinate{18.9096, 47.45}, Tz::Europe_Budapest, CountryId{"HU"}}, // Törökbálint railway station
    {Coordinate{18.834, 47.4805}, Tz::Europe_Budapest, CountryId{"HU"}}, // Biatorbágy railway station
    {Coordinate{18.7449, 47.4939}, Tz::Europe_Budapest, CountryId{"HU"}}, // Herceghalom railway station
    {Coordinate{18.6433, 47.4867}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bicske alsó railway station
    {Coordinate{18.5276, 47.4851}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szár railway station
    {Coordinate{18.4958, 47.5183}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szárliget railway station
    {Coordinate{18.4245, 47.5634}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsógalla railway station
    {Coordinate{18.3757, 47.6188}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vértesszőlős railway station
    {Coordinate{18.348, 47.647}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tóvároskert railway station
    {Coordinate{18.262, 47.7253}, Tz::Europe_Budapest, CountryId{"HU"}}, // Almásfüzitő railway station
    {Coordinate{18.217, 47.7313}, Tz::Europe_Budapest, CountryId{"HU"}}, // Almásfüzitő felső railway station
    {Coordinate{18.1771, 47.7357}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szőny railway station
    {Coordinate{17.8699, 47.7054}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyszentjános railway station
    {Coordinate{17.7461, 47.6888}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győrszentiván railway station
    {Coordinate{18.8744, 47.3658}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tárnok railway station
    {Coordinate{18.7813, 47.3206}, Tz::Europe_Budapest, CountryId{"HU"}}, // Martonvásár railway station
    {Coordinate{18.7549, 47.2984}, Tz::Europe_Budapest, CountryId{"HU"}}, // Baracska railway station
    {Coordinate{18.7131, 47.2627}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pettend railway station
    {Coordinate{18.6927, 47.2454}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kápolnásnyék railway station
    {Coordinate{18.6638, 47.2269}, Tz::Europe_Budapest, CountryId{"HU"}}, // Velence railway station
    {Coordinate{18.6482, 47.2186}, Tz::Europe_Budapest, CountryId{"HU"}}, // Velencefürdő railway station
    {Coordinate{18.6247, 47.206}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gárdony railway station
    {Coordinate{18.6062, 47.1982}, Tz::Europe_Budapest, CountryId{"HU"}}, // Agárd railway station
    {Coordinate{18.5626, 47.1804}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dinnyés railway station
    {Coordinate{18.9371, 47.3896}, Tz::Europe_Budapest, CountryId{"HU"}}, // Érdliget railway station
    {Coordinate{18.9228, 47.3813}, Tz::Europe_Budapest, CountryId{"HU"}}, // Érd felső railway station
    {Coordinate{18.9011, 47.37}, Tz::Europe_Budapest, CountryId{"HU"}}, // Érd railway station
    {Coordinate{18.8989, 47.3225}, Tz::Europe_Budapest, CountryId{"HU"}}, // Százhalombatta railway station
    {Coordinate{18.8789, 47.2944}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunai Finomító railway station
    {Coordinate{18.8755, 47.2472}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ercsi railway station
    {Coordinate{18.8121, 47.1778}, Tz::Europe_Budapest, CountryId{"HU"}}, // Iváncsa railway station
    {Coordinate{19.3386, 47.4936}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pécel railway station
    {Coordinate{19.3901, 47.5351}, Tz::Europe_Budapest, CountryId{"HU"}}, // Isaszeg railway station
    {Coordinate{19.3896, 47.5957}, Tz::Europe_Budapest, CountryId{"HU"}}, // Máriabesnyő railway station
    {Coordinate{19.4718, 47.6412}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bag railway station
    {Coordinate{19.4924, 47.6478}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aszód railway station
    {Coordinate{19.5585, 47.6324}, Tz::Europe_Budapest, CountryId{"HU"}}, // Galgahévíz railway station
    {Coordinate{19.5972, 47.6264}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tura railway station
    {Coordinate{19.0496, 47.9401}, Tz::Europe_Budapest, CountryId{"HU"}}, // Diósjenő railway station
    {Coordinate{18.4067, 47.1589}, Tz::Europe_Budapest, CountryId{"HU"}}, // Székesfehérvár-Repülőtér railway station
    {Coordinate{18.1708, 46.9843}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonaliga railway station
    {Coordinate{18.018, 46.8979}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonszéplak felső railway station
    {Coordinate{17.9933, 46.8919}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonszéplak alsó railway station
    {Coordinate{17.9697, 46.886}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zamárdi felső railway station
    {Coordinate{17.9448, 46.8799}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zamárdi railway station
    {Coordinate{17.8995, 46.8623}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szántód-Kőröshegy railway station
    {Coordinate{17.8799, 46.8533}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonföldvár railway station
    {Coordinate{17.8304, 46.8321}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonszárszó railway station
    {Coordinate{17.7765, 46.8119}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonszemes railway station
    {Coordinate{17.7201, 46.7947}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonlelle felső railway station
    {Coordinate{17.6945, 46.7875}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonlelle railway station
    {Coordinate{17.6472, 46.7761}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonboglár railway station
    {Coordinate{17.5926, 46.7592}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fonyódliget railway station
    {Coordinate{17.5349, 46.7376}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bélatelep railway station
    {Coordinate{17.5163, 46.7242}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsóbélatelep railway station
    {Coordinate{17.4826, 46.7136}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonfenyves railway station
    {Coordinate{17.4538, 46.7083}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonfenyves alsó railway station
    {Coordinate{17.4349, 46.7049}, Tz::Europe_Budapest, CountryId{"HU"}}, // Máriahullámtelep railway station
    {Coordinate{17.3753, 46.7042}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonmáriafürdő railway station
    {Coordinate{17.3172, 46.7138}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonberény railway station
    {Coordinate{19.4939, 46.4338}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskunhalas railway station
    {Coordinate{19.6103, 46.1948}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kelebia railway station
    {Coordinate{20.1602, 46.2419}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újszeged railway station
    {Coordinate{18.7156, 46.2025}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bátaszék railway station
    {Coordinate{18.9573, 46.1872}, Tz::Europe_Budapest, CountryId{"HU"}}, // Baja railway station
    {Coordinate{18.914, 46.9607}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunaújváros railway station
    {Coordinate{20.0667, 47.2858}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újszász railway station
    {Coordinate{19.9373, 47.7831}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyöngyös railway station
    {Coordinate{20.4127, 47.7507}, Tz::Europe_Budapest, CountryId{"HU"}}, // Füzesabony railway station
    {Coordinate{20.3816, 47.8918}, Tz::Europe_Budapest, CountryId{"HU"}}, // Eger railway station
    {Coordinate{20.254, 47.7341}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kál-Kápolna railway station
    {Coordinate{21.7055, 47.9453}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyíregyháza railway station
    {Coordinate{22.1838, 48.4019}, Tz::Europe_Budapest, CountryId{"HU"}}, // Záhony
    {Coordinate{21.1287, 47.3278}, Tz::Europe_Budapest, CountryId{"HU"}}, // Püspökladány railway station
    {Coordinate{21.7219, 47.1355}, Tz::Europe_Budapest, CountryId{"HU"}}, // Biharkeresztes raiway station
    {Coordinate{21.2632, 46.9391}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vésztő railway station
    {Coordinate{21.2733, 46.6564}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyula railway station
    {Coordinate{20.8209, 46.9272}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyoma railway station
    {Coordinate{20.93, 46.8623}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csárdaszállás railway station
    {Coordinate{20.7607, 46.5969}, Tz::Europe_Budapest, CountryId{"HU"}}, // Orosházi tanyák railway station
    {Coordinate{20.3399, 46.4133}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hódmezővásárhely railway station
    {Coordinate{17.307, 46.2891}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somogyszob railway station
    {Coordinate{17.9907, 46.0331}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentlőrinc railway station
    {Coordinate{18.4515, 45.8773}, Tz::Europe_Budapest, CountryId{"HU"}}, // Villány railway station
    {Coordinate{18.3088, 47.487}, Tz::Europe_Budapest, CountryId{"HU"}}, // Oroszlány railway station
    {Coordinate{18.372, 47.5738}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bánhida railway station
    {Coordinate{18.3337, 47.5429}, Tz::Europe_Budapest, CountryId{"HU"}}, // Környe railway station
    {Coordinate{18.317, 47.5208}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kecskéd alsó railway station
    {Coordinate{-2.43267, 47.2826}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Pouliguen train station
    {Coordinate{1.8, 42.5889}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Andorre-L'Hospitalet
    {Coordinate{2.99318, 48.8085}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2187977
    {Coordinate{-0.0769444, 49.3}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Houlgate
    {Coordinate{5.99333, 50.89}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerlen de Kissel railway station
    {Coordinate{0.116578, 46.4357}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2188462
    {Coordinate{-0.120914, 48.7151}, Tz::Europe_Paris, CountryId{"FR"}}, // Écouché
    {Coordinate{17.7888, 47.5047}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tarjánpuszta railway station
    {Coordinate{17.7989, 47.494}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győrasszonyfa railway station
    {Coordinate{16.637, 47.6327}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kópháza railway station
    {Coordinate{16.6901, 47.6011}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagycenk railway station
    {Coordinate{16.7486, 47.5475}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sopronkövesd railway station
    {Coordinate{16.7773, 47.5097}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lövő railway station
    {Coordinate{16.7866, 47.4579}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újkér railway station
    {Coordinate{16.7817, 47.4303}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tormásliget railway station
    {Coordinate{16.7522, 47.3886}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bük railway station
    {Coordinate{16.7347, 47.3084}, Tz::Europe_Budapest, CountryId{"HU"}}, // Acsád railway station
    {Coordinate{16.7038, 47.2911}, Tz::Europe_Budapest, CountryId{"HU"}}, // Salköveskút-Vassurány railway station
    {Coordinate{16.5974, 47.0161}, Tz::Europe_Budapest, CountryId{"HU"}}, // Körmend railway station
    {Coordinate{16.6418, 47.2065}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szombathely-Szőlős railway station
    {Coordinate{16.6303, 47.1614}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ják-Balogunyom railway station
    {Coordinate{16.6197, 47.091}, Tz::Europe_Budapest, CountryId{"HU"}}, // Egyházasrádóc railway station
    {Coordinate{16.5437, 47.0052}, Tz::Europe_Budapest, CountryId{"HU"}}, // Horvátnádalja railway station
    {Coordinate{16.4997, 46.9783}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csákánydoroszló railway station
    {Coordinate{16.433, 46.9676}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rátót railway station
    {Coordinate{16.3782, 46.9643}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsórönök railway station
    {Coordinate{16.2824, 46.9646}, Tz::Europe_Budapest, CountryId{"HU"}}, // Haris railway station
    {Coordinate{-0.391459, 43.2343}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gan
    {Coordinate{16.727, 47.236}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vép railway station
    {Coordinate{16.8431, 47.3006}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ölbő-Alsószeleste railway station
    {Coordinate{2.72833, 48.7453}, Tz::Europe_Paris, CountryId{"FR"}}, // Gretz-Armainvilliers Station
    {Coordinate{5.86222, 51.0603}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Susteren railway station
    {Coordinate{17.5231, 47.6576}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ikrény railway station
    {Coordinate{17.463, 47.6491}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rábapatona stop
    {Coordinate{17.4248, 47.6442}, Tz::Europe_Budapest, CountryId{"HU"}}, // Enese railway station
    {Coordinate{17.1616, 47.5928}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rábatamási railway station
    {Coordinate{17.1961, 47.596}, Tz::Europe_Budapest, CountryId{"HU"}}, // Farád railway station
    {Coordinate{17.3573, 47.6323}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kóny railway station
    {Coordinate{17.123, 47.5893}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szárföld railway station
    {Coordinate{17.0999, 47.5871}, Tz::Europe_Budapest, CountryId{"HU"}}, // Veszkény railway station
    {Coordinate{17.048, 47.5819}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kapuvár railway station
    {Coordinate{16.9868, 47.5821}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vitnyéd-Csermajor railway station
    {Coordinate{16.8895, 47.5957}, Tz::Europe_Budapest, CountryId{"HU"}}, // Petőháza railway station
    {Coordinate{16.769, 47.6002}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pinnye railway station
    {Coordinate{16.6916, 47.6251}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fertőboz railway station
    {Coordinate{16.8507, 47.618}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fertőszéplak-Fertőd railway station
    {Coordinate{16.9034, 47.7041}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Pamhagen
    {Coordinate{5.11278, 51.1903}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mol railway station
    {Coordinate{-0.698056, 49.2697}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bayeux
    {Coordinate{17.2078, 47.9734}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bezenye railway station
    {Coordinate{17.1922, 47.8898}, Tz::Europe_Budapest, CountryId{"HU"}}, // Levél railway station
    {Coordinate{17.5407, 47.6907}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abda railway station
    {Coordinate{17.4891, 47.7198}, Tz::Europe_Budapest, CountryId{"HU"}}, // Öttevény railway station
    {Coordinate{17.4253, 47.7558}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lébény-Mosonszentmiklós railway station
    {Coordinate{17.3419, 47.8045}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kimle-Károlyháza railway station
    {Coordinate{17.2664, 47.8506}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mosonmagyaróvár railway station
    {Coordinate{6.8887, 45.9396}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Praz-de-Chamonix
    {Coordinate{2.39806, 49.8461}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boves
    {Coordinate{3.09062, 45.768}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2189379
    {Coordinate{1.55278, 49.9819}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longroy-Gamaches
    {Coordinate{3.50245, 50.3299}, Tz::Europe_Paris, CountryId{"FR"}}, // Poirier-Université
    {Coordinate{21.2353, 47.2998}, Tz::Europe_Budapest, CountryId{"HU"}}, // Báránd railway station
    {Coordinate{21.5321, 47.2122}, Tz::Europe_Budapest, CountryId{"HU"}}, // Berettyóújfalu railway station
    {Coordinate{21.6256, 47.1762}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőpeterd railway station
    {Coordinate{21.3608, 47.2597}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sáp railway station
    {Coordinate{7.71804, 48.666}, Tz::Europe_Paris, CountryId{"FR"}}, // Vendenheim
    {Coordinate{9.38506, 41.1811}, Tz::Europe_Rome, CountryId{"IT"}}, // Q21903489
    {Coordinate{5.34892, 50.9896}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zonhoven railway station
    {Coordinate{6.4414, 48.178}, Tz::Europe_Paris, CountryId{"FR"}}, // Épinal railway station
    {Coordinate{4.65111, 50.7997}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Joris-Weert railway station
    {Coordinate{3.03205, 50.4453}, Tz::Europe_Paris, CountryId{"FR"}}, // Ostricourt
    {Coordinate{3.05702, 44.3247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2191151
    {Coordinate{6.07278, 51.9231}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zevenaar railway station
    {Coordinate{21.1481, 47.0152}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szeghalom railway station
    {Coordinate{21.0858, 46.9701}, Tz::Europe_Budapest, CountryId{"HU"}}, // Körösladány railway station
    {Coordinate{20.9437, 47.0343}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dévaványa railway station
    {Coordinate{20.7457, 46.9768}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagylapos railway station
    {Coordinate{4.69528, 50.8625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heverlee railway station
    {Coordinate{-4.09222, 47.9947}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quimper
    {Coordinate{-1.31393, 47.8321}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2191724
    {Coordinate{0.81022, 48.3261}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2192067
    {Coordinate{-0.930065, 45.6666}, Tz::Europe_Paris, CountryId{"FR"}}, // Saujon
    {Coordinate{19.2564, 47.4085}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vecsés railway station
    {Coordinate{19.2728, 47.4033}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vecsés-Kertekalja railway station
    {Coordinate{19.3509, 47.3908}, Tz::Europe_Budapest, CountryId{"HU"}}, // Üllő railway station
    {Coordinate{19.3902, 47.3703}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hosszúberek-Péteri railway station
    {Coordinate{19.4373, 47.3451}, Tz::Europe_Budapest, CountryId{"HU"}}, // Monor railway station
    {Coordinate{19.4999, 47.3085}, Tz::Europe_Budapest, CountryId{"HU"}}, // Monorierdő railway station
    {Coordinate{19.5371, 47.2794}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pilis railway station
    {Coordinate{19.6068, 47.24}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21921442
    {Coordinate{19.6577, 47.2163}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21921444
    {Coordinate{19.6861, 47.2108}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ceglédbercel-Cserő railway station
    {Coordinate{19.7324, 47.2084}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budai út railway station
    {Coordinate{20.0161, 47.1732}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abony railway station
    {Coordinate{30.4717, 60.0944}, Tz::Europe_Moscow, CountryId{"RU"}}, // Kapitolovo
    {Coordinate{20.2953, 47.1704}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szajol railway station
    {Coordinate{20.3696, 47.1357}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszatenyő railway station
    {Coordinate{20.4112, 47.1696}, Tz::Europe_Budapest, CountryId{"HU"}}, // Törökszentmiklós railway station
    {Coordinate{30.1139, 60.6319}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q219220
    {Coordinate{30.5088, 60.1492}, Tz::Europe_Moscow, CountryId{"RU"}}, // Toksovo station
    {Coordinate{0.0841667, 49.36}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Trouville-Deauville
    {Coordinate{1.26417, 43.9239}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montbartier
    {Coordinate{20.4878, 47.077}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kétpó railway station
    {Coordinate{20.5414, 47.0503}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csugar railway station
    {Coordinate{20.4558, 47.093}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztapó railway station
    {Coordinate{20.6195, 47.0135}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőtúr railway station
    {Coordinate{21.0129, 46.8147}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőberény station
    {Coordinate{21.038, 46.757}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21923133
    {Coordinate{21.2376, 46.4321}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lőkösháza railway station
    {Coordinate{21.1718, 46.5326}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21923139
    {Coordinate{20.1251, 47.2066}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abonyi út railway station
    {Coordinate{20.0974, 47.2443}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zagyvarékas railway station
    {Coordinate{2.47627, 46.3715}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2192387
    {Coordinate{19.3148, 47.4406}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ecser railway station
    {Coordinate{19.3407, 47.4389}, Tz::Europe_Budapest, CountryId{"HU"}}, // Maglód railway station
    {Coordinate{19.3635, 47.4342}, Tz::Europe_Budapest, CountryId{"HU"}}, // Maglódi nyaraló railway station
    {Coordinate{19.3939, 47.4296}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyömrő railway station
    {Coordinate{19.4398, 47.4267}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mende railway station
    {Coordinate{19.4707, 47.4396}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztaszenistván railway station
    {Coordinate{19.5271, 47.4518}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sülysáp railway station
    {Coordinate{19.5594, 47.4507}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szőlősnyaraló railway station
    {Coordinate{19.6205, 47.4413}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tápiószecső railway station
    {Coordinate{19.6798, 47.4322}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentmártonkáta railway station
    {Coordinate{19.7376, 47.4099}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagykáta railway station
    {Coordinate{19.7974, 47.3737}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tápiószentmárton railway station
    {Coordinate{19.8374, 47.3554}, Tz::Europe_Budapest, CountryId{"HU"}}, // Farmos railway station
    {Coordinate{19.8737, 47.3462}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tápiószele railway station
    {Coordinate{19.9494, 47.325}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tápiógyörgye railway station
    {Coordinate{19.7602, 47.0382}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagykőrös railway station
    {Coordinate{2.0763, 50.8755}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Audruicq
    {Coordinate{6.663, 50.698}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zülpich
    {Coordinate{2.18783, 48.8121}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2193360
    {Coordinate{3.27056, 49.6922}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mennessis
    {Coordinate{5.82861, 49.5633}, Tz::Europe_Brussels, CountryId{"BE"}}, // Athus railway station
    {Coordinate{5.41111, 53.1747}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Harlingen Haven railway station
    {Coordinate{-0.627669, 44.8426}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2194618
    {Coordinate{19.8925, 47.4955}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászberény railway station
    {Coordinate{19.7943, 47.5642}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztamonostor railway station
    {Coordinate{19.9395, 47.4411}, Tz::Europe_Budapest, CountryId{"HU"}}, // Meggyespele railway station
    {Coordinate{19.7542, 47.5931}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászfényszaru railway station
    {Coordinate{0.908147, 44.8471}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Buisson
    {Coordinate{19.9587, 47.418}, Tz::Europe_Budapest, CountryId{"HU"}}, // Portelek railway station
    {Coordinate{20.001, 47.3675}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászboldogháza-Jánoshida railway station
    {Coordinate{-1.65431, 48.2395}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-sur-Ille
    {Coordinate{10.8122, 44.5611}, Tz::Europe_Rome, CountryId{"IT"}}, // Fiorano railway halt
    {Coordinate{10.846, 44.5777}, Tz::Europe_Rome, CountryId{"IT"}}, // Formigine railway station
    {Coordinate{4.22139, 51.1261}, Tz::Europe_Brussels, CountryId{"BE"}}, // Temse railway station
    {Coordinate{4.54947, 50.6935}, Tz::Europe_Brussels, CountryId{"BE"}}, // Profondsart railway station
    {Coordinate{1.78556, 50.8731}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pihen
    {Coordinate{5.96118, 46.1447}, Tz::Europe_Paris, CountryId{"FR"}}, // Pougny - Chancy
    {Coordinate{5.8251, 43.1225}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2195891
    {Coordinate{3.06666, 46.1993}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bellenaves
    {Coordinate{2.19139, 48.7047}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Guichet
    {Coordinate{4.46694, 51.3908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kalmthout railway station
    {Coordinate{28.2339, 59.3678}, Tz::Europe_Moscow, CountryId{"RU"}}, // Ivangorod railway station
    {Coordinate{2.70417, 48.2294}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bagneaux-sur-Loing
    {Coordinate{4.76264, 50.4432}, Tz::Europe_Brussels, CountryId{"BE"}}, // Floreffe railway station
    {Coordinate{10.736, 44.5854}, Tz::Europe_Rome, CountryId{"IT"}}, // Casalgrande railway station
    {Coordinate{1.53694, 50.0589}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Woincourt
    {Coordinate{10.694, 44.6004}, Tz::Europe_Rome, CountryId{"IT"}}, // Scandiano railway station
    {Coordinate{24.3167, 49.4}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q21980526
    {Coordinate{4.81111, 52.8669}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Anna Paulowna railway station
    {Coordinate{3.44909, 51.092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aalter railway station
    {Coordinate{0.329707, 43.1035}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Capvern
    {Coordinate{24.4159, 59.3061}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2198819
    {Coordinate{19.8343, 46.7071}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskunfélegyháza railway station
    {Coordinate{7.57224, 48.7552}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2198911
    {Coordinate{2.40306, 48.7122}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2199402
    {Coordinate{16.3718, 39.0808}, Tz::Europe_Rome, CountryId{"IT"}}, // Soveria Mannelli
    {Coordinate{20.044, 46.3457}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szatymaz railway station
    {Coordinate{2.43361, 48.7653}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2199518
    {Coordinate{20.541, 46.5041}, Tz::Europe_Budapest, CountryId{"HU"}}, // Székkutas railway station
    {Coordinate{19.909, 46.5383}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csengele railway station
    {Coordinate{4.06479, 48.2959}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Troyes
    {Coordinate{18.6474, 47.7414}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996736
    {Coordinate{18.6747, 47.7346}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996752
    {Coordinate{18.5616, 47.7612}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996758
    {Coordinate{18.5408, 47.7624}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996760
    {Coordinate{18.53, 47.7555}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996765
    {Coordinate{18.4779, 47.7532}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996775
    {Coordinate{18.4376, 47.7569}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996776
    {Coordinate{18.5147, 47.7522}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lábatlan railway station
    {Coordinate{18.4549, 47.7613}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996779
    {Coordinate{18.3679, 47.7375}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996780
    {Coordinate{18.3452, 47.7344}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21996781
    {Coordinate{18.3262, 47.733}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunaalmás railway station
    {Coordinate{18.2479, 47.3172}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bodajk railway station
    {Coordinate{18.0507, 47.6309}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyigmánd-Bábolna railway station
    {Coordinate{18.0249, 47.4942}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisbér railway station
    {Coordinate{18.1032, 47.4439}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonysárkány railway station
    {Coordinate{18.1887, 47.3695}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mór railway station
    {Coordinate{18.2376, 47.3299}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csókakő railway station
    {Coordinate{18.1432, 47.7369}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szőny-Déli railway station
    {Coordinate{18.9239, 47.3799}, Tz::Europe_Budapest, CountryId{"HU"}}, // Érd alsó railway station
    {Coordinate{18.8479, 47.1062}, Tz::Europe_Budapest, CountryId{"HU"}}, // Adony railway station
    {Coordinate{18.8974, 47.051}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kulcs railway station
    {Coordinate{18.9098, 47.0243}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rácalmás railway station
    {Coordinate{18.9036, 46.9829}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunaújváros külső railway station
    {Coordinate{18.6128, 47.1193}, Tz::Europe_Budapest, CountryId{"HU"}}, // Seregélyes-Szőlőhegy railway station
    {Coordinate{18.5816, 47.1209}, Tz::Europe_Budapest, CountryId{"HU"}}, // Seregélyes train station
    {Coordinate{18.5151, 47.1401}, Tz::Europe_Budapest, CountryId{"HU"}}, // Börgönd railway station
    {Coordinate{18.6119, 46.8968}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sárbogárd railway station
    {Coordinate{18.4997, 47.1029}, Tz::Europe_Budapest, CountryId{"HU"}}, // Belsőbáránd railway station
    {Coordinate{18.5424, 47.0237}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aba-Sárkereszúr railway station
    {Coordinate{18.6236, 46.7723}, Tz::Europe_Budapest, CountryId{"HU"}}, // Cece railway station
    {Coordinate{18.648, 46.7142}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vajta railway station
    {Coordinate{18.7289, 46.3809}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szekszárd-Palánk railway station
    {Coordinate{18.6497, 46.6154}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagydorog railway station
    {Coordinate{18.6951, 46.5158}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tengelic railway station
    {Coordinate{18.7358, 46.4489}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fácánkert railway station
    {Coordinate{18.7501, 46.4148}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tolna-Mözs railway station
    {Coordinate{18.7425, 46.3188}, Tz::Europe_Budapest, CountryId{"HU"}}, // Őcsény railway station
    {Coordinate{18.7561, 46.2838}, Tz::Europe_Budapest, CountryId{"HU"}}, // Decs railway station
    {Coordinate{18.7382, 46.1994}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsónyék railway station
    {Coordinate{18.8279, 46.1991}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pörböly railway station
    {Coordinate{18.9211, 46.1931}, Tz::Europe_Budapest, CountryId{"HU"}}, // Baja-Dunafürdő railway station
    {Coordinate{18.1528, 46.3371}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csikóstőttős railway station
    {Coordinate{18.2222, 46.3103}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mágocs-Alsómocsolád railway station
    {Coordinate{18.289, 46.2846}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szalatnak railway station
    {Coordinate{18.3698, 46.2874}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szászvár railway station
    {Coordinate{18.409, 46.2791}, Tz::Europe_Budapest, CountryId{"HU"}}, // Máza-Szászvár railway station
    {Coordinate{18.4368, 46.2811}, Tz::Europe_Budapest, CountryId{"HU"}}, // Váralja railway station
    {Coordinate{18.4571, 46.2796}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagymányok railway station
    {Coordinate{18.5233, 46.2691}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hidas-Bonyhád railway station
    {Coordinate{18.5574, 46.2635}, Tz::Europe_Budapest, CountryId{"HU"}}, // Cikó railway station
    {Coordinate{18.5945, 46.257}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mőcsény railway station
    {Coordinate{6.36617, 46.2701}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bons-en-Chablais
    {Coordinate{18.1431, 46.3309}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposszekcső railway station
    {Coordinate{18.1387, 46.3102}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vásárosdombó railway station
    {Coordinate{18.1045, 46.2572}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sásd railway station
    {Coordinate{18.1047, 46.2233}, Tz::Europe_Budapest, CountryId{"HU"}}, // Godisa railway station
    {Coordinate{18.0838, 46.2026}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szatina-Kishajmás railway station
    {Coordinate{18.0753, 46.1527}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abaliget railway station
    {Coordinate{18.045, 46.1282}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hethehely railway station
    {Coordinate{17.9874, 46.0855}, Tz::Europe_Budapest, CountryId{"HU"}}, // Cserdi-Helesfa railway station
    {Coordinate{17.9994, 46.113}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bükkösd railway station
    {Coordinate{18.054, 46.041}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bicsérd railway station
    {Coordinate{18.1521, 46.0602}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mecsekalja-Cserkút railway station
    {Coordinate{18.5891, 46.7826}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q21999784
    {Coordinate{5.76494, 46.9125}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2199980
    {Coordinate{18.5408, 46.7565}, Tz::Europe_Budapest, CountryId{"HU"}}, // Simontornya railway station
    {Coordinate{8.73972, 50.105}, Tz::Europe_Berlin, CountryId{"DE"}}, // Offenbach-Kaiserlei station
    {Coordinate{6.42513, 51.3679}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2200101
    {Coordinate{2.27067, 48.8394}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Pont du Garigliano
    {Coordinate{6.46639, 51.1033}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hochneukirch station
    {Coordinate{18.4774, 46.7289}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002084
    {Coordinate{18.4301, 46.6812}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002085
    {Coordinate{18.4113, 46.6396}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002086
    {Coordinate{18.4264, 46.5973}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002087
    {Coordinate{18.4204, 46.5753}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002088
    {Coordinate{18.3963, 46.5688}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002090
    {Coordinate{18.3893, 46.5238}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002091
    {Coordinate{18.3356, 46.4662}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002092
    {Coordinate{18.3184, 46.4503}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002093
    {Coordinate{18.253, 46.4164}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002094
    {Coordinate{18.3774, 46.4942}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22002127
    {Coordinate{18.7044, 47.0827}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szabadegyháza railway station
    {Coordinate{18.6602, 47.0396}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sárosd railway station
    {Coordinate{18.6357, 46.9793}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagylók railway station
    {Coordinate{17.8592, 45.8732}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sellye railway station
    {Coordinate{17.8523, 45.9048}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kákics railway station
    {Coordinate{17.8649, 45.9338}, Tz::Europe_Budapest, CountryId{"HU"}}, // Okorág-Kárászpuszta railway station
    {Coordinate{17.9117, 45.9607}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sumony railway station
    {Coordinate{17.9569, 45.983}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyöngyfa-Magyarmecske railway station
    {Coordinate{17.9723, 45.9894}, Tz::Europe_Budapest, CountryId{"HU"}}, // Királyegyháza-Rigópuszta railway station
    {Coordinate{18.2401, 46.0717}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pécs-Külváros railway station
    {Coordinate{18.2701, 46.064}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pécsbánya-Rendező railway station
    {Coordinate{18.2755, 46.0093}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pécsudvard railway station
    {Coordinate{18.2906, 45.967}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szőkéd railway station
    {Coordinate{18.307, 45.9358}, Tz::Europe_Budapest, CountryId{"HU"}}, // Áta railway station
    {Coordinate{18.3153, 45.9095}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kistótfalu railway station
    {Coordinate{18.3343, 45.8995}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vokány railway station
    {Coordinate{18.3941, 45.8914}, Tz::Europe_Budapest, CountryId{"HU"}}, // Palkonya railway station
    {Coordinate{18.4263, 45.8798}, Tz::Europe_Budapest, CountryId{"HU"}}, // Villánykövesd railway station
    {Coordinate{18.4907, 45.835}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarbóly railway station
    {Coordinate{18.4991, 45.8868}, Tz::Europe_Budapest, CountryId{"HU"}}, // Márok railway station
    {Coordinate{18.5383, 45.9376}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bóly railway station
    {Coordinate{18.5649, 45.9534}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagynyárád railway station
    {Coordinate{18.6692, 45.9959}, Tz::Europe_Budapest, CountryId{"HU"}}, // Középmező railway station
    {Coordinate{18.6845, 46.0025}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mohács railway station
    {Coordinate{17.4469, 45.9518}, Tz::Europe_Budapest, CountryId{"HU"}}, // Barcs railway station
    {Coordinate{17.4862, 45.9583}, Tz::Europe_Budapest, CountryId{"HU"}}, // Barcs felső railway station
    {Coordinate{17.5986, 45.9922}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22003448
    {Coordinate{17.5249, 45.9705}, Tz::Europe_Budapest, CountryId{"HU"}}, // Középrigóc railway station
    {Coordinate{17.6671, 46.012}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisdobsza railway station
    {Coordinate{17.802, 46.0431}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szigetvár railway station
    {Coordinate{17.8979, 46.0381}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagypeterd railway station
    {Coordinate{17.7073, 46.0236}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nemeske railway station
    {Coordinate{17.7484, 46.0352}, Tz::Europe_Budapest, CountryId{"HU"}}, // Molvány railway station
    {Coordinate{17.9271, 46.0365}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentdénes railway station
    {Coordinate{17.1795, 46.1632}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somogyudvarhely railway station
    {Coordinate{17.2078, 46.1229}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22003646
    {Coordinate{17.3425, 46.0284}, Tz::Europe_Budapest, CountryId{"HU"}}, // Babócsa railway station
    {Coordinate{17.3581, 46.0067}, Tz::Europe_Budapest, CountryId{"HU"}}, // Péterhida-Komlósd railway station
    {Coordinate{17.1435, 46.2012}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22003650
    {Coordinate{17.2395, 46.1013}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22003652
    {Coordinate{6.19889, 51.6236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weeze railway station
    {Coordinate{0.596937, 43.6473}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2200917
    {Coordinate{6.78912, 51.2119}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Friedrichstadt station
    {Coordinate{4.36194, 50.8522}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels Congress railway station
    {Coordinate{3.69649, 43.4128}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sète
    {Coordinate{0.77258, 49.0743}, Tz::Europe_Paris, CountryId{"FR"}}, // Beaumont-le-Roger
    {Coordinate{7.09567, 48.7429}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2202248
    {Coordinate{19.3756, 47.5643}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gödöllő-Állami telepek railway station
    {Coordinate{19.5259, 47.6389}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hévízgyörk railway station
    {Coordinate{19.0403, 47.8313}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarkút-Verőce railway station
    {Coordinate{19.0467, 47.8491}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarkút railway station
    {Coordinate{19.0306, 47.8711}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szokolya railway station
    {Coordinate{19.0713, 47.8855}, Tz::Europe_Budapest, CountryId{"HU"}}, // Berkenye railway station
    {Coordinate{19.0471, 47.9022}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nógrád railway station
    {Coordinate{19.057, 48.0424}, Tz::Europe_Budapest, CountryId{"HU"}}, // Drégely railway station
    {Coordinate{19.0467, 48.0548}, Tz::Europe_Budapest, CountryId{"HU"}}, // Drégelypalánk railway station
    {Coordinate{19.1964, 48.0455}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dejtár railway station
    {Coordinate{19.0947, 47.9733}, Tz::Europe_Budapest, CountryId{"HU"}}, // Borsosberény railway station
    {Coordinate{19.1007, 47.9939}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyoroszi railway station
    {Coordinate{19.0796, 48.002}, Tz::Europe_Budapest, CountryId{"HU"}}, // Drégelyvár railway station
    {Coordinate{19.1072, 48.0574}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ipolyvece railway station
    {Coordinate{19.2239, 48.0546}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ipolyszög railway station
    {Coordinate{19.0443, 48.0286}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sáferkút railway station
    {Coordinate{2.99019, 50.6069}, Tz::Europe_Paris, CountryId{"FR"}}, // Haubourdin
    {Coordinate{19.4038, 48.0788}, Tz::Europe_Budapest, CountryId{"HU"}}, // Őrhalom railway station
    {Coordinate{19.4239, 48.0829}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hugyag railway station
    {Coordinate{19.5212, 48.0925}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szécsény railway station
    {Coordinate{19.5295, 48.1325}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ludányhalászi railway station
    {Coordinate{19.5217, 48.1781}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nógrádszakál railway station
    {Coordinate{19.5413, 48.2072}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ráróspuszta railway station
    {Coordinate{19.5987, 48.2159}, Tz::Europe_Budapest, CountryId{"HU"}}, // Litke railway station
    {Coordinate{19.6291, 48.2366}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ipolytarnóc railway station
    {Coordinate{19.4441, 47.6582}, Tz::Europe_Budapest, CountryId{"HU"}}, // Iklad-Domony railway station
    {Coordinate{19.4284, 47.6678}, Tz::Europe_Budapest, CountryId{"HU"}}, // Iklad-Domony felső railway station
    {Coordinate{19.3925, 47.6941}, Tz::Europe_Budapest, CountryId{"HU"}}, // Galgamácsa railway station
    {Coordinate{19.3861, 47.801}, Tz::Europe_Budapest, CountryId{"HU"}}, // Acsa-Erdőkürt railway station
    {Coordinate{19.3861, 47.8463}, Tz::Europe_Budapest, CountryId{"HU"}}, // Galgaguta railway station
    {Coordinate{19.3673, 47.8956}, Tz::Europe_Budapest, CountryId{"HU"}}, // Becske alsó railway station
    {Coordinate{19.3331, 48.0363}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szügy railway station
    {Coordinate{19.3722, 47.7353}, Tz::Europe_Budapest, CountryId{"HU"}}, // Galgagyörk railway station
    {Coordinate{19.3688, 47.7728}, Tz::Europe_Budapest, CountryId{"HU"}}, // Püspökhatvan railway station
    {Coordinate{19.3712, 47.8795}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nógrádkövesd railway station
    {Coordinate{19.358, 47.9723}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarnándor railway station
    {Coordinate{19.3465, 47.9967}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mohora railway station
    {Coordinate{0.952409, 45.8781}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2202693
    {Coordinate{4.43417, 51.2817}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ekeren railway station
    {Coordinate{2.29051, 48.5333}, Tz::Europe_Paris, CountryId{"FR"}}, // Bouray (Paris RER)
    {Coordinate{5.89222, 50.9197}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nuth railway station
    {Coordinate{19.0648, 47.2745}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunavarsány railway station
    {Coordinate{19.0794, 47.1104}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dömsöd railway station
    {Coordinate{19.1002, 47.0183}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kunszentmiklós-Tass railway station
    {Coordinate{19.0966, 47.3528}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunaharaszti railway station
    {Coordinate{19.0767, 47.3205}, Tz::Europe_Budapest, CountryId{"HU"}}, // Taksony railway station
    {Coordinate{19.087, 47.3404}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dunaharaszti alsó railway station
    {Coordinate{19.0608, 47.2536}, Tz::Europe_Budapest, CountryId{"HU"}}, // Délegyháza railway station
    {Coordinate{19.0437, 47.185}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskunlacháza railway station
    {Coordinate{19.7189, 46.9632}, Tz::Europe_Budapest, CountryId{"HU"}}, // Katonatelep railway station
    {Coordinate{19.1597, 46.9383}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bösztör railway station
    {Coordinate{19.2101, 46.8704}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szabadszállás railway station
    {Coordinate{19.2636, 46.7685}, Tz::Europe_Budapest, CountryId{"HU"}}, // Soltszentimre railway station
    {Coordinate{19.4344, 46.5213}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pirtói szőlők railway station
    {Coordinate{19.5331, 46.3493}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balotaszállás railway station
    {Coordinate{19.5772, 46.2335}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tompa railway station
    {Coordinate{19.5387, 46.2788}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisszállás railway station
    {Coordinate{19.2469, 46.8212}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fülöpszállás railway station
    {Coordinate{19.2826, 46.6798}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tabdi railway station
    {Coordinate{3.24132, 50.1768}, Tz::Europe_Paris, CountryId{"FR"}}, // Cambrai-Ville railway station
    {Coordinate{19.3954, 46.5698}, Tz::Europe_Budapest, CountryId{"HU"}}, // Soltvadkert railway station
    {Coordinate{19.2745, 46.7175}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csengőd railway station
    {Coordinate{19.2974, 46.6262}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskőrös railway station
    {Coordinate{19.4501, 46.4989}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pirtó railway station
    {Coordinate{6.99796, 51.3868}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Werden station
    {Coordinate{5.02561, 43.3929}, Tz::Europe_Paris, CountryId{"FR"}}, // Martigues train station
    {Coordinate{6.75694, 51.1422}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuss Allerheiligen station
    {Coordinate{4.77952, 45.7657}, Tz::Europe_Paris, CountryId{"FR"}}, // railway station of Écully-la-Demi-Lune
    {Coordinate{19.1601, 46.1156}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bácsbokod-Bácsborsód railway station
    {Coordinate{19.3286, 46.1162}, Tz::Europe_Budapest, CountryId{"HU"}}, // Almás railway station
    {Coordinate{19.3465, 46.1176}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bácsalmás railway station
    {Coordinate{19.3704, 46.2129}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mélykút railway station
    {Coordinate{19.3305, 46.2927}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jánoshalma railway station
    {Coordinate{19.3949, 46.3294}, Tz::Europe_Budapest, CountryId{"HU"}}, // Erdőszél railway station
    {Coordinate{19.4169, 46.3559}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kunfehértó railway station
    {Coordinate{19.6019, 46.4586}, Tz::Europe_Budapest, CountryId{"HU"}}, // Harkakötöny railway station
    {Coordinate{19.6502, 46.4725}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tajó railway station
    {Coordinate{19.7538, 46.5663}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászszentlászló railway station
    {Coordinate{19.7355, 46.5383}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskunmajsa railway station
    {Coordinate{19.8012, 46.6252}, Tz::Europe_Budapest, CountryId{"HU"}}, // Galambos railway station
    {Coordinate{19.9324, 47.7443}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyöngyöshalász railway station
    {Coordinate{19.9353, 47.7666}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kitérőgyár railway station
    {Coordinate{19.9276, 47.686}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vámosgyörk railway station
    {Coordinate{19.9702, 47.6361}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászárokszállás railway station
    {Coordinate{20.0285, 47.5628}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászdózsa railway station
    {Coordinate{20.2036, 47.456}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászkisér railway station
    {Coordinate{20.2024, 47.4382}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászkisér felső railway station
    {Coordinate{20.0909, 47.3206}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szászberek railway station
    {Coordinate{20.1552, 47.5136}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászapáti railway station
    {Coordinate{20.189, 47.4256}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szellőhát railway station
    {Coordinate{20.1586, 47.3729}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jászladány railway station
    {Coordinate{19.7972, 47.6723}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22039452
    {Coordinate{20.4022, 47.8524}, Tz::Europe_Budapest, CountryId{"HU"}}, // Andornaktálya railway station
    {Coordinate{20.4046, 47.808}, Tz::Europe_Budapest, CountryId{"HU"}}, // Maklár railway station
    {Coordinate{20.3808, 47.9075}, Tz::Europe_Budapest, CountryId{"HU"}}, // Egervár railway station
    {Coordinate{20.3707, 47.9366}, Tz::Europe_Budapest, CountryId{"HU"}}, // Eger-Felnémet railway station
    {Coordinate{20.3326, 47.9884}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szarvaskő railway station
    {Coordinate{20.3298, 48.0321}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mónosbél railway station
    {Coordinate{20.3556, 48.0584}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bélapátfalvi Cementgyár railway station
    {Coordinate{20.3825, 48.0956}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szilvásvárad-Szalajkavölgy railway station
    {Coordinate{20.3577, 47.9549}, Tz::Europe_Budapest, CountryId{"HU"}}, // Almár railway station
    {Coordinate{20.3406, 48.0559}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bélapátfalva railway station
    {Coordinate{20.379, 48.1135}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szilvásvárad railway station
    {Coordinate{21.03, 47.9261}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaújváros railway station
    {Coordinate{20.9893, 47.9425}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sajószöged railway station
    {Coordinate{20.9464, 47.9537}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagycsécs railway station
    {Coordinate{20.8697, 47.9604}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hejőkeresztúr railway station
    {Coordinate{20.8403, 47.9926}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyékládháza railway station
    {Coordinate{20.4928, 47.7672}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szihalom railway station
    {Coordinate{19.9756, 47.6967}, Tz::Europe_Budapest, CountryId{"HU"}}, // Adács railway station
    {Coordinate{20.045, 47.7171}, Tz::Europe_Budapest, CountryId{"HU"}}, // Karácsond railway station
    {Coordinate{20.0956, 47.724}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ludas railway station
    {Coordinate{20.1621, 47.7266}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyút railway station
    {Coordinate{0.00972222, 49.3161}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villers-sur-Mer
    {Coordinate{2.41778, 48.7461}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Saules
    {Coordinate{20.021, 46.689}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kettőshalom railway station
    {Coordinate{19.866, 46.6974}, Tz::Europe_Budapest, CountryId{"HU"}}, // Városi park railway station
    {Coordinate{19.9229, 46.6902}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csongrádi úti tanyák railway station
    {Coordinate{19.9623, 46.685}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gátér railway station
    {Coordinate{20.0597, 46.695}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kónyaszék railway station
    {Coordinate{20.1278, 46.7114}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csongrád alsó railway station
    {Coordinate{20.1404, 46.7044}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csongrád railway station
    {Coordinate{20.2669, 46.6751}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hékéd railway station
    {Coordinate{20.3128, 46.4033}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hódmezővásárhelyi Népkert railway station
    {Coordinate{20.2493, 46.5885}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22043851
    {Coordinate{20.2251, 46.5643}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22043855
    {Coordinate{20.1939, 46.524}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22043856
    {Coordinate{20.2362, 46.4733}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mártély railway station
    {Coordinate{20.452, 46.4594}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kútvölgy railway station
    {Coordinate{20.1252, 46.2662}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szeged-Rókus railway station
    {Coordinate{20.196, 46.3355}, Tz::Europe_Budapest, CountryId{"HU"}}, // Algyő railway station
    {Coordinate{20.6645, 46.5662}, Tz::Europe_Budapest, CountryId{"HU"}}, // Orosháza railway station
    {Coordinate{20.8409, 46.6235}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csorvás railway station
    {Coordinate{20.8898, 46.6351}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csorvás alsó railway station
    {Coordinate{20.9639, 46.6559}, Tz::Europe_Budapest, CountryId{"HU"}}, // Telekgerendás railway station
    {Coordinate{21.0234, 46.6724}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fürjes railway station
    {Coordinate{20.3682, 46.6699}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dónát railway station
    {Coordinate{20.4073, 46.6764}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22045696
    {Coordinate{20.4566, 46.67}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fábiánsebestyén railway station
    {Coordinate{20.6283, 46.5909}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentetornya railway station
    {Coordinate{20.5882, 46.6566}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gádoros railway station
    {Coordinate{20.5362, 46.6605}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22045704
    {Coordinate{20.6164, 46.6196}, Tz::Europe_Budapest, CountryId{"HU"}}, // Justhmajor railway station
    {Coordinate{20.6306, 46.5677}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyopárosfürdő railway station
    {Coordinate{1.34194, 43.7858}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Castelnau-d'Estrétefonds
    {Coordinate{21.1795, 46.6598}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046606
    {Coordinate{21.3329, 46.7046}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046607
    {Coordinate{21.1657, 46.66}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046608
    {Coordinate{21.3228, 46.6949}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046610
    {Coordinate{21.3839, 46.7298}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046611
    {Coordinate{21.3988, 46.7355}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046612
    {Coordinate{21.4796, 46.7586}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046613
    {Coordinate{21.4556, 46.7743}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046614
    {Coordinate{21.417, 46.8232}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22046615
    {Coordinate{21.3392, 46.8925}, Tz::Europe_Budapest, CountryId{"HU"}}, // Okány railway station
    {Coordinate{2.0888, 49.4265}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Beauvais
    {Coordinate{21.2016, 47.0937}, Tz::Europe_Budapest, CountryId{"HU"}}, // Füzesgyarmatfürdő railway station
    {Coordinate{21.1943, 47.1131}, Tz::Europe_Budapest, CountryId{"HU"}}, // Füzesgyarmat railway station
    {Coordinate{21.2218, 47.2088}, Tz::Europe_Budapest, CountryId{"HU"}}, // Biharnagybajom railway station
    {Coordinate{21.1807, 47.2314}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sárrétudvari railway station
    {Coordinate{21.1458, 47.2344}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szerep railway station
    {Coordinate{21.1019, 47.2356}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hosszúhát railway station
    {Coordinate{21.0914, 47.2673}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ürmöshát railway station
    {Coordinate{21.0961, 47.3191}, Tz::Europe_Budapest, CountryId{"HU"}}, // Püspökladány-Vásártér railway station
    {Coordinate{20.929, 47.3033}, Tz::Europe_Budapest, CountryId{"HU"}}, // Karcag railway station
    {Coordinate{20.9071, 47.3219}, Tz::Europe_Budapest, CountryId{"HU"}}, // Karcag-Vásártér railway station
    {Coordinate{20.7498, 47.4535}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22047644
    {Coordinate{20.7372, 47.616}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22047645
    {Coordinate{20.8272, 47.3749}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22047647
    {Coordinate{20.7333, 47.4909}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22047648
    {Coordinate{20.7282, 47.5552}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaszőlős railway station
    {Coordinate{20.7558, 47.6279}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszafüred railway station
    {Coordinate{20.793, 47.4152}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22047651
    {Coordinate{20.6655, 47.3249}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bánhalma-Halastó railway station
    {Coordinate{20.6864, 47.2543}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kenderes railway station
    {Coordinate{20.7511, 47.2239}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisújszállás railway station
    {Coordinate{20.3664, 47.5618}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hevesvezekény railway station
    {Coordinate{20.3903, 47.5472}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tarnaszentmiklós railway station
    {Coordinate{20.4815, 47.4954}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisköre railway station
    {Coordinate{20.5079, 47.4808}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisköre-Tiszahíd railway station
    {Coordinate{20.5532, 47.4553}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abádszalók railway station
    {Coordinate{20.6409, 47.3765}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kunhegyes railway station
    {Coordinate{20.654, 47.3634}, Tz::Europe_Budapest, CountryId{"HU"}}, // Előhát railway station
    {Coordinate{20.3062, 47.6094}, Tz::Europe_Budapest, CountryId{"HU"}}, // Heves railway station
    {Coordinate{20.3024, 47.6832}, Tz::Europe_Budapest, CountryId{"HU"}}, // Erdőtelek railway station
    {Coordinate{14.7848, 41.0151}, Tz::Europe_Rome, CountryId{"IT"}}, // Altavilla Irpina railway station
    {Coordinate{14.8427, 40.9885}, Tz::Europe_Rome, CountryId{"IT"}}, // Prata-Pratola railway station
    {Coordinate{14.7865, 41.0805}, Tz::Europe_Rome, CountryId{"IT"}}, // Montorsi railway halt
    {Coordinate{14.8159, 41.0138}, Tz::Europe_Rome, CountryId{"IT"}}, // Tufo railway station
    {Coordinate{14.8276, 40.9507}, Tz::Europe_Rome, CountryId{"IT"}}, // Montefredane railway station
    {Coordinate{20.0932, 47.1759}, Tz::Europe_Budapest, CountryId{"HU"}}, // Paládicspuszta railway station
    {Coordinate{4.04082, 49.1665}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2205349
    {Coordinate{20.5576, 47.1944}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fegyvernek-Örményes railway station
    {Coordinate{21.2593, 47.3689}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaba railway station
    {Coordinate{21.4069, 47.4293}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúszoboszló railway station
    {Coordinate{21.4886, 47.4626}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ebes railway station
    {Coordinate{6.43464, 47.1298}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avoudrey
    {Coordinate{21.6479, 47.5405}, Tz::Europe_Budapest, CountryId{"HU"}}, // Debrecen-Csapókert railway station
    {Coordinate{21.6558, 47.584}, Tz::Europe_Budapest, CountryId{"HU"}}, // Apafa railway station
    {Coordinate{21.666, 47.6403}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bocskaikert railway station
    {Coordinate{21.6848, 47.7146}, Tz::Europe_Budapest, CountryId{"HU"}}, // Téglás railway station
    {Coordinate{21.6793, 47.6868}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúhadház railway station
    {Coordinate{21.7065, 47.8148}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újfehértó railway station
    {Coordinate{21.729, 47.9971}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sóstó railway station
    {Coordinate{21.884, 48.0933}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054861
    {Coordinate{21.8016, 48.0654}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054862
    {Coordinate{21.7428, 48.0123}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054863
    {Coordinate{21.9269, 48.1116}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054864
    {Coordinate{21.9526, 48.1287}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054865
    {Coordinate{21.855, 48.0823}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054866
    {Coordinate{21.9968, 48.1587}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054869
    {Coordinate{22.0464, 48.1855}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054870
    {Coordinate{22.079, 48.209}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054871
    {Coordinate{22.0918, 48.2283}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054872
    {Coordinate{22.1072, 48.2674}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054873
    {Coordinate{22.1182, 48.3051}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054874
    {Coordinate{22.1316, 48.3424}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054875
    {Coordinate{22.1449, 48.3713}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22054876
    {Coordinate{21.7401, 47.9431}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056021
    {Coordinate{21.8732, 47.9487}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056026
    {Coordinate{22.2033, 48.0591}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056041
    {Coordinate{21.8064, 47.9458}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056049
    {Coordinate{21.9391, 47.9538}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056064
    {Coordinate{22.0413, 47.9406}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056069
    {Coordinate{22.0713, 47.9516}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056071
    {Coordinate{22.0834, 47.9886}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056073
    {Coordinate{22.1635, 48.0065}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056075
    {Coordinate{22.178, 48.0221}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056077
    {Coordinate{22.2513, 48.0821}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056081
    {Coordinate{22.3058, 48.1266}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056084
    {Coordinate{21.9937, 47.948}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056099
    {Coordinate{20.0327, 46.194}, Tz::Europe_Budapest, CountryId{"HU"}}, // Röszke railway station
    {Coordinate{22.2692, 48.1715}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056391
    {Coordinate{22.1964, 48.3272}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056392
    {Coordinate{22.3137, 47.951}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátészalka railway station
    {Coordinate{22.3182, 47.9979}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056394
    {Coordinate{22.3114, 48.0541}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056395
    {Coordinate{22.3082, 48.0955}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056396
    {Coordinate{22.2902, 48.1518}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056397
    {Coordinate{22.2535, 48.2114}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056398
    {Coordinate{22.2215, 48.2512}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056399
    {Coordinate{22.2022, 48.2684}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056400
    {Coordinate{22.1902, 48.3606}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056401
    {Coordinate{36.9437, 47.352}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q22056454
    {Coordinate{22.4029, 47.8153}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiborszállás railway station
    {Coordinate{22.3854, 47.8649}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056457
    {Coordinate{22.3483, 47.9081}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22056458
    {Coordinate{37.4923, 47.5538}, Tz::Europe_Kiev, CountryId{"UA"}}, // 412 km
    {Coordinate{38.085, 48.8165}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056514
    {Coordinate{38.0289, 48.6958}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056519
    {Coordinate{37.9707, 48.5014}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056523
    {Coordinate{34.6844, 46.9994}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 51 km
    {Coordinate{34.52, 46.9678}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056535
    {Coordinate{31.4357, 51.4261}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056540
    {Coordinate{37.7697, 48.9948}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056550
    {Coordinate{37.9733, 48.5402}, Tz::Europe_Kiev, CountryId{"UA"}}, // Klishchiivka
    {Coordinate{37.7422, 49.0103}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056556
    {Coordinate{32.6741, 47.0695}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056557
    {Coordinate{37.6809, 49.0448}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056559
    {Coordinate{28.5197, 49.4543}, Tz::Europe_Kiev, CountryId{"UA"}}, // Robocha
    {Coordinate{38.0708, 48.7552}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056565
    {Coordinate{38.0673, 48.3394}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056568
    {Coordinate{37.5899, 49.0688}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056577
    {Coordinate{37.6343, 49.0658}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22056579
    {Coordinate{37.7331, 48.1489}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057695
    {Coordinate{38.1319, 48.3161}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057703
    {Coordinate{21.5833, 47.364}, Tz::Europe_Budapest, CountryId{"HU"}}, // Derecske railway station
    {Coordinate{25.3471, 48.1757}, Tz::Europe_Kiev, CountryId{"UA"}}, // Berehomet
    {Coordinate{21.581, 47.3516}, Tz::Europe_Budapest, CountryId{"HU"}}, // Derecske-Vásártér railway station
    {Coordinate{21.7454, 47.3241}, Tz::Europe_Budapest, CountryId{"HU"}}, // Konyári Sóstófürdő railway station
    {Coordinate{24.9501, 49.445}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057726
    {Coordinate{21.8139, 47.2439}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22057729
    {Coordinate{21.8004, 47.1908}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22057731
    {Coordinate{25.6871, 49.0397}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057740
    {Coordinate{21.6251, 47.4143}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sáránd  railway station
    {Coordinate{24.5247, 49.0353}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bodnariv
    {Coordinate{21.6662, 47.3236}, Tz::Europe_Budapest, CountryId{"HU"}}, // Konyár railway station
    {Coordinate{21.7928, 47.2883}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pocsaj-Esztár railway station
    {Coordinate{23.8722, 49.0632}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057759
    {Coordinate{26.0594, 48.8044}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057768
    {Coordinate{24.7186, 48.8232}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057779
    {Coordinate{24.4948, 49.26}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057787
    {Coordinate{38.3597, 48.3025}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057794
    {Coordinate{24.6476, 49.2173}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057795
    {Coordinate{25.9077, 48.2027}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057805
    {Coordinate{25.7515, 48.5413}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057814
    {Coordinate{25.8601, 49.0383}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyhnanka
    {Coordinate{25.4255, 48.4471}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057833
    {Coordinate{25.1928, 48.2492}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057842
    {Coordinate{35.7145, 49.5922}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057850
    {Coordinate{24.5082, 48.2794}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057950
    {Coordinate{25.9017, 49.0486}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057972
    {Coordinate{24.7327, 49.1371}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057986
    {Coordinate{25.08, 48.5984}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22057995
    {Coordinate{38.0442, 48.3111}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058004
    {Coordinate{37.3133, 48.2269}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058012
    {Coordinate{26.1837, 49.0734}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058031
    {Coordinate{36.4753, 48.1781}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058040
    {Coordinate{25.7732, 49.239}, Tz::Europe_Kiev, CountryId{"UA"}}, // Derenivka
    {Coordinate{37.0758, 48.4483}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058055
    {Coordinate{23.9841, 48.9823}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dolyna
    {Coordinate{38.1325, 48.4144}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058073
    {Coordinate{24.7952, 49.0916}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058092
    {Coordinate{24.7659, 49.0408}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058111
    {Coordinate{38.1997, 48.2264}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058121
    {Coordinate{24.3762, 49.3129}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058130
    {Coordinate{25.3074, 48.4737}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058139
    {Coordinate{38.1968, 47.924}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058165
    {Coordinate{25.2524, 48.2985}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058174
    {Coordinate{37.8814, 48.0639}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058183
    {Coordinate{25.8412, 48.0944}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058201
    {Coordinate{37.6175, 48.5792}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058210
    {Coordinate{25.7767, 48.4361}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058218
    {Coordinate{25.1643, 49.4295}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058227
    {Coordinate{25.0169, 48.6538}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058236
    {Coordinate{25.7188, 48.6441}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058247
    {Coordinate{37.7214, 48.5167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058248
    {Coordinate{37.5092, 47.9919}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058249
    {Coordinate{37.7814, 48.4089}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058250
    {Coordinate{38.0244, 48.1267}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058251
    {Coordinate{37.3742, 48.0367}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058253
    {Coordinate{37.9597, 48.4639}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058254
    {Coordinate{32.7916, 48.3136}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kutsivka
    {Coordinate{26.0833, 49.8742}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058256
    {Coordinate{38.2881, 49.9242}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058257
    {Coordinate{32.125, 48.5189}, Tz::Europe_Kiev, CountryId{"UA"}}, // Lelekivka
    {Coordinate{25.7708, 48.3617}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058260
    {Coordinate{26.5753, 48.2526}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058261
    {Coordinate{38.635, 48.4089}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058262
    {Coordinate{24.7883, 48.8195}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058263
    {Coordinate{25.1661, 48.5094}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058264
    {Coordinate{32.6715, 48.5659}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mederove
    {Coordinate{25.6308, 48.0525}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058266
    {Coordinate{24.5938, 48.3969}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058268
    {Coordinate{38.075, 47.8817}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058270
    {Coordinate{24.5849, 48.6242}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nadvirna
    {Coordinate{25.6532, 48.3997}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nepolokivtsi
    {Coordinate{26.2806, 48.2242}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058276
    {Coordinate{37.995, 48.2}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058277
    {Coordinate{25.4411, 49.0669}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pyshkivtsi
    {Coordinate{24.7781, 49.38}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058279
    {Coordinate{31.7269, 48.4612}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058280
    {Coordinate{24.9814, 49.377}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058281
    {Coordinate{25.6848, 49.4168}, Tz::Europe_Kiev, CountryId{"UA"}}, // Proshova
    {Coordinate{38.04, 48.1428}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058283
    {Coordinate{24.6213, 49.3995}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rohatyn
    {Coordinate{39.0231, 48.5547}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058285
    {Coordinate{24.1599, 49.0002}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058286
    {Coordinate{25.9507, 48.331}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058289
    {Coordinate{32.6254, 48.644}, Tz::Europe_Kiev, CountryId{"UA"}}, // Saharna
    {Coordinate{38.0928, 48.8694}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058291
    {Coordinate{38.9097, 48.5461}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058293
    {Coordinate{25.5052, 48.4293}, Tz::Europe_Kiev, CountryId{"UA"}}, // Snyatyn
    {Coordinate{27.3727, 48.4443}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058295
    {Coordinate{25.7107, 48.7575}, Tz::Europe_Kiev, CountryId{"UA"}}, // Torskie
    {Coordinate{32.3672, 48.6849}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058298
    {Coordinate{37.0139, 48.2408}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058300
    {Coordinate{38.1519, 48.0325}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058301
    {Coordinate{24.7416, 48.8911}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058302
    {Coordinate{32.7961, 48.5009}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sharivka
    {Coordinate{37.9958, 48.6547}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058306
    {Coordinate{31.9717, 48.5166}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058309
    {Coordinate{38.1403, 48.1942}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058310
    {Coordinate{25.7344, 48.9333}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q22058311
    {Coordinate{24.7111, 48.9854}, Tz::Europe_Kiev, CountryId{"UA"}}, // Yamnytsia
    {Coordinate{5.89064, 48.1797}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2205857
    {Coordinate{20.1279, 47.1467}, Tz::Europe_Budapest, CountryId{"HU"}}, // Piroska railway station
    {Coordinate{20.1384, 47.0981}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tószeg railway station
    {Coordinate{20.1424, 47.0365}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszajenő-Vezseny railway station
    {Coordinate{20.1345, 47.017}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszajenő alsó railway station
    {Coordinate{20.0936, 46.9621}, Tz::Europe_Budapest, CountryId{"HU"}}, // Óbög railway station
    {Coordinate{20.1111, 46.9871}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újbög railway station
    {Coordinate{20.082, 46.9375}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszakécske railway station
    {Coordinate{20.0466, 46.9024}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kerekdomb railway station
    {Coordinate{20.0039, 46.8729}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lakitelek railway station
    {Coordinate{20.1428, 47.0594}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszavárkony railway station
    {Coordinate{19.7797, 46.8985}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsóúrrét railway station
    {Coordinate{19.9895, 46.8665}, Tz::Europe_Budapest, CountryId{"HU"}}, // Árpádszállás railway station
    {Coordinate{19.9754, 46.8583}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szikra railway station
    {Coordinate{19.94, 46.8552}, Tz::Europe_Budapest, CountryId{"HU"}}, // Világoshegy railway station
    {Coordinate{19.923, 46.8577}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyárjas railway station
    {Coordinate{19.8787, 46.8641}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyárlőrinc alsó railway station
    {Coordinate{19.8515, 46.8701}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyárlőrinc railway station
    {Coordinate{19.8282, 46.8776}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyárlőrici szőlők railway station
    {Coordinate{19.8073, 46.8884}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisfái railway station
    {Coordinate{19.8474, 46.7253}, Tz::Europe_Budapest, CountryId{"HU"}}, // Petőfiváros railway station
    {Coordinate{19.8879, 46.7537}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kismindszenti út railway station
    {Coordinate{19.9129, 46.7699}, Tz::Europe_Budapest, CountryId{"HU"}}, // Borsihalom railway station
    {Coordinate{19.9515, 46.7908}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaalpár alsó railway station
    {Coordinate{19.9827, 46.8186}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaalpár railway station
    {Coordinate{19.977, 46.8362}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaalpár felső railway station
    {Coordinate{19.98, 46.8512}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tőserdő railway station
    {Coordinate{20.0524, 46.8662}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaug-Tiszahídfő railway station
    {Coordinate{20.0742, 46.8505}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszaug railway station
    {Coordinate{20.0899, 46.8258}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszasas railway station
    {Coordinate{20.135, 46.8125}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csépa railway station
    {Coordinate{20.1958, 46.8117}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szelevény railway station
    {Coordinate{20.2935, 46.8483}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kunszentmárton railway station
    {Coordinate{5.25194, 52.6961}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bovenkarspel Flora railway station
    {Coordinate{20.2921, 47.0208}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22061479
    {Coordinate{20.2766, 46.9757}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22061483
    {Coordinate{20.3157, 47.0603}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22061490
    {Coordinate{20.3399, 47.0899}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kengyel railway station
    {Coordinate{20.2695, 46.9458}, Tz::Europe_Budapest, CountryId{"HU"}}, // Homok railway station
    {Coordinate{20.2679, 46.9083}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kungyalu railway station
    {Coordinate{20.2916, 46.7633}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22061707
    {Coordinate{20.2814, 46.7157}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22061711
    {Coordinate{5.71992, 45.1528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Échirolles
    {Coordinate{-0.2502, 52.5748}, Tz::Europe_London, CountryId{"GB"}}, // Peterborough railway station
    {Coordinate{6.98, 51.4542}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen West station
    {Coordinate{4.46278, 50.4322}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lodelinsart railway station
    {Coordinate{2.21476, 48.8214}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Sèvres-Rive-Gauche
    {Coordinate{-2.765, 48.5075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Brieuc
    {Coordinate{3.32215, 48.9687}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2207054
    {Coordinate{19.791, 48.0893}, Tz::Europe_Budapest, CountryId{"HU"}}, // Salgótarján külső railway station
    {Coordinate{19.8157, 48.1552}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somoskőújfalu railway station
    {Coordinate{19.7067, 47.9388}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátraszőlős-Hasznos railway station
    {Coordinate{19.8194, 47.9797}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagybátony railway station
    {Coordinate{19.7463, 47.956}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tar railway station
    {Coordinate{19.8306, 48.0236}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisterenye-Bányatelep railway station
    {Coordinate{19.785, 48.0673}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zagyvapálfalva railway station
    {Coordinate{19.8319, 48.0096}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisterenye railway station
    {Coordinate{19.6889, 47.919}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pásztó railway station
    {Coordinate{19.7787, 47.9683}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátraverebély railway station
    {Coordinate{19.6903, 47.8515}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szurdokpüspöki railway station
    {Coordinate{19.6681, 47.7913}, Tz::Europe_Budapest, CountryId{"HU"}}, // Apc-Zagyvaszántó railway station
    {Coordinate{19.6738, 47.7196}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátravidéki Erőmű railway station
    {Coordinate{19.6874, 47.829}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jobbágyi  railway station
    {Coordinate{19.6709, 47.7589}, Tz::Europe_Budapest, CountryId{"HU"}}, // Selyp railway station
    {Coordinate{19.6739, 47.7377}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lőrinci railway station
    {Coordinate{20.8661, 48.0836}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőzsolca railway station
    {Coordinate{20.9075, 48.1219}, Tz::Europe_Budapest, CountryId{"HU"}}, // Onga railway station
    {Coordinate{20.9348, 48.1929}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071385
    {Coordinate{20.9417, 48.2016}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071386
    {Coordinate{20.9618, 48.2201}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071387
    {Coordinate{20.9911, 48.246}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071388
    {Coordinate{21.0341, 48.2772}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071389
    {Coordinate{21.0535, 48.2893}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071390
    {Coordinate{21.1177, 48.3275}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071391
    {Coordinate{21.1402, 48.363}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071392
    {Coordinate{21.1702, 48.4039}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071393
    {Coordinate{21.2136, 48.4868}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071394
    {Coordinate{20.7665, 48.1856}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071955
    {Coordinate{20.7829, 48.1477}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071956
    {Coordinate{20.7741, 48.1679}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071957
    {Coordinate{20.726, 48.2197}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071958
    {Coordinate{20.7085, 48.2221}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071959
    {Coordinate{20.6725, 48.2389}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071960
    {Coordinate{20.6499, 48.2548}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071961
    {Coordinate{20.6284, 48.2642}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22071962
    {Coordinate{20.5822, 48.2728}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072652
    {Coordinate{20.5559, 48.2763}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072711
    {Coordinate{20.5045, 48.2807}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072739
    {Coordinate{20.4374, 48.2865}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072803
    {Coordinate{20.3816, 48.2964}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072857
    {Coordinate{20.352, 48.2998}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bánréve railway station
    {Coordinate{20.3681, 48.2839}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072965
    {Coordinate{20.367, 48.2701}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22072968
    {Coordinate{20.319, 48.2344}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ózd alsó railway station
    {Coordinate{6.77722, 50.9365}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frechen-Königsdorf station
    {Coordinate{3.16307, 50.6957}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Roubaix
    {Coordinate{20.7922, 48.2126}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073969
    {Coordinate{20.7906, 48.2232}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073970
    {Coordinate{20.771, 48.2587}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073974
    {Coordinate{20.7609, 48.2788}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073975
    {Coordinate{20.7494, 48.2997}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073976
    {Coordinate{20.7317, 48.3342}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073977
    {Coordinate{20.7256, 48.3741}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073978
    {Coordinate{20.7214, 48.4003}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073979
    {Coordinate{20.7201, 48.41}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073980
    {Coordinate{20.7223, 48.4485}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073981
    {Coordinate{20.6912, 48.4719}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073982
    {Coordinate{20.6938, 48.4898}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073983
    {Coordinate{20.7379, 48.5375}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073984
    {Coordinate{20.7565, 48.5462}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22073985
    {Coordinate{20.7871, 48.558}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tornanádaska railway station
    {Coordinate{35.0497, 47.3047}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q22073997
    {Coordinate{35.0712, 47.8175}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 168 km
    {Coordinate{35.0964, 47.8497}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 172 km
    {Coordinate{35.1122, 47.8553}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 174 km
    {Coordinate{35.2203, 47.8372}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Iskra
    {Coordinate{35.2092, 47.8286}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Motor
    {Coordinate{20.9853, 48.0515}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hernádnémeti-Bőcs railway station
    {Coordinate{21.0566, 48.0395}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszalúc railway station
    {Coordinate{21.1291, 48.0919}, Tz::Europe_Budapest, CountryId{"HU"}}, // Taktaharkány railway station
    {Coordinate{21.1495, 48.1125}, Tz::Europe_Budapest, CountryId{"HU"}}, // Taktaszada railway station
    {Coordinate{21.2148, 48.1559}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szerencs railway station
    {Coordinate{21.2676, 48.1569}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074412
    {Coordinate{20.7639, 47.8908}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csincse railway station
    {Coordinate{20.5676, 47.7973}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőkövesd railway station
    {Coordinate{20.5898, 47.8064}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőkövesd felső railway station
    {Coordinate{20.6696, 47.8452}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőkeresztes-Mezőnyárád railway station
    {Coordinate{20.8227, 47.9308}, Tz::Europe_Budapest, CountryId{"HU"}}, // Emőd railway station
    {Coordinate{21.3399, 48.125}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074469
    {Coordinate{21.407, 48.113}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074470
    {Coordinate{21.5261, 48.0679}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074492
    {Coordinate{21.4748, 48.1202}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074494
    {Coordinate{21.5552, 48.0398}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074495
    {Coordinate{21.6164, 48.0047}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074496
    {Coordinate{21.6476, 47.9888}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074497
    {Coordinate{21.3693, 48.0129}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074505
    {Coordinate{21.4699, 47.9891}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074506
    {Coordinate{21.4146, 47.9989}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074507
    {Coordinate{21.5145, 48.0262}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bashalom railway station
    {Coordinate{21.4922, 48.0106}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074509
    {Coordinate{21.3867, 48.201}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074883
    {Coordinate{21.3539, 48.1753}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074885
    {Coordinate{21.4019, 48.2181}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074886
    {Coordinate{21.448, 48.2582}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074887
    {Coordinate{21.5121, 48.2854}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074889
    {Coordinate{21.5659, 48.3257}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22074890
    {Coordinate{21.6579, 48.3859}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sátoraljaújhely railway station
    {Coordinate{21.2688, 48.19}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mád railway station
    {Coordinate{21.223, 48.2282}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tállya railway station
    {Coordinate{21.2047, 48.2425}, Tz::Europe_Budapest, CountryId{"HU"}}, // Golop railway station
    {Coordinate{21.1812, 48.2865}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abaújszántó railway station
    {Coordinate{21.1796, 48.2687}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abaújszántói fürdő  railway station
    {Coordinate{21.2302, 48.2144}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rátka raiway station
    {Coordinate{21.198, 48.3089}, Tz::Europe_Budapest, CountryId{"HU"}}, // Abaújkér railway station
    {Coordinate{21.2087, 48.345}, Tz::Europe_Budapest, CountryId{"HU"}}, // Boldogkőváralja railway station
    {Coordinate{21.2192, 48.3647}, Tz::Europe_Budapest, CountryId{"HU"}}, // Korlát-Vizsoly railway station
    {Coordinate{21.2424, 48.411}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fony railway station
    {Coordinate{21.2455, 48.4193}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hejce-Vilmány railway station
    {Coordinate{21.2471, 48.4454}, Tz::Europe_Budapest, CountryId{"HU"}}, // Göncruszka railway station
    {Coordinate{21.2616, 48.4705}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gönc railway station
    {Coordinate{21.2647, 48.4922}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zsujta railway station
    {Coordinate{21.5887, 47.5292}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tócóvölgy railway station
    {Coordinate{21.5847, 47.6005}, Tz::Europe_Budapest, CountryId{"HU"}}, // Józsa railway station
    {Coordinate{21.5784, 47.6082}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúszentgyörgy railway station
    {Coordinate{21.5784, 47.6268}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zelemér railway station
    {Coordinate{21.5082, 47.7486}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúvid railway station
    {Coordinate{21.524, 47.6688}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúböszörmény railway station
    {Coordinate{21.4276, 47.8319}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúnánás railway station
    {Coordinate{21.4076, 47.8428}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúnánás-Vásártér railway station
    {Coordinate{21.4931, 47.8054}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajdúdorog railway station
    {Coordinate{21.4041, 47.9027}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tedej railway station
    {Coordinate{21.375, 47.9453}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszavasvári railway station
    {Coordinate{21.365, 47.9725}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22075991
    {Coordinate{21.3653, 47.9788}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22075994
    {Coordinate{21.4457, 47.5812}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyhát railway station
    {Coordinate{21.348, 47.6139}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balmazújváros railway station
    {Coordinate{21.2376, 47.6007}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kónya railway station
    {Coordinate{21.1541, 47.5861}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hortobágy railway station
    {Coordinate{21.0741, 47.6039}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hortobágyi Halastó railway station
    {Coordinate{20.951, 47.6234}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ohat-Pusztakócs railway station
    {Coordinate{20.8837, 47.6167}, Tz::Europe_Budapest, CountryId{"HU"}}, // Egyek railway station
    {Coordinate{35.0769, 47.8322}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Zaporizka Sich
    {Coordinate{20.6546, 47.6579}, Tz::Europe_Budapest, CountryId{"HU"}}, // Poroszló railway station
    {Coordinate{20.5645, 47.6944}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kétútköz railway station
    {Coordinate{20.5224, 47.7115}, Tz::Europe_Budapest, CountryId{"HU"}}, // Egerfarmos railway station
    {Coordinate{20.4802, 47.7252}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőtárkány railway station
    {Coordinate{21.6587, 47.5277}, Tz::Europe_Budapest, CountryId{"HU"}}, // Debrecen-Szabadságtelep
    {Coordinate{21.9658, 47.5198}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22076759
    {Coordinate{21.7136, 47.5252}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22076761
    {Coordinate{21.7633, 47.5238}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22076763
    {Coordinate{21.8187, 47.5216}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22076764
    {Coordinate{21.894, 47.5179}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22076765
    {Coordinate{22.0166, 47.5238}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyírábrány railway station
    {Coordinate{21.7957, 47.6327}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077094
    {Coordinate{21.8238, 47.6445}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077096
    {Coordinate{21.8427, 47.6629}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077097
    {Coordinate{21.7548, 47.6081}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077099
    {Coordinate{21.7065, 47.6029}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077100
    {Coordinate{21.9025, 47.699}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyíradony railway station
    {Coordinate{21.9588, 47.7374}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077171
    {Coordinate{21.9879, 47.7509}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077173
    {Coordinate{22.0671, 47.7932}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077176
    {Coordinate{22.1794, 47.8658}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077181
    {Coordinate{22.2138, 47.8962}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077182
    {Coordinate{22.2566, 47.9226}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077184
    {Coordinate{22.1316, 47.8426}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077190
    {Coordinate{21.8257, 47.8709}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077262
    {Coordinate{21.935, 47.8545}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077263
    {Coordinate{22.0191, 47.8529}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22077264
    {Coordinate{-1.345, 43.2681}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-Noblia-Bidarray
    {Coordinate{22.3757, 47.942}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22078557
    {Coordinate{22.4014, 47.9463}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22078558
    {Coordinate{22.4247, 47.9368}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22078559
    {Coordinate{22.4434, 47.9211}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22078560
    {Coordinate{22.4965, 47.9109}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22078561
    {Coordinate{22.5684, 47.8681}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22078562
    {Coordinate{22.6665, 47.8262}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csenger railway station
    {Coordinate{10.7666, 46.6261}, Tz::Europe_Rome, CountryId{"IT"}}, // Schlanders train station
    {Coordinate{2.31472, 48.8606}, Tz::Europe_Paris, CountryId{"FR"}}, // Invalides
    {Coordinate{22.4426, 47.9606}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086181
    {Coordinate{22.5243, 47.9788}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086182
    {Coordinate{22.4648, 47.9661}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086185
    {Coordinate{22.5672, 47.9953}, Tz::Europe_Budapest, CountryId{"HU"}}, // Penyige railway station
    {Coordinate{22.6135, 47.9759}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086219
    {Coordinate{22.6298, 47.9659}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086220
    {Coordinate{22.6571, 47.9421}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086221
    {Coordinate{22.7451, 47.9263}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086222
    {Coordinate{22.7823, 47.9129}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22086223
    {Coordinate{22.7953, 47.903}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zajta railway station
    {Coordinate{19.5514, 47.0061}, Tz::Europe_Budapest, CountryId{"HU"}}, // Klábertelep railway station
    {Coordinate{19.5578, 46.987}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőméntelek railway station
    {Coordinate{19.5707, 46.9787}, Tz::Europe_Budapest, CountryId{"HU"}}, // Méntelek railway station
    {Coordinate{19.579, 46.9616}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsóméntelek railway station
    {Coordinate{19.5949, 46.9309}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hetényegyháza railway station
    {Coordinate{19.6205, 46.918}, Tz::Europe_Budapest, CountryId{"HU"}}, // Úrihegy railway station
    {Coordinate{19.6308, 46.9134}, Tz::Europe_Budapest, CountryId{"HU"}}, // Miklóstelep railway station
    {Coordinate{19.6758, 46.9013}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kecskemét-Máriaváros railway station
    {Coordinate{19.6922, 46.8957}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kecskemét alsó railway station
    {Coordinate{18.2837, 47.0697}, Tz::Europe_Budapest, CountryId{"HU"}}, // Polgárdi railway station
    {Coordinate{18.2558, 47.0501}, Tz::Europe_Budapest, CountryId{"HU"}}, // Füle railway station
    {Coordinate{18.2142, 47.0312}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonfőkajár felső railway station
    {Coordinate{18.1862, 47.0338}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csajág railway station
    {Coordinate{18.1678, 47.0174}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonakarattya railway station
    {Coordinate{18.1375, 47.0253}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csittényhegy railway station
    {Coordinate{18.1055, 47.0325}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonkenese railway station
    {Coordinate{18.0426, 47.0599}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonfűzfő railway station
    {Coordinate{18.015, 47.0283}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonalmádi railway station
    {Coordinate{18.3142, 47.0794}, Tz::Europe_Budapest, CountryId{"HU"}}, // Polgárdi-Ipartelepek railway station
    {Coordinate{18.004, 47.0102}, Tz::Europe_Budapest, CountryId{"HU"}}, // Káptalanfüred railway station
    {Coordinate{17.9759, 46.9852}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsóörs railway station
    {Coordinate{17.9312, 46.9745}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csopak railway station
    {Coordinate{17.8975, 46.9625}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonarács railway station
    {Coordinate{17.8831, 46.9561}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonfüred railway station
    {Coordinate{17.8325, 46.9254}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aszófő railway station
    {Coordinate{17.8182, 46.9123}, Tz::Europe_Budapest, CountryId{"HU"}}, // Örvényes railway station
    {Coordinate{17.7896, 46.8935}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fövenyes railway station
    {Coordinate{17.7085, 46.8775}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zánkafürdő railway station
    {Coordinate{17.6877, 46.8728}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zánka-Köveskál railway station
    {Coordinate{17.6633, 46.8512}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonszepezd railway station
    {Coordinate{17.6324, 46.8291}, Tz::Europe_Budapest, CountryId{"HU"}}, // Révfülöp railway station
    {Coordinate{17.8077, 46.9046}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonudvari railway station
    {Coordinate{17.7481, 46.8798}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonakali-Dörgicse railway station
    {Coordinate{17.6497, 46.8397}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szepezdfürdő railway station
    {Coordinate{17.5841, 46.8255}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonrendes railway station
    {Coordinate{17.572, 46.8149}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ábrahámhegy railway station
    {Coordinate{17.4741, 46.7907}, Tz::Europe_Budapest, CountryId{"HU"}}, // Badacsonylábdihegy railway station
    {Coordinate{17.5299, 46.8065}, Tz::Europe_Budapest, CountryId{"HU"}}, // Badacsonyörs railway station
    {Coordinate{17.5182, 46.8046}, Tz::Europe_Budapest, CountryId{"HU"}}, // Badacsonytomaj railway station
    {Coordinate{17.5065, 46.7885}, Tz::Europe_Budapest, CountryId{"HU"}}, // Badacsony railway station
    {Coordinate{17.469, 46.8098}, Tz::Europe_Budapest, CountryId{"HU"}}, // Badacsonytördemic-Szigliget railway station
    {Coordinate{17.4763, 46.837}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nemesgulács-Kisapáti railway station
    {Coordinate{1.91921, 49.0067}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2209315
    {Coordinate{17.5992, 47.6216}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ménfőcsanak railway station
    {Coordinate{17.6144, 47.6378}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ménfőcsanak felső railway station
    {Coordinate{17.5847, 47.5672}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győrszemere railway station
    {Coordinate{17.5606, 47.5202}, Tz::Europe_Budapest, CountryId{"HU"}}, // Halipuszta railway station
    {Coordinate{17.5595, 47.5016}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyömöre-Tét railway station
    {Coordinate{17.5588, 47.4853}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyömöre railway station
    {Coordinate{17.5151, 47.4562}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gecse-Gyarmat railway station
    {Coordinate{17.4963, 47.4025}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vaszar railway station
    {Coordinate{17.5474, 47.4692}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szerecseny railway station
    {Coordinate{17.3642, 47.3235}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőlak railway station
    {Coordinate{17.3293, 47.3185}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mihályháza railway station
    {Coordinate{17.2826, 47.3057}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vinár railway station
    {Coordinate{17.2217, 47.28}, Tz::Europe_Budapest, CountryId{"HU"}}, // Külsővat railway station
    {Coordinate{17.1091, 47.279}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kemenesmihályfa railway station
    {Coordinate{17.0575, 47.2656}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagysimonyi railway station
    {Coordinate{17.0242, 47.2839}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ostffyasszonyfa railway station
    {Coordinate{17.188, 47.2039}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nemeskocs railway station
    {Coordinate{17.3165, 47.5222}, Tz::Europe_Budapest, CountryId{"HU"}}, // Egyed-Rábacsanak railway station
    {Coordinate{17.3152, 47.4607}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szany-Rábaszentandrás railway station
    {Coordinate{17.3489, 47.4277}, Tz::Europe_Budapest, CountryId{"HU"}}, // Marcaltő railway station
    {Coordinate{17.3766, 47.4028}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nemesgörzsöny railway station
    {Coordinate{17.3152, 47.5574}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rábapordány railway station
    {Coordinate{17.3377, 47.4385}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rábahíd railway station
    {Coordinate{2.36867, 46.8017}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2209490
    {Coordinate{2.30167, 48.6064}, Tz::Europe_Paris, CountryId{"FR"}}, // Brétigny (Paris RER)
    {Coordinate{113.556, 56.1924}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Okusikan
    {Coordinate{77.9781, 44.3569}, Tz::Asia_Almaty, CountryId{"KZ"}}, // Q22097561
    {Coordinate{2.145, 48.4275}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Martin-d'Étampes
    {Coordinate{5.58556, 50.4858}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rivage railway station
    {Coordinate{18.1225, 47.1673}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pétfürdő railway station
    {Coordinate{18.0749, 47.1598}, Tz::Europe_Budapest, CountryId{"HU"}}, // Öskü railway station
    {Coordinate{18.0095, 47.141}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hajmáskér railway station
    {Coordinate{17.1829, 47.1393}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kemenespálfa railway station
    {Coordinate{17.1718, 47.1158}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jánosháza railway station
    {Coordinate{17.1839, 47.0932}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nemeskeresztúr railway station
    {Coordinate{17.1994, 47.0606}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rigács railway station
    {Coordinate{16.9966, 46.9591}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pakod railway station
    {Coordinate{16.972, 46.9245}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pókaszepetk railway station
    {Coordinate{16.9466, 46.9057}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kemendollár railway station
    {Coordinate{16.9087, 46.8875}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaszentiván railway station
    {Coordinate{17.1669, 47.0258}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dabronc railway station
    {Coordinate{17.0946, 46.9952}, Tz::Europe_Budapest, CountryId{"HU"}}, // Türje railway station
    {Coordinate{17.0406, 46.9831}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalabér-Batyk railway station
    {Coordinate{16.8375, 46.8513}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaegerszeg-Ola railway station
    {Coordinate{16.7794, 46.8626}, Tz::Europe_Budapest, CountryId{"HU"}}, // Andráshida railway station
    {Coordinate{16.746, 46.875}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bagod railway station
    {Coordinate{16.7115, 46.8719}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaszentgyörgy railway station
    {Coordinate{16.6613, 46.8578}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalacséb-Salomvár railway station
    {Coordinate{16.625, 46.8516}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budafa railway station
    {Coordinate{16.6041, 46.8455}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalapatakalja railway station
    {Coordinate{16.5436, 46.8414}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőjánosfa railway station
    {Coordinate{16.4976, 46.8361}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pankasz railway station
    {Coordinate{16.4557, 46.8272}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyrákos railway station
    {Coordinate{16.4161, 46.8292}, Tz::Europe_Budapest, CountryId{"HU"}}, // Őriszentpéter railway station
    {Coordinate{16.3581, 46.8181}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bajánsenye railway station
    {Coordinate{2.89701, 48.3788}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Grande-Paroisse
    {Coordinate{17.3315, 47.1287}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tüskevár railway station
    {Coordinate{17.8108, 47.1269}, Tz::Europe_Budapest, CountryId{"HU"}}, // Márkó railway station
    {Coordinate{17.7607, 47.137}, Tz::Europe_Budapest, CountryId{"HU"}}, // Herend railway station
    {Coordinate{17.7073, 47.1365}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentgál railway station
    {Coordinate{17.6531, 47.1445}, Tz::Europe_Budapest, CountryId{"HU"}}, // Városlőd railway station
    {Coordinate{17.6296, 47.1332}, Tz::Europe_Budapest, CountryId{"HU"}}, // Városlőd-Kislőd railway station
    {Coordinate{17.5553, 47.0968}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ajka-Gyártelep railway station
    {Coordinate{17.4357, 47.1123}, Tz::Europe_Budapest, CountryId{"HU"}}, // Devecser railway station
    {Coordinate{17.3689, 47.1244}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somlóvásárhely railway station
    {Coordinate{17.2882, 47.1336}, Tz::Europe_Budapest, CountryId{"HU"}}, // Karakószörcsök railway station
    {Coordinate{17.2384, 47.1515}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kerta railway station
    {Coordinate{16.8006, 46.6699}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116522
    {Coordinate{16.6852, 46.6265}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116523
    {Coordinate{16.6418, 46.6078}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116524
    {Coordinate{16.6035, 46.6032}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116525
    {Coordinate{16.8534, 46.7783}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116526
    {Coordinate{16.8492, 46.732}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116527
    {Coordinate{16.74, 46.6469}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116528
    {Coordinate{16.5725, 46.6113}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116529
    {Coordinate{16.5297, 46.6212}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116530
    {Coordinate{16.4711, 46.618}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rédics railway station
    {Coordinate{16.8513, 46.7552}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116532
    {Coordinate{16.7666, 46.6551}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116533
    {Coordinate{16.8247, 46.6907}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22116537
    {Coordinate{17.2077, 47.0212}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gógánfa railway station
    {Coordinate{17.2208, 47.011}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalagyömörő railway station
    {Coordinate{17.2475, 46.9976}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyírlak railway station
    {Coordinate{17.2707, 46.9811}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sümeg railway station
    {Coordinate{17.3316, 46.9204}, Tz::Europe_Budapest, CountryId{"HU"}}, // Uzsa railway station
    {Coordinate{17.3453, 46.8983}, Tz::Europe_Budapest, CountryId{"HU"}}, // Uzsabánya alsó railway station
    {Coordinate{17.2925, 46.9523}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sümegi Bazaltbánya railway station
    {Coordinate{17.3182, 46.7552}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vonyarcvashegy railway station
    {Coordinate{17.2924, 46.7633}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyenesdiás railway station
    {Coordinate{17.4125, 46.8508}, Tz::Europe_Budapest, CountryId{"HU"}}, // Raposka railway station
    {Coordinate{17.3845, 46.8026}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonederics train station
    {Coordinate{17.3726, 46.7761}, Tz::Europe_Budapest, CountryId{"HU"}}, // Becehegy railway station
    {Coordinate{17.3542, 46.752}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatongyörök railway station
    {Coordinate{17.2766, 46.7659}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsógyenes railway station
    {Coordinate{17.2488, 46.7117}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fenékpuszta railway station
    {Coordinate{17.2353, 46.6092}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sávoly railway station
    {Coordinate{17.1883, 46.53}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalakomár railway station
    {Coordinate{17.1354, 46.4915}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaszentjakab railway station
    {Coordinate{17.0436, 46.4638}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyrécse railway station
    {Coordinate{17.26, 46.6634}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vörs railway station
    {Coordinate{16.9327, 46.7923}, Tz::Europe_Budapest, CountryId{"HU"}}, // Búcsúszentlászló railway station
    {Coordinate{16.9519, 46.7233}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaszentmihály-Pacsa railway station
    {Coordinate{16.9827, 46.6003}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gelse railway station
    {Coordinate{16.9364, 46.8542}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alsónemesapáti railway station
    {Coordinate{16.935, 46.8322}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagykapornak railway station
    {Coordinate{16.98, 46.5193}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újudvar railway station
    {Coordinate{16.958, 46.682}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pötréte railway station
    {Coordinate{16.9827, 46.667}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőrajk railway station
    {Coordinate{16.5886, 47.3164}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyöngyösfalu railway station
    {Coordinate{16.6259, 47.2543}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kámon railway station
    {Coordinate{16.6001, 47.2858}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gencsapáti alsó railway station
    {Coordinate{16.5938, 47.2995}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gencsapáti felső railway station
    {Coordinate{16.5852, 47.3266}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lukácsháza alsó railway station
    {Coordinate{16.5804, 47.3408}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lukácsháza railway station
    {Coordinate{16.5674, 47.3618}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőszegfalva railway station
    {Coordinate{16.5568, 47.3815}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőszeg railway station
    {Coordinate{5.90332, 45.6485}, Tz::Europe_Paris, CountryId{"FR"}}, // Viviers-du-Lac
    {Coordinate{1.94072, 49.6618}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grandvilliers
    {Coordinate{18.1185, 46.9341}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szabadisóstó railway station
    {Coordinate{18.0999, 46.9244}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szabadifürdő railway station
    {Coordinate{18.3549, 47.0481}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiscséripuszta railway station
    {Coordinate{18.3006, 47.019}, Tz::Europe_Budapest, CountryId{"HU"}}, // Polgárdi-Tekerespuszta railway station
    {Coordinate{18.2475, 46.9874}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lepsény railway station
    {Coordinate{18.1576, 46.9639}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balatonvilágos railway station
    {Coordinate{16.9215, 46.3791}, Tz::Europe_Budapest, CountryId{"HU"}}, // Fityeház railway station
    {Coordinate{16.8775, 46.3263}, Tz::Europe_Budapest, CountryId{"HU"}}, // Belezna railway station
    {Coordinate{16.938, 46.255}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zákány railway station
    {Coordinate{16.8766, 46.3638}, Tz::Europe_Budapest, CountryId{"HU"}}, // Murakeresztúr railway station
    {Coordinate{16.8877, 46.2978}, Tz::Europe_Budapest, CountryId{"HU"}}, // Őrtilos railway station
    {Coordinate{17.3543, 46.2284}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22121789
    {Coordinate{18.1101, 46.7461}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bábonymegyer railway station
    {Coordinate{18.0411, 46.7341}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tab railway station
    {Coordinate{18.1254, 46.8806}, Tz::Europe_Budapest, CountryId{"HU"}}, // Siójut railway station
    {Coordinate{18.1414, 46.8541}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ádánd railway station
    {Coordinate{18.1494, 46.8028}, Tz::Europe_Budapest, CountryId{"HU"}}, // Som-Nagyberény railway station
    {Coordinate{18.1469, 46.7667}, Tz::Europe_Budapest, CountryId{"HU"}}, // Daránypuszta railway station
    {Coordinate{18.077, 46.9112}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sióvölgy railway station
    {Coordinate{17.9777, 46.7136}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kapoly railway station
    {Coordinate{17.8749, 46.6811}, Tz::Europe_Budapest, CountryId{"HU"}}, // Karád railway station
    {Coordinate{17.9207, 46.7204}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somogymeggyes railway station
    {Coordinate{17.8922, 46.6473}, Tz::Europe_Budapest, CountryId{"HU"}}, // Andocs railway station
    {Coordinate{17.9107, 46.6091}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bonnya railway station
    {Coordinate{17.8216, 46.5593}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőmocsolád railway station
    {Coordinate{17.8668, 46.615}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisbárapáti railway station
    {Coordinate{17.8324, 46.5081}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mernye railway station
    {Coordinate{17.8406, 46.4537}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somogyaszaló railway station
    {Coordinate{17.8399, 46.3957}, Tz::Europe_Budapest, CountryId{"HU"}}, // Toponár railway station
    {Coordinate{17.8201, 46.3566}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposszentjakab railway station
    {Coordinate{17.8475, 46.4303}, Tz::Europe_Budapest, CountryId{"HU"}}, // Répáspuszta railway station
    {Coordinate{17.8367, 46.4724}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somodor railway station
    {Coordinate{18.1565, 46.1931}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarhertelend railway station
    {Coordinate{18.186, 46.2102}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarszék railway station
    {Coordinate{18.2135, 46.2241}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mecsekpölöske railway station
    {Coordinate{18.2653, 46.1891}, Tz::Europe_Budapest, CountryId{"HU"}}, // Komló railway station
    {Coordinate{18.1289, 46.2}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bodolyabér railway station
    {Coordinate{18.2419, 46.2163}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mecsekjánosi railway station
    {Coordinate{4.99954, 43.5805}, Tz::Europe_Paris, CountryId{"FR"}}, // Miramas Station
    {Coordinate{3.10583, 42.5189}, Tz::Europe_Paris, CountryId{"FR"}}, // Port-Ventres railway station
    {Coordinate{8.947, 44.4066}, Tz::Europe_Rome, CountryId{"IT"}}, // Genova Brignole
    {Coordinate{17.5946, 46.6866}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztaberény railway station
    {Coordinate{17.6134, 46.6607}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lengyeltóti railway station
    {Coordinate{17.6212, 46.6366}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tatárvár railway station
    {Coordinate{17.6328, 46.6088}, Tz::Europe_Budapest, CountryId{"HU"}}, // Öreglak railway station
    {Coordinate{17.6348, 46.5805}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somogyvár railway station
    {Coordinate{17.6341, 46.5572}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pamuk railway station
    {Coordinate{17.6572, 46.5145}, Tz::Europe_Budapest, CountryId{"HU"}}, // Osztopán railway station
    {Coordinate{17.7594, 46.4149}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposfüred railway station
    {Coordinate{17.6945, 46.4907}, Tz::Europe_Budapest, CountryId{"HU"}}, // Somogyjád railway station
    {Coordinate{17.7252, 46.4605}, Tz::Europe_Budapest, CountryId{"HU"}}, // Várda railway station
    {Coordinate{17.7742, 46.366}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kapostüskevár railway station
    {Coordinate{18.7829, 46.8659}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagykarácsony felső railway station
    {Coordinate{18.7658, 46.8487}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagykarácsony railway station
    {Coordinate{18.6574, 46.832}, Tz::Europe_Budapest, CountryId{"HU"}}, // Alap railway station
    {Coordinate{18.6372, 46.8288}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rétszilas alsó railway station
    {Coordinate{18.8105, 46.9053}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mezőfalva railway station
    {Coordinate{18.8713, 46.9372}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újvenyim railway station
    {Coordinate{16.8557, 47.3269}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pósfa railway station
    {Coordinate{16.8984, 47.3578}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hegyfalu railway station
    {Coordinate{16.9283, 47.3745}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vasegerszeg railway station
    {Coordinate{16.9614, 47.3853}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vámoscsalád railway station
    {Coordinate{17.009, 47.419}, Tz::Europe_Budapest, CountryId{"HU"}}, // Répcelak railway station
    {Coordinate{17.0261, 47.4303}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csánig railway station
    {Coordinate{17.055, 47.4487}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dénesfa railway station
    {Coordinate{17.0847, 47.4667}, Tz::Europe_Budapest, CountryId{"HU"}}, // Beled railway station
    {Coordinate{17.1117, 47.4777}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vica railway station
    {Coordinate{17.1762, 47.5142}, Tz::Europe_Budapest, CountryId{"HU"}}, // Magyarkeresztúr-Zsebeháza railway station
    {Coordinate{17.1373, 47.4922}, Tz::Europe_Budapest, CountryId{"HU"}}, // Páli-Vadosfa railway station
    {Coordinate{17.2096, 47.5334}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szil-Sopronnémeti railway station
    {Coordinate{17.2342, 47.6854}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bősárkány railway station
    {Coordinate{17.2155, 47.72}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hanságliget railway station
    {Coordinate{17.1891, 47.7411}, Tz::Europe_Budapest, CountryId{"HU"}}, // Hanság-Nagyerdő railway station
    {Coordinate{17.1376, 47.7891}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jánossomorja railway station
    {Coordinate{17.1605, 47.8526}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mosonszolnok railway station
    {Coordinate{-1.32178, 48.1092}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2213900
    {Coordinate{16.8338, 47.0098}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pácsony railway station
    {Coordinate{16.8422, 46.9897}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győrvár railway station
    {Coordinate{16.8625, 46.9419}, Tz::Europe_Budapest, CountryId{"HU"}}, // Egervár-Vasboldogasszony railway station
    {Coordinate{16.6572, 47.2029}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gyöngyöshermán railway station
    {Coordinate{16.7197, 47.1369}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sorkifalud railway station
    {Coordinate{16.7337, 47.1219}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szentléránt railway station
    {Coordinate{16.7686, 47.0849}, Tz::Europe_Budapest, CountryId{"HU"}}, // Püspökmolnári railway station
    {Coordinate{16.81, 47.0574}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vasvár railway station
    {Coordinate{16.8773, 46.9141}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zalaszentlőrinc railway station
    {Coordinate{6.74833, 53.3344}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Loppersum railway station
    {Coordinate{5.69684, 44.6693}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2215039
    {Coordinate{1.97101, 50.8921}, Tz::Europe_Paris, CountryId{"FR"}}, // Pont-d'Ardres
    {Coordinate{19.7536, 46.8158}, Tz::Europe_Budapest, CountryId{"HU"}}, // Városföld railway station
    {Coordinate{19.7687, 46.781}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kunszállás railway station
    {Coordinate{19.8264, 47.1684}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ceglédi szállások railway station
    {Coordinate{19.7925, 47.1003}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nyársapát railway station
    {Coordinate{19.9286, 46.5143}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisteleki szőlők railway station
    {Coordinate{19.8535, 46.6555}, Tz::Europe_Budapest, CountryId{"HU"}}, // Selymes railway station
    {Coordinate{19.8655, 46.6173}, Tz::Europe_Budapest, CountryId{"HU"}}, // Petőfiszállás railway station
    {Coordinate{19.8748, 46.5877}, Tz::Europe_Budapest, CountryId{"HU"}}, // Petőfiszállási tanyák railway station
    {Coordinate{19.9876, 46.4353}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kapitányság railway station
    {Coordinate{20.0014, 46.4135}, Tz::Europe_Budapest, CountryId{"HU"}}, // Balástya railway station
    {Coordinate{20.0159, 46.3904}, Tz::Europe_Budapest, CountryId{"HU"}}, // Őszeszék railway station
    {Coordinate{20.0309, 46.3664}, Tz::Europe_Budapest, CountryId{"HU"}}, // Vilmaszállás railway station
    {Coordinate{20.0512, 46.3343}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jánosszállás railway station
    {Coordinate{20.0909, 46.2713}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskundorozsma railway station
    {Coordinate{4.45111, 51.4625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wildert railway station
    {Coordinate{3.30278, 48.0268}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Julien-du-Sault
    {Coordinate{4.079, 45.6038}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2217344
    {Coordinate{6.8934, 51.0146}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Volkhovener Weg station
    {Coordinate{-0.908241, 44.0336}, Tz::Europe_Paris, CountryId{"FR"}}, // Morcenx
    {Coordinate{2.5075, 48.7708}, Tz::Europe_Paris, CountryId{"FR"}}, // Sucy – Bonneuil (Paris RER)
    {Coordinate{7.27942, 48.0858}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Turckheim
    {Coordinate{3.98333, 50.9433}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vijfhuizen railway station
    {Coordinate{-0.767612, 43.4841}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Orthez
    {Coordinate{15.5144, 51.9475}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Zielona Góra
    {Coordinate{-1.23884, 43.1681}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Jean-Pied-de-Port
    {Coordinate{1.38947, 44.742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gourdon
    {Coordinate{6.71811, 51.2061}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuss Rheinpark-Center station
    {Coordinate{2.24167, 49.3544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hermes-Berthecourt
    {Coordinate{2.73601, 50.8544}, Tz::Europe_Brussels, CountryId{"BE"}}, // Poperinge railway station
    {Coordinate{1.9743, 43.6562}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2222023
    {Coordinate{18.1341, 46.3638}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dombóvár alsó railway station
    {Coordinate{18.0968, 46.3731}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kapospula railway station
    {Coordinate{18.045, 46.3666}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csoma-Szabadi railway station
    {Coordinate{18.0078, 46.3562}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyberki railway station
    {Coordinate{17.9609, 46.3556}, Tz::Europe_Budapest, CountryId{"HU"}}, // Baté railway station
    {Coordinate{17.9218, 46.3674}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposhomok railway station
    {Coordinate{17.8937, 46.3635}, Tz::Europe_Budapest, CountryId{"HU"}}, // Taszár railway station
    {Coordinate{18.0675, 46.3687}, Tz::Europe_Budapest, CountryId{"HU"}}, // Attala railway station
    {Coordinate{17.7244, 46.367}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposújlak railway station
    {Coordinate{17.6996, 46.3654}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposmérő railway station
    {Coordinate{17.6604, 46.3642}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kaposfő railway station
    {Coordinate{17.6089, 46.3623}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiskorpád railway station
    {Coordinate{17.5553, 46.3446}, Tz::Europe_Budapest, CountryId{"HU"}}, // Jákó-Nagybajom railway station
    {Coordinate{17.4534, 46.326}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kutas railway station
    {Coordinate{17.4206, 46.3167}, Tz::Europe_Budapest, CountryId{"HU"}}, // Beleg railway station
    {Coordinate{17.3579, 46.2927}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ötvöskónyi railway station
    {Coordinate{17.1809, 46.2737}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szenta railway station
    {Coordinate{17.0209, 46.2532}, Tz::Europe_Budapest, CountryId{"HU"}}, // Porrogszentkirály railway station
    {Coordinate{17.2754, 46.2821}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bolhás railway station
    {Coordinate{17.1408, 46.2751}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zrínyitelep railway station
    {Coordinate{17.0916, 46.2612}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csurgó railway station
    {Coordinate{17.4795, 46.7125}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22222762
    {Coordinate{17.4998, 46.6805}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22222767
    {Coordinate{17.4575, 46.6628}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22222768
    {Coordinate{17.4719, 46.6492}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22222769
    {Coordinate{17.4785, 46.639}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22222770
    {Coordinate{5.01194, 52.1031}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vleuten railway station
    {Coordinate{7.26846, 47.6763}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2222548
    {Coordinate{20.4136, 46.1921}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227129
    {Coordinate{20.1826, 46.2117}, Tz::Europe_Budapest, CountryId{"HU"}}, // :Szőreg railway station
    {Coordinate{20.4306, 46.191}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227132
    {Coordinate{20.4748, 46.2046}, Tz::Europe_Budapest, CountryId{"HU"}}, // Makó railway station
    {Coordinate{20.2464, 46.21}, Tz::Europe_Budapest, CountryId{"HU"}}, // Deszk railway station
    {Coordinate{20.5806, 46.1752}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227154
    {Coordinate{20.6103, 46.1746}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227155
    {Coordinate{20.7081, 46.1701}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227156
    {Coordinate{20.7174, 46.189}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227157
    {Coordinate{20.7326, 46.236}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227158
    {Coordinate{20.8158, 46.3108}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227159
    {Coordinate{20.8485, 46.3413}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227171
    {Coordinate{20.8669, 46.3671}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227172
    {Coordinate{20.8999, 46.408}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227173
    {Coordinate{20.9191, 46.4159}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227174
    {Coordinate{20.9692, 46.451}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227175
    {Coordinate{21.0304, 46.4964}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227176
    {Coordinate{20.8792, 46.3851}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227177
    {Coordinate{21.0939, 46.5054}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227178
    {Coordinate{20.6558, 46.5535}, Tz::Europe_Budapest, CountryId{"HU"}}, // Orosháza felső railway station
    {Coordinate{20.7374, 46.3708}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227189
    {Coordinate{20.7461, 46.3263}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227190
    {Coordinate{20.7269, 46.4087}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227191
    {Coordinate{20.6976, 46.4982}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227194
    {Coordinate{20.7406, 46.3531}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227195
    {Coordinate{20.6834, 46.5799}, Tz::Europe_Budapest, CountryId{"HU"}}, // Orosháza-Üveggyár railway station
    {Coordinate{20.5568, 46.94}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztabánréve railway station
    {Coordinate{20.6745, 46.6728}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyszénás railway station
    {Coordinate{20.7176, 46.7192}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kiscsákó railway station
    {Coordinate{20.7215, 46.7512}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisszénás railway station
    {Coordinate{20.6633, 46.8228}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csabacsűd railway station
    {Coordinate{20.6493, 46.8292}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csabacsűd felső railway station
    {Coordinate{20.5667, 46.8605}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szarvas railway station
    {Coordinate{20.5625, 46.9112}, Tz::Europe_Budapest, CountryId{"HU"}}, // Halászlak railway station
    {Coordinate{20.6098, 46.8406}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sirató railway station
    {Coordinate{20.9067, 46.3203}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227453
    {Coordinate{20.967, 46.321}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227454
    {Coordinate{21.004, 46.282}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q22227455
    {Coordinate{-2.08833, 47.4352}, Tz::Europe_Paris, CountryId{"FR"}}, // Pontchâteau
    {Coordinate{6.06277, 49.0574}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2222801
    {Coordinate{-2.14518, 48.2484}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quédillac
    {Coordinate{7.00433, 50.9535}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Buchforst
    {Coordinate{4.01376, 49.3295}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2224318
    {Coordinate{0.489222, 44.8573}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bergerac
    {Coordinate{4.56912, 50.6596}, Tz::Europe_Brussels, CountryId{"BE"}}, // Céroux-Mousty railway station
    {Coordinate{5.72456, 47.1526}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2225878
    {Coordinate{7.54714, 48.8424}, Tz::Europe_Paris, CountryId{"FR"}}, // Obermodern
    {Coordinate{7.62003, 45.4052}, Tz::Europe_Rome, CountryId{"IT"}}, // Campore railway station
    {Coordinate{7.66114, 45.3695}, Tz::Europe_Rome, CountryId{"IT"}}, // Valperga railway station
    {Coordinate{7.74369, 45.3037}, Tz::Europe_Rome, CountryId{"IT"}}, // Feletto railway station
    {Coordinate{7.76186, 45.2675}, Tz::Europe_Rome, CountryId{"IT"}}, // Bosconero railway station
    {Coordinate{4.02611, 50.8394}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ninove railway station
    {Coordinate{6.71583, 52.26}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Delden railway station
    {Coordinate{7.1342, 51.3724}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Nierenhof station
    {Coordinate{24.2447, 59.3419}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2226890
    {Coordinate{2.46592, 50.5899}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2226896
    {Coordinate{0.984289, 44.8197}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Siorac-en-Périgord
    {Coordinate{3.61677, 50.6006}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leuze railway station
    {Coordinate{6.8981, 51.0212}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Köln-Chorweiler
    {Coordinate{1.2894, 43.6215}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2227003
    {Coordinate{-0.210094, 46.9852}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thouars
    {Coordinate{3.60177, 50.7422}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ronse railway station
    {Coordinate{4.66699, 50.5925}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ernage railway station
    {Coordinate{6.84116, 51.2025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf-Eller Mitte station
    {Coordinate{13.2994, 52.5303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Jungfernheide station
    {Coordinate{26.146, 59.3382}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Kadrina railway station
    {Coordinate{3.09053, 50.3718}, Tz::Europe_Paris, CountryId{"FR"}}, // Douai railway station
    {Coordinate{5.61194, 50.6439}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bressoux railway station
    {Coordinate{2.75944, 48.7392}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tournan
    {Coordinate{4.67139, 51.7897}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dordrecht Zuid railway station
    {Coordinate{-0.187799, 44.5753}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Pierre-d'Aurillac
    {Coordinate{7.59105, 44.4962}, Tz::Europe_Rome, CountryId{"IT"}}, // Centallo railway station
    {Coordinate{5.45406, 50.6563}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bierset-Awans railway station
    {Coordinate{5.21861, 50.5286}, Tz::Europe_Brussels, CountryId{"BE"}}, // Statte railway station
    {Coordinate{3.66768, 49.6487}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2230592
    {Coordinate{4.74278, 52.0147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gouda Goverwelle railway station
    {Coordinate{2.04727, 47.0859}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2230843
    {Coordinate{1.01185, 44.7774}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belvès
    {Coordinate{-1.42841, 43.3784}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Halsou-Larressore
    {Coordinate{4.71667, 51.8017}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dordrecht Stadspolders railway station
    {Coordinate{1.7718, 48.6258}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gazeran
    {Coordinate{4.44917, 50.7661}, Tz::Europe_Brussels, CountryId{"BE"}}, // Groenendaal railway station
    {Coordinate{8.77639, 46.1169}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ranzo-Sant’Abbondio railway station
    {Coordinate{8.785, 46.1219}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gerra (Gambarogno) railway station
    {Coordinate{4.24028, 51.0992}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bornem railway station
    {Coordinate{16.2429, 39.6535}, Tz::Europe_Rome, CountryId{"IT"}}, // Tarsia railway station
    {Coordinate{16.2226, 39.5385}, Tz::Europe_Rome, CountryId{"IT"}}, // Mongrassano-Cervicati railway station
    {Coordinate{16.2105, 39.4945}, Tz::Europe_Rome, CountryId{"IT"}}, // Torano-Lattarico railway station
    {Coordinate{16.2452, 39.4414}, Tz::Europe_Rome, CountryId{"IT"}}, // Acri-Bisignano-Luzzi railway station
    {Coordinate{16.2475, 39.4071}, Tz::Europe_Rome, CountryId{"IT"}}, // Montalto-Rose railway station
    {Coordinate{25.333, 59.3375}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2232297
    {Coordinate{11.1524, 45.1888}, Tz::Europe_Rome, CountryId{"IT"}}, // Sanguinetto railway station
    {Coordinate{11.3487, 45.1531}, Tz::Europe_Rome, CountryId{"IT"}}, // Villabartolomea railway station
    {Coordinate{11.6964, 45.0457}, Tz::Europe_Rome, CountryId{"IT"}}, // Costa railway station
    {Coordinate{14.1761, 38.018}, Tz::Europe_Rome, CountryId{"IT"}}, // Pollina-San Mauro Castelverde railway station
    {Coordinate{14.2567, 38.008}, Tz::Europe_Rome, CountryId{"IT"}}, // Tusa railway station
    {Coordinate{15.2581, 38.1978}, Tz::Europe_Rome, CountryId{"IT"}}, // Milazzo railway station
    {Coordinate{15.3126, 38.2025}, Tz::Europe_Rome, CountryId{"IT"}}, // Pace del Mela railway station
    {Coordinate{15.3836, 38.2195}, Tz::Europe_Rome, CountryId{"IT"}}, // Spadafora railway station
    {Coordinate{15.4293, 38.2336}, Tz::Europe_Rome, CountryId{"IT"}}, // Villafranca Tirrena-Saponara railway station
    {Coordinate{8.75917, 51.7278}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22329094
    {Coordinate{7.07073, 50.9816}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Dellbrück station
    {Coordinate{15.3892, 40.5618}, Tz::Europe_Rome, CountryId{"IT"}}, // Petina railway station
    {Coordinate{15.4973, 40.5129}, Tz::Europe_Rome, CountryId{"IT"}}, // Polla railway station
    {Coordinate{15.6049, 40.3687}, Tz::Europe_Rome, CountryId{"IT"}}, // Sassano-Teggiano railway station
    {Coordinate{15.6299, 40.3352}, Tz::Europe_Rome, CountryId{"IT"}}, // Padula railway station
    {Coordinate{15.6538, 40.2867}, Tz::Europe_Rome, CountryId{"IT"}}, // Montesano-Buonabitacolo railway station
    {Coordinate{15.686, 40.2141}, Tz::Europe_Rome, CountryId{"IT"}}, // Casalbuono railway station
    {Coordinate{2.07799, 44.5782}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Capdenac
    {Coordinate{30.4639, 49.7158}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zhytni Hory
    {Coordinate{10.123, 53.5864}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Tonndorf station
    {Coordinate{10.1544, 53.6048}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Rahlstedt station
    {Coordinate{3.09396, 49.2501}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villers-Cotterêts
    {Coordinate{1.87291, 49.2612}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2234313
    {Coordinate{3.79287, 47.5289}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2234530
    {Coordinate{4.53607, 50.1915}, Tz::Europe_Brussels, CountryId{"BE"}}, // Philippeville railway station
    {Coordinate{6.37528, 51.4583}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nieukerk
    {Coordinate{5.85444, 50.5878}, Tz::Europe_Brussels, CountryId{"BE"}}, // Verviers-Central railway station
    {Coordinate{5.37944, 49.1656}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2234913
    {Coordinate{-0.476521, 48.1576}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Neau
    {Coordinate{6.27367, 49.3966}, Tz::Europe_Paris, CountryId{"FR"}}, // Kœnigsmacker
    {Coordinate{4.00151, 50.0889}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sains-du-Nord
    {Coordinate{2.30667, 48.6358}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Michel-sur-Orge (Paris RER)
    {Coordinate{5.2357, 51.0507}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beringen railway station
    {Coordinate{4.21097, 50.4303}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leval railway station
    {Coordinate{-0.659722, 44.7934}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2241014
    {Coordinate{1.41854, 43.5934}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulouse-Saint-Cyprien-Arènes
    {Coordinate{4.63883, 51.1135}, Tz::Europe_Brussels, CountryId{"BE"}}, // Berlaar railway station
    {Coordinate{2.19415, 50.9523}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2243517
    {Coordinate{3.12806, 42.4831}, Tz::Europe_Paris, CountryId{"FR"}}, // Banyuls-sur-Mer railway station
    {Coordinate{0.620833, 44.2083}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Agen
    {Coordinate{-0.784, 51.788}, Tz::Europe_London, CountryId{"GB"}}, // Stoke Mandeville railway station
    {Coordinate{8.54028, 47.3778}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Hauptbahnhof
    {Coordinate{3.85767, 49.5269}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2245176
    {Coordinate{1.37167, 43.7381}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Jory
    {Coordinate{0.826667, 44.1267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamagistère
    {Coordinate{7.50241, 51.51}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Körne West station
    {Coordinate{2.37679, 49.2034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2247293
    {Coordinate{16.7442, 53.1431}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Piła Główna
    {Coordinate{2.96216, 50.5918}, Tz::Europe_Paris, CountryId{"FR"}}, // Santes
    {Coordinate{9.76, 48.6833}, Tz::Europe_Berlin, CountryId{"DE"}}, // Süßen station
    {Coordinate{2.15247, 48.8369}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2248860
    {Coordinate{5.62278, 50.6606}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herstal railway station
    {Coordinate{6.847, 45.9124}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2249371
    {Coordinate{-0.100664, 49.2912}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dives-sur-Mer-Port-Guillaume
    {Coordinate{0.109401, 45.8874}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2249657
    {Coordinate{5.95278, 50.8961}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heerlen Woonboulevard railway station
    {Coordinate{1.89024, 48.7218}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2249999
    {Coordinate{0.166206, 48.5999}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sées
    {Coordinate{6.87398, 45.9227}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2250995
    {Coordinate{5.08014, 50.7478}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landen railway station
    {Coordinate{3.88244, 51.0016}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wetteren railway station
    {Coordinate{2.90751, 48.7891}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2252245
    {Coordinate{18.7883, 54.0978}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2253001
    {Coordinate{7.3085, 47.747}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mulhouse-Dornach
    {Coordinate{4.77778, 46.2831}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mâcon-Loché TGV
    {Coordinate{6.22427, 43.2984}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2253083
    {Coordinate{3.03469, 50.6145}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lille-CHR
    {Coordinate{3.73306, 50.8753}, Tz::Europe_Brussels, CountryId{"BE"}}, // Munkzwalm railway station
    {Coordinate{-4.48046, 48.3878}, Tz::Europe_Paris, CountryId{"FR"}}, // Brest railway station
    {Coordinate{2.76306, 48.1481}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dordives
    {Coordinate{5.87318, 50.3691}, Tz::Europe_Brussels, CountryId{"BE"}}, // Trois-Ponts railway station
    {Coordinate{6.60028, 52.4019}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vriezenveen railway station
    {Coordinate{8.74301, 39.462}, Tz::Europe_Rome, CountryId{"IT"}}, // Villacidro railway station
    {Coordinate{8.95763, 39.6204}, Tz::Europe_Rome, CountryId{"IT"}}, // Villamar railway station
    {Coordinate{3.76095, 45.8163}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Noirétable
    {Coordinate{6.93878, 51.1025}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenfeld station
    {Coordinate{4.56583, 52.3028}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hillegom
    {Coordinate{10.5371, 53.337}, Tz::Europe_Berlin, CountryId{"DE"}}, // Echem station
    {Coordinate{3.41931, 50.4433}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Amand-les-Eaux
    {Coordinate{3.36392, 48.9917}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2259679
    {Coordinate{2.36167, 48.9175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Plaine-Stade de France
    {Coordinate{1.8155, 48.8026}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2260519
    {Coordinate{-0.369481, 43.2915}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pau
    {Coordinate{2.37194, 48.9636}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pierrefitte - Stains
    {Coordinate{7.62477, 51.534}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Wickede station
    {Coordinate{4.6275, 52.4042}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bloemendaal railway station
    {Coordinate{4.79626, 45.6073}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2260903
    {Coordinate{1.04907, 44.627}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villefranche-du-Périgord
    {Coordinate{4.01389, 50.7242}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herne railway station
    {Coordinate{4.02247, 49.2336}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2261583
    {Coordinate{3.02011, 50.5154}, Tz::Europe_Paris, CountryId{"FR"}}, // Phalempin
    {Coordinate{7.46493, 48.7518}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2262411
    {Coordinate{0.718873, 49.1076}, Tz::Europe_Paris, CountryId{"FR"}}, // Serquigny
    {Coordinate{2.72694, 48.4161}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fontainebleau–Avon
    {Coordinate{5.32077, 50.6787}, Tz::Europe_Brussels, CountryId{"BE"}}, // Remicourt railway station
    {Coordinate{3.66789, 51.126}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sleidinge railway station
    {Coordinate{5.03361, 52.1353}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maarssen railway station
    {Coordinate{2.27194, 48.8642}, Tz::Europe_Paris, CountryId{"FR"}}, // Avenue Henri Martin
    {Coordinate{19.5715, 46.8575}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ballószög railway station
    {Coordinate{7.10437, 50.9847}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duckterath station
    {Coordinate{7.35695, 43.7224}, Tz::Europe_Paris, CountryId{"FR"}}, // Èze-sur-Mer railway station
    {Coordinate{1.35263, 49.1747}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gaillon - Aubevoye
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q2267282
    {Coordinate{3.02533, 48.9592}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2267427
    {Coordinate{10.4636, 53.2176}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wendisch Evern station
    {Coordinate{10.5552, 53.1991}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vastorf station
    {Coordinate{10.6291, 53.1875}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bavendorf station
    {Coordinate{8.46225, 50.1248}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22677939
    {Coordinate{3.62823, 44.5285}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2267810
    {Coordinate{10.7088, 53.1694}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dahlenburg station
    {Coordinate{10.761, 53.1637}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neetzendorf station
    {Coordinate{-4.20529, 48.4741}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2268018
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22682010
    {Coordinate{6.27778, 52.3917}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Raalte railway station
    {Coordinate{2.14056, 49.9461}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Picquigny
    {Coordinate{5.3446, 47.8771}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2268586
    {Coordinate{2.61194, 49.5031}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Wacquemoulin
    {Coordinate{13.3658, 49.7403}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q2269031
    {Coordinate{12.5949, 52.1359}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Belzig station
    {Coordinate{8.07386, 49.8083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691245
    {Coordinate{9.9125, 51.7972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Einbeck-Salzderhelden station
    {Coordinate{9.0053, 50.0767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691248
    {Coordinate{11.4522, 50.1097}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kulmbach station
    {Coordinate{10.3429, 51.9303}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langelsheim station
    {Coordinate{9.42269, 49.43}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osterburken station
    {Coordinate{9.48499, 48.1497}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22691254
    {Coordinate{12.1314, 51.0564}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zeitz station
    {Coordinate{8.49479, 49.9123}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22692098
    {Coordinate{10.5486, 46.6843}, Tz::Europe_Rome, CountryId{"IT"}}, // Q22692924
    {Coordinate{14.3921, 51.0931}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q22694635
    {Coordinate{16.8775, 48.6863}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bernhardsthal railway station
    {Coordinate{-2.44115, 48.2532}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2269977
    {Coordinate{-2.05276, 48.19}, Tz::Europe_Paris, CountryId{"FR"}}, // Montauban-de-Bretagne Station
    {Coordinate{4.92389, 51.5839}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gilze-Rijen railway station
    {Coordinate{4.65472, 50.7608}, Tz::Europe_Brussels, CountryId{"BE"}}, // Florival railway station
    {Coordinate{39.0792, 45.0514}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q22709418
    {Coordinate{1.91314, 48.9925}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Mureaux
    {Coordinate{5.72306, 52.5339}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dronten railway station
    {Coordinate{4.74722, 52.3858}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Halfweg-Zwanenburg railway station
    {Coordinate{6.14023, 48.2708}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2273195
    {Coordinate{1.32353, 47.5854}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Blois
    {Coordinate{5.98222, 45.7861}, Tz::Europe_Paris, CountryId{"FR"}}, // Albens
    {Coordinate{-1.14273, 44.637}, Tz::Europe_Paris, CountryId{"FR"}}, // La Teste
    {Coordinate{8.75167, 50.1058}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2274451
    {Coordinate{-1.139, 50.678}, Tz::Europe_London, CountryId{"GB"}}, // Brading railway station
    {Coordinate{2.44557, 49.3248}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2274967
    {Coordinate{4.93013, 49.6949}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2275121
    {Coordinate{7.29756, 48.0889}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2275567
    {Coordinate{2.07639, 48.8681}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2276249
    {Coordinate{2.1375, 48.6983}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gif-sur-Yvette
    {Coordinate{6.80687, 47.681}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2277130
    {Coordinate{4.13106, 43.6794}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2277923
    {Coordinate{-0.623787, 44.9176}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2277962
    {Coordinate{1.17803, 45.6918}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nexon
    {Coordinate{3.42436, 50.8917}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waregem railway station
    {Coordinate{7.54601, 50.8091}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dattenfeld station
    {Coordinate{2.76941, 43.1999}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2280048
    {Coordinate{5.81893, 44.3165}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2280269
    {Coordinate{6.3022, 49.4215}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2280858
    {Coordinate{10.9128, 53.1692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leitstade station
    {Coordinate{6.00765, 45.4342}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2281291
    {Coordinate{11.0386, 53.1391}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hitzacker station
    {Coordinate{3.28342, 44.7183}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aumont-Aubrac
    {Coordinate{5.45439, 46.2129}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2281639
    {Coordinate{5.82361, 51.8278}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Goffert railway station
    {Coordinate{3.2776, 49.2911}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2282895
    {Coordinate{2.87973, 42.6963}, Tz::Europe_Paris, CountryId{"FR"}}, // Perpignan railway station
    {Coordinate{4.55258, 50.4291}, Tz::Europe_Brussels, CountryId{"BE"}}, // Farciennes railway station
    {Coordinate{4.66343, 50.4514}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemeppe-sur-Sambre railway station
    {Coordinate{4.8182, 50.1402}, Tz::Europe_Paris, CountryId{"FR"}}, // Givet railway station
    {Coordinate{4.53918, 50.6095}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Roche railway station
    {Coordinate{1.51349, 48.7684}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2284960
    {Coordinate{2.642, 48.976}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mitry – Claye
    {Coordinate{-1.02859, 45.9937}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Laurent Fouras
    {Coordinate{3.94334, 50.2658}, Tz::Europe_Paris, CountryId{"FR"}}, // Louvroil
    {Coordinate{4.24907, 45.6444}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2286280
    {Coordinate{2.8948, 50.3036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rœux
    {Coordinate{4.49028, 51.03}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mechelen-Nekkerspoel railway station
    {Coordinate{1.47842, 49.0912}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vernon
    {Coordinate{1.61008, 50.7155}, Tz::Europe_Paris, CountryId{"FR"}}, // Boulogne-Ville railway station
    {Coordinate{8.87481, 49.2505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sinsheim Central Station
    {Coordinate{4.99528, 50.7714}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ezemaal train station
    {Coordinate{2.33722, 48.8394}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Port-Royal
    {Coordinate{7.96722, 50.5578}, Tz::Europe_Berlin, CountryId{"DE"}}, // Westerburg station
    {Coordinate{7.99535, 45.1613}, Tz::Europe_Rome, CountryId{"IT"}}, // Lauriano railway station
    {Coordinate{8.01924, 45.1585}, Tz::Europe_Rome, CountryId{"IT"}}, // Monteu da Po railway station
    {Coordinate{8.04751, 45.1537}, Tz::Europe_Rome, CountryId{"IT"}}, // Cavagnolo-Brusasco railway station
    {Coordinate{8.05889, 45.1213}, Tz::Europe_Rome, CountryId{"IT"}}, // Brozolo railway halt
    {Coordinate{8.06966, 45.0838}, Tz::Europe_Rome, CountryId{"IT"}}, // Cocconato railway station
    {Coordinate{8.1069, 45.0676}, Tz::Europe_Rome, CountryId{"IT"}}, // Montiglio-Murisengo railway station
    {Coordinate{8.11006, 45.0369}, Tz::Europe_Rome, CountryId{"IT"}}, // Cunico-Scandeluzza railway station
    {Coordinate{8.12885, 44.985}, Tz::Europe_Rome, CountryId{"IT"}}, // Chiusano-Cossombrato railway station
    {Coordinate{8.13032, 44.9653}, Tz::Europe_Rome, CountryId{"IT"}}, // Settime-Cinaglio-Mombarone railway halt
    {Coordinate{5.58944, 52.1408}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barneveld Zuid railway station
    {Coordinate{10.4844, 53.1423}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bienenbüttel station
    {Coordinate{10.5742, 53.0782}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Bevensen station
    {Coordinate{12.5233, 41.8794}, Tz::Europe_Rome, CountryId{"IT"}}, // Roma Tuscolana railway station
    {Coordinate{4.96533, 50.4807}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marche-les-Dames railway station
    {Coordinate{1.52056, 43.3053}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cintegabelle
    {Coordinate{2.92583, 51.2289}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oostende railway station
    {Coordinate{2.263, 42.5417}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2293147
    {Coordinate{10.5923, 52.9076}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stederdorf (Kr Uelzen) station
    {Coordinate{4.20583, 50.6918}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tubize railway station
    {Coordinate{2.44583, 48.73}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2293848
    {Coordinate{15.4268, 40.5365}, Tz::Europe_Rome, CountryId{"IT"}}, // Q22939462
    {Coordinate{7.54271, 47.2042}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn railway station
    {Coordinate{-0.255702, 44.5554}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Langon
    {Coordinate{7.05572, 48.9458}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2294448
    {Coordinate{4.8803, 50.4549}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jambes-Est railway station
    {Coordinate{5.29083, 50.5392}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ampsin railway station
    {Coordinate{10.6556, 52.8926}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wieren station
    {Coordinate{10.7612, 52.8742}, Tz::Europe_Berlin, CountryId{"DE"}}, // Soltendieck station
    {Coordinate{4.38972, 52.0561}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Ypenburg
    {Coordinate{3.49389, 50.8264}, Tz::Europe_Brussels, CountryId{"BE"}}, // Anzegem railway station
    {Coordinate{1.01639, 43.1961}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Martres-Tolosane
    {Coordinate{3.84694, 50.7328}, Tz::Europe_Brussels, CountryId{"BE"}}, // Acren railway station
    {Coordinate{2.20139, 48.5003}, Tz::Europe_Paris, CountryId{"FR"}}, // Étréchy (Paris RER)
    {Coordinate{9.17015, 40.3182}, Tz::Europe_Rome, CountryId{"IT"}}, // Q22963397
    {Coordinate{9.1354, 40.3216}, Tz::Europe_Rome, CountryId{"IT"}}, // Q22964110
    {Coordinate{0.389734, 45.7402}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Rochefoucauld
    {Coordinate{9.03795, 40.3231}, Tz::Europe_Rome, CountryId{"IT"}}, // Iscra railway station
    {Coordinate{3.59167, 50.5136}, Tz::Europe_Brussels, CountryId{"BE"}}, // Péruwelz railway station
    {Coordinate{3.65569, 51.0471}, Tz::Europe_Brussels, CountryId{"BE"}}, // Drongen railway station
    {Coordinate{10.4169, 53.0172}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ebstorf (Kr Uelzen) station
    {Coordinate{10.259, 53.0022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Brockhöfe station
    {Coordinate{10.0962, 52.9933}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munster (Örtze) station
    {Coordinate{4.78472, 51.1683}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wolfstee railway station
    {Coordinate{8.96251, 40.3104}, Tz::Europe_Rome, CountryId{"IT"}}, // Bolotana railway station
    {Coordinate{8.89364, 40.2847}, Tz::Europe_Rome, CountryId{"IT"}}, // Silanus railway station
    {Coordinate{8.84214, 40.2794}, Tz::Europe_Rome, CountryId{"IT"}}, // Bortigali railway station
    {Coordinate{2.3141, 48.8878}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-Cardinet
    {Coordinate{7.49106, 44.6142}, Tz::Europe_Rome, CountryId{"IT"}}, // Manta railway station
    {Coordinate{7.48263, 44.5694}, Tz::Europe_Rome, CountryId{"IT"}}, // Costigliole Saluzzo railway station
    {Coordinate{7.48153, 44.5206}, Tz::Europe_Rome, CountryId{"IT"}}, // Busca railway station
    {Coordinate{4.0685, 50.8768}, Tz::Europe_Brussels, CountryId{"BE"}}, // Iddergem railway station
    {Coordinate{5.815, 50.5364}, Tz::Europe_Brussels, CountryId{"BE"}}, // Theux railway station
    {Coordinate{8.64794, 47.3253}, Tz::Europe_Zurich, CountryId{"CH"}}, // Forch railway station
    {Coordinate{8.7099, 47.2878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Esslingen railway station
    {Coordinate{8.58338, 47.351}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zürich Rehalp railway station
    {Coordinate{7.57407, 44.6421}, Tz::Europe_Rome, CountryId{"IT"}}, // Lagnasco railway halt
    {Coordinate{0.81185, 45.8696}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2300634
    {Coordinate{5.09113, 50.2913}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ciney railway station
    {Coordinate{}, Timezone{}, CountryId{"KZ"}}, // Petropavlovsk train station
    {Coordinate{9.79891, 53.1105}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schneverdingen station
    {Coordinate{9.84521, 53.0272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolterdingen (Han) station
    {Coordinate{9.86112, 53.0015}, Tz::Europe_Berlin, CountryId{"DE"}}, // Soltau (Han) Nord station
    {Coordinate{9.7712, 52.8991}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dorfmark station
    {Coordinate{9.70031, 52.8629}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Fallingbostel station
    {Coordinate{5.91981, 46.7425}, Tz::Europe_Paris, CountryId{"FR"}}, // Q23013004
    {Coordinate{9.60116, 52.8649}, Tz::Europe_Berlin, CountryId{"DE"}}, // Walsrode station
    {Coordinate{7.60808, 50.7972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rosbach station
    {Coordinate{6.84592, 47.6486}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2302057
    {Coordinate{5.45833, 52.1664}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoevelaken railway station
    {Coordinate{8.7305, 40.2819}, Tz::Europe_Rome, CountryId{"IT"}}, // Q23028048
    {Coordinate{6.75806, 52.6944}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Dalen railway station
    {Coordinate{5.04306, 52.1008}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Terwijde railway station
    {Coordinate{-1.47806, 47.1861}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vertou
    {Coordinate{0.849734, 49.6367}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Motteville
    {Coordinate{4.89289, 46.2678}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-de-Veyle
    {Coordinate{2.20083, 49.3811}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montreuil-sur-Thérain
    {Coordinate{9.59529, 52.7663}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hodenhagen station
    {Coordinate{2.3075, 48.9333}, Tz::Europe_Paris, CountryId{"FR"}}, // Gennevilliers
    {Coordinate{9.62449, 52.6786}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schwarmstedt station
    {Coordinate{9.68875, 52.611}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lindwedel station
    {Coordinate{10.433, 52.9051}, Tz::Europe_Berlin, CountryId{"DE"}}, // Suderburg station
    {Coordinate{10.3002, 52.8349}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unterlüß station
    {Coordinate{10.2307, 52.7412}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eschede station
    {Coordinate{7.18727, 48.4249}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2306456
    {Coordinate{10.0626, 52.6209}, Tz::Europe_Berlin, CountryId{"DE"}}, // Celle station
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Laas railway station
    {Coordinate{6.05224, 49.0276}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2306832
    {Coordinate{5.26472, 51.8069}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zaltbommel railway station
    {Coordinate{26.1096, 51.8101}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zarichne
    {Coordinate{1.37778, 50.0631}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Tréport-Mers
    {Coordinate{9.85726, 52.5062}, Tz::Europe_Berlin, CountryId{"DE"}}, // Großburgwedel station
    {Coordinate{9.80309, 52.4858}, Tz::Europe_Berlin, CountryId{"DE"}}, // Isernhagen station
    {Coordinate{-3.68222, 40.4722}, Tz::Europe_Madrid, CountryId{"ES"}}, // Madrid Chamartín station
    {Coordinate{0.956815, 44.9774}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mauzens-Miremont
    {Coordinate{5.3929, 43.3307}, Tz::Europe_Paris, CountryId{"FR"}}, // Picon-Busserine
    {Coordinate{7.00939, 48.8091}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2308590
    {Coordinate{4.05083, 50.9031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Welle railway station
    {Coordinate{5.69981, 49.2843}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2309377
    {Coordinate{1.42583, 43.4333}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Venerque-le-Vernet
    {Coordinate{5.16278, 52.2656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bussum Zuid railway station
    {Coordinate{3.35233, 49.1877}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2309625
    {Coordinate{6.62722, 51.6558}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wesel station
    {Coordinate{4.3366, 47.6187}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montbard
    {Coordinate{4.39417, 50.4122}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marchienne-au-Pont railway station
    {Coordinate{-1.78083, 43.3533}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hendaye
    {Coordinate{5.17886, 43.5008}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2310408
    {Coordinate{-0.199835, 48.1601}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2311391
    {Coordinate{7.49447, 48.3101}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ebersheim
    {Coordinate{3.85627, 50.4499}, Tz::Europe_Brussels, CountryId{"BE"}}, // Quaregnon railway station
    {Coordinate{1.67358, 46.0912}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2312849
    {Coordinate{-2.15559, 48.2844}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2312892
    {Coordinate{5.71833, 44.4247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2313377
    {Coordinate{6.02383, 46.5257}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2314163
    {Coordinate{4.34235, 50.8728}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tour and Taxis railway station
    {Coordinate{0.265307, 46.4267}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2314920
    {Coordinate{1.1264, 48.0738}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2314948
    {Coordinate{3.08139, 42.5267}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2315101
    {Coordinate{-2.0437, 47.5163}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2315187
    {Coordinate{1.38612, 48.1863}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2315461
    {Coordinate{2.15208, 44.0487}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carmaux
    {Coordinate{5.45639, 50.5947}, Tz::Europe_Brussels, CountryId{"BE"}}, // Flémalle-Haute railway station
    {Coordinate{1.49144, 47.1397}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2316810
    {Coordinate{2.37083, 48.5319}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2317284
    {Coordinate{1.76472, 48.8106}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2317468
    {Coordinate{6.3534, 46.9008}, Tz::Europe_Paris, CountryId{"FR"}}, // Pontarlier
    {Coordinate{2.51167, 48.8247}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Boullereaux – Champigny (Paris RER)
    {Coordinate{1.47623, 46.0469}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sulpice-Laurière
    {Coordinate{8.65619, 40.295}, Tz::Europe_Rome, CountryId{"IT"}}, // Q23199378
    {Coordinate{-0.201145, 46.4064}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Maixent (Deux-Sèvres)
    {Coordinate{6.68048, 50.9033}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sindorf station
    {Coordinate{21.0078, 52.2294}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Śródmieście PKP railway station
    {Coordinate{8.55098, 40.2681}, Tz::Europe_Rome, CountryId{"IT"}}, // Q23210654
    {Coordinate{2.41205, 50.8898}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2321493
    {Coordinate{3.07526, 49.1355}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2321640
    {Coordinate{5.46694, 50.5997}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leman railway station
    {Coordinate{7.04694, 51.4936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Zollverein Nord station
    {Coordinate{0.217804, 46.1467}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2322939
    {Coordinate{2.24222, 49.1358}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Champagne-sur-Oise
    {Coordinate{7.35694, 49.2469}, Tz::Europe_Berlin, CountryId{"DE"}}, // Zweibrücken Central Station
    {Coordinate{7.36376, 51.4981}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Germania station
    {Coordinate{2.35194, 48.485}, Tz::Europe_Paris, CountryId{"FR"}}, // La Ferté-Alais Station
    {Coordinate{0.335556, 44.2983}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aiguillon
    {Coordinate{4.11238, 50.3037}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erquelinnes railway station
    {Coordinate{1.06654, 49.8717}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2325583
    {Coordinate{6.93742, 51.1635}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hilden Süd station
    {Coordinate{3.66661, 50.5053}, Tz::Europe_Brussels, CountryId{"BE"}}, // Blaton railway station
    {Coordinate{4.35083, 50.3775}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landelies railway station
    {Coordinate{7.39434, 43.7205}, Tz::Europe_Paris, CountryId{"FR"}}, // Cap-d'Ail
    {Coordinate{2.28111, 48.78}, Tz::Europe_Paris, CountryId{"FR"}}, // Robinson
    {Coordinate{0.192097, 49.506}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2326704
    {Coordinate{19.3403, 47.7051}, Tz::Europe_Budapest, CountryId{"HU"}}, // Váckisújfalu railway station
    {Coordinate{19.2651, 47.7242}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kisnémedi railway station
    {Coordinate{2.16778, 41.39}, Tz::Europe_Madrid, CountryId{"ES"}}, // Passeig de Gràcia
    {Coordinate{20.9656, 52.2194}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2328552
    {Coordinate{18.9636, 47.5413}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q23287275
    {Coordinate{18.9553, 47.5284}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q23288262
    {Coordinate{18.9492, 47.5228}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q23289575
    {Coordinate{18.9509, 47.5149}, Tz::Europe_Budapest, CountryId{"HU"}}, // János-hegy rail station, Budapest
    {Coordinate{18.9617, 47.4981}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q23292616
    {Coordinate{18.9708, 47.4999}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q23292887
    {Coordinate{18.9769, 47.4941}, Tz::Europe_Budapest, CountryId{"HU"}}, // Széchenyi Hill Station (Children's railway, Budapest)
    {Coordinate{18.9744, 47.388}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagytétény railway station
    {Coordinate{2.47177, 48.8352}, Tz::Europe_Paris, CountryId{"FR"}}, // Nogent-sur-Marne (Paris RER)
    {Coordinate{24.2792, 57.1283}, Tz::Europe_Riga, CountryId{"LV"}}, // Carnikava Station
    {Coordinate{4.67557, 50.513}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mazy railway station
    {Coordinate{24.1463, 56.9774}, Tz::Europe_Riga, CountryId{"LV"}}, // Brasa Station
    {Coordinate{24.1563, 56.9655}, Tz::Europe_Riga, CountryId{"LV"}}, // Zemitāni Station
    {Coordinate{24.02, 56.9497}, Tz::Europe_Riga, CountryId{"LV"}}, // Zolitūde Station
    {Coordinate{5.30306, 52.1653}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Soest Zuid railway station
    {Coordinate{5.89038, 50.8665}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Klimmen-Ransdaal railway station
    {Coordinate{5.33447, 46.054}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2330039
    {Coordinate{15.9251, 38.6832}, Tz::Europe_Rome, CountryId{"IT"}}, // Q23301322
    {Coordinate{2.30722, 48.7006}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2330216
    {Coordinate{-1.21165, 48.1225}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vitré
    {Coordinate{6.01472, 51.9431}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Duiven railway station
    {Coordinate{6.30944, 53.2558}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Grijpskerk railway station
    {Coordinate{3.77778, 50.6272}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ath railway station
    {Coordinate{7.13159, 48.3146}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2331565
    {Coordinate{4.33167, 50.7786}, Tz::Europe_Brussels, CountryId{"BE"}}, // Moensberg railway station
    {Coordinate{3.7975, 51.0031}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melle railway station
    {Coordinate{6.295, 51.9583}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Doetinchem railway station
    {Coordinate{5.36972, 52.0642}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maarn railway station
    {Coordinate{-0.066175, 48.1684}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2332424
    {Coordinate{6.11086, 47.2763}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2332908
    {Coordinate{4.23611, 51.9256}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maassluis West railway station
    {Coordinate{5.87692, 43.117}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Seyne-Six-Fours
    {Coordinate{2.20556, 49.0778}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mériel
    {Coordinate{2.12194, 48.8981}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Vésinet – Le Pecq
    {Coordinate{0.716888, 45.8725}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2335798
    {Coordinate{1.62861, 43.0414}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Varilhes
    {Coordinate{24.0516, 56.9417}, Tz::Europe_Riga, CountryId{"LV"}}, // Zasulauks Station
    {Coordinate{3.50898, 50.389}, Tz::Europe_Paris, CountryId{"FR"}}, // Beuvrages
    {Coordinate{2.90944, 49.7639}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nesle
    {Coordinate{7.5332, 48.5428}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dachstein
    {Coordinate{5.85556, 50.4903}, Tz::Europe_Brussels, CountryId{"BE"}}, // Spa railway station
    {Coordinate{4.16592, 50.8746}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ternat railway station
    {Coordinate{2.31333, 48.6531}, Tz::Europe_Paris, CountryId{"FR"}}, // Sainte-Geneviève-des-Bois (Paris RER)
    {Coordinate{6.0998, 49.2559}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2339319
    {Coordinate{-3.98322, 48.7207}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2339910
    {Coordinate{4.02431, 49.8908}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2339922
    {Coordinate{0.429067, 48.7173}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2340022
    {Coordinate{-4.30714, 48.4264}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2340141
    {Coordinate{2.13549, 49.4142}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villers-sur-Thère
    {Coordinate{19.4381, 51.0747}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2341427
    {Coordinate{13.2496, 52.7536}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oranienburg station
    {Coordinate{2.30083, 48.7544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Antony
    {Coordinate{5.16509, 51.1693}, Tz::Europe_Brussels, CountryId{"BE"}}, // Balen railway station
    {Coordinate{-1.0692, 44.6406}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2342346
    {Coordinate{0.595833, 49.0872}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bernay
    {Coordinate{4.15387, 51.0194}, Tz::Europe_Brussels, CountryId{"BE"}}, // Baasrode-South railway station
    {Coordinate{23.6014, 52.074}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2342808
    {Coordinate{-1.11572, 43.5468}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Peyrehorade
    {Coordinate{3.96112, 49.4348}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2342913
    {Coordinate{-3.04612, 48.7769}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Paimpol
    {Coordinate{5.40852, 50.9557}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bokrijk railway station
    {Coordinate{-0.131376, 45.0367}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Coutras
    {Coordinate{13.2888, 52.6885}, Tz::Europe_Berlin, CountryId{"DE"}}, // Birkenwerder station
    {Coordinate{3.6399, 50.9294}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gavere-Asper railway station
    {Coordinate{2.20139, 48.8278}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sèvres – Ville-d'Avray
    {Coordinate{3.91722, 50.7517}, Tz::Europe_Brussels, CountryId{"BE"}}, // Viane-Moerbeke railway station
    {Coordinate{3.19328, 50.604}, Tz::Europe_Paris, CountryId{"FR"}}, // Anstaing
    {Coordinate{2.12328, 50.9787}, Tz::Europe_Paris, CountryId{"FR"}}, // Gravelines
    {Coordinate{2.23373, 48.8835}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Puteaux
    {Coordinate{5.11005, 43.333}, Tz::Europe_Paris, CountryId{"FR"}}, // Sausset-les-Pins train station
    {Coordinate{0.572491, 48.1223}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2346854
    {Coordinate{3.26362, 51.3383}, Tz::Europe_Brussels, CountryId{"BE"}}, // Duinbergen railway station
    {Coordinate{1.43583, 49.6294}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sommery
    {Coordinate{2.54778, 48.6672}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2348110
    {Coordinate{6.27074, 47.1559}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2348604
    {Coordinate{3.74313, 50.1582}, Tz::Europe_Paris, CountryId{"FR"}}, // Hachette railway station
    {Coordinate{6.67611, 52.61}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Gramsbergen railway station
    {Coordinate{4.20583, 50.8669}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Martens-Bodegem railway station
    {Coordinate{5.85944, 51.8644}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nijmegen Lent railway station
    {Coordinate{2.12323, 48.8611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2351194
    {Coordinate{6.57806, 51.9211}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Aalten railway station
    {Coordinate{5.42804, 45.4384}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2351956
    {Coordinate{-2.51139, 48.4658}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamballe
    {Coordinate{1.73028, 50.8053}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marquise-Rinxent
    {Coordinate{-1.75013, 48.5441}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dol-de-Bretagne
    {Coordinate{2.47917, 48.5736}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2353069
    {Coordinate{-0.5958, 49.216}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2353104
    {Coordinate{6.8712, 51.4396}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mülheim West station
    {Coordinate{7.14583, 46.0769}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sembrancher train station
    {Coordinate{5.69417, 50.7442}, Tz::Europe_Brussels, CountryId{"BE"}}, // Visé railway station
    {Coordinate{1.09835, 49.3245}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2355108
    {Coordinate{3.00871, 50.4802}, Tz::Europe_Paris, CountryId{"FR"}}, // Libercourt
    {Coordinate{3.80566, 50.9007}, Tz::Europe_Brussels, CountryId{"BE"}}, // Balegem-Zuid railway station
    {Coordinate{2.25861, 48.9969}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Gros Noyer – Saint-Prix
    {Coordinate{2.42056, 49.1172}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Luzarches
    {Coordinate{5.94361, 51.9881}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnhem Presikhaaf railway station
    {Coordinate{6.03415, 47.2404}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2356506
    {Coordinate{9.67993, 52.3505}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Bornum station
    {Coordinate{2.02315, 46.1228}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2357627
    {Coordinate{4.13417, 51.005}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lebbeke railway station
    {Coordinate{9.66898, 52.3401}, Tz::Europe_Berlin, CountryId{"DE"}}, // Empelde station
    {Coordinate{7.11994, 47.8056}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vieux-Thann
    {Coordinate{2.49956, 49.9117}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2358337
    {Coordinate{0.6077, 46.9723}, Tz::Europe_Paris, CountryId{"FR"}}, // Ormes-sur-Vienne station
    {Coordinate{4.36639, 43.8325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nîmes
    {Coordinate{4.21182, 47.7293}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2360723
    {Coordinate{2.76071, 48.4426}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Héricy
    {Coordinate{4.88564, 50.4282}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dave-Saint-Martin railway station
    {Coordinate{-2.89239, 48.5086}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Plouvara - Plerneuf
    {Coordinate{1.43306, 44.4492}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cahors
    {Coordinate{2.47296, 50.6525}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thiennes
    {Coordinate{-1.42882, 43.5871}, Tz::Europe_Paris, CountryId{"FR"}}, // Labenne
    {Coordinate{1.1717, 47.3438}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2362220
    {Coordinate{3.91369, 50.1321}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2362288
    {Coordinate{2.28811, 43.1121}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pomas
    {Coordinate{5.47203, 45.4918}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Virieu-sur-Bourbre
    {Coordinate{5.4634, 43.4559}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gardanne
    {Coordinate{2.69194, 48.4756}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bois-le-Roi
    {Coordinate{3.22003, 48.974}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2363439
    {Coordinate{4.26356, 50.4479}, Tz::Europe_Brussels, CountryId{"BE"}}, // Carnières railway station
    {Coordinate{-1.49076, 43.5235}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boucau
    {Coordinate{7.14861, 46.0525}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2365843
    {Coordinate{4.21622, 45.5222}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bonson
    {Coordinate{7.04899, 48.9655}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2366623
    {Coordinate{8.47959, 40.2901}, Tz::Europe_Rome, CountryId{"IT"}}, // Q23666993
    {Coordinate{2.35083, 49.0794}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villaines
    {Coordinate{8.50121, 40.2928}, Tz::Europe_Rome, CountryId{"IT"}}, // Q23671458
    {Coordinate{-1.60989, 43.4254}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guéthary
    {Coordinate{9.60891, 52.2851}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lemmie station
    {Coordinate{9.57217, 52.2795}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wennigsen (Deister) station
    {Coordinate{30.4828, 50.4892}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zenit
    {Coordinate{10.5308, 44.698}, Tz::Europe_Rome, CountryId{"IT"}}, // Cavriago railway station
    {Coordinate{1.22471, 49.2339}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-du-Vauvray
    {Coordinate{35.3114, 54.9878}, Tz::Europe_Moscow, CountryId{"RU"}}, // Iznoski
    {Coordinate{9.51323, 52.2788}, Tz::Europe_Berlin, CountryId{"DE"}}, // Egestorf (Deister) station
    {Coordinate{}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Neumarkt-Kallham
    {Coordinate{21.0178, 52.2636}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Zoo railway station
    {Coordinate{10.4692, 44.6641}, Tz::Europe_Rome, CountryId{"IT"}}, // Bibbiano railway station
    {Coordinate{9.49163, 52.2902}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirchdorf (Deister) station
    {Coordinate{6.9418, 50.9588}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Nippes station
    {Coordinate{9.43614, 52.3234}, Tz::Europe_Berlin, CountryId{"DE"}}, // Winninghausen station
    {Coordinate{9.41777, 52.3322}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bantorf station
    {Coordinate{9.37839, 52.344}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Nenndorf station
    {Coordinate{1.62706, 50.6827}, Tz::Europe_Paris, CountryId{"FR"}}, // Pont-de-Briques
    {Coordinate{5.8185, 49.5927}, Tz::Europe_Brussels, CountryId{"BE"}}, // Messancy railway station
    {Coordinate{2.51361, 48.8533}, Tz::Europe_Paris, CountryId{"FR"}}, // Neuilly-Plaisance
    {Coordinate{3.87486, 50.587}, Tz::Europe_Brussels, CountryId{"BE"}}, // Cambron-Casteau railway station
    {Coordinate{1.34083, 44.0139}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montauban-Ville-Bourbon
    {Coordinate{7.25166, 48.4982}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2373826
    {Coordinate{1.39972, 43.4792}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pins-Justaret
    {Coordinate{5.085, 52.6533}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoorn Kersenboogerd railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q2375438
    {Coordinate{-3.32228, 48.5935}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2375803
    {Coordinate{6.146, 51.7896}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kleve
    {Coordinate{5.63663, 47.036}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2376752
    {Coordinate{3.10583, 51.0648}, Tz::Europe_Brussels, CountryId{"BE"}}, // Torhout railway station
    {Coordinate{7.46285, 48.5336}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2377439
    {Coordinate{6.08562, 46.142}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Julien-en-Genevois
    {Coordinate{}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q23784034
    {Coordinate{2.82278, 46.9993}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2378542
    {Coordinate{6.66388, 51.373}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Hohenbudberg Chempark station
    {Coordinate{7.17335, 51.6676}, Tz::Europe_Berlin, CountryId{"DE"}}, // Marl-Sinsen station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q23787924
    {Coordinate{8.19612, 47.801}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q23787942
    {Coordinate{3.15989, 50.622}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ascq
    {Coordinate{1.98578, 46.9488}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2379431
    {Coordinate{-0.321485, 44.605}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Barsac
    {Coordinate{2.45472, 48.9325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Drancy
    {Coordinate{7.60346, 47.4534}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2381221
    {Coordinate{5.81312, 45.5363}, Tz::Europe_Paris, CountryId{"FR"}}, // Aiguebelette-le-Lac
    {Coordinate{-2.05353, 48.4568}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dinan
    {Coordinate{4.81803, 45.6272}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2382041
    {Coordinate{6.16738, 50.8675}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Kellersberg station
    {Coordinate{9.96256, 52.318}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sehnde station
    {Coordinate{9.96658, 52.252}, Tz::Europe_Berlin, CountryId{"DE"}}, // Algermissen station
    {Coordinate{0.354206, 49.5836}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2382506
    {Coordinate{9.96576, 52.2076}, Tz::Europe_Berlin, CountryId{"DE"}}, // Harsum station
    {Coordinate{2.25794, 48.9135}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Vallées
    {Coordinate{44.4597, 48.6683}, Tz::Europe_Volgograd, CountryId{"RU"}}, // Yelshanka railway station
    {Coordinate{44.4406, 48.5808}, Tz::Europe_Volgograd, CountryId{"RU"}}, // Q23831003
    {Coordinate{3.04876, 45.7948}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Durtol - Nohanent
    {Coordinate{1.09824, 49.7155}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2383414
    {Coordinate{3.16155, 45.7921}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aulnat-Aéroport
    {Coordinate{6.49402, 46.5111}, Tz::Europe_Zurich, CountryId{"CH"}}, // Morges railway station
    {Coordinate{5.1347, 47.1938}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longecourt
    {Coordinate{1.00817, 44.9412}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Eyzies
    {Coordinate{3.62421, 49.5706}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laon
    {Coordinate{7.02556, 47.6178}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2385464
    {Coordinate{1.41938, 43.5736}, Tz::Europe_Paris, CountryId{"FR"}}, // Gallieni-Cancéropôle
    {Coordinate{5.54444, 51.2461}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hamont railway station
    {Coordinate{4.74936, 46.907}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2386091
    {Coordinate{1.97292, 48.2566}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boisseaux
    {Coordinate{6.84861, 52.7183}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nieuw Amsterdam railway station
    {Coordinate{3.25019, 49.6276}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2386825
    {Coordinate{2.01806, 42.4633}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2387136
    {Coordinate{21.155, 51.3911}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Radom railway station
    {Coordinate{9.86588, 52.1624}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emmerke station
    {Coordinate{2.264, 48.9704}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sannois
    {Coordinate{4.99278, 51.8719}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arkel railway station
    {Coordinate{1.65722, 50.0825}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Acheux-Franleu
    {Coordinate{5.83162, 45.963}, Tz::Europe_Paris, CountryId{"FR"}}, // Seyssel - Corbonod
    {Coordinate{7.48189, 43.7623}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2388773
    {Coordinate{0.6334, 47.2011}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2389054
    {Coordinate{5.69048, 48.3582}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2389073
    {Coordinate{5.0875, 49.9072}, Tz::Europe_Brussels, CountryId{"BE"}}, // Carlsbourg railway station
    {Coordinate{4.69434, 50.4529}, Tz::Europe_Brussels, CountryId{"BE"}}, // Moustier railway station
    {Coordinate{-2.14141, 48.496}, Tz::Europe_Paris, CountryId{"FR"}}, // Station Corseul - Languenan
    {Coordinate{3.18472, 49.7194}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Flavy-le-Martel
    {Coordinate{4.50944, 51.9053}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rotterdam Zuid railway station
    {Coordinate{6.98667, 43.5489}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cannes-La Bocca
    {Coordinate{6.66042, 50.224}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gerolstein station
    {Coordinate{9.81487, 52.1952}, Tz::Europe_Berlin, CountryId{"DE"}}, // Barnten station
    {Coordinate{9.81922, 52.2862}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rethen (Leine) station
    {Coordinate{3.96283, 50.9295}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erpe-Mere railway station
    {Coordinate{2.075, 48.5375}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2390290
    {Coordinate{1.70229, 47.3325}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2390460
    {Coordinate{-1.44101, 47.2652}, Tz::Europe_Paris, CountryId{"FR"}}, // Thouaré
    {Coordinate{9.6907, 52.4084}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Ledeburg station
    {Coordinate{0.098889, 48.4342}, Tz::Europe_Paris, CountryId{"FR"}}, // Alençon railway station
    {Coordinate{9.70765, 52.4241}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hannover-Vinnhorst station
    {Coordinate{6.57093, 49.9987}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bitburg-Erdorf station
    {Coordinate{9.72587, 52.4407}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenhagen Mitte station
    {Coordinate{1.34028, 44.6533}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2391846
    {Coordinate{9.73636, 52.48}, Tz::Europe_Berlin, CountryId{"DE"}}, // Langenhagen-Kaltenweide station
    {Coordinate{9.74813, 52.5225}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bissendorf station
    {Coordinate{9.7443, 52.5486}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mellendorf station
    {Coordinate{9.72673, 52.5811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bennemühlen station
    {Coordinate{6.28133, 51.1451}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wegberg
    {Coordinate{6.58096, 50.3448}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jünkerath station
    {Coordinate{7.41993, 51.5001}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Dorstfeld Süd station
    {Coordinate{9.65319, 52.272}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holtensen/Linderte station
    {Coordinate{3.57993, 47.8508}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2393009
    {Coordinate{-1.73947, 48.0432}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2393189
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bernburg station
    {Coordinate{5.24857, 50.6945}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waremme railway station
    {Coordinate{3.92127, 50.8016}, Tz::Europe_Brussels, CountryId{"BE"}}, // Idegem railway station
    {Coordinate{2.5525, 48.8769}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Chénay – Gagny
    {Coordinate{4.99581, 50.3875}, Tz::Europe_Brussels, CountryId{"BE"}}, // Courrière railway station
    {Coordinate{2.04, 48.933}, Tz::Europe_Paris, CountryId{"FR"}}, // Poissy station
    {Coordinate{0.522922, 45.1389}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Astier
    {Coordinate{6.15667, 51.3725}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Blerick railway station
    {Coordinate{3.99065, 49.3466}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2395523
    {Coordinate{5.60648, 44.8269}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2395629
    {Coordinate{2.27278, 49.3403}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Heilles-Mouchy
    {Coordinate{4.725, 49.7678}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Charleville-Mézières
    {Coordinate{-0.611786, 44.9744}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2395750
    {Coordinate{6.08389, 52.1781}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Klarenbeek railway station
    {Coordinate{3.82944, 50.9914}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kwatrecht railway station
    {Coordinate{9.66535, 52.2403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bennigsen station
    {Coordinate{9.62626, 52.2118}, Tz::Europe_Berlin, CountryId{"DE"}}, // Völksen/Eldagsen station
    {Coordinate{9.55659, 52.2152}, Tz::Europe_Berlin, CountryId{"DE"}}, // Springe station
    {Coordinate{2.00889, 48.5331}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2398073
    {Coordinate{9.46804, 52.1778}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Münder (Deister) station
    {Coordinate{-1.59472, 48.0144}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Armel
    {Coordinate{2.74486, 49.0963}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2398897
    {Coordinate{5.87583, 50.9386}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schinnen railway station
    {Coordinate{2.23987, 48.9095}, Tz::Europe_Paris, CountryId{"FR"}}, // La Garenne-Colombes
    {Coordinate{4.82339, 50.984}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aarschot railway station
    {Coordinate{9.38306, 52.0463}, Tz::Europe_Berlin, CountryId{"DE"}}, // Emmerthal station
    {Coordinate{9.27286, 51.9744}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Pyrmont station
    {Coordinate{9.15164, 51.9223}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schieder station
    {Coordinate{9.08854, 51.8683}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinheim (Westf) station
    {Coordinate{0.942812, 44.9057}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Bugue
    {Coordinate{5.19417, 52.0631}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bunnik railway station
    {Coordinate{0.640734, 47.4313}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2401102
    {Coordinate{4.49491, 50.2369}, Tz::Europe_Brussels, CountryId{"BE"}}, // Yves-Gomezée railway station
    {Coordinate{6.52832, 48.1199}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2401925
    {Coordinate{0.375503, 49.7595}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2402132
    {Coordinate{0.314167, 44.3928}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tonneins
    {Coordinate{2.22743, 42.5237}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2402394
    {Coordinate{2.51905, 48.9267}, Tz::Europe_Paris, CountryId{"FR"}}, // Freinville – Sevran railway station
    {Coordinate{2.02901, 42.4428}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2402792
    {Coordinate{9.97921, 52.4032}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aligse station
    {Coordinate{10.0172, 52.4876}, Tz::Europe_Berlin, CountryId{"DE"}}, // Otze station
    {Coordinate{10.0296, 52.5236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ehlershausen station
    {Coordinate{3.09647, 50.6177}, Tz::Europe_Paris, CountryId{"FR"}}, // Mont-de-Terre
    {Coordinate{2.19337, 48.9684}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2403653
    {Coordinate{5.01611, 44.7301}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2404429
    {Coordinate{6.792, 51.21}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Volksgarten station
    {Coordinate{9.24399, 52.1665}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hessisch Oldendorf station
    {Coordinate{9.53722, 52.1194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Coppenbrügge station
    {Coordinate{9.58295, 52.1015}, Tz::Europe_Berlin, CountryId{"DE"}}, // Voldagsen station
    {Coordinate{9.63572, 52.0974}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osterwald station
    {Coordinate{9.74705, 52.1205}, Tz::Europe_Berlin, CountryId{"DE"}}, // Elze (Han) station
    {Coordinate{-0.600833, 43.0522}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sarrance
    {Coordinate{9.29111, 49.4333}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2405473
    {Coordinate{2.58128, 44.3619}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rodez
    {Coordinate{7.6933, 48.5631}, Tz::Europe_Paris, CountryId{"FR"}}, // Strasbourg-Roethig
    {Coordinate{3.05953, 50.4276}, Tz::Europe_Paris, CountryId{"FR"}}, // Leforest
    {Coordinate{3.07247, 50.6608}, Tz::Europe_Paris, CountryId{"FR"}}, // La Madeleine
    {Coordinate{0.235974, 46.2276}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2406713
    {Coordinate{-0.631747, 44.8044}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pessac
    {Coordinate{2.29384, 50.997}, Tz::Europe_Paris, CountryId{"FR"}}, // Courghain
    {Coordinate{1.37746, 45.9046}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Bardys
    {Coordinate{2.25936, 43.5426}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2408107
    {Coordinate{7.07994, 49.0138}, Tz::Europe_Paris, CountryId{"FR"}}, // Herbitzheim
    {Coordinate{11.0312, 51.7459}, Tz::Europe_Berlin, CountryId{"DE"}}, // Thale Central Station
    {Coordinate{6.145, 53.2564}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Buitenpost railway station
    {Coordinate{6.54, 53.2911}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sauwerd railway station
    {Coordinate{1.0508, 49.48}, Tz::Europe_Paris, CountryId{"FR"}}, // Maromme
    {Coordinate{7.0528, 50.9156}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Frankfurter Straße station
    {Coordinate{5.4306, 50.6608}, Tz::Europe_Brussels, CountryId{"BE"}}, // Voroux railway station
    {Coordinate{3.19615, 44.4475}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2410794
    {Coordinate{2.13056, 49.0604}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2410901
    {Coordinate{2.60279, 49.31}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-Sainte-Maxence
    {Coordinate{3.8853, 50.4526}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemappes railway station
    {Coordinate{2.51278, 48.795}, Tz::Europe_Paris, CountryId{"FR"}}, // La Varenne – Chennevières (Paris RER)
    {Coordinate{7.38006, 49.0007}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Lemberg
    {Coordinate{0.750208, 49.6222}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2411757
    {Coordinate{3.68207, 50.1284}, Tz::Europe_Paris, CountryId{"FR"}}, // Landrecies railway station
    {Coordinate{3.05108, 50.6724}, Tz::Europe_Paris, CountryId{"FR"}}, // Marquette
    {Coordinate{6.13072, 48.773}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2412350
    {Coordinate{6.73794, 47.0556}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2412486
    {Coordinate{-0.395564, 44.6744}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Arbanats
    {Coordinate{4.63917, 52.4428}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Driehuis railway station
    {Coordinate{7.13723, 48.3601}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2412987
    {Coordinate{4.65724, 43.8011}, Tz::Europe_Paris, CountryId{"FR"}}, // Tarascon
    {Coordinate{5.90747, 47.1847}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2413225
    {Coordinate{2.19139, 48.5772}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2413575
    {Coordinate{5.855, 51.9167}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Elst railway station
    {Coordinate{2.21472, 48.9014}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nanterre – Université
    {Coordinate{3.15873, 50.5492}, Tz::Europe_Paris, CountryId{"FR"}}, // Ennevelin
    {Coordinate{7.03779, 48.2658}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2415356
    {Coordinate{4.63278, 50.9003}, Tz::Europe_Brussels, CountryId{"BE"}}, // Veltem railway station
    {Coordinate{2.15611, 48.8853}, Tz::Europe_Paris, CountryId{"FR"}}, // Chatou – Croissy
    {Coordinate{2.28, 48.8531}, Tz::Europe_Paris, CountryId{"FR"}}, // Avenue du Président Kennedy
    {Coordinate{6.39508, 49.0143}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2417113
    {Coordinate{3.48828, 51.0835}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bellem railway station
    {Coordinate{3.38682, 51.1075}, Tz::Europe_Brussels, CountryId{"BE"}}, // Maria-Aalter railway station
    {Coordinate{12.0971, 45.3855}, Tz::Europe_Rome, CountryId{"IT"}}, // Casello 11 railway station
    {Coordinate{2.60254, 51.0773}, Tz::Europe_Brussels, CountryId{"BE"}}, // De Panne railway station
    {Coordinate{-1.811, 52.484}, Tz::Europe_London, CountryId{"GB"}}, // Stechford railway station
    {Coordinate{5.12385, 46.2448}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2419249
    {Coordinate{7.73998, 45.3497}, Tz::Europe_Rome, CountryId{"IT"}}, // Ozegna railway station
    {Coordinate{12.4878, 54.2511}, Tz::Europe_Berlin, CountryId{"DE"}}, // Ribnitz-Damgarten Ost railway station
    {Coordinate{0.610432, 43.0211}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Loures-Barbazan
    {Coordinate{2.275, 48.8564}, Tz::Europe_Paris, CountryId{"FR"}}, // Boulainvilliers
    {Coordinate{2.13611, 48.7958}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Versailles-Chantiers
    {Coordinate{5.1582, 47.1673}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aiserey
    {Coordinate{1.93686, 49.1627}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chars
    {Coordinate{2.58333, 48.5967}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2424302
    {Coordinate{3.49382, 48.498}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2424780
    {Coordinate{2.22106, 48.8717}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Suresnes-Mont-Valérien
    {Coordinate{7.44976, 48.3823}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2424815
    {Coordinate{5.21211, 47.1315}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Brazey-en-Plaine
    {Coordinate{1.7025, 50.1089}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quesnoy-le-Montant
    {Coordinate{5.69984, 45.1251}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2425885
    {Coordinate{27.9261, 47.7861}, Tz::Europe_Chisinau, CountryId{"MD"}}, // Q2425970
    {Coordinate{12.4007, 42.4004}, Tz::Europe_Rome, CountryId{"IT"}}, // Castel Bagnolo di Orte railway station
    {Coordinate{5.073, 47.2557}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ouges
    {Coordinate{12.2581, 42.3039}, Tz::Europe_Rome, CountryId{"IT"}}, // Caprarola railway station
    {Coordinate{7.7157, 45.3809}, Tz::Europe_Rome, CountryId{"IT"}}, // Castellamonte railway station
    {Coordinate{13.7809, 37.3636}, Tz::Europe_Rome, CountryId{"IT"}}, // Castrofilippo railway station
    {Coordinate{7.11802, 50.7146}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bonn UN Campus station
    {Coordinate{10.0203, 52.0977}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Düngen station
    {Coordinate{4.09972, 51.0228}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dendermonde railway station
    {Coordinate{2.37509, 51.0175}, Tz::Europe_Paris, CountryId{"FR"}}, // Coudekerque-Branche
    {Coordinate{2.1525, 48.695}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Hacquinière
    {Coordinate{10.0342, 52.0811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wesseln station
    {Coordinate{10.0186, 52.0701}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24278926
    {Coordinate{10.0055, 52.0626}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24278951
    {Coordinate{2.02241, 47.5938}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamotte-Beuvron
    {Coordinate{2.03211, 48.3485}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monnerville
    {Coordinate{9.75051, 52.0659}, Tz::Europe_Berlin, CountryId{"DE"}}, // Banteln station
    {Coordinate{9.89897, 51.9281}, Tz::Europe_Berlin, CountryId{"DE"}}, // Freden (Leine) station
    {Coordinate{7.68499, 48.521}, Tz::Europe_Paris, CountryId{"FR"}}, // Geispolsheim
    {Coordinate{6.17361, 51.7583}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bedburg-Hau
    {Coordinate{0.4412, 46.7288}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2430077
    {Coordinate{3.98169, 49.8596}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2430408
    {Coordinate{5.61639, 53.0147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // IJlst railway station
    {Coordinate{-0.0749, 49.0708}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mézidon
    {Coordinate{2.86901, 51.0327}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diksmuide railway station
    {Coordinate{6.10238, 47.2096}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2432168
    {Coordinate{2.0407, 48.8074}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2433863
    {Coordinate{2.07942, 48.8811}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mareil-Marly
    {Coordinate{-3.46686, 48.6062}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Plouaret-Trégor
    {Coordinate{2.47879, 50.5616}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2435363
    {Coordinate{2.46222, 48.7081}, Tz::Europe_Paris, CountryId{"FR"}}, // Montgeron - Crosne railway station
    {Coordinate{4.29314, 45.5659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2437593
    {Coordinate{2.48584, 42.6428}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2437638
    {Coordinate{5.05181, 43.34}, Tz::Europe_Paris, CountryId{"FR"}}, // La Couronne-Carro train station
    {Coordinate{2.41111, 48.7642}, Tz::Europe_Paris, CountryId{"FR"}}, // Choisy-le-Roi
    {Coordinate{4.74883, 50.5338}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beuzet railway station
    {Coordinate{4.36976, 49.5043}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2438613
    {Coordinate{4.82583, 50.4542}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ronet railway station
    {Coordinate{6.33696, 47.914}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2441064
    {Coordinate{4.55361, 51.8544}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Barendrecht railway station
    {Coordinate{3.90944, 50.3414}, Tz::Europe_Brussels, CountryId{"BE"}}, // Quévy railway station
    {Coordinate{5.58356, 50.5705}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tilff railway station
    {Coordinate{8.01757, 49.6619}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24420931
    {Coordinate{6.00333, 52.2147}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Apeldoorn Osseveld railway station
    {Coordinate{9.6205, 51.881}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stadtoldendorf station
    {Coordinate{4.35583, 51.0664}, Tz::Europe_Brussels, CountryId{"BE"}}, // Willebroek railway station
    {Coordinate{0.252373, 49.5286}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Laurent - Gainneville
    {Coordinate{2.4611, 45.6452}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2442991
    {Coordinate{-0.814696, 46.7523}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pouzauges
    {Coordinate{2.29167, 48.7875}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2443290
    {Coordinate{1.41694, 50.0542}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Eu
    {Coordinate{5.77869, 45.8432}, Tz::Europe_Paris, CountryId{"FR"}}, // Culoz
    {Coordinate{-3.70651, 47.9267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bannalec
    {Coordinate{9.45376, 51.8201}, Tz::Europe_Berlin, CountryId{"DE"}}, // Holzminden station
    {Coordinate{9.4273, 51.7911}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lüchtringen station
    {Coordinate{9.3571, 51.7353}, Tz::Europe_Berlin, CountryId{"DE"}}, // Godelheim station
    {Coordinate{7.42451, 51.3523}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagen-Heubing station
    {Coordinate{0.069498, 43.2402}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tarbes
    {Coordinate{4.55917, 51.1361}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lier railway station
    {Coordinate{7.11079, 48.3471}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saales
    {Coordinate{2.70425, 48.8821}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2447714
    {Coordinate{-0.325965, 45.6844}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2448097
    {Coordinate{6.17594, 46.0109}, Tz::Europe_Paris, CountryId{"FR"}}, // Pringy
    {Coordinate{6.83701, 48.4038}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Raon-l'Étape
    {Coordinate{2.84611, 45.8208}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2448758
    {Coordinate{1.34362, 45.8847}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2450041
    {Coordinate{5.98, 51.9947}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Velp railway station
    {Coordinate{7.47699, 48.8727}, Tz::Europe_Paris, CountryId{"FR"}}, // Ingwiller
    {Coordinate{-1.0254, 48.1136}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2453000
    {Coordinate{0.694498, 48.2672}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2453056
    {Coordinate{5.93806, 50.625}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dolhain-Gileppe railway station
    {Coordinate{5.61444, 52.3011}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ermelo railway station
    {Coordinate{4.99, 51.1689}, Tz::Europe_Brussels, CountryId{"BE"}}, // Geel railway station
    {Coordinate{2.56694, 48.9442}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2453871
    {Coordinate{6.13845, 43.2831}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2454091
    {Coordinate{3.12073, 50.2863}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2454325
    {Coordinate{3.25194, 49.7383}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montescourt
    {Coordinate{1.92087, 48.7436}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2455021
    {Coordinate{3.61609, 49.3052}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2455391
    {Coordinate{2.39068, 42.6034}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ria
    {Coordinate{4.46111, 51.3981}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heide railway station
    {Coordinate{8.585, 48.0878}, Tz::Europe_Berlin, CountryId{"DE"}}, // Trossingen station
    {Coordinate{2.26881, 48.9055}, Tz::Europe_Paris, CountryId{"FR"}}, // Bécon-les-Bruyères
    {Coordinate{5.31333, 50.2025}, Tz::Europe_Brussels, CountryId{"BE"}}, // Marloie railway station
    {Coordinate{2.63667, 47.6989}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gien
    {Coordinate{2.87749, 50.6806}, Tz::Europe_Paris, CountryId{"FR"}}, // Armentières
    {Coordinate{3.21897, 50.5405}, Tz::Europe_Paris, CountryId{"FR"}}, // Cobrieux
    {Coordinate{1.46889, 43.3486}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Auterive
    {Coordinate{2.28778, 49.1136}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Presles-Courcelles
    {Coordinate{-1.1521, 46.1676}, Tz::Europe_Paris, CountryId{"FR"}}, // La Rochelle-Porte Dauphine
    {Coordinate{7.07667, 48.2896}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2459131
    {Coordinate{4.64806, 52.0556}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Waddinxveen Noord railway station
    {Coordinate{5.25778, 51.1175}, Tz::Europe_Brussels, CountryId{"BE"}}, // Leopoldsburg railway station
    {Coordinate{5.28604, 50.6852}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bleret railway station
    {Coordinate{4.93384, 45.6866}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Priest
    {Coordinate{8.73407, 44.4725}, Tz::Europe_Rome, CountryId{"IT"}}, // Q2460876
    {Coordinate{3.03919, 43.02}, Tz::Europe_Paris, CountryId{"FR"}}, // Port-la-Nouvelle
    {Coordinate{-1.94905, 48.1388}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2461161
    {Coordinate{-3.55306, 47.8694}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quimperlé
    {Coordinate{1.01029, 49.3027}, Tz::Europe_Paris, CountryId{"FR"}}, // Elbeuf - Saint-Aubin
    {Coordinate{9.98111, 53.4606}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hamburg-Harburg Rathaus
    {Coordinate{2.20972, 49.1144}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Isle-Adam – Parmain
    {Coordinate{6.42528, 52.1667}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lochem railway station
    {Coordinate{6.05694, 50.8614}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kerkrade Centrum railway station
    {Coordinate{4.66556, 51.1594}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nijlen railway station
    {Coordinate{5.68063, 45.5245}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-de-Beauvoisin
    {Coordinate{4.30208, 50.7664}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beersel railway station
    {Coordinate{4.81722, 44.7544}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2462836
    {Coordinate{5.23722, 43.4425}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2462992
    {Coordinate{7.08997, 51.3135}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Neviges station
    {Coordinate{5.61673, 50.6077}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chênée railway station
    {Coordinate{5.23411, 51.0871}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beverlo railway station
    {Coordinate{2.07833, 49.0139}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Neuville – Université
    {Coordinate{10.6174, 48.0456}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2464536
    {Coordinate{7.02314, 51.4399}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen Süd station
    {Coordinate{6.6326, 44.89}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Briançon
    {Coordinate{5.20105, 47.0463}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pagny (Côte-d'Or)
    {Coordinate{8.72967, 47.9362}, Tz::Europe_Berlin, CountryId{"DE"}}, // Immendingen station
    {Coordinate{11.3133, 50.9717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24652564
    {Coordinate{2.95238, 50.4169}, Tz::Europe_Paris, CountryId{"FR"}}, // Hénin-Beaumont
    {Coordinate{2.95464, 48.8105}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2466859
    {Coordinate{2.295, 48.8736}, Tz::Europe_Paris, CountryId{"FR"}}, // Charles-de-Gaulle - Étoile
    {Coordinate{2.17111, 48.5644}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2467699
    {Coordinate{24.6561, 60.205}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Espoo railway station
    {Coordinate{0.639181, 48.1865}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2468105
    {Coordinate{2.18444, 48.9206}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Houilles – Carrières-sur-Seine
    {Coordinate{4.80022, 51.0225}, Tz::Europe_Brussels, CountryId{"BE"}}, // Begijnendijk railway station
    {Coordinate{5.7546, 44.5195}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2468651
    {Coordinate{4.70161, 46.9107}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2468656
    {Coordinate{6.90296, 51.2204}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkrath station
    {Coordinate{-3.49072, 48.3406}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2469362
    {Coordinate{7.18293, 50.9015}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q24706440
    {Coordinate{5.53139, 52.0281}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenendaal West railway station
    {Coordinate{4.64556, 52.2597}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Nieuw Vennep railway station
    {Coordinate{5.25361, 43.4097}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pas-des-Lanciers
    {Coordinate{20.9753, 50.0053}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Tarnów
    {Coordinate{0.183945, 49.5325}, Tz::Europe_Paris, CountryId{"FR"}}, // Jacques-Monod-la-Demi-Lieue station
    {Coordinate{4.64944, 52.0447}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Waddinxveen railway station
    {Coordinate{7.08083, 51.4692}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Kray Nord station
    {Coordinate{2.36876, 51.0304}, Tz::Europe_Paris, CountryId{"FR"}}, // Dunkirk railway station
    {Coordinate{1.05456, 48.7608}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2475867
    {Coordinate{5.04032, 43.5512}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Chamas
    {Coordinate{14.5497, 53.4186}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Szczecin Główny
    {Coordinate{4.96667, 52.5114}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Purmerend Overwhere railway station
    {Coordinate{4.32361, 50.8025}, Tz::Europe_Brussels, CountryId{"BE"}}, // Uccle-Stalle railway station
    {Coordinate{4.49212, 46.0611}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamure-sur-Azergues
    {Coordinate{0.576, 47.111}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2478637
    {Coordinate{5.87417, 51.7267}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Cuijk railway station
    {Coordinate{5.33176, 49.7071}, Tz::Europe_Brussels, CountryId{"BE"}}, // Florenville railway station
    {Coordinate{4.32056, 50.8092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Forest-East railway station
    {Coordinate{5.2243, 47.2443}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Genlis
    {Coordinate{0.3727, 46.6515}, Tz::Europe_Paris, CountryId{"FR"}}, // Chasseneuil station
    {Coordinate{5.36236, 44.7587}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Die
    {Coordinate{5.02619, 50.4921}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sclaigneaux railway station
    {Coordinate{5.50944, 50.6611}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ans railway station
    {Coordinate{5.31889, 51.5847}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boxtel railway station
    {Coordinate{-1.4356, 46.6726}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Roche-sur-Yon
    {Coordinate{9.7389, 47.4174}, Tz::Europe_Vienna, CountryId{"AT"}}, // Dornbirn station
    {Coordinate{6.11119, 46.4545}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Givrine station
    {Coordinate{3.7238, 50.4648}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ville-Pommerœul railway station
    {Coordinate{6.33562, 48.3435}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2482640
    {Coordinate{0.853056, 43.1047}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Labarthe-Inard
    {Coordinate{-0.550776, 48.1413}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2483118
    {Coordinate{6.60472, 47.0536}, Tz::Europe_Paris, CountryId{"FR"}}, // Morteau
    {Coordinate{1.41389, 43.6639}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2484686
    {Coordinate{-1.58748, 48.8384}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Granville
    {Coordinate{4.39944, 45.4433}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Étienne-Châteaucreux
    {Coordinate{4.70083, 52.6}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Heiloo railway station
    {Coordinate{6.15641, 49.408}, Tz::Europe_Paris, CountryId{"FR"}}, // Hettange-Grande railway station
    {Coordinate{4.70972, 51.0733}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heist-op-den-Berg railway station
    {Coordinate{2.77444, 48.8561}, Tz::Europe_Paris, CountryId{"FR"}}, // Val d'Europe
    {Coordinate{6.69029, 51.1858}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuss Süd station
    {Coordinate{1.31113, 45.5077}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Coussac-Bonneval
    {Coordinate{6.56667, 52.4761}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geerdijk railway station
    {Coordinate{-1.81834, 47.8224}, Tz::Europe_Paris, CountryId{"FR"}}, // Messac - Guipry
    {Coordinate{5.97407, 45.3419}, Tz::Europe_Paris, CountryId{"FR"}}, // Goncelin
    {Coordinate{6.08567, 43.2364}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2489194
    {Coordinate{7.33385, 48.0859}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2489577
    {Coordinate{2.47333, 48.6139}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2489748
    {Coordinate{4.95639, 50.1153}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beauraing railway station
    {Coordinate{5.82222, 53.0894}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Grou-Jirnsum railway station
    {Coordinate{2.1683, 48.8055}, Tz::Europe_Paris, CountryId{"FR"}}, // Viroflay-Rive-Droite station
    {Coordinate{63.1667, 67.0833}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q2490848
    {Coordinate{5.58731, 50.5475}, Tz::Europe_Brussels, CountryId{"BE"}}, // Méry railway station
    {Coordinate{5.19361, 51.5819}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oisterwijk railway station
    {Coordinate{30.7406, 46.4644}, Tz::Europe_Kiev, CountryId{"UA"}}, // Odessa Railway Station
    {Coordinate{-2.1936, 47.3004}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2491824
    {Coordinate{4.60917, 50.4322}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tamines railway station
    {Coordinate{40.1167, 63.5167}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q24934906
    {Coordinate{4.60514, 50.7162}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wavre railway station
    {Coordinate{41.3047, 56.3689}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q24936273
    {Coordinate{3.09917, 50.6205}, Tz::Europe_Paris, CountryId{"FR"}}, // Lezennes
    {Coordinate{5.25516, 47.0873}, Tz::Europe_Paris, CountryId{"FR"}}, // Q24936906
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24937183
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24937188
    {Coordinate{5.24404, 47.0998}, Tz::Europe_Paris, CountryId{"FR"}}, // Q24937300
    {Coordinate{5.10452, 47.2241}, Tz::Europe_Paris, CountryId{"FR"}}, // Q24937330
    {Coordinate{35.2572, 47.8547}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Zaporizhzhia-Vantazhne
    {Coordinate{-0.509862, 45.9408}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Jean-d'Angély
    {Coordinate{}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24937760
    {Coordinate{12.8405, 37.5852}, Tz::Europe_Rome, CountryId{"IT"}}, // Selinunte railway station
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Brest-South railway station
    {Coordinate{7.648, 44.5188}, Tz::Europe_Rome, CountryId{"IT"}}, // Maddalene railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q24938258
    {Coordinate{4.49861, 50.4886}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hofstade railway station
    {Coordinate{13.7027, 37.4097}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24939188
    {Coordinate{13.7277, 37.4061}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24939189
    {Coordinate{18.3543, 40.1463}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24940099
    {Coordinate{14.8033, 41.158}, Tz::Europe_Rome, CountryId{"IT"}}, // Benevento Acquafredda railway halt
    {Coordinate{5.07833, 47.3708}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ruffey
    {Coordinate{14.8601, 40.8589}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24940466
    {Coordinate{14.8535, 40.8745}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24940469
    {Coordinate{5.11006, 47.3898}, Tz::Europe_Paris, CountryId{"FR"}}, // Q24940485
    {Coordinate{14.4627, 41.0286}, Tz::Europe_Rome, CountryId{"IT"}}, // Santa Maria a Vico railway station
    {Coordinate{16.0583, 37.9249}, Tz::Europe_Rome, CountryId{"IT"}}, // Q24942036
    {Coordinate{-0.582266, 46.2445}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2495776
    {Coordinate{2.18159, 42.8738}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quillan
    {Coordinate{-0.051918, 46.3998}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2497266
    {Coordinate{7.32118, 48.0873}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2497752
    {Coordinate{6.80166, 47.5105}, Tz::Europe_Paris, CountryId{"FR"}}, // Montbéliard railway station
    {Coordinate{2.23133, 48.9504}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2498496
    {Coordinate{2.65444, 48.5272}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Melun
    {Coordinate{1.94758, 47.8192}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2499133
    {Coordinate{21.1347, 55.7208}, Tz::Europe_Vilnius, CountryId{"LT"}}, // Klaipėda railway station
    {Coordinate{3.1467, 50.6229}, Tz::Europe_Paris, CountryId{"FR"}}, // Annappes
    {Coordinate{6.83958, 45.9074}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2499816
    {Coordinate{6.35932, 47.3541}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2500921
    {Coordinate{5.76494, 45.5416}, Tz::Europe_Paris, CountryId{"FR"}}, // Lépin-le-Lac - La Bauche
    {Coordinate{-0.636382, 46.2191}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2501811
    {Coordinate{52.4397, 56.5006}, Tz::Europe_Samara, CountryId{"RU"}}, // Q2502164
    {Coordinate{1.70333, 48.9898}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mantes-la-Jolie
    {Coordinate{2.63925, 48.8752}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vaires-Torcy
    {Coordinate{1.15962, 49.317}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2504721
    {Coordinate{8.544, 47.4186}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zurich Seebach railway station
    {Coordinate{0.941325, 44.4865}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monsempron-Libos
    {Coordinate{4.63604, 50.6205}, Tz::Europe_Brussels, CountryId{"BE"}}, // Blanmont railway station
    {Coordinate{6.18844, 50.862}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Mariadorf station
    {Coordinate{3.83518, 50.7028}, Tz::Europe_Brussels, CountryId{"BE"}}, // Houraing railway station
    {Coordinate{2.48889, 48.8542}, Tz::Europe_Paris, CountryId{"FR"}}, // Val de Fontenay
    {Coordinate{3.60028, 50.8497}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oudenaarde railway station
    {Coordinate{1.55862, 47.1631}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Valençay
    {Coordinate{5.71004, 50.772}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eijsden railway station
    {Coordinate{8.56603, 49.6589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25088577
    {Coordinate{8.64559, 49.9137}, Tz::Europe_Berlin, CountryId{"DE"}}, // Darmstadt-Arheilgen station
    {Coordinate{11.0736, 51.8994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Halberstadt station
    {Coordinate{11.77, 51.2063}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25089303
    {Coordinate{8.6058, 52.3063}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lübbecke station
    {Coordinate{9.44056, 48.6447}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Kirchheim unter Teck
    {Coordinate{11.2756, 50.6825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25089975
    {Coordinate{8.82812, 48.5228}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25090000
    {Coordinate{4.29417, 50.7906}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ruisbroek railway station
    {Coordinate{0.317047, 46.4842}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2510926
    {Coordinate{4.46528, 51.1539}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hove railway station
    {Coordinate{2.80481, 45.5795}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Mont-Dore
    {Coordinate{4.82833, 51.1806}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herentals railway station
    {Coordinate{3.45611, 50.0675}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Maurois
    {Coordinate{1.28569, 45.7562}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Solignac-Le Vigen
    {Coordinate{-0.391464, 45.1391}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Mariens - Saint-Yzan
    {Coordinate{1.61487, 50.576}, Tz::Europe_Paris, CountryId{"FR"}}, // Dannes - Camiers
    {Coordinate{3.87222, 50.7703}, Tz::Europe_Brussels, CountryId{"BE"}}, // Geraardsbergen railway station
    {Coordinate{6.01417, 51.5264}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Venray railway station
    {Coordinate{16.358, 48.2356}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Spittelau railway station
    {Coordinate{16.42, 48.1703}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Simmering railway station
    {Coordinate{3.54, 50.0914}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Cateau
    {Coordinate{-0.547298, 44.7683}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villenave-d'Ornon
    {Coordinate{4.77806, 51.8294}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sliedrecht railway station
    {Coordinate{3.22516, 50.8262}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bissegem railway station
    {Coordinate{2.38444, 49.6264}, Tz::Europe_Paris, CountryId{"FR"}}, // Breteuil-Embranchement station
    {Coordinate{2.27222, 48.9138}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bois-Colombes
    {Coordinate{5.8602, 46.39}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Claude railway station
    {Coordinate{7.36544, 51.4895}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Kley station
    {Coordinate{2.50972, 48.8069}, Tz::Europe_Paris, CountryId{"FR"}}, // Champigny
    {Coordinate{-1.24127, 43.6713}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Geours-de-Maremne
    {Coordinate{6.14, 52.3897}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wijhe railway station
    {Coordinate{2.31028, 46.8567}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2521024
    {Coordinate{4.56936, 50.6737}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ottignies railway station
    {Coordinate{17.646, 59.8587}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Uppsala Central Station
    {Coordinate{5.05751, 45.8478}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2522225
    {Coordinate{6.37676, 48.0531}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Xertigny
    {Coordinate{6.01972, 50.8964}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Landgraaf railway station
    {Coordinate{3.68219, 49.3109}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2523711
    {Coordinate{3.69833, 50.8742}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Denijs-Boekel railway station
    {Coordinate{7.08893, 51.4441}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Steele Ost station
    {Coordinate{4.02361, 50.9067}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haaltert railway station
    {Coordinate{5.85167, 51.9547}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Arnhem Zuid railway station
    {Coordinate{1.98833, 49.5036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Milly-sur-Thérain
    {Coordinate{1.25148, 45.8384}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2527927
    {Coordinate{2.12278, 48.5494}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2530265
    {Coordinate{-0.454722, 46.3194}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Niort
    {Coordinate{3.24593, 50.7137}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herseaux railway station
    {Coordinate{5.195, 51.8992}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Beesd railway station
    {Coordinate{2.15944, 48.4369}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Étampes
    {Coordinate{24.548, 59.3249}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2531292
    {Coordinate{0.045103, 44.5629}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamothe-Landerron
    {Coordinate{4.36056, 51.0908}, Tz::Europe_Brussels, CountryId{"BE"}}, // Boom railway station
    {Coordinate{2.61152, 46.3356}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2531756
    {Coordinate{2.38694, 48.3706}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2531979
    {Coordinate{2.07361, 48.9906}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Conflans-Fin-d'Oise
    {Coordinate{6.0505, 48.9003}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2532824
    {Coordinate{6.63634, 45.9357}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2533028
    {Coordinate{6.04611, 50.8897}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eygelshoven railway station
    {Coordinate{9.91517, 51.4212}, Tz::Europe_Berlin, CountryId{"DE"}}, // Friedland (Han) station
    {Coordinate{2.2982, 48.8968}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clichy-Levallois
    {Coordinate{-9.10304, 38.7467}, Tz::Europe_Lisbon, CountryId{"PT"}}, // Braço de Prata
    {Coordinate{1.82472, 42.5386}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Porté-Puymorens
    {Coordinate{9.86281, 51.3517}, Tz::Europe_Berlin, CountryId{"DE"}}, // Witzenhausen Nord station
    {Coordinate{9.80429, 51.38}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gertenbach station
    {Coordinate{1.10961, 49.677}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2535233
    {Coordinate{6.2125, 51.9567}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wehl railway station
    {Coordinate{4.84852, 47.023}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2535260
    {Coordinate{6.77774, 51.365}, Tz::Europe_Berlin, CountryId{"DE"}}, // Duisburg-Großenbaum station
    {Coordinate{2.53139, 49.7142}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hargicourt-Pierrepont
    {Coordinate{9.762, 51.3921}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hedemünden station
    {Coordinate{9.65815, 51.4124}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hann. Münden station
    {Coordinate{5.28071, 50.0907}, Tz::Europe_Brussels, CountryId{"BE"}}, // Grupont railway station
    {Coordinate{41.6775, 41.6586}, Tz::Asia_Tbilisi, CountryId{"GE"}}, // Batumi railway station
    {Coordinate{8.6778, 48.8656}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q25389195
    {Coordinate{5.3904, 43.3391}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2538961
    {Coordinate{40.0167, 61.6667}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25393617
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25393696
    {Coordinate{89.0342, 53.4783}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q25393791
    {Coordinate{31.2167, 69.5833}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25393792
    {Coordinate{38.0081, 63.75}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25393812
    {Coordinate{89.9606, 54.4883}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q25393935
    {Coordinate{91.1317, 53.5953}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q25393939
    {Coordinate{100.548, 54.5919}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Tulun station
    {Coordinate{90.4189, 53.1317}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Askiz
    {Coordinate{89.5183, 53.4589}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q25393942
    {Coordinate{93.3767, 54.2933}, Tz::Asia_Krasnoyarsk, CountryId{"RU"}}, // Q25393944
    {Coordinate{112.823, 56.2597}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25393948
    {Coordinate{111.736, 56.1492}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25393952
    {Coordinate{110.102, 55.9303}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25393954
    {Coordinate{109.603, 55.8117}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25393956
    {Coordinate{110.907, 56.0119}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25393962
    {Coordinate{111.527, 56.1636}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25393975
    {Coordinate{113.672, 56.1683}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25394017
    {Coordinate{104.245, 56.7114}, Tz::Asia_Irkutsk, CountryId{"RU"}}, // Q25394040
    {Coordinate{24.7917, 56.5758}, Tz::Europe_Riga, CountryId{"LV"}}, // Lāčplēsis train station
    {Coordinate{61.685, 57.8564}, Tz::Asia_Yekaterinburg, CountryId{"RU"}}, // Q25394264
    {Coordinate{40.5836, 64.1531}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25394338
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394486
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394514
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394517
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394621
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394642
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Bereshino
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394689
    {Coordinate{}, Timezone{}, CountryId{"UZ"}}, // Q25394710
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25394799
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25395025
    {Coordinate{37.0477, 55.9943}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25395040
    {Coordinate{34.8452, 55.5359}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25395062
    {Coordinate{36.4329, 53.2429}, Tz::Europe_Moscow, CountryId{}}, // Q25395512
    {Coordinate{27.1514, 56.537}, Tz::Europe_Riga, CountryId{"LV"}}, // Q25395632
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Smalyavichy
    {Coordinate{33.3049, 54.5565}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25395760
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25395780
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25395958
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25396117
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25396143
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25396301
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25396411
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25396412
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25396586
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shastsyorawka
    {Coordinate{25.6168, 56.526}, Tz::Europe_Riga, CountryId{"LV"}}, // Q25396738
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397021
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397062
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397063
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397068
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397143
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397172
    {Coordinate{76.5792, 54.7103}, Tz::Asia_Novosibirsk, CountryId{"RU"}}, // Q25397290
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397298
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25397325
    {Coordinate{7.5727, 44.461}, Tz::Europe_Rome, CountryId{"IT"}}, // San Benigno di Cuneo railway station
    {Coordinate{9.43056, 46.8286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ems Werk
    {Coordinate{-1.60201, 48.1126}, Tz::Europe_Paris, CountryId{"FR"}}, // Cesson-Sévigné
    {Coordinate{2.16416, 45.5305}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Meymac
    {Coordinate{15.0784, 50.6293}, Tz::Europe_Prague, CountryId{"CZ"}}, // Q25412023
    {Coordinate{14.6382, 51.5056}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weißwasser (Oberlausitz) railway station
    {Coordinate{7.12213, 51.3548}, Tz::Europe_Berlin, CountryId{"DE"}}, // Velbert-Langenberg station
    {Coordinate{5.12528, 52.11}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Overvecht railway station
    {Coordinate{6.12413, 43.1088}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hyères
    {Coordinate{7.13445, 49.0782}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2542772
    {Coordinate{2.13417, 48.89}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Vésinet – Centre
    {Coordinate{37.8055, 48.9762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25431972
    {Coordinate{37.7011, 49.0333}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432066
    {Coordinate{37.6494, 48.8689}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432189
    {Coordinate{38.005, 48.3782}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432234
    {Coordinate{37.9731, 48.3958}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432241
    {Coordinate{37.9773, 48.5177}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432325
    {Coordinate{37.9832, 48.6209}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432345
    {Coordinate{38.1004, 48.8534}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432363
    {Coordinate{38.0842, 48.7889}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432364
    {Coordinate{38.0381, 48.9231}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432406
    {Coordinate{37.8639, 48.2236}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432482
    {Coordinate{37.8694, 48.2524}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25432596
    {Coordinate{32.757, 48.2092}, Tz::Europe_Kiev, CountryId{"UA"}}, // Marzhanivka
    {Coordinate{32.3837, 48.5906}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25434278
    {Coordinate{39.2419, 48.5697}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25434705
    {Coordinate{38.5428, 48.3825}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435245
    {Coordinate{37.5589, 48.5936}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435435
    {Coordinate{33.556, 48.3782}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tishchenkove
    {Coordinate{38.0775, 48.0858}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435638
    {Coordinate{37.7867, 48.0914}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435677
    {Coordinate{37.8587, 48.1228}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435681
    {Coordinate{35.4867, 48.2423}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435717
    {Coordinate{24.614, 48.6894}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tarnovytsia
    {Coordinate{24.5952, 49.0001}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435779
    {Coordinate{37.393, 47.9964}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435798
    {Coordinate{37.2439, 48.1494}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435799
    {Coordinate{37.3069, 48.0833}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435800
    {Coordinate{25.723, 49.0231}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bila-Chortkivska
    {Coordinate{25.6496, 49.3606}, Tz::Europe_Kiev, CountryId{"UA"}}, // Mykulyntsi-Strusiv
    {Coordinate{25.9452, 48.8897}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435832
    {Coordinate{25.3544, 49.4714}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435846
    {Coordinate{37.4061, 48.8303}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435910
    {Coordinate{37.27, 48.8597}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435914
    {Coordinate{36.6305, 48.8243}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25435998
    {Coordinate{38.4289, 48.3528}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436013
    {Coordinate{38.5081, 48.2061}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436020
    {Coordinate{38.5672, 48.1319}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436021
    {Coordinate{38.4972, 48.0403}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436026
    {Coordinate{24.0921, 49.8825}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436034
    {Coordinate{22.7584, 49.5046}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436046
    {Coordinate{35.3137, 47.0622}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Lankoskladalne
    {Coordinate{38.2586, 48.0256}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436306
    {Coordinate{38.2239, 47.9564}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436312
    {Coordinate{34.5943, 46.1074}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dzymbuluk
    {Coordinate{34.8651, 50.7256}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436369
    {Coordinate{34.8539, 50.8952}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sumy-Tovarna
    {Coordinate{34.3043, 51.093}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436507
    {Coordinate{34.3747, 50.9539}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436567
    {Coordinate{33.4322, 49.1065}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25436842
    {Coordinate{36.3291, 49.0312}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437090
    {Coordinate{35.8522, 49.6736}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437184
    {Coordinate{39.2873, 48.4824}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437490
    {Coordinate{39.4744, 48.6544}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437501
    {Coordinate{39.4472, 48.6767}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437507
    {Coordinate{39.3738, 48.2546}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437583
    {Coordinate{39.3528, 48.7736}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437584
    {Coordinate{39.2778, 48.7719}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437586
    {Coordinate{39.2081, 48.7503}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437587
    {Coordinate{39.0689, 48.8436}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25437614
    {Coordinate{35.8725, 47.5361}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25437793
    {Coordinate{36.3483, 48.3794}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25439131
    {Coordinate{35.6242, 48.3064}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25439605
    {Coordinate{29.4322, 48.2822}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25440721
    {Coordinate{1.90667, 47.9267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Aubrais-Orléans
    {Coordinate{2.32222, 48.9056}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Ouen
    {Coordinate{25.9275, 49.0989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kopychyntsi
    {Coordinate{37.8942, 48.124}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25443845
    {Coordinate{34.9312, 47.0286}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25443967
    {Coordinate{35.1903, 47.0425}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25443976
    {Coordinate{35.21, 47.7472}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Balabine
    {Coordinate{32.7, 46.6885}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kindijka
    {Coordinate{33.0707, 46.4703}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sad
    {Coordinate{33.2468, 46.3747}, Tz::Europe_Kiev, CountryId{"UA"}}, // Radhosp Pravda
    {Coordinate{33.3552, 46.3145}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rachivka
    {Coordinate{33.4043, 46.2879}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kolos
    {Coordinate{32.3438, 46.795}, Tz::Europe_Kiev, CountryId{"UA"}}, // Petrivske
    {Coordinate{32.144, 46.9595}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444197
    {Coordinate{32.0306, 46.9308}, Tz::Europe_Kiev, CountryId{"UA"}}, // 230 km
    {Coordinate{32.3177, 46.9998}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444200
    {Coordinate{32.0298, 46.927}, Tz::Europe_Kiev, CountryId{"UA"}}, // Nove Sadivnytstvo
    {Coordinate{31.9848, 46.9529}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sudnobudivnykiv
    {Coordinate{32.5115, 47.5067}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tekhnikum
    {Coordinate{32.5063, 47.4782}, Tz::Europe_Kiev, CountryId{"UA"}}, // Barvinok
    {Coordinate{32.5711, 47.6345}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zahalna Koryst
    {Coordinate{32.4953, 47.4169}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bashtanka
    {Coordinate{32.4831, 47.3507}, Tz::Europe_Kiev, CountryId{"UA"}}, // Rozplidnyk
    {Coordinate{32.3513, 47.1732}, Tz::Europe_Kiev, CountryId{"UA"}}, // Maryanivka
    {Coordinate{32.3633, 47.1878}, Tz::Europe_Kiev, CountryId{"UA"}}, // Horodnya
    {Coordinate{32.1172, 46.9755}, Tz::Europe_Kiev, CountryId{"UA"}}, // Doslidna
    {Coordinate{32.7659, 47.9345}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dmytrivka
    {Coordinate{32.7556, 48.0124}, Tz::Europe_Kiev, CountryId{"UA"}}, // Danylivka
    {Coordinate{32.2484, 47.0524}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dachna
    {Coordinate{31.3013, 47.2932}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444266
    {Coordinate{31.5337, 47.2853}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444274
    {Coordinate{32.0246, 47.0128}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444285
    {Coordinate{32.8489, 48.4417}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chabanivka
    {Coordinate{32.4292, 48.7229}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444365
    {Coordinate{39.1839, 48.5731}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444435
    {Coordinate{39.0847, 48.5624}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444439
    {Coordinate{38.9458, 48.5521}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444448
    {Coordinate{38.8531, 48.515}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444456
    {Coordinate{38.3333, 48.6177}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444833
    {Coordinate{34.7331, 47.7706}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444859
    {Coordinate{36.8148, 47.3426}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25444860
    {Coordinate{37.7689, 48.1071}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444866
    {Coordinate{35.5069, 47.9711}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25444869
    {Coordinate{35.5028, 48.0594}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25444870
    {Coordinate{38.085, 47.9488}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444914
    {Coordinate{24.1934, 49.6999}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444923
    {Coordinate{38.0347, 47.9752}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444924
    {Coordinate{24.1493, 49.7418}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444927
    {Coordinate{37.86, 48.4328}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444938
    {Coordinate{24.2266, 49.628}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444945
    {Coordinate{24.2145, 49.5605}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444947
    {Coordinate{24.2193, 49.4964}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444955
    {Coordinate{24.1578, 49.3778}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444956
    {Coordinate{24.1048, 49.3281}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hnizdychiv
    {Coordinate{23.9637, 49.2925}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444959
    {Coordinate{37.1492, 48.8828}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444967
    {Coordinate{37.1492, 48.8828}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444975
    {Coordinate{36.9253, 48.9264}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25444976
    {Coordinate{23.8284, 50.1241}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445001
    {Coordinate{23.6631, 49.3011}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445009
    {Coordinate{23.5464, 49.2956}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stebnyk
    {Coordinate{24.3508, 50.1989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445023
    {Coordinate{36.4484, 48.8602}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445036
    {Coordinate{37.5492, 48.8575}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445037
    {Coordinate{36.366, 48.8762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Post 4 km
    {Coordinate{24.2236, 50.3533}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445049
    {Coordinate{38.5231, 48.2658}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445053
    {Coordinate{35.2054, 47.7082}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445069
    {Coordinate{35.2219, 47.6902}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445070
    {Coordinate{35.2262, 47.674}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445074
    {Coordinate{35.2814, 47.6068}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445075
    {Coordinate{35.2883, 47.5967}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445078
    {Coordinate{35.3012, 47.5808}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445079
    {Coordinate{35.3315, 47.5489}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445083
    {Coordinate{35.279, 47.4797}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445089
    {Coordinate{35.3344, 47.5242}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445093
    {Coordinate{38.3906, 48.0403}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445094
    {Coordinate{25.7661, 50.2417}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445118
    {Coordinate{26.1872, 51.4317}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445128
    {Coordinate{26.018, 51.6404}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445129
    {Coordinate{35.3271, 47.3829}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445149
    {Coordinate{35.3294, 47.3352}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445150
    {Coordinate{35.3275, 47.3011}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445151
    {Coordinate{35.3171, 47.139}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445156
    {Coordinate{35.3223, 47.216}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445157
    {Coordinate{34.4255, 45.7946}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q25445167
    {Coordinate{35.3494, 46.8797}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Depo
    {Coordinate{35.9514, 50.1597}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445222
    {Coordinate{35.0641, 50.4021}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445284
    {Coordinate{35.1349, 50.3434}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445285
    {Coordinate{35.4909, 48.1661}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445286
    {Coordinate{35.4885, 48.2035}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445288
    {Coordinate{34.9197, 50.5467}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445297
    {Coordinate{34.8773, 50.6509}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445306
    {Coordinate{34.6771, 50.5725}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445308
    {Coordinate{34.4909, 50.5691}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445349
    {Coordinate{34.8867, 50.8621}, Tz::Europe_Kiev, CountryId{"UA"}}, // Basy
    {Coordinate{34.6706, 50.9425}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445377
    {Coordinate{34.5728, 50.9739}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445384
    {Coordinate{34.4642, 51.0017}, Tz::Europe_Kiev, CountryId{"UA"}}, // Ambary
    {Coordinate{34.3748, 51.0212}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyry
    {Coordinate{34.2714, 51.1419}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445428
    {Coordinate{35.025, 50.8252}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445447
    {Coordinate{35.1374, 50.82}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445459
    {Coordinate{35.2579, 50.7831}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445467
    {Coordinate{33.5667, 49.016}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445496
    {Coordinate{33.4898, 50.7013}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445542
    {Coordinate{36.0781, 49.9762}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445565
    {Coordinate{36.0024, 49.9953}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445568
    {Coordinate{35.9533, 50.0497}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445578
    {Coordinate{36.0531, 49.7184}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445591
    {Coordinate{36.1404, 49.651}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445593
    {Coordinate{36.1696, 49.5911}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bezpalivka
    {Coordinate{36.1398, 49.483}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445612
    {Coordinate{36.2081, 49.3821}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445626
    {Coordinate{36.3067, 49.2639}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445628
    {Coordinate{36.3214, 49.1399}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445631
    {Coordinate{36.2811, 48.9404}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445647
    {Coordinate{36.0876, 49.7705}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445657
    {Coordinate{35.8592, 50.4175}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445671
    {Coordinate{36.4311, 49.9022}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445683
    {Coordinate{28.9136, 48.9647}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sazhky
    {Coordinate{37.8153, 48.5925}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445796
    {Coordinate{37.9707, 48.6371}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445797
    {Coordinate{37.9925, 48.6339}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445799
    {Coordinate{36.2231, 48.7692}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445818
    {Coordinate{35.9856, 48.7047}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445824
    {Coordinate{35.8867, 48.6275}, Tz::Europe_Kiev, CountryId{"UA"}}, // Aromatna
    {Coordinate{39.1498, 48.7735}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445857
    {Coordinate{39.1326, 48.7884}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445860
    {Coordinate{39.06, 48.8623}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445861
    {Coordinate{39.064, 48.8926}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445862
    {Coordinate{35.6806, 48.4247}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445871
    {Coordinate{35.3074, 46.8266}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 1226 km
    {Coordinate{35.2042, 46.7292}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 1240 km
    {Coordinate{35.3069, 46.8261}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 1237 km
    {Coordinate{34.9908, 46.5364}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 1267 km
    {Coordinate{34.8147, 47.4458}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445902
    {Coordinate{35.7967, 47.2266}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445904
    {Coordinate{35.4031, 48.6167}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445934
    {Coordinate{35.5661, 48.5928}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25445948
    {Coordinate{35.4256, 47.8156}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q25445964
    {Coordinate{35.1842, 47.8669}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 21 km
    {Coordinate{35.1697, 47.8608}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // 23 km
    {Coordinate{36.0267, 48.4444}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446105
    {Coordinate{24.5768, 48.3453}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tatariv
    {Coordinate{36.4864, 48.4311}, Tz::Europe_Kiev, CountryId{"UA"}}, // Petropavlivka
    {Coordinate{36.7056, 48.3875}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446176
    {Coordinate{35.175, 49.1039}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446186
    {Coordinate{35.7103, 48.3264}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446197
    {Coordinate{35.8044, 48.2033}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446200
    {Coordinate{36.0572, 48.2072}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446226
    {Coordinate{35.1217, 48.5403}, Tz::Europe_Kiev, CountryId{"UA"}}, // Samarivka
    {Coordinate{28.7822, 55.4913}, Tz::Europe_Minsk, CountryId{"BY"}}, // Polatsk
    {Coordinate{37.1032, 50.2039}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446556
    {Coordinate{37.345, 50.1613}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q25446590
    {Coordinate{}, Timezone{}, CountryId{"MN"}}, // Choir railway station
    {Coordinate{34.2582, 51.26}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25447076
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25447549
    {Coordinate{3.26762, 48.1978}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545246
    {Coordinate{1.55878, 48.5108}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545316
    {Coordinate{5.7147, 45.1908}, Tz::Europe_Paris, CountryId{"FR"}}, // Grenoble railway station
    {Coordinate{4.61833, 45.8332}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de l'Arbresle
    {Coordinate{1.48163, 45.8321}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545374
    {Coordinate{4.39254, 45.4172}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545435
    {Coordinate{7.67597, 51.5389}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unna West station
    {Coordinate{6.71869, 48.2049}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545635
    {Coordinate{3.08481, 50.3981}, Tz::Europe_Paris, CountryId{"FR"}}, // Pont-de-la-Deûle
    {Coordinate{2.8631, 49.467}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545798
    {Coordinate{3.2905, 50.4688}, Tz::Europe_Paris, CountryId{"FR"}}, // Landas
    {Coordinate{5.97914, 49.0136}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2545995
    {Coordinate{7.16697, 43.6605}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2546150
    {Coordinate{11.555, 48.1408}, Tz::Europe_Berlin, CountryId{"DE"}}, // Munich Central Station
    {Coordinate{1.87164, 48.8937}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2546484
    {Coordinate{3.43278, 49.9502}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2546900
    {Coordinate{9.56386, 51.3773}, Tz::Europe_Berlin, CountryId{"DE"}}, // Staufenberg-Speele station
    {Coordinate{5.89241, 43.9247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2548471
    {Coordinate{7.6568, 50.7737}, Tz::Europe_Berlin, CountryId{"DE"}}, // Au station
    {Coordinate{7.4151, 48.7636}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2548766
    {Coordinate{2.15722, 48.9375}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sartrouville
    {Coordinate{4.23996, 50.7334}, Tz::Europe_Brussels, CountryId{"BE"}}, // Halle railway station
    {Coordinate{4.86906, 50.3488}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lustin railway station
    {Coordinate{7.53743, 51.5187}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund Knappschaftskrankenhaus station
    {Coordinate{-2.36464, 47.2837}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2552507
    {Coordinate{2.46299, 50.614}, Tz::Europe_Paris, CountryId{"FR"}}, // Isbergues
    {Coordinate{5.90737, 49.1939}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2552882
    {Coordinate{4.805, 43.9417}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avignon-Centre
    {Coordinate{5.24139, 52.14}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Dolder railway station
    {Coordinate{6.68639, 53.3258}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Stedum railway station
    {Coordinate{50.1813, 56.1108}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q25556791
    {Coordinate{51.0333, 56.2294}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q25556800
    {Coordinate{-1.45706, 43.5687}, Tz::Europe_Paris, CountryId{"FR"}}, // Ondres
    {Coordinate{-1.68596, 48.3506}, Tz::Europe_Paris, CountryId{"FR"}}, // Dingé
    {Coordinate{2.22306, 48.8956}, Tz::Europe_Paris, CountryId{"FR"}}, // Nanterre-Préfecture
    {Coordinate{5.57834, 50.509}, Tz::Europe_Brussels, CountryId{"BE"}}, // Poulseur railway station
    {Coordinate{1.61389, 50.7644}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Wimille-Wimereux
    {Coordinate{5.50372, 43.6848}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2557517
    {Coordinate{2.33932, 50.3789}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2557790
    {Coordinate{0.253347, 47.1641}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2558544
    {Coordinate{0.485061, 49.5916}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bolbec - Nointot
    {Coordinate{2.34417, 49.2942}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Balagny-Saint-Épin
    {Coordinate{6.79278, 51.2203}, Tz::Europe_Berlin, CountryId{"DE"}}, // Düsseldorf Central Station
    {Coordinate{3.96654, 50.2726}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Maubeuge
    {Coordinate{2.3125, 48.7478}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2560132
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q25603901
    {Coordinate{6.76962, 47.5733}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2560558
    {Coordinate{5.86722, 50.4892}, Tz::Europe_Brussels, CountryId{"BE"}}, // Spa-Géronstère railway station
    {Coordinate{2.3141, 45.557}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ussel
    {Coordinate{7.33177, 43.7068}, Tz::Europe_Paris, CountryId{"FR"}}, // Beaulieu-sur-Mer railway station
    {Coordinate{2.43333, 48.8472}, Tz::Europe_Paris, CountryId{"FR"}}, // Vincennes
    {Coordinate{3.69189, 49.7026}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2562340
    {Coordinate{-0.736223, 43.9783}, Tz::Europe_Paris, CountryId{"FR"}}, // Ygos
    {Coordinate{4.83056, 44.7797}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2563655
    {Coordinate{4.8134, 45.6456}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2563981
    {Coordinate{-1.17786, 47.3695}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2564893
    {Coordinate{3.36979, 49.6578}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2565580
    {Coordinate{7.82341, 48.7819}, Tz::Europe_Paris, CountryId{"FR"}}, // Marienthal
    {Coordinate{4.95417, 52.5033}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Purmerend railway station
    {Coordinate{4.29028, 50.4928}, Tz::Europe_Brussels, CountryId{"BE"}}, // Godarville railway station
    {Coordinate{5.18389, 52.6906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoogkarspel railway station
    {Coordinate{5.67284, 50.4727}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aywaille railway station
    {Coordinate{7.21472, 46.0792}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q2569112
    {Coordinate{5.4671, 43.2881}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2569951
    {Coordinate{5.93444, 53.2189}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hurdegaryp railway station
    {Coordinate{5.63111, 51.4681}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond 't Hout railway station
    {Coordinate{3.33922, 46.5613}, Tz::Europe_Paris, CountryId{"FR"}}, // Moulins-sur-Allier railway station
    {Coordinate{1.47566, 45.258}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Allassac
    {Coordinate{-0.612264, 43.1948}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Oloron-Sainte-Marie
    {Coordinate{6.15172, 47.6175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vesoul
    {Coordinate{2.28056, 49.1325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nointel - Mours
    {Coordinate{1.74022, 47.367}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2573173
    {Coordinate{5.19761, 43.3344}, Tz::Europe_Paris, CountryId{"FR"}}, // La Redonne-Ensuès train station
    {Coordinate{7.0577, 50.8952}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Steinstraße station
    {Coordinate{4.72107, 45.9846}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villefranche-sur-Saône
    {Coordinate{2.53333, 48.6806}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2576523
    {Coordinate{-0.963719, 45.9474}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rochefort
    {Coordinate{2.1626, 47.1758}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2577332
    {Coordinate{3.51304, 47.9611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2577756
    {Coordinate{4.36167, 51.91}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vlaardingen Oost railway station
    {Coordinate{3.06139, 45.7675}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2578159
    {Coordinate{6.58146, 47.4473}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2578262
    {Coordinate{7.34275, 53.1634}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weener railway station
    {Coordinate{3.43064, 46.1264}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2578951
    {Coordinate{-3.9989, 48.4851}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2579335
    {Coordinate{6.71, 45.0767}, Tz::Europe_Rome, CountryId{"IT"}}, // Bardonecchia railway station
    {Coordinate{4.18528, 51.1853}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nieuwkerken-Waas railway station
    {Coordinate{-0.885655, 48.0968}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2580610
    {Coordinate{-3.16685, 48.5609}, Tz::Europe_Paris, CountryId{"FR"}}, // Halte de Gourland
    {Coordinate{2.49, 49.138}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Orry-la-Ville-Coye
    {Coordinate{10.1002, 51.6859}, Tz::Europe_Berlin, CountryId{"DE"}}, // Katlenburg station
    {Coordinate{10.1755, 51.6594}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wulften station
    {Coordinate{10.2366, 51.6461}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hattorf station
    {Coordinate{1.10946, 49.3771}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Étienne-du-Rouvray
    {Coordinate{5.66222, 51.4758}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond railway station
    {Coordinate{25.7536, 62.2408}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Jyväskylä railway station
    {Coordinate{2.095, 48.8981}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Germain-en-Laye station
    {Coordinate{4.1875, 45.8179}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2583133
    {Coordinate{18.9418, 47.1756}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ráckeve HÉV station
    {Coordinate{19.0936, 47.4382}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pesterzsébet felső HÉV station
    {Coordinate{19.0042, 47.3337}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q25834903
    {Coordinate{18.9742, 47.3133}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q25835296
    {Coordinate{18.9562, 47.27}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q25835884
    {Coordinate{18.9461, 47.2281}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q25835890
    {Coordinate{1.60277, 48.7959}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2583814
    {Coordinate{19.2249, 47.5451}, Tz::Europe_Budapest, CountryId{"HU"}}, // Csömör HÉV station
    {Coordinate{19.1678, 47.507}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagyicce HÉV station
    {Coordinate{19.2712, 47.5533}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kerepes HÉV station
    {Coordinate{19.3566, 47.5986}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gödöllő, Palotakert HÉV station
    {Coordinate{19.1256, 50.2786}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Sosnowiec Main Station
    {Coordinate{10.4149, 51.6188}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Lauterberg im Harz Barbis station
    {Coordinate{35.3844, 45.0303}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Feodosia
    {Coordinate{10.574, 51.5825}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Sachsa station
    {Coordinate{10.6089, 51.5848}, Tz::Europe_Berlin, CountryId{"DE"}}, // Walkenried station
    {Coordinate{6.59881, 48.0164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2586908
    {Coordinate{-1.3969, 43.3655}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cambo-les-Bains
    {Coordinate{6.04321, 49.2468}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moyeuvre-grande
    {Coordinate{2.56954, 48.6284}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2588017
    {Coordinate{1.4065, 45.9529}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ambazac
    {Coordinate{4.0875, 50.2961}, Tz::Europe_Paris, CountryId{"FR"}}, // Jeumont railway station
    {Coordinate{3.2574, 51.1543}, Tz::Europe_Brussels, CountryId{"BE"}}, // Oostkamp railway station
    {Coordinate{6.58306, 52.2303}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Goor railway station
    {Coordinate{1.03506, 48.9885}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Bonneville-sur-Iton
    {Coordinate{-2.00314, 48.496}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2591014
    {Coordinate{3.00566, 43.1906}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Narbonne
    {Coordinate{10.3328, 51.6541}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzberg Schloß station
    {Coordinate{2.63162, 44.9759}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2592189
    {Coordinate{2.92629, 50.5665}, Tz::Europe_Paris, CountryId{"FR"}}, // La Fontaine
    {Coordinate{10.2731, 51.717}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osterode am Harz Leege station
    {Coordinate{10.2455, 51.7261}, Tz::Europe_Berlin, CountryId{"DE"}}, // Osterode am Harz Mitte station
    {Coordinate{10.2031, 51.7872}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gittede/Bad Grund (Harz)
    {Coordinate{7.4182, 47.7378}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2592955
    {Coordinate{10.0202, 51.8674}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Gandersheim station
    {Coordinate{130.847, 52.4561}, Tz::Asia_Yakutsk, CountryId{"RU"}}, // Q25930308
    {Coordinate{5.54861, 52.0197}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Veenendaal Centrum railway station
    {Coordinate{21.1578, 52.2569}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Rembertów railway station
    {Coordinate{1.52352, 48.4826}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2594740
    {Coordinate{4.64667, 52.0769}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boskoop railway station
    {Coordinate{2.24639, 48.7175}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Palaiseau
    {Coordinate{5.51948, 50.3769}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bomal railway station
    {Coordinate{4.33861, 51.1364}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hemiksem railway station
    {Coordinate{6.25833, 51.9592}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Doetinchem De Huet railway station
    {Coordinate{6.34314, 43.3903}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2597445
    {Coordinate{7.30474, 47.6989}, Tz::Europe_Paris, CountryId{"FR"}}, // Flaxlanden
    {Coordinate{3.16811, 50.7166}, Tz::Europe_Paris, CountryId{"FR"}}, // Tourcoing
    {Coordinate{3.891, 49.2782}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Muizon
    {Coordinate{0.250308, 46.3493}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2598406
    {Coordinate{4.28818, 50.3425}, Tz::Europe_Brussels, CountryId{"BE"}}, // Thuin railway station
    {Coordinate{3.19652, 45.2537}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2599851
    {Coordinate{5.63028, 51.3039}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Maarheeze railway station
    {Coordinate{7.13175, 49.0006}, Tz::Europe_Paris, CountryId{"FR"}}, // Oermingen
    {Coordinate{23.8521, 56.9814}, Tz::Europe_Riga, CountryId{"LV"}}, // Bulduri Station
    {Coordinate{10.2037, 56.1499}, Tz::Europe_Copenhagen, CountryId{"DK"}}, // Aarhus Central Station
    {Coordinate{6.25167, 51.5811}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kevelaer station
    {Coordinate{4.675, 50.9036}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herent railway station
    {Coordinate{-3.46033, 48.7273}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lannion
    {Coordinate{2.47667, 49.0322}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2602083
    {Coordinate{2.5825, 48.8742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chelles-Gournay
    {Coordinate{-1.76522, 48.4763}, Tz::Europe_Paris, CountryId{"FR"}}, // Bonnemain
    {Coordinate{2.0032, 49.0807}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montgeroult - Courcelles
    {Coordinate{4.68639, 50.9311}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hambos railway station
    {Coordinate{5.57276, 50.5305}, Tz::Europe_Brussels, CountryId{"BE"}}, // Esneux railway station
    {Coordinate{2.63146, 50.7134}, Tz::Europe_Paris, CountryId{"FR"}}, // Strazeele
    {Coordinate{10.4784, 51.9049}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oker station
    {Coordinate{2.37491, 43.4978}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2606934
    {Coordinate{4.40666, 50.3338}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beignée railway station
    {Coordinate{2.57944, 48.8231}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Yvris-Noisy-le-Grand
    {Coordinate{12.1265, 42.7239}, Tz::Europe_Rome, CountryId{"IT"}}, // Q2608652
    {Coordinate{7.31694, 43.76}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2608753
    {Coordinate{9.07278, 45.8092}, Tz::Europe_Rome, CountryId{"IT"}}, // Como San Giovanni railway station
    {Coordinate{7.29433, 47.6944}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Zillisheim
    {Coordinate{1.53944, 49.6314}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Serqueux
    {Coordinate{0.596512, 42.7973}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Luchon
    {Coordinate{1.14972, 49.0186}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Évreux-Normandie
    {Coordinate{2.69331, 42.689}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2609571
    {Coordinate{-0.011587, 48.1274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Conlie
    {Coordinate{3.50416, 49.2086}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2611283
    {Coordinate{1.83361, 42.7244}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ax-les-Thermes
    {Coordinate{1.32389, 43.4647}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Muret
    {Coordinate{2.45194, 48.6344}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2612260
    {Coordinate{3.03463, 50.5482}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2612480
    {Coordinate{1.64612, 47.2551}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2612548
    {Coordinate{2.38308, 48.839}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bercy
    {Coordinate{2.85436, 48.8826}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2613961
    {Coordinate{1.21167, 43.2978}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carbonne
    {Coordinate{3.98639, 51.1075}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lokeren railway station
    {Coordinate{5.975, 50.6592}, Tz::Europe_Brussels, CountryId{"BE"}}, // Welkenraedt railway station
    {Coordinate{-1.84663, 47.3022}, Tz::Europe_Paris, CountryId{"FR"}}, // Cordemais
    {Coordinate{2.40111, 48.2933}, Tz::Europe_Paris, CountryId{"FR"}}, // Malesherbes
    {Coordinate{5.0512, 50.9931}, Tz::Europe_Brussels, CountryId{"BE"}}, // Diest railway station
    {Coordinate{-0.897671, 45.9433}, Tz::Europe_Paris, CountryId{"FR"}}, // Tonnay-Charente train station
    {Coordinate{4.37948, 45.4648}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Étienne-La Terrasse
    {Coordinate{6.39954, 48.2709}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2616463
    {Coordinate{24.2575, 59.3205}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2616477
    {Coordinate{1.48316, 45.0147}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gignac-Cressensac
    {Coordinate{4.58488, 50.4295}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aiseau railway station
    {Coordinate{6.05806, 50.8961}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Eygelshoven Markt railway station
    {Coordinate{125.324, 43.91}, Tz::Asia_Shanghai, CountryId{"CN"}}, // Changchun railway station
    {Coordinate{7.14805, 48.3897}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2618399
    {Coordinate{3.71959, 51.089}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wondelgem railway station
    {Coordinate{2.51222, 48.9628}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villepinte
    {Coordinate{5.63277, 43.1997}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Ciotat
    {Coordinate{5.51567, 43.2848}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2619859
    {Coordinate{3.99333, 50.7353}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tollembeek railway station
    {Coordinate{5.09528, 50.4967}, Tz::Europe_Brussels, CountryId{"BE"}}, // Andenne railway station
    {Coordinate{7.0916, 49.0914}, Tz::Europe_Paris, CountryId{"FR"}}, // Rémelfing
    {Coordinate{4.41722, 50.9078}, Tz::Europe_Brussels, CountryId{"BE"}}, // Buda railway station
    {Coordinate{1.94364, 48.7556}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Verrière
    {Coordinate{2.02299, 50.883}, Tz::Europe_Paris, CountryId{"FR"}}, // Nortkerque
    {Coordinate{5.80639, 50.5681}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pepinster railway station
    {Coordinate{5.80444, 50.5636}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pepinster-Cité railway station
    {Coordinate{-1.71354, 48.0673}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Jacques-de-la-Lande
    {Coordinate{-2.00399, 48.6466}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Malo
    {Coordinate{3.1307, 48.3239}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2623301
    {Coordinate{0.93793, 48.9622}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2623394
    {Coordinate{13.0751, 50.8544}, Tz::Europe_Berlin, CountryId{"DE"}}, // Flöha railway station
    {Coordinate{2.75338, 45.0907}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Lioran
    {Coordinate{17.3417, 50.4778}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Main Train Station in Nysa
    {Coordinate{2.77176, 50.4342}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Liévin
    {Coordinate{4.62133, 50.7243}, Tz::Europe_Brussels, CountryId{"BE"}}, // Basse-Wavre railway station
    {Coordinate{15.7452, 48.6855}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q26254154
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q26257043
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Porokylä railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Niittylahti railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Ilomantsi railway station
    {Coordinate{5.37683, 47.1928}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2625770
    {Coordinate{-1.02369, 46.1206}, Tz::Europe_Paris, CountryId{"FR"}}, // Q26257933
    {Coordinate{7.85917, 45.4903}, Tz::Europe_Rome, CountryId{"IT"}}, // Q26258088
    {Coordinate{7.8094, 45.5672}, Tz::Europe_Rome, CountryId{"IT"}}, // Q26258089
    {Coordinate{8.20655, 44.8644}, Tz::Europe_Rome, CountryId{"IT"}}, // San Marzanotto railway station
    {Coordinate{2.12917, 48.8}, Tz::Europe_Paris, CountryId{"FR"}}, // Versailles-Château
    {Coordinate{5.34972, 50.9544}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kiewit railway station
    {Coordinate{1.94906, 49.124}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2627008
    {Coordinate{4.6987, 50.5581}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chapelle-Dieu railway station
    {Coordinate{4.34853, 50.8412}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels-Chapel railway station
    {Coordinate{1.23694, 43.6147}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2628524
    {Coordinate{4.64868, 50.6088}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chastre railway station
    {Coordinate{6.28012, 46.7765}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2629074
    {Coordinate{3.89611, 50.9014}, Tz::Europe_Brussels, CountryId{"BE"}}, // Terhagen railway station
    {Coordinate{3.96936, 50.8118}, Tz::Europe_Brussels, CountryId{"BE"}}, // Appelterre railway station
    {Coordinate{7.88249, 48.9346}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2630630
    {Coordinate{-0.609242, 44.8866}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2631759
    {Coordinate{13.3069, 52.6178}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin-Hermsdorf station
    {Coordinate{2.15333, 49.0194}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pierrelaye
    {Coordinate{-1.76606, 47.8979}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2632104
    {Coordinate{3.27159, 49.1873}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2632376
    {Coordinate{5.13139, 52.0872}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Station Utrecht Maliebaan
    {Coordinate{-2.33167, 48.5074}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2632632
    {Coordinate{2.49222, 48.5661}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Coudray-Montceaux
    {Coordinate{4.20111, 51.0164}, Tz::Europe_Brussels, CountryId{"BE"}}, // Buggenhout railway station
    {Coordinate{4.09528, 50.8825}, Tz::Europe_Brussels, CountryId{"BE"}}, // Liedekerke railway station
    {Coordinate{7.86944, 50.7894}, Tz::Europe_Berlin, CountryId{"DE"}}, // Betzdorf (Sieg) station
    {Coordinate{7.0019, 50.9901}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Stammheim station
    {Coordinate{7.59406, 44.0899}, Tz::Europe_Paris, CountryId{"FR"}}, // Tende railway station
    {Coordinate{-2.97384, 48.5332}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2637353
    {Coordinate{30.1525, 59.9945}, Tz::Europe_Moscow, CountryId{"RU"}}, // Lakhta railway station
    {Coordinate{28.7513, 60.7154}, Tz::Europe_Moscow, CountryId{"RU"}}, // Vyborg railway station
    {Coordinate{6.59306, 53.3069}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bedum railway station
    {Coordinate{24.8533, 60.2706}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Louhela railway station
    {Coordinate{1.93231, 47.721}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2641304
    {Coordinate{13.4085, 52.3602}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mahlow station
    {Coordinate{8.63251, 44.6305}, Tz::Europe_Rome, CountryId{"IT"}}, // Ovada railway station
    {Coordinate{11.5803, 49.95}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bayreuth Central Station
    {Coordinate{-1.76028, 47.9353}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guichen - Bourg-des-Comptes
    {Coordinate{4.99056, 52.17}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Breukelen railway station
    {Coordinate{4.63167, 52.4194}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Santpoort Zuid
    {Coordinate{-4.09417, 48.2016}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2644205
    {Coordinate{6.31483, 47.1511}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2645004
    {Coordinate{6.96338, 51.0642}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leverkusen-Rheindorf station
    {Coordinate{-0.276111, 47.3972}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Ménitré
    {Coordinate{2.75329, 49.3595}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Meux - La Croix-Saint-Ouen
    {Coordinate{6.85256, 51.4491}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mülheim-Styrum station
    {Coordinate{4.11666, 50.8825}, Tz::Europe_Brussels, CountryId{"BE"}}, // Essene-Lombeek railway station
    {Coordinate{-3.38234, 48.4274}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2649057
    {Coordinate{18.853, 46.6067}, Tz::Europe_Budapest, CountryId{"HU"}}, // Paks railway station
    {Coordinate{-0.537784, 44.752}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cadaujac
    {Coordinate{3.72873, 48.5142}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Romilly-sur-Seine
    {Coordinate{4.58417, 51.9533}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Capelle Schollevaar railway station
    {Coordinate{2.24056, 49.1636}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chambly
    {Coordinate{2.95433, 49.5343}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2650500
    {Coordinate{-3.31144, 48.4702}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2650643
    {Coordinate{2.13761, 43.9226}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albi-Ville
    {Coordinate{3.82327, 50.6864}, Tz::Europe_Brussels, CountryId{"BE"}}, // Papignies railway station
    {Coordinate{2.40826, 50.8316}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2651595
    {Coordinate{36.6056, 50.5931}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q2651951
    {Coordinate{3.64611, 50.9078}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zingem railway station
    {Coordinate{6.03583, 53.2483}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Zwaagwesteinde railway station
    {Coordinate{2.48361, 48.7064}, Tz::Europe_Paris, CountryId{"FR"}}, // Yerres railway station
    {Coordinate{6.2131, 47.1692}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2653098
    {Coordinate{6.64861, 45.5544}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aime-La Plagne
    {Coordinate{2.7375, 47.8528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nogent-sur-Vernisson
    {Coordinate{3.21577, 49.2551}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2653635
    {Coordinate{26.5275, 55.8749}, Tz::Europe_Riga, CountryId{"LV"}}, // Daugavpils Station
    {Coordinate{6.03915, 48.9523}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2654586
    {Coordinate{-1.4491, 43.4047}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ustaritz
    {Coordinate{5.80888, 47.1836}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2655559
    {Coordinate{7.11212, 49.0862}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2655906
    {Coordinate{-0.853716, 44.6905}, Tz::Europe_Paris, CountryId{"FR"}}, // Marcheprime
    {Coordinate{3.23073, 50.5061}, Tz::Europe_Paris, CountryId{"FR"}}, // Nomain
    {Coordinate{4.79278, 52.4892}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Wormerveer railway station
    {Coordinate{5.48795, 47.0961}, Tz::Europe_Paris, CountryId{"FR"}}, // Dole-Ville railway station
    {Coordinate{1.50788, 46.6265}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2657063
    {Coordinate{7.4624, 49.5474}, Tz::Europe_Berlin, CountryId{"DE"}}, // Altenglan station
    {Coordinate{2.48083, 48.8825}, Tz::Europe_Paris, CountryId{"FR"}}, // Rosny-Bois-Perrier station
    {Coordinate{13.5797, 51.1231}, Tz::Europe_Berlin, CountryId{"DE"}}, // Coswig (b Dresden) station
    {Coordinate{7.96444, 51.1728}, Tz::Europe_Berlin, CountryId{"DE"}}, // Finnentrop station
    {Coordinate{9.82771, 47.6463}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hergatz station
    {Coordinate{12.2356, 50.5712}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herlasgrün station
    {Coordinate{9.12111, 52.3081}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kirchhorsten railway station
    {Coordinate{7.72949, 49.4838}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2657925
    {Coordinate{7.59071, 49.6537}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lauterecken-Grumbach station
    {Coordinate{12.7989, 52.9302}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q2657942
    {Coordinate{7.60389, 50.2998}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberlahnstein station
    {Coordinate{10.277, 47.4104}, Tz::Europe_Berlin, CountryId{"DE"}}, // Oberstdorf station
    {Coordinate{11.427, 47.9142}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wolfratshausen station
    {Coordinate{1.58889, 50.0633}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Feuquières-Fressenneville
    {Coordinate{2.418, 49.2142}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2659445
    {Coordinate{6.03889, 50.635}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eupen railway station
    {Coordinate{6.47697, 49.0038}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2659780
    {Coordinate{24.1218, 56.9463}, Tz::Europe_Riga, CountryId{"LV"}}, // Riga Central Station
    {Coordinate{5.93952, 51.6445}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Boxmeer railway station
    {Coordinate{-0.798537, 45.8945}, Tz::Europe_Paris, CountryId{"FR"}}, // Bords
    {Coordinate{2.23694, 48.8922}, Tz::Europe_Paris, CountryId{"FR"}}, // La Défense
    {Coordinate{4.99176, 46.2271}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2661260
    {Coordinate{6.60842, 48.5312}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2661330
    {Coordinate{3.70194, 51.1072}, Tz::Europe_Brussels, CountryId{"BE"}}, // Evergem railway station
    {Coordinate{-0.186111, 49.1111}, Tz::Europe_Paris, CountryId{"FR"}}, // Moult - Argences
    {Coordinate{4.51333, 51.0086}, Tz::Europe_Brussels, CountryId{"BE"}}, // Muizen railway station
    {Coordinate{6.03083, 52.01}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rheden railway station
    {Coordinate{25.9613, 59.2656}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Tapa railway station
    {Coordinate{7.26516, 47.8275}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Staffelfelden
    {Coordinate{12.235, 51.84}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dessau Central Station
    {Coordinate{5.19056, 50.5219}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bas-Oha railway station
    {Coordinate{1.49223, 46.2398}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2666389
    {Coordinate{6.86676, 45.9199}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2667134
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q26683837
    {Coordinate{3.78111, 50.9533}, Tz::Europe_Brussels, CountryId{"BE"}}, // Moortsele railway station
    {Coordinate{3.77477, 49.5563}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2668765
    {Coordinate{1.92061, 49.2026}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lavilletertre
    {Coordinate{2.70475, 45.6469}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2669277
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q26694328
    {Coordinate{5.8148, 44.5315}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2669992
    {Coordinate{4.67188, 50.4529}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ham-sur-Sambre railway station
    {Coordinate{1.08333, 43.2128}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cazères-sur-Garonne
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q26706935
    {Coordinate{6.90968, 51.2294}, Tz::Europe_Berlin, CountryId{"DE"}}, // Erkrath Nord station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26714912
    {Coordinate{10.55, 52.022}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schladen (Harz) station
    {Coordinate{10.569, 52.0605}, Tz::Europe_Berlin, CountryId{"DE"}}, // Börßum station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kaskinen railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Niirala-raja railway station
    {Coordinate{0.5257, 46.7834}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2672815
    {Coordinate{2.36981, 42.5916}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2672817
    {Coordinate{2.62341, 48.5401}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Mée
    {Coordinate{4.74689, 45.7728}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2672930
    {Coordinate{0.239004, 43.1836}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tournay
    {Coordinate{5.4225, 51.2156}, Tz::Europe_Brussels, CountryId{"BE"}}, // Overpelt railway station
    {Coordinate{8.31009, 45.3415}, Tz::Europe_Rome, CountryId{"IT"}}, // Olcenengo railway station
    {Coordinate{3.32958, 50.9904}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tielt railway station
    {Coordinate{6.03499, 43.1363}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Pauline-Hyères
    {Coordinate{-3.56229, 48.2778}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carhaix
    {Coordinate{-1.49611, 47.1903}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sébastien-Frêne-Rond
    {Coordinate{0.682844, 49.2715}, Tz::Europe_Paris, CountryId{"FR"}}, // Glos-Montfort
    {Coordinate{7.38133, 48.5274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Heiligenberg - Mollkirch
    {Coordinate{-0.507644, 43.154}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ogeu-les-Bains
    {Coordinate{0.789187, 43.65}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2676863
    {Coordinate{4.84108, 43.9345}, Tz::Europe_Paris, CountryId{"FR"}}, // Q26772027
    {Coordinate{23.3538, 52.518}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2677271
    {Coordinate{-1.62139, 49.6333}, Tz::Europe_Paris, CountryId{"FR"}}, // Cherbourg railway station
    {Coordinate{5.84278, 50.9672}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geleen Oost railway station
    {Coordinate{4.79549, 45.3717}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2678036
    {Coordinate{1.87917, 46.1742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guéret
    {Coordinate{6.83861, 52.2372}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Enschede Drienerlo railway station
    {Coordinate{2.35028, 48.9175}, Tz::Europe_Paris, CountryId{"FR"}}, // Stade de France – Saint-Denis
    {Coordinate{5.37028, 43.4031}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2678689
    {Coordinate{2.42611, 48.9308}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Bourget
    {Coordinate{8.51606, 49.4599}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26791758
    {Coordinate{5.81779, 50.5299}, Tz::Europe_Brussels, CountryId{"BE"}}, // Franchimont railway station
    {Coordinate{5.42106, 46.2203}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2679597
    {Coordinate{3.76454, 51.0201}, Tz::Europe_Brussels, CountryId{"BE"}}, // Merelbeke railway station
    {Coordinate{5.12466, 50.2619}, Tz::Europe_Brussels, CountryId{"BE"}}, // Chapois railway station
    {Coordinate{6.15642, 50.8706}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Annapark station
    {Coordinate{4.61575, 50.6698}, Tz::Europe_Brussels, CountryId{"BE"}}, // Louvain-la-Neuve railway station
    {Coordinate{3.41861, 50.9844}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aarsele railway station
    {Coordinate{-3.41507, 50.6218}, Tz::Europe_London, CountryId{"GB"}}, // Exmouth railway station
    {Coordinate{2.53957, 49.9435}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2681583
    {Coordinate{2.70596, 49.4333}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2681989
    {Coordinate{20.9408, 52.2061}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Aleje Jerozolimskie railway station
    {Coordinate{9.96751, 51.8514}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kreiensen station
    {Coordinate{7.85613, 49.5704}, Tz::Europe_Berlin, CountryId{"DE"}}, // Winnweiler station
    {Coordinate{12.2472, 54.1767}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rövershagen railway station
    {Coordinate{11.705, 50.1544}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26821640
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26821689
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Burg (bei Magdeburg) station
    {Coordinate{17.9502, 47.4798}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonyszombathely railway station
    {Coordinate{2.27167, 48.9806}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ermont - Eaubonne
    {Coordinate{17.9138, 47.4716}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonybánk railway station
    {Coordinate{17.8675, 47.4772}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tápszentmiklós railway station
    {Coordinate{17.8355, 47.4701}, Tz::Europe_Budapest, CountryId{"HU"}}, // Lázi railway station
    {Coordinate{17.7934, 47.4394}, Tz::Europe_Budapest, CountryId{"HU"}}, // Románd railway station
    {Coordinate{17.748, 47.428}, Tz::Europe_Budapest, CountryId{"HU"}}, // Gic-Hathalom railway station
    {Coordinate{17.7233, 47.4143}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bakonytamási railway station
    {Coordinate{17.6843, 47.376}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pápateszér railway station
    {Coordinate{17.6374, 47.3486}, Tz::Europe_Budapest, CountryId{"HU"}}, // Franciavágás railway station
    {Coordinate{17.6002, 47.3326}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ugod railway station
    {Coordinate{17.5602, 47.3422}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagygyimót railway station
    {Coordinate{17.515, 47.3496}, Tz::Europe_Budapest, CountryId{"HU"}}, // Pusztagyimót  railway station
    {Coordinate{-0.677693, 45.8759}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Savinien-sur-Charente
    {Coordinate{18.2983, 47.5301}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kecskéd railway station
    {Coordinate{18.2279, 47.5231}, Tz::Europe_Budapest, CountryId{"HU"}}, // Dad railway station
    {Coordinate{18.1874, 47.5168}, Tz::Europe_Budapest, CountryId{"HU"}}, // Szákszend railway station
    {Coordinate{18.1494, 47.5085}, Tz::Europe_Budapest, CountryId{"HU"}}, // Császár railway station
    {Coordinate{18.0781, 47.5157}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ete railway station
    {Coordinate{18.2713, 47.5164}, Tz::Europe_Budapest, CountryId{"HU"}}, // Bokod railway station
    {Coordinate{17.9436, 47.2968}, Tz::Europe_Budapest, CountryId{"HU"}}, // Q26833849
    {Coordinate{17.7289, 47.5611}, Tz::Europe_Budapest, CountryId{"HU"}}, // Écs railway staion
    {Coordinate{2.28286, 48.9061}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Asnières-sur-Seine
    {Coordinate{5.92972, 43.1286}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulon
    {Coordinate{8.56889, 50.1436}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26836599
    {Coordinate{13.0227, 48.2631}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q26836635
    {Coordinate{2.35222, 48.6761}, Tz::Europe_Paris, CountryId{"FR"}}, // Savigny-sur-Orge (Paris RER)
    {Coordinate{6.18647, 43.2975}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2684008
    {Coordinate{5.87167, 50.8561}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Schin op Geul railway station
    {Coordinate{0.89, 44.1117}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Valence-d'Agen
    {Coordinate{18.4487, 47.5518}, Tz::Europe_Budapest, CountryId{"HU"}}, // Felsőgalla railway station
    {Coordinate{5.5021, 50.3496}, Tz::Europe_Brussels, CountryId{"BE"}}, // Barvaux railway station
    {Coordinate{37.7461, 55.8039}, Tz::Europe_Moscow, CountryId{"RU"}}, // Cherkizovo
    {Coordinate{5.55028, 51.42}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geldrop railway station
    {Coordinate{-0.651585, 43.93}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Martin-d'Oney
    {Coordinate{2.32639, 49.3206}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mouy-Bury
    {Coordinate{20.9719, 52.1722}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warsaw Chopin Airport railway station
    {Coordinate{-1.63038, 48.2086}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2686580
    {Coordinate{4.13166, 50.3102}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erquelinnes-Village railway station
    {Coordinate{4.74278, 49.8119}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2687707
    {Coordinate{1.84814, 48.9721}, Tz::Europe_Paris, CountryId{"FR"}}, // Aubergenville-Élisabethville
    {Coordinate{7.70032, 48.7328}, Tz::Europe_Paris, CountryId{"FR"}}, // Brumath
    {Coordinate{3.53622, 51.0731}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hansbeke railway station
    {Coordinate{10.229, 52.0892}, Tz::Europe_Berlin, CountryId{"DE"}}, // Baddeckenstedt station
    {Coordinate{10.1438, 52.0969}, Tz::Europe_Berlin, CountryId{"DE"}}, // Derneburg (Han) station
    {Coordinate{2.2425, 49.0156}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Leu-la-Forêt
    {Coordinate{4.56571, 50.6466}, Tz::Europe_Brussels, CountryId{"BE"}}, // Court-Saint-Étienne railway station
    {Coordinate{5.35791, 43.3696}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2689067
    {Coordinate{-3.28576, 47.7991}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hennebont
    {Coordinate{-0.318056, 47.4122}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Mathurin
    {Coordinate{4.66306, 51.6908}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lage Zwaluwe railway station
    {Coordinate{5.89126, 49.3666}, Tz::Europe_Paris, CountryId{"FR"}}, // Audun-le-Roman
    {Coordinate{5.88098, 50.3912}, Tz::Europe_Brussels, CountryId{"BE"}}, // Coo railway station
    {Coordinate{6.92106, 47.6216}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2690835
    {Coordinate{5.33409, 46.4338}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2691181
    {Coordinate{-3.56823, 48.5816}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Plounérin
    {Coordinate{6.57491, 50.8627}, Tz::Europe_Berlin, CountryId{"DE"}}, // Buir station
    {Coordinate{3.54326, 45.8612}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2691990
    {Coordinate{5.58361, 51.9314}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Kesteren railway station
    {Coordinate{7.32075, 48.0166}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2692559
    {Coordinate{4.96694, 52.3453}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Diemen railway station
    {Coordinate{2.36028, 49.2725}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cires-lès-Mello
    {Coordinate{-1.305, 43.235}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ossès-Saint-Martin-d'Arrossa
    {Coordinate{4.99278, 51.5739}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tilburg Reeshof railway station
    {Coordinate{2.13611, 49.2886}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laboissière-Le Déluge
    {Coordinate{7.53117, 47.6095}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Louis-la-Chaussée
    {Coordinate{20.9653, 52.2203}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Zachodnia station
    {Coordinate{1.81799, 49.2827}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2694601
    {Coordinate{5.60861, 51.4622}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Helmond Brandevoort railway station
    {Coordinate{6.35017, 49.444}, Tz::Europe_Paris, CountryId{"FR"}}, // Sierck-les-Bains
    {Coordinate{1.06614, 47.3307}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2695647
    {Coordinate{4.38338, 50.715}, Tz::Europe_Brussels, CountryId{"BE"}}, // Waterloo railway station
    {Coordinate{3.44884, 49.496}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2696779
    {Coordinate{2.25951, 48.9235}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Colombes
    {Coordinate{4.29778, 51.0092}, Tz::Europe_Brussels, CountryId{"BE"}}, // Londerzeel railway station
    {Coordinate{4.41444, 50.8892}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haren-South railway station
    {Coordinate{11.133, 45.0541}, Tz::Europe_Rome, CountryId{"IT"}}, // Q26972880
    {Coordinate{2.16188, 48.9903}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2697336
    {Coordinate{1.83433, 47.3903}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2697644
    {Coordinate{2.84234, 48.3865}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2697657
    {Coordinate{1.68611, 42.7864}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Cabannes
    {Coordinate{2.21665, 48.8569}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Val d'Or
    {Coordinate{-0.534813, 45.8501}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Hilaire - Brizambourg
    {Coordinate{-0.425286, 44.6929}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Portets
    {Coordinate{6.97417, 52.2186}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Glanerbrug railway station
    {Coordinate{7.93344, 48.9313}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2700531
    {Coordinate{2.24811, 42.9424}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Couiza-Montazels
    {Coordinate{2.67905, 48.5103}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2700782
    {Coordinate{2.16175, 45.9598}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2701026
    {Coordinate{-0.030946, 44.58}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Réole
    {Coordinate{5.8775, 51.7647}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Mook-Molenhoek railway station
    {Coordinate{2.3925, 49.7994}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dommartin-Remiencourt
    {Coordinate{7.55009, 51.5207}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Brackel station
    {Coordinate{17.4707, 50.8531}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Brzeg railway station
    {Coordinate{16.78, 48.0189}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q27031506
    {Coordinate{10.4937, 52.1804}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzgitter-Thiede station
    {Coordinate{10.4418, 52.1501}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27031811
    {Coordinate{10.4071, 52.1501}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzgitter-Watenstedt station
    {Coordinate{10.333, 52.1513}, Tz::Europe_Berlin, CountryId{"DE"}}, // Salzgitter-Lebenstedt station
    {Coordinate{-0.921062, 44.2106}, Tz::Europe_Paris, CountryId{"FR"}}, // Labouheyre
    {Coordinate{2.41444, 48.7083}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2703407
    {Coordinate{-0.974109, 48.1108}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2703622
    {Coordinate{-1.45641, 43.4314}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villefranque
    {Coordinate{10.6606, 52.1568}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dettum station
    {Coordinate{10.3198, 52.1968}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lengede-Broistedt station
    {Coordinate{10.2792, 52.2007}, Tz::Europe_Berlin, CountryId{"DE"}}, // Woltwiesche station
    {Coordinate{10.1972, 52.2001}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27057411
    {Coordinate{0.221314, 45.6763}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2706277
    {Coordinate{7.95402, 48.9614}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2707075
    {Coordinate{7.44306, 48.26}, Tz::Europe_Paris, CountryId{"FR"}}, // Sélestat
    {Coordinate{6.2746, 51.2743}, Tz::Europe_Berlin, CountryId{"DE"}}, // Boisheim railway station
    {Coordinate{-1.37013, 48.6902}, Tz::Europe_Paris, CountryId{"FR"}}, // Avranches
    {Coordinate{16.915, 41.1117}, Tz::Europe_Rome, CountryId{"IT"}}, // Bari Torre Quetta railway halt
    {Coordinate{15.533, 41.3518}, Tz::Europe_Rome, CountryId{"IT"}}, // Ponte Albanito railway station
    {Coordinate{6.68903, 47.4554}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2711259
    {Coordinate{13.7464, 51.0723}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dresden Bischofsplatz station
    {Coordinate{2.27501, 46.9352}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2711794
    {Coordinate{4.80198, 50.4992}, Tz::Europe_Brussels, CountryId{"BE"}}, // Rhisnes railway station
    {Coordinate{7.12496, 47.6276}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dannemarie
    {Coordinate{1.00959, 45.8767}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2713487
    {Coordinate{7.34531, 48.0817}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Colmar-Saint-Joseph
    {Coordinate{1.60806, 43.0125}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Jean-de-Verges
    {Coordinate{-0.951618, 46.0939}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aigrefeuille - Le Thou
    {Coordinate{2.50194, 49.0492}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2716584
    {Coordinate{6.90128, 49.1895}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Forbach
    {Coordinate{0.191944, 47.9942}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Mans
    {Coordinate{2.08748, 42.4979}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bolquère - Eyne
    {Coordinate{-1.84323, 48.5936}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2718288
    {Coordinate{6.73556, 52.6631}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Coevorden railway station
    {Coordinate{0.381752, 46.682}, Tz::Europe_Paris, CountryId{"FR"}}, // Janay-Clan station
    {Coordinate{-1.49777, 47.9553}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2720994
    {Coordinate{1.93722, 43.9283}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tessonnières
    {Coordinate{0.892317, 48.4328}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2723066
    {Coordinate{4.38944, 50.8222}, Tz::Europe_Brussels, CountryId{"BE"}}, // Etterbeek railway station
    {Coordinate{6.77441, 49.1262}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2725085
    {Coordinate{2.498, 50.357}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2725104
    {Coordinate{2.34861, 49.6964}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Faloise
    {Coordinate{1.51832, 46.5923}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2727028
    {Coordinate{1.73912, 47.3556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2727107
    {Coordinate{2.69028, 48.7706}, Tz::Europe_Paris, CountryId{"FR"}}, // Ozoir-la-Ferrière Station
    {Coordinate{-0.397182, 48.1555}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2727830
    {Coordinate{5.76812, 49.6909}, Tz::Europe_Brussels, CountryId{"BE"}}, // Stockem railway station
    {Coordinate{1.84992, 50.9409}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Fontinettes
    {Coordinate{6.3103, 49.0635}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2729654
    {Coordinate{7.06913, 51.4292}, Tz::Europe_Berlin, CountryId{"DE"}}, // Essen-Überruhr station
    {Coordinate{2.42895, 49.5036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Just-en-Chaussée
    {Coordinate{2.42566, 49.4681}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2731100
    {Coordinate{6.22467, 46.1945}, Tz::Europe_Paris, CountryId{"FR"}}, // Ambilly Station
    {Coordinate{4.66222, 50.7547}, Tz::Europe_Brussels, CountryId{"BE"}}, // Archennes railway station
    {Coordinate{}, Timezone{}, CountryId{"UZ"}}, // Khavast
    {Coordinate{5.53375, 50.4283}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hamoir railway station
    {Coordinate{4.33, 51.2142}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zwijndrecht railway station
    {Coordinate{2.22222, 48.5817}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2733637
    {Coordinate{6.69855, 51.22}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuss Am Kaiser station
    {Coordinate{2.47583, 49.7767}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moreuil
    {Coordinate{2.52139, 49.8628}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villers-Bretonneux
    {Coordinate{2.64222, 49.4386}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Estrées-Saint-Denis
    {Coordinate{2.80111, 49.8075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chaulnes
    {Coordinate{4.43389, 52.1264}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voorschoten railway station
    {Coordinate{4.88797, 45.7052}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vénissieux
    {Coordinate{2.57261, 49.9556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2738092
    {Coordinate{-3.83417, 47.9606}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rosporden
    {Coordinate{-0.260278, 49.1411}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Frénouville-Cagny
    {Coordinate{4.03944, 50.9428}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aalst railway station
    {Coordinate{-0.644454, 45.8304}, Tz::Europe_Paris, CountryId{"FR"}}, // Taillebourg
    {Coordinate{7.60269, 48.7537}, Tz::Europe_Paris, CountryId{"FR"}}, // Schwindratzheim
    {Coordinate{10.5244, 52.4163}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rötgesbüttel station
    {Coordinate{10.5358, 52.3813}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meine station
    {Coordinate{5.04361, 49.9336}, Tz::Europe_Brussels, CountryId{"BE"}}, // Graide railway station
    {Coordinate{5.16838, 49.6283}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2743849
    {Coordinate{-1.12815, 46.1275}, Tz::Europe_Paris, CountryId{"FR"}}, // Aytré-Plage
    {Coordinate{-0.34105, 44.6324}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cérons
    {Coordinate{4.87458, 45.5213}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vienne
    {Coordinate{-2.16096, 47.3213}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2744949
    {Coordinate{-0.809245, 44.007}, Tz::Europe_Paris, CountryId{"FR"}}, // Arengosse
    {Coordinate{4.32857, 50.881}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jette railway station
    {Coordinate{6.01774, 46.5393}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2745587
    {Coordinate{17.0172, 54.4672}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Słupsk railway station
    {Coordinate{2.14139, 43.9378}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albi-Madeleine
    {Coordinate{5.39222, 51.8739}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tiel Passewaaij railway station
    {Coordinate{4.90806, 50.2611}, Tz::Europe_Brussels, CountryId{"BE"}}, // Dinant railway station
    {Coordinate{3.04639, 50.7818}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wervik railway station
    {Coordinate{5.63694, 51.9261}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Opheusden railway station
    {Coordinate{-0.773, 52.035}, Tz::Europe_London, CountryId{"GB"}}, // Milton Keynes Central railway station
    {Coordinate{2.21809, 42.9358}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Espéraza
    {Coordinate{6.88828, 48.3271}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2747695
    {Coordinate{0.488806, 48.0749}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2747705
    {Coordinate{11.2448, 51.1802}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478676
    {Coordinate{6.95734, 50.7958}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sechtem station
    {Coordinate{7.72889, 48.0497}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478870
    {Coordinate{8.02722, 48.3386}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478874
    {Coordinate{13.3636, 50.8758}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478889
    {Coordinate{7.7694, 48.1523}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478896
    {Coordinate{11.7572, 47.7141}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tegernsee station
    {Coordinate{9.8307, 47.6891}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27478957
    {Coordinate{9.17235, 48.7759}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stuttgart Stadtmitte station
    {Coordinate{4.82437, 46.3025}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mâcon-Ville
    {Coordinate{6.85383, 47.6336}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belfort
    {Coordinate{2.05987, 47.2266}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vierzon-Ville
    {Coordinate{1.52833, 45.1525}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Brive-la-Gaillarde
    {Coordinate{3.15056, 46.9869}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nevers
    {Coordinate{3.1585, 50.2685}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2749450
    {Coordinate{4.05568, 50.9193}, Tz::Europe_Brussels, CountryId{"BE"}}, // Erembodegem railway station
    {Coordinate{4.21053, 50.52}, Tz::Europe_Brussels, CountryId{"BE"}}, // Familleureux railway station
    {Coordinate{-1.67446, 48.3072}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2750216
    {Coordinate{4.74333, 51.8297}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Sliedrecht Baanhoek railway station
    {Coordinate{-1.4447, 43.3911}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Jatxou
    {Coordinate{3.16389, 51.1267}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zedelgem railway station
    {Coordinate{2.12222, 49.0545}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2752323
    {Coordinate{6.98812, 51.0458}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leverkusen-Küppersteg station
    {Coordinate{5.00693, 45.8339}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2752803
    {Coordinate{3.22039, 50.5306}, Tz::Europe_Paris, CountryId{"FR"}}, // Genech
    {Coordinate{2.41806, 49.3853}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clermont-de-l'Oise
    {Coordinate{6.81594, 51.0988}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dormagen station
    {Coordinate{21.0011, 52.2278}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Śródmieście WKD railway station
    {Coordinate{2.20556, 42.917}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Campagne
    {Coordinate{3.13796, 50.6786}, Tz::Europe_Paris, CountryId{"FR"}}, // Croix - Wasquehal
    {Coordinate{4.74556, 52.0819}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bodegraven railway station
    {Coordinate{6.07461, 50.8319}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kohlscheid railway station
    {Coordinate{30.7798, 59.7601}, Tz::Europe_Moscow, CountryId{"RU"}}, // Ivanovskaya railway station
    {Coordinate{6.3069, 45.5436}, Tz::Europe_Paris, CountryId{"FR"}}, // Aiguebelle
    {Coordinate{2.04903, 48.9748}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2759280
    {Coordinate{7.38643, 51.4882}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Oespel station
    {Coordinate{2.14178, 49.0693}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2761375
    {Coordinate{-1.14556, 46.1528}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Rochelle
    {Coordinate{27.4039, 66.7236}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kemijärvi railway station
    {Coordinate{3.20858, 48.7993}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2762581
    {Coordinate{2.41778, 49.4446}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2762650
    {Coordinate{7.7212, 48.6447}, Tz::Europe_Paris, CountryId{"FR"}}, // Mundolsheim
    {Coordinate{-3.41966, 48.4063}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Callac
    {Coordinate{5.99911, 49.2183}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2765639
    {Coordinate{4.87861, 50.3208}, Tz::Europe_Brussels, CountryId{"BE"}}, // Yvoir railway station
    {Coordinate{6.65833, 45.1925}, Tz::Europe_Paris, CountryId{"FR"}}, // Modane
    {Coordinate{2.60808, 50.5255}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fouquereuil
    {Coordinate{3.11264, 50.3565}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2767849
    {Coordinate{3.62784, 50.9607}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eke-Nazareth railway station
    {Coordinate{6.45056, 52.0806}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ruurlo railway station
    {Coordinate{21.0375, 52.2553}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Wileńska station
    {Coordinate{-0.504509, 43.8847}, Tz::Europe_Paris, CountryId{"FR"}}, // Mont-de-Marsan
    {Coordinate{3.88056, 50.8969}, Tz::Europe_Brussels, CountryId{"BE"}}, // Herzele railway station
    {Coordinate{13.0544, 51.9976}, Tz::Europe_Berlin, CountryId{"DE"}}, // Jüterbog station
    {Coordinate{5.78604, 49.6882}, Tz::Europe_Brussels, CountryId{"BE"}}, // Viville railway station
    {Coordinate{-1.16544, 44.6588}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Arcachon
    {Coordinate{7.43486, 52.2765}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheine station
    {Coordinate{4.35889, 51.0108}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kapelle-op-den-Bos railway station
    {Coordinate{10.5428, 52.4797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gifhorn-Stadt railway station
    {Coordinate{10.5781, 52.5093}, Tz::Europe_Berlin, CountryId{"DE"}}, // Triangel railway station
    {Coordinate{10.6074, 52.5487}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neudorf-Platendorf railway station
    {Coordinate{10.607, 52.608}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wahrenholz railway station
    {Coordinate{10.6347, 52.6279}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schönewörde railway station
    {Coordinate{10.656, 52.6477}, Tz::Europe_Berlin, CountryId{"DE"}}, // Vorhop railway station
    {Coordinate{4.83583, 50.8358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vertrijk railway station
    {Coordinate{6.13222, 51.9331}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Didam railway station
    {Coordinate{24.3192, 59.3139}, Tz::Europe_Tallinn, CountryId{"EE"}}, // Q2778863
    {Coordinate{10.6904, 52.6778}, Tz::Europe_Berlin, CountryId{"DE"}}, // Knesebeck railway station
    {Coordinate{10.723, 52.7271}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wittingen railway station
    {Coordinate{5.56722, 50.4564}, Tz::Europe_Brussels, CountryId{"BE"}}, // Comblain-la-Tour railway station
    {Coordinate{10.6734, 52.8342}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Bodenteich railway station
    {Coordinate{8.03118, 43.8973}, Tz::Europe_Rome, CountryId{"IT"}}, // Imperia railway station
    {Coordinate{8.13834, 43.9601}, Tz::Europe_Rome, CountryId{"IT"}}, // Andora railway station
    {Coordinate{6.16904, 48.7353}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2779510
    {Coordinate{5.72833, 53.1886}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Deinum railway station
    {Coordinate{-1.81922, 48.1233}, Tz::Europe_Paris, CountryId{"FR"}}, // L'Hermitage - Mordelles
    {Coordinate{8.80211, 50.06}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heusenstamm station
    {Coordinate{4.32528, 50.4969}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gouy-lez-Piéton railway station
    {Coordinate{4.67134, 52.3829}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Haarlem Spaarnwoude railway station
    {Coordinate{4.36167, 50.7481}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Genesius-Rode railway station
    {Coordinate{0.804719, 48.7658}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2781575
    {Coordinate{2.21825, 43.0684}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Limoux-Flassian
    {Coordinate{6.14062, 50.8766}, Tz::Europe_Berlin, CountryId{"DE"}}, // Alsdorf-Busch station
    {Coordinate{5.15056, 45.6275}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2781996
    {Coordinate{3.95646, 50.4719}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nimy railway station
    {Coordinate{8.83732, 50.1194}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühlheim station
    {Coordinate{8.78923, 50.0177}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dietzenbach-Mitte station
    {Coordinate{2.29167, 48.8181}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vanves-Malakoff
    {Coordinate{1.33838, 48.0734}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2782753
    {Coordinate{5.44512, 43.5232}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aix-en-Provence
    {Coordinate{6.73554, 45.5751}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Landry
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Priobye railway station
    {Coordinate{8.19242, 49.4082}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27842213
    {Coordinate{7.19734, 50.9117}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27842219
    {Coordinate{2.18002, 48.9802}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2784246
    {Coordinate{1.75638, 45.2588}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tulle
    {Coordinate{8.64397, 52.7916}, Tz::Europe_Berlin, CountryId{"DE"}}, // Twistringen station
    {Coordinate{13.5039, 52.5731}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wartenberg station
    {Coordinate{2.3525, 48.7403}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2784751
    {Coordinate{2.46389, 48.8211}, Tz::Europe_Paris, CountryId{"FR"}}, // Joinville-le-Pont
    {Coordinate{6.92246, 51.1671}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hilden station
    {Coordinate{2.92718, 49.5062}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2785272
    {Coordinate{20.9725, 52.3578}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Warszawa Choszczówka railway station
    {Coordinate{3.57646, 49.2968}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2785553
    {Coordinate{3.2852, 51.3399}, Tz::Europe_Brussels, CountryId{"BE"}}, // Knokke railway station
    {Coordinate{2.106, 49.045}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Ouen-l'Aumône
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Serov railway station
    {Coordinate{6.15487, 50.7857}, Tz::Europe_Berlin, CountryId{"DE"}}, // Eilendorf station
    {Coordinate{5.33075, 50.5538}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haute-Flône railway station
    {Coordinate{-1.72775, 48.4162}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Combourg
    {Coordinate{6.75558, 43.4284}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2786235
    {Coordinate{2.22904, 43.598}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Castres
    {Coordinate{0.333056, 46.5822}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Poitiers
    {Coordinate{7.68756, 51.5533}, Tz::Europe_Berlin, CountryId{"DE"}}, // Unna-Königsborn station
    {Coordinate{3.26442, 50.8244}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kortrijk railway station
    {Coordinate{7.55694, 47.7317}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27869673
    {Coordinate{2.02497, 49.0758}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2787050
    {Coordinate{35.9681, 49.7538}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q27876085
    {Coordinate{1.90551, 49.2207}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Liancourt-Saint-Pierre
    {Coordinate{4.76579, 45.5852}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Givors-Ville
    {Coordinate{5.63778, 51.795}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ravenstein railway station
    {Coordinate{1.10209, 49.343}, Tz::Europe_Paris, CountryId{"FR"}}, // Oissel
    {Coordinate{6.12927, 48.2993}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2788266
    {Coordinate{6.90167, 50.9978}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Longerich station
    {Coordinate{4.52455, 50.0958}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mariembourg railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27894893
    {Coordinate{7.18031, 51.3972}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hattingen Mitte station
    {Coordinate{0.40628, 48.0407}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montfort-le-Gesnois
    {Coordinate{-2.08861, 47.6517}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Redon
    {Coordinate{7.75791, 48.6287}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2789917
    {Coordinate{32.0278, 49.4056}, Tz::Europe_Kiev, CountryId{"UA"}}, // Buddetal
    {Coordinate{8.7884, 49.3937}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neckargemünd
    {Coordinate{5.12818, 47.4057}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Julien - Clénay
    {Coordinate{5.50667, 51.7583}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Oss West railway station
    {Coordinate{5.1297, 47.4781}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gemeaux
    {Coordinate{16.2836, 48.1733}, Tz::Europe_Vienna, CountryId{"AT"}}, // Bahnhof Wien Speising
    {Coordinate{3.14611, 50.2781}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2792196
    {Coordinate{13.9132, 37.2058}, Tz::Europe_Rome, CountryId{"IT"}}, // Favarotta railway station
    {Coordinate{1.67595, 50.2731}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rue
    {Coordinate{4.12833, 51.9753}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Hoek van Holland Haven railway station
    {Coordinate{5.66778, 52.0431}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Ede Centrum railway station
    {Coordinate{6.55611, 44.791}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2792896
    {Coordinate{4.28639, 51.2106}, Tz::Europe_Brussels, CountryId{"BE"}}, // Melsele railway station
    {Coordinate{6.29529, 47.9812}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2793921
    {Coordinate{8.34361, 47.8836}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof (Löffingen)
    {Coordinate{7.2423, 51.278}, Tz::Europe_Berlin, CountryId{"DE"}}, // Wuppertal-Langerfeld station
    {Coordinate{2.05996, 48.3747}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Guillerval
    {Coordinate{5.84944, 50.9433}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Spaubeek railway station
    {Coordinate{16.2886, 48.1471}, Tz::Europe_Vienna, CountryId{"AT"}}, // Wien Atzgersdorf railway station
    {Coordinate{2.23028, 49.9147}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dreuil-lès-Amiens
    {Coordinate{3.93561, 50.9135}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bambrugge railway station
    {Coordinate{15.4614, 38.2333}, Tz::Europe_Rome, CountryId{"IT"}}, // Gesso railway station
    {Coordinate{14.0887, 41.42}, Tz::Europe_Rome, CountryId{"IT"}}, // Q27961303
    {Coordinate{1.07667, 44.1019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moissac
    {Coordinate{2.50667, 48.6989}, Tz::Europe_Paris, CountryId{"FR"}}, // Brunoy railway station
    {Coordinate{6.14278, 52.1578}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Voorst-Empe railway station
    {Coordinate{3.85243, 50.5942}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brugelette railway station
    {Coordinate{0.365725, 48.0286}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Mars-la-Brière Station
    {Coordinate{6.9967, 51.0114}, Tz::Europe_Berlin, CountryId{"DE"}}, // Leverkusen Chempark
    {Coordinate{6.19955, 47.2926}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2797747
    {Coordinate{4.18265, 45.5291}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2797918
    {Coordinate{7.75267, 48.5636}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Krimmeri-Meinau
    {Coordinate{2.52611, 48.8444}, Tz::Europe_Paris, CountryId{"FR"}}, // Bry-sur-Marne
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27996573
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q27996598
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mannheim-Neckarau station
    {Coordinate{5.99667, 51.5922}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vierlingsbeek railway station
    {Coordinate{-1.09089, 46.0784}, Tz::Europe_Paris, CountryId{"FR"}}, // Châtelaillon
    {Coordinate{6.07314, 49.3307}, Tz::Europe_Paris, CountryId{"FR"}}, // Hayange railway station
    {Coordinate{7.37799, 51.3366}, Tz::Europe_Berlin, CountryId{"DE"}}, // Gevelsberg-Knapp station
    {Coordinate{3.23074, 50.5061}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nomain - Ouvignies
    {Coordinate{7.50752, 48.7459}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2800820
    {Coordinate{4.47667, 51.1339}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kontich railway station
    {Coordinate{6.60508, 49.0457}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2801459
    {Coordinate{5.84684, 45.8034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2801473
    {Coordinate{3.21867, 43.3361}, Tz::Europe_Paris, CountryId{"FR"}}, // Béziers railway station
    {Coordinate{9.87972, 48.2289}, Tz::Europe_Berlin, CountryId{"DE"}}, // Laupheim West station
    {Coordinate{9.39239, 48.8795}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28025261
    {Coordinate{-1.76435, 43.37}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Deux-Jumeaux
    {Coordinate{2.31622, 43.1555}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Couffoulens-Leuc
    {Coordinate{2.47889, 48.8939}, Tz::Europe_Paris, CountryId{"FR"}}, // Bondy (Paris RER)
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28027752
    {Coordinate{8.77277, 47.8563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Engen station
    {Coordinate{6.04128, 51.4271}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Horst-Sevenum railway station
    {Coordinate{6.6259, 51.2691}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meerbusch-Osterath station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Meissen Triebischtal station
    {Coordinate{1.31412, 43.6164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2804370
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stollberg (Sachs) railway station
    {Coordinate{2.43556, 48.6481}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grand Bourg
    {Coordinate{6.31778, 52.1069}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Vorden railway station
    {Coordinate{9.98639, 53.5492}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stadthausbrücke station
    {Coordinate{12.1, 54.0779}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rostock Thierfelder Straße railway station
    {Coordinate{12.0463, 54.077}, Tz::Europe_Berlin, CountryId{"DE"}}, // Groß Schwaß railway station
    {Coordinate{11.9787, 54.0813}, Tz::Europe_Berlin, CountryId{"DE"}}, // Parkentin railway station
    {Coordinate{11.922, 54.0905}, Tz::Europe_Berlin, CountryId{"DE"}}, // Althof railway station
    {Coordinate{11.905, 54.1}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Doberan railway station
    {Coordinate{11.8496, 54.0853}, Tz::Europe_Berlin, CountryId{"DE"}}, // Reddelich railway station
    {Coordinate{11.9021, 54.1047}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Doberan Stadtmitte railway station
    {Coordinate{11.7274, 54.1467}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kühlungsborn West railway station
    {Coordinate{11.8999, 54.1083}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bad Doberan Goethestraße railway station
    {Coordinate{11.8429, 54.1417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Heiligendamm railway station
    {Coordinate{11.7939, 54.1448}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steilküste/Wittenbeck railway station
    {Coordinate{11.7598, 54.1478}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kühlungsborn Ost railway station
    {Coordinate{11.7534, 54.1416}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kühlungsborn Mitte railway station
    {Coordinate{11.7918, 54.069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kröpelin railway station
    {Coordinate{11.7407, 54.0527}, Tz::Europe_Berlin, CountryId{"DE"}}, // Sandhagen (b. Bad Doberan) railway station
    {Coordinate{11.6779, 54.0309}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neubukow railway station
    {Coordinate{11.6378, 53.9943}, Tz::Europe_Berlin, CountryId{"DE"}}, // Teschow railway station
    {Coordinate{11.6149, 53.9596}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hagebök railway station
    {Coordinate{11.5963, 53.9422}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinhausen-Neuburg railway station
    {Coordinate{11.5784, 53.9257}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kalsow railway station
    {Coordinate{11.5353, 53.9068}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hornstorf railway station
    {Coordinate{-2.20083, 47.2904}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Penhoët
    {Coordinate{5.44389, 47.8094}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Culmont-Chalindrey
    {Coordinate{7.05855, 47.2771}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pré-Petitjean train station
    {Coordinate{2.82239, 44.3749}, Tz::Europe_Paris, CountryId{"FR"}}, // Q28066138
    {Coordinate{14.0873, 51.0371}, Tz::Europe_Berlin, CountryId{"DE"}}, // Stolpen railway station
    {Coordinate{3.3144, 50.8564}, Tz::Europe_Brussels, CountryId{"BE"}}, // Harelbeke railway station
    {Coordinate{7.84917, 48.1214}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28119419
    {Coordinate{11.8105, 51.9207}, Tz::Europe_Berlin, CountryId{"DE"}}, // Calbe (Saale) Ost station
    {Coordinate{9.00126, 49.6844}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28131570
    {Coordinate{13.8247, 52.4067}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fangschleuse railway station
    {Coordinate{12.8864, 52.6125}, Tz::Europe_Berlin, CountryId{"DE"}}, // Nauen railway station
    {Coordinate{11.1446, 44.7652}, Tz::Europe_Rome, CountryId{"IT"}}, // Q28217247
    {Coordinate{0.036153, 49.3315}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Blonville-sur-Mer-Benerville
    {Coordinate{3.35699, 49.4037}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2831424
    {Coordinate{3.04266, 48.8138}, Tz::Europe_Paris, CountryId{"FR"}}, // Mouroux station
    {Coordinate{6.51794, 50.84}, Tz::Europe_Berlin, CountryId{"DE"}}, // Merzenich station
    {Coordinate{9.17631, 39.3458}, Tz::Europe_Rome, CountryId{"IT"}}, // Soleminis railway station
    {Coordinate{20.9422, 52.2056}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2832591
    {Coordinate{2.32278, 49.0661}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montsoult - Maffliers
    {Coordinate{3.3966, 50.613}, Tz::Europe_Brussels, CountryId{"BE"}}, // Tournai railway station
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // 11 km
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // 15 km
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // 331 km
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Awraamawskaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Adrowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Alyeksandryya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Alyaksandrawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Alyonushka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Antonawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Antopal′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28379973
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Babina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Barkalabava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Barsuki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Batali
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Batcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byazvyerkhavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byelahruda
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byel′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byenislawskaha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byerazhok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byerazina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byerazinskaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byarozavy Hay
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byarezawtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bibkawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Birulichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Blahavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Blazhewshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bluzha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Babry
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bakuny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bal′nitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Baravaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Barowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Barok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Babrechcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Brytsalavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bradzishcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Budatsyen′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Busly
    {Coordinate{26.7833, 51.8036}, Tz::Europe_Minsk, CountryId{"BY"}}, // Buchlichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bushawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Val′ki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vanyelyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vas′kawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyedrych
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyandzyezh
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyerasy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyarba
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyaren′ki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyeratsyei
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyeravoysha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyarkhi
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyesyalowski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyetryna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vayhany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Voytkavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Valowniki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Valodz′ki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Valoki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Valatava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Uskhod
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vidershchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vydreya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vylazy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vysokaye-Horad
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyatny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hay
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hyeolah
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hlyebava Rudnya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hlyadki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hadutsishki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Haloshawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Halynka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Homanawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hanchary
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Harozha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrabawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrabyanyova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrynki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrushawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrada
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Huta
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Danilaw Most
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Danilawtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Darlivaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dary
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dachnaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dachnaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dachny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dvarets
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyahtsyany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyednava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyedawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dembava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Depo
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Depowski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyetkavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzikalawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzitva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzitryki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dobryna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dawhyerdzishki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Damanawski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Damachava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Damashany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dranukha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Drychyn
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dubna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dubnavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dubok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyatlava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yaromina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yermalowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yotkishki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhalyeznitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chyhunachny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhaludok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhamchuzhyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zharabkovichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhastsyanka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhafarava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhylichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhodzina-Pawdnyovaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhuravinka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhurki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zahorbashsha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zahorye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zahraddzye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zadrutstsye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zazyerka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zakazanka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zalyeskaya Slabada
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zalichynka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zamoshsha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380159
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zakhodnyaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zapollye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380166
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zashchobye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zbunin
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380171
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zorny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zyalyony Vostraw
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zyenit
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Znamyenka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zory
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zubki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zubry
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zyaby
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ivaki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Iwnaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Idolta
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Izbyn′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ilava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Isa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Istobki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kazimirava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kalininski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kalinkavichy-Uskhodniya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kalybawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kamayka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kamyennaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kamyen′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Karavyshan′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kastrychnik
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kachanova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kvyetka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kireyeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kiryanawtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kisyalyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Klyednyavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Klishavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Klachki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Knyazikowtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kabyolka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kavali
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kodzyen′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kazlovichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kamarowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kamarova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kanstantsinaw Dvor
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kapan′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Koptsi
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Karobchytsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kastsyani
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kosh
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krayeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krasnaya Buda
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krasnaya Horka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krasnawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krasnaruchcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krasny Byerazhok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kryvichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krynichyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kruhlitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kulyani
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kul′shychy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kurhan
    {Coordinate{28.8581, 54.8811}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lazoviki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lastayantsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyenindar
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyaplyowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyesniki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyottsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lipinki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lipniki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lipava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Listapady
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Litva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Labachy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lohviny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lozki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lamachyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lukyanawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyuban′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyubashava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyudzyanyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyuta
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyakhawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mayski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Makanavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Malyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Malinniki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Malyatsichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Martsyukhova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mashkova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mil′kawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myel′kambinat
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myel′niki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myanyutsyeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myetalurh
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myetalurh
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myekhavoye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikyelyewshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikulichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Miloye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mil′cha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mits′ki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikhyeyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikhnava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mokraye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mowchadz′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Montawty
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Morach
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Matykaly Vyalikiya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Moshny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mashok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mstsibava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Muravanka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nartsyzava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nyemanitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nyestsyeravichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Niwki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nivy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikol′sk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mikol′ski Pyerayezd
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Novaya Dubrova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Novaye Zhytstsyo
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Novaya Niva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Navahorki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Navadrutsk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Navalipawski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Navasyolki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Novyya Luki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nasovichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380342
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Azyemlya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Aktsyabrski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Al′khowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380349
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Amyal′nya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Arlovichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Orsichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vosaw
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vosava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Atochka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Parshyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pasyeka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pyeramozhnik
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pyerasyel′tsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pyetsyuny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pyachynski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pihanovichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Plyosy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Plyetsyanichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pludzim
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pawstyn′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Paharelaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Padlyessye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Padstantsyya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pazhezhyn
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Paznyakova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Palyevachy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Palyeski Park
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Polava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Palykavitskiya Khutary
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Panizow
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Parachany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Porplishcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Patapawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Prybarava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Prybuzhzha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Adamova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Andreyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Baravukha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Baranavichy-Pawnochnyya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bastuny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byalynkavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Byarozki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bobr
    {Coordinate{29.1956, 53.1378}, Tz::Europe_Minsk, CountryId{"BY"}}, // Babruysk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bahdanaw
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bahushewskaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Borkavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Baravoye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Barawtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Brest-Palyeski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Brest-Pawnochny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Brozha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bruzhi
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Budslaw
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Buynichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bumazhkova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Burbin
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Bykhaw
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyendryzh
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyeramyeyki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyerkhnyadzvinsk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380449
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vilyeyka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Virski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vits′ba
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Valozhyn
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380469
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Varapayeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Vyhada
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hawya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hatava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hibulichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hlybokaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Homyel′-Pawnochny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Haradzishcha
    {Coordinate{26.7835, 52.8521}, Tz::Europe_Minsk, CountryId{"BY"}}, // Haryn′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Harany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hrybachy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hryshany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Hutna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Darahanava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dzyerawtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dretun′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Druts′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Dubitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yalizava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhlobin-Zakhodni
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhlobin-Padol′ski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhlobin-Pawnochny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhlobin-Sartyraval′ny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zhurzhava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zabalotsinka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zavadzichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zahatstsye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zakrutsin
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zaluchcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zaslonava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zyabki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Zyabrawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kalyedzino
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kaliy I
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Klyetsk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Knyahinin
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Knyazhytsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chyrvony Stsyah
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krasny Brod
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krulyawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krupki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Krynki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ksty
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lazurnaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyemnitsa
    {Coordinate{25.2957, 53.8811}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lida
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380577
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lisichki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lowsha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Losvida
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lasosna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Luzhasna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lukskaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Luchosa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Lyshchytsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Minoyty
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pryharadny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pryluki
    {Coordinate{27.5328, 53.8792}, Tz::Europe_Minsk, CountryId{"BY"}}, // Minsk-Sartyraval′ny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380607
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pralyetarskaya Pabyeda
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Myory
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Prudowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Miradzina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pushcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pyachkavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mitskyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rawnapollye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Radzyeyeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Raduha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Razvadava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Razlohi
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Raklyowtsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mordzichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Randowski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rekta
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Remyestava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Matykaly
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rytm
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Mulyarawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ramanavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ramanowshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nyekrashy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ramatova
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rudawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nyemyayshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rudzyeya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Nyasyata
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Navadvortsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Savyelyenki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Savichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Navasady
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Obal′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sadovy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sady
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Saki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Orsha-Zakhodnyaya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Samulki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Asinawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Saryanka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Svislach
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syewruki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Asavyets
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syedcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syakyerawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Parafyanava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syel′naye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syelyakhi
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syemashki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syemukovichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pahodzina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syennyenski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Padsvillye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syeradnyaki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Palonka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syechki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sidarawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sinyuha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pastavy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Skoki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Slabada
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Prypyats′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Slabodski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pryyamina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sluch
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Snitava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sabalyowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Savyetski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sonyechny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ratmiravichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Salanoye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rabusa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Resta
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Staraya Vyes′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Staraya Rudnya
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Staryna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380733
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Stayalava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Stradzyech
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Raslyaki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Strazhy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Rumina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Budawnik
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Susha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tachanka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Savichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tekstyl′shchyk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Saltanawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tekhnikum
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsimirazyeva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Svol′na
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsikhinichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsishowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Syenazavod
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Takary
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tratsylava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Trud
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tuholitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Slawnaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Turya
    {Coordinate{29.0681, 51.6317}, Tz::Europe_Minsk, CountryId{"BY"}}, // Slavyechna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tyshkyevichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ubalats′
    {Coordinate{27.5229, 53.0143}, Tz::Europe_Minsk, CountryId{"BY"}}, // Slutsk
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Uborak
    {Coordinate{30.1558, 54.6281}, Tz::Europe_Minsk, CountryId{"BY"}}, // Smal′yany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Uzhlyatsina
    {Coordinate{27.5494, 52.7944}, Tz::Europe_Minsk, CountryId{"BY"}}, // Solihorsk railway station
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sosnitsa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Uzdorniki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Staroye Syalo
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Ul′yanawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Starasyel′ski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Starushki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Fabrychny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Fyedzyuki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Stsyapyanka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khalyechyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tatarka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kharsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380797
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khvaynyany
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khonava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsimkavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khorabrava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Talachyn
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Kharashki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsvyermy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsel′
    {Coordinate{30.8183, 52.5969}, Tz::Europe_Minsk, CountryId{"BY"}}, // Uza
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Charavachytsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Urechcha
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Charatok
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Uts′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chornaya Natopa
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Falichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Charnitsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Farynava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chornaye
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khal′ch
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khlusava
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chornyya Brady
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khlyustsina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chyzhowka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Khodasy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shalavichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sharabai
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sharybawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Tsentralit
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shakhi
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chavusy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shakhtsyorski
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28380841
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shybyeki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chepina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shypulichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Chervina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shypy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shchezhar
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shchepichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Sharkawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shcherbawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shchytniki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yubilyeyny
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Pawdnyovy Zakhad
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yurkawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Shumilina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yuravichy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yuratsishki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yazvina
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yareva
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yakimawka
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yasyen′
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yakhimawshchyna
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yashchytsy
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Yatsuki
    {Coordinate{}, Tz::Europe_Minsk, CountryId{"BY"}}, // Q28381011
    {Coordinate{2.50652, 48.8973}, Tz::Europe_Paris, CountryId{"FR"}}, // Allée de la Tour - Rendez-Vous railway station
    {Coordinate{-0.177779, 45.6711}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2839048
    {Coordinate{4.6513, 50.7784}, Tz::Europe_Brussels, CountryId{"BE"}}, // Pécrot railway station
    {Coordinate{49.1747, 55.8064}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q28415
    {Coordinate{5.85204, 47.1185}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2841574
    {Coordinate{49.1678, 55.7778}, Tz::Europe_Moscow, CountryId{"RU"}}, // Ometevo
    {Coordinate{6.0855, 44.564}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gap
    {Coordinate{2.04774, 47.4252}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Salbris
    {Coordinate{4.46722, 51.3789}, Tz::Europe_Brussels, CountryId{"BE"}}, // Kijkuit railway station
    {Coordinate{1.77111, 50.8161}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Haut-Banc
    {Coordinate{4.51528, 50.7256}, Tz::Europe_Brussels, CountryId{"BE"}}, // Genval railway station
    {Coordinate{4.44694, 51.1822}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mortsel-Deurnesteenweg railway station
    {Coordinate{4.74611, 51.1656}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bouwel railway station
    {Coordinate{37.3075, 47.9892}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28469460
    {Coordinate{9.1199, 39.428}, Tz::Europe_Rome, CountryId{"IT"}}, // Donori railway station
    {Coordinate{-1.89738, 48.1405}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2847254
    {Coordinate{8.02217, 49.039}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28475391
    {Coordinate{5.76944, 49.5131}, Tz::Europe_Paris, CountryId{"FR"}}, // Longwy railway station
    {Coordinate{2.24095, 48.8149}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Meudon
    {Coordinate{7.3024, 47.913}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Merxheim
    {Coordinate{6.63002, 51.3377}, Tz::Europe_Berlin, CountryId{"DE"}}, // Krefeld-Linn station
    {Coordinate{11.0376, 48.1059}, Tz::Europe_Berlin, CountryId{"DE"}}, // Geltendorf station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28491312
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28491321
    {Coordinate{116.421, 39.9022}, Tz::Asia_Shanghai, CountryId{"CN"}}, // Beijing railway station
    {Coordinate{22.055, 50.5703}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2853323
    {Coordinate{7.3118, 48.5247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2853441
    {Coordinate{40.6014, 61.025}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q28548181
    {Coordinate{40.5836, 64.1531}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q28548199
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548206
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548209
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548212
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548524
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548602
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548607
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548612
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548637
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28548660
    {Coordinate{35.4289, 47.9422}, Tz::Europe_Zaporozhye, CountryId{"UA"}}, // Q28548757
    {Coordinate{2.61806, 48.8061}, Tz::Europe_Paris, CountryId{"FR"}}, // Émerainville – Pontault-Combault (Paris RER)
    {Coordinate{8.68611, 50.0994}, Tz::Europe_Berlin, CountryId{"DE"}}, // Frankfurt South station
    {Coordinate{3.96967, 51.0019}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wichelen railway station
    {Coordinate{2.37625, 48.8296}, Tz::Europe_Paris, CountryId{"FR"}}, // Bibliothèque François Mitterrand Station
    {Coordinate{8.79833, 47.98}, Tz::Europe_Berlin, CountryId{"DE"}}, // Tuttlingen station
    {Coordinate{5.37917, 49.92}, Tz::Europe_Brussels, CountryId{"BE"}}, // Libramont railway station
    {Coordinate{3.19142, 51.3059}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zwankendamme railway station
    {Coordinate{-0.94606, 44.3293}, Tz::Europe_Paris, CountryId{"FR"}}, // Ychoux
    {Coordinate{7.9281, 49.2171}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28595256
    {Coordinate{6.42494, 46.3033}, Tz::Europe_Paris, CountryId{"FR"}}, // Perrignier
    {Coordinate{6.16401, 49.2536}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2859801
    {Coordinate{7.8837, 49.2094}, Tz::Europe_Berlin, CountryId{"DE"}}, // Railway station Wilgartswiesen
    {Coordinate{3.90633, 50.4875}, Tz::Europe_Brussels, CountryId{"BE"}}, // Ghlin railway station
    {Coordinate{1.20528, 45.5192}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Yrieix-la-Perche
    {Coordinate{11.7846, 51.763}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Baalberge
    {Coordinate{11.7686, 51.7736}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bernburg-Friedenshall station
    {Coordinate{7.86694, 48.0422}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28656485
    {Coordinate{9.13213, 39.5589}, Tz::Europe_Rome, CountryId{"IT"}}, // Suelli railway station
    {Coordinate{-0.391566, 44.9141}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Sulpice - Izon
    {Coordinate{10.0251, 47.554}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28661170
    {Coordinate{5.97142, 49.2162}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2866372
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667351
    {Coordinate{44.0196, 56.199}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q28667363
    {Coordinate{40.2475, 61.9328}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q28667397
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667399
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667400
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667403
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667404
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667407
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667455
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667471
    {Coordinate{35.4852, 54.9474}, Tz::Europe_Moscow, CountryId{"RU"}}, // Koshnyaki
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667498
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667505
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667507
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667521
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Krasnoufimsk rail station
    {Coordinate{38.851, 56.4542}, Tz::Europe_Moscow, CountryId{}}, // Q28667595
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667596
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667640
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667675
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667690
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667698
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667699
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667740
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667753
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667755
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667766
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667784
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667802
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28667848
    {Coordinate{11.8647, 43.5268}, Tz::Europe_Rome, CountryId{"IT"}}, // Giovi railway station
    {Coordinate{15.6482, 38.121}, Tz::Europe_Rome, CountryId{"IT"}}, // Q28668108
    {Coordinate{15.5248, 38.1905}, Tz::Europe_Rome, CountryId{"IT"}}, // Q28668411
    {Coordinate{14.313, 41.2711}, Tz::Europe_Rome, CountryId{"IT"}}, // Q28671079
    {Coordinate{3.84344, 50.1973}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aulnoye-Aymeries
    {Coordinate{16.6191, 47.6416}, Tz::Europe_Budapest, CountryId{"HU"}}, // Harka train station
    {Coordinate{4.23572, 47.283}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2868757
    {Coordinate{2.18333, 48.7994}, Tz::Europe_Paris, CountryId{"FR"}}, // Chaville-Vélizy
    {Coordinate{25.9193, 48.3163}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28703958
    {Coordinate{25.4875, 48.6636}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28704074
    {Coordinate{25.9581, 48.265}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28704076
    {Coordinate{30.7422, 50.0703}, Tz::Europe_Kiev, CountryId{"UA"}}, // Hordyn
    {Coordinate{38.0633, 47.6678}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28704397
    {Coordinate{30.7071, 46.4536}, Tz::Europe_Kiev, CountryId{"UA"}}, // Odesa-Pojizna
    {Coordinate{36.3974, 49.9462}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28704758
    {Coordinate{37.1755, 49.6944}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28704776
    {Coordinate{31.1547, 51.9953}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28704950
    {Coordinate{30.8395, 51.5071}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705210
    {Coordinate{24.5237, 50.1949}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705359
    {Coordinate{32.2828, 49.9306}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705406
    {Coordinate{31.1603, 51.6861}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705564
    {Coordinate{31.1831, 51.6494}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705571
    {Coordinate{35.1342, 48.4808}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705830
    {Coordinate{35.7128, 48.5636}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28705847
    {Coordinate{33.2866, 49.3267}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706380
    {Coordinate{34.8604, 47.8041}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706409
    {Coordinate{34.79, 47.7842}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706411
    {Coordinate{}, Timezone{}, CountryId{"UA"}}, // Q28706432
    {Coordinate{35.1792, 48.4806}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706434
    {Coordinate{35.3914, 48.3542}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706436
    {Coordinate{35.4344, 48.3455}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706438
    {Coordinate{35.3213, 48.3706}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706439
    {Coordinate{35.2404, 48.4292}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706442
    {Coordinate{23.8781, 49.8342}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zymna Voda
    {Coordinate{35.0864, 48.4838}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706450
    {Coordinate{35.051, 48.5047}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706452
    {Coordinate{35.0442, 48.42}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706453
    {Coordinate{34.9628, 48.4393}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706457
    {Coordinate{32.9142, 47.1286}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706458
    {Coordinate{34.9036, 48.4433}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706461
    {Coordinate{35.201, 48.4576}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706467
    {Coordinate{25.5467, 48.6231}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706468
    {Coordinate{25.6136, 48.6325}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706469
    {Coordinate{25.125, 48.5503}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706470
    {Coordinate{25.1993, 48.5551}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706471
    {Coordinate{25.793, 48.4072}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706475
    {Coordinate{25.2956, 48.6419}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706478
    {Coordinate{25.7699, 48.4765}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706479
    {Coordinate{25.295, 48.6108}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706480
    {Coordinate{25.3539, 48.6608}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706483
    {Coordinate{38.5853, 47.7447}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706610
    {Coordinate{31.1631, 49.001}, Tz::Europe_Kiev, CountryId{"UA"}}, // Stetsivka
    {Coordinate{31.3667, 48.9944}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706705
    {Coordinate{}, Timezone{}, CountryId{"UA"}}, // Q28706706
    {Coordinate{38.4797, 47.8008}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706730
    {Coordinate{29.8295, 48.8989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706737
    {Coordinate{37.4407, 49.9428}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706792
    {Coordinate{37.4119, 49.8475}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706793
    {Coordinate{37.5231, 49.8265}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706812
    {Coordinate{37.4458, 49.6782}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706815
    {Coordinate{36.7425, 49.7711}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706822
    {Coordinate{36.42, 49.9286}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706845
    {Coordinate{36.5644, 49.8278}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706854
    {Coordinate{31.8261, 51.2622}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706863
    {Coordinate{37.6442, 49.6543}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706883
    {Coordinate{31.8782, 49.2207}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sriblyanka
    {Coordinate{31.8767, 49.2302}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tsentralna
    {Coordinate{31.3556, 51.4228}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706891
    {Coordinate{36.6727, 49.8196}, Tz::Europe_Kiev, CountryId{"UA"}}, // Chuhuiv
    {Coordinate{31.1569, 51.9475}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28706970
    {Coordinate{31.1403, 51.8842}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707187
    {Coordinate{31.1161, 51.8136}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707283
    {Coordinate{23.635, 49.8381}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707306
    {Coordinate{24.2329, 49.9607}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707399
    {Coordinate{24.3321, 50.0476}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707400
    {Coordinate{24.3571, 50.0989}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707402
    {Coordinate{24.5662, 50.2311}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707406
    {Coordinate{24.7453, 50.4095}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707409
    {Coordinate{24.8949, 50.4613}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707413
    {Coordinate{24.3327, 50.11}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707426
    {Coordinate{24.2927, 50.5513}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707430
    {Coordinate{24.3636, 50.5881}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707431
    {Coordinate{24.3199, 50.2554}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707434
    {Coordinate{23.4119, 49.7964}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707456
    {Coordinate{23.2656, 49.8158}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707477
    {Coordinate{23.2036, 49.8261}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707483
    {Coordinate{23.0867, 49.8069}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707503
    {Coordinate{23.7067, 49.8342}, Tz::Europe_Kiev, CountryId{"UA"}}, // Tsuniv
    {Coordinate{23.8434, 49.8357}, Tz::Europe_Kiev, CountryId{"UA"}}, // Sukhovolia
    {Coordinate{34.9279, 50.5253}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707712
    {Coordinate{34.9811, 50.4517}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707714
    {Coordinate{35.1626, 49.8253}, Tz::Europe_Kiev, CountryId{"UA"}}, // Iskrivka
    {Coordinate{34.3783, 48.0833}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707750
    {Coordinate{34.1714, 47.9728}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707757
    {Coordinate{34.0331, 47.8717}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707769
    {Coordinate{33.9797, 47.8381}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707770
    {Coordinate{33.8608, 47.7825}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707772
    {Coordinate{33.7656, 47.7353}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707773
    {Coordinate{33.9478, 47.835}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707776
    {Coordinate{35.1425, 48.4947}, Tz::Europe_Kiev, CountryId{"UA"}}, // 195 km
    {Coordinate{35.2619, 48.6514}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707809
    {Coordinate{35.2794, 48.6492}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707810
    {Coordinate{36.0986, 48.4161}, Tz::Europe_Kiev, CountryId{"UA"}}, // 90 km
    {Coordinate{36.2103, 48.3758}, Tz::Europe_Kiev, CountryId{"UA"}}, // 80 km
    {Coordinate{36.2811, 48.365}, Tz::Europe_Kiev, CountryId{"UA"}}, // 73 km
    {Coordinate{36.0825, 48.7492}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707824
    {Coordinate{35.88, 48.5981}, Tz::Europe_Kiev, CountryId{"UA"}}, // 988 km
    {Coordinate{36.0133, 48.7297}, Tz::Europe_Kiev, CountryId{"UA"}}, // 969 km
    {Coordinate{35.9461, 48.6712}, Tz::Europe_Kiev, CountryId{"UA"}}, // 978 km
    {Coordinate{36.2947, 48.0867}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707851
    {Coordinate{36.2947, 48.0867}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707852
    {Coordinate{31.1586, 51.4947}, Tz::Europe_Kiev, CountryId{"UA"}}, // Bilous
    {Coordinate{31.0611, 51.5011}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q28707989
    {Coordinate{0.041691, 46.4188}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2871831
    {Coordinate{-0.050105, 45.5999}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2872674
    {Coordinate{12.0417, 45.2949}, Tz::Europe_Rome, CountryId{"IT"}}, // Piove di Sacco railway station
    {Coordinate{8.85799, 50.1205}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mühlheim-Dietesheim station
    {Coordinate{9.15202, 39.6934}, Tz::Europe_Rome, CountryId{"IT"}}, // Serri railway station
    {Coordinate{2.38444, 48.9239}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Courneuve – Aubervilliers
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28754089
    {Coordinate{2.83807, 50.5419}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Salomé
    {Coordinate{5.33838, 46.0116}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2876103
    {Coordinate{10.6804, 44.771}, Tz::Europe_Rome, CountryId{"IT"}}, // Bagnolo Soave railway halt
    {Coordinate{-4.25626, 48.4537}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Landerneau
    {Coordinate{9.24685, 39.6934}, Tz::Europe_Rome, CountryId{"IT"}}, // Orroli railway station
    {Coordinate{9.22956, 39.7212}, Tz::Europe_Rome, CountryId{"IT"}}, // Nurri railway station
    {Coordinate{9.26309, 39.7536}, Tz::Europe_Rome, CountryId{"IT"}}, // Betilli railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28806114
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28806129
    {Coordinate{7.60631, 51.5293}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Wickede West station
    {Coordinate{5.78444, 45.1847}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grenoble-Universités-Gières
    {Coordinate{9.25596, 39.7884}, Tz::Europe_Rome, CountryId{"IT"}}, // Esterzili railway station
    {Coordinate{5.5951, 48.0541}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2882529
    {Coordinate{10.038, 44.8498}, Tz::Europe_Rome, CountryId{"IT"}}, // Vaio-Ospedale railway station
    {Coordinate{20.1746, 47.9156}, Tz::Europe_Budapest, CountryId{"HU"}}, // Sirok railway station
    {Coordinate{9.26967, 39.8152}, Tz::Europe_Rome, CountryId{"IT"}}, // Sadali-Seulo railway station
    {Coordinate{9.32643, 39.8369}, Tz::Europe_Rome, CountryId{"IT"}}, // Seui railway station
    {Coordinate{9.44093, 39.8341}, Tz::Europe_Rome, CountryId{"IT"}}, // Ussassai railway station
    {Coordinate{3.2557, 48.5294}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sainte-Colombe-Septveilles
    {Coordinate{8.4835, 52.5547}, Tz::Europe_Berlin, CountryId{"DE"}}, // Syke railway station
    {Coordinate{7.35939, 46.2274}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sion railway station
    {Coordinate{5.81, 50.5447}, Tz::Europe_Brussels, CountryId{"BE"}}, // Juslenville railway station
    {Coordinate{3.8375, 50.8839}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hillegem railway station
    {Coordinate{7.43944, 46.9497}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern railway station
    {Coordinate{11.2032, 50.8563}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q28870827
    {Coordinate{9.47626, 39.9195}, Tz::Europe_Rome, CountryId{"IT"}}, // Villagrande railway station
    {Coordinate{37.1845, 48.2844}, Tz::Europe_Kiev, CountryId{"UA"}}, // Pokrovsk
    {Coordinate{4.61361, 50.9661}, Tz::Europe_Brussels, CountryId{"BE"}}, // Haacht railway station
    {Coordinate{9.50932, 39.902}, Tz::Europe_Rome, CountryId{"IT"}}, // Arzana railway station
    {Coordinate{2.15361, 48.7964}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Porchefontaine
    {Coordinate{2.30417, 48.7619}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Croix de Berny
    {Coordinate{16.2661, 39.288}, Tz::Europe_Rome, CountryId{"IT"}}, // Cosenza Casali railway station
    {Coordinate{16.3186, 39.1938}, Tz::Europe_Rome, CountryId{"IT"}}, // Santo Stefano railway halt
    {Coordinate{16.3221, 39.1809}, Tz::Europe_Rome, CountryId{"IT"}}, // Rogliano railway station
    {Coordinate{16.3044, 39.1682}, Tz::Europe_Rome, CountryId{"IT"}}, // Marzi railway station
    {Coordinate{14.8439, 40.8345}, Tz::Europe_Rome, CountryId{"IT"}}, // Q28942313
    {Coordinate{6.38778, 48.3072}, Tz::Europe_Paris, CountryId{"FR"}}, // Q289445
    {Coordinate{5.88036, 48.6792}, Tz::Europe_Paris, CountryId{"FR"}}, // Toul railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q28974621
    {Coordinate{1.04604, 46.1253}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2898331
    {Coordinate{0.215912, 49.582}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2902609
    {Coordinate{12.3673, 50.7257}, Tz::Europe_Berlin, CountryId{"DE"}}, // Werdau station
    {Coordinate{11.2814, 50.896}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29043546
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Röthenbach (Allgäu) railway station
    {Coordinate{6.38167, 45.6731}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albertville
    {Coordinate{1.93979, 48.1935}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toury
    {Coordinate{1.98298, 48.9817}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vernouillet - Verneuil
    {Coordinate{-1.74944, 47.9714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2910832
    {Coordinate{7.64368, 51.5417}, Tz::Europe_Berlin, CountryId{"DE"}}, // Massen station
    {Coordinate{8.7075, 47.2083}, Tz::Europe_Zurich, CountryId{"CH"}}, // Richterswil railway station
    {Coordinate{2.311, 42.5616}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2913010
    {Coordinate{24.2054, 57.102}, Tz::Europe_Riga, CountryId{"LV"}}, // Garciems Station
    {Coordinate{24.2882, 57.1415}, Tz::Europe_Riga, CountryId{"LV"}}, // Gauja Station
    {Coordinate{24.3373, 57.182}, Tz::Europe_Riga, CountryId{"LV"}}, // Lilaste Station
    {Coordinate{3.47876, 50.3902}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2913331
    {Coordinate{24.2451, 57.1142}, Tz::Europe_Riga, CountryId{"LV"}}, // Garupe Station
    {Coordinate{24.1525, 57.0866}, Tz::Europe_Riga, CountryId{"LV"}}, // Kalngale Station
    {Coordinate{6.7724, 45.9088}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2913384
    {Coordinate{-1.46613, 48.1122}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2913679
    {Coordinate{3.18835, 50.3613}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2913951
    {Coordinate{5.71333, 53.13}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Mantgum railway station
    {Coordinate{2.9058, 48.8596}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Crécy-la-Chapelle
    {Coordinate{4.22917, 51.0144}, Tz::Europe_Brussels, CountryId{"BE"}}, // Malderen railway station
    {Coordinate{5.90132, 45.2626}, Tz::Europe_Paris, CountryId{"FR"}}, // Brignoud
    {Coordinate{2.03219, 42.4569}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2919626
    {Coordinate{8.01307, 47.5073}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frick railway station
    {Coordinate{9.70748, 39.9386}, Tz::Europe_Rome, CountryId{"IT"}}, // Arbatax railway station
    {Coordinate{4.36361, 50.5358}, Tz::Europe_Brussels, CountryId{"BE"}}, // Obaix-Buzet railway station
    {Coordinate{5.49611, 50.9669}, Tz::Europe_Brussels, CountryId{"BE"}}, // Genk railway station
    {Coordinate{5.75008, 43.1404}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2931894
    {Coordinate{9.49638, 39.822}, Tz::Europe_Rome, CountryId{"IT"}}, // Osini-Ulassai railway station
    {Coordinate{5.57363, 50.5399}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hony railway station
    {Coordinate{1.40147, 43.5956}, Tz::Europe_Paris, CountryId{"FR"}}, // Station of TOEC
    {Coordinate{13.02, 58.0789}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Herrljunga railway station
    {Coordinate{13.335, 58.1392}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Floby railway station
    {Coordinate{13.0533, 57.9867}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Ljung railway station
    {Coordinate{16.7031, 41.0239}, Tz::Europe_Rome, CountryId{"IT"}}, // Q29366570
    {Coordinate{16.7108, 41.0514}, Tz::Europe_Rome, CountryId{"IT"}}, // Q29366594
    {Coordinate{4.77261, 45.5958}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2936724
    {Coordinate{7.90778, 47.3519}, Tz::Europe_Zurich, CountryId{"CH"}}, // Olten railway station
    {Coordinate{9.21998, 49.1887}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29370439
    {Coordinate{7.362, 48.7446}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saverne
    {Coordinate{10.9452, 43.6523}, Tz::Europe_Rome, CountryId{"IT"}}, // Granaiolo railway station
    {Coordinate{19.156, 63.3441}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Husum railway station
    {Coordinate{18.7153, 63.3027}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Örnsköldsvik north station
    {Coordinate{17.7447, 63.0526}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Västeraspby railway station
    {Coordinate{19.4851, 63.5786}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Nordmaling railway station
    {Coordinate{19.9101, 63.6329}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Hörnefors railway station
    {Coordinate{2.48583, 48.8703}, Tz::Europe_Paris, CountryId{"FR"}}, // Rosny-sous-Bois station
    {Coordinate{}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Nykroppa railway station
    {Coordinate{6.82417, 45.8987}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2942136
    {Coordinate{38.0833, 50.2032}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q2943934
    {Coordinate{5.52791, 46.1847}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nurieux
    {Coordinate{8.04257, 49.2093}, Tz::Europe_Berlin, CountryId{"DE"}}, // Siebeldingen-Birkweiler station
    {Coordinate{9.5027, 49.2032}, Tz::Europe_Berlin, CountryId{"DE"}}, // Öhringen Central Station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29478870
    {Coordinate{4.46889, 50.3928}, Tz::Europe_Brussels, CountryId{"BE"}}, // Couillet railway station
    {Coordinate{3.79111, 50.9706}, Tz::Europe_Brussels, CountryId{"BE"}}, // Landskouter railway station
    {Coordinate{7.30329, 51.4782}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bochum-Langendreer West station
    {Coordinate{1.46667, 44.9022}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Souillac
    {Coordinate{1.75583, 49.765}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aumale
    {Coordinate{2.34528, 48.935}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Denis
    {Coordinate{2.98152, 50.3274}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vitry-en-Artois
    {Coordinate{5.82561, 48.1087}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2952673
    {Coordinate{1.72222, 49.6539}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Formerie
    {Coordinate{11.2627, 58.9222}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Skee railway station
    {Coordinate{4.33528, 50.6006}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nivelles railway station
    {Coordinate{11.2958, 58.7134}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Tanum railway station
    {Coordinate{11.2598, 58.843}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Överby railway station
    {Coordinate{7.08496, 48.9359}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2955054
    {Coordinate{14.1279, 58.7056}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Töreboda railway station
    {Coordinate{14.3334, 58.872}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Gårdsjö railway station
    {Coordinate{14.2152, 58.8548}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Hova railway station
    {Coordinate{11.485, 43.3069}, Tz::Europe_Rome, CountryId{"IT"}}, // Castelnuovo Berardenga railway station
    {Coordinate{11.5636, 43.2317}, Tz::Europe_Rome, CountryId{"IT"}}, // Asciano-Monte Oliveto Maggiore railway halt
    {Coordinate{11.7877, 43.1742}, Tz::Europe_Rome, CountryId{"IT"}}, // Torrita di Siena railway station
    {Coordinate{13.6364, 52.7178}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rüdnitz
    {Coordinate{5.18556, 50.9642}, Tz::Europe_Brussels, CountryId{"BE"}}, // Schulen railway station
    {Coordinate{1.82611, 49.7364}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fouilloy
    {Coordinate{6.72088, 49.0858}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2958494
    {Coordinate{20.9911, 52.2258}, Tz::Europe_Warsaw, CountryId{"PL"}}, // Q2961989
    {Coordinate{4.18722, 50.9747}, Tz::Europe_Brussels, CountryId{"BE"}}, // Opwijk railway station
    {Coordinate{4.40111, 50.8678}, Tz::Europe_Brussels, CountryId{"BE"}}, // Evere railway station
    {Coordinate{0.848908, 48.3838}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2971091
    {Coordinate{9.08317, 47.3197}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lichtensteig station
    {Coordinate{6.89222, 51.0286}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Chorweiler Nord
    {Coordinate{7.64225, 48.7558}, Tz::Europe_Paris, CountryId{"FR"}}, // Mommenheim
    {Coordinate{5.14333, 52.0656}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Utrecht Lunetten railway station
    {Coordinate{7.61835, 51.363}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q29878878
    {Coordinate{10.503, 43.5518}, Tz::Europe_Rome, CountryId{"IT"}}, // Fauglia-Lorenzana railway station
    {Coordinate{13.8989, 37.623}, Tz::Europe_Rome, CountryId{"IT"}}, // Q29918875
    {Coordinate{13.964, 37.5473}, Tz::Europe_Rome, CountryId{"IT"}}, // Mimiani-San Cataldo railway station
    {Coordinate{13.9977, 37.4697}, Tz::Europe_Rome, CountryId{"IT"}}, // Q29919038
    {Coordinate{13.8851, 37.6685}, Tz::Europe_Rome, CountryId{"IT"}}, // Villalba railway station
    {Coordinate{13.8467, 37.6914}, Tz::Europe_Rome, CountryId{"IT"}}, // Vallelunga station
    {Coordinate{6.05944, 50.8761}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Chevremont railway station
    {Coordinate{1.76889, 50.4661}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montreuil-sur-Mer
    {Coordinate{31.0637, 54.9469}, Tz::Europe_Moscow, CountryId{"RU"}}, // Q29956810
    {Coordinate{2.27197, 42.5547}, Tz::Europe_Paris, CountryId{"FR"}}, // Q2999397
    {Coordinate{2.0619, 48.8413}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Noisy-le-Roi
    {Coordinate{11.7799, 51.6741}, Tz::Europe_Berlin, CountryId{"DE"}}, // Könnern station
    {Coordinate{7.15247, 50.8137}, Tz::Europe_Berlin, CountryId{"DE"}}, // Troisdorf station
    {Coordinate{6.37224, 49.4588}, Tz::Europe_Paris, CountryId{"FR"}}, // Apach
    {Coordinate{14.0141, 51.1882}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30046682
    {Coordinate{12.6486, 51.1439}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30047032
    {Coordinate{7.62817, 48.5469}, Tz::Europe_Paris, CountryId{"FR"}}, // Entzheim-Aéroport Station
    {Coordinate{14.5262, 51.0343}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30053133
    {Coordinate{13.5288, 50.7403}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30055362
    {Coordinate{12.2443, 50.6113}, Tz::Europe_Berlin, CountryId{"DE"}}, // Netzschkau railway station
    {Coordinate{12.3019, 50.548}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Treuen
    {Coordinate{12.8126, 50.9157}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Burgstädt
    {Coordinate{4.11806, 51.0217}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sint-Gillis railway station
    {Coordinate{6.09111, 50.7681}, Tz::Europe_Berlin, CountryId{"DE"}}, // Aachen Central Station
    {Coordinate{-3.11833, 47.4853}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Quiberon
    {Coordinate{7.35702, 46.9046}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q30088642
    {Coordinate{7.66231, 47.5315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schweizerhalle Station
    {Coordinate{2.31, 48.7703}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Parc de Sceaux
    {Coordinate{12.9774, 52.9055}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30106124
    {Coordinate{0.953728, 49.5492}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3014650
    {Coordinate{4.36972, 52.0906}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Mariahoeve
    {Coordinate{6.51917, 52.3117}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rijssen railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Bahnhof Waghäusel
    {Coordinate{4.35413, 50.7675}, Tz::Europe_Brussels, CountryId{"BE"}}, // Holleken railway station
    {Coordinate{1.11065, 49.7916}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3022757
    {Coordinate{8.25505, 50.2968}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30238830
    {Coordinate{7.20163, 47.2198}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tavannes Station
    {Coordinate{7.22741, 47.2352}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reconvilier Station
    {Coordinate{7.27593, 47.2387}, Tz::Europe_Zurich, CountryId{"CH"}}, // Malleray-Bévilard Station
    {Coordinate{8.90796, 49.236}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30248297
    {Coordinate{7.52833, 51.5719}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dortmund-Derne station
    {Coordinate{15.8617, 41.5836}, Tz::Europe_Rome, CountryId{"IT"}}, // Frattarolo railway halt
    {Coordinate{15.7326, 41.518}, Tz::Europe_Rome, CountryId{"IT"}}, // Amendola railway halt
    {Coordinate{11.7588, 51.9057}, Tz::Europe_Berlin, CountryId{"DE"}}, // Calbe (Saale) West station
    {Coordinate{13.3124, 52.4797}, Tz::Europe_Berlin, CountryId{"DE"}}, // Berlin Heidelberger Platz station
    {Coordinate{8.34493, 48.2912}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30303373
    {Coordinate{20.1077, 47.9317}, Tz::Europe_Budapest, CountryId{"HU"}}, // Recsk-Parádfürdő railway station
    {Coordinate{20.078, 47.9464}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátraderecske railway station
    {Coordinate{20.0241, 47.9846}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátraballa railway station
    {Coordinate{19.9388, 47.9973}, Tz::Europe_Budapest, CountryId{"HU"}}, // Mátramindszent railway station
    {Coordinate{19.902, 48.0038}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nemti railway station
    {Coordinate{20.1827, 47.9009}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőkútpuszta railway station
    {Coordinate{20.1972, 47.8793}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tarnaszentmária railway station
    {Coordinate{20.2119, 47.8554}, Tz::Europe_Budapest, CountryId{"HU"}}, // Verpelét railway station
    {Coordinate{20.2188, 47.8113}, Tz::Europe_Budapest, CountryId{"HU"}}, // Feldebrő railway station
    {Coordinate{20.2243, 47.7843}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aldebrő railway station
    {Coordinate{20.235, 47.7608}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kápolna railway station
    {Coordinate{6.28176, 43.3172}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3031449
    {Coordinate{3.02306, 42.5464}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Argelès-sur-Mer
    {Coordinate{1.47987, 45.6099}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-les-Belles
    {Coordinate{4.37955, 50.8299}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mouterij railway station
    {Coordinate{}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q30340466
    {Coordinate{2.26067, 48.9314}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Stade
    {Coordinate{-0.129777, 46.3809}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3036487
    {Coordinate{8.78519, 50.008}, Tz::Europe_Berlin, CountryId{"DE"}}, // Dietzenbach station
    {Coordinate{2.86827, 48.7345}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3040113
    {Coordinate{1.87929, 48.0266}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chevilly
    {Coordinate{-2.07264, 47.3089}, Tz::Europe_Paris, CountryId{"FR"}}, // Donges
    {Coordinate{1.53822, 45.5742}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Porcherie
    {Coordinate{7.79691, 48.7178}, Tz::Europe_Paris, CountryId{"FR"}}, // Q305421
    {Coordinate{1.44394, 45.6288}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Magnac-Vicq
    {Coordinate{4.06273, 46.0395}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Roanne
    {Coordinate{5.20528, 52.13}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Bilthoven railway station
    {Coordinate{5.09222, 51.8944}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Leerdam railway station
    {Coordinate{12.6944, 56.0444}, Tz::Europe_Stockholm, CountryId{"SE"}}, // Helsingborg Central Station
    {Coordinate{5.9975, 44.0615}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3063125
    {Coordinate{5.93597, 49.2057}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3063522
    {Coordinate{1.2825, 43.4039}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Fauga
    {Coordinate{2.26278, 48.8294}, Tz::Europe_Paris, CountryId{"FR"}}, // Issy – Val de Seine
    {Coordinate{7.15111, 46.8028}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fribourg railway station
    {Coordinate{21.0486, 47.9099}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tiszapalkonya-Erőmű railway station
    {Coordinate{4.7688, 50.5208}, Tz::Europe_Brussels, CountryId{"BE"}}, // Saint-Denis-Bovesse railway station
    {Coordinate{8.2825, 50.0069}, Tz::Europe_Berlin, CountryId{"DE"}}, // Mainz-Kastel station
    {Coordinate{3.87914, 51.087}, Tz::Europe_Brussels, CountryId{"BE"}}, // Beervelde railway station
    {Coordinate{4.71987, 45.9394}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3078253
    {Coordinate{6.10139, 50.8856}, Tz::Europe_Berlin, CountryId{"DE"}}, // Herzogenrath-Alt-Merkstein station
    {Coordinate{4.72111, 51.6058}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Breda-Prinsenbeek railway station
    {Coordinate{-1.06703, 45.5663}, Tz::Europe_Paris, CountryId{"FR"}}, // La Pointe-de-Grave
    {Coordinate{1.09389, 49.4489}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rouen-Rive-Droite
    {Coordinate{5.32, 50.5461}, Tz::Europe_Brussels, CountryId{"BE"}}, // Amay railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30888871
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890454
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890532
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890594
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890612
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890736
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890781
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890800
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890926
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890939
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30890971
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30891065
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30891080
    {Coordinate{49.0352, 59.2252}, Tz::Europe_Kirov, CountryId{"RU"}}, // Q30891164
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Kinel railway station
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30891172
    {Coordinate{1.02083, 47.8219}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vendôme-Villiers-sur-Loir TGV
    {Coordinate{}, Timezone{}, CountryId{"RU"}}, // Q30896981
    {Coordinate{21.6926, 56.6205}, Tz::Europe_Riga, CountryId{"LV"}}, // Q30897330
    {Coordinate{21.5524, 56.5751}, Tz::Europe_Riga, CountryId{"LV"}}, // Q30897336
    {Coordinate{4.30861, 52.0533}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Den Haag Moerwijk
    {Coordinate{9.16667, 45.6667}, Tz::Europe_Rome, CountryId{"IT"}}, // Cabiate railway station
    {Coordinate{2.37333, 48.8967}, Tz::Europe_Paris, CountryId{"FR"}}, // Rosa Parks
    {Coordinate{-1.52446, 47.5546}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095579
    {Coordinate{6.85652, 43.4314}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095586
    {Coordinate{7.6034, 47.4677}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3095587
    {Coordinate{3.12175, 46.0551}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095589
    {Coordinate{4.19105, 43.5709}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aigues-Mortes
    {Coordinate{2.78046, 50.1317}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095591
    {Coordinate{0.748709, 45.2866}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Agonac
    {Coordinate{4.20875, 43.6787}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095594
    {Coordinate{7.55521, 43.8713}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095596
    {Coordinate{2.39833, 45.6139}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aix-La Marsalouse
    {Coordinate{1.14566, 45.7965}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095598
    {Coordinate{4.77182, 45.752}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095600
    {Coordinate{5.90944, 45.6881}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aix-les-Bains-Le Revard
    {Coordinate{2.64431, 50.0056}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Albert
    {Coordinate{4.83263, 45.8748}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095609
    {Coordinate{2.25191, 42.9974}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Alet-les-Bains
    {Coordinate{3.66377, 44.5413}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095615
    {Coordinate{3.67334, 44.9189}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095616
    {Coordinate{4.08492, 44.128}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095618
    {Coordinate{4.4739, 49.5239}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095619
    {Coordinate{4.3267, 45.971}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Amplepuis
    {Coordinate{3.91055, 49.4847}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095623
    {Coordinate{0.981175, 47.4216}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Amboise
    {Coordinate{4.67035, 49.9308}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095628
    {Coordinate{4.2552, 45.5216}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095632
    {Coordinate{2.30833, 49.8906}, Tz::Europe_Paris, CountryId{"FR"}}, // Amiens railway station
    {Coordinate{19.0892, 47.55}, Tz::Europe_Budapest, CountryId{"HU"}}, // Angyalföld train station
    {Coordinate{2.00389, 48.3114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Angerville
    {Coordinate{6.89209, 43.435}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095643
    {Coordinate{4.09316, 49.9849}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Anor
    {Coordinate{4.90472, 50.2375}, Tz::Europe_Brussels, CountryId{"BE"}}, // Anseremme railway station
    {Coordinate{0.165278, 45.6542}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Angoulême
    {Coordinate{6.45988, 49.2623}, Tz::Europe_Paris, CountryId{"FR"}}, // Anzeling
    {Coordinate{7.29613, 45.7326}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095652
    {Coordinate{7.30632, 45.7316}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095653
    {Coordinate{6.42373, 46.5509}, Tz::Europe_Zurich, CountryId{"CH"}}, // Apples railway station
    {Coordinate{7.3225, 45.7342}, Tz::Europe_Rome, CountryId{"IT"}}, // Aosta railway station
    {Coordinate{7.9735, 48.5413}, Tz::Europe_Berlin, CountryId{"DE"}}, // Appenweier
    {Coordinate{19.0481, 47.5662}, Tz::Europe_Budapest, CountryId{"HU"}}, // Aquincum MÁV station
    {Coordinate{3.7672, 47.6006}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Arcy-sur-Cure
    {Coordinate{5.77673, 47.0304}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095662
    {Coordinate{-0.025337, 48.7385}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Argentan
    {Coordinate{0.190015, 47.9286}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095667
    {Coordinate{1.12855, 48.0999}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095672
    {Coordinate{3.31062, 45.3654}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095673
    {Coordinate{2.25722, 48.9469}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Argenteuil
    {Coordinate{7.16675, 45.7041}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095675
    {Coordinate{-0.570131, 43.3931}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Artix
    {Coordinate{6.62052, 46.6132}, Tz::Europe_Zurich, CountryId{"CH"}}, // Assens railway station
    {Coordinate{-0.295131, 43.2545}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Assat
    {Coordinate{1.86954, 44.6745}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Assier
    {Coordinate{5.02306, 50.3681}, Tz::Europe_Brussels, CountryId{"BE"}}, // Assesse railway station
    {Coordinate{3.16036, 45.9838}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095685
    {Coordinate{-0.419804, 45.0153}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095686
    {Coordinate{0.265749, 47.6869}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095688
    {Coordinate{2.59276, 50.3531}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095689
    {Coordinate{2.10225, 50.3962}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095692
    {Coordinate{3.61118, 47.7663}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095693
    {Coordinate{1.77988, 48.4461}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095696
    {Coordinate{4.19836, 45.3711}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095697
    {Coordinate{-2.99917, 47.68}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Auray
    {Coordinate{4.29285, 46.9551}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Autun
    {Coordinate{2.49444, 48.9319}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Aulnay-sous-Bois
    {Coordinate{4.04351, 49.0648}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095704
    {Coordinate{3.58492, 47.798}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095705
    {Coordinate{3.91238, 47.4955}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avallon
    {Coordinate{1.78772, 43.3638}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Avignonet
    {Coordinate{2.83397, 50.4072}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095708
    {Coordinate{3.93313, 50.1269}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095711
    {Coordinate{7.13131, 45.7063}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095712
    {Coordinate{4.0016, 49.0487}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095713
    {Coordinate{2.65264, 47.0349}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095714
    {Coordinate{0.447649, 47.2663}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095715
    {Coordinate{0.86007, 47.3652}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095716
    {Coordinate{5.30139, 50.2242}, Tz::Europe_Brussels, CountryId{"BE"}}, // Aye railway station
    {Coordinate{7.99007, 47.5331}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eiken railway station
    {Coordinate{6.39329, 48.5035}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Einvaux
    {Coordinate{3.99356, 50.8238}, Tz::Europe_Brussels, CountryId{"BE"}}, // Eichem railway station
    {Coordinate{7.33344, 49.0162}, Tz::Europe_Paris, CountryId{"FR"}}, // gare d'Enchenberg
    {Coordinate{4.04722, 50.6972}, Tz::Europe_Brussels, CountryId{"BE"}}, // Enghien railway station
    {Coordinate{5.40111, 50.5822}, Tz::Europe_Brussels, CountryId{"BE"}}, // Engis railway station
    {Coordinate{2.30667, 48.9731}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Enghien-les-Bains
    {Coordinate{7.4509, 48.3636}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095742
    {Coordinate{-1.54465, 47.283}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095744
    {Coordinate{1.54227, 43.5171}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095745
    {Coordinate{2.81067, 48.9032}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095747
    {Coordinate{0.781666, 47.2841}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095750
    {Coordinate{4.86813, 45.5403}, Tz::Europe_Paris, CountryId{"FR"}}, // gare d'Estressin
    {Coordinate{5.04472, 48.583}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095752
    {Coordinate{1.74119, 45.7398}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095756
    {Coordinate{0.666598, 45.8863}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095757
    {Coordinate{2.06611, 49.9825}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Hangest
    {Coordinate{4.05999, 50.4706}, Tz::Europe_Brussels, CountryId{"BE"}}, // Havré railway station
    {Coordinate{4.70243, 50.0114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Haybes
    {Coordinate{2.54136, 50.7252}, Tz::Europe_Paris, CountryId{"FR"}}, // Hazebrouck
    {Coordinate{2.01094, 49.488}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095768
    {Coordinate{6.17974, 48.6455}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095770
    {Coordinate{6.8057, 48.6466}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095780
    {Coordinate{2.23083, 48.74}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095782
    {Coordinate{3.25957, 46.9334}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095786
    {Coordinate{2.6244, 42.6683}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ille-sur-Têt
    {Coordinate{1.24477, 48.3041}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095789
    {Coordinate{-0.919624, 47.4065}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095790
    {Coordinate{5.12935, 47.5203}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095794
    {Coordinate{3.25396, 45.544}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095800
    {Coordinate{-1.45185, 47.6263}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095801
    {Coordinate{19.1063, 47.5503}, Tz::Europe_Budapest, CountryId{"HU"}}, // Istvántelek railway station
    {Coordinate{2.25889, 48.8197}, Tz::Europe_Paris, CountryId{"FR"}}, // Issy
    {Coordinate{7.78725, 47.4673}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3095807
    {Coordinate{3.21475, 50.9211}, Tz::Europe_Brussels, CountryId{"BE"}}, // Izegem railway station
    {Coordinate{2.39111, 48.8142}, Tz::Europe_Paris, CountryId{"FR"}}, // Ivry-sur-Seine
    {Coordinate{6.97357, 47.9105}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095816
    {Coordinate{-1.76751, 46.5484}, Tz::Europe_Paris, CountryId{"FR"}}, // Olonne-sur-Mer
    {Coordinate{7.5349, 43.8783}, Tz::Europe_Rome, CountryId{"IT"}}, // Olivetta San Michele station
    {Coordinate{4.05367, 50.8566}, Tz::Europe_Brussels, CountryId{"BE"}}, // Okegem railway station
    {Coordinate{1.70251, 48.8265}, Tz::Europe_Paris, CountryId{"FR"}}, // Orgerus-Béhoust station
    {Coordinate{1.186, 47.4919}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Onzain
    {Coordinate{3.62684, 50.1032}, Tz::Europe_Paris, CountryId{"FR"}}, // Ors railway station
    {Coordinate{2.05759, 49.063}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095835
    {Coordinate{-0.021411, 43.1834}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Ossun
    {Coordinate{-1.29198, 47.3433}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095840
    {Coordinate{1.97722, 42.4197}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Osséja
    {Coordinate{6.8294, 45.0385}, Tz::Europe_Rome, CountryId{"IT"}}, // Oulx-Cesana-Claviere-Sestriere railway station
    {Coordinate{4.26727, 43.758}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095850
    {Coordinate{4.3321, 50.7919}, Tz::Europe_Brussels, CountryId{"BE"}}, // Uccle-Calevoet railway station
    {Coordinate{2.58658, 46.6294}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Urçay
    {Coordinate{2.36447, 44.9106}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095857
    {Coordinate{6.41097, 49.2748}, Tz::Europe_Paris, CountryId{"FR"}}, // Ébersviller
    {Coordinate{1.57045, 45.4407}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Uzerche
    {Coordinate{6.63294, 46.6394}, Tz::Europe_Zurich, CountryId{"CH"}}, // Échallens railway station
    {Coordinate{35.6441, 45.2649}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Branne Pole
    {Coordinate{5.99465, 47.2748}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'École-Valentin
    {Coordinate{0.268898, 47.8245}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095866
    {Coordinate{36.0378, 45.3544}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30958667
    {Coordinate{-0.51949, 47.5039}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095867
    {Coordinate{1.68155, 48.6052}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095869
    {Coordinate{2.36306, 49.0228}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare d'Écouen - Ézanville
    {Coordinate{6.29253, 45.457}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095873
    {Coordinate{2.33167, 48.6692}, Tz::Europe_Paris, CountryId{"FR"}}, // Épinay-sur-Orge (Paris RER)
    {Coordinate{4.1838, 46.8679}, Tz::Europe_Paris, CountryId{"FR"}}, // Étang-sur-Arroux train station
    {Coordinate{-0.460694, 47.6571}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095879
    {Coordinate{2.30228, 48.9542}, Tz::Europe_Paris, CountryId{"FR"}}, // Épinay-sur-Seine
    {Coordinate{5.63976, 49.2076}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095881
    {Coordinate{19.0322, 47.5692}, Tz::Europe_Budapest, CountryId{"HU"}}, // Óbuda railway station
    {Coordinate{19.0796, 47.5588}, Tz::Europe_Budapest, CountryId{"HU"}}, // Újpest railway station
    {Coordinate{-1.54534, 47.2589}, Tz::Europe_Paris, CountryId{"FR"}}, // Babinière
    {Coordinate{8.23085, 48.4489}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q3095888
    {Coordinate{1.32478, 48.3669}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095889
    {Coordinate{4.00699, 43.6533}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095890
    {Coordinate{2.73488, 50.729}, Tz::Europe_Paris, CountryId{"FR"}}, // Bailleul
    {Coordinate{6.09929, 48.5864}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095895
    {Coordinate{0.618691, 47.337}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ballan
    {Coordinate{3.23469, 50.6185}, Tz::Europe_Paris, CountryId{"FR"}}, // Baisieux
    {Coordinate{7.50432, 47.811}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bantzenheim
    {Coordinate{7.4567, 48.4033}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Barr
    {Coordinate{2.01898, 45.5663}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095906
    {Coordinate{4.13961, 45.2977}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095908
    {Coordinate{7.24684, 47.3367}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3095912
    {Coordinate{5.925, 49.5583}, Tz::Europe_Luxembourg, CountryId{"LU"}}, // Bascharage-Sanem railway station
    {Coordinate{-2.4789, 47.281}, Tz::Europe_Paris, CountryId{"FR"}}, // Batz-sur-Mer train station
    {Coordinate{2.90519, 50.5116}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095922
    {Coordinate{5.07602, 48.5516}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bayard
    {Coordinate{1.66818, 47.8118}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095924
    {Coordinate{6.32275, 48.4679}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bayon
    {Coordinate{4.17414, 49.3611}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095927
    {Coordinate{1.6206, 43.4535}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Baziège
    {Coordinate{4.64708, 43.8022}, Tz::Europe_Paris, CountryId{"FR"}}, // Beaucaire
    {Coordinate{1.62577, 47.7785}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095933
    {Coordinate{1.89529, 50.4228}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095935
    {Coordinate{4.32131, 43.7246}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095936
    {Coordinate{-0.468878, 46.1767}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095939
    {Coordinate{-0.603529, 42.9949}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095940
    {Coordinate{-0.450085, 44.7011}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Beautiran
    {Coordinate{-1.47, 43.4972}, Tz::Europe_Paris, CountryId{"FR"}}, // Bayonne railway station
    {Coordinate{-0.526509, 45.7007}, Tz::Europe_Paris, CountryId{"FR"}}, // Beillant
    {Coordinate{6.10184, 48.8196}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095947
    {Coordinate{-1.43445, 46.7883}, Tz::Europe_Paris, CountryId{"FR"}}, // Belleville
    {Coordinate{4.72886, 46.112}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belleville-sur-Saône
    {Coordinate{5.823, 46.1095}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bellegarde
    {Coordinate{3.75189, 44.5618}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095955
    {Coordinate{2.36083, 49.0978}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belloy – Saint-Martin
    {Coordinate{-3.07217, 47.6525}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Belz-Ploemel
    {Coordinate{2.74997, 47.0001}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095962
    {Coordinate{6.7037, 46.6929}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bercher railway station
    {Coordinate{4.28992, 50.8727}, Tz::Europe_Brussels, CountryId{"BE"}}, // Berchem-Sainte-Agathe railway station
    {Coordinate{6.79112, 48.4284}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095975
    {Coordinate{3.36048, 46.443}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095977
    {Coordinate{-1.87, 47.6992}, Tz::Europe_Paris, CountryId{"FR"}}, // Beslé
    {Coordinate{2.69169, 50.5358}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095981
    {Coordinate{7.57929, 43.8252}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3095986
    {Coordinate{7.12633, 43.6109}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Biot
    {Coordinate{7.74116, 48.6112}, Tz::Europe_Paris, CountryId{"FR"}}, // Bischheim
    {Coordinate{7.4981, 48.4871}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095992
    {Coordinate{4.17278, 50.4086}, Tz::Europe_Brussels, CountryId{"BE"}}, // Binche railway station
    {Coordinate{7.43227, 49.0488}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Bitche
    {Coordinate{7.85132, 48.7656}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095997
    {Coordinate{7.07822, 47.8277}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3095998
    {Coordinate{6.333, 46.538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bière railway station
    {Coordinate{4.7405, 47.374}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096003
    {Coordinate{4.39144, 46.6941}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096004
    {Coordinate{0.987822, 47.3379}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096007
    {Coordinate{3.13387, 51.3122}, Tz::Europe_Brussels, CountryId{"BE"}}, // Blankenberge railway station
    {Coordinate{4.57518, 45.9066}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096013
    {Coordinate{4.70796, 44.2716}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096014
    {Coordinate{7.26733, 47.857}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bollwiller
    {Coordinate{2.77131, 50.2107}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096020
    {Coordinate{4.40944, 50.8772}, Tz::Europe_Brussels, CountryId{"BE"}}, // Bordet railway station
    {Coordinate{-1.68139, 47.1381}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bouaye
    {Coordinate{4.18762, 43.9927}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096030
    {Coordinate{2.2072, 49.1947}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bornel-Belle-Église
    {Coordinate{2.13212, 48.8542}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096034
    {Coordinate{-1.17869, 46.6516}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096037
    {Coordinate{-1.95528, 47.0464}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourgneuf-en-Retz
    {Coordinate{-1.18281, 47.0506}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Boussay - La Bruffière
    {Coordinate{0.83836, 49.3176}, Tz::Europe_Paris, CountryId{"FR"}}, // Bourgtheroulde-Thuit-Hébert
    {Coordinate{2.69194, 48.3325}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourron-Marlotte–Grez
    {Coordinate{5.21461, 46.2001}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bourg-en-Bresse
    {Coordinate{4.27761, 45.5247}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096044
    {Coordinate{4.35308, 49.0913}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096046
    {Coordinate{6.52903, 49.2899}, Tz::Europe_Paris, CountryId{"FR"}}, // Bouzonville
    {Coordinate{2.37611, 48.4347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096048
    {Coordinate{4.00491, 45.7413}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096049
    {Coordinate{3.20217, 50.5739}, Tz::Europe_Paris, CountryId{"FR"}}, // Bouvines
    {Coordinate{4.13844, 50.6056}, Tz::Europe_Brussels, CountryId{"BE"}}, // Braine-le-Comte railway station
    {Coordinate{3.33017, 45.4141}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096057
    {Coordinate{2.1193, 43.244}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bram
    {Coordinate{7.10367, 48.0283}, Tz::Europe_Paris, CountryId{"FR"}}, // Breitenbach station
    {Coordinate{-0.496381, 46.8384}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096060
    {Coordinate{-0.51167, 49.2031}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096062
    {Coordinate{3.7665, 49.3084}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096063
    {Coordinate{1.44008, 45.8642}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096065
    {Coordinate{4.76377, 45.6737}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096066
    {Coordinate{4.20702, 46.9086}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096068
    {Coordinate{3.37875, 45.3006}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096071
    {Coordinate{1.8334, 50.4469}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096072
    {Coordinate{1.16056, 48.2158}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096073
    {Coordinate{0.711597, 49.1964}, Tz::Europe_Paris, CountryId{"FR"}}, // Brionne
    {Coordinate{4.29548, 46.8622}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096075
    {Coordinate{4.32134, 50.849}, Tz::Europe_Brussels, CountryId{"BE"}}, // Brussels West railway station
    {Coordinate{-1.75181, 48.0286}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096079
    {Coordinate{1.54156, 48.9433}, Tz::Europe_Paris, CountryId{"FR"}}, // Bréval
    {Coordinate{19.0315, 47.4413}, Tz::Europe_Budapest, CountryId{"HU"}}, // Albertfalva railway station
    {Coordinate{7.84799, 47.4089}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096083
    {Coordinate{19.0327, 47.4113}, Tz::Europe_Budapest, CountryId{"HU"}}, // Háros railway station
    {Coordinate{19.0413, 47.4238}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budafok railway station
    {Coordinate{19.0018, 47.5808}, Tz::Europe_Budapest, CountryId{"HU"}}, // Üröm railway station
    {Coordinate{19.0165, 47.4051}, Tz::Europe_Budapest, CountryId{"HU"}}, // Budatétény railway station
    {Coordinate{1.92436, 45.6005}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096089
    {Coordinate{1.44352, 48.9253}, Tz::Europe_Paris, CountryId{"FR"}}, // Bueil
    {Coordinate{2.73329, 50.4486}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096091
    {Coordinate{1.02614, 45.6075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bussière-Galant
    {Coordinate{3.31803, 46.8652}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096096
    {Coordinate{3.14947, 43.6087}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096097
    {Coordinate{4.89299, 44.0408}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bédarrides
    {Coordinate{7.61952, 47.5426}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096099
    {Coordinate{2.16305, 48.6958}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Bures-sur-Yvette
    {Coordinate{6.82847, 49.1382}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096104
    {Coordinate{-1.36977, 43.6278}, Tz::Europe_Paris, CountryId{"FR"}}, // Bénesse-Maremne
    {Coordinate{1.91671, 42.4581}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Béna Fanès
    {Coordinate{7.14806, 43.6578}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cagnes-sur-Mer
    {Coordinate{-0.3477, 49.1764}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Caen
    {Coordinate{3.06634, 44.422}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096117
    {Coordinate{5.04399, 44.0503}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Carpentras
    {Coordinate{5.154, 43.3365}, Tz::Europe_Paris, CountryId{"FR"}}, // Carry-le-Rouet train station
    {Coordinate{4.73067, 45.788}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096140
    {Coordinate{-0.040707, 44.8571}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Castillon
    {Coordinate{5.04365, 43.8347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096148
    {Coordinate{-0.38215, 45.1052}, Tz::Europe_Paris, CountryId{"FR"}}, // Cavignac
    {Coordinate{6.15734, 48.5239}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096152
    {Coordinate{3.15515, 43.8123}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096153
    {Coordinate{3.6452, 46.8578}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096157
    {Coordinate{-0.667485, 46.8175}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096159
    {Coordinate{-0.533632, 44.8563}, Tz::Europe_Paris, CountryId{"FR"}}, // Cenon station
    {Coordinate{3.15183, 48.8143}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chailly - Boissy-le-Châtel
    {Coordinate{2.59417, 48.5653}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cesson
    {Coordinate{2.25722, 48.985}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cernay
    {Coordinate{-0.743689, 47.3429}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096169
    {Coordinate{3.99245, 45.206}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096170
    {Coordinate{1.78244, 47.8771}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096173
    {Coordinate{-1.87194, 46.8433}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Challans
    {Coordinate{2.21361, 48.5117}, Tz::Europe_Paris, CountryId{"FR"}}, // Chamarande (Paris RER)
    {Coordinate{3.97931, 44.3003}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096177
    {Coordinate{7.55718, 45.7443}, Tz::Europe_Rome, CountryId{"IT"}}, // Chambave train station
    {Coordinate{0.96538, 47.1818}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096179
    {Coordinate{4.50711, 45.9816}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096181
    {Coordinate{3.60366, 47.7385}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096182
    {Coordinate{5.91937, 45.561}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chambéry-Challes-les-Eaux
    {Coordinate{-1.05454, 46.6901}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096184
    {Coordinate{3.17192, 46.7283}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096185
    {Coordinate{3.74189, 44.838}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096187
    {Coordinate{-1.59434, 47.1972}, Tz::Europe_Paris, CountryId{"FR"}}, // Chantenay Station
    {Coordinate{4.76427, 45.6983}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096190
    {Coordinate{4.73582, 45.7822}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Charbonnières-les-Bains
    {Coordinate{4.80083, 45.5814}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096199
    {Coordinate{3.8399, 44.554}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096201
    {Coordinate{0.453528, 45.8244}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096202
    {Coordinate{6.30155, 48.3786}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096204
    {Coordinate{4.3454, 46.2074}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096206
    {Coordinate{4.72534, 45.8733}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096209
    {Coordinate{4.67585, 46.8925}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096210
    {Coordinate{3.55426, 47.8974}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096213
    {Coordinate{2.18853, 48.8048}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Chaville-Rive-Gauche
    {Coordinate{-0.732163, 47.2177}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096215
    {Coordinate{6.60608, 46.5844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cheseaux-sur-Lausanne railway station
    {Coordinate{5.11157, 48.5245}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096218
    {Coordinate{4.62253, 45.8856}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Chessy
    {Coordinate{1.13353, 47.3348}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096220
    {Coordinate{3.2638, 44.5246}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096221
    {Coordinate{6.27186, 44.5458}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096225
    {Coordinate{1.24732, 47.52}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096226
    {Coordinate{0.901374, 47.5879}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096228
    {Coordinate{-0.86979, 47.066}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cholet
    {Coordinate{0.688232, 45.2446}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Château-l'Évêque
    {Coordinate{0.414916, 47.6832}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Château-du-Loir
    {Coordinate{-1.40522, 48.1062}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096234
    {Coordinate{1.64517, 45.7594}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096235
    {Coordinate{6.81549, 46.5705}, Tz::Europe_Zurich, CountryId{"CH"}}, // Châtillens railway station
    {Coordinate{4.64523, 45.8753}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096237
    {Coordinate{4.51889, 50.4087}, Tz::Europe_Brussels, CountryId{"BE"}}, // Châtelet railway station
    {Coordinate{6.19629, 46.1967}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096243
    {Coordinate{0.460506, 47.3451}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096245
    {Coordinate{4.29959, 46.6042}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096246
    {Coordinate{4.7184, 45.8593}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Civrieux-d'Azergues
    {Coordinate{3.52055, 47.4668}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clamecy
    {Coordinate{3.5766, 49.5439}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096250
    {Coordinate{3.13415, 45.767}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096253
    {Coordinate{5.06485, 49.1066}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Clermont-en-Argonne
    {Coordinate{1.24336, 47.9921}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096255
    {Coordinate{-1.2865, 47.0859}, Tz::Europe_Paris, CountryId{"FR"}}, // Clisson
    {Coordinate{1.10652, 49.5994}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096260
    {Coordinate{5.26615, 47.221}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096264
    {Coordinate{4.84641, 45.8291}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096265
    {Coordinate{1.33395, 43.6036}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Colomiers
    {Coordinate{5.58868, 48.7659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096271
    {Coordinate{2.99825, 50.7717}, Tz::Europe_Brussels, CountryId{"BE"}}, // Comines railway station
    {Coordinate{1.22675, 45.1267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Condat-Le Lardin
    {Coordinate{4.34309, 47.0509}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096281
    {Coordinate{3.67833, 47.2547}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Corbigny
    {Coordinate{1.89978, 44.0671}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cordes-Vindrac
    {Coordinate{0.833971, 47.2625}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096288
    {Coordinate{4.91714, 47.0842}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096291
    {Coordinate{2.88604, 50.415}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096295
    {Coordinate{1.69791, 45.2151}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cornil
    {Coordinate{3.08155, 48.8077}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Coulommiers
    {Coordinate{7.12417, 47.4053}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courgenay
    {Coordinate{2.24853, 48.8984}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Courbevoie
    {Coordinate{3.05092, 43.2337}, Tz::Europe_Paris, CountryId{"FR"}}, // Coursan
    {Coordinate{7.29116, 47.3351}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096306
    {Coordinate{4.88831, 44.09}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096308
    {Coordinate{6.59583, 52.0119}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Lichtenvoorde-Groenlo railway station
    {Coordinate{7.31798, 47.3427}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courtételle
    {Coordinate{1.23484, 48.4515}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096314
    {Coordinate{0.867747, 47.2378}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096315
    {Coordinate{-1.44148, 49.0427}, Tz::Europe_Paris, CountryId{"FR"}}, // Coutances
    {Coordinate{0.70364, 44.8366}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Couze
    {Coordinate{3.68114, 47.6786}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096319
    {Coordinate{4.82928, 45.8487}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096321
    {Coordinate{-1.72357, 47.2219}, Tz::Europe_Paris, CountryId{"FR"}}, // Couëron
    {Coordinate{3.16307, 50.6957}, Tz::Europe_Paris, CountryId{"FR"}}, // Croix-L'Allumette
    {Coordinate{5.01966, 43.4089}, Tz::Europe_Paris, CountryId{"FR"}}, // Croix-Sainte train station
    {Coordinate{2.40556, 49.2564}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cramoisy
    {Coordinate{3.0628, 49.0917}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096328
    {Coordinate{-0.459042, 44.9729}, Tz::Europe_Paris, CountryId{"FR"}}, // Cubzac-les-Ponts
    {Coordinate{4.78417, 46.2462}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096336
    {Coordinate{-1.25486, 47.0587}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Cugand
    {Coordinate{2.88653, 49.231}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Crépy-en-Valois
    {Coordinate{2.74465, 50.522}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096339
    {Coordinate{3.21002, 50.5619}, Tz::Europe_Paris, CountryId{"FR"}}, // Cysoing
    {Coordinate{7.43558, 48.3217}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096344
    {Coordinate{34.4881, 45.6339}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963448
    {Coordinate{5.65679, 48.094}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Damblain
    {Coordinate{34.6556, 45.5247}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963450
    {Coordinate{34.4625, 45.6475}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963451
    {Coordinate{34.8056, 45.3869}, Tz::Europe_Simferopol, CountryId{"UA"}}, // 50 km
    {Coordinate{34.9269, 45.3406}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963455
    {Coordinate{35.0642, 45.2875}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963456
    {Coordinate{4.76122, 45.8153}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096346
    {Coordinate{35.3036, 45.1953}, Tz::Europe_Simferopol, CountryId{"UA"}}, // 93 km
    {Coordinate{35.3994, 45.1269}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963468
    {Coordinate{4.75996, 45.7968}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096347
    {Coordinate{35.445, 45.1881}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963470
    {Coordinate{35.5383, 45.2292}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963472
    {Coordinate{3.73656, 45.1421}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Darsac
    {Coordinate{36.015, 45.3578}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963490
    {Coordinate{3.46728, 46.8375}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096352
    {Coordinate{4.36183, 50.7481}, Tz::Europe_Brussels, CountryId{"BE"}}, // De Hoek railway station
    {Coordinate{3.64908, 50.9965}, Tz::Europe_Brussels, CountryId{"BE"}}, // De Pinte railway station
    {Coordinate{7.0865, 45.7304}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3096357
    {Coordinate{4.70722, 49.8796}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096359
    {Coordinate{6.12638, 48.3976}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096361
    {Coordinate{7.83776, 47.4496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096363
    {Coordinate{6.07184, 48.844}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dieulouard
    {Coordinate{3.98765, 46.4853}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096365
    {Coordinate{3.75182, 46.5307}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096370
    {Coordinate{6.26017, 49.335}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096372
    {Coordinate{5.02722, 47.3233}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dijon-Ville
    {Coordinate{6.34346, 48.6233}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096382
    {Coordinate{4.73441, 45.8397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dommartin - Lissieu
    {Coordinate{-0.025953, 48.1078}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096385
    {Coordinate{3.67492, 46.5264}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096386
    {Coordinate{4.87481, 49.6984}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Donchery
    {Coordinate{5.1483, 48.3658}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096388
    {Coordinate{3.87106, 50.1461}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096389
    {Coordinate{7.49293, 48.5244}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096390
    {Coordinate{7.61122, 47.4886}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096391
    {Coordinate{36.1698, 45.3719}, Tz::Europe_Simferopol, CountryId{"UA"}}, // Q30963939
    {Coordinate{2.98693, 50.4322}, Tz::Europe_Paris, CountryId{"FR"}}, // Dourges
    {Coordinate{0.417295, 45.0795}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Douzillac
    {Coordinate{1.99528, 48.5356}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dourdan-la-Forêt
    {Coordinate{-2.0502, 47.4824}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Drefféac
    {Coordinate{7.94764, 48.766}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096402
    {Coordinate{0.535685, 47.3069}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096403
    {Coordinate{2.41111, 48.9437}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Dugny - La Courneuve
    {Coordinate{7.83951, 47.6613}, Tz::Europe_Berlin, CountryId{"DE"}}, // Fahrnau station
    {Coordinate{6.90806, 49.0879}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096413
    {Coordinate{6.86167, 49.1181}, Tz::Europe_Paris, CountryId{"FR"}}, // Farébersviller
    {Coordinate{7.67236, 48.491}, Tz::Europe_Paris, CountryId{"FR"}}, // Fegersheim - Lipsheim
    {Coordinate{6.98705, 47.8977}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096419
    {Coordinate{2.16971, 45.8863}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Felletin
    {Coordinate{19.2237, 47.4374}, Tz::Europe_Budapest, CountryId{"HU"}}, // Ferihegy railway station
    {Coordinate{4.85308, 45.6659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096429
    {Coordinate{4.23077, 45.744}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096431
    {Coordinate{2.77278, 48.0964}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ferrières-Fontenay
    {Coordinate{2.0373, 44.6035}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Figeac
    {Coordinate{4.2864, 45.3918}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Firminy
    {Coordinate{3.61497, 47.3631}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096437
    {Coordinate{4.66012, 45.8451}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096438
    {Coordinate{4.80729, 50.4562}, Tz::Europe_Brussels, CountryId{"BE"}}, // Flawinne railway station
    {Coordinate{4.20668, 43.9073}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096441
    {Coordinate{-0.760833, 48.0764}, Tz::Europe_Paris, CountryId{"FR"}}, // Laval railway station
    {Coordinate{-0.383186, 45.3871}, Tz::Europe_Paris, CountryId{"FR"}}, // Fontaines-d'Ozillac
    {Coordinate{4.77507, 46.8513}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096448
    {Coordinate{5.98005, 48.7115}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fontenoy-sur-Moselle
    {Coordinate{7.55107, 43.9967}, Tz::Europe_Paris, CountryId{"FR"}}, // Fontan - Saorge railway station
    {Coordinate{4.32455, 50.4332}, Tz::Europe_Brussels, CountryId{"BE"}}, // Forchies railway station
    {Coordinate{4.97472, 43.4281}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096453
    {Coordinate{2.1885, 42.5138}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fontpédrouse-Saint-Thomas-les-Bains
    {Coordinate{-0.40693, 46.2346}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096457
    {Coordinate{5.79132, 48.6793}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096461
    {Coordinate{-1.23186, 46.6653}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fougeré
    {Coordinate{0.597129, 49.6083}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096464
    {Coordinate{-1.85139, 47.7297}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fougeray - Langon
    {Coordinate{4.2697, 45.395}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096467
    {Coordinate{4.05384, 50.0154}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fourmies
    {Coordinate{3.08722, 47.0189}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fourchambault
    {Coordinate{3.90611, 50.4058}, Tz::Europe_Brussels, CountryId{"BE"}}, // Frameries railway station
    {Coordinate{4.014, 49.2422}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096474
    {Coordinate{6.49131, 49.2773}, Tz::Europe_Paris, CountryId{"FR"}}, // Freistroff
    {Coordinate{5.93753, 47.2274}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096478
    {Coordinate{7.71912, 47.5014}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096480
    {Coordinate{2.23472, 48.9933}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Franconville – Le Plessis-Bouchard
    {Coordinate{6.31408, 45.6304}, Tz::Europe_Paris, CountryId{"FR"}}, // Frontenex
    {Coordinate{5.14167, 48.2964}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096489
    {Coordinate{3.75891, 43.4449}, Tz::Europe_Paris, CountryId{"FR"}}, // Frontignan
    {Coordinate{1.43248, 46.1714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096492
    {Coordinate{5.15614, 48.4008}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096493
    {Coordinate{1.2118, 47.8919}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096495
    {Coordinate{3.35447, 50.6301}, Tz::Europe_Brussels, CountryId{"BE"}}, // Froyennes railway station
    {Coordinate{2.63331, 50.3473}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096497
    {Coordinate{4.69253, 49.9861}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Fumay
    {Coordinate{2.67028, 51.0736}, Tz::Europe_Brussels, CountryId{"BE"}}, // Veurne railway station
    {Coordinate{4.72642, 50.0235}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096505
    {Coordinate{4.17127, 43.7161}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096509
    {Coordinate{4.32999, 46.6422}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096510
    {Coordinate{7.87918, 48.6951}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gambsheim
    {Coordinate{4.14674, 44.2703}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096512
    {Coordinate{1.89606, 43.9068}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gaillac
    {Coordinate{6.13597, 49.261}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096518
    {Coordinate{3.74057, 51.0561}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gent-Dampoort railway station
    {Coordinate{3.08583, 47.0431}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Garchizy
    {Coordinate{0.331864, 44.8347}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gardonne
    {Coordinate{-0.399223, 45.0544}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096524
    {Coordinate{7.84757, 47.4658}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096527
    {Coordinate{-0.699411, 44.7722}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096529
    {Coordinate{4.02279, 49.128}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096531
    {Coordinate{2.34056, 48.8156}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096532
    {Coordinate{3.14309, 45.8335}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096533
    {Coordinate{5.27083, 51.8839}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Geldermalsen railway station
    {Coordinate{-3.44278, 47.8028}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gestel
    {Coordinate{4.99905, 47.2275}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gevrey-Chambertin
    {Coordinate{3.78212, 46.5371}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096539
    {Coordinate{0.86748, 43.6331}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096543
    {Coordinate{7.2093, 47.3352}, Tz::Europe_Zurich, CountryId{"CH"}}, // Glovelier train station
    {Coordinate{5.53548, 50.7506}, Tz::Europe_Brussels, CountryId{"BE"}}, // Glons railway station
    {Coordinate{-1.31379, 47.1079}, Tz::Europe_Paris, CountryId{"FR"}}, // Gorges
    {Coordinate{1.73802, 49.4814}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096557
    {Coordinate{7.47875, 48.4329}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096559
    {Coordinate{0.851389, 44.1167}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Golfech
    {Coordinate{7.69028, 48.5328}, Tz::Europe_Paris, CountryId{"FR"}}, // Graffenstaden railway station
    {Coordinate{4.03289, 44.2098}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096562
    {Coordinate{5.95335, 50.19}, Tz::Europe_Brussels, CountryId{"BE"}}, // Gouvy railway station
    {Coordinate{1.72226, 44.7734}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Gramat
    {Coordinate{2.46306, 49.0236}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096567
    {Coordinate{7.59235, 47.4413}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096575
    {Coordinate{2.39556, 48.6533}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grigny-Centre
    {Coordinate{6.17579, 46.0111}, Tz::Europe_Paris, CountryId{"FR"}}, // Groisy-Thorens-la-Caille
    {Coordinate{1.30139, 43.8269}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Grisolles
    {Coordinate{6.25891, 45.5944}, Tz::Europe_Paris, CountryId{"FR"}}, // Grésy-sur-Isère
    {Coordinate{5.92198, 45.7247}, Tz::Europe_Paris, CountryId{"FR"}}, // Grésy-sur-Aix train station
    {Coordinate{5.14099, 48.3382}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096594
    {Coordinate{7.8909, 46.5965}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grütschalp railway station
    {Coordinate{7.17474, 48.0416}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096599
    {Coordinate{17.634, 47.682}, Tz::Europe_Budapest, CountryId{"HU"}}, // Győr railway station
    {Coordinate{4.23805, 46.5812}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096601
    {Coordinate{3.95165, 44.3472}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Génolhac
    {Coordinate{4.34337, 43.7324}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096603
    {Coordinate{5.74329, 49.556}, Tz::Europe_Brussels, CountryId{"BE"}}, // Halanzy railway station
    {Coordinate{-1.52259, 47.249}, Tz::Europe_Paris, CountryId{"FR"}}, // Haluchère-Batignolles
    {Coordinate{7.84637, 47.6793}, Tz::Europe_Berlin, CountryId{"DE"}}, // Hausen-Raitbach station
    {Coordinate{3.91537, 50.2539}, Tz::Europe_Paris, CountryId{"FR"}}, // Hautmont
    {Coordinate{7.91015, 48.7276}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096622
    {Coordinate{3.23913, 51.3339}, Tz::Europe_Brussels, CountryId{"BE"}}, // Heist railway station
    {Coordinate{4.5377, 50.9977}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hever railway station
    {Coordinate{4.46778, 50.76}, Tz::Europe_Brussels, CountryId{"BE"}}, // Hoeilaart railway station
    {Coordinate{6.35077, 49.2825}, Tz::Europe_Paris, CountryId{"FR"}}, // Hombourg-Budange
    {Coordinate{7.66318, 48.5556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096635
    {Coordinate{5.00583, 50.1906}, Tz::Europe_Brussels, CountryId{"BE"}}, // Houyet railway station
    {Coordinate{6.97754, 49.1066}, Tz::Europe_Paris, CountryId{"FR"}}, // Hundling
    {Coordinate{6.20256, 48.6701}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096650
    {Coordinate{2.13966, 45.5435}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096652
    {Coordinate{5.26667, 50.16}, Tz::Europe_Brussels, CountryId{"BE"}}, // Jemelle railway station
    {Coordinate{4.76707, 49.8337}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096655
    {Coordinate{37.6881, 49.7948}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30966552
    {Coordinate{37.6373, 49.7083}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30966553
    {Coordinate{5.14366, 48.4443}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096656
    {Coordinate{3.81946, 49.2902}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096660
    {Coordinate{3.39314, 47.9736}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096662
    {Coordinate{28.7803, 51.2656}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30966639
    {Coordinate{6.60172, 46.5484}, Tz::Europe_Zurich, CountryId{"CH"}}, // Jouxtens-Mézery railway station
    {Coordinate{28.7275, 51.2897}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30966641
    {Coordinate{1.55753, 48.5102}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Jouy
    {Coordinate{3.27376, 48.7908}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096666
    {Coordinate{2.16333, 48.7647}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096667
    {Coordinate{7.11141, 43.571}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Juan-les-Pins
    {Coordinate{7.7241, 47.5386}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kaiseraugst railway station
    {Coordinate{7.12527, 49.0351}, Tz::Europe_Paris, CountryId{"FR"}}, // Kalhausen station
    {Coordinate{-3.13655, 47.5364}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Kerhostin
    {Coordinate{7.85518, 48.6796}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096687
    {Coordinate{19.1572, 47.4479}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kispest railway station
    {Coordinate{7.87423, 48.5702}, Tz::Europe_Berlin, CountryId{"DE"}}, // Kork
    {Coordinate{10.5611, 62.9765}, Tz::Europe_Oslo, CountryId{"NO"}}, // Kotsøy Station
    {Coordinate{6.969, 47.924}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Kruth
    {Coordinate{6.23455, 49.3499}, Tz::Europe_Paris, CountryId{"FR"}}, // Kuntzig
    {Coordinate{7.81324, 48.7419}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096706
    {Coordinate{6.33254, 49.3052}, Tz::Europe_Paris, CountryId{"FR"}}, // Kédange
    {Coordinate{19.1491, 47.4631}, Tz::Europe_Budapest, CountryId{"HU"}}, // Kőbánya-Kispest railway station
    {Coordinate{0.620062, 48.7663}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Aigle
    {Coordinate{7.35196, 43.8397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Escarène
    {Coordinate{-1.37122, 46.9069}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096724
    {Coordinate{5.0475, 43.9174}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096732
    {Coordinate{5.21944, 45.6075}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Isle-d'Abeau
    {Coordinate{2.80516, 50.5278}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096743
    {Coordinate{1.16009, 45.1511}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Bachellerie
    {Coordinate{3.9042, 44.5935}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Bastide - Saint-Laurent-les-Bains
    {Coordinate{-0.40088, 47.4344}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096749
    {Coordinate{-1.66028, 47.2041}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Basse-Indre-Saint-Herblain
    {Coordinate{-2.38944, 47.2886}, Tz::Europe_Paris, CountryId{"FR"}}, // La Baule-Escoublac train station
    {Coordinate{-2.03361, 47.0828}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Bernerie-en-Retz
    {Coordinate{-2.11034, 48.2136}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Brohinière
    {Coordinate{2.74609, 45.5906}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096758
    {Coordinate{-1.28353, 46.6769}, Tz::Europe_Paris, CountryId{"FR"}}, // La Chaize-le-Vicomte
    {Coordinate{7.60284, 44.0625}, Tz::Europe_Paris, CountryId{"FR"}}, // La Brigue railway halt
    {Coordinate{2.50556, 49.1269}, Tz::Europe_Paris, CountryId{"FR"}}, // La Borne Blanche
    {Coordinate{0.627762, 45.1839}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Cave
    {Coordinate{-1.54134, 47.3087}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096764
    {Coordinate{-1.54803, 47.2974}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096765
    {Coordinate{0.218684, 47.2513}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096766
    {Coordinate{1.82684, 47.893}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096767
    {Coordinate{5.96133, 46.6049}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096768
    {Coordinate{4.29841, 46.2882}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096769
    {Coordinate{1.35416, 47.6131}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096770
    {Coordinate{3.02389, 47.1797}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Charité
    {Coordinate{6.82504, 47.0986}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Chaux-de-Fonds railway station
    {Coordinate{0.974336, 45.5407}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Coquille
    {Coordinate{0.653075, 47.3386}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096775
    {Coordinate{3.29775, 48.7821}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096776
    {Coordinate{-0.379182, 43.2856}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Croix du Prince
    {Coordinate{33.3833, 47.3889}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30967789
    {Coordinate{4.31687, 45.4979}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096780
    {Coordinate{26.6027, 50.3838}, Tz::Europe_Kiev, CountryId{"UA"}}, // Badivka
    {Coordinate{6.97211, 43.5581}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Frayère
    {Coordinate{6.01006, 43.1187}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096782
    {Coordinate{3.12075, 49.1796}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Ferté-Milon
    {Coordinate{0.19304, 48.114}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096784
    {Coordinate{2.94841, 46.9478}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096785
    {Coordinate{35.6106, 49.5583}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30967853
    {Coordinate{-1.90593, 48.6144}, Tz::Europe_Paris, CountryId{"FR"}}, // La Gouesnière - Cancale - Saint-Méloir-des-Ondes
    {Coordinate{-1.39194, 47.1614}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Haye-Fouassière
    {Coordinate{0.105565, 48.3033}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096791
    {Coordinate{4.01049, 44.2285}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096792
    {Coordinate{4.49708, 50.7383}, Tz::Europe_Brussels, CountryId{"BE"}}, // La Hulpe railway station
    {Coordinate{3.04083, 47.1392}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Marche
    {Coordinate{-1.65958, 46.6071}, Tz::Europe_Paris, CountryId{"FR"}}, // La Mothe-Achard
    {Coordinate{5.99961, 46.1787}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Plaine
    {Coordinate{4.35815, 45.4034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096803
    {Coordinate{-0.691705, 47.3714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096804
    {Coordinate{4.17017, 47.3853}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096808
    {Coordinate{1.36554, 45.1397}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Rivière-de-Mansac
    {Coordinate{4.71615, 45.8001}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096811
    {Coordinate{0.026461, 47.8924}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096812
    {Coordinate{1.37291, 48.4074}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096814
    {Coordinate{7.31206, 43.7432}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096816
    {Coordinate{2.5917, 46.35}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096819
    {Coordinate{7.85518, 48.6796}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096820
    {Coordinate{1.21694, 44.0356}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de La Ville-Dieu
    {Coordinate{2.26542, 44.9203}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096824
    {Coordinate{4.18528, 50.3161}, Tz::Europe_Brussels, CountryId{"BE"}}, // Labuissière railway station
    {Coordinate{1.82648, 45.6412}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096826
    {Coordinate{1.5129, 43.5474}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096827
    {Coordinate{3.61035, 45.1229}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096828
    {Coordinate{37.7296, 49.8522}, Tz::Europe_Kiev, CountryId{"UA"}}, // Dvorichna
    {Coordinate{0.217, 47.874}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096830
    {Coordinate{37.9083, 49.9603}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30968307
    {Coordinate{4.69282, 49.9114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Laifour
    {Coordinate{1.13101, 45.6339}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lafarge
    {Coordinate{27.8844, 50.7489}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30968351
    {Coordinate{28.4622, 50.9392}, Tz::Europe_Kiev, CountryId{"UA"}}, // Viden'
    {Coordinate{29.0414, 51.5697}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30968360
    {Coordinate{28.4903, 50.9464}, Tz::Europe_Kiev, CountryId{"UA"}}, // Vyhiv
    {Coordinate{28.9747, 51.5031}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30968368
    {Coordinate{0.742823, 44.8396}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lalinde
    {Coordinate{28.6908, 51.0922}, Tz::Europe_Kiev, CountryId{"UA"}}, // Q30968385
    {Coordinate{28.5659, 50.9826}, Tz::Europe_Kiev, CountryId{"UA"}}, // Kozhuhivka
    {Coordinate{5.7591, 48.0905}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096839
    {Coordinate{0.380301, 44.8434}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamonzie-Saint-Martin
    {Coordinate{0.02152, 44.8538}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lamothe-Montravel
    {Coordinate{-3.08639, 47.7361}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096845
    {Coordinate{6.22803, 48.6555}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096846
    {Coordinate{3.4905, 45.1012}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096847
    {Coordinate{0.410647, 47.324}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096848
    {Coordinate{-3.12556, 47.7597}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096850
    {Coordinate{2.89326, 46.2268}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096852
    {Coordinate{4.86109, 47.3351}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096853
    {Coordinate{8.06109, 47.5595}, Tz::Europe_Zurich, CountryId{"CH"}}, // Laufenburg railway station
    {Coordinate{1.41599, 45.1321}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Larche
    {Coordinate{7.50263, 47.4193}, Tz::Europe_Zurich, CountryId{"CH"}}, // Laufen railway station
    {Coordinate{0.965004, 46.3381}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096858
    {Coordinate{7.75986, 47.4702}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096861
    {Coordinate{2.27008, 46.3213}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096862
    {Coordinate{6.62611, 46.5233}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lausanne-Chauderon railway station
    {Coordinate{2.08912, 46.0795}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096864
    {Coordinate{1.81235, 43.7034}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096865
    {Coordinate{3.90531, 45.1214}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096866
    {Coordinate{7.91366, 48.5585}, Tz::Europe_Berlin, CountryId{"DE"}}, // Legelshurst
    {Coordinate{4.66718, 45.8218}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096871
    {Coordinate{4.68213, 45.8164}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096872
    {Coordinate{4.22112, 50.7147}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lembeek railway station
    {Coordinate{3.9034, 50.559}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lens railway station
    {Coordinate{2.82786, 50.4267}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lens
    {Coordinate{-0.755093, 45.2038}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096876
    {Coordinate{3.83734, 50.1837}, Tz::Europe_Paris, CountryId{"FR"}}, // Leval
    {Coordinate{4.26728, 47.2138}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096879
    {Coordinate{7.73148, 47.4844}, Tz::Europe_Zurich, CountryId{"CH"}}, // Liestal railway station
    {Coordinate{7.65969, 48.4609}, Tz::Europe_Paris, CountryId{"FR"}}, // Limersheim
    {Coordinate{1.747, 48.9843}, Tz::Europe_Paris, CountryId{"FR"}}, // Limay
    {Coordinate{1.04957, 47.4501}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096886
    {Coordinate{4.36583, 50.6453}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lillois railway station
    {Coordinate{0.977793, 45.1563}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Limeyrat
    {Coordinate{6.06177, 48.7494}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096893
    {Coordinate{3.19445, 51.2947}, Tz::Europe_Brussels, CountryId{"BE"}}, // Lissewege railway station
    {Coordinate{-1.0504, 49.227}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lison
    {Coordinate{2.85918, 50.4402}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096897
    {Coordinate{2.79323, 50.4379}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096902
    {Coordinate{2.71755, 49.3425}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096904
    {Coordinate{2.00278, 50.0117}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Longpré-les-Corps-Saints
    {Coordinate{3.01701, 50.6128}, Tz::Europe_Paris, CountryId{"FR"}}, // Station Loos-lez-Lille
    {Coordinate{5.21741, 46.6309}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096907
    {Coordinate{2.98486, 46.2241}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096909
    {Coordinate{-3.36611, 47.7553}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lorient
    {Coordinate{3.89146, 44.6541}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096912
    {Coordinate{3.74583, 47.6281}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096916
    {Coordinate{5.45472, 44.6136}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096917
    {Coordinate{6.17088, 48.6221}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096918
    {Coordinate{4.78323, 49.7331}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096919
    {Coordinate{3.19475, 43.7093}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096920
    {Coordinate{4.09352, 43.6811}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096922
    {Coordinate{7.11906, 48.0355}, Tz::Europe_Paris, CountryId{"FR"}}, // Luttenbach-près-Munster station
    {Coordinate{0.718649, 46.4052}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096925
    {Coordinate{7.27704, 47.7582}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Lutterbach
    {Coordinate{3.96939, 46.7942}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096928
    {Coordinate{-1.16738, 46.4638}, Tz::Europe_Paris, CountryId{"FR"}}, // Luçon
    {Coordinate{7.85636, 47.3921}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096933
    {Coordinate{5.53847, 48.797}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096935
    {Coordinate{-0.619829, 45.0041}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096944
    {Coordinate{7.65917, 47.6011}, Tz::Europe_Berlin, CountryId{"DE"}}, // Lörrach-Stetten
    {Coordinate{6.32809, 46.2513}, Tz::Europe_Paris, CountryId{"FR"}}, // Machilly
    {Coordinate{-1.8225, 46.99}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Machecoul
    {Coordinate{3.22948, 43.4676}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Magalas
    {Coordinate{6.62157, 46.0169}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096951
    {Coordinate{3.73373, 49.31}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096953
    {Coordinate{2.60282, 46.4642}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096954
    {Coordinate{1.28105, 48.3343}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096955
    {Coordinate{6.15845, 49.2155}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096957
    {Coordinate{0.58302, 47.0533}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096962
    {Coordinate{2.42639, 48.8019}, Tz::Europe_Paris, CountryId{"FR"}}, // Maisons-Alfort – Alfortville
    {Coordinate{6.94145, 43.5239}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096964
    {Coordinate{4.47935, 43.8264}, Tz::Europe_Paris, CountryId{"FR"}}, // Manduel - Redessan
    {Coordinate{4.32671, 47.1325}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096967
    {Coordinate{6.10937, 48.8021}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096968
    {Coordinate{-1.00138, 46.3042}, Tz::Europe_Paris, CountryId{"FR"}}, // Marans Station
    {Coordinate{3.40301, 49.4393}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096971
    {Coordinate{-0.685424, 45.0359}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Margaux
    {Coordinate{2.58167, 49.8533}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marcelcave
    {Coordinate{1.93069, 50.408}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096975
    {Coordinate{6.50785, 46.0888}, Tz::Europe_Paris, CountryId{"FR"}}, // Marignier
    {Coordinate{5.07319, 46.0639}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marlieux - Châtillon
    {Coordinate{-0.428446, 46.1991}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096978
    {Coordinate{4.36029, 46.8335}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096980
    {Coordinate{2.28264, 47.1}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096981
    {Coordinate{1.5856, 46.0942}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096983
    {Coordinate{0.168031, 44.5032}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marmande
    {Coordinate{7.07912, 46.1058}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3096986
    {Coordinate{2.02659, 43.9151}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Marssac-sur-Tarn
    {Coordinate{3.28101, 44.5447}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096989
    {Coordinate{2.69816, 50.3225}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3096993
    {Coordinate{-1.91417, 47.6744}, Tz::Europe_Paris, CountryId{"FR"}}, // Massérac
    {Coordinate{7.61969, 48.3989}, Tz::Europe_Paris, CountryId{"FR"}}, // Matzenheim
    {Coordinate{0.265901, 47.7601}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097004
    {Coordinate{2.05987, 48.9872}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097005
    {Coordinate{2.7013, 50.4606}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097006
    {Coordinate{0.789937, 44.8558}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mauzac
    {Coordinate{2.87371, 48.958}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Meaux
    {Coordinate{1.40564, 47.6451}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097014
    {Coordinate{3.50188, 44.5223}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097015
    {Coordinate{3.11407, 50.7996}, Tz::Europe_Brussels, CountryId{"BE"}}, // Menen railway station
    {Coordinate{1.50622, 47.706}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097018
    {Coordinate{7.51694, 43.785}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Menton-Garavan
    {Coordinate{5.17938, 46.7989}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097025
    {Coordinate{6.1379, 48.6129}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097027
    {Coordinate{4.24493, 46.8629}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097030
    {Coordinate{7.07322, 48.0132}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Metzeral
    {Coordinate{3.00639, 47.2422}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mesves-Bulcy
    {Coordinate{6.28366, 49.3181}, Tz::Europe_Paris, CountryId{"FR"}}, // Station Metzervisse
    {Coordinate{6.16795, 49.1369}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Metz-Nord
    {Coordinate{2.89319, 50.4973}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097035
    {Coordinate{1.90199, 49.0055}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Meulan - Hardricourt
    {Coordinate{4.7945, 46.9677}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097037
    {Coordinate{3.07437, 44.1024}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097038
    {Coordinate{4.30323, 43.7886}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097039
    {Coordinate{0.918035, 45.1291}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Milhac-d'Auberoche
    {Coordinate{4.91961, 45.8968}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097042
    {Coordinate{5.60003, 50.6928}, Tz::Europe_Brussels, CountryId{"BE"}}, // Milmort railway station
    {Coordinate{4.95388, 45.8221}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097047
    {Coordinate{5.56492, 45.3241}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097052
    {Coordinate{4.16023, 44.2593}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097055
    {Coordinate{4.73327, 49.7527}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mohon
    {Coordinate{3.64988, 44.9697}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monistrol-d'Allier
    {Coordinate{7.50009, 48.5373}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Molsheim
    {Coordinate{0.793249, 47.4988}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monnaie
    {Coordinate{5.63391, 44.9119}, Tz::Europe_Paris, CountryId{"FR"}}, // Monestier-de-Clermont
    {Coordinate{1.73394, 46.1368}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097064
    {Coordinate{-1.31635, 46.9838}, Tz::Europe_Paris, CountryId{"FR"}}, // Montaigu
    {Coordinate{0.190705, 48.1513}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097066
    {Coordinate{0.721381, 47.2917}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097067
    {Coordinate{3.94172, 50.454}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mons railway station
    {Coordinate{4.03884, 49.194}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097070
    {Coordinate{4.48151, 46.7593}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097072
    {Coordinate{4.36105, 46.6706}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097073
    {Coordinate{-0.198324, 43.1271}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montaut-Bétharram
    {Coordinate{4.74069, 49.8657}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Monthermé
    {Coordinate{1.57771, 43.4752}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097081
    {Coordinate{5.37162, 49.5229}, Tz::Europe_Paris, CountryId{"FR"}}, // Montmédy
    {Coordinate{0.817277, 47.3915}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097083
    {Coordinate{2.73861, 48.3364}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montigny-sur-Loing
    {Coordinate{3.10969, 43.8685}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097085
    {Coordinate{6.04313, 45.5031}, Tz::Europe_Paris, CountryId{"FR"}}, // Montmélian
    {Coordinate{3.92629, 43.5961}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097089
    {Coordinate{-0.148103, 47.1253}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montreuil-Bellay
    {Coordinate{0.159355, 45.0062}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montpon-Ménestérol
    {Coordinate{7.05087, 47.8607}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097098
    {Coordinate{-0.4181, 47.739}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097100
    {Coordinate{0.6547, 47.2818}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097101
    {Coordinate{4.74472, 44.5592}, Tz::Europe_Paris, CountryId{"FR"}}, // Montélimar railway station
    {Coordinate{1.33444, 49.6031}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Montérolier-Buchy
    {Coordinate{6.65936, 48.9365}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Morhange
    {Coordinate{4.90834, 43.9414}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097106
    {Coordinate{7.034, 45.7572}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3097107
    {Coordinate{1.24778, 49.5233}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Morgny
    {Coordinate{4.2471, 50.4585}, Tz::Europe_Brussels, CountryId{"BE"}}, // Morlanwelz railway station
    {Coordinate{8.16164, 48.9347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097112
    {Coordinate{-0.744705, 45.084}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097116
    {Coordinate{6.97417, 43.6206}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mouans-Sartoux
    {Coordinate{4.31778, 49.1313}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097119
    {Coordinate{2.47333, 48.5861}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097121
    {Coordinate{7.08774, 48.0246}, Tz::Europe_Paris, CountryId{"FR"}}, // Muhlbach-sur-Munster station
    {Coordinate{3.22806, 50.74}, Tz::Europe_Brussels, CountryId{"BE"}}, // Mouscron railway station
    {Coordinate{6.53139, 45.4864}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Moûtiers-Salins-Brides-les-Bains
    {Coordinate{7.9098, 47.5475}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mumpf railway station
    {Coordinate{8.14112, 48.924}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097133
    {Coordinate{7.33125, 47.7363}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mulhouse-Hasenrain
    {Coordinate{7.15278, 48.0391}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097135
    {Coordinate{7.13416, 48.0383}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Munster
    {Coordinate{2.86964, 45.109}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Murat
    {Coordinate{7.64806, 47.5336}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muttenz
    {Coordinate{0.353911, 45.0345}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mussidan
    {Coordinate{1.60103, 48.9666}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097141
    {Coordinate{1.15058, 43.6367}, Tz::Europe_Paris, CountryId{"FR"}}, // Mérenvielle train station
    {Coordinate{1.83667, 42.6589}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Mérens-les-Vals
    {Coordinate{2.13278, 49.2319}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Méru
    {Coordinate{7.83403, 47.5619}, Tz::Europe_Zurich, CountryId{"CH"}}, // Möhlin railway station
    {Coordinate{7.59935, 47.8101}, Tz::Europe_Berlin, CountryId{"DE"}}, // Müllheim (Baden) station
    {Coordinate{7.61727, 47.5132}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münchenstein
    {Coordinate{2.19083, 49.0578}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Méry-sur-Oise
    {Coordinate{18.9554, 47.3852}, Tz::Europe_Budapest, CountryId{"HU"}}, // Tétényliget railway station
    {Coordinate{18.9741, 47.3981}, Tz::Europe_Budapest, CountryId{"HU"}}, // Nagytétény-Diósd railway station
    {Coordinate{4.99756, 50.4701}, Tz::Europe_Brussels, CountryId{"BE"}}, // Namêche railway station
    {Coordinate{5.29118, 48.7181}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097170
    {Coordinate{4.92981, 50.4196}, Tz::Europe_Brussels, CountryId{"BE"}}, // Naninne railway station
    {Coordinate{1.15638, 46.0056}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097172
    {Coordinate{2.3635, 44.1855}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Naucelle
    {Coordinate{7.56194, 47.8115}, Tz::Europe_Berlin, CountryId{"DE"}}, // Neuenburg
    {Coordinate{5.45265, 49.8541}, Tz::Europe_Brussels, CountryId{"BE"}}, // Neufchâteau railway station
    {Coordinate{5.74167, 50.5719}, Tz::Europe_Brussels, CountryId{"BE"}}, // Nessonvaux railway station
    {Coordinate{1.64327, 50.6237}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097187
    {Coordinate{5.11176, 47.2815}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097188
    {Coordinate{0.564776, 47.5579}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Neuillé-Pont-Pierre
    {Coordinate{6.10789, 48.6148}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097192
    {Coordinate{0.199639, 48.0704}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097193
    {Coordinate{3.1638, 47.0069}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097195
    {Coordinate{0.445105, 45.0999}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Neuvic
    {Coordinate{3.14669, 47.0056}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097197
    {Coordinate{7.28687, 43.7153}, Tz::Europe_Paris, CountryId{"FR"}}, // Nice-Saint-Roch
    {Coordinate{7.21642, 43.6708}, Tz::Europe_Paris, CountryId{"FR"}}, // Nice-Saint-Augustin
    {Coordinate{3.11667, 43.2956}, Tz::Europe_Paris, CountryId{"FR"}}, // Nissan
    {Coordinate{0.896264, 47.4098}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097215
    {Coordinate{0.219734, 48.7039}, Tz::Europe_Paris, CountryId{"FR"}}, // Nonant-le-Pin
    {Coordinate{1.19297, 48.7757}, Tz::Europe_Paris, CountryId{"FR"}}, // Nonancourt Station
    {Coordinate{0.706985, 47.4597}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097220
    {Coordinate{6.46863, 45.5393}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097221
    {Coordinate{4.79484, 49.6972}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097227
    {Coordinate{2.0329, 47.5346}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Nouan-le-Fuzelier
    {Coordinate{0.098211, 47.8745}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097229
    {Coordinate{4.20732, 43.976}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097231
    {Coordinate{4.95618, 47.1305}, Tz::Europe_Paris, CountryId{"FR"}}, // Nuits-Saint-Georges train station
    {Coordinate{1.70471, 50.1874}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Noyelles
    {Coordinate{7.47114, 45.7389}, Tz::Europe_Rome, CountryId{"IT"}}, // Q3097235
    {Coordinate{0.861185, 45.346}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Négrondes
    {Coordinate{2.67438, 50.4831}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097237
    {Coordinate{1.84069, 48.9388}, Tz::Europe_Paris, CountryId{"FR"}}, // Nézel - Aulnay
    {Coordinate{5.73382, 48.6967}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097240
    {Coordinate{3.21677, 45.6143}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097244
    {Coordinate{4.11372, 46.4473}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Paray-le-Monial
    {Coordinate{-0.619498, 44.9441}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097246
    {Coordinate{1.61944, 43.1161}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pamiers
    {Coordinate{2.17469, 46.1984}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097250
    {Coordinate{-0.755093, 45.2038}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097256
    {Coordinate{3.50045, 45.2102}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097258
    {Coordinate{7.38, 43.7919}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097259
    {Coordinate{7.36677, 43.7679}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097260
    {Coordinate{6.22245, 49.0736}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097261
    {Coordinate{0.950467, 49.564}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pavilly-Station
    {Coordinate{-3.13306, 47.5581}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Penthièvre
    {Coordinate{2.26542, 44.9203}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097265
    {Coordinate{7.29994, 49.0494}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Petit-Réderching
    {Coordinate{1.14105, 47.8674}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097269
    {Coordinate{6.12416, 48.5489}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097271
    {Coordinate{2.33417, 48.6756}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097273
    {Coordinate{4.28879, 50.4349}, Tz::Europe_Brussels, CountryId{"BE"}}, // Piéton railway station
    {Coordinate{-1.85075, 48.5316}, Tz::Europe_Paris, CountryId{"FR"}}, // Plerguer
    {Coordinate{1.96001, 48.8308}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097278
    {Coordinate{-3.11837, 47.6043}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Plouharnel-Carnac
    {Coordinate{-3.37059, 48.4583}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097284
    {Coordinate{-0.359057, 44.649}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Podensac
    {Coordinate{5.47378, 45.2559}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097293
    {Coordinate{-1.1265, 49.1625}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097295
    {Coordinate{6.10288, 48.6025}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097296
    {Coordinate{4.13739, 45.2599}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-de-Lignon
    {Coordinate{3.13059, 50.6239}, Tz::Europe_Paris, CountryId{"FR"}}, // Pont-de-Bois
    {Coordinate{2.86296, 50.4159}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097301
    {Coordinate{3.49049, 45.8428}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097303
    {Coordinate{2.87515, 50.4714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097306
    {Coordinate{3.20175, 48.2863}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pont-sur-Yonne
    {Coordinate{4.77277, 46.2131}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pontanevaux
    {Coordinate{4.49287, 45.8714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097312
    {Coordinate{3.16003, 45.9398}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097317
    {Coordinate{2.54444, 48.535}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ponthierry - Pringy
    {Coordinate{7.08007, 47.4209}, Tz::Europe_Zurich, CountryId{"CH"}}, // Porrentruy
    {Coordinate{0.155535, 47.2487}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097321
    {Coordinate{-1.73944, 47.1167}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Port-Saint-Père-Saint-Mars
    {Coordinate{-2.34489, 47.2706}, Tz::Europe_Paris, CountryId{"FR"}}, // Pornichet train station
    {Coordinate{1.52338, 49.0627}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097324
    {Coordinate{4.98463, 43.4073}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097326
    {Coordinate{0.390556, 44.25}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Port-Sainte-Marie
    {Coordinate{3.09387, 47.0768}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pougues-les-Eaux
    {Coordinate{6.12664, 48.3226}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097337
    {Coordinate{2.96361, 47.2828}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Pouilly-sur-Loire
    {Coordinate{7.69131, 47.5228}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pratteln train station
    {Coordinate{7.71024, 47.5307}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pratteln Salina Raurica station
    {Coordinate{6.10076, 48.4328}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Praye-sous-Vaudémont
    {Coordinate{4.18382, 49.1987}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Prunay
    {Coordinate{-0.302356, 44.5784}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Preignac
    {Coordinate{3.46114, 50.3167}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097348
    {Coordinate{7.08556, 48.3047}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097349
    {Coordinate{1.67204, 47.3132}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097351
    {Coordinate{6.13745, 48.5361}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097353
    {Coordinate{1.97772, 45.585}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097359
    {Coordinate{0.733615, 45.1784}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Périgueux-Saint-Georges
    {Coordinate{1.73037, 43.8196}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rabastens-Couffouleux
    {Coordinate{3.68667, 50.41}, Tz::Europe_Brussels, CountryId{"BE"}}, // Quiévrain railway station
    {Coordinate{7.01245, 47.8817}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ranspach
    {Coordinate{6.9693, 43.5691}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ranguin
    {Coordinate{0.599256, 45.1659}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Razac
    {Coordinate{0.900974, 47.2181}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097388
    {Coordinate{6.26744, 46.1255}, Tz::Europe_Paris, CountryId{"FR"}}, // Reignier
    {Coordinate{6.57889, 46.5369}, Tz::Europe_Zurich, CountryId{"CH"}}, // Renens VD railway station
    {Coordinate{2.37205, 50.732}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097394
    {Coordinate{4.03614, 45.2013}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097397
    {Coordinate{4.98536, 48.8242}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Revigny
    {Coordinate{7.78361, 47.5567}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rheinfelden railway station
    {Coordinate{4.64286, 49.9387}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097401
    {Coordinate{7.76813, 47.5456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rheinfelden-Augarten railway station
    {Coordinate{7.65167, 47.5831}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riehen
    {Coordinate{7.63333, 47.5694}, Tz::Europe_Zurich, CountryId{"CH"}}, // Riehen-Niederholz
    {Coordinate{0.36192, 47.2677}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097413
    {Coordinate{5.49167, 45.3575}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rives
    {Coordinate{9.73621, 44.1007}, Tz::Europe_Rome, CountryId{"IT"}}, // Riomaggiore
    {Coordinate{4.16111, 51.4228}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Rilland-Bath railway station
    {Coordinate{4.12272, 44.2768}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097422
    {Coordinate{7.40618, 47.7487}, Tz::Europe_Paris, CountryId{"FR"}}, // Rixheim station
    {Coordinate{2.1725, 49.3989}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rochy-Condé
    {Coordinate{7.26458, 49.0554}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Rohrbach-lès-Bitche
    {Coordinate{5.23058, 43.4866}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097434
    {Coordinate{6.60315, 46.5624}, Tz::Europe_Zurich, CountryId{"CH"}}, // Romanel-sur-Lausanne railway station
    {Coordinate{2.65, 48.7956}, Tz::Europe_Paris, CountryId{"FR"}}, // Roissy-en-Brie Station
    {Coordinate{4.74221, 46.1763}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097437
    {Coordinate{31.6836, 50.2533}, Tz::Europe_Kiev, CountryId{"UA"}}, // Zasupoivka
    {Coordinate{5.04899, 45.0488}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097440
    {Coordinate{8.06212, 48.8512}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097443
    {Coordinate{7.49132, 48.5051}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097445
    {Coordinate{3.07822, 50.6044}, Tz::Europe_Paris, CountryId{"FR"}}, // Ronchin
    {Coordinate{7.20744, 48.4593}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097449
    {Coordinate{1.44, 43.635}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Route-de-Launaguet
    {Coordinate{8.01181, 48.8204}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097451
    {Coordinate{-1.01648, 45.6259}, Tz::Europe_Paris, CountryId{"FR"}}, // Royan
    {Coordinate{5.70547, 48.1209}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097455
    {Coordinate{4.76091, 46.8804}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097459
    {Coordinate{2.15811, 50.8619}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097461
    {Coordinate{0.190038, 46.0307}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Ruffec
    {Coordinate{19.112, 47.5658}, Tz::Europe_Budapest, CountryId{"HU"}}, // Rákospalota-Újpest railway station
    {Coordinate{5.63469, 45.3689}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097466
    {Coordinate{4.21506, 45.9878}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097467
    {Coordinate{8.02996, 48.8335}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097470
    {Coordinate{7.85061, 47.4254}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097471
    {Coordinate{3.87891, 46.502}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097475
    {Coordinate{1.38378, 47.2869}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097477
    {Coordinate{2.48575, 46.7265}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Amand-Montrond - Orval train station
    {Coordinate{1.012, 47.6932}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097480
    {Coordinate{7.0287, 47.8729}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Amarin
    {Coordinate{4.19339, 44.2596}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Ambroix
    {Coordinate{4.94883, 45.9258}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-André-de-Corcy
    {Coordinate{-0.440411, 44.991}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097485
    {Coordinate{-0.019098, 45.1573}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097487
    {Coordinate{0.616408, 47.5038}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Antoine-du-Rocher
    {Coordinate{3.04744, 50.6544}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-André
    {Coordinate{3.96332, 43.6354}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Aunès
    {Coordinate{1.336, 48.447}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097495
    {Coordinate{3.13942, 46.1484}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097496
    {Coordinate{1.74991, 47.8631}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097498
    {Coordinate{4.02765, 43.6607}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Brès - Mudaison
    {Coordinate{4.51709, 45.4724}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097503
    {Coordinate{5.73183, 45.504}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Béron - La Bridoire
    {Coordinate{3.27094, 44.8017}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097505
    {Coordinate{4.32786, 43.8135}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Césaire
    {Coordinate{1.55132, 45.789}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097510
    {Coordinate{1.0435, 44.8633}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Cyprien
    {Coordinate{1.66644, 44.9459}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Denis-près-Martel
    {Coordinate{3.10621, 45.0347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097518
    {Coordinate{6.94844, 48.282}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097519
    {Coordinate{4.85252, 45.7058}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097522
    {Coordinate{3.73093, 47.9808}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097523
    {Coordinate{0.590995, 47.3709}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097524
    {Coordinate{3.49471, 45.1605}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097525
    {Coordinate{2.98358, 44.0659}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097526
    {Coordinate{4.71873, 46.0621}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097531
    {Coordinate{2.07034, 48.8955}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-en-Laye-Bel-Air
    {Coordinate{7.25396, 48.0714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097534
    {Coordinate{3.81924, 50.4426}, Tz::Europe_Brussels, CountryId{"BE"}}, // Saint-Ghislain railway station
    {Coordinate{4.21481, 43.9502}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097537
    {Coordinate{4.37943, 49.0561}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097539
    {Coordinate{2.07306, 48.9031}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Germain-en-Laye Grande-Ceinture
    {Coordinate{5.24389, 45.0714}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097541
    {Coordinate{-1.86444, 47.1053}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Hilaire-de-Chaléons
    {Coordinate{2.28514, 48.9638}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Gratien
    {Coordinate{-1.94972, 46.7161}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Hilaire-de-Riez
    {Coordinate{6.35475, 45.2777}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Jean de Maurienne - Vallée de l'Arvan
    {Coordinate{4.19293, 44.2116}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Julien - les Fumades, railway station
    {Coordinate{4.19305, 43.6393}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097554
    {Coordinate{4.62865, 46.8484}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097559
    {Coordinate{0.492212, 45.1233}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Léon-sur-l'Isle
    {Coordinate{-0.433028, 44.9224}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Loubès
    {Coordinate{4.97754, 45.9504}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Marcel-en-Dombes
    {Coordinate{5.32361, 45.1508}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097567
    {Coordinate{2.81573, 48.3823}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097570
    {Coordinate{4.80021, 43.6222}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Martin-de-Crau Station
    {Coordinate{0.905813, 47.3551}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097573
    {Coordinate{1.37175, 43.5998}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097574
    {Coordinate{1.16167, 49.4708}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Martin-du-Vivier
    {Coordinate{-0.048805, 45.0155}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Médard-de-Guizières
    {Coordinate{1.99694, 49.5303}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Omer-en-Chaussée
    {Coordinate{0.478296, 47.6042}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097584
    {Coordinate{-2.21171, 47.2866}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Nazaire railway station
    {Coordinate{2.12778, 49.0342}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Ouen-l'Aumône – Liesse
    {Coordinate{0.309789, 47.2856}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097590
    {Coordinate{2.10361, 49.04}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Ouen-l'Aumône – Quartier de l'Église
    {Coordinate{5.12808, 46.1}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097592
    {Coordinate{-3.13889, 47.5211}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Pierre-Quiberon
    {Coordinate{6.37584, 46.0593}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-en-Faucigny
    {Coordinate{3.11152, 46.7933}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097600
    {Coordinate{0.0407615, 49.0232}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Pierre-sur-Dives
    {Coordinate{1.40028, 45.8872}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097608
    {Coordinate{0.723611, 47.3861}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Pierre-des-Corps
    {Coordinate{4.54231, 45.8616}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Romain-de-Popey
    {Coordinate{2.96738, 44.014}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097612
    {Coordinate{4.93515, 43.9531}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097613
    {Coordinate{4.81043, 45.2977}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097619
    {Coordinate{2.04444, 48.7872}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Quentin-en-Yvelines
    {Coordinate{4.33781, 46.8442}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097621
    {Coordinate{-0.002079, 45.0114}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Seurin-sur-l'Isle
    {Coordinate{1.68056, 43.775}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Sulpice-sur-Tarn
    {Coordinate{1.54664, 46.3861}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097625
    {Coordinate{7.16588, 47.3677}, Tz::Europe_Zurich, CountryId{"CH"}}, // Saint-Ursanne
    {Coordinate{-3.9486, 48.4942}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097628
    {Coordinate{4.28121, 46.0026}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097633
    {Coordinate{3.91867, 45.1493}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097634
    {Coordinate{-1.78564, 47.2748}, Tz::Europe_Paris, CountryId{"FR"}}, // Saint-Étienne-de-Montluc
    {Coordinate{-0.159258, 44.8811}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saint-Émilion
    {Coordinate{5.67114, 45.2351}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Saint-Égrève-Saint-Robert
    {Coordinate{4.37828, 45.4371}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097638
    {Coordinate{3.97587, 44.2556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097639
    {Coordinate{-0.493989, 44.8978}, Tz::Europe_Paris, CountryId{"FR"}}, // Sainte-Eulalie - Carbon-Blanc
    {Coordinate{6.26575, 46.8791}, Tz::Europe_Paris, CountryId{"FR"}}, // Sainte-Colombe
    {Coordinate{0.22143, 44.8368}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097642
    {Coordinate{0.092329, 44.5332}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sainte-Bazeille
    {Coordinate{4.90385, 49.0899}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sainte-Menehould
    {Coordinate{-1.81444, 47.105}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sainte-Pazanne
    {Coordinate{2.0105, 42.4412}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097651
    {Coordinate{4.15336, 44.1732}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097652
    {Coordinate{2.8556, 50.4223}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097654
    {Coordinate{-0.617596, 45.7487}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saintes
    {Coordinate{6.33937, 49.0447}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097665
    {Coordinate{3.16843, 45.7383}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097675
    {Coordinate{7.03604, 49.0007}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sarralbe
    {Coordinate{4.94938, 50.4065}, Tz::Europe_Brussels, CountryId{"BE"}}, // Sart-Bernard railway station
    {Coordinate{6.03767, 46.2143}, Tz::Europe_Zurich, CountryId{"CH"}}, // Satigny
    {Coordinate{4.8748, 45.8199}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097685
    {Coordinate{-1.19018, 43.6603}, Tz::Europe_Paris, CountryId{"FR"}}, // Saubusse-les-Bains
    {Coordinate{-0.654491, 47.3815}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097691
    {Coordinate{-0.071293, 47.2689}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saumur
    {Coordinate{1.01156, 44.5894}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sauveterre-la-Lémance
    {Coordinate{0.543884, 47.3606}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Savonnières
    {Coordinate{2.55753, 50.3538}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097698
    {Coordinate{1.57028, 43.2394}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Saverdun
    {Coordinate{2.2975, 48.7811}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097701
    {Coordinate{7.43027, 48.2869}, Tz::Europe_Paris, CountryId{"FR"}}, // Scherwiller
    {Coordinate{7.82276, 47.6479}, Tz::Europe_Berlin, CountryId{"DE"}}, // Schopfheim station
    {Coordinate{7.74263, 48.8288}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097710
    {Coordinate{8.09841, 48.8967}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097711
    {Coordinate{1.92217, 47.3884}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097715
    {Coordinate{4.87449, 46.6407}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sennecey-le-Grand
    {Coordinate{4.25695, 49.1512}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Sept-Saulx
    {Coordinate{7.98924, 48.7963}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097722
    {Coordinate{3.95806, 50.9853}, Tz::Europe_Brussels, CountryId{"BE"}}, // Serskamp railway station
    {Coordinate{6.76403, 45.924}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097727
    {Coordinate{5.15129, 46.9964}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Seurre
    {Coordinate{2.52417, 48.9472}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097731
    {Coordinate{4.14411, 49.2034}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Sillery
    {Coordinate{7.53277, 46.292}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sierre/Siders train station
    {Coordinate{4.33108, 50.8635}, Tz::Europe_Brussels, CountryId{"BE"}}, // Simonis railway station
    {Coordinate{4.07228, 47.2559}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097747
    {Coordinate{5.42608, 43.4347}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097749
    {Coordinate{7.81214, 47.4627}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097750
    {Coordinate{5.94502, 44.1927}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097754
    {Coordinate{21.4458, 41.9912}, Tz::Europe_Skopje, CountryId{"MK"}}, // Skopje Main railway station
    {Coordinate{7.85168, 47.439}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097761
    {Coordinate{6.04643, 43.1908}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097763
    {Coordinate{3.27741, 50.3556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097764
    {Coordinate{4.87576, 44.0053}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097765
    {Coordinate{7.45383, 43.8764}, Tz::Europe_Paris, CountryId{"FR"}}, // Sospel railway station
    {Coordinate{3.93949, 50.2656}, Tz::Europe_Paris, CountryId{"FR"}}, // Sous-le-Bois
    {Coordinate{-1.11763, 45.5082}, Tz::Europe_Paris, CountryId{"FR"}}, // Soulac-sur-Mer
    {Coordinate{2.39201, 48.9545}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097772
    {Coordinate{7.74173, 47.6415}, Tz::Europe_Berlin, CountryId{"DE"}}, // Steinen station
    {Coordinate{7.70452, 48.7176}, Tz::Europe_Paris, CountryId{"FR"}}, // Stephansfeld
    {Coordinate{-1.53006, 47.3433}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097782
    {Coordinate{6.66582, 46.655}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sugnens railway station
    {Coordinate{4.54387, 49.1201}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097790
    {Coordinate{2.52611, 49.0994}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097800
    {Coordinate{1.45463, 47.6807}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097803
    {Coordinate{0.134453, 48.6648}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Surdon
    {Coordinate{6.61065, 46.5247}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lausanne-Sébeillon railway station
    {Coordinate{1.76406, 49.3574}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097810
    {Coordinate{5.33993, 43.3624}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097816
    {Coordinate{-2.07292, 47.55}, Tz::Europe_Paris, CountryId{"FR"}}, // Sévérac
    {Coordinate{1.66894, 48.8295}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097822
    {Coordinate{6.12898, 48.4838}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097834
    {Coordinate{4.43901, 45.8899}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097836
    {Coordinate{4.75848, 45.7616}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097842
    {Coordinate{7.88759, 47.4456}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097843
    {Coordinate{0.19134, 48.1813}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097844
    {Coordinate{3.17587, 50.5288}, Tz::Europe_Paris, CountryId{"FR"}}, // Templeuve
    {Coordinate{1.30037, 45.1358}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Terrasson
    {Coordinate{7.10107, 47.8097}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097850
    {Coordinate{4.94733, 51.0097}, Tz::Europe_Brussels, CountryId{"BE"}}, // Testelt railway station
    {Coordinate{3.29742, 49.6592}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tergnier
    {Coordinate{2.04414, 47.3142}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097853
    {Coordinate{6.8104, 48.4138}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thiaville
    {Coordinate{1.06871, 45.1602}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thenon
    {Coordinate{4.62312, 47.4945}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097858
    {Coordinate{3.57928, 46.5263}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097859
    {Coordinate{4.09778, 50.47}, Tz::Europe_Brussels, CountryId{"BE"}}, // Thieu railway station
    {Coordinate{0.921229, 45.4191}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Thiviers
    {Coordinate{6.93682, 43.5135}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Théoule-sur-Mer
    {Coordinate{1.31207, 47.3223}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097869
    {Coordinate{2.88181, 49.4753}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097870
    {Coordinate{-0.469594, 47.6176}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097874
    {Coordinate{2.43593, 49.8117}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097876
    {Coordinate{5.42306, 51.8894}, Tz::Europe_Amsterdam, CountryId{"NL"}}, // Tiel railway station
    {Coordinate{-1.0939, 47.0328}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Torfou - Le Longeron - Tiffauges
    {Coordinate{3.01667, 43.9697}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097889
    {Coordinate{1.42858, 43.646}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Toulouse-Lalande-Église
    {Coordinate{7.36439, 43.847}, Tz::Europe_Paris, CountryId{"FR"}}, // Touët-de-L'Escarène railway halt
    {Coordinate{4.90641, 46.5667}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097896
    {Coordinate{7.90433, 47.366}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3097902
    {Coordinate{0.885009, 44.4431}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Trentels-Ladignac
    {Coordinate{-3.17426, 48.6246}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097907
    {Coordinate{3.05417, 47.1136}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Tronsanges
    {Coordinate{5.49222, 45.3011}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097910
    {Coordinate{0.316481, 47.6708}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097913
    {Coordinate{4.22213, 49.1781}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097915
    {Coordinate{4.06029, 43.6728}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097921
    {Coordinate{5.96732, 46.1094}, Tz::Europe_Paris, CountryId{"FR"}}, // Valleiry
    {Coordinate{4.89278, 44.9281}, Tz::Europe_Paris, CountryId{"FR"}}, // Valence-Ville railway station
    {Coordinate{6.31319, 48.6354}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097932
    {Coordinate{-1.01971, 47.3745}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097933
    {Coordinate{6.37031, 46.7126}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vallorbe railway station
    {Coordinate{4.27001, 43.6951}, Tz::Europe_Paris, CountryId{"FR"}}, // Vauvert
    {Coordinate{2.19222, 48.7589}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097938
    {Coordinate{1.70611, 44.95}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vayrac
    {Coordinate{2.98841, 49.2339}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097940
    {Coordinate{3.40977, 49.4741}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097941
    {Coordinate{0.734941, 47.2916}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097944
    {Coordinate{4.9276, 47.3267}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097947
    {Coordinate{-0.317135, 44.8972}, Tz::Europe_Paris, CountryId{"FR"}}, // Vayres
    {Coordinate{1.06782, 47.8021}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vendôme
    {Coordinate{4.21894, 43.7398}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097953
    {Coordinate{3.73202, 47.6606}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097954
    {Coordinate{4.66957, 47.4388}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Verrey
    {Coordinate{0.929162, 48.7427}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Verneuil-sur-Avre
    {Coordinate{3.8933, 49.83}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vervins
    {Coordinate{3.42537, 43.3158}, Tz::Europe_Paris, CountryId{"FR"}}, // Vias
    {Coordinate{3.2069, 45.6657}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097970
    {Coordinate{3.79936, 43.5007}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097971
    {Coordinate{5.90936, 50.2787}, Tz::Europe_Brussels, CountryId{"BE"}}, // Vielsalm railway station
    {Coordinate{2.36833, 49.1169}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Viarmes
    {Coordinate{5.1242, 48.2702}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097983
    {Coordinate{7.13322, 47.8019}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vieux-Thann-ZI
    {Coordinate{5.02833, 46.0043}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097985
    {Coordinate{1.51511, 45.3829}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vigeois
    {Coordinate{1.71457, 43.3984}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097993
    {Coordinate{3.92396, 44.4395}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097995
    {Coordinate{3.84986, 43.5437}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3097997
    {Coordinate{3.24688, 46.6591}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villeneuve-sur-Allier
    {Coordinate{3.28673, 48.085}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098001
    {Coordinate{1.66067, 43.4332}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098002
    {Coordinate{6.92695, 46.3984}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villeneuve railway station
    {Coordinate{5.34773, 47.2068}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098006
    {Coordinate{2.34183, 48.9595}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villetaneuse-Université
    {Coordinate{2.48954, 49.2824}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098011
    {Coordinate{2.82301, 50.3731}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098013
    {Coordinate{5.41011, 45.2079}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098014
    {Coordinate{3.6286, 47.7041}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098015
    {Coordinate{1.87731, 48.8154}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Villiers - Neauphle - Pontchartrain
    {Coordinate{2.41639, 48.9936}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098018
    {Coordinate{5.65373, 45.8482}, Tz::Europe_Paris, CountryId{"FR"}}, // Virieu-le-Grand - Belley
    {Coordinate{2.17145, 48.8007}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Viroflay-Rive-Gauche
    {Coordinate{2.52766, 42.6481}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Vinça
    {Coordinate{5.51935, 49.5605}, Tz::Europe_Brussels, CountryId{"BE"}}, // Virton railway station
    {Coordinate{0.144769, 48.2302}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098027
    {Coordinate{2.40222, 48.8006}, Tz::Europe_Paris, CountryId{"FR"}}, // Vitry-sur-Seine
    {Coordinate{7.56305, 44.1126}, Tz::Europe_Paris, CountryId{"FR"}}, // Viévola railway station
    {Coordinate{0.085364, 47.9304}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098033
    {Coordinate{5.59466, 45.3639}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Voiron
    {Coordinate{3.91143, 45.1829}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098038
    {Coordinate{3.78044, 47.5614}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098040
    {Coordinate{2.59889, 48.515}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098041
    {Coordinate{4.97159, 47.1756}, Tz::Europe_Paris, CountryId{"FR"}}, // Vougeot - Gilly-lès-Cîteaux train station
    {Coordinate{5.12385, 48.2365}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098043
    {Coordinate{4.84402, 49.701}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098045
    {Coordinate{3.72042, 49.7262}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098046
    {Coordinate{0.819882, 47.3715}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098047
    {Coordinate{6.10061, 48.4807}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098048
    {Coordinate{7.23369, 48.0582}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098050
    {Coordinate{3.03989, 50.6815}, Tz::Europe_Paris, CountryId{"FR"}}, // Wambrechies
    {Coordinate{3.31139, 50.1339}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de Wambaix
    {Coordinate{7.60861, 47.5936}, Tz::Europe_Berlin, CountryId{"DE"}}, // Weil am Rhein
    {Coordinate{7.61622, 47.5887}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q3098066
    {Coordinate{7.62707, 47.589}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q3098067
    {Coordinate{2.20776, 50.8258}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098068
    {Coordinate{3.05189, 50.5798}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098070
    {Coordinate{6.99769, 47.8899}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098076
    {Coordinate{4.74749, 50.956}, Tz::Europe_Brussels, CountryId{"BE"}}, // Wezemaal railway station
    {Coordinate{7.20956, 48.0463}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098081
    {Coordinate{7.06893, 47.8429}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098082
    {Coordinate{6.15596, 49.1489}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098088
    {Coordinate{7.19055, 49.0948}, Tz::Europe_Paris, CountryId{"FR"}}, // gare de Wœlfling-lès-Sarreguemines
    {Coordinate{6.10219, 48.5698}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098095
    {Coordinate{6.20935, 49.3614}, Tz::Europe_Paris, CountryId{"FR"}}, // Yutz
    {Coordinate{19.1002, 47.512}, Tz::Europe_Budapest, CountryId{"HU"}}, // Zugló railway station
    {Coordinate{7.5302, 47.4338}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zwingen
    {Coordinate{4.98833, 51.0064}, Tz::Europe_Brussels, CountryId{"BE"}}, // Zichem railway station
    {Coordinate{6.41121, 46.6173}, Tz::Europe_Zurich, CountryId{"CH"}}, // L'Isle-Mont-la-Ville railway station
    {Coordinate{-0.477032, 44.9356}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098124
    {Coordinate{2.315, 48.8941}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de la Porte de Clichy
    {Coordinate{4.011, 50.2799}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098143
    {Coordinate{6.48215, 43.4556}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098144
    {Coordinate{3.18628, 43.7779}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098145
    {Coordinate{2.40944, 48.7825}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Ardoines
    {Coordinate{1.95547, 48.9926}, Tz::Europe_Paris, CountryId{"FR"}}, // Les Clairières de Verneuil
    {Coordinate{4.75414, 45.7774}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098153
    {Coordinate{6.16619, 46.201}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3098155
    {Coordinate{5.00195, 49.1062}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098157
    {Coordinate{3.19337, 45.6882}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098158
    {Coordinate{6.3047, 46.7525}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098161
    {Coordinate{4.46252, 47.5431}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098164
    {Coordinate{-2.00111, 47.0617}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Moutiers-en-Retz
    {Coordinate{1.64391, 44.9975}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Quatre Routes
    {Coordinate{4.91091, 45.8746}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Échets
    {Coordinate{3.16893, 43.6912}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Bousquet-d'Orb
    {Coordinate{0.857458, 45.0887}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Versannes
    {Coordinate{2.47611, 48.9322}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Blanc-Mesnil
    {Coordinate{-0.043935, 45.0941}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098178
    {Coordinate{3.26216, 45.4672}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098179
    {Coordinate{2.45056, 48.6231}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098180
    {Coordinate{3.35805, 44.481}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098182
    {Coordinate{4.23485, 43.6833}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098183
    {Coordinate{3.18871, 45.7239}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098186
    {Coordinate{-1.35121, 47.3131}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098187
    {Coordinate{4.32237, 45.3948}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098188
    {Coordinate{4.43049, 46.8078}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Creusot
    {Coordinate{6.78527, 47.0776}, Tz::Europe_Zurich, CountryId{"CH"}}, // Q3098196
    {Coordinate{6.84427, 43.4178}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098197
    {Coordinate{4.14043, 43.5371}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098203
    {Coordinate{6.72609, 47.0499}, Tz::Europe_Zurich, CountryId{"CH"}}, // Locle-Col des Roches
    {Coordinate{-0.88164, 49.2492}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098213
    {Coordinate{3.25205, 44.5089}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Monastier
    {Coordinate{0.125278, 49.4928}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Havre
    {Coordinate{-1.34678, 47.1439}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Pallet
    {Coordinate{1.8562, 48.6932}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098223
    {Coordinate{-3.47635, 48.3647}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098226
    {Coordinate{4.6862, 44.5524}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Teil
    {Coordinate{2.79508, 42.6791}, Tz::Europe_Paris, CountryId{"FR"}}, // Le Soler
    {Coordinate{6.92439, 43.4747}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098239
    {Coordinate{-1.43201, 47.9187}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Theil-de-Bretagne
    {Coordinate{-1.0652, 45.5493}, Tz::Europe_Paris, CountryId{"FR"}}, // Verdon
    {Coordinate{-0.482929, 47.5739}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3098245
    {Coordinate{6.7849, 45.8971}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare du Viaduc-Sainte-Marie
    {Coordinate{27.7386, 64.22}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Kajaani railway station
    {Coordinate{2.51707, 48.9083}, Tz::Europe_Paris, CountryId{"FR"}}, // Gargan railway station
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q31086463
    {Coordinate{}, Tz::Europe_Helsinki, CountryId{"FI"}}, // Q31087442
    {Coordinate{16.0839, 47.0417}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q31209189
    {Coordinate{6.60091, 46.5566}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Lussex halt
    {Coordinate{6.60796, 46.5921}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Ripes halt
    {Coordinate{6.60983, 46.5348}, Tz::Europe_Zurich, CountryId{"CH"}}, // Union-Prilly railway station
    {Coordinate{6.613, 46.6}, Tz::Europe_Zurich, CountryId{"CH"}}, // Étagnières halt
    {Coordinate{3.45639, 44.4821}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3126230
    {Coordinate{6.60558, 46.5785}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bel-Air LEB halt
    {Coordinate{6.60513, 46.5445}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cery − Fleur-de-Lys halt
    {Coordinate{6.68503, 46.6743}, Tz::Europe_Zurich, CountryId{"CH"}}, // Fey halt
    {Coordinate{1.53278, 43.5306}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3126240
    {Coordinate{-3.13372, 47.5465}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare de L'Isthme
    {Coordinate{7.45013, 43.7557}, Tz::Europe_Paris, CountryId{"FR"}}, // Halte de Monte-Carlo-Country-Club
    {Coordinate{6.6134, 46.53}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montétan halt
    {Coordinate{6.60741, 46.5397}, Tz::Europe_Zurich, CountryId{"CH"}}, // Prilly-Chasseur halt
    {Coordinate{6.60258, 46.5267}, Tz::Europe_Zurich, CountryId{"CH"}}, // Prilly-Malley halt
    {Coordinate{-1.63098, 48.0924}, Tz::Europe_Paris, CountryId{"FR"}}, // Rennes-La Poterie
    {Coordinate{-1.69129, 48.1187}, Tz::Europe_Paris, CountryId{"FR"}}, // Rennes-Pontchaillou
    {Coordinate{6.63886, 46.6404}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sur Roche halt
    {Coordinate{-3.13514, 48.7485}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3126258
    {Coordinate{6.60484, 46.571}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vernand-Camarès halt
    {Coordinate{3.28038, 44.4833}, Tz::Europe_Paris, CountryId{"FR"}}, // Q3126261
    {Coordinate{6.64211, 46.6433}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grésaley halt
    {Coordinate{-3.13245, 47.5756}, Tz::Europe_Paris, CountryId{"FR"}}, // Gare des Sables-Blancs
    {Coordinate{6.9177, 50.9516}, Tz::Europe_Berlin, CountryId{"DE"}}, // Köln-Ehrenfeld station
    {Coordinate{9.68171, 47.365}, Tz::Europe_Vienna, CountryId{"AT"}}, // Q31338289
    {Coordinate{7.0403, 51.549}, Tz::Europe_Berlin, CountryId{"DE"}}, // Q31401849
    {Coordinate{7.20694, 50.6314}, Tz::Europe_Berlin, CountryId{"DE"}}, // Rolandseck station
    {Coordinate{7.3421, 47.2406}, Tz::Europe_Zurich, CountryId{"CH"}}, // Court Station
    {Coordinate{7.58917, 47.4929}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reinach BL, Dorf Station
    {Coordinate{7.30577, 47.2392}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sorvilier Station
    {Coordinate{7.05537, 47.4559}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courtemaîche Station
    {Coordinate{7.25415, 47.2388}, Tz::Europe_Zurich, CountryId{"CH"}}, // Pontenet Station
    {Coordinate{7.04809, 47.4699}, Tz::Europe_Zurich, CountryId{"CH"}}, // Grandgourt Station
    {Coordinate{7.02996, 47.4793}, Tz::Europe_Zurich, CountryId{"CH"}}, // Buix Station
    {Coordinate{7.53195, 47.2067}, Tz::Europe_Zurich, CountryId{"CH"}}, // Solothurn West Station
    {Coordinate{7.69481, 47.2704}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederbipp Station
    {Coordinate{7.33774, 47.1187}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dotzigen Station
    {Coordinate{7.37123, 47.1381}, Tz::Europe_Zurich, CountryId{"CH"}}, // Büren an der Aare Station
    {Coordinate{6.40051, 46.7173}, Tz::Europe_Zurich, CountryId{"CH"}}, // Le Day Station
    {Coordinate{6.92705, 46.3587}, Tz::Europe_Zurich, CountryId{"CH"}}, // Roche VD Station
    {Coordinate{8.31969, 47.1079}, Tz::Europe_Zurich, CountryId{"CH"}}, // Waldibrücke Station
    {Coordinate{8.2423, 47.2297}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ermensee Station
    {Coordinate{8.32278, 47.1324}, Tz::Europe_Zurich, CountryId{"CH"}}, // Eschenbach Station
    {Coordinate{8.31688, 47.1538}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ballwil Station
    {Coordinate{8.28869, 47.167}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hochdorf Station
    {Coordinate{8.28021, 47.1857}, Tz::Europe_Zurich, CountryId{"CH"}}, // Baldegg Station
    {Coordinate{8.26481, 47.2136}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gelfingen Station
    {Coordinate{8.25198, 47.2227}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hitzkirch Station
    {Coordinate{8.2768, 47.0783}, Tz::Europe_Zurich, CountryId{"CH"}}, // Emmenbrücke Gersag Station
    {Coordinate{8.22415, 47.2443}, Tz::Europe_Zurich, CountryId{"CH"}}, // Mosen Station
    {Coordinate{8.15879, 47.3461}, Tz::Europe_Zurich, CountryId{"CH"}}, // Seon Station
    {Coordinate{8.17594, 47.3286}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hallwil Station
    {Coordinate{8.18455, 47.315}, Tz::Europe_Zurich, CountryId{"CH"}}, // Boniswil Station
    {Coordinate{8.199, 47.2878}, Tz::Europe_Zurich, CountryId{"CH"}}, // Birrwil Station
    {Coordinate{8.20222, 47.2672}, Tz::Europe_Zurich, CountryId{"CH"}}, // Beinwil am See Station
    {Coordinate{8.29821, 47.1647}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hochdorf Schönau Station
    {Coordinate{8.12568, 47.3883}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hunzenschwil Station
    {Coordinate{8.21497, 47.4452}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lupfig Station
    {Coordinate{8.21766, 47.4358}, Tz::Europe_Zurich, CountryId{"CH"}}, // Birr Station
    {Coordinate{7.9009, 47.2755}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vordemwald, Post Station
    {Coordinate{7.89541, 47.27}, Tz::Europe_Zurich, CountryId{"CH"}}, // Vordemwald, Chratzernstrasse Station
    {Coordinate{7.96984, 47.2524}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reiden, Unterdorf Station
    {Coordinate{7.94268, 47.2601}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brittnau, Ausserdorf Station
    {Coordinate{8.8343, 47.3248}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ettenhausen-Emmetschloo Station
    {Coordinate{8.85216, 47.3373}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bäretswil Station
    {Coordinate{8.86436, 47.3579}, Tz::Europe_Zurich, CountryId{"CH"}}, // Neuthal Station
    {Coordinate{8.64595, 47.6922}, Tz::Europe_Zurich, CountryId{"CH"}}, // Feuerthalen Station
    {Coordinate{8.25634, 47.5753}, Tz::Europe_Zurich, CountryId{"CH"}}, // Döttingen Station
    {Coordinate{8.24015, 47.5179}, Tz::Europe_Zurich, CountryId{"CH"}}, // Siggenthal-Würenlingen Station
    {Coordinate{6.79126, 46.6531}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bressonnaz Station
    {Coordinate{7.18975, 46.851}, Tz::Europe_Zurich, CountryId{"CH"}}, // Düdingen Station
    {Coordinate{7.25392, 46.8629}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schmitten Station
    {Coordinate{7.37645, 46.9255}, Tz::Europe_Zurich, CountryId{"CH"}}, // Niederwangen Station
    {Coordinate{7.39523, 46.9375}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Bümpliz Süd Station
    {Coordinate{7.40611, 46.9442}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bern Europaplatz SBB station
    {Coordinate{7.28064, 46.8719}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wünnewil Station
    {Coordinate{7.35186, 46.8936}, Tz::Europe_Zurich, CountryId{"CH"}}, // Thörishaus Dorf Station
    {Coordinate{7.36219, 46.9146}, Tz::Europe_Zurich, CountryId{"CH"}}, // Oberwangen Station
    {Coordinate{6.96029, 46.8353}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corcelles-Nord Station
    {Coordinate{6.98536, 46.8544}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dompierre Station
    {Coordinate{7.01138, 46.8685}, Tz::Europe_Zurich, CountryId{"CH"}}, // Domdidier Station
    {Coordinate{7.04092, 46.8846}, Tz::Europe_Zurich, CountryId{"CH"}}, // Avenches Station
    {Coordinate{7.07459, 46.9082}, Tz::Europe_Zurich, CountryId{"CH"}}, // Faoug Station
    {Coordinate{7.1532, 46.9509}, Tz::Europe_Zurich, CountryId{"CH"}}, // Galmiz Station
    {Coordinate{7.13325, 46.938}, Tz::Europe_Zurich, CountryId{"CH"}}, // Muntelier-Löwenberg Station
    {Coordinate{6.67656, 46.9424}, Tz::Europe_Zurich, CountryId{"CH"}}, // Travers Station
    {Coordinate{6.7218, 46.9549}, Tz::Europe_Zurich, CountryId{"CH"}}, // Noiraigue Station
    {Coordinate{6.77498, 46.9599}, Tz::Europe_Zurich, CountryId{"CH"}}, // Champ-du-Moulin Station
    {Coordinate{6.83769, 46.969}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bôle Station
    {Coordinate{6.89915, 46.9855}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Deurres Station
    {Coordinate{6.88381, 46.9833}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corcelles-Peseux Station
    {Coordinate{6.81225, 46.9671}, Tz::Europe_Zurich, CountryId{"CH"}}, // Chambrelien Station
    {Coordinate{6.84284, 46.9914}, Tz::Europe_Zurich, CountryId{"CH"}}, // Montmollin-Montezillon Station
    {Coordinate{6.85321, 47.0151}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Geneveys-sur-Coffrane Station
    {Coordinate{6.87467, 47.0472}, Tz::Europe_Zurich, CountryId{"CH"}}, // Les Hauts-Geneveys Station
    {Coordinate{7.25752, 47.1694}, Tz::Europe_Zurich, CountryId{"CH"}}, // Frinvillier-Taubenloch Station
    {Coordinate{7.24701, 47.1897}, Tz::Europe_Zurich, CountryId{"CH"}}, // Reuchenette-Péry Station
    {Coordinate{7.22539, 47.1895}, Tz::Europe_Zurich, CountryId{"CH"}}, // La Heutte Station
    {Coordinate{7.14465, 47.1934}, Tz::Europe_Zurich, CountryId{"CH"}}, // Corgémont Station
    {Coordinate{7.1073, 47.1893}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cortébert Station
    {Coordinate{7.0688, 47.1756}, Tz::Europe_Zurich, CountryId{"CH"}}, // Courtelary Station
    {Coordinate{7.05412, 47.1729}, Tz::Europe_Zurich, CountryId{"CH"}}, // Cormoret Station
    {Coordinate{7.01967, 47.1602}, Tz::Europe_Zurich, CountryId{"CH"}}, // Villeret Station
    {Coordinate{7.00121, 47.1517}, Tz::Europe_Zurich, CountryId{"CH"}}, // St-Imier Station
    {Coordinate{6.96934, 47.1413}, Tz::Europe_Zurich, CountryId{"CH"}}, // Sonvilier Station
    {Coordinate{6.92537, 47.1257}, Tz::Europe_Zurich, CountryId{"CH"}}, // Renan BE Station
    {Coordinate{7.26117, 47.0402}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bargen Station
    {Coordinate{7.45194, 47.0214}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münchenbuchsee Station
    {Coordinate{7.386, 47.0418}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schüpfen Station
    {Coordinate{9.07024, 47.383}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lütisburg, Restaurant Bahnhof Station
    {Coordinate{7.33899, 47.0588}, Tz::Europe_Zurich, CountryId{"CH"}}, // Suberg-Grossaffoltern Station
    {Coordinate{7.31862, 47.0987}, Tz::Europe_Zurich, CountryId{"CH"}}, // Busswil Station
    {Coordinate{7.27821, 47.1236}, Tz::Europe_Zurich, CountryId{"CH"}}, // Brügg BE Station
    {Coordinate{7.30174, 47.1104}, Tz::Europe_Zurich, CountryId{"CH"}}, // Studen BE Station
    {Coordinate{9.24694, 47.6289}, Tz::Europe_Zurich, CountryId{"CH"}}, // Landschlacht Station
    {Coordinate{8.85373, 47.6593}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hemishofen Station
    {Coordinate{8.82115, 47.7074}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ramsen Station
    {Coordinate{9.10875, 47.6629}, Tz::Europe_Zurich, CountryId{"CH"}}, // Triboltingen Station
    {Coordinate{9.19635, 47.6431}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kurzrickenbach Seepark Station
    {Coordinate{9.227, 47.6334}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münsterlingen-Scherzingen Station
    {Coordinate{9.21308, 47.6407}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bottighofen Station
    {Coordinate{9.18196, 47.6492}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kreuzlingen Hafen Station
    {Coordinate{9.13296, 47.6596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tägerwilen-Gottlieben Station
    {Coordinate{9.23611, 47.632}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münsterlingen Spital Station
    {Coordinate{9.0783, 47.3446}, Tz::Europe_Zurich, CountryId{"CH"}}, // Dietfurt Station
    {Coordinate{9.07514, 47.3596}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bütschwil Station
    {Coordinate{9.07067, 47.3838}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lütisburg Station
    {Coordinate{9.06904, 47.4101}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bazenheid Station
    {Coordinate{7.48149, 46.9568}, Tz::Europe_Zurich, CountryId{"CH"}}, // Ostermundigen Station
    {Coordinate{7.5055, 46.9343}, Tz::Europe_Zurich, CountryId{"CH"}}, // Gümligen Station
    {Coordinate{7.54537, 46.8992}, Tz::Europe_Zurich, CountryId{"CH"}}, // Rubigen Station
    {Coordinate{7.55943, 46.8733}, Tz::Europe_Zurich, CountryId{"CH"}}, // Münsingen Station
    {Coordinate{7.56885, 46.8416}, Tz::Europe_Zurich, CountryId{"CH"}}, // Wichtrach Station
    {Coordinate{7.57549, 46.8189}, Tz::Europe_Zurich, CountryId{"CH"}}, // Kiesen Station
    {Coordinate{7.58262, 46.7943}, Tz::Europe_Zurich, CountryId{"CH"}}, // Uttigen Station
    {Coordinate{7.49892, 47.0189}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schönbühl SBB Station
    {Coordinate{7.5454, 47.0496}, Tz::Europe_Zurich, CountryId{"CH"}}, // Hindelbank Station
    {Coordinate{7.58131, 47.0638}, Tz::Europe_Zurich, CountryId{"CH"}}, // Lyssach Station
    {Coordinate{7.56484, 46.9152}, Tz::Europe_Zurich, CountryId{"CH"}}, // Worb SBB Station
    {Coordinate{7.58083, 46.8823}, Tz::Europe_Zurich, CountryId{"CH"}}, // Tägertschi Station
    {Coordinate{7.66288, 46.8997}, Tz::Europe_Zurich, CountryId{"CH"}}, // Zäziwil Station
    {Coordinate{7.69805, 46.9}, Tz::Europe_Zurich, CountryId{"CH"}}, // Bowil Station
    {Coordinate{7.72545, 46.9196}, Tz::Europe_Zurich, CountryId{"CH"}}, // Signau Station
    {Coordinate{7.74729, 46.9482}, Tz::Europe_Zurich, CountryId{"CH"}}, // Emmenmatt Station
    {Coordinate{7.84613, 46.9217}, Tz::Europe_Zurich, CountryId{"CH"}}, // Trubschachen Station
    {Coordinate{7.93636, 46.9153}, Tz::Europe_Zurich, CountryId{"CH"}}, // Escholzmatt Station
    {Coordinate{8.01514, 46.9506}, Tz::Europe_Zurich, CountryId{"CH"}}, // Schüpfheim Station
    {C