//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \short A class which provides notifications of state changes to a SmartCursor via inheritance.
    ///  \ingroup kte_group_smart_classes
    ///  This class provides notifications of changes to a SmartCursor such as the
    ///  position in the document, and deletion or insertion of text immediately
    ///  before or after the cursor.
    ///  If you prefer to receive notifications via QObject signals, see SmartCursorNotifier.
    ///  \sa SmartCursor, SmartCursorNotifier
    ///  \author Hamish Rodda \<rodda@kde.org\>
    ///  </remarks>        <short>    \short A class which provides notifications of state changes to a SmartCursor via virtual inheritance.</short>
    [SmokeClass("KTextEditor::SmartCursorWatcher")]
    public class SmartCursorWatcher : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected SmartCursorWatcher(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SmartCursorWatcher), this);
        }
        /// <remarks>
        ///  Default constructor.
        ///      </remarks>        <short>    Default constructor.</short>
        public SmartCursorWatcher() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SmartCursorWatcher", "SmartCursorWatcher()", typeof(void));
        }
        /// <remarks>
        ///  Returns whether this watcher wants to be notified of changes that happen
        ///  directly to the cursor, e.g. by calls to SmartCursor.SetPosition(), rather
        ///  than just when surrounding text changes.
        ///      </remarks>        <short>    Returns whether this watcher wants to be notified of changes that happen  directly to the cursor, e.</short>
        public bool WantsDirectChanges() {
            return (bool) interceptor.Invoke("wantsDirectChanges", "wantsDirectChanges() const", typeof(bool));
        }
        /// <remarks>
        ///  Set whether this watcher should be notified of changes that happen
        ///  directly to the cursor, e.g. by calls to SmartCursor.SetPosition(), rather
        ///  than just when surrounding text changes.
        ///  \param wantsDirectChanges whether this watcher should receive notifications for direct changes.
        ///      </remarks>        <short>    Set whether this watcher should be notified of changes that happen  directly to the cursor, e.</short>
        public void SetWantsDirectChanges(bool wantsDirectChanges) {
            interceptor.Invoke("setWantsDirectChanges$", "setWantsDirectChanges(bool)", typeof(void), typeof(bool), wantsDirectChanges);
        }
        /// <remarks>
        ///  The cursor's position was changed.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///      </remarks>        <short>    The cursor's position was changed.</short>
        [SmokeMethod("positionChanged(KTextEditor::SmartCursor*)")]
        public virtual void PositionChanged(KTextEditor.SmartCursor cursor) {
            interceptor.Invoke("positionChanged#", "positionChanged(KTextEditor::SmartCursor*)", typeof(void), typeof(KTextEditor.SmartCursor), cursor);
        }
        /// <remarks>
        ///  The cursor's surrounding characters were both deleted simultaneously.
        ///  The cursor is automatically placed at the start of the deleted region.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///      </remarks>        <short>    The cursor's surrounding characters were both deleted simultaneously.</short>
        [SmokeMethod("positionDeleted(KTextEditor::SmartCursor*)")]
        public virtual void PositionDeleted(KTextEditor.SmartCursor cursor) {
            interceptor.Invoke("positionDeleted#", "positionDeleted(KTextEditor::SmartCursor*)", typeof(void), typeof(KTextEditor.SmartCursor), cursor);
        }
        /// <remarks>
        ///  The character immediately surrounding the cursor was deleted.
        ///  If both characters are simultaneously deleted, positionDeleted() is called instead.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///  \param deletedBefore <code>true</code> if the character immediately before was deleted,
        ///                       <code>false</code> if the character immediately after was deleted.
        ///      </remarks>        <short>    The character immediately surrounding the cursor was deleted.</short>
        [SmokeMethod("characterDeleted(KTextEditor::SmartCursor*, bool)")]
        public virtual void CharacterDeleted(KTextEditor.SmartCursor cursor, bool deletedBefore) {
            interceptor.Invoke("characterDeleted#$", "characterDeleted(KTextEditor::SmartCursor*, bool)", typeof(void), typeof(KTextEditor.SmartCursor), cursor, typeof(bool), deletedBefore);
        }
        /// <remarks>
        ///  A character was inserted immediately before or after the cursor, as given
        ///  by <pre>insertedBefore</pre>.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///  \param insertedBefore \e true if a character was inserted before <pre>cursor</pre>,
        ///                        \e false if a character was inserted after
        ///      </remarks>        <short>    A character was inserted immediately before or after the cursor, as given  by \p insertedBefore.</short>
        [SmokeMethod("characterInserted(KTextEditor::SmartCursor*, bool)")]
        public virtual void CharacterInserted(KTextEditor.SmartCursor cursor, bool insertedBefore) {
            interceptor.Invoke("characterInserted#$", "characterInserted(KTextEditor::SmartCursor*, bool)", typeof(void), typeof(KTextEditor.SmartCursor), cursor, typeof(bool), insertedBefore);
        }
        /// <remarks>
        ///  The SmartCursor instance specified by <pre>cursor</pre> is being deleted.
        ///  \param cursor pointer to the cursor which is about to be deleted.  It is
        ///                still safe to access information at this point.
        ///      </remarks>        <short>    The SmartCursor instance specified by \p cursor is being deleted.</short>
        [SmokeMethod("deleted(KTextEditor::SmartCursor*)")]
        public virtual void Deleted(KTextEditor.SmartCursor cursor) {
            interceptor.Invoke("deleted#", "deleted(KTextEditor::SmartCursor*)", typeof(void), typeof(KTextEditor.SmartCursor), cursor);
        }
        ~SmartCursorWatcher() {
            interceptor.Invoke("~SmartCursorWatcher", "~SmartCursorWatcher()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~SmartCursorWatcher", "~SmartCursorWatcher()", typeof(void));
        }
    }
}
