//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  This is an interface for inserting template strings with user editable
    ///  fields into a document.
    ///  \ingroup kte_group_view_extensions
    ///  </remarks>        <short>    This is an interface for inserting template strings with user editable  fields into a document.</short>
    [SmokeClass("KTextEditor::TemplateInterface")]
    public class TemplateInterface : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected TemplateInterface(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(TemplateInterface), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static TemplateInterface() {
            staticInterceptor = new SmokeInvocation(typeof(TemplateInterface), null);
        }
        public TemplateInterface() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("TemplateInterface", "TemplateInterface()", typeof(void));
        }
        /// <remarks>
        ///  Inserts an interactive ediable template text at line "line", column "col".
        ///  \return true if inserting the string succeeded
        ///  Use insertTemplateText(lines(), ...) to append text at end of document
        ///  Template  strings look like
        ///  "for( int ${index}=0;${index}<10;${index}++) { ${cursor} }"
        ///  or "%{date}"
        ///  This syntax is somewhat similar to the one found in the Eclipse editor.
        ///  There are certain common placeholders (macros), which get assigned a
        ///  default initialValue, If the second parameter does not a given value.
        ///  For all others the initial value is the name of the placeholder.
        ///  Placeholder names may only consist of a-zA-Z0-9_
        ///  Common placeholders and values are
        ///  - index: "i"
        ///  - loginname: The current users's loginname
        ///  - firstname: The current user's first name retrieved from kabc
        ///  - lastname: The current user's last name retrieved from kabc
        ///  - fullname: The current user's first and last name retrieved from kabc
        ///  - email: The current user's primary email address retrieved from kabc
        ///  - date: current date
        ///  - time: current time
        ///  - year: current year
        ///  - month: current month
        ///  - day: current day
        ///  - hostname: hostname of the computer
        ///  - cursor: at this position the cursor will be after editing of the
        ///    template has finished, this has to be taken care of by the actual
        ///    implementation. The placeholder gets a value of "|" assigned.
        ///  If a macro is started with a % (persent sign) like "%{date}" it isn't added
        ///  to the list editable strings ( for example TAB key navigation) if a value
        ///  differing from the macro name is found.
        ///  If the editor supports some kind of smart indentation, the inserted code
        ///  should be layouted by the indenter.
        ///      </remarks>        <short>    Inserts an interactive ediable template text at line "line", column "col".</short>
        public bool InsertTemplateText(KTextEditor.Cursor insertPosition, string templateString, Dictionary<string, string> initialValues) {
            return (bool) interceptor.Invoke("insertTemplateText#$?", "insertTemplateText(const KTextEditor::Cursor&, const QString&, const QMap<QString,QString>&)", typeof(bool), typeof(KTextEditor.Cursor), insertPosition, typeof(string), templateString, typeof(Dictionary<string, string>), initialValues);
        }
        /// <remarks>
        ///  You must implement this, it is called by insertTemplateText, after all
        ///  default values are inserted. If you are implementing this interface,
        ///  this method should work as described in the documentation for
        ///  insertTemplateText above.
        ///  \return true if any text was inserted.
        ///      </remarks>        <short>    You must implement this, it is called by insertTemplateText, after all  default values are inserted.</short>
        [SmokeMethod("insertTemplateTextImplementation(const KTextEditor::Cursor&, const QString&, const QMap<QString,QString>&)")]
        protected virtual bool InsertTemplateTextImplementation(KTextEditor.Cursor insertPosition, string templateString, Dictionary<string, string> initialValues) {
            return (bool) interceptor.Invoke("insertTemplateTextImplementation#$?", "insertTemplateTextImplementation(const KTextEditor::Cursor&, const QString&, const QMap<QString,QString>&)", typeof(bool), typeof(KTextEditor.Cursor), insertPosition, typeof(string), templateString, typeof(Dictionary<string, string>), initialValues);
        }
        ~TemplateInterface() {
            interceptor.Invoke("~TemplateInterface", "~TemplateInterface()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~TemplateInterface", "~TemplateInterface()", typeof(void));
        }
        /// <remarks>
        ///  Parses <pre>templateString</pre> for macros in the form [$%]{NAME} and finds
        ///  the value corresponding to NAME if any. The NAME string may contain
        ///  any non-whitespace character execpt '}'
        ///  \param initialValues a map with the keys for the macros to expand.
        ///  keys with a value are ignored.
        ///  \param parentWindow is used if dialogs have to be shown
        ///  \return true if all macros was successfully expanded
        ///  \see insertTemplateText for a list of supported macros
        ///      </remarks>        <short>    Parses \p templateString for macros in the form [$%]{NAME} and finds  the value corresponding to NAME if any.</short>
        public static bool ExpandMacros(Dictionary<string, string> initialValues, QWidget parentWindow) {
            return (bool) staticInterceptor.Invoke("expandMacros?#", "expandMacros(QMap<QString,QString>&, QWidget*)", typeof(bool), typeof(Dictionary<string, string>), initialValues, typeof(QWidget), parentWindow);
        }
    }
}
