# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DIST_AUTHOR=EDD
DIST_VERSION=0.26
inherit perl-module

DESCRIPTION="Get stock quotes from Yahoo! Finance"

LICENSE="GPL-2+"
SLOT="0"
KEYWORDS="amd64 ppc x86"

RDEPEND="
	>=dev-perl/HTML-Parser-2.200.0
	>=dev-perl/HTTP-Message-1.230.0
	>=dev-perl/libwww-perl-1.620.0
	>=virtual/perl-Text-ParseWords-3.100.0
"
BDEPEND="${RDEPEND}"

src_test() {
	local MODULES=(
		"Finance::YahooQuote ${DIST_VERSION}"
	)
	local failed=()
	for dep in "${MODULES[@]}"; do
		ebegin "Compile testing ${dep}"
			perl -Mblib="${S}" -M"${dep} ()" -e1
		eend $? || failed+=( "$dep" )
	done
	if [[ ${failed[@]} ]]; then
		echo
		eerror "One or more modules failed compile:";
		for dep in "${failed[@]}"; do
			eerror "  ${dep}"
		done
		die "Failing due to module compilation errors";
	fi
	perl-module_src_test
}
