# Copyright 1999-2018 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit toolchain-funcs

DESCRIPTION="Listen to music on the radio generated by images on your screen"
HOMEPAGE="http://www.erikyyy.de/tempest/"
SRC_URI="http://www.erikyyy.de/tempest/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ~ppc x86"

RDEPEND="media-libs/libsdl"
DEPEND="${RDEPEND}"

src_configure() {
	tc-export CXX
	econf \
		--enable-debug \
		--enable-nowarnerror
}

src_compile() {
	emake CXXFLAGS="${CXXFLAGS}" LDFLAGS="${LDFLAGS}"
}

src_install() {
	default
	rm songs/Makefile* || die
	insinto /usr/share/${PN}
	doins songs/*
}
