/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import org.apache.commons.httpclient.Cookie;

public class SetCookies
extends DefaultStep {
    private static final QName _cookies = new QName("", "cookies");
    private static final QName _domain = new QName("", "domain");
    private static final QName _name = new QName("", "name");
    private static final QName _value = new QName("", "value");
    private static final QName _path = new QName("", "path");
    private static final QName _expires = new QName("", "expires");
    private static final QName _version = new QName("", "version");
    private static final QName _secure = new QName("", "secure");
    private static final QName c_cookies = new QName("c", "http://www.w3.org/ns/xproc-step", "cookies");
    private static final QName c_cookie = new QName("c", "http://www.w3.org/ns/xproc-step", "cookie");
    private static DateFormat iso8601tz = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private ReadablePipe source = null;

    public SetCookies(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getOption(_cookies).getString();
        XdmNode xdmNode = this.source.read();
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (!c_cookies.equals((Object)xdmNode2.getNodeName())) {
            throw new XProcException(this.step.getNode(), "The input to cx:set-cookies must be a c:cookies document.");
        }
        for (XdmNode xdmNode3 : new RelevantNodes(null, xdmNode2, Axis.CHILD)) {
            if (xdmNode3.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (!c_cookie.equals((Object)xdmNode3.getNodeName())) {
                    throw new XProcException(this.step.getNode(), "A c:cookies document must contain only c:cookie elements.");
                }
                String string2 = xdmNode3.getAttributeValue(_domain);
                String string3 = xdmNode3.getAttributeValue(_name);
                String string4 = xdmNode3.getAttributeValue(_value);
                String string5 = xdmNode3.getAttributeValue(_path);
                String string6 = xdmNode3.getAttributeValue(_expires);
                if (string3 == null || string4 == null) {
                    throw new XProcException(this.step.getNode(), "Invalid cookie: " + xdmNode3);
                }
                Cookie cookie = new Cookie();
                cookie.setName(string3);
                cookie.setValue(string4);
                if (string2 != null) {
                    cookie.setDomain(string2);
                }
                if (string5 != null) {
                    cookie.setPath(string5);
                }
                if (string6 != null) {
                    Date date = null;
                    try {
                        if (string6.length() > 21) {
                            string6 = string6.substring(0, 22) + string6.substring(23);
                            date = iso8601tz.parse(string6);
                        } else {
                            date = iso8601.parse(string6);
                        }
                        cookie.setExpiryDate(date);
                    }
                    catch (ParseException parseException) {
                        throw new XProcException(parseException);
                    }
                }
                this.runtime.addCookie(string, cookie);
                continue;
            }
            if (xdmNode3.getNodeKind() != XdmNodeKind.TEXT || "".equals(xdmNode3.getStringValue().trim())) continue;
            throw new XProcException(this.step.getNode(), "A c:cookies document must not contain non-whitespace text nodes.");
        }
    }
}

