/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmValue
implements Iterable<XdmItem> {
    private ValueRepresentation value;

    protected XdmValue() {
    }

    public XdmValue(Iterable<XdmItem> items) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem item : items) {
            values.add((Item)item.getUnderlyingValue());
        }
        this.value = new SequenceExtent(values);
    }

    protected XdmValue(ValueRepresentation value) {
        this.value = value;
    }

    protected void setValue(ValueRepresentation value) {
        this.value = value;
    }

    protected static XdmValue wrap(ValueRepresentation value) {
        if (value == null) {
            return null;
        }
        if (value instanceof NodeInfo) {
            return new XdmNode((NodeInfo)value);
        }
        if (value instanceof AtomicValue) {
            return new XdmAtomicValue((AtomicValue)value);
        }
        if (value instanceof EmptySequence) {
            return XdmEmptySequence.getInstance();
        }
        return new XdmValue(value);
    }

    public XdmValue append(XdmValue otherValue) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem item : this) {
            values.add((Item)item.getUnderlyingValue());
        }
        for (XdmItem item : otherValue) {
            values.add((Item)item.getUnderlyingValue());
        }
        return new XdmValue(new SequenceExtent(values));
    }

    public int size() {
        try {
            if (this.value instanceof Value) {
                return ((Value)this.value).getLength();
            }
            return 1;
        }
        catch (XPathException err) {
            throw new SaxonApiUncheckedException(err);
        }
    }

    public XdmItem itemAt(int n) throws IndexOutOfBoundsException, SaxonApiUncheckedException {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("" + n);
        }
        if (this.value instanceof Value) {
            try {
                return (XdmItem)XdmItem.wrap(((Value)this.value).itemAt(n));
            }
            catch (XPathException e) {
                throw new SaxonApiUncheckedException(e);
            }
        }
        return (XdmNode)XdmNode.wrap((NodeInfo)this.value);
    }

    public XdmSequenceIterator iterator() throws SaxonApiUncheckedException {
        try {
            ValueRepresentation v = this.getUnderlyingValue();
            if (v instanceof Value) {
                return new XdmSequenceIterator(((Value)v).iterate());
            }
            return new XdmSequenceIterator(SingletonIterator.makeIterator((NodeInfo)v));
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public ValueRepresentation getUnderlyingValue() {
        return this.value;
    }
}

