/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceCodeIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType resultItemType;
    private Expression select;

    public Copy(Expression select, boolean copyNamespaces, boolean inheritNamespaces, SchemaType schemaType, int validation) {
        this.copyNamespaces = copyNamespaces;
        this.inheritNamespaces = inheritNamespaces;
        this.select = select;
        this.setSchemaType(schemaType);
        this.validation = validation;
        boolean bl = this.preservingTypes = schemaType == null && validation == 3;
        if (copyNamespaces) {
            this.setLazyConstruction(false);
        }
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.preservingTypes |= !visitor.getExecutable().isSchemaAware();
        return super.simplify(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        try {
            this.select = visitor.typeCheck(this.select, contextItemType);
            this.adoptChildExpression(this.select);
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart().equals("XPDY0002")) {
                err.setErrorCode("XTTE0945");
                err.maybeSetLocation(this);
            }
            this.select = new Literal(EmptySequence.getInstance());
            throw err;
        }
        ItemType selectItemType = this.select.getItemType(visitor.getConfiguration().getTypeHierarchy());
        if (selectItemType instanceof NodeTest) {
            switch (selectItemType.getPrimitiveType()) {
                case 1: {
                    this.resultItemType = NodeKindTest.ELEMENT;
                    break;
                }
                case 2: {
                    this.resultItemType = NodeKindTest.ATTRIBUTE;
                    break;
                }
                case 9: {
                    this.resultItemType = NodeKindTest.DOCUMENT;
                    break;
                }
                default: {
                    this.resultItemType = selectItemType;
                    break;
                }
            }
        } else {
            this.resultItemType = selectItemType;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Expression copy() {
        Copy copy = new Copy(this.select, this.copyNamespaces, this.inheritNamespaces, this.getSchemaType(), this.validation);
        copy.setContentExpression(this.content.copy());
        return copy;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public int getInstructionNameCode() {
        return 143;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.select, this.content);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.resultItemType != null) {
            return this.resultItemType;
        }
        this.resultItemType = this.computeItemType(th);
        return this.resultItemType;
    }

    private ItemType computeItemType(TypeHierarchy th) {
        ItemType selectItemType = this.select.getItemType(th);
        Executable exec = this.getExecutable();
        if (!exec.isSchemaAware()) {
            return selectItemType;
        }
        Configuration config = exec.getConfiguration();
        if (this.getSchemaType() != null) {
            int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
            if (e == 0 || e == 2) {
                return new ContentTypeTest(1, this.getSchemaType(), config);
            }
            int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
            if (a == 0 || a == 2) {
                return new ContentTypeTest(2, this.getSchemaType(), config);
            }
            return AnyNodeTest.getInstance();
        }
        switch (this.validation) {
            case 3: {
                return selectItemType;
            }
            case 4: {
                int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
                if (e == 0 || e == 2) {
                    return new ContentTypeTest(1, Untyped.getInstance(), config);
                }
                int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
                if (a == 0 || a == 2) {
                    return new ContentTypeTest(2, BuiltInAtomicType.UNTYPED_ATOMIC, config);
                }
                if (e != 4 || a != 4) {
                    return AnyNodeTest.getInstance();
                }
                return selectItemType;
            }
            case 1: 
            case 2: {
                if (selectItemType instanceof NodeTest) {
                    int fp = ((NodeTest)selectItemType).getFingerprint();
                    if (fp != -1) {
                        int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
                        if (e == 0 || e == 2) {
                            SchemaDeclaration elem = config.getElementDeclaration(fp);
                            if (elem != null) {
                                return new ContentTypeTest(1, elem.getType(), config);
                            }
                            return new ContentTypeTest(1, AnyType.getInstance(), config);
                        }
                        int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
                        if (a == 0 || a == 2) {
                            SchemaDeclaration attr = config.getElementDeclaration(fp);
                            if (attr != null) {
                                return new ContentTypeTest(2, attr.getType(), config);
                            }
                            return new ContentTypeTest(2, AnySimpleType.getInstance(), config);
                        }
                    } else {
                        int e = th.relationship(selectItemType, NodeKindTest.ELEMENT);
                        if (e == 0 || e == 2) {
                            return NodeKindTest.ELEMENT;
                        }
                        int a = th.relationship(selectItemType, NodeKindTest.ATTRIBUTE);
                        if (a == 0 || a == 2) {
                            return NodeKindTest.ATTRIBUTE;
                        }
                    }
                    return AnyNodeTest.getInstance();
                }
                if (selectItemType instanceof AtomicType) {
                    return selectItemType;
                }
                return AnyItemType.getInstance();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this) {
            if (this.resultItemType == null) {
                this.resultItemType = this.computeItemType(visitor.getConfiguration().getTypeHierarchy());
            }
            if (this.resultItemType.isAtomicType()) {
                return this.select;
            }
        }
        return exp;
    }

    @Override
    public int getNameCode(XPathContext context, NodeInfo copiedNode) throws XPathException {
        return copiedNode.getNameCode();
    }

    @Override
    public String getNewBaseURI(XPathContext context, NodeInfo copiedNode) {
        return copiedNode.getBaseURI();
    }

    @Override
    protected void outputNamespaceNodes(XPathContext context, Receiver receiver, int nameCode, NodeInfo copiedNode) throws XPathException {
        if (this.copyNamespaces) {
            NamespaceCodeIterator.sendNamespaces(copiedNode, receiver);
        } else {
            receiver.namespace(context.getNamePool().getNamespaceCode(nameCode), 0);
        }
    }

    @Override
    public int[] getActiveNamespaces() throws XPathException {
        if (this.copyNamespaces) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        SequenceReceiver out = context.getReceiver();
        Item item = this.select.evaluateItem(context);
        if (item == null) {
            // empty if block
        }
        if (!(item instanceof NodeInfo)) {
            out.append(item, this.locationId, 2);
            return null;
        }
        NodeInfo source = (NodeInfo)item;
        switch (source.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(context, (NodeInfo)item);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(source, this.getSchemaType(), this.validation, this, context, false);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    err.setXPathContext(context);
                    throw Copy.dynamicError(this, err, context);
                }
            }
            case 3: {
                out.characters(source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 7: {
                out.processingInstruction(source.getDisplayName(), source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 8: {
                out.comment(source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    source.copy(out, 0, this.locationId);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e = new XPathException(err.getMessage());
                    e.setXPathContext(context);
                    e.setErrorCodeQName(err.getErrorCodeQName());
                    throw Copy.dynamicError(this, e, context);
                }
            }
            case 9: {
                Receiver val;
                XPathContext c2 = context;
                if (!this.preservingTypes && (val = controller.getConfiguration().getDocumentValidator(out, source.getBaseURI(), this.validation, 0, this.getSchemaType(), -1)) != out) {
                    TreeReceiver sr = new TreeReceiver(val);
                    ((SequenceReceiver)sr).setPipelineConfiguration(out.getPipelineConfiguration());
                    c2 = c2.newMinorContext();
                    c2.setReceiver(sr);
                    out = sr;
                }
                out.startDocument(0);
                this.content.process(c2);
                out.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + source.getNodeKind());
            }
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        Item item = seq.getFirstItem();
        seq.reset();
        return item;
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        NodeInfo node = (NodeInfo)this.select.evaluateItem(context);
        int nodeKind = node.getNodeKind();
        switch (nodeKind) {
            case 9: {
                Controller controller;
                Receiver val;
                XPathContext c2 = context;
                SequenceReceiver out = context.getReceiver();
                state.push(out);
                if (!this.preservingTypes && (val = (controller = c2.getController()).getConfiguration().getDocumentValidator(out, node.getBaseURI(), this.validation, 0, this.getSchemaType(), -1)) != out) {
                    TreeReceiver sr = new TreeReceiver(val);
                    ((SequenceReceiver)sr).setPipelineConfiguration(out.getPipelineConfiguration());
                    c2 = c2.newMinorContext();
                    c2.setReceiver(sr);
                    out = sr;
                }
                out.startDocument(0);
                break;
            }
            case 1: {
                super.processLeft(contextStack, state, node);
                break;
            }
            default: {
                try {
                    for (TailCall tc = this.processLeavingTail(context, node); tc != null; tc = tc.processLeavingTail()) {
                    }
                    break;
                }
                catch (XPathException err) {
                    err.maybeSetLocation(this);
                    throw err;
                }
            }
        }
        state.push(nodeKind);
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        int nodeKind = (Integer)state.pop();
        switch (nodeKind) {
            case 9: {
                SequenceReceiver out = context.getReceiver();
                out.endDocument();
                out = (SequenceReceiver)state.pop();
                context.setReceiver(out);
                break;
            }
            case 1: {
                super.processRight(contextStack, state);
                break;
            }
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("copy");
        this.content.explain(out);
        out.endElement();
    }
}

