# This file has been autogenerated by the pywayland scanner

# Copyright © 2012, 2013 Intel Corporation
# Copyright © 2015, 2016 Jan Arne Petersen
# Copyright © 2017, 2018 Red Hat, Inc.
# Copyright © 2018       Purism SPC
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSeat
from .zwp_text_input_v3 import ZwpTextInputV3


class ZwpTextInputManagerV3(Interface):
    """Text input manager

    A factory for text-input objects. This object is a global singleton.
    """

    name = "zwp_text_input_manager_v3"
    version = 1


class ZwpTextInputManagerV3Proxy(Proxy[ZwpTextInputManagerV3]):
    interface = ZwpTextInputManagerV3

    @ZwpTextInputManagerV3.request()
    def destroy(self) -> None:
        """Destroy the wp_text_input_manager

        Destroy the wp_text_input_manager object.
        """
        self._marshal(0)
        self._destroy()

    @ZwpTextInputManagerV3.request(
        Argument(ArgumentType.NewId, interface=ZwpTextInputV3),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def get_text_input(self, seat: WlSeat) -> Proxy[ZwpTextInputV3]:
        """Create a new text input object

        Creates a new text-input object for a given seat.

        :param seat:
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.text_input_unstable_v3.ZwpTextInputV3`
        """
        id = self._marshal_constructor(1, ZwpTextInputV3, seat)
        return id


class ZwpTextInputManagerV3Resource(Resource):
    interface = ZwpTextInputManagerV3


class ZwpTextInputManagerV3Global(Global):
    interface = ZwpTextInputManagerV3


ZwpTextInputManagerV3._gen_c()
ZwpTextInputManagerV3.proxy_class = ZwpTextInputManagerV3Proxy
ZwpTextInputManagerV3.resource_class = ZwpTextInputManagerV3Resource
ZwpTextInputManagerV3.global_class = ZwpTextInputManagerV3Global
