(** Feature checks.

    {e You probably don't need these!}

    If you installed Luv in the usual way, through either opam or esy, you can
    ignore this module completely. In this case, Luv internally installed a
    vendored libuv of a recent version, and you have all the latest APIs
    available — whatever is exposed by your version of Luv {e is} actually
    implemented by libuv.

    However, if you installed Luv through a system package manager, or tweaked
    your Luv installation so that it links to a system or other external libuv
    — or if your users will do so — that external libuv might be of a
    considerably older version than Luv expects. Not all features normally
    exposed by Luv might actually be available.

    For that case, this module provides a bunch of useful feature checks, so
    that you can control the behavior of your downstream project and/or prevent
    its compilation with too old a libuv.

    This module itself is present since Luv 0.5.7. *)

(**/**)

type 'p s

type ___0
type ___1 = ___0 s
type ___2 = ___1 s
type ___3 = ___2 s
type ___4 = ___3 s
type ___5 = ___4 s
type ___6 = ___5 s
type ___7 = ___6 s
type ___8 = ___7 s
type ___9 = ___8 s
type ___10 = ___9 s
type ___11 = ___10 s
type ___12 = ___11 s
type ___13 = ___12 s
type ___14 = ___13 s
type ___15 = ___14 s
type ___16 = ___15 s
type ___17 = ___16 s
type ___18 = ___17 s
type ___19 = ___18 s
type ___20 = ___19 s
type ___21 = ___20 s
type ___22 = ___21 s
type ___23 = ___22 s
type ___24 = ___23 s
type ___25 = ___24 s
type ___26 = ___25 s
type ___27 = ___26 s
type ___28 = ___27 s
type ___29 = ___28 s
type ___30 = ___29 s
type ___31 = ___30 s
type ___32 = ___31 s
type ___33 = ___32 s
type ___34 = ___33 s
type ___35 = ___34 s
type ___36 = ___35 s
type ___37 = ___36 s
type ___38 = ___37 s
type ___39 = ___38 s
type ___40 = ___39 s
type ___41 = ___40 s
type ___42 = ___41 s
type ___43 = ___42 s
type ___44 = ___43 s
type ___45 = ___44 s
type ___46 = ___45 s
type ___47 = ___46 s
type ___48 = ___47 s
type ___49 = ___48 s
type ___50 = ___49 s
type ___51 = ___50 s
type ___52 = ___51 s
type ___53 = ___52 s
type ___54 = ___53 s
type ___55 = ___54 s
type ___56 = ___55 s
type ___57 = ___56 s
type ___58 = ___57 s
type ___59 = ___58 s
type ___60 = ___59 s
type ___61 = ___60 s
type ___62 = ___61 s
type ___63 = ___62 s
type ___64 = ___63 s
type ___65 = ___64 s
type ___66 = ___65 s
type ___67 = ___66 s
type ___68 = ___67 s
type ___69 = ___68 s
type ___70 = ___69 s
type ___71 = ___70 s
type ___72 = ___71 s
type ___73 = ___72 s
type ___74 = ___73 s
type ___75 = ___74 s
type ___76 = ___75 s
type ___77 = ___76 s
type ___78 = ___77 s
type ___79 = ___78 s
type ___80 = ___79 s
type ___81 = ___80 s
type ___82 = ___81 s
type ___83 = ___82 s
type ___84 = ___83 s
type ___85 = ___84 s
type ___86 = ___85 s
type ___87 = ___86 s
type ___88 = ___87 s
type ___89 = ___88 s
type ___90 = ___89 s
type ___91 = ___90 s
type ___92 = ___91 s
type ___93 = ___92 s
type ___94 = ___93 s
type ___95 = ___94 s
type ___96 = ___95 s
type ___97 = ___96 s
type ___98 = ___97 s
type ___99 = ___98 s
type ___inf = ___99 s

type _0 = int * ___0
type _1 = int * ___1
type _2 = int * ___2
type _3 = int * ___3
type _4 = int * ___4
type _5 = int * ___5
type _6 = int * ___6
type _7 = int * ___7
type _8 = int * ___8
type _9 = int * ___9
type _10 = int * ___10
type _11 = int * ___11
type _12 = int * ___12
type _13 = int * ___13
type _14 = int * ___14
type _15 = int * ___15
type _16 = int * ___16
type _17 = int * ___17
type _18 = int * ___18
type _19 = int * ___19
type _20 = int * ___20
type _21 = int * ___21
type _22 = int * ___22
type _23 = int * ___23
type _24 = int * ___24
type _25 = int * ___25
type _26 = int * ___26
type _27 = int * ___27
type _28 = int * ___28
type _29 = int * ___29
type _30 = int * ___30
type _31 = int * ___31
type _32 = int * ___32
type _33 = int * ___33
type _34 = int * ___34
type _35 = int * ___35
type _36 = int * ___36
type _37 = int * ___37
type _38 = int * ___38
type _39 = int * ___39
type _40 = int * ___40
type _41 = int * ___41
type _42 = int * ___42
type _43 = int * ___43
type _44 = int * ___44
type _45 = int * ___45
type _46 = int * ___46
type _47 = int * ___47
type _48 = int * ___48
type _49 = int * ___49
type _50 = int * ___50
type _51 = int * ___51
type _52 = int * ___52
type _53 = int * ___53
type _54 = int * ___54
type _55 = int * ___55
type _56 = int * ___56
type _57 = int * ___57
type _58 = int * ___58
type _59 = int * ___59
type _60 = int * ___60
type _61 = int * ___61
type _62 = int * ___62
type _63 = int * ___63
type _64 = int * ___64
type _65 = int * ___65
type _66 = int * ___66
type _67 = int * ___67
type _68 = int * ___68
type _69 = int * ___69
type _70 = int * ___70
type _71 = int * ___71
type _72 = int * ___72
type _73 = int * ___73
type _74 = int * ___74
type _75 = int * ___75
type _76 = int * ___76
type _77 = int * ___77
type _78 = int * ___78
type _79 = int * ___79
type _80 = int * ___80
type _81 = int * ___81
type _82 = int * ___82
type _83 = int * ___83
type _84 = int * ___84
type _85 = int * ___85
type _86 = int * ___86
type _87 = int * ___87
type _88 = int * ___88
type _89 = int * ___89
type _90 = int * ___90
type _91 = int * ___91
type _92 = int * ___92
type _93 = int * ___93
type _94 = int * ___94
type _95 = int * ___95
type _96 = int * ___96
type _97 = int * ___97
type _98 = int * ___98
type _99 = int * ___99
type _inf = int * ___inf

type 'u __0 = 'u
type 'u __1 = 'u __0 s
type 'u __2 = 'u __1 s
type 'u __3 = 'u __2 s
type 'u __4 = 'u __3 s
type 'u __5 = 'u __4 s
type 'u __6 = 'u __5 s
type 'u __7 = 'u __6 s
type 'u __8 = 'u __7 s
type 'u __9 = 'u __8 s
type 'u __10 = 'u __9 s
type 'u __11 = 'u __10 s
type 'u __12 = 'u __11 s
type 'u __13 = 'u __12 s
type 'u __14 = 'u __13 s
type 'u __15 = 'u __14 s
type 'u __16 = 'u __15 s
type 'u __17 = 'u __16 s
type 'u __18 = 'u __17 s
type 'u __19 = 'u __18 s
type 'u __20 = 'u __19 s
type 'u __21 = 'u __20 s
type 'u __22 = 'u __21 s
type 'u __23 = 'u __22 s
type 'u __24 = 'u __23 s
type 'u __25 = 'u __24 s
type 'u __26 = 'u __25 s
type 'u __27 = 'u __26 s
type 'u __28 = 'u __27 s
type 'u __29 = 'u __28 s
type 'u __30 = 'u __29 s
type 'u __31 = 'u __30 s
type 'u __32 = 'u __31 s
type 'u __33 = 'u __32 s
type 'u __34 = 'u __33 s
type 'u __35 = 'u __34 s
type 'u __36 = 'u __35 s
type 'u __37 = 'u __36 s
type 'u __38 = 'u __37 s
type 'u __39 = 'u __38 s
type 'u __40 = 'u __39 s
type 'u __41 = 'u __40 s
type 'u __42 = 'u __41 s
type 'u __43 = 'u __42 s
type 'u __44 = 'u __43 s
type 'u __45 = 'u __44 s
type 'u __46 = 'u __45 s
type 'u __47 = 'u __46 s
type 'u __48 = 'u __47 s
type 'u __49 = 'u __48 s
type 'u __50 = 'u __49 s
type 'u __51 = 'u __50 s
type 'u __52 = 'u __51 s
type 'u __53 = 'u __52 s
type 'u __54 = 'u __53 s
type 'u __55 = 'u __54 s
type 'u __56 = 'u __55 s
type 'u __57 = 'u __56 s
type 'u __58 = 'u __57 s
type 'u __59 = 'u __58 s
type 'u __60 = 'u __59 s
type 'u __61 = 'u __60 s
type 'u __62 = 'u __61 s
type 'u __63 = 'u __62 s
type 'u __64 = 'u __63 s
type 'u __65 = 'u __64 s
type 'u __66 = 'u __65 s
type 'u __67 = 'u __66 s
type 'u __68 = 'u __67 s
type 'u __69 = 'u __68 s
type 'u __70 = 'u __69 s
type 'u __71 = 'u __70 s
type 'u __72 = 'u __71 s
type 'u __73 = 'u __72 s
type 'u __74 = 'u __73 s
type 'u __75 = 'u __74 s
type 'u __76 = 'u __75 s
type 'u __77 = 'u __76 s
type 'u __78 = 'u __77 s
type 'u __79 = 'u __78 s
type 'u __80 = 'u __79 s
type 'u __81 = 'u __80 s
type 'u __82 = 'u __81 s
type 'u __83 = 'u __82 s
type 'u __84 = 'u __83 s
type 'u __85 = 'u __84 s
type 'u __86 = 'u __85 s
type 'u __87 = 'u __86 s
type 'u __88 = 'u __87 s
type 'u __89 = 'u __88 s
type 'u __90 = 'u __89 s
type 'u __91 = 'u __90 s
type 'u __92 = 'u __91 s
type 'u __93 = 'u __92 s
type 'u __94 = 'u __93 s
type 'u __95 = 'u __94 s
type 'u __96 = 'u __95 s
type 'u __97 = 'u __96 s
type 'u __98 = 'u __97 s
type 'u __99 = 'u __98 s

type 'compile_time_value number

val _0 : 'u __0 number
val _1 : 'u __1 number
val _2 : 'u __2 number
val _3 : 'u __3 number
val _4 : 'u __4 number
val _5 : 'u __5 number
val _6 : 'u __6 number
val _7 : 'u __7 number
val _8 : 'u __8 number
val _9 : 'u __9 number
val _10 : 'u __10 number
val _11 : 'u __11 number
val _12 : 'u __12 number
val _13 : 'u __13 number
val _14 : 'u __14 number
val _15 : 'u __15 number
val _16 : 'u __16 number
val _17 : 'u __17 number
val _18 : 'u __18 number
val _19 : 'u __19 number
val _20 : 'u __20 number
val _21 : 'u __21 number
val _22 : 'u __22 number
val _23 : 'u __23 number
val _24 : 'u __24 number
val _25 : 'u __25 number
val _26 : 'u __26 number
val _27 : 'u __27 number
val _28 : 'u __28 number
val _29 : 'u __29 number
val _30 : 'u __30 number
val _31 : 'u __31 number
val _32 : 'u __32 number
val _33 : 'u __33 number
val _34 : 'u __34 number
val _35 : 'u __35 number
val _36 : 'u __36 number
val _37 : 'u __37 number
val _38 : 'u __38 number
val _39 : 'u __39 number
val _40 : 'u __40 number
val _41 : 'u __41 number
val _42 : 'u __42 number
val _43 : 'u __43 number
val _44 : 'u __44 number
val _45 : 'u __45 number
val _46 : 'u __46 number
val _47 : 'u __47 number
val _48 : 'u __48 number
val _49 : 'u __49 number
val _50 : 'u __50 number
val _51 : 'u __51 number
val _52 : 'u __52 number
val _53 : 'u __53 number
val _54 : 'u __54 number
val _55 : 'u __55 number
val _56 : 'u __56 number
val _57 : 'u __57 number
val _58 : 'u __58 number
val _59 : 'u __59 number
val _60 : 'u __60 number
val _61 : 'u __61 number
val _62 : 'u __62 number
val _63 : 'u __63 number
val _64 : 'u __64 number
val _65 : 'u __65 number
val _66 : 'u __66 number
val _67 : 'u __67 number
val _68 : 'u __68 number
val _69 : 'u __69 number
val _70 : 'u __70 number
val _71 : 'u __71 number
val _72 : 'u __72 number
val _73 : 'u __73 number
val _74 : 'u __74 number
val _75 : 'u __75 number
val _76 : 'u __76 number
val _77 : 'u __77 number
val _78 : 'u __78 number
val _79 : 'u __79 number
val _80 : 'u __80 number
val _81 : 'u __81 number
val _82 : 'u __82 number
val _83 : 'u __83 number
val _84 : 'u __84 number
val _85 : 'u __85 number
val _86 : 'u __86 number
val _87 : 'u __87 number
val _88 : 'u __88 number
val _89 : 'u __89 number
val _90 : 'u __90 number
val _91 : 'u __91 number
val _92 : 'u __92 number
val _93 : 'u __93 number
val _94 : 'u __94 number
val _95 : 'u __95 number
val _96 : 'u __96 number
val _97 : 'u __97 number
val _98 : 'u __98 number
val _99 : 'u __99 number

type __true
type __false

type _true = bool * __true
type _false = bool * __false

(**/**)

type 'a feature
  constraint 'a = 'run_time * 'compile_time
(** A value of type ['a feature] is physically either a
    [bool] or an [int].

    The [constraint] notation can be ignored. It's part of this module's
    internal type machinery for implementing compile-time feature checking.

    Specific features (see below) have types like [_40 feature] or [_true
    feature]. The first is an [int] feature whose run-time value is [40], and
    the second is a [bool] feature whose run-time value is [true].

    As you can see, the run-time value can be seen from the type, and therefore
    from the docs, at a glance. So, you can quickly find out what your libuv
    supports by generating the docs for your Luv installation and looking at
    this module.

    Of course, if you installed Luv through opam/esy and are using its vendored
    libuv, the [int] features will simply be the corresponding libuv version,
    and all the [bool] features will be [_true]. *)

val get : ('run_time * _) feature -> 'run_time
(** Returns the value of a feature at run time — in the ordinary
    way. Examples:

    - [Luv.Require.(get luv05)] returns [7] at the time of this writing — the
      current patch version of Luv (0.5.7).
    - [Luv.Require.(get random)] returns [true] if Luv was linked with a libuv
      late enough that it supports [uv_random] (1.33.0 or higher). *)

val (>=) : (int * 'compile_time) feature -> 'compile_time number -> unit
(** Triggers a compile-time check of an [int] feature.

    For example, take [Luv.Require.(libuv1 >= _33)].

    If the linked libuv has version 1.33.0 or higher, this check compiles. The
    compiled check then does nothing at run time — it is zero-cost.

    If libuv has version less than 1.33.0, compilation of this expression
    triggers a type error. If that is too severe, you can relax to a run-time
    check by doing [Luv.Require.(get libuv1) >= 33] instead.

    The compile-time numbers [_0] — [_99] are defined for use with
    [Luv.Require.(>=)]. They are hidden from this documentation to reduce visual
    noise.

    These compile-time checks are modular in the sense that you can spread them
    throughout your project, locally where various features of libuv are being
    used, so that you don't have to do a survey of all your code in order to
    figure out the overall minimum libuv version. During build, your project
    will compile only if all the checks in its modules pass. They will then be
    optimized away. *)

val has : _true feature -> unit
(** Triggers a compile-time check of a [bool] feature.

    For example, take [Luv.Require.(has random)].

    If the linked libuv has [uv_random], this check compiles, and is fully
    optimized away.

    If libuv lacks [uv_random], compilation of this check triggers a type error.
    The check can be relaxed to run time by doing [Luv.Require.(get random)]
    instead.

    As with {!Luv.Require.(>=)}, you can insert these checks throughout your
    program, locally near where you use libuv features. The project will compile
    only if all the checks pass. *)

(** {1 Features} *)


val libuv1 : _49 feature
(** libuv minor version in the 1.x series.*)

val luv05 : _7 feature
(** Luv patch version in the 0.5.x series.*)

val available_parallelism : _true feature
(** See {!Luv.System_info.available_parallelism}. Requires libuv 1.44.0.*)

val clock_gettime : _true feature
(** See {!Luv.Time.clock_gettime}. Requires libuv 1.45.0.*)

val cpumask_size : _true feature
(** See {!Luv.System_info.cpumask_size}. Requires libuv 1.45.0.*)

val disconnect : _true feature
(** See [`DISCONNECT] in {!Luv.Poll.Event.t}. Requires libuv 1.9.0.*)

val eftype : _true feature
(** See [`EFTYPE] in {!Luv.Error.t}. Requires libuv 1.21.0.*)

val eilseq : _true feature
(** See [`EILSEQ] in {!Luv.Error.t}. Requires libuv 1.32.0.*)

val enodata : _true feature
(** See [`ENODATA] in {!Luv.Error.t}. Requires libuv 1.45.0.*)

val enotty : _true feature
(** See [`ENOTTY] in {!Luv.Error.t}. Requires libuv 1.16.0.*)

val eoverflow : _true feature
(** See [`EOVERFLOW] in {!Luv.Error.t}. Requires libuv 1.42.0.*)

val err_name_r : _true feature
(** See {!Luv.Error.err_name}. Requires libuv 1.22.0.*)

val esocktnosupport : _true feature
(** See [`ESOCKTNOSUPPORT] in {!Luv.Error.t}. Requires libuv 1.42.0.*)

val eunatch : _true feature
(** See [`EUNATCH] in {!Luv.Error.t}. Requires libuv 1.46.0.*)

val fs_copyfile : _true feature
(** See {!Luv.File.copyfile}. Requires libuv 1.14.0.*)

val fs_copyfile_ficlone : _true feature
(** See signature of {!Luv.File.copyfile}. Requires libuv 1.20.0.*)

val fs_lutime : _true feature
(** See {!Luv.File.lutime}. Requires libuv 1.36.0.*)

val fs_lchown : _true feature
(** See {!Luv.File.lchown}. Requires libuv 1.21.0.*)

val fs_mkstemp : _true feature
(** See {!Luv.File.mkstemp}. Requires libuv 1.34.0.*)

val fs_o_filemap : _true feature
(** See [`FILEMAP] {!Luv.File.Open_flag.t}. Requires libuv 1.31.0.*)

val fs_realpath : _true feature
(** See {!Luv.File.realpath}. Requires libuv 1.8.0.*)

val fs_statfs : _true feature
(** See {!Luv.File.statfs}. Requires libuv 1.31.0.*)

val get_available_memory : _true feature
(** See {!Luv.Resource.available_memory}. Requires libuv 1.45.0.*)

val get_constrained_memory : _true feature
(** See {!Luv.Resource.constrained_memory}. Requires libuv 1.29.0.*)

val get_osfhandle : _true feature
(** See {!Luv.File.get_osfhandle}. Requires libuv 1.12.0.*)

val getaffinity : _true feature
(** See {!Luv.Thread.getaffinity} Requires libuv 1.45.0.*)

val getcpu : _true feature
(** See {!Luv.Thread.getcpu}. Requires libuv 1.45.0.*)

val getpriority : _true feature
(** See {!Luv.Thread.getpriority}. Requires libuv 1.48.0.*)

val gettimeofday : _true feature
(** See {!Luv.Time.gettimeofday}. Requires libuv 1.28.0.*)

val if_indextoiid : _true feature
(** See {!Luv.Network.if_indextoiid}. Requires libuv 1.16.0.*)

val if_indextoname : _true feature
(** See {!Luv.Network.if_indextoname}. Requires libuv 1.16.0.*)

val library_shutdown : _true feature
(** See {!Luv.Loop.library_shutdown}. Requires libuv 1.38.0.*)

val loop_fork : _true feature
(** See {!Luv.Loop.fork}. Requires libuv 1.12.0.*)

val maxhostnamesize : _true feature
(** Used internally. Requires libuv 1.26.0.*)

val metrics_idle_time : _true feature
(** See {!Luv.Metrics.idle_time}. Requires libuv 1.39.0.*)

val metrics_info : _true feature
(** See {!Luv.Metrics.info}. Requires libuv 1.45.0.*)

val mutex_init_recursive : _true feature
(** See {!Luv.Mutex.init}. Requires libuv 1.15.0.*)

val open_osfhandle : _true feature
(** See {!Luv.File.open_osfhandle}. Requires libuv 1.23.0.*)

val os_environ : _true feature
(** See {!Luv.Env.environ}. Requires libuv 1.31.0.*)

val os_homedir : _true feature
(** See {!Luv.Path.homedir}. Requires libuv 1.6.0.*)

val os_get_group : _true feature
(** See {!Luv.Passwd.get_group}. Requires libuv 1.45.0.*)

val os_get_passwd : _true feature
(** See {!Luv.Passwd.get_passwd}. Requires libuv 1.9.0.*)

val os_get_passwd_uid : _true feature
(** See {!Luv.Passwd.get_passwd}. Requires libuv 1.45.0.*)

val os_getenv : _true feature
(** See {!Luv.Env.getenv}. Requires libuv 1.12.0.*)

val os_gethostname : _true feature
(** See {!Luv.Network.gethostname}. Requires libuv 1.12.0.*)

val os_getpid : _true feature
(** See {!Luv.Pid.getpid}. Requires libuv 1.18.0.*)

val os_getppid : _true feature
(** See {!Luv.Pid.getppid}. Requires libuv 1.16.0.*)

val os_priority : _true feature
(** See {!Luv.Resource.setpriority}. Requires libuv 1.23.0.*)

val os_tmpdir : _true feature
(** See {!Luv.Path.tmpdir}. Requires libuv 1.9.0.*)

val os_uname : _true feature
(** See {!Luv.System_info.uname}. Requires libuv 1.25.0.*)

val overlapped_pipe : _true feature
(** See {!Luv.Process.to_parent_pipe}. Requires libuv 1.21.0.*)

val pipe : _true feature
(** See {!Luv.Pipe.pipe} Requires libuv 1.41.0.*)

val pipe_bind2 : _true feature
(** See {!Luv.Pipe.bind}. Requires libuv 1.46.0.*)

val pipe_connect2 : _true feature
(** See {!Luv.Pipe.connect}. Requires libuv 1.46.0.*)

val pipe_chmod : _true feature
(** See {!Luv.Pipe.chmod}. Requires libuv 1.16.0.*)

val prioritized : _true feature
(** See [`PRIORITIZED] in {!Luv.Poll.Event.t}. Requires libuv 1.14.0.*)

val process_windows_hide_console : _true feature
(** See {!Luv.Process.spawn}. Requires libuv 1.24.0.*)

val process_windows_hide_gui : _true feature
(** See {!Luv.Process.spawn}. Requires libuv 1.24.0.*)

val process_windows_file_path_exact_name : _true feature
(** See {!Luv.Process.spawn}. Requires libuv 1.48.0.*)

val random : _true feature
(** See {!Luv.Random.random}. Requires libuv 1.33.0.*)

val readdir : _true feature
(** See {!Luv.File.readdir}. Requires libuv 1.28.0.*)

val setaffinity : _true feature
(** See {!Luv.Thread.setaffinity}. Requires libuv 1.45.0.*)

val setpriority : _true feature
(** See {!Luv.Thread.setpriority}. Requires libuv 1.48.0.*)

val signal_start_oneshot : _true feature
(** See {!Luv.Signal.start_oneshot}. Requires libuv 1.12.0.*)

val sleep : _true feature
(** See {!Luv.Time.sleep}. Requires libuv 1.34.0.*)

val socketpair : _true feature
(** See {!Luv.TCP.socketpair}. Requires libuv 1.41.0.*)

val strerror_r : _true feature
(** See {!Luv.Error.strerror}. Requires libuv 1.22.0.*)

val tcp_close_reset : _true feature
(** See {!Luv.TCP.close_reset}. Requires libuv 1.32.0.*)

val tcp_init_ex : _true feature
(** See {!Luv.TCP.init}. Requires libuv 1.7.0.*)

val timer_get_due_in : _true feature
(** See {!Luv.Timer.get_due_in}. Requires libuv 1.40.0.*)

val thread_stack_size : _true feature
(** See {!Luv.Thread.create}. Requires libuv 1.26.0.*)

val translate_sys_error : _true feature
(** See {!Luv.Error.translate_sys_error}. Requires libuv 1.10.0.*)

val try_write2 : _true feature
(** See {!Luv.Stream.try_write2}. Requires libuv 1.42.0.*)

val tty_vterm_state : _true feature
(** See {!Luv.TTY.set_vterm_state}. Requires libuv 1.33.0.*)

val udp_connect : _true feature
(** See {!Luv.UDP.Connected}. Requires libuv 1.27.0.*)

val udp_init_ex : _true feature
(** See {!Luv.UDP.init}. Requires libuv 1.7.0.*)

val udp_mmsg_chunk : _true feature
(** See [`MMSG_CHUNK] in {!Luv.UDP.Recv_flag.t}. Requires libuv 1.35.0.*)

val udp_mmsg_free : _true feature
(** See [`MMSG_FREE] in {!Luv.UDP.Recv_flag.t}. Requires libuv 1.40.0.*)

val udp_recvmmsg : _true feature
(** See {!Luv.UDP.init}. Requires libuv 1.37.0.*)

val udp_set_source_membership : _true feature
(** See {!Luv.UDP.set_source_membership}. Requires libuv 1.32.0.*)

val udp_using_recvmmsg : _true feature
(** See {!Luv.UDP.using_recvmmsg}. Requires libuv 1.39.0.*)

val utf_16 : _true feature
(** See {!Luv.String}. Requires libuv 1.47.0.*)
