// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/paymentgateway/issuerswitch/v1/resolutions.proto

package issuerswitch

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	money "google.golang.org/genproto/googleapis/type/money"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The subtype of the complaint or dispute.
type TransactionSubType int32

const (
	// Unspecified transaction subtype.
	TransactionSubType_TRANSACTION_SUB_TYPE_UNSPECIFIED TransactionSubType = 0
	// Beneficiary transaction subtype.
	TransactionSubType_TRANSACTION_SUB_TYPE_BENEFICIARY TransactionSubType = 1
	// Remitter transaction subtype.
	TransactionSubType_TRANSACTION_SUB_TYPE_REMITTER TransactionSubType = 2
)

// Enum value maps for TransactionSubType.
var (
	TransactionSubType_name = map[int32]string{
		0: "TRANSACTION_SUB_TYPE_UNSPECIFIED",
		1: "TRANSACTION_SUB_TYPE_BENEFICIARY",
		2: "TRANSACTION_SUB_TYPE_REMITTER",
	}
	TransactionSubType_value = map[string]int32{
		"TRANSACTION_SUB_TYPE_UNSPECIFIED": 0,
		"TRANSACTION_SUB_TYPE_BENEFICIARY": 1,
		"TRANSACTION_SUB_TYPE_REMITTER":    2,
	}
)

func (x TransactionSubType) Enum() *TransactionSubType {
	p := new(TransactionSubType)
	*p = x
	return p
}

func (x TransactionSubType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionSubType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[0].Descriptor()
}

func (TransactionSubType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[0]
}

func (x TransactionSubType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionSubType.Descriptor instead.
func (TransactionSubType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{0}
}

// The adjusment flag for raising complaint.
type RaiseComplaintAdjustment_AdjustmentFlag int32

const (
	// Unspecified adjustment flag.
	RaiseComplaintAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED RaiseComplaintAdjustment_AdjustmentFlag = 0
	// Complaint Raise. This flag maps to the `PBRB` adjustment flag as defined
	// in NPCI's `UDIR` specification.
	RaiseComplaintAdjustment_RAISE RaiseComplaintAdjustment_AdjustmentFlag = 1
)

// Enum value maps for RaiseComplaintAdjustment_AdjustmentFlag.
var (
	RaiseComplaintAdjustment_AdjustmentFlag_name = map[int32]string{
		0: "ADJUSTMENT_FLAG_UNSPECIFIED",
		1: "RAISE",
	}
	RaiseComplaintAdjustment_AdjustmentFlag_value = map[string]int32{
		"ADJUSTMENT_FLAG_UNSPECIFIED": 0,
		"RAISE":                       1,
	}
)

func (x RaiseComplaintAdjustment_AdjustmentFlag) Enum() *RaiseComplaintAdjustment_AdjustmentFlag {
	p := new(RaiseComplaintAdjustment_AdjustmentFlag)
	*p = x
	return p
}

func (x RaiseComplaintAdjustment_AdjustmentFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiseComplaintAdjustment_AdjustmentFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[1].Descriptor()
}

func (RaiseComplaintAdjustment_AdjustmentFlag) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[1]
}

func (x RaiseComplaintAdjustment_AdjustmentFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiseComplaintAdjustment_AdjustmentFlag.Descriptor instead.
func (RaiseComplaintAdjustment_AdjustmentFlag) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{9, 0}
}

// The reason for raising complaint.
type RaiseComplaintAdjustment_ReasonCode int32

const (
	// Unspecified reason code.
	RaiseComplaintAdjustment_REASON_CODE_UNSPECIFIED RaiseComplaintAdjustment_ReasonCode = 0
	// Customer account has not yet reversed for a declined pay transaction.
	// This reason code maps to the `U005` reason code as defined in NPCI's
	// `UDIR` specification.
	RaiseComplaintAdjustment_CUSTOMER_ACCOUNT_NOT_REVERSED RaiseComplaintAdjustment_ReasonCode = 1
	// Goods / services are not provided for approved transaction.
	// This reason code maps to the `U008` reason code as defined in NPCI's
	// `UDIR` specification.
	RaiseComplaintAdjustment_GOODS_SERVICES_NOT_PROVIDED RaiseComplaintAdjustment_ReasonCode = 2
	// Customer account not credited back for declined transaction. This
	// reason code maps to the `U009` reason code as defined in NPCI's `UDIR`
	// specification.
	RaiseComplaintAdjustment_CUSTOMER_ACCOUNT_NOT_CREDITED_BACK RaiseComplaintAdjustment_ReasonCode = 3
	// Beneficiary account is not credited for successful pay transaction. This
	// reason code maps to the `U010` reason code as defined in NPCI's `UDIR`
	// specification.
	RaiseComplaintAdjustment_BENEFICIARY_ACCOUNT_NOT_CREDITED RaiseComplaintAdjustment_ReasonCode = 4
	// Credit not processed for cancelled or returned goods and services.
	// This reason code maps to the `U021` reason code as defined in NPCI's
	// `UDIR` specification.
	RaiseComplaintAdjustment_GOODS_SERVICES_CREDIT_NOT_PROCESSED RaiseComplaintAdjustment_ReasonCode = 5
	// Account debited but transaction confirmation not received at merchant
	// location. This reason code maps to the `U022` reason code as defined in
	// NPCI's `UDIR` specification.
	RaiseComplaintAdjustment_MERCHANT_NOT_RECEIVED_CONFIRMATION RaiseComplaintAdjustment_ReasonCode = 6
	// Paid by alternate means / Duplicate payment. This reason code maps to the
	// `U023` reason code as defined in NPCI's `UDIR` specification.
	RaiseComplaintAdjustment_PAID_BY_ALTERNATE_MEANS RaiseComplaintAdjustment_ReasonCode = 7
)

// Enum value maps for RaiseComplaintAdjustment_ReasonCode.
var (
	RaiseComplaintAdjustment_ReasonCode_name = map[int32]string{
		0: "REASON_CODE_UNSPECIFIED",
		1: "CUSTOMER_ACCOUNT_NOT_REVERSED",
		2: "GOODS_SERVICES_NOT_PROVIDED",
		3: "CUSTOMER_ACCOUNT_NOT_CREDITED_BACK",
		4: "BENEFICIARY_ACCOUNT_NOT_CREDITED",
		5: "GOODS_SERVICES_CREDIT_NOT_PROCESSED",
		6: "MERCHANT_NOT_RECEIVED_CONFIRMATION",
		7: "PAID_BY_ALTERNATE_MEANS",
	}
	RaiseComplaintAdjustment_ReasonCode_value = map[string]int32{
		"REASON_CODE_UNSPECIFIED":             0,
		"CUSTOMER_ACCOUNT_NOT_REVERSED":       1,
		"GOODS_SERVICES_NOT_PROVIDED":         2,
		"CUSTOMER_ACCOUNT_NOT_CREDITED_BACK":  3,
		"BENEFICIARY_ACCOUNT_NOT_CREDITED":    4,
		"GOODS_SERVICES_CREDIT_NOT_PROCESSED": 5,
		"MERCHANT_NOT_RECEIVED_CONFIRMATION":  6,
		"PAID_BY_ALTERNATE_MEANS":             7,
	}
)

func (x RaiseComplaintAdjustment_ReasonCode) Enum() *RaiseComplaintAdjustment_ReasonCode {
	p := new(RaiseComplaintAdjustment_ReasonCode)
	*p = x
	return p
}

func (x RaiseComplaintAdjustment_ReasonCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiseComplaintAdjustment_ReasonCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[2].Descriptor()
}

func (RaiseComplaintAdjustment_ReasonCode) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[2]
}

func (x RaiseComplaintAdjustment_ReasonCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiseComplaintAdjustment_ReasonCode.Descriptor instead.
func (RaiseComplaintAdjustment_ReasonCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{9, 1}
}

// The adjusment flag for resolving the complaint.
type ResolveComplaintAdjustment_AdjustmentFlag int32

const (
	// Unspecified adjustment flag.
	ResolveComplaintAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED ResolveComplaintAdjustment_AdjustmentFlag = 0
	// Debit Reversal Confirmation. This flag maps to the `DRC` adjustment flag
	// as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_DEBIT_REVERSAL_CONFIRMATION ResolveComplaintAdjustment_AdjustmentFlag = 1
	// Return. This flag maps to the `RET` adjustment flag as defined in NPCI's
	// `UDIR` specification.
	ResolveComplaintAdjustment_RETURN ResolveComplaintAdjustment_AdjustmentFlag = 2
	// Refund Reversal Confirmation. This flag maps to the `RRC` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_REFUND_REVERSAL_CONFIRMATION ResolveComplaintAdjustment_AdjustmentFlag = 3
	// Transaction Credit Confirmation. This flag maps to the `TCC` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_TRANSACTION_CREDIT_CONFIRMATION ResolveComplaintAdjustment_AdjustmentFlag = 4
)

// Enum value maps for ResolveComplaintAdjustment_AdjustmentFlag.
var (
	ResolveComplaintAdjustment_AdjustmentFlag_name = map[int32]string{
		0: "ADJUSTMENT_FLAG_UNSPECIFIED",
		1: "DEBIT_REVERSAL_CONFIRMATION",
		2: "RETURN",
		3: "REFUND_REVERSAL_CONFIRMATION",
		4: "TRANSACTION_CREDIT_CONFIRMATION",
	}
	ResolveComplaintAdjustment_AdjustmentFlag_value = map[string]int32{
		"ADJUSTMENT_FLAG_UNSPECIFIED":     0,
		"DEBIT_REVERSAL_CONFIRMATION":     1,
		"RETURN":                          2,
		"REFUND_REVERSAL_CONFIRMATION":    3,
		"TRANSACTION_CREDIT_CONFIRMATION": 4,
	}
)

func (x ResolveComplaintAdjustment_AdjustmentFlag) Enum() *ResolveComplaintAdjustment_AdjustmentFlag {
	p := new(ResolveComplaintAdjustment_AdjustmentFlag)
	*p = x
	return p
}

func (x ResolveComplaintAdjustment_AdjustmentFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolveComplaintAdjustment_AdjustmentFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[3].Descriptor()
}

func (ResolveComplaintAdjustment_AdjustmentFlag) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[3]
}

func (x ResolveComplaintAdjustment_AdjustmentFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResolveComplaintAdjustment_AdjustmentFlag.Descriptor instead.
func (ResolveComplaintAdjustment_AdjustmentFlag) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{10, 0}
}

// The complaint resolution reason code.
type ResolveComplaintAdjustment_ReasonCode int32

const (
	// Unspecified reason code.
	ResolveComplaintAdjustment_REASON_CODE_UNSPECIFIED ResolveComplaintAdjustment_ReasonCode = 0
	// Customer account has been reversed online for DRC dispute or beneficiary
	// account has been credited online for TCC dispute. This reason code maps
	// to the `102` reason code as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_COMPLAINT_RESOLVED_ONLINE ResolveComplaintAdjustment_ReasonCode = 1
	// Customer account has been reversed now or manually post reconciliation
	// for DRC dispute or beneficiary account has been credited now or manually
	// post reconciliation for TCC dispute. This reason code maps to the `103`
	// reason code as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_COMPLAINT_RESOLVED_NOW_OR_MANUALLY ResolveComplaintAdjustment_ReasonCode = 2
	// Online decline response failed. This reason code maps to the
	// `104` reason code as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_ORIGINAL_TRANSACTION_NOT_DONE ResolveComplaintAdjustment_ReasonCode = 3
	// Account closed. This reason code maps to the `114` reason code for
	// RET dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_ACCOUNT_CLOSED ResolveComplaintAdjustment_ReasonCode = 4
	// Account does not exist. This reason code maps to the `115` reason code
	// for RET dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_ACCOUNT_DOES_NOT_EXIST ResolveComplaintAdjustment_ReasonCode = 5
	// Party instructions. This reason code maps to the `116` reason code for
	// RET dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_PARTY_INSTRUCTIONS ResolveComplaintAdjustment_ReasonCode = 6
	// NRI account. This reason code maps to the `117` reason code for RET
	// dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_NRI_ACCOUNT ResolveComplaintAdjustment_ReasonCode = 7
	// Credit freezed. This reason code maps to the `118` reason code for RET
	// dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_CREDIT_FREEZED ResolveComplaintAdjustment_ReasonCode = 8
	// Invalid beneficiary details. This reason code maps to the `119` reason
	// code for RET dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_INVALID_BENEFICIARY_DETAILS ResolveComplaintAdjustment_ReasonCode = 9
	// Any other reason. This reason code maps to the `120` reason code for RET
	// dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_ANY_OTHER_REASON ResolveComplaintAdjustment_ReasonCode = 10
	// Beneficiary bank unable to credit their customer account.
	// This reason code maps to the `1094` reason code for RET dispute as
	// defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_BENEFICIARY_CANNOT_CREDIT ResolveComplaintAdjustment_ReasonCode = 11
	// Account debited but transaction confirmation not received at merchant
	// location. This reason code maps to the `1065` reason code for Credit
	// adjustment and RET dispute as defined in NPCI's `UDIR` specification.
	ResolveComplaintAdjustment_RET_MERCHANT_NOT_RECEIVED_CONFIRMATION ResolveComplaintAdjustment_ReasonCode = 12
	// Customer account has been credited. This reason code maps to the `501`
	// reason code for Refund reversal confirmation dispute as defined in NPCI's
	// `UDIR` specification.
	ResolveComplaintAdjustment_RRC_CUSTOMER_ACCOUNT_CREDITED ResolveComplaintAdjustment_ReasonCode = 13
)

// Enum value maps for ResolveComplaintAdjustment_ReasonCode.
var (
	ResolveComplaintAdjustment_ReasonCode_name = map[int32]string{
		0:  "REASON_CODE_UNSPECIFIED",
		1:  "COMPLAINT_RESOLVED_ONLINE",
		2:  "COMPLAINT_RESOLVED_NOW_OR_MANUALLY",
		3:  "ORIGINAL_TRANSACTION_NOT_DONE",
		4:  "RET_ACCOUNT_CLOSED",
		5:  "RET_ACCOUNT_DOES_NOT_EXIST",
		6:  "RET_PARTY_INSTRUCTIONS",
		7:  "RET_NRI_ACCOUNT",
		8:  "RET_CREDIT_FREEZED",
		9:  "RET_INVALID_BENEFICIARY_DETAILS",
		10: "RET_ANY_OTHER_REASON",
		11: "RET_BENEFICIARY_CANNOT_CREDIT",
		12: "RET_MERCHANT_NOT_RECEIVED_CONFIRMATION",
		13: "RRC_CUSTOMER_ACCOUNT_CREDITED",
	}
	ResolveComplaintAdjustment_ReasonCode_value = map[string]int32{
		"REASON_CODE_UNSPECIFIED":                0,
		"COMPLAINT_RESOLVED_ONLINE":              1,
		"COMPLAINT_RESOLVED_NOW_OR_MANUALLY":     2,
		"ORIGINAL_TRANSACTION_NOT_DONE":          3,
		"RET_ACCOUNT_CLOSED":                     4,
		"RET_ACCOUNT_DOES_NOT_EXIST":             5,
		"RET_PARTY_INSTRUCTIONS":                 6,
		"RET_NRI_ACCOUNT":                        7,
		"RET_CREDIT_FREEZED":                     8,
		"RET_INVALID_BENEFICIARY_DETAILS":        9,
		"RET_ANY_OTHER_REASON":                   10,
		"RET_BENEFICIARY_CANNOT_CREDIT":          11,
		"RET_MERCHANT_NOT_RECEIVED_CONFIRMATION": 12,
		"RRC_CUSTOMER_ACCOUNT_CREDITED":          13,
	}
)

func (x ResolveComplaintAdjustment_ReasonCode) Enum() *ResolveComplaintAdjustment_ReasonCode {
	p := new(ResolveComplaintAdjustment_ReasonCode)
	*p = x
	return p
}

func (x ResolveComplaintAdjustment_ReasonCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolveComplaintAdjustment_ReasonCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[4].Descriptor()
}

func (ResolveComplaintAdjustment_ReasonCode) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[4]
}

func (x ResolveComplaintAdjustment_ReasonCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResolveComplaintAdjustment_ReasonCode.Descriptor instead.
func (ResolveComplaintAdjustment_ReasonCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{10, 1}
}

// The adjusment flag for raising dispute.
type RaiseDisputeAdjustment_AdjustmentFlag int32

const (
	// Unspecified adjustment flag.
	RaiseDisputeAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED RaiseDisputeAdjustment_AdjustmentFlag = 0
	// Chargeback Raise. This flag maps to the `B` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_CHARGEBACK_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 1
	// Fraud Chargeback Raise. This flag maps to the `FC` adjustment flag
	// as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_FRAUD_CHARGEBACK_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 2
	// Wrong Credit Chargeback Raise. This flag maps to the `WC` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_WRONG_CREDIT_CHARGEBACK_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 3
	// Deferred Chargeback Raise. This flag maps to the `FB` adjustment flag
	// as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DEFERRED_CHARGEBACK_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 4
	// Pre-Arbitration Raise. This flag maps to the `P` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_PRE_ARBITRATION_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 5
	// Deferred Pre-Arbitration Raise. This flag maps to the `FP` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DEFERRED_PRE_ARBITRATION_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 6
	// Arbitration Raise. This flag maps to the `AR` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_ARBITRATION_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 7
	// Deferred Arbitration Raise. This flag maps to the `FAR` adjustment flag
	// as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DEFERRED_ARBITRATION_RAISE RaiseDisputeAdjustment_AdjustmentFlag = 8
)

// Enum value maps for RaiseDisputeAdjustment_AdjustmentFlag.
var (
	RaiseDisputeAdjustment_AdjustmentFlag_name = map[int32]string{
		0: "ADJUSTMENT_FLAG_UNSPECIFIED",
		1: "CHARGEBACK_RAISE",
		2: "FRAUD_CHARGEBACK_RAISE",
		3: "WRONG_CREDIT_CHARGEBACK_RAISE",
		4: "DEFERRED_CHARGEBACK_RAISE",
		5: "PRE_ARBITRATION_RAISE",
		6: "DEFERRED_PRE_ARBITRATION_RAISE",
		7: "ARBITRATION_RAISE",
		8: "DEFERRED_ARBITRATION_RAISE",
	}
	RaiseDisputeAdjustment_AdjustmentFlag_value = map[string]int32{
		"ADJUSTMENT_FLAG_UNSPECIFIED":    0,
		"CHARGEBACK_RAISE":               1,
		"FRAUD_CHARGEBACK_RAISE":         2,
		"WRONG_CREDIT_CHARGEBACK_RAISE":  3,
		"DEFERRED_CHARGEBACK_RAISE":      4,
		"PRE_ARBITRATION_RAISE":          5,
		"DEFERRED_PRE_ARBITRATION_RAISE": 6,
		"ARBITRATION_RAISE":              7,
		"DEFERRED_ARBITRATION_RAISE":     8,
	}
)

func (x RaiseDisputeAdjustment_AdjustmentFlag) Enum() *RaiseDisputeAdjustment_AdjustmentFlag {
	p := new(RaiseDisputeAdjustment_AdjustmentFlag)
	*p = x
	return p
}

func (x RaiseDisputeAdjustment_AdjustmentFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiseDisputeAdjustment_AdjustmentFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[5].Descriptor()
}

func (RaiseDisputeAdjustment_AdjustmentFlag) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[5]
}

func (x RaiseDisputeAdjustment_AdjustmentFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiseDisputeAdjustment_AdjustmentFlag.Descriptor instead.
func (RaiseDisputeAdjustment_AdjustmentFlag) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{11, 0}
}

// The reason for raising dispute.
type RaiseDisputeAdjustment_ReasonCode int32

const (
	// Unspecified reason code.
	RaiseDisputeAdjustment_REASON_CODE_UNSPECIFIED RaiseDisputeAdjustment_ReasonCode = 0
	// Remitter account is debited but beneficiary account is not credited.
	// This reason code maps to the `108` reason code as defined in
	// NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_CHARGEBACK_RAISE_REMITTER_DEBITED_BENEFICIARY_NOT_CREDITED RaiseDisputeAdjustment_ReasonCode = 1
	// Remitter bank customer still disputes that beneficiary account is not
	// credited. This reason code maps to the `109` reason code as defined in
	// NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_PRE_ARBITRATION_RAISE_BENEFICIARY_NOT_CREDITED RaiseDisputeAdjustment_ReasonCode = 2
	// TCC has been raised but customer still complaining that beneficiary
	// account is not credited. This reason code maps to the `121` reason code
	// as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DEFERRED_CHARGEBACK_RAISE_BENEFICIARY_NOT_CREDITED RaiseDisputeAdjustment_ReasonCode = 3
	// Customer is still complaining for not crediting the beneficiary
	// customer account. This reason code maps to the `124` reason code as
	// defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DEFERRED_PRE_ARBITRATION_RAISE_BENEFICIARY_NOT_CREDITED RaiseDisputeAdjustment_ReasonCode = 4
	// Customer is complaining even after raising Deferred Chargeback and
	// Pre-Arbitration on Deferred Chargeback where both have been rejected by
	// beneficiary bank. This reason code maps to the `127` reason code as
	// defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DEFERRED_ARBITRATION_RAISE_DEFERRED_CHARGEBACK_PRE_ARBITRATION_REJECTED RaiseDisputeAdjustment_ReasonCode = 5
	// Chargeback on fraudulent transaction. This reason code maps to the `128`
	// reason code as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_CHARGEBACK_ON_FRAUD RaiseDisputeAdjustment_ReasonCode = 6
	// Credit not processed for cancelled or returned goods and services. This
	// reason code maps to the `1061` reason code as defined in NPCI's `UDIR`
	// specification.
	RaiseDisputeAdjustment_GOODS_SERVICES_CREDIT_NOT_PROCESSED RaiseDisputeAdjustment_ReasonCode = 7
	// Goods and services not as described / defective. This reason code maps to
	// the `1062` reason code as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_GOODS_SERVICES_DEFECTIVE RaiseDisputeAdjustment_ReasonCode = 8
	// Paid by alternate means. This reason code maps to the `1063` reason code
	// as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_PAID_BY_ALTERNATE_MEANS RaiseDisputeAdjustment_ReasonCode = 9
	// Goods or services not provided / not received. This reason code maps to
	// the `1064` reason code as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_GOODS_SERVICES_NOT_RECEIVED RaiseDisputeAdjustment_ReasonCode = 10
	// Account debited but transaction confirmation not received at merchant
	// location. This reason code maps to the `1065` reason code for chargeback
	// raise and deferred chargeback raise as defined in NPCI's `UDIR`
	// specification.
	RaiseDisputeAdjustment_MERCHANT_NOT_RECEIVED_CONFIRMATION RaiseDisputeAdjustment_ReasonCode = 11
	// Transaction not steeled within the specified timeframes. This reason code
	// maps to the `1081` reason code as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_TRANSACTION_NOT_STEELED RaiseDisputeAdjustment_ReasonCode = 12
	// Duplicate / Multiple transaction. This reason code maps to the `1084`
	// reason code as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_DUPLICATE_TRANSACTION RaiseDisputeAdjustment_ReasonCode = 13
	// Card holder was charged more than the transaction amount.
	// This reason code maps to the `1085` reason code for Chargeback raise
	// dispute as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_CHARGEBACK_CARD_HOLDER_CHARGED_MORE RaiseDisputeAdjustment_ReasonCode = 14
	// Customer is still claiming that services are not delivered. This reason
	// code maps to the `1097` reason code as defined in NPCI's `UDIR`
	// specification.
	RaiseDisputeAdjustment_CUSTOMER_CLAIMING_GOODS_SERVICES_NOT_DELIVERED RaiseDisputeAdjustment_ReasonCode = 15
	// Both the parties denied to agree. This reason code maps to the `1100`
	// reason code as defined in NPCI's `UDIR` specification.
	RaiseDisputeAdjustment_PARTIES_DENIED RaiseDisputeAdjustment_ReasonCode = 16
	// Customer transferred funds to the unintended beneficiary account. This
	// reason code maps to the `WC1` reason code as defined in NPCI's `UDIR`
	// specification.
	RaiseDisputeAdjustment_FUNDS_TRANSFERRED_TO_UNINTENDED_BENEFICIARY RaiseDisputeAdjustment_ReasonCode = 17
)

// Enum value maps for RaiseDisputeAdjustment_ReasonCode.
var (
	RaiseDisputeAdjustment_ReasonCode_name = map[int32]string{
		0:  "REASON_CODE_UNSPECIFIED",
		1:  "CHARGEBACK_RAISE_REMITTER_DEBITED_BENEFICIARY_NOT_CREDITED",
		2:  "PRE_ARBITRATION_RAISE_BENEFICIARY_NOT_CREDITED",
		3:  "DEFERRED_CHARGEBACK_RAISE_BENEFICIARY_NOT_CREDITED",
		4:  "DEFERRED_PRE_ARBITRATION_RAISE_BENEFICIARY_NOT_CREDITED",
		5:  "DEFERRED_ARBITRATION_RAISE_DEFERRED_CHARGEBACK_PRE_ARBITRATION_REJECTED",
		6:  "CHARGEBACK_ON_FRAUD",
		7:  "GOODS_SERVICES_CREDIT_NOT_PROCESSED",
		8:  "GOODS_SERVICES_DEFECTIVE",
		9:  "PAID_BY_ALTERNATE_MEANS",
		10: "GOODS_SERVICES_NOT_RECEIVED",
		11: "MERCHANT_NOT_RECEIVED_CONFIRMATION",
		12: "TRANSACTION_NOT_STEELED",
		13: "DUPLICATE_TRANSACTION",
		14: "CHARGEBACK_CARD_HOLDER_CHARGED_MORE",
		15: "CUSTOMER_CLAIMING_GOODS_SERVICES_NOT_DELIVERED",
		16: "PARTIES_DENIED",
		17: "FUNDS_TRANSFERRED_TO_UNINTENDED_BENEFICIARY",
	}
	RaiseDisputeAdjustment_ReasonCode_value = map[string]int32{
		"REASON_CODE_UNSPECIFIED":                                                 0,
		"CHARGEBACK_RAISE_REMITTER_DEBITED_BENEFICIARY_NOT_CREDITED":              1,
		"PRE_ARBITRATION_RAISE_BENEFICIARY_NOT_CREDITED":                          2,
		"DEFERRED_CHARGEBACK_RAISE_BENEFICIARY_NOT_CREDITED":                      3,
		"DEFERRED_PRE_ARBITRATION_RAISE_BENEFICIARY_NOT_CREDITED":                 4,
		"DEFERRED_ARBITRATION_RAISE_DEFERRED_CHARGEBACK_PRE_ARBITRATION_REJECTED": 5,
		"CHARGEBACK_ON_FRAUD":                                                     6,
		"GOODS_SERVICES_CREDIT_NOT_PROCESSED":                                     7,
		"GOODS_SERVICES_DEFECTIVE":                                                8,
		"PAID_BY_ALTERNATE_MEANS":                                                 9,
		"GOODS_SERVICES_NOT_RECEIVED":                                             10,
		"MERCHANT_NOT_RECEIVED_CONFIRMATION":                                      11,
		"TRANSACTION_NOT_STEELED":                                                 12,
		"DUPLICATE_TRANSACTION":                                                   13,
		"CHARGEBACK_CARD_HOLDER_CHARGED_MORE":                                     14,
		"CUSTOMER_CLAIMING_GOODS_SERVICES_NOT_DELIVERED":                          15,
		"PARTIES_DENIED":                                                          16,
		"FUNDS_TRANSFERRED_TO_UNINTENDED_BENEFICIARY":                             17,
	}
)

func (x RaiseDisputeAdjustment_ReasonCode) Enum() *RaiseDisputeAdjustment_ReasonCode {
	p := new(RaiseDisputeAdjustment_ReasonCode)
	*p = x
	return p
}

func (x RaiseDisputeAdjustment_ReasonCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiseDisputeAdjustment_ReasonCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[6].Descriptor()
}

func (RaiseDisputeAdjustment_ReasonCode) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[6]
}

func (x RaiseDisputeAdjustment_ReasonCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiseDisputeAdjustment_ReasonCode.Descriptor instead.
func (RaiseDisputeAdjustment_ReasonCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{11, 1}
}

// The adjusment flag for resolving the dispute.
type ResolveDisputeAdjustment_AdjustmentFlag int32

const (
	// Unspecified adjustment flag.
	ResolveDisputeAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED ResolveDisputeAdjustment_AdjustmentFlag = 0
	// Re-presentment Raise. This flag maps to the `R` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_RE_PRESENTMENT_RAISE ResolveDisputeAdjustment_AdjustmentFlag = 1
	// Deferred Re-presentment Raise. This flag maps to the `FR` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_RE_PRESENTMENT_RAISE ResolveDisputeAdjustment_AdjustmentFlag = 2
	// Chargeback Acceptance. This flag maps to the `A` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CHARGEBACK_ACCEPTANCE ResolveDisputeAdjustment_AdjustmentFlag = 3
	// Deferred Chargeback Acceptance. This flag maps to the `FA` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_CHARGEBACK_ACCEPTANCE ResolveDisputeAdjustment_AdjustmentFlag = 4
	// Pre-Arbitration Acceptance. This flag maps to the `AP` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_PRE_ARBITRATION_ACCEPTANCE ResolveDisputeAdjustment_AdjustmentFlag = 5
	// Deferred Pre-Arbitration Acceptance. This flag maps to the `FAP`
	// adjustment flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_PRE_ARBITRATION_ACCEPTANCE ResolveDisputeAdjustment_AdjustmentFlag = 6
	// Pre-Arbitration Declined. This flag maps to the `PR` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_PRE_ARBITRATION_DECLINED ResolveDisputeAdjustment_AdjustmentFlag = 7
	// Deferred Pre-Arbitration Declined. This flag maps to the `FPR` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_PRE_ARBITRATION_DECLINED ResolveDisputeAdjustment_AdjustmentFlag = 8
	// Arbitration Acceptance. This flag maps to the `ACA` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_ACCEPTANCE ResolveDisputeAdjustment_AdjustmentFlag = 9
	// Arbitration Continuation. This flag maps to the `ACC` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_CONTINUATION ResolveDisputeAdjustment_AdjustmentFlag = 10
	// Arbitration Withdrawn. This flag maps to the `ACW` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_WITHDRAWN ResolveDisputeAdjustment_AdjustmentFlag = 11
	// Arbitration Verdict. This flag maps to the `ACV` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_VERDICT ResolveDisputeAdjustment_AdjustmentFlag = 12
	// Credit Adjustment. This flag maps to the `C` adjustment flag as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT ResolveDisputeAdjustment_AdjustmentFlag = 13
	// Fraud Chargeback Representment. This flag maps to the `FCR` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_FRAUD_CHARGEBACK_REPRESENTMENT ResolveDisputeAdjustment_AdjustmentFlag = 14
	// Fraud Chargeback Accept. This flag maps to the `FCA` adjustment flag
	// as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_FRAUD_CHARGEBACK_ACCEPT ResolveDisputeAdjustment_AdjustmentFlag = 15
	// Wrong Credit Representment. This flag maps to the `WR` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_WRONG_CREDIT_REPRESENTMENT ResolveDisputeAdjustment_AdjustmentFlag = 16
	// Wrong Credit Chargeback Acceptance. This flag maps to the `WA` adjustment
	// flag as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_WRONG_CREDIT_CHARGEBACK_ACCEPTANCE ResolveDisputeAdjustment_AdjustmentFlag = 17
	// Manual Adjustment. This flag maps to the `MA` adjustment flag as defined
	// in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_MANUAL_ADJUSTMENT ResolveDisputeAdjustment_AdjustmentFlag = 18
)

// Enum value maps for ResolveDisputeAdjustment_AdjustmentFlag.
var (
	ResolveDisputeAdjustment_AdjustmentFlag_name = map[int32]string{
		0:  "ADJUSTMENT_FLAG_UNSPECIFIED",
		1:  "RE_PRESENTMENT_RAISE",
		2:  "DEFERRED_RE_PRESENTMENT_RAISE",
		3:  "CHARGEBACK_ACCEPTANCE",
		4:  "DEFERRED_CHARGEBACK_ACCEPTANCE",
		5:  "PRE_ARBITRATION_ACCEPTANCE",
		6:  "DEFERRED_PRE_ARBITRATION_ACCEPTANCE",
		7:  "PRE_ARBITRATION_DECLINED",
		8:  "DEFERRED_PRE_ARBITRATION_DECLINED",
		9:  "ARBITRATION_ACCEPTANCE",
		10: "ARBITRATION_CONTINUATION",
		11: "ARBITRATION_WITHDRAWN",
		12: "ARBITRATION_VERDICT",
		13: "CREDIT_ADJUSTMENT",
		14: "FRAUD_CHARGEBACK_REPRESENTMENT",
		15: "FRAUD_CHARGEBACK_ACCEPT",
		16: "WRONG_CREDIT_REPRESENTMENT",
		17: "WRONG_CREDIT_CHARGEBACK_ACCEPTANCE",
		18: "MANUAL_ADJUSTMENT",
	}
	ResolveDisputeAdjustment_AdjustmentFlag_value = map[string]int32{
		"ADJUSTMENT_FLAG_UNSPECIFIED":         0,
		"RE_PRESENTMENT_RAISE":                1,
		"DEFERRED_RE_PRESENTMENT_RAISE":       2,
		"CHARGEBACK_ACCEPTANCE":               3,
		"DEFERRED_CHARGEBACK_ACCEPTANCE":      4,
		"PRE_ARBITRATION_ACCEPTANCE":          5,
		"DEFERRED_PRE_ARBITRATION_ACCEPTANCE": 6,
		"PRE_ARBITRATION_DECLINED":            7,
		"DEFERRED_PRE_ARBITRATION_DECLINED":   8,
		"ARBITRATION_ACCEPTANCE":              9,
		"ARBITRATION_CONTINUATION":            10,
		"ARBITRATION_WITHDRAWN":               11,
		"ARBITRATION_VERDICT":                 12,
		"CREDIT_ADJUSTMENT":                   13,
		"FRAUD_CHARGEBACK_REPRESENTMENT":      14,
		"FRAUD_CHARGEBACK_ACCEPT":             15,
		"WRONG_CREDIT_REPRESENTMENT":          16,
		"WRONG_CREDIT_CHARGEBACK_ACCEPTANCE":  17,
		"MANUAL_ADJUSTMENT":                   18,
	}
)

func (x ResolveDisputeAdjustment_AdjustmentFlag) Enum() *ResolveDisputeAdjustment_AdjustmentFlag {
	p := new(ResolveDisputeAdjustment_AdjustmentFlag)
	*p = x
	return p
}

func (x ResolveDisputeAdjustment_AdjustmentFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolveDisputeAdjustment_AdjustmentFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[7].Descriptor()
}

func (ResolveDisputeAdjustment_AdjustmentFlag) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[7]
}

func (x ResolveDisputeAdjustment_AdjustmentFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResolveDisputeAdjustment_AdjustmentFlag.Descriptor instead.
func (ResolveDisputeAdjustment_AdjustmentFlag) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{12, 0}
}

// The dispute resolution reason code.
type ResolveDisputeAdjustment_ReasonCode int32

const (
	// Unspecified reason code.
	ResolveDisputeAdjustment_REASON_CODE_UNSPECIFIED ResolveDisputeAdjustment_ReasonCode = 0
	// Beneficiary bank unable to credit their customer account for Chargeback
	// Acceptance dispute or duplicate processing for Pre Arbitration Acceptance
	// dispute. This reason code maps to the `111` reason code as defined in
	// NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CHARGEBACK_BENEFICIARY_CANNOT_CREDIT_OR_PRE_ARBITRATION_DUPLICATE_PROCESS ResolveDisputeAdjustment_ReasonCode = 1
	// Beneficiary account has been credited online. This reason code maps to
	// the `112` reason code for Pre-arbitration declined dispute as defined in
	// NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_PRE_ARBITRATION_DECLINED_BENEFICIARY_CREDITED_ONLINE ResolveDisputeAdjustment_ReasonCode = 3
	// Beneficiary account has been credited manually post reconciliation. This
	// reason code maps to the `113` reason code for Pre-arbitration declined
	// dispute as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_PRE_ARBITRATION_DECLINED_BENEFICIARY_CREDITED_MANUALLY ResolveDisputeAdjustment_ReasonCode = 4
	// Customer account is not credited, TCC raised inadvertently. This reason
	// code maps to the `122` reason code as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_DEFERRED_CHARGEBACK_ACCEPTANCE_ACCOUNT_NOT_CREDITED_TCC_RAISED ResolveDisputeAdjustment_ReasonCode = 5
	// Customer account is credited successfully and TCC raised accordingly.
	// This reason code maps to the `123` reason code as defined in NPCI's
	// `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_RE_PRESENTMENT_RAISE_ACCOUNT_CREDITED_TCC_RAISED ResolveDisputeAdjustment_ReasonCode = 6
	// Customer account is not credited, TCC and Re-Presentment raised
	// inadvertently. This reason code maps to the `125` reason code as defined
	// in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_PRE_ARBITRATION_ACCEPTANCE_ACCOUNT_NOT_CREDITED ResolveDisputeAdjustment_ReasonCode = 7
	// Customer account is credited successfully and TCC and Re-Presentment
	// raised accordingly. This reason code maps to the `126` reason code as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_DEFERRED_PRE_ARBITRATION_DECLINED_ACCOUNT_CREDITED ResolveDisputeAdjustment_ReasonCode = 8
	// Amount has been recovered successfully from the fraudulent customer
	// account. This reason code maps to the `129` reason code as defined
	// in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_FRAUD_CHARGEBACK_ACCEPT_AMOUNT_RECOVERED_FROM_FRAUDULENT_ACCOUNT ResolveDisputeAdjustment_ReasonCode = 9
	// Lien marked however, customer account is not having sufficient balance to
	// debit. This reason code maps to the `130` reason code for
	// Fraud chargeback representment dispute as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_FRAUD_CHARGEBACK_REPRESENTMENT_LIEN_MARKED_INSUFFICIENT_BALANCE ResolveDisputeAdjustment_ReasonCode = 10
	// FIR Copy not provided for the disputed transaction. This reason code maps
	// to the `131` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_FRAUD_CHARGEBACK_REPRESENTMENT_FIR_NOT_PROVIDED ResolveDisputeAdjustment_ReasonCode = 11
	// Other reason for Fraud chargeback representment dispute. This reason code
	// maps to the `132` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_FRAUD_CHARGEBACK_REPRESENTMENT_REASON_OTHERS ResolveDisputeAdjustment_ReasonCode = 12
	// Beneficiary account credited online. This reason code maps to the `208`
	// reason code for Re-presentment raise dispute as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_RE_PRESENTMENT_RAISE_BENEFICIARY_CREDITED_ONLINE ResolveDisputeAdjustment_ReasonCode = 13
	// Beneficiary account credited manually post reconciliation. This reason
	// code maps to the `209` reason code for Re-presentment raise dispute as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_RE_PRESENTMENT_RAISE_BENEFICIARY_CREDITED_MANUALLY ResolveDisputeAdjustment_ReasonCode = 14
	// Credit not processed for cancelled or returned goods and services. This
	// reason code maps to the `1061` reason code as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_GOODS_SERVICES_CREDIT_NOT_PROCESSED ResolveDisputeAdjustment_ReasonCode = 15
	// Goods and Services not as described / defective. This reason code maps to
	// the `1062` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_GOODS_SERVICES_DEFECTIVE ResolveDisputeAdjustment_ReasonCode = 16
	// Paid by alternate means. This reason code maps to the `1063` reason code
	// as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_PAID_BY_ALTERNATE_MEANS ResolveDisputeAdjustment_ReasonCode = 17
	// Goods or Services Not Provided / Not Received. This reason code maps to
	// the `1064` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_GOODS_SERVICES_NOT_RECEIVED ResolveDisputeAdjustment_ReasonCode = 18
	// Account debited but transaction confirmation not received at merchant
	// location. This reason code maps to the `1065` reason code for Credit
	// adjustment as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_MERCHANT_NOT_RECEIVED_CONFIRMATION ResolveDisputeAdjustment_ReasonCode = 19
	// Duplicate /Multiple Transaction. This reason code maps to the `1084`
	// reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_DUPLICATE_TRANSACTION ResolveDisputeAdjustment_ReasonCode = 20
	// Other reason for Credit adjustment. This reason code maps to the `1090`
	// reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_REASON_OTHERS ResolveDisputeAdjustment_ReasonCode = 21
	// Non Matching account number. This reason code maps to the `1091`
	// reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_NON_MATCHING_ACCOUNT_NUMBER ResolveDisputeAdjustment_ReasonCode = 22
	// Card holder was charged more than the transaction amount.
	// This reason code maps to the `1092` reason code as defined in NPCI's
	// `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_CARD_HOLDER_CHARGED_MORE ResolveDisputeAdjustment_ReasonCode = 23
	// Credit not Processed. This reason code maps to the `1093` reason code as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_CREDIT_NOT_PROCESSED ResolveDisputeAdjustment_ReasonCode = 24
	// Beneficiary bank unable to credit their customer account. This reason
	// code maps to the `1094` reason code for Credit Adjustment dispute as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CREDIT_ADJUSTMENT_BENEFICIARY_CANNOT_CREDIT ResolveDisputeAdjustment_ReasonCode = 25
	// Merchant was unable to provide the service. This reason code maps to the
	// `1095` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_CHARGEBACK_ACCEPTANCE_MERCHANT_CANNOT_PROVIDE_SERVICE ResolveDisputeAdjustment_ReasonCode = 26
	// Services/Goods provided see the supporting document. This reason code
	// maps to the `1096` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_RE_PRESENTMENT_RAISE_GOODS_SERVICES_PROVIDED ResolveDisputeAdjustment_ReasonCode = 27
	// Services provided later see supporting documents. This reason code maps
	// to the `1098` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_PRE_ARBITRATION_DECLINED_SERVICES_PROVIDED_LATER ResolveDisputeAdjustment_ReasonCode = 28
	// Services not provided by the merchant. This reason code maps to the
	// `1099` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_PRE_ARBITRATION_ACCEPTANCE_SERVICES_NOT_PROVIDED_BY_MERCHANT ResolveDisputeAdjustment_ReasonCode = 29
	// Illegible Fulfilment. This reason code maps to the `1101` reason code for
	// arbitration acceptance dispute as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_ACCEPTANCE_ILLEGIBLE_FULFILMENT ResolveDisputeAdjustment_ReasonCode = 30
	// Customer has still not received the service. This reason code maps to the
	// `1102` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_CONTINUATION_CUSTOMER_STILL_NOT_RECEIVED_SERVICE ResolveDisputeAdjustment_ReasonCode = 31
	// Customer has received the service later. This reason code maps to the
	// `1103` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_WITHDRAWN_CUSTOMER_RECEIVED_SERVICE_LATER ResolveDisputeAdjustment_ReasonCode = 32
	// Panel will give the verdict. This reason code maps to the `1104` reason
	// code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ARBITRATION_VERDICT_PANEL_VERDICT ResolveDisputeAdjustment_ReasonCode = 33
	// Manual adjustment. This reason code maps to the `2001` reason code as
	// defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_MANUAL_ADJUSTMENT_REASON ResolveDisputeAdjustment_ReasonCode = 34
	// Attributing to the Customer. This reason code maps to the `AC` reason
	// code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_ATTRIBUTING_CUSTOMER ResolveDisputeAdjustment_ReasonCode = 35
	// Attributing to the Technical issue at bank/aggregator/merchant. This
	// reason code maps to the `AT` reason code as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_ATTRIBUTING_TECHNICAL_ISSUE ResolveDisputeAdjustment_ReasonCode = 36
	// Amount has been recovered successfully from the unintended customer
	// account. This reason code maps to the `WC2` reason code as defined in
	// NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_WRONG_CREDIT_CHARGEBACK_ACCEPTANCE_AMOUNT_RECOVERED ResolveDisputeAdjustment_ReasonCode = 37
	// Lien marked however customer account is not having sufficient balance to
	// debit the customer account. This reason code maps to the `WC3` reason
	// code for Wrong credit representment dispute as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_WRONG_CREDIT_REPRESENTMENT_LIEN_MARKED_INSUFFICIENT_BALANCE ResolveDisputeAdjustment_ReasonCode = 38
	// Customer is not accessible for obtaining debit confirmation. This reason
	// code maps to the `WC4` reason code as defined in NPCI's `UDIR`
	// specification.
	ResolveDisputeAdjustment_WRONG_CREDIT_REPRESENTMENT_CUSTOMER_INACCESSIBLE ResolveDisputeAdjustment_ReasonCode = 39
	// Other reason for Wrong credit representment. This reason code maps to the
	// `WC5` reason code as defined in NPCI's `UDIR` specification.
	ResolveDisputeAdjustment_WRONG_CREDIT_REPRESENTMENT_REASON_OTHERS ResolveDisputeAdjustment_ReasonCode = 40
)

// Enum value maps for ResolveDisputeAdjustment_ReasonCode.
var (
	ResolveDisputeAdjustment_ReasonCode_name = map[int32]string{
		0:  "REASON_CODE_UNSPECIFIED",
		1:  "CHARGEBACK_BENEFICIARY_CANNOT_CREDIT_OR_PRE_ARBITRATION_DUPLICATE_PROCESS",
		3:  "PRE_ARBITRATION_DECLINED_BENEFICIARY_CREDITED_ONLINE",
		4:  "PRE_ARBITRATION_DECLINED_BENEFICIARY_CREDITED_MANUALLY",
		5:  "DEFERRED_CHARGEBACK_ACCEPTANCE_ACCOUNT_NOT_CREDITED_TCC_RAISED",
		6:  "DEFERRED_RE_PRESENTMENT_RAISE_ACCOUNT_CREDITED_TCC_RAISED",
		7:  "DEFERRED_PRE_ARBITRATION_ACCEPTANCE_ACCOUNT_NOT_CREDITED",
		8:  "DEFERRED_PRE_ARBITRATION_DECLINED_ACCOUNT_CREDITED",
		9:  "FRAUD_CHARGEBACK_ACCEPT_AMOUNT_RECOVERED_FROM_FRAUDULENT_ACCOUNT",
		10: "FRAUD_CHARGEBACK_REPRESENTMENT_LIEN_MARKED_INSUFFICIENT_BALANCE",
		11: "FRAUD_CHARGEBACK_REPRESENTMENT_FIR_NOT_PROVIDED",
		12: "FRAUD_CHARGEBACK_REPRESENTMENT_REASON_OTHERS",
		13: "RE_PRESENTMENT_RAISE_BENEFICIARY_CREDITED_ONLINE",
		14: "RE_PRESENTMENT_RAISE_BENEFICIARY_CREDITED_MANUALLY",
		15: "CREDIT_ADJUSTMENT_GOODS_SERVICES_CREDIT_NOT_PROCESSED",
		16: "CREDIT_ADJUSTMENT_GOODS_SERVICES_DEFECTIVE",
		17: "CREDIT_ADJUSTMENT_PAID_BY_ALTERNATE_MEANS",
		18: "CREDIT_ADJUSTMENT_GOODS_SERVICES_NOT_RECEIVED",
		19: "CREDIT_ADJUSTMENT_MERCHANT_NOT_RECEIVED_CONFIRMATION",
		20: "CREDIT_ADJUSTMENT_DUPLICATE_TRANSACTION",
		21: "CREDIT_ADJUSTMENT_REASON_OTHERS",
		22: "CREDIT_ADJUSTMENT_NON_MATCHING_ACCOUNT_NUMBER",
		23: "CREDIT_ADJUSTMENT_CARD_HOLDER_CHARGED_MORE",
		24: "CREDIT_ADJUSTMENT_CREDIT_NOT_PROCESSED",
		25: "CREDIT_ADJUSTMENT_BENEFICIARY_CANNOT_CREDIT",
		26: "CHARGEBACK_ACCEPTANCE_MERCHANT_CANNOT_PROVIDE_SERVICE",
		27: "RE_PRESENTMENT_RAISE_GOODS_SERVICES_PROVIDED",
		28: "PRE_ARBITRATION_DECLINED_SERVICES_PROVIDED_LATER",
		29: "PRE_ARBITRATION_ACCEPTANCE_SERVICES_NOT_PROVIDED_BY_MERCHANT",
		30: "ARBITRATION_ACCEPTANCE_ILLEGIBLE_FULFILMENT",
		31: "ARBITRATION_CONTINUATION_CUSTOMER_STILL_NOT_RECEIVED_SERVICE",
		32: "ARBITRATION_WITHDRAWN_CUSTOMER_RECEIVED_SERVICE_LATER",
		33: "ARBITRATION_VERDICT_PANEL_VERDICT",
		34: "MANUAL_ADJUSTMENT_REASON",
		35: "ATTRIBUTING_CUSTOMER",
		36: "ATTRIBUTING_TECHNICAL_ISSUE",
		37: "WRONG_CREDIT_CHARGEBACK_ACCEPTANCE_AMOUNT_RECOVERED",
		38: "WRONG_CREDIT_REPRESENTMENT_LIEN_MARKED_INSUFFICIENT_BALANCE",
		39: "WRONG_CREDIT_REPRESENTMENT_CUSTOMER_INACCESSIBLE",
		40: "WRONG_CREDIT_REPRESENTMENT_REASON_OTHERS",
	}
	ResolveDisputeAdjustment_ReasonCode_value = map[string]int32{
		"REASON_CODE_UNSPECIFIED": 0,
		"CHARGEBACK_BENEFICIARY_CANNOT_CREDIT_OR_PRE_ARBITRATION_DUPLICATE_PROCESS": 1,
		"PRE_ARBITRATION_DECLINED_BENEFICIARY_CREDITED_ONLINE":                      3,
		"PRE_ARBITRATION_DECLINED_BENEFICIARY_CREDITED_MANUALLY":                    4,
		"DEFERRED_CHARGEBACK_ACCEPTANCE_ACCOUNT_NOT_CREDITED_TCC_RAISED":            5,
		"DEFERRED_RE_PRESENTMENT_RAISE_ACCOUNT_CREDITED_TCC_RAISED":                 6,
		"DEFERRED_PRE_ARBITRATION_ACCEPTANCE_ACCOUNT_NOT_CREDITED":                  7,
		"DEFERRED_PRE_ARBITRATION_DECLINED_ACCOUNT_CREDITED":                        8,
		"FRAUD_CHARGEBACK_ACCEPT_AMOUNT_RECOVERED_FROM_FRAUDULENT_ACCOUNT":          9,
		"FRAUD_CHARGEBACK_REPRESENTMENT_LIEN_MARKED_INSUFFICIENT_BALANCE":           10,
		"FRAUD_CHARGEBACK_REPRESENTMENT_FIR_NOT_PROVIDED":                           11,
		"FRAUD_CHARGEBACK_REPRESENTMENT_REASON_OTHERS":                              12,
		"RE_PRESENTMENT_RAISE_BENEFICIARY_CREDITED_ONLINE":                          13,
		"RE_PRESENTMENT_RAISE_BENEFICIARY_CREDITED_MANUALLY":                        14,
		"CREDIT_ADJUSTMENT_GOODS_SERVICES_CREDIT_NOT_PROCESSED":                     15,
		"CREDIT_ADJUSTMENT_GOODS_SERVICES_DEFECTIVE":                                16,
		"CREDIT_ADJUSTMENT_PAID_BY_ALTERNATE_MEANS":                                 17,
		"CREDIT_ADJUSTMENT_GOODS_SERVICES_NOT_RECEIVED":                             18,
		"CREDIT_ADJUSTMENT_MERCHANT_NOT_RECEIVED_CONFIRMATION":                      19,
		"CREDIT_ADJUSTMENT_DUPLICATE_TRANSACTION":                                   20,
		"CREDIT_ADJUSTMENT_REASON_OTHERS":                                           21,
		"CREDIT_ADJUSTMENT_NON_MATCHING_ACCOUNT_NUMBER":                             22,
		"CREDIT_ADJUSTMENT_CARD_HOLDER_CHARGED_MORE":                                23,
		"CREDIT_ADJUSTMENT_CREDIT_NOT_PROCESSED":                                    24,
		"CREDIT_ADJUSTMENT_BENEFICIARY_CANNOT_CREDIT":                               25,
		"CHARGEBACK_ACCEPTANCE_MERCHANT_CANNOT_PROVIDE_SERVICE":                     26,
		"RE_PRESENTMENT_RAISE_GOODS_SERVICES_PROVIDED":                              27,
		"PRE_ARBITRATION_DECLINED_SERVICES_PROVIDED_LATER":                          28,
		"PRE_ARBITRATION_ACCEPTANCE_SERVICES_NOT_PROVIDED_BY_MERCHANT":              29,
		"ARBITRATION_ACCEPTANCE_ILLEGIBLE_FULFILMENT":                               30,
		"ARBITRATION_CONTINUATION_CUSTOMER_STILL_NOT_RECEIVED_SERVICE":              31,
		"ARBITRATION_WITHDRAWN_CUSTOMER_RECEIVED_SERVICE_LATER":                     32,
		"ARBITRATION_VERDICT_PANEL_VERDICT":                                         33,
		"MANUAL_ADJUSTMENT_REASON":                                                  34,
		"ATTRIBUTING_CUSTOMER":                                                      35,
		"ATTRIBUTING_TECHNICAL_ISSUE":                                               36,
		"WRONG_CREDIT_CHARGEBACK_ACCEPTANCE_AMOUNT_RECOVERED":                       37,
		"WRONG_CREDIT_REPRESENTMENT_LIEN_MARKED_INSUFFICIENT_BALANCE":               38,
		"WRONG_CREDIT_REPRESENTMENT_CUSTOMER_INACCESSIBLE":                          39,
		"WRONG_CREDIT_REPRESENTMENT_REASON_OTHERS":                                  40,
	}
)

func (x ResolveDisputeAdjustment_ReasonCode) Enum() *ResolveDisputeAdjustment_ReasonCode {
	p := new(ResolveDisputeAdjustment_ReasonCode)
	*p = x
	return p
}

func (x ResolveDisputeAdjustment_ReasonCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolveDisputeAdjustment_ReasonCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[8].Descriptor()
}

func (ResolveDisputeAdjustment_ReasonCode) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes[8]
}

func (x ResolveDisputeAdjustment_ReasonCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResolveDisputeAdjustment_ReasonCode.Descriptor instead.
func (ResolveDisputeAdjustment_ReasonCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{12, 1}
}

// A complaint processed by the issuer switch.
type Complaint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the complaint. This uniquely identifies the complaint.
	// Format of name is
	// projects/{project_id}/complaints/{complaint_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The reason for raising the complaint. This maps adjustment flag
	// and reason code for the complaint to `reqAdjFlag` and `reqAdjCode` in
	// complaint request respectively while raising a complaint.
	RaiseComplaintAdjustment *RaiseComplaintAdjustment `protobuf:"bytes,2,opt,name=raise_complaint_adjustment,json=raiseComplaintAdjustment,proto3" json:"raise_complaint_adjustment,omitempty"`
	// Required. Details required for raising / resolving a complaint.
	Details *CaseDetails `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
	// Output only. Response to the raised / resolved complaint.
	Response *CaseResponse `protobuf:"bytes,5,opt,name=response,proto3" json:"response,omitempty"`
	// The reason for resolving the complaint. It provides adjustment values while
	// resolving and for already resolved complaints. This maps adjustment flag
	// and reason code for the complaint to `reqAdjFlag` and `reqAdjCode` in
	// complaint request respectively when a complete resolution is done via
	// Resolve Complaint API otherwise maps to `respAdjFlag` and `respAdjCode` in
	// complaint response respectively when a complaint request from UPI is
	// directly resolved by issuer switch.
	ResolveComplaintAdjustment *ResolveComplaintAdjustment `protobuf:"bytes,6,opt,name=resolve_complaint_adjustment,json=resolveComplaintAdjustment,proto3" json:"resolve_complaint_adjustment,omitempty"`
}

func (x *Complaint) Reset() {
	*x = Complaint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Complaint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Complaint) ProtoMessage() {}

func (x *Complaint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Complaint.ProtoReflect.Descriptor instead.
func (*Complaint) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{0}
}

func (x *Complaint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Complaint) GetRaiseComplaintAdjustment() *RaiseComplaintAdjustment {
	if x != nil {
		return x.RaiseComplaintAdjustment
	}
	return nil
}

func (x *Complaint) GetDetails() *CaseDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Complaint) GetResponse() *CaseResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *Complaint) GetResolveComplaintAdjustment() *ResolveComplaintAdjustment {
	if x != nil {
		return x.ResolveComplaintAdjustment
	}
	return nil
}

// Request for the `CreateComplaint` method.
type CreateComplaintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the complaint. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The complaint to be raised.
	Complaint *Complaint `protobuf:"bytes,2,opt,name=complaint,proto3" json:"complaint,omitempty"`
}

func (x *CreateComplaintRequest) Reset() {
	*x = CreateComplaintRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateComplaintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateComplaintRequest) ProtoMessage() {}

func (x *CreateComplaintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateComplaintRequest.ProtoReflect.Descriptor instead.
func (*CreateComplaintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{1}
}

func (x *CreateComplaintRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateComplaintRequest) GetComplaint() *Complaint {
	if x != nil {
		return x.Complaint
	}
	return nil
}

// Request for the `ResolveComplaint` method.
type ResolveComplaintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The complaint to be resolved.
	Complaint *Complaint `protobuf:"bytes,1,opt,name=complaint,proto3" json:"complaint,omitempty"`
}

func (x *ResolveComplaintRequest) Reset() {
	*x = ResolveComplaintRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveComplaintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveComplaintRequest) ProtoMessage() {}

func (x *ResolveComplaintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveComplaintRequest.ProtoReflect.Descriptor instead.
func (*ResolveComplaintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{2}
}

func (x *ResolveComplaintRequest) GetComplaint() *Complaint {
	if x != nil {
		return x.Complaint
	}
	return nil
}

// A dispute processed by the issuer switch.
type Dispute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the dispute. This uniquely identifies the dispute.
	// Format of name is
	// projects/{project_id}/disputes/{dispute_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The reason for raising the dispute. This maps adjustment flag
	// and reason code for the dispute to `reqAdjFlag` and `reqAdjCode` in
	// complaint request respectively while raising a dispute.
	RaiseDisputeAdjustment *RaiseDisputeAdjustment `protobuf:"bytes,2,opt,name=raise_dispute_adjustment,json=raiseDisputeAdjustment,proto3" json:"raise_dispute_adjustment,omitempty"`
	// Required. Details required for raising/resolving dispute.
	Details *CaseDetails `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
	// Output only. Response to the raised/resolved dispute.
	Response *CaseResponse `protobuf:"bytes,5,opt,name=response,proto3" json:"response,omitempty"`
	// The reason for resolving the dispute. It provides adjustment values while
	// resolving and for already resolved disputes. This maps adjustment flag
	// and reason code for the dispute to `reqAdjFlag` and `reqAdjCode` in
	// dispute request respectively while resolving a dispute.
	ResolveDisputeAdjustment *ResolveDisputeAdjustment `protobuf:"bytes,6,opt,name=resolve_dispute_adjustment,json=resolveDisputeAdjustment,proto3" json:"resolve_dispute_adjustment,omitempty"`
}

func (x *Dispute) Reset() {
	*x = Dispute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dispute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dispute) ProtoMessage() {}

func (x *Dispute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dispute.ProtoReflect.Descriptor instead.
func (*Dispute) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{3}
}

func (x *Dispute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dispute) GetRaiseDisputeAdjustment() *RaiseDisputeAdjustment {
	if x != nil {
		return x.RaiseDisputeAdjustment
	}
	return nil
}

func (x *Dispute) GetDetails() *CaseDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Dispute) GetResponse() *CaseResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *Dispute) GetResolveDisputeAdjustment() *ResolveDisputeAdjustment {
	if x != nil {
		return x.ResolveDisputeAdjustment
	}
	return nil
}

// Request for the `CreateDispute` method.
type CreateDisputeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the dispute. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The dispute to be raised.
	Dispute *Dispute `protobuf:"bytes,2,opt,name=dispute,proto3" json:"dispute,omitempty"`
}

func (x *CreateDisputeRequest) Reset() {
	*x = CreateDisputeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisputeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisputeRequest) ProtoMessage() {}

func (x *CreateDisputeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisputeRequest.ProtoReflect.Descriptor instead.
func (*CreateDisputeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{4}
}

func (x *CreateDisputeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisputeRequest) GetDispute() *Dispute {
	if x != nil {
		return x.Dispute
	}
	return nil
}

// Request for the `ResolveDispute` method.
type ResolveDisputeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dispute to be resolved.
	Dispute *Dispute `protobuf:"bytes,1,opt,name=dispute,proto3" json:"dispute,omitempty"`
}

func (x *ResolveDisputeRequest) Reset() {
	*x = ResolveDisputeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveDisputeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveDisputeRequest) ProtoMessage() {}

func (x *ResolveDisputeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveDisputeRequest.ProtoReflect.Descriptor instead.
func (*ResolveDisputeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{5}
}

func (x *ResolveDisputeRequest) GetDispute() *Dispute {
	if x != nil {
		return x.Dispute
	}
	return nil
}

// Details of original transaction.
type OriginalTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Uniquely identifies the original transaction. This maps to the `Txn.Id`
	// value of the original transaction in India's UPI system.
	TransactionId string `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	// Required. Retrieval Reference Number (RRN) of the original transaction.
	RetrievalReferenceNumber string `protobuf:"bytes,2,opt,name=retrieval_reference_number,json=retrievalReferenceNumber,proto3" json:"retrieval_reference_number,omitempty"`
	// Timestamp of the original transaction request.
	RequestTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
}

func (x *OriginalTransaction) Reset() {
	*x = OriginalTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OriginalTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginalTransaction) ProtoMessage() {}

func (x *OriginalTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginalTransaction.ProtoReflect.Descriptor instead.
func (*OriginalTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{6}
}

func (x *OriginalTransaction) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *OriginalTransaction) GetRetrievalReferenceNumber() string {
	if x != nil {
		return x.RetrievalReferenceNumber
	}
	return ""
}

func (x *OriginalTransaction) GetRequestTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RequestTime
	}
	return nil
}

// Details of the complaint or dispute.
type CaseDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Details of original transaction.
	OriginalTransaction *OriginalTransaction `protobuf:"bytes,1,opt,name=original_transaction,json=originalTransaction,proto3" json:"original_transaction,omitempty"`
	// Required. Initiator of the complaint / dispute.
	TransactionSubType TransactionSubType `protobuf:"varint,2,opt,name=transaction_sub_type,json=transactionSubType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionSubType" json:"transaction_sub_type,omitempty"`
	// Required. The adjustment amount in URCS for the complaint / dispute. This
	// maps to `reqAdjAmount` in complaint request.
	Amount *money.Money `protobuf:"bytes,3,opt,name=amount,proto3" json:"amount,omitempty"`
	// The original response code which has been updated in the complaint
	// Response. This should map to settlement response code currently available
	// in URCS system.
	OriginalSettlementResponseCode string `protobuf:"bytes,4,opt,name=original_settlement_response_code,json=originalSettlementResponseCode,proto3" json:"original_settlement_response_code,omitempty"`
	// Required. Set to true if the complaint / dispute belongs to current settlement cycle,
	// false otherwise.
	CurrentCycle bool `protobuf:"varint,5,opt,name=current_cycle,json=currentCycle,proto3" json:"current_cycle,omitempty"`
}

func (x *CaseDetails) Reset() {
	*x = CaseDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaseDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaseDetails) ProtoMessage() {}

func (x *CaseDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaseDetails.ProtoReflect.Descriptor instead.
func (*CaseDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{7}
}

func (x *CaseDetails) GetOriginalTransaction() *OriginalTransaction {
	if x != nil {
		return x.OriginalTransaction
	}
	return nil
}

func (x *CaseDetails) GetTransactionSubType() TransactionSubType {
	if x != nil {
		return x.TransactionSubType
	}
	return TransactionSubType_TRANSACTION_SUB_TYPE_UNSPECIFIED
}

func (x *CaseDetails) GetAmount() *money.Money {
	if x != nil {
		return x.Amount
	}
	return nil
}

func (x *CaseDetails) GetOriginalSettlementResponseCode() string {
	if x != nil {
		return x.OriginalSettlementResponseCode
	}
	return ""
}

func (x *CaseDetails) GetCurrentCycle() bool {
	if x != nil {
		return x.CurrentCycle
	}
	return false
}

// Response to the complaint or dispute.
type CaseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Complaint Reference Number(CRN) sent by UPI as a reference against the
	// generated complaint / dispute.
	ComplaintReferenceNumber string `protobuf:"bytes,1,opt,name=complaint_reference_number,json=complaintReferenceNumber,proto3" json:"complaint_reference_number,omitempty"`
	// The adjustment amount of the response. This maps to `adjAmt` in
	// complaint response.
	Amount *money.Money `protobuf:"bytes,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// The adjustment flag in response to the complaint. This maps adjustment flag
	// in URCS for the complaint transaction to `Resp.Ref.adjFlag` in complaint
	// response.
	AdjustmentFlag string `protobuf:"bytes,3,opt,name=adjustment_flag,json=adjustmentFlag,proto3" json:"adjustment_flag,omitempty"`
	// The adjustment code in response to the complaint. This maps reason code in
	// URCS for the complaint transaction to `Resp.Ref.adjCode` in complaint
	// response.
	AdjustmentCode string `protobuf:"bytes,4,opt,name=adjustment_code,json=adjustmentCode,proto3" json:"adjustment_code,omitempty"`
	// It defines the Adjustment Reference ID which has been updated in the
	// complaint response. This maps to `adjRefID` in complaint response.
	AdjustmentReferenceId string `protobuf:"bytes,5,opt,name=adjustment_reference_id,json=adjustmentReferenceId,proto3" json:"adjustment_reference_id,omitempty"`
	// Adjustment Remarks. This maps to `adjRemarks` in complaint response.
	AdjustmentRemarks string `protobuf:"bytes,6,opt,name=adjustment_remarks,json=adjustmentRemarks,proto3" json:"adjustment_remarks,omitempty"`
	// The Approval Reference Number. This maps to `approvalNum` in complaint
	// response.
	ApprovalNumber string `protobuf:"bytes,7,opt,name=approval_number,json=approvalNumber,proto3" json:"approval_number,omitempty"`
	// Process Status of the transaction. This maps to `procStatus` in complaint
	// response.
	ProcessStatus string `protobuf:"bytes,8,opt,name=process_status,json=processStatus,proto3" json:"process_status,omitempty"`
	// The adjustment timestamp when bank performs the adjustment for the received
	// complaint request. This maps to `adjTs` in complaint response.
	AdjustmentTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=adjustment_time,json=adjustmentTime,proto3" json:"adjustment_time,omitempty"`
	// The details of the participant of the original financial transaction.
	//
	// Types that are assignable to Participant:
	//	*CaseResponse_Payer
	//	*CaseResponse_Payee
	Participant isCaseResponse_Participant `protobuf_oneof:"participant"`
}

func (x *CaseResponse) Reset() {
	*x = CaseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CaseResponse) ProtoMessage() {}

func (x *CaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CaseResponse.ProtoReflect.Descriptor instead.
func (*CaseResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{8}
}

func (x *CaseResponse) GetComplaintReferenceNumber() string {
	if x != nil {
		return x.ComplaintReferenceNumber
	}
	return ""
}

func (x *CaseResponse) GetAmount() *money.Money {
	if x != nil {
		return x.Amount
	}
	return nil
}

func (x *CaseResponse) GetAdjustmentFlag() string {
	if x != nil {
		return x.AdjustmentFlag
	}
	return ""
}

func (x *CaseResponse) GetAdjustmentCode() string {
	if x != nil {
		return x.AdjustmentCode
	}
	return ""
}

func (x *CaseResponse) GetAdjustmentReferenceId() string {
	if x != nil {
		return x.AdjustmentReferenceId
	}
	return ""
}

func (x *CaseResponse) GetAdjustmentRemarks() string {
	if x != nil {
		return x.AdjustmentRemarks
	}
	return ""
}

func (x *CaseResponse) GetApprovalNumber() string {
	if x != nil {
		return x.ApprovalNumber
	}
	return ""
}

func (x *CaseResponse) GetProcessStatus() string {
	if x != nil {
		return x.ProcessStatus
	}
	return ""
}

func (x *CaseResponse) GetAdjustmentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AdjustmentTime
	}
	return nil
}

func (m *CaseResponse) GetParticipant() isCaseResponse_Participant {
	if m != nil {
		return m.Participant
	}
	return nil
}

func (x *CaseResponse) GetPayer() *SettlementParticipant {
	if x, ok := x.GetParticipant().(*CaseResponse_Payer); ok {
		return x.Payer
	}
	return nil
}

func (x *CaseResponse) GetPayee() *SettlementParticipant {
	if x, ok := x.GetParticipant().(*CaseResponse_Payee); ok {
		return x.Payee
	}
	return nil
}

type isCaseResponse_Participant interface {
	isCaseResponse_Participant()
}

type CaseResponse_Payer struct {
	// The payer in the original financial transaction.
	Payer *SettlementParticipant `protobuf:"bytes,10,opt,name=payer,proto3,oneof"`
}

type CaseResponse_Payee struct {
	// The payee in the original financial transaction.
	Payee *SettlementParticipant `protobuf:"bytes,11,opt,name=payee,proto3,oneof"`
}

func (*CaseResponse_Payer) isCaseResponse_Participant() {}

func (*CaseResponse_Payee) isCaseResponse_Participant() {}

// The adjusment flag and reason code for raising complaint.
type RaiseComplaintAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The adjustment flag in URCS for the complaint transaction. This maps to
	// `reqAdjFlag` in complaint request and `respAdjFlag` in complaint response.
	AdjustmentFlag RaiseComplaintAdjustment_AdjustmentFlag `protobuf:"varint,1,opt,name=adjustment_flag,json=adjustmentFlag,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment_AdjustmentFlag" json:"adjustment_flag,omitempty"`
	// Required. The adjustment code in URCS for the complaint transaction. This maps to
	// `reqAdjCode` in complaint request.
	AdjustmentCode RaiseComplaintAdjustment_ReasonCode `protobuf:"varint,2,opt,name=adjustment_code,json=adjustmentCode,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment_ReasonCode" json:"adjustment_code,omitempty"`
}

func (x *RaiseComplaintAdjustment) Reset() {
	*x = RaiseComplaintAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RaiseComplaintAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiseComplaintAdjustment) ProtoMessage() {}

func (x *RaiseComplaintAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiseComplaintAdjustment.ProtoReflect.Descriptor instead.
func (*RaiseComplaintAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{9}
}

func (x *RaiseComplaintAdjustment) GetAdjustmentFlag() RaiseComplaintAdjustment_AdjustmentFlag {
	if x != nil {
		return x.AdjustmentFlag
	}
	return RaiseComplaintAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED
}

func (x *RaiseComplaintAdjustment) GetAdjustmentCode() RaiseComplaintAdjustment_ReasonCode {
	if x != nil {
		return x.AdjustmentCode
	}
	return RaiseComplaintAdjustment_REASON_CODE_UNSPECIFIED
}

// The adjusment flag and reason code for resolving the complaint.
type ResolveComplaintAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The adjustment flag in URCS for the complaint transaction. This maps to
	// `reqAdjFlag` in complaint request and `respAdjFlag` in complaint response.
	AdjustmentFlag ResolveComplaintAdjustment_AdjustmentFlag `protobuf:"varint,1,opt,name=adjustment_flag,json=adjustmentFlag,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment_AdjustmentFlag" json:"adjustment_flag,omitempty"`
	// Required. The adjustment code in URCS for the complaint transaction. This maps to
	// `reqAdjCode` in complaint request.
	AdjustmentCode ResolveComplaintAdjustment_ReasonCode `protobuf:"varint,2,opt,name=adjustment_code,json=adjustmentCode,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment_ReasonCode" json:"adjustment_code,omitempty"`
}

func (x *ResolveComplaintAdjustment) Reset() {
	*x = ResolveComplaintAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveComplaintAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveComplaintAdjustment) ProtoMessage() {}

func (x *ResolveComplaintAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveComplaintAdjustment.ProtoReflect.Descriptor instead.
func (*ResolveComplaintAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{10}
}

func (x *ResolveComplaintAdjustment) GetAdjustmentFlag() ResolveComplaintAdjustment_AdjustmentFlag {
	if x != nil {
		return x.AdjustmentFlag
	}
	return ResolveComplaintAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED
}

func (x *ResolveComplaintAdjustment) GetAdjustmentCode() ResolveComplaintAdjustment_ReasonCode {
	if x != nil {
		return x.AdjustmentCode
	}
	return ResolveComplaintAdjustment_REASON_CODE_UNSPECIFIED
}

// The adjusment flag and reason code for raising dispute.
type RaiseDisputeAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The adjustment flag in URCS for the complaint transaction. This maps to
	// `reqAdjFlag` in dispute request and `respAdjFlag` in dispute response.
	AdjustmentFlag RaiseDisputeAdjustment_AdjustmentFlag `protobuf:"varint,1,opt,name=adjustment_flag,json=adjustmentFlag,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment_AdjustmentFlag" json:"adjustment_flag,omitempty"`
	// Required. The adjustment code in URCS for the complaint transaction. This maps to
	// `reqAdjCode` in dispute request.
	AdjustmentCode RaiseDisputeAdjustment_ReasonCode `protobuf:"varint,2,opt,name=adjustment_code,json=adjustmentCode,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment_ReasonCode" json:"adjustment_code,omitempty"`
}

func (x *RaiseDisputeAdjustment) Reset() {
	*x = RaiseDisputeAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RaiseDisputeAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiseDisputeAdjustment) ProtoMessage() {}

func (x *RaiseDisputeAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiseDisputeAdjustment.ProtoReflect.Descriptor instead.
func (*RaiseDisputeAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{11}
}

func (x *RaiseDisputeAdjustment) GetAdjustmentFlag() RaiseDisputeAdjustment_AdjustmentFlag {
	if x != nil {
		return x.AdjustmentFlag
	}
	return RaiseDisputeAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED
}

func (x *RaiseDisputeAdjustment) GetAdjustmentCode() RaiseDisputeAdjustment_ReasonCode {
	if x != nil {
		return x.AdjustmentCode
	}
	return RaiseDisputeAdjustment_REASON_CODE_UNSPECIFIED
}

// The adjusment flag and reason code for resolving the dispute.
type ResolveDisputeAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The adjustment flag in URCS for the complaint transaction. This maps to
	// `reqAdjFlag` in dispute request and `respAdjFlag` in dispute response.
	AdjustmentFlag ResolveDisputeAdjustment_AdjustmentFlag `protobuf:"varint,1,opt,name=adjustment_flag,json=adjustmentFlag,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment_AdjustmentFlag" json:"adjustment_flag,omitempty"`
	// Required. The adjustment code in URCS for the complaint transaction. This maps to
	// `reqAdjCode` in dispute request.
	AdjustmentCode ResolveDisputeAdjustment_ReasonCode `protobuf:"varint,2,opt,name=adjustment_code,json=adjustmentCode,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment_ReasonCode" json:"adjustment_code,omitempty"`
}

func (x *ResolveDisputeAdjustment) Reset() {
	*x = ResolveDisputeAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveDisputeAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveDisputeAdjustment) ProtoMessage() {}

func (x *ResolveDisputeAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveDisputeAdjustment.ProtoReflect.Descriptor instead.
func (*ResolveDisputeAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{12}
}

func (x *ResolveDisputeAdjustment) GetAdjustmentFlag() ResolveDisputeAdjustment_AdjustmentFlag {
	if x != nil {
		return x.AdjustmentFlag
	}
	return ResolveDisputeAdjustment_ADJUSTMENT_FLAG_UNSPECIFIED
}

func (x *ResolveDisputeAdjustment) GetAdjustmentCode() ResolveDisputeAdjustment_ReasonCode {
	if x != nil {
		return x.AdjustmentCode
	}
	return ResolveDisputeAdjustment_REASON_CODE_UNSPECIFIED
}

// Metadata for CreateComplaint.
type CreateComplaintMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateComplaintMetadata) Reset() {
	*x = CreateComplaintMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateComplaintMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateComplaintMetadata) ProtoMessage() {}

func (x *CreateComplaintMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateComplaintMetadata.ProtoReflect.Descriptor instead.
func (*CreateComplaintMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{13}
}

// Metadata for ResolveComplaint.
type ResolveComplaintMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResolveComplaintMetadata) Reset() {
	*x = ResolveComplaintMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveComplaintMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveComplaintMetadata) ProtoMessage() {}

func (x *ResolveComplaintMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveComplaintMetadata.ProtoReflect.Descriptor instead.
func (*ResolveComplaintMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{14}
}

// Metadata for CreateDispute.
type CreateDisputeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateDisputeMetadata) Reset() {
	*x = CreateDisputeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisputeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisputeMetadata) ProtoMessage() {}

func (x *CreateDisputeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisputeMetadata.ProtoReflect.Descriptor instead.
func (*CreateDisputeMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{15}
}

// Metadata for ResolveDispute.
type ResolveDisputeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResolveDisputeMetadata) Reset() {
	*x = ResolveDisputeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveDisputeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveDisputeMetadata) ProtoMessage() {}

func (x *ResolveDisputeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveDisputeMetadata.ProtoReflect.Descriptor instead.
func (*ResolveDisputeMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP(), []int{16}
}

var File_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto protoreflect.FileDescriptor

var file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xbd, 0x04, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x83, 0x01, 0x0a, 0x1a, 0x72, 0x61, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x18, 0x72,
	0x61, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x5a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x89, 0x01, 0x0a,
	0x1c, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x1a, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x41, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x55, 0xea, 0x41, 0x52, 0x0a, 0x25, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x12, 0x29, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x7d, 0x22,
	0xba, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x12, 0x25, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x59, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x22, 0x74, 0x0a, 0x17,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x22, 0xa8, 0x04, 0x0a, 0x07, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x7d, 0x0a, 0x18, 0x72, 0x61, 0x69, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x75, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x73, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x41,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x16, 0x72, 0x61, 0x69, 0x73, 0x65,
	0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x57, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x73, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x1a, 0x72, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75,
	0x74, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x4f, 0xea, 0x41,
	0x4c, 0x0a, 0x23, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x75,
	0x74, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x7d, 0x22, 0xb0, 0x01,
	0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70,
	0x75, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x07, 0x64,
	0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x75,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65,
	0x22, 0x6c, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x07, 0x64, 0x69, 0x73,
	0x70, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x22, 0xc3,
	0x01, 0x0a, 0x13, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x41, 0x0a, 0x1a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xa5, 0x03, 0x0a, 0x0b, 0x43, 0x61, 0x73, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x78, 0x0a, 0x14, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76,
	0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75,
	0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x21, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x22, 0x8d, 0x05, 0x0a,
	0x0c, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a,
	0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x06, 0x61,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52,
	0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67,
	0x12, 0x27, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x61, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x61,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x43, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x05, 0x70, 0x61, 0x79, 0x65, 0x72, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x70, 0x61, 0x79, 0x65,
	0x72, 0x12, 0x5a, 0x0a, 0x05, 0x70, 0x61, 0x79, 0x65, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x70, 0x61, 0x79, 0x65, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0x89, 0x05, 0x0a,
	0x18, 0x52, 0x61, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x41,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x0f, 0x61, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x61, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74,
	0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x7e,
	0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x3c,
	0x0a, 0x0e, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67,
	0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46,
	0x4c, 0x41, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x01, 0x22, 0xa9, 0x02, 0x0a,
	0x0a, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x52,
	0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x52, 0x45, 0x56, 0x45, 0x52, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x47,
	0x4f, 0x4f, 0x44, 0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x26, 0x0a, 0x22,
	0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x41,
	0x43, 0x4b, 0x10, 0x03, 0x12, 0x24, 0x0a, 0x20, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49,
	0x41, 0x52, 0x59, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f,
	0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x27, 0x0a, 0x23, 0x47, 0x4f,
	0x4f, 0x44, 0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x45,
	0x44, 0x10, 0x05, 0x12, 0x26, 0x0a, 0x22, 0x4d, 0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x1b, 0x0a, 0x17, 0x50,
	0x41, 0x49, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x54, 0x45,
	0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x53, 0x10, 0x07, 0x22, 0x96, 0x07, 0x0a, 0x1a, 0x52, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74,
	0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x80,
	0x01, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0xa5, 0x01, 0x0a, 0x0e, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x46, 0x6c, 0x61, 0x67, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x45, 0x42, 0x49, 0x54, 0x5f, 0x52,
	0x45, 0x56, 0x45, 0x52, 0x53, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e,
	0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x46, 0x55, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x56,
	0x45, 0x52, 0x53, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49,
	0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x22, 0xc5, 0x03, 0x0a, 0x0a, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x41, 0x53,
	0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x41, 0x49,
	0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x49,
	0x4e, 0x45, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x41, 0x49, 0x4e,
	0x54, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x4e, 0x4f, 0x57, 0x5f, 0x4f,
	0x52, 0x5f, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d,
	0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e, 0x41, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x45, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x43,
	0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x54, 0x5f, 0x41,
	0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x4f, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f,
	0x45, 0x58, 0x49, 0x53, 0x54, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x54, 0x5f, 0x50,
	0x41, 0x52, 0x54, 0x59, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x53, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x54, 0x5f, 0x4e, 0x52, 0x49, 0x5f, 0x41,
	0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x07, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x54, 0x5f,
	0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x46, 0x52, 0x45, 0x45, 0x5a, 0x45, 0x44, 0x10, 0x08,
	0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x54, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x54, 0x41,
	0x49, 0x4c, 0x53, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x54, 0x5f, 0x41, 0x4e, 0x59,
	0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x10, 0x0a, 0x12,
	0x21, 0x0a, 0x1d, 0x52, 0x45, 0x54, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41,
	0x52, 0x59, 0x5f, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54,
	0x10, 0x0b, 0x12, 0x2a, 0x0a, 0x26, 0x52, 0x45, 0x54, 0x5f, 0x4d, 0x45, 0x52, 0x43, 0x48, 0x41,
	0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x12, 0x21,
	0x0a, 0x1d, 0x52, 0x52, 0x43, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x41,
	0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x10,
	0x0d, 0x22, 0xb9, 0x0a, 0x0a, 0x16, 0x52, 0x61, 0x69, 0x73, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75,
	0x74, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x80, 0x01, 0x0a,
	0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x61, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x73, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74,
	0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x12,
	0x7c, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x73, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x75, 0x74, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x61,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x9b, 0x02,
	0x0a, 0x0e, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67,
	0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46,
	0x4c, 0x41, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f,
	0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x52, 0x41, 0x55, 0x44,
	0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x41, 0x49, 0x53,
	0x45, 0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52,
	0x41, 0x49, 0x53, 0x45, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52,
	0x45, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x41,
	0x49, 0x53, 0x45, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42,
	0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x05,
	0x12, 0x22, 0x0a, 0x1e, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x45,
	0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x49,
	0x53, 0x45, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x07, 0x12, 0x1e, 0x0a, 0x1a, 0x44,
	0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x08, 0x22, 0xff, 0x05, 0x0a, 0x0a,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45,
	0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x3e, 0x0a, 0x3a, 0x43, 0x48, 0x41, 0x52, 0x47,
	0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x52, 0x45, 0x4d, 0x49,
	0x54, 0x54, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x42, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x45, 0x4e,
	0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x32, 0x0a, 0x2e, 0x50, 0x52, 0x45, 0x5f, 0x41,
	0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45,
	0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x36, 0x0a, 0x32, 0x44,
	0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41,
	0x43, 0x4b, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43,
	0x49, 0x41, 0x52, 0x59, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x3b, 0x0a, 0x37, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f,
	0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52,
	0x59, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x4b, 0x0a, 0x47, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x41, 0x52, 0x42,
	0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x44,
	0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41,
	0x43, 0x4b, 0x5f, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x17, 0x0a,
	0x13, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x5f, 0x46,
	0x52, 0x41, 0x55, 0x44, 0x10, 0x06, 0x12, 0x27, 0x0a, 0x23, 0x47, 0x4f, 0x4f, 0x44, 0x53, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x45, 0x44, 0x10, 0x07, 0x12,
	0x1c, 0x0a, 0x18, 0x47, 0x4f, 0x4f, 0x44, 0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x53, 0x5f, 0x44, 0x45, 0x46, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x08, 0x12, 0x1b, 0x0a,
	0x17, 0x50, 0x41, 0x49, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x54, 0x45, 0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x53, 0x10, 0x09, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x4f,
	0x4f, 0x44, 0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x26, 0x0a, 0x22, 0x4d,
	0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x45,
	0x49, 0x56, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x0b, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x45, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x0c,
	0x12, 0x19, 0x0a, 0x15, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0d, 0x12, 0x27, 0x0a, 0x23, 0x43,
	0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x41, 0x52, 0x44, 0x5f, 0x48,
	0x4f, 0x4c, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x44, 0x5f, 0x4d, 0x4f,
	0x52, 0x45, 0x10, 0x0e, 0x12, 0x32, 0x0a, 0x2e, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52,
	0x5f, 0x43, 0x4c, 0x41, 0x49, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x47, 0x4f, 0x4f, 0x44, 0x53, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x44, 0x45, 0x4c,
	0x49, 0x56, 0x45, 0x52, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x52, 0x54,
	0x49, 0x45, 0x53, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x10, 0x12, 0x2f, 0x0a, 0x2b,
	0x46, 0x55, 0x4e, 0x44, 0x53, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x52, 0x45,
	0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x55, 0x4e, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x5f,
	0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x10, 0x11, 0x22, 0xd6, 0x17,
	0x0a, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65,
	0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x0f, 0x61,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74,
	0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x12,
	0x7e, 0x0a, 0x0f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x75, 0x74, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x22,
	0xe0, 0x04, 0x0a, 0x0e, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6c,
	0x61, 0x67, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x46, 0x4c, 0x41, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e,
	0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x01, 0x12, 0x21, 0x0a,
	0x1d, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x45,
	0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x10, 0x02,
	0x12, 0x19, 0x0a, 0x15, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e, 0x44,
	0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41,
	0x43, 0x4b, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x04, 0x12,
	0x1e, 0x0a, 0x1a, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x05, 0x12,
	0x27, 0x0a, 0x23, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x45, 0x5f,
	0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x45, 0x5f,
	0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x43, 0x4c,
	0x49, 0x4e, 0x45, 0x44, 0x10, 0x07, 0x12, 0x25, 0x0a, 0x21, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52,
	0x45, 0x44, 0x5f, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x08, 0x12, 0x1a, 0x0a,
	0x16, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x52, 0x42,
	0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x52, 0x42, 0x49, 0x54,
	0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x44, 0x52, 0x41, 0x57, 0x4e,
	0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x56, 0x45, 0x52, 0x44, 0x49, 0x43, 0x54, 0x10, 0x0c, 0x12, 0x15, 0x0a, 0x11, 0x43,
	0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x0d, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x52, 0x41, 0x55, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52,
	0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54,
	0x4d, 0x45, 0x4e, 0x54, 0x10, 0x0e, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x52, 0x41, 0x55, 0x44, 0x5f,
	0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50,
	0x54, 0x10, 0x0f, 0x12, 0x1e, 0x0a, 0x1a, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e,
	0x54, 0x10, 0x10, 0x12, 0x26, 0x0a, 0x22, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x11, 0x12, 0x15, 0x0a, 0x11, 0x4d,
	0x41, 0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x12, 0x22, 0xd1, 0x10, 0x0a, 0x0a, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x4d,
	0x0a, 0x49, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x42, 0x45, 0x4e,
	0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f,
	0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x4f, 0x52, 0x5f, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52,
	0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x54, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x38, 0x0a,
	0x34, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x44, 0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49,
	0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x4f,
	0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x3a, 0x0a, 0x36, 0x50, 0x52, 0x45, 0x5f, 0x41,
	0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x43, 0x4c, 0x49,
	0x4e, 0x45, 0x44, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x5f,
	0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x4c,
	0x59, 0x10, 0x04, 0x12, 0x42, 0x0a, 0x3e, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f,
	0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x43, 0x43, 0x5f, 0x52,
	0x41, 0x49, 0x53, 0x45, 0x44, 0x10, 0x05, 0x12, 0x3d, 0x0a, 0x39, 0x44, 0x45, 0x46, 0x45, 0x52,
	0x52, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x43, 0x43, 0x5f, 0x52, 0x41,
	0x49, 0x53, 0x45, 0x44, 0x10, 0x06, 0x12, 0x3c, 0x0a, 0x38, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52,
	0x45, 0x44, 0x5f, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x43,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54,
	0x45, 0x44, 0x10, 0x07, 0x12, 0x36, 0x0a, 0x32, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44,
	0x5f, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x44, 0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x10, 0x08, 0x12, 0x44, 0x0a, 0x40,
	0x46, 0x52, 0x41, 0x55, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x52,
	0x45, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x46, 0x52,
	0x41, 0x55, 0x44, 0x55, 0x4c, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x10, 0x09, 0x12, 0x43, 0x0a, 0x3f, 0x46, 0x52, 0x41, 0x55, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52,
	0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x49, 0x45, 0x4e, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x44,
	0x5f, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x41,
	0x4c, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x0a, 0x12, 0x33, 0x0a, 0x2f, 0x46, 0x52, 0x41, 0x55, 0x44,
	0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x50, 0x52,
	0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46, 0x49, 0x52, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x44, 0x10, 0x0b, 0x12, 0x30, 0x0a, 0x2c,
	0x46, 0x52, 0x41, 0x55, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b,
	0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52,
	0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x34,
	0x0a, 0x30, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41,
	0x52, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x49,
	0x4e, 0x45, 0x10, 0x0d, 0x12, 0x36, 0x0a, 0x32, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45,
	0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x42, 0x45, 0x4e,
	0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x45,
	0x44, 0x5f, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x4c, 0x59, 0x10, 0x0e, 0x12, 0x39, 0x0a, 0x35,
	0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x47, 0x4f, 0x4f, 0x44, 0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53,
	0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43,
	0x45, 0x53, 0x53, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x2e, 0x0a, 0x2a, 0x43, 0x52, 0x45, 0x44, 0x49,
	0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x47, 0x4f, 0x4f,
	0x44, 0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x44, 0x45, 0x46, 0x45,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x10, 0x12, 0x2d, 0x0a, 0x29, 0x43, 0x52, 0x45, 0x44, 0x49,
	0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x41, 0x49,
	0x44, 0x5f, 0x42, 0x59, 0x5f, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x54, 0x45, 0x5f, 0x4d,
	0x45, 0x41, 0x4e, 0x53, 0x10, 0x11, 0x12, 0x31, 0x0a, 0x2d, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54,
	0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x47, 0x4f, 0x4f, 0x44,
	0x53, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52,
	0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x10, 0x12, 0x12, 0x38, 0x0a, 0x34, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4d,
	0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x45,
	0x49, 0x56, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x13, 0x12, 0x2b, 0x0a, 0x27, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x41, 0x44,
	0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x54, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x14,
	0x12, 0x23, 0x0a, 0x1f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53,
	0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x54, 0x48,
	0x45, 0x52, 0x53, 0x10, 0x15, 0x12, 0x31, 0x0a, 0x2d, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f,
	0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x4e, 0x5f, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f,
	0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x16, 0x12, 0x2e, 0x0a, 0x2a, 0x43, 0x52, 0x45, 0x44,
	0x49, 0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x41,
	0x52, 0x44, 0x5f, 0x48, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45,
	0x44, 0x5f, 0x4d, 0x4f, 0x52, 0x45, 0x10, 0x17, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x52, 0x45, 0x44,
	0x49, 0x54, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52,
	0x45, 0x44, 0x49, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53,
	0x45, 0x44, 0x10, 0x18, 0x12, 0x2f, 0x0a, 0x2b, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x41,
	0x44, 0x4a, 0x55, 0x53, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49,
	0x43, 0x49, 0x41, 0x52, 0x59, 0x5f, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x52, 0x45,
	0x44, 0x49, 0x54, 0x10, 0x19, 0x12, 0x39, 0x0a, 0x35, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42,
	0x41, 0x43, 0x4b, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4d,
	0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54, 0x5f, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x50,
	0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x1a,
	0x12, 0x30, 0x0a, 0x2c, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x52, 0x41, 0x49, 0x53, 0x45, 0x5f, 0x47, 0x4f, 0x4f, 0x44, 0x53, 0x5f, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x44,
	0x10, 0x1b, 0x12, 0x34, 0x0a, 0x30, 0x50, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x44,
	0x5f, 0x4c, 0x41, 0x54, 0x45, 0x52, 0x10, 0x1c, 0x12, 0x40, 0x0a, 0x3c, 0x50, 0x52, 0x45, 0x5f,
	0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f,
	0x4d, 0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54, 0x10, 0x1d, 0x12, 0x2f, 0x0a, 0x2b, 0x41, 0x52,
	0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x46,
	0x55, 0x4c, 0x46, 0x49, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x1e, 0x12, 0x40, 0x0a, 0x3c, 0x41,
	0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x49,
	0x4e, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52,
	0x5f, 0x53, 0x54, 0x49, 0x4c, 0x4c, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49,
	0x56, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x1f, 0x12, 0x39, 0x0a,
	0x35, 0x41, 0x52, 0x42, 0x49, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x44, 0x52, 0x41, 0x57, 0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f,
	0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x5f, 0x4c, 0x41, 0x54, 0x45, 0x52, 0x10, 0x20, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x52, 0x42, 0x49,
	0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x45, 0x52, 0x44, 0x49, 0x43, 0x54, 0x5f,
	0x50, 0x41, 0x4e, 0x45, 0x4c, 0x5f, 0x56, 0x45, 0x52, 0x44, 0x49, 0x43, 0x54, 0x10, 0x21, 0x12,
	0x1c, 0x0a, 0x18, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x10, 0x22, 0x12, 0x18, 0x0a,
	0x14, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x45, 0x52, 0x10, 0x23, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x54, 0x54, 0x52, 0x49,
	0x42, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x45, 0x43, 0x48, 0x4e, 0x49, 0x43, 0x41, 0x4c,
	0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x24, 0x12, 0x37, 0x0a, 0x33, 0x57, 0x52, 0x4f, 0x4e,
	0x47, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42,
	0x41, 0x43, 0x4b, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x41,
	0x4d, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x44, 0x10,
	0x25, 0x12, 0x3f, 0x0a, 0x3b, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49,
	0x54, 0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x4c, 0x49, 0x45, 0x4e, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x55,
	0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x26, 0x12, 0x34, 0x0a, 0x30, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x43, 0x52, 0x45, 0x44,
	0x49, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x41, 0x43, 0x43, 0x45,
	0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x27, 0x12, 0x2c, 0x0a, 0x28, 0x57, 0x52, 0x4f, 0x4e,
	0x47, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x52, 0x45, 0x53, 0x45,
	0x4e, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x54,
	0x48, 0x45, 0x52, 0x53, 0x10, 0x28, 0x22, 0x19, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x1a, 0x0a, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x61, 0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x17, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x18, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2a, 0x83, 0x01, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a,
	0x20, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x42,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49, 0x43, 0x49, 0x41, 0x52,
	0x59, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x4d, 0x49,
	0x54, 0x54, 0x45, 0x52, 0x10, 0x02, 0x32, 0x8c, 0x08, 0x0a, 0x17, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xe6, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2f, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x3a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e,
	0x74, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0xca, 0x41, 0x24, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf4, 0x01, 0x0a, 0x10,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74,
	0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x3a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0xda, 0x41,
	0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0xca, 0x41, 0x25, 0x0a, 0x09, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xd8, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x75, 0x74, 0x65, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x22, 0x20,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x73,
	0x3a, 0x07, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0xca, 0x41, 0x20, 0x0a, 0x07, 0x44,
	0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x12, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe4, 0x01,
	0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x3a, 0x07, 0x64,
	0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0xda, 0x41, 0x07, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65,
	0xca, 0x41, 0x21, 0x0a, 0x07, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x12, 0x16, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xac, 0x02, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0xaa, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x3a, 0x3a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescOnce sync.Once
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescData = file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDesc
)

func file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescGZIP() []byte {
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescOnce.Do(func() {
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescData)
	})
	return file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDescData
}

var file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_goTypes = []interface{}{
	(TransactionSubType)(0),                        // 0: google.cloud.paymentgateway.issuerswitch.v1.TransactionSubType
	(RaiseComplaintAdjustment_AdjustmentFlag)(0),   // 1: google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment.AdjustmentFlag
	(RaiseComplaintAdjustment_ReasonCode)(0),       // 2: google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment.ReasonCode
	(ResolveComplaintAdjustment_AdjustmentFlag)(0), // 3: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment.AdjustmentFlag
	(ResolveComplaintAdjustment_ReasonCode)(0),     // 4: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment.ReasonCode
	(RaiseDisputeAdjustment_AdjustmentFlag)(0),     // 5: google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment.AdjustmentFlag
	(RaiseDisputeAdjustment_ReasonCode)(0),         // 6: google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment.ReasonCode
	(ResolveDisputeAdjustment_AdjustmentFlag)(0),   // 7: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment.AdjustmentFlag
	(ResolveDisputeAdjustment_ReasonCode)(0),       // 8: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment.ReasonCode
	(*Complaint)(nil),                              // 9: google.cloud.paymentgateway.issuerswitch.v1.Complaint
	(*CreateComplaintRequest)(nil),                 // 10: google.cloud.paymentgateway.issuerswitch.v1.CreateComplaintRequest
	(*ResolveComplaintRequest)(nil),                // 11: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintRequest
	(*Dispute)(nil),                                // 12: google.cloud.paymentgateway.issuerswitch.v1.Dispute
	(*CreateDisputeRequest)(nil),                   // 13: google.cloud.paymentgateway.issuerswitch.v1.CreateDisputeRequest
	(*ResolveDisputeRequest)(nil),                  // 14: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeRequest
	(*OriginalTransaction)(nil),                    // 15: google.cloud.paymentgateway.issuerswitch.v1.OriginalTransaction
	(*CaseDetails)(nil),                            // 16: google.cloud.paymentgateway.issuerswitch.v1.CaseDetails
	(*CaseResponse)(nil),                           // 17: google.cloud.paymentgateway.issuerswitch.v1.CaseResponse
	(*RaiseComplaintAdjustment)(nil),               // 18: google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment
	(*ResolveComplaintAdjustment)(nil),             // 19: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment
	(*RaiseDisputeAdjustment)(nil),                 // 20: google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment
	(*ResolveDisputeAdjustment)(nil),               // 21: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment
	(*CreateComplaintMetadata)(nil),                // 22: google.cloud.paymentgateway.issuerswitch.v1.CreateComplaintMetadata
	(*ResolveComplaintMetadata)(nil),               // 23: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintMetadata
	(*CreateDisputeMetadata)(nil),                  // 24: google.cloud.paymentgateway.issuerswitch.v1.CreateDisputeMetadata
	(*ResolveDisputeMetadata)(nil),                 // 25: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeMetadata
	(*timestamppb.Timestamp)(nil),                  // 26: google.protobuf.Timestamp
	(*money.Money)(nil),                            // 27: google.type.Money
	(*SettlementParticipant)(nil),                  // 28: google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	(*longrunning.Operation)(nil),                  // 29: google.longrunning.Operation
}
var file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_depIdxs = []int32{
	18, // 0: google.cloud.paymentgateway.issuerswitch.v1.Complaint.raise_complaint_adjustment:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment
	16, // 1: google.cloud.paymentgateway.issuerswitch.v1.Complaint.details:type_name -> google.cloud.paymentgateway.issuerswitch.v1.CaseDetails
	17, // 2: google.cloud.paymentgateway.issuerswitch.v1.Complaint.response:type_name -> google.cloud.paymentgateway.issuerswitch.v1.CaseResponse
	19, // 3: google.cloud.paymentgateway.issuerswitch.v1.Complaint.resolve_complaint_adjustment:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment
	9,  // 4: google.cloud.paymentgateway.issuerswitch.v1.CreateComplaintRequest.complaint:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Complaint
	9,  // 5: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintRequest.complaint:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Complaint
	20, // 6: google.cloud.paymentgateway.issuerswitch.v1.Dispute.raise_dispute_adjustment:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment
	16, // 7: google.cloud.paymentgateway.issuerswitch.v1.Dispute.details:type_name -> google.cloud.paymentgateway.issuerswitch.v1.CaseDetails
	17, // 8: google.cloud.paymentgateway.issuerswitch.v1.Dispute.response:type_name -> google.cloud.paymentgateway.issuerswitch.v1.CaseResponse
	21, // 9: google.cloud.paymentgateway.issuerswitch.v1.Dispute.resolve_dispute_adjustment:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment
	12, // 10: google.cloud.paymentgateway.issuerswitch.v1.CreateDisputeRequest.dispute:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Dispute
	12, // 11: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeRequest.dispute:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Dispute
	26, // 12: google.cloud.paymentgateway.issuerswitch.v1.OriginalTransaction.request_time:type_name -> google.protobuf.Timestamp
	15, // 13: google.cloud.paymentgateway.issuerswitch.v1.CaseDetails.original_transaction:type_name -> google.cloud.paymentgateway.issuerswitch.v1.OriginalTransaction
	0,  // 14: google.cloud.paymentgateway.issuerswitch.v1.CaseDetails.transaction_sub_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionSubType
	27, // 15: google.cloud.paymentgateway.issuerswitch.v1.CaseDetails.amount:type_name -> google.type.Money
	27, // 16: google.cloud.paymentgateway.issuerswitch.v1.CaseResponse.amount:type_name -> google.type.Money
	26, // 17: google.cloud.paymentgateway.issuerswitch.v1.CaseResponse.adjustment_time:type_name -> google.protobuf.Timestamp
	28, // 18: google.cloud.paymentgateway.issuerswitch.v1.CaseResponse.payer:type_name -> google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	28, // 19: google.cloud.paymentgateway.issuerswitch.v1.CaseResponse.payee:type_name -> google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	1,  // 20: google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment.adjustment_flag:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment.AdjustmentFlag
	2,  // 21: google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment.adjustment_code:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RaiseComplaintAdjustment.ReasonCode
	3,  // 22: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment.adjustment_flag:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment.AdjustmentFlag
	4,  // 23: google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment.adjustment_code:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintAdjustment.ReasonCode
	5,  // 24: google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment.adjustment_flag:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment.AdjustmentFlag
	6,  // 25: google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment.adjustment_code:type_name -> google.cloud.paymentgateway.issuerswitch.v1.RaiseDisputeAdjustment.ReasonCode
	7,  // 26: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment.adjustment_flag:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment.AdjustmentFlag
	8,  // 27: google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment.adjustment_code:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeAdjustment.ReasonCode
	10, // 28: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.CreateComplaint:input_type -> google.cloud.paymentgateway.issuerswitch.v1.CreateComplaintRequest
	11, // 29: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.ResolveComplaint:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintRequest
	13, // 30: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.CreateDispute:input_type -> google.cloud.paymentgateway.issuerswitch.v1.CreateDisputeRequest
	14, // 31: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.ResolveDispute:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeRequest
	29, // 32: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.CreateComplaint:output_type -> google.longrunning.Operation
	29, // 33: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.ResolveComplaint:output_type -> google.longrunning.Operation
	29, // 34: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.CreateDispute:output_type -> google.longrunning.Operation
	29, // 35: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions.ResolveDispute:output_type -> google.longrunning.Operation
	32, // [32:36] is the sub-list for method output_type
	28, // [28:32] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_init() }
func file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_init() {
	if File_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto != nil {
		return
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Complaint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateComplaintRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveComplaintRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dispute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisputeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveDisputeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OriginalTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaseDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CaseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RaiseComplaintAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveComplaintAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RaiseDisputeAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveDisputeAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateComplaintMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveComplaintMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisputeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveDisputeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*CaseResponse_Payer)(nil),
		(*CaseResponse_Payee)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_goTypes,
		DependencyIndexes: file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_depIdxs,
		EnumInfos:         file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_enumTypes,
		MessageInfos:      file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_msgTypes,
	}.Build()
	File_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto = out.File
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_rawDesc = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_goTypes = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IssuerSwitchResolutionsClient is the client API for IssuerSwitchResolutions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IssuerSwitchResolutionsClient interface {
	// Create a complaint. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [CreateComplaintMetadata][google.cloud.paymentgateway.issuerswitch.v1.CreateComplaintMetadata]
	// - `response`: [Complaint][google.cloud.paymentgateway.issuerswitch.v1.Complaint]
	CreateComplaint(ctx context.Context, in *CreateComplaintRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Resolve a complaint. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [ResolveComplaintMetadata][google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintMetadata]
	// - `response`: [Complaint][google.cloud.paymentgateway.issuerswitch.v1.Complaint]
	ResolveComplaint(ctx context.Context, in *ResolveComplaintRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Create a dispute. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [CreateDisputeMetadata][google.cloud.paymentgateway.issuerswitch.v1.CreateDisputeMetadata]
	// - `response`: [Dispute][google.cloud.paymentgateway.issuerswitch.v1.Dispute]
	CreateDispute(ctx context.Context, in *CreateDisputeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Resolve a dispute. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [ResolveDisputeMetadata][google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeMetadata]
	// - `response`: [Dispute][google.cloud.paymentgateway.issuerswitch.v1.Dispute]
	ResolveDispute(ctx context.Context, in *ResolveDisputeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type issuerSwitchResolutionsClient struct {
	cc grpc.ClientConnInterface
}

func NewIssuerSwitchResolutionsClient(cc grpc.ClientConnInterface) IssuerSwitchResolutionsClient {
	return &issuerSwitchResolutionsClient{cc}
}

func (c *issuerSwitchResolutionsClient) CreateComplaint(ctx context.Context, in *CreateComplaintRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/CreateComplaint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchResolutionsClient) ResolveComplaint(ctx context.Context, in *ResolveComplaintRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/ResolveComplaint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchResolutionsClient) CreateDispute(ctx context.Context, in *CreateDisputeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/CreateDispute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchResolutionsClient) ResolveDispute(ctx context.Context, in *ResolveDisputeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/ResolveDispute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IssuerSwitchResolutionsServer is the server API for IssuerSwitchResolutions service.
type IssuerSwitchResolutionsServer interface {
	// Create a complaint. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [CreateComplaintMetadata][google.cloud.paymentgateway.issuerswitch.v1.CreateComplaintMetadata]
	// - `response`: [Complaint][google.cloud.paymentgateway.issuerswitch.v1.Complaint]
	CreateComplaint(context.Context, *CreateComplaintRequest) (*longrunning.Operation, error)
	// Resolve a complaint. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [ResolveComplaintMetadata][google.cloud.paymentgateway.issuerswitch.v1.ResolveComplaintMetadata]
	// - `response`: [Complaint][google.cloud.paymentgateway.issuerswitch.v1.Complaint]
	ResolveComplaint(context.Context, *ResolveComplaintRequest) (*longrunning.Operation, error)
	// Create a dispute. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [CreateDisputeMetadata][google.cloud.paymentgateway.issuerswitch.v1.CreateDisputeMetadata]
	// - `response`: [Dispute][google.cloud.paymentgateway.issuerswitch.v1.Dispute]
	CreateDispute(context.Context, *CreateDisputeRequest) (*longrunning.Operation, error)
	// Resolve a dispute. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`: [ResolveDisputeMetadata][google.cloud.paymentgateway.issuerswitch.v1.ResolveDisputeMetadata]
	// - `response`: [Dispute][google.cloud.paymentgateway.issuerswitch.v1.Dispute]
	ResolveDispute(context.Context, *ResolveDisputeRequest) (*longrunning.Operation, error)
}

// UnimplementedIssuerSwitchResolutionsServer can be embedded to have forward compatible implementations.
type UnimplementedIssuerSwitchResolutionsServer struct {
}

func (*UnimplementedIssuerSwitchResolutionsServer) CreateComplaint(context.Context, *CreateComplaintRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateComplaint not implemented")
}
func (*UnimplementedIssuerSwitchResolutionsServer) ResolveComplaint(context.Context, *ResolveComplaintRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveComplaint not implemented")
}
func (*UnimplementedIssuerSwitchResolutionsServer) CreateDispute(context.Context, *CreateDisputeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDispute not implemented")
}
func (*UnimplementedIssuerSwitchResolutionsServer) ResolveDispute(context.Context, *ResolveDisputeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveDispute not implemented")
}

func RegisterIssuerSwitchResolutionsServer(s *grpc.Server, srv IssuerSwitchResolutionsServer) {
	s.RegisterService(&_IssuerSwitchResolutions_serviceDesc, srv)
}

func _IssuerSwitchResolutions_CreateComplaint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateComplaintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchResolutionsServer).CreateComplaint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/CreateComplaint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchResolutionsServer).CreateComplaint(ctx, req.(*CreateComplaintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchResolutions_ResolveComplaint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveComplaintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchResolutionsServer).ResolveComplaint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/ResolveComplaint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchResolutionsServer).ResolveComplaint(ctx, req.(*ResolveComplaintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchResolutions_CreateDispute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisputeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchResolutionsServer).CreateDispute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/CreateDispute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchResolutionsServer).CreateDispute(ctx, req.(*CreateDisputeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchResolutions_ResolveDispute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveDisputeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchResolutionsServer).ResolveDispute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions/ResolveDispute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchResolutionsServer).ResolveDispute(ctx, req.(*ResolveDisputeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IssuerSwitchResolutions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchResolutions",
	HandlerType: (*IssuerSwitchResolutionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateComplaint",
			Handler:    _IssuerSwitchResolutions_CreateComplaint_Handler,
		},
		{
			MethodName: "ResolveComplaint",
			Handler:    _IssuerSwitchResolutions_ResolveComplaint_Handler,
		},
		{
			MethodName: "CreateDispute",
			Handler:    _IssuerSwitchResolutions_CreateDispute_Handler,
		},
		{
			MethodName: "ResolveDispute",
			Handler:    _IssuerSwitchResolutions_ResolveDispute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/paymentgateway/issuerswitch/v1/resolutions.proto",
}
