/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;

public interface StatefulNextGenBuildCacheService
extends BuildCacheService,
Closeable {
    public boolean contains(BuildCacheKey var1);

    default public void store(BuildCacheKey key, final BuildCacheEntryWriter legacyWriter) throws BuildCacheException {
        NextGenWriter writer = legacyWriter instanceof NextGenWriter ? (NextGenWriter)legacyWriter : new NextGenWriter(){

            @Override
            public InputStream openStream() throws IOException {
                UnsynchronizedByteArrayOutputStream data = new UnsynchronizedByteArrayOutputStream();
                this.writeTo((OutputStream)data);
                return data.toInputStream();
            }

            public void writeTo(OutputStream output) throws IOException {
                legacyWriter.writeTo(output);
            }

            public long getSize() {
                return legacyWriter.getSize();
            }
        };
        this.store(key, writer);
    }

    public void store(BuildCacheKey var1, NextGenWriter var2) throws BuildCacheException;

    public void open();

    @Override
    public void close();

    public static interface NextGenWriter
    extends BuildCacheEntryWriter {
        public InputStream openStream() throws IOException;
    }
}

