/* XtpipesUni.java (2024-02-28-13:22), generated from xtpipes.tex
   Copyright (C) 2009-2010 TeX Users Group
   Copyright (C) 2002-2009 Eitan M. Gurari
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either
% version 1.3c of this license or (at your option) any
% later version. The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3c or later is part of all distributions
% of LaTeX version 2005/12/01 or later.
%
% This work has the LPPL maintenance status "maintained".
%
% The Current Maintainer of this work
% is the TeX4ht Project <http://tug.org/tex4ht>.
%
% If you modify this program, changing the
% version identification would be appreciated. */
package xtpipes;
public class XtpipesUni{
   private static int D800 = Integer.parseInt("D800", 16);
private static int DFFF = Integer.parseInt("DFFF", 16);
private static int DC00 = Integer.parseInt("DC00", 16);
private static int X400 = Integer.parseInt("400",16);
private static int X10000 = Integer.parseInt("10000",16);


public static String toUni( char[] ch, int start, int length,
                                           String filter ){
   StringBuffer buf = new StringBuffer(length);
   for (int i = 0; i < length; i++) {
       int chr = ch[ start + i ];
       boolean ascii =  (chr == '\n')
                        || (chr > 31) && (chr < 127) ;
       if( filter.indexOf(chr) > -1 ){ ascii = false; }

       if( (chr >= D800) && (chr<= DFFF) ){
          chr = ((ch[i] - D800) * X400 + (ch[++i] - DC00)) + X10000;
       }


       buf.append(
         ascii ? Character.toString((char) chr)
               : ("&#x"
                 + Integer.toHexString(chr).toUpperCase()
                 + ";" ) );
   }
   return new String(buf);
}

   public static String toUni( String s, String filter ){
   char [] ch = s.toCharArray();
   int length = ch.length;
   return toUni(ch, 0, length, filter);
}

}

