package tex4ht;
/* JsmlMathBreak.java (2024-02-28-13:21), generated from tex4ht-jsml-xtpipes.tex
   Copyright (C) 2009-2010 TeX Users Group
   Copyright (C) 2002-2009 Eitan M. Gurari
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either
% version 1.3c of this license or (at your option) any
% later version. The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3c or later is part of all distributions
% of LaTeX version 2005/12/01 or later.
%
% This work has the LPPL maintenance status "maintained".
%
% The Current Maintainer of this work
% is the TeX4ht Project <http://tug.org/tex4ht>.
%
% If you modify this program, changing the
% version identification would be appreciated. */

import xtpipes.XtpipesUni;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;
import java.io.*;
import java.lang.reflect.*;
import java.util.HashMap;

public class JsmlMathBreak extends DefaultHandler {
        PrintWriter out = null;
        boolean delete = false;
  public JsmlMathBreak(PrintWriter out,
                       HashMap<String,Object> scripts,
                       Method method, PrintWriter log, boolean trace) {
    this.out = out;
  }
  public void characters(char[] ch, int start, int length) {
    String s = XtpipesUni.toUni(ch, start, length, "<>&");
    out.print( s );
    if( !s.trim().equals("") ){
       delete = false;
  } }
  public void startElement(String ns, String sName,
                                      String qName,
                                      Attributes atts) {
    if( !( delete && qName.equals("BREAK") ) ){
      String s = "<" + qName + "\n";
      for (int i = 0; i < atts.getLength(); i++) {
        String name = atts.getQName(i);
        if (name != "xmlns") {
          s += (" " + name + "=\""
              + XtpipesUni.toUni(atts.getValue(i), "<>&\"")
              + "\"");
      } }
      if( qName.equals( "BREAK" ) ){
        s += "/";
        delete = true;
      }
      s += ">";
      out.print(s);
  } }
  public void endElement(String ns, String sName, String qName) {
    if( !qName.equals( "BREAK" ) ){
      String s = "</" + qName + ">";
      out.print(s);
} } }

