// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkidentity

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAppInstance = "CreateAppInstance"

// CreateAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstance for more information on using the CreateAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceRequest method.
//	req, resp := client.CreateAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance
func (c *ChimeSDKIdentity) CreateAppInstanceRequest(input *CreateAppInstanceInput) (req *request.Request, output *CreateAppInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instances",
	}

	if input == nil {
		input = &CreateAppInstanceInput{}
	}

	output = &CreateAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstance API operation for Amazon Chime SDK Identity.
//
// Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only
// SDK messaging customers use this API. CreateAppInstance supports idempotency
// behavior as described in the AWS API Standard.
//
// identity
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance
func (c *ChimeSDKIdentity) CreateAppInstance(input *CreateAppInstanceInput) (*CreateAppInstanceOutput, error) {
	req, out := c.CreateAppInstanceRequest(input)
	return out, req.Send()
}

// CreateAppInstanceWithContext is the same as CreateAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceWithContext(ctx aws.Context, input *CreateAppInstanceInput, opts ...request.Option) (*CreateAppInstanceOutput, error) {
	req, out := c.CreateAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceAdmin = "CreateAppInstanceAdmin"

// CreateAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceAdmin for more information on using the CreateAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceAdminRequest method.
//	req, resp := client.CreateAppInstanceAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin
func (c *ChimeSDKIdentity) CreateAppInstanceAdminRequest(input *CreateAppInstanceAdminInput) (req *request.Request, output *CreateAppInstanceAdminOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstanceAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins",
	}

	if input == nil {
		input = &CreateAppInstanceAdminInput{}
	}

	output = &CreateAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstanceAdmin API operation for Amazon Chime SDK Identity.
//
// Promotes an AppInstanceUser or AppInstanceBot to an AppInstanceAdmin. The
// promoted entity can perform the following actions.
//
//   - ChannelModerator actions across all channels in the AppInstance.
//
//   - DeleteChannelMessage actions.
//
// Only an AppInstanceUser and AppInstanceBot can be promoted to an AppInstanceAdmin
// role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin
func (c *ChimeSDKIdentity) CreateAppInstanceAdmin(input *CreateAppInstanceAdminInput) (*CreateAppInstanceAdminOutput, error) {
	req, out := c.CreateAppInstanceAdminRequest(input)
	return out, req.Send()
}

// CreateAppInstanceAdminWithContext is the same as CreateAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceAdminWithContext(ctx aws.Context, input *CreateAppInstanceAdminInput, opts ...request.Option) (*CreateAppInstanceAdminOutput, error) {
	req, out := c.CreateAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceBot = "CreateAppInstanceBot"

// CreateAppInstanceBotRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceBot for more information on using the CreateAppInstanceBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceBotRequest method.
//	req, resp := client.CreateAppInstanceBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceBot
func (c *ChimeSDKIdentity) CreateAppInstanceBotRequest(input *CreateAppInstanceBotInput) (req *request.Request, output *CreateAppInstanceBotOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstanceBot,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instance-bots",
	}

	if input == nil {
		input = &CreateAppInstanceBotInput{}
	}

	output = &CreateAppInstanceBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstanceBot API operation for Amazon Chime SDK Identity.
//
// Creates a bot under an Amazon Chime AppInstance. The request consists of
// a unique Configuration and Name for that bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstanceBot for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceBot
func (c *ChimeSDKIdentity) CreateAppInstanceBot(input *CreateAppInstanceBotInput) (*CreateAppInstanceBotOutput, error) {
	req, out := c.CreateAppInstanceBotRequest(input)
	return out, req.Send()
}

// CreateAppInstanceBotWithContext is the same as CreateAppInstanceBot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceBotWithContext(ctx aws.Context, input *CreateAppInstanceBotInput, opts ...request.Option) (*CreateAppInstanceBotOutput, error) {
	req, out := c.CreateAppInstanceBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceUser = "CreateAppInstanceUser"

// CreateAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceUser for more information on using the CreateAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceUserRequest method.
//	req, resp := client.CreateAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser
func (c *ChimeSDKIdentity) CreateAppInstanceUserRequest(input *CreateAppInstanceUserInput) (req *request.Request, output *CreateAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstanceUser,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instance-users",
	}

	if input == nil {
		input = &CreateAppInstanceUserInput{}
	}

	output = &CreateAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Creates a user under an Amazon Chime AppInstance. The request consists of
// a unique appInstanceUserId and Name for that user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser
func (c *ChimeSDKIdentity) CreateAppInstanceUser(input *CreateAppInstanceUserInput) (*CreateAppInstanceUserOutput, error) {
	req, out := c.CreateAppInstanceUserRequest(input)
	return out, req.Send()
}

// CreateAppInstanceUserWithContext is the same as CreateAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceUserWithContext(ctx aws.Context, input *CreateAppInstanceUserInput, opts ...request.Option) (*CreateAppInstanceUserOutput, error) {
	req, out := c.CreateAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstance = "DeleteAppInstance"

// DeleteAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstance for more information on using the DeleteAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceRequest method.
//	req, resp := client.DeleteAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance
func (c *ChimeSDKIdentity) DeleteAppInstanceRequest(input *DeleteAppInstanceInput) (req *request.Request, output *DeleteAppInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceInput{}
	}

	output = &DeleteAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstance API operation for Amazon Chime SDK Identity.
//
// Deletes an AppInstance and all associated data asynchronously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance
func (c *ChimeSDKIdentity) DeleteAppInstance(input *DeleteAppInstanceInput) (*DeleteAppInstanceOutput, error) {
	req, out := c.DeleteAppInstanceRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceWithContext is the same as DeleteAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceWithContext(ctx aws.Context, input *DeleteAppInstanceInput, opts ...request.Option) (*DeleteAppInstanceOutput, error) {
	req, out := c.DeleteAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceAdmin = "DeleteAppInstanceAdmin"

// DeleteAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceAdmin for more information on using the DeleteAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceAdminRequest method.
//	req, resp := client.DeleteAppInstanceAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin
func (c *ChimeSDKIdentity) DeleteAppInstanceAdminRequest(input *DeleteAppInstanceAdminInput) (req *request.Request, output *DeleteAppInstanceAdminOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstanceAdmin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins/{appInstanceAdminArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceAdminInput{}
	}

	output = &DeleteAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstanceAdmin API operation for Amazon Chime SDK Identity.
//
// Demotes an AppInstanceAdmin to an AppInstanceUser or AppInstanceBot. This
// action does not delete the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin
func (c *ChimeSDKIdentity) DeleteAppInstanceAdmin(input *DeleteAppInstanceAdminInput) (*DeleteAppInstanceAdminOutput, error) {
	req, out := c.DeleteAppInstanceAdminRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceAdminWithContext is the same as DeleteAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceAdminWithContext(ctx aws.Context, input *DeleteAppInstanceAdminInput, opts ...request.Option) (*DeleteAppInstanceAdminOutput, error) {
	req, out := c.DeleteAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceBot = "DeleteAppInstanceBot"

// DeleteAppInstanceBotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceBot for more information on using the DeleteAppInstanceBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceBotRequest method.
//	req, resp := client.DeleteAppInstanceBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceBot
func (c *ChimeSDKIdentity) DeleteAppInstanceBotRequest(input *DeleteAppInstanceBotInput) (req *request.Request, output *DeleteAppInstanceBotOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstanceBot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instance-bots/{appInstanceBotArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceBotInput{}
	}

	output = &DeleteAppInstanceBotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstanceBot API operation for Amazon Chime SDK Identity.
//
// Deletes an AppInstanceBot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstanceBot for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceBot
func (c *ChimeSDKIdentity) DeleteAppInstanceBot(input *DeleteAppInstanceBotInput) (*DeleteAppInstanceBotOutput, error) {
	req, out := c.DeleteAppInstanceBotRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceBotWithContext is the same as DeleteAppInstanceBot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceBotWithContext(ctx aws.Context, input *DeleteAppInstanceBotInput, opts ...request.Option) (*DeleteAppInstanceBotOutput, error) {
	req, out := c.DeleteAppInstanceBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceUser = "DeleteAppInstanceUser"

// DeleteAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceUser for more information on using the DeleteAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceUserRequest method.
//	req, resp := client.DeleteAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser
func (c *ChimeSDKIdentity) DeleteAppInstanceUserRequest(input *DeleteAppInstanceUserInput) (req *request.Request, output *DeleteAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstanceUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceUserInput{}
	}

	output = &DeleteAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Deletes an AppInstanceUser.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser
func (c *ChimeSDKIdentity) DeleteAppInstanceUser(input *DeleteAppInstanceUserInput) (*DeleteAppInstanceUserOutput, error) {
	req, out := c.DeleteAppInstanceUserRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceUserWithContext is the same as DeleteAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceUserWithContext(ctx aws.Context, input *DeleteAppInstanceUserInput, opts ...request.Option) (*DeleteAppInstanceUserOutput, error) {
	req, out := c.DeleteAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterAppInstanceUserEndpoint = "DeregisterAppInstanceUserEndpoint"

// DeregisterAppInstanceUserEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterAppInstanceUserEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterAppInstanceUserEndpoint for more information on using the DeregisterAppInstanceUserEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterAppInstanceUserEndpointRequest method.
//	req, resp := client.DeregisterAppInstanceUserEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeregisterAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) DeregisterAppInstanceUserEndpointRequest(input *DeregisterAppInstanceUserEndpointInput) (req *request.Request, output *DeregisterAppInstanceUserEndpointOutput) {
	op := &request.Operation{
		Name:       opDeregisterAppInstanceUserEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}/endpoints/{endpointId}",
	}

	if input == nil {
		input = &DeregisterAppInstanceUserEndpointInput{}
	}

	output = &DeregisterAppInstanceUserEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterAppInstanceUserEndpoint API operation for Amazon Chime SDK Identity.
//
// Deregisters an AppInstanceUserEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeregisterAppInstanceUserEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeregisterAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) DeregisterAppInstanceUserEndpoint(input *DeregisterAppInstanceUserEndpointInput) (*DeregisterAppInstanceUserEndpointOutput, error) {
	req, out := c.DeregisterAppInstanceUserEndpointRequest(input)
	return out, req.Send()
}

// DeregisterAppInstanceUserEndpointWithContext is the same as DeregisterAppInstanceUserEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterAppInstanceUserEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeregisterAppInstanceUserEndpointWithContext(ctx aws.Context, input *DeregisterAppInstanceUserEndpointInput, opts ...request.Option) (*DeregisterAppInstanceUserEndpointOutput, error) {
	req, out := c.DeregisterAppInstanceUserEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstance = "DescribeAppInstance"

// DescribeAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstance for more information on using the DescribeAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceRequest method.
//	req, resp := client.DescribeAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance
func (c *ChimeSDKIdentity) DescribeAppInstanceRequest(input *DescribeAppInstanceInput) (req *request.Request, output *DescribeAppInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceInput{}
	}

	output = &DescribeAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstance API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance
func (c *ChimeSDKIdentity) DescribeAppInstance(input *DescribeAppInstanceInput) (*DescribeAppInstanceOutput, error) {
	req, out := c.DescribeAppInstanceRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceWithContext is the same as DescribeAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceWithContext(ctx aws.Context, input *DescribeAppInstanceInput, opts ...request.Option) (*DescribeAppInstanceOutput, error) {
	req, out := c.DescribeAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceAdmin = "DescribeAppInstanceAdmin"

// DescribeAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceAdmin for more information on using the DescribeAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceAdminRequest method.
//	req, resp := client.DescribeAppInstanceAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin
func (c *ChimeSDKIdentity) DescribeAppInstanceAdminRequest(input *DescribeAppInstanceAdminInput) (req *request.Request, output *DescribeAppInstanceAdminOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstanceAdmin,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins/{appInstanceAdminArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceAdminInput{}
	}

	output = &DescribeAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstanceAdmin API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstanceAdmin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin
func (c *ChimeSDKIdentity) DescribeAppInstanceAdmin(input *DescribeAppInstanceAdminInput) (*DescribeAppInstanceAdminOutput, error) {
	req, out := c.DescribeAppInstanceAdminRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceAdminWithContext is the same as DescribeAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceAdminWithContext(ctx aws.Context, input *DescribeAppInstanceAdminInput, opts ...request.Option) (*DescribeAppInstanceAdminOutput, error) {
	req, out := c.DescribeAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceBot = "DescribeAppInstanceBot"

// DescribeAppInstanceBotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceBot for more information on using the DescribeAppInstanceBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceBotRequest method.
//	req, resp := client.DescribeAppInstanceBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceBot
func (c *ChimeSDKIdentity) DescribeAppInstanceBotRequest(input *DescribeAppInstanceBotInput) (req *request.Request, output *DescribeAppInstanceBotOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstanceBot,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-bots/{appInstanceBotArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceBotInput{}
	}

	output = &DescribeAppInstanceBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstanceBot API operation for Amazon Chime SDK Identity.
//
// The AppInstanceBot's information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstanceBot for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceBot
func (c *ChimeSDKIdentity) DescribeAppInstanceBot(input *DescribeAppInstanceBotInput) (*DescribeAppInstanceBotOutput, error) {
	req, out := c.DescribeAppInstanceBotRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceBotWithContext is the same as DescribeAppInstanceBot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceBotWithContext(ctx aws.Context, input *DescribeAppInstanceBotInput, opts ...request.Option) (*DescribeAppInstanceBotOutput, error) {
	req, out := c.DescribeAppInstanceBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceUser = "DescribeAppInstanceUser"

// DescribeAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceUser for more information on using the DescribeAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceUserRequest method.
//	req, resp := client.DescribeAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser
func (c *ChimeSDKIdentity) DescribeAppInstanceUserRequest(input *DescribeAppInstanceUserInput) (req *request.Request, output *DescribeAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceUserInput{}
	}

	output = &DescribeAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstanceUser.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser
func (c *ChimeSDKIdentity) DescribeAppInstanceUser(input *DescribeAppInstanceUserInput) (*DescribeAppInstanceUserOutput, error) {
	req, out := c.DescribeAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceUserWithContext is the same as DescribeAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceUserWithContext(ctx aws.Context, input *DescribeAppInstanceUserInput, opts ...request.Option) (*DescribeAppInstanceUserOutput, error) {
	req, out := c.DescribeAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceUserEndpoint = "DescribeAppInstanceUserEndpoint"

// DescribeAppInstanceUserEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceUserEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceUserEndpoint for more information on using the DescribeAppInstanceUserEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceUserEndpointRequest method.
//	req, resp := client.DescribeAppInstanceUserEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) DescribeAppInstanceUserEndpointRequest(input *DescribeAppInstanceUserEndpointInput) (req *request.Request, output *DescribeAppInstanceUserEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstanceUserEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}/endpoints/{endpointId}",
	}

	if input == nil {
		input = &DescribeAppInstanceUserEndpointInput{}
	}

	output = &DescribeAppInstanceUserEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstanceUserEndpoint API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstanceUserEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstanceUserEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) DescribeAppInstanceUserEndpoint(input *DescribeAppInstanceUserEndpointInput) (*DescribeAppInstanceUserEndpointOutput, error) {
	req, out := c.DescribeAppInstanceUserEndpointRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceUserEndpointWithContext is the same as DescribeAppInstanceUserEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceUserEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceUserEndpointWithContext(ctx aws.Context, input *DescribeAppInstanceUserEndpointInput, opts ...request.Option) (*DescribeAppInstanceUserEndpointOutput, error) {
	req, out := c.DescribeAppInstanceUserEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppInstanceRetentionSettings = "GetAppInstanceRetentionSettings"

// GetAppInstanceRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAppInstanceRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppInstanceRetentionSettings for more information on using the GetAppInstanceRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAppInstanceRetentionSettingsRequest method.
//	req, resp := client.GetAppInstanceRetentionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) GetAppInstanceRetentionSettingsRequest(input *GetAppInstanceRetentionSettingsInput) (req *request.Request, output *GetAppInstanceRetentionSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAppInstanceRetentionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/retention-settings",
	}

	if input == nil {
		input = &GetAppInstanceRetentionSettingsInput{}
	}

	output = &GetAppInstanceRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppInstanceRetentionSettings API operation for Amazon Chime SDK Identity.
//
// Gets the retention settings for an AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation GetAppInstanceRetentionSettings for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) GetAppInstanceRetentionSettings(input *GetAppInstanceRetentionSettingsInput) (*GetAppInstanceRetentionSettingsOutput, error) {
	req, out := c.GetAppInstanceRetentionSettingsRequest(input)
	return out, req.Send()
}

// GetAppInstanceRetentionSettingsWithContext is the same as GetAppInstanceRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppInstanceRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) GetAppInstanceRetentionSettingsWithContext(ctx aws.Context, input *GetAppInstanceRetentionSettingsInput, opts ...request.Option) (*GetAppInstanceRetentionSettingsOutput, error) {
	req, out := c.GetAppInstanceRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAppInstanceAdmins = "ListAppInstanceAdmins"

// ListAppInstanceAdminsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceAdmins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceAdmins for more information on using the ListAppInstanceAdmins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstanceAdminsRequest method.
//	req, resp := client.ListAppInstanceAdminsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins
func (c *ChimeSDKIdentity) ListAppInstanceAdminsRequest(input *ListAppInstanceAdminsInput) (req *request.Request, output *ListAppInstanceAdminsOutput) {
	op := &request.Operation{
		Name:       opListAppInstanceAdmins,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceAdminsInput{}
	}

	output = &ListAppInstanceAdminsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstanceAdmins API operation for Amazon Chime SDK Identity.
//
// Returns a list of the administrators in the AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstanceAdmins for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins
func (c *ChimeSDKIdentity) ListAppInstanceAdmins(input *ListAppInstanceAdminsInput) (*ListAppInstanceAdminsOutput, error) {
	req, out := c.ListAppInstanceAdminsRequest(input)
	return out, req.Send()
}

// ListAppInstanceAdminsWithContext is the same as ListAppInstanceAdmins with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceAdmins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceAdminsWithContext(ctx aws.Context, input *ListAppInstanceAdminsInput, opts ...request.Option) (*ListAppInstanceAdminsOutput, error) {
	req, out := c.ListAppInstanceAdminsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceAdminsPages iterates over the pages of a ListAppInstanceAdmins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceAdmins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstanceAdmins operation.
//	pageNum := 0
//	err := client.ListAppInstanceAdminsPages(params,
//	    func(page *chimesdkidentity.ListAppInstanceAdminsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKIdentity) ListAppInstanceAdminsPages(input *ListAppInstanceAdminsInput, fn func(*ListAppInstanceAdminsOutput, bool) bool) error {
	return c.ListAppInstanceAdminsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceAdminsPagesWithContext same as ListAppInstanceAdminsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceAdminsPagesWithContext(ctx aws.Context, input *ListAppInstanceAdminsInput, fn func(*ListAppInstanceAdminsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceAdminsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceAdminsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceAdminsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstanceBots = "ListAppInstanceBots"

// ListAppInstanceBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceBots for more information on using the ListAppInstanceBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstanceBotsRequest method.
//	req, resp := client.ListAppInstanceBotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceBots
func (c *ChimeSDKIdentity) ListAppInstanceBotsRequest(input *ListAppInstanceBotsInput) (req *request.Request, output *ListAppInstanceBotsOutput) {
	op := &request.Operation{
		Name:       opListAppInstanceBots,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-bots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceBotsInput{}
	}

	output = &ListAppInstanceBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstanceBots API operation for Amazon Chime SDK Identity.
//
// Lists all AppInstanceBots created under a single AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstanceBots for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceBots
func (c *ChimeSDKIdentity) ListAppInstanceBots(input *ListAppInstanceBotsInput) (*ListAppInstanceBotsOutput, error) {
	req, out := c.ListAppInstanceBotsRequest(input)
	return out, req.Send()
}

// ListAppInstanceBotsWithContext is the same as ListAppInstanceBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceBotsWithContext(ctx aws.Context, input *ListAppInstanceBotsInput, opts ...request.Option) (*ListAppInstanceBotsOutput, error) {
	req, out := c.ListAppInstanceBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceBotsPages iterates over the pages of a ListAppInstanceBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstanceBots operation.
//	pageNum := 0
//	err := client.ListAppInstanceBotsPages(params,
//	    func(page *chimesdkidentity.ListAppInstanceBotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKIdentity) ListAppInstanceBotsPages(input *ListAppInstanceBotsInput, fn func(*ListAppInstanceBotsOutput, bool) bool) error {
	return c.ListAppInstanceBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceBotsPagesWithContext same as ListAppInstanceBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceBotsPagesWithContext(ctx aws.Context, input *ListAppInstanceBotsInput, fn func(*ListAppInstanceBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstanceUserEndpoints = "ListAppInstanceUserEndpoints"

// ListAppInstanceUserEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceUserEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceUserEndpoints for more information on using the ListAppInstanceUserEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstanceUserEndpointsRequest method.
//	req, resp := client.ListAppInstanceUserEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUserEndpoints
func (c *ChimeSDKIdentity) ListAppInstanceUserEndpointsRequest(input *ListAppInstanceUserEndpointsInput) (req *request.Request, output *ListAppInstanceUserEndpointsOutput) {
	op := &request.Operation{
		Name:       opListAppInstanceUserEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}/endpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceUserEndpointsInput{}
	}

	output = &ListAppInstanceUserEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstanceUserEndpoints API operation for Amazon Chime SDK Identity.
//
// Lists all the AppInstanceUserEndpoints created under a single AppInstanceUser.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstanceUserEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUserEndpoints
func (c *ChimeSDKIdentity) ListAppInstanceUserEndpoints(input *ListAppInstanceUserEndpointsInput) (*ListAppInstanceUserEndpointsOutput, error) {
	req, out := c.ListAppInstanceUserEndpointsRequest(input)
	return out, req.Send()
}

// ListAppInstanceUserEndpointsWithContext is the same as ListAppInstanceUserEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceUserEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceUserEndpointsWithContext(ctx aws.Context, input *ListAppInstanceUserEndpointsInput, opts ...request.Option) (*ListAppInstanceUserEndpointsOutput, error) {
	req, out := c.ListAppInstanceUserEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceUserEndpointsPages iterates over the pages of a ListAppInstanceUserEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceUserEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstanceUserEndpoints operation.
//	pageNum := 0
//	err := client.ListAppInstanceUserEndpointsPages(params,
//	    func(page *chimesdkidentity.ListAppInstanceUserEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKIdentity) ListAppInstanceUserEndpointsPages(input *ListAppInstanceUserEndpointsInput, fn func(*ListAppInstanceUserEndpointsOutput, bool) bool) error {
	return c.ListAppInstanceUserEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceUserEndpointsPagesWithContext same as ListAppInstanceUserEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceUserEndpointsPagesWithContext(ctx aws.Context, input *ListAppInstanceUserEndpointsInput, fn func(*ListAppInstanceUserEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceUserEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceUserEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceUserEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstanceUsers = "ListAppInstanceUsers"

// ListAppInstanceUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceUsers for more information on using the ListAppInstanceUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstanceUsersRequest method.
//	req, resp := client.ListAppInstanceUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers
func (c *ChimeSDKIdentity) ListAppInstanceUsersRequest(input *ListAppInstanceUsersInput) (req *request.Request, output *ListAppInstanceUsersOutput) {
	op := &request.Operation{
		Name:       opListAppInstanceUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceUsersInput{}
	}

	output = &ListAppInstanceUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstanceUsers API operation for Amazon Chime SDK Identity.
//
// List all AppInstanceUsers created under a single AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstanceUsers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers
func (c *ChimeSDKIdentity) ListAppInstanceUsers(input *ListAppInstanceUsersInput) (*ListAppInstanceUsersOutput, error) {
	req, out := c.ListAppInstanceUsersRequest(input)
	return out, req.Send()
}

// ListAppInstanceUsersWithContext is the same as ListAppInstanceUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceUsersWithContext(ctx aws.Context, input *ListAppInstanceUsersInput, opts ...request.Option) (*ListAppInstanceUsersOutput, error) {
	req, out := c.ListAppInstanceUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceUsersPages iterates over the pages of a ListAppInstanceUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstanceUsers operation.
//	pageNum := 0
//	err := client.ListAppInstanceUsersPages(params,
//	    func(page *chimesdkidentity.ListAppInstanceUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKIdentity) ListAppInstanceUsersPages(input *ListAppInstanceUsersInput, fn func(*ListAppInstanceUsersOutput, bool) bool) error {
	return c.ListAppInstanceUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceUsersPagesWithContext same as ListAppInstanceUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceUsersPagesWithContext(ctx aws.Context, input *ListAppInstanceUsersInput, fn func(*ListAppInstanceUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstances = "ListAppInstances"

// ListAppInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstances for more information on using the ListAppInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstancesRequest method.
//	req, resp := client.ListAppInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances
func (c *ChimeSDKIdentity) ListAppInstancesRequest(input *ListAppInstancesInput) (req *request.Request, output *ListAppInstancesOutput) {
	op := &request.Operation{
		Name:       opListAppInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstancesInput{}
	}

	output = &ListAppInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstances API operation for Amazon Chime SDK Identity.
//
// Lists all Amazon Chime AppInstances created under a single AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstances for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances
func (c *ChimeSDKIdentity) ListAppInstances(input *ListAppInstancesInput) (*ListAppInstancesOutput, error) {
	req, out := c.ListAppInstancesRequest(input)
	return out, req.Send()
}

// ListAppInstancesWithContext is the same as ListAppInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstancesWithContext(ctx aws.Context, input *ListAppInstancesInput, opts ...request.Option) (*ListAppInstancesOutput, error) {
	req, out := c.ListAppInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstancesPages iterates over the pages of a ListAppInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstances operation.
//	pageNum := 0
//	err := client.ListAppInstancesPages(params,
//	    func(page *chimesdkidentity.ListAppInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKIdentity) ListAppInstancesPages(input *ListAppInstancesInput, fn func(*ListAppInstancesOutput, bool) bool) error {
	return c.ListAppInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstancesPagesWithContext same as ListAppInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstancesPagesWithContext(ctx aws.Context, input *ListAppInstancesInput, fn func(*ListAppInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListTagsForResource
func (c *ChimeSDKIdentity) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Chime SDK Identity.
//
// Lists the tags applied to an Amazon Chime SDK identity resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListTagsForResource
func (c *ChimeSDKIdentity) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppInstanceRetentionSettings = "PutAppInstanceRetentionSettings"

// PutAppInstanceRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutAppInstanceRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppInstanceRetentionSettings for more information on using the PutAppInstanceRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAppInstanceRetentionSettingsRequest method.
//	req, resp := client.PutAppInstanceRetentionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) PutAppInstanceRetentionSettingsRequest(input *PutAppInstanceRetentionSettingsInput) (req *request.Request, output *PutAppInstanceRetentionSettingsOutput) {
	op := &request.Operation{
		Name:       opPutAppInstanceRetentionSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}/retention-settings",
	}

	if input == nil {
		input = &PutAppInstanceRetentionSettingsInput{}
	}

	output = &PutAppInstanceRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAppInstanceRetentionSettings API operation for Amazon Chime SDK Identity.
//
// Sets the amount of time in days that a given AppInstance retains data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation PutAppInstanceRetentionSettings for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) PutAppInstanceRetentionSettings(input *PutAppInstanceRetentionSettingsInput) (*PutAppInstanceRetentionSettingsOutput, error) {
	req, out := c.PutAppInstanceRetentionSettingsRequest(input)
	return out, req.Send()
}

// PutAppInstanceRetentionSettingsWithContext is the same as PutAppInstanceRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppInstanceRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) PutAppInstanceRetentionSettingsWithContext(ctx aws.Context, input *PutAppInstanceRetentionSettingsInput, opts ...request.Option) (*PutAppInstanceRetentionSettingsOutput, error) {
	req, out := c.PutAppInstanceRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppInstanceUserExpirationSettings = "PutAppInstanceUserExpirationSettings"

// PutAppInstanceUserExpirationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutAppInstanceUserExpirationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppInstanceUserExpirationSettings for more information on using the PutAppInstanceUserExpirationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAppInstanceUserExpirationSettingsRequest method.
//	req, resp := client.PutAppInstanceUserExpirationSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceUserExpirationSettings
func (c *ChimeSDKIdentity) PutAppInstanceUserExpirationSettingsRequest(input *PutAppInstanceUserExpirationSettingsInput) (req *request.Request, output *PutAppInstanceUserExpirationSettingsOutput) {
	op := &request.Operation{
		Name:       opPutAppInstanceUserExpirationSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}/expiration-settings",
	}

	if input == nil {
		input = &PutAppInstanceUserExpirationSettingsInput{}
	}

	output = &PutAppInstanceUserExpirationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAppInstanceUserExpirationSettings API operation for Amazon Chime SDK Identity.
//
// Sets the number of days before the AppInstanceUser is automatically deleted.
//
// A background process deletes expired AppInstanceUsers within 6 hours of expiration.
// Actual deletion times may vary.
//
// Expired AppInstanceUsers that have not yet been deleted appear as active,
// and you can update their expiration settings. The system honors the new settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation PutAppInstanceUserExpirationSettings for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceUserExpirationSettings
func (c *ChimeSDKIdentity) PutAppInstanceUserExpirationSettings(input *PutAppInstanceUserExpirationSettingsInput) (*PutAppInstanceUserExpirationSettingsOutput, error) {
	req, out := c.PutAppInstanceUserExpirationSettingsRequest(input)
	return out, req.Send()
}

// PutAppInstanceUserExpirationSettingsWithContext is the same as PutAppInstanceUserExpirationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppInstanceUserExpirationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) PutAppInstanceUserExpirationSettingsWithContext(ctx aws.Context, input *PutAppInstanceUserExpirationSettingsInput, opts ...request.Option) (*PutAppInstanceUserExpirationSettingsOutput, error) {
	req, out := c.PutAppInstanceUserExpirationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterAppInstanceUserEndpoint = "RegisterAppInstanceUserEndpoint"

// RegisterAppInstanceUserEndpointRequest generates a "aws/request.Request" representing the
// client's request for the RegisterAppInstanceUserEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterAppInstanceUserEndpoint for more information on using the RegisterAppInstanceUserEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterAppInstanceUserEndpointRequest method.
//	req, resp := client.RegisterAppInstanceUserEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/RegisterAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) RegisterAppInstanceUserEndpointRequest(input *RegisterAppInstanceUserEndpointInput) (req *request.Request, output *RegisterAppInstanceUserEndpointOutput) {
	op := &request.Operation{
		Name:       opRegisterAppInstanceUserEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}/endpoints",
	}

	if input == nil {
		input = &RegisterAppInstanceUserEndpointInput{}
	}

	output = &RegisterAppInstanceUserEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterAppInstanceUserEndpoint API operation for Amazon Chime SDK Identity.
//
// Registers an endpoint under an Amazon Chime AppInstanceUser. The endpoint
// receives messages for a user. For push notifications, the endpoint is a mobile
// device used to receive mobile push notifications for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation RegisterAppInstanceUserEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/RegisterAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) RegisterAppInstanceUserEndpoint(input *RegisterAppInstanceUserEndpointInput) (*RegisterAppInstanceUserEndpointOutput, error) {
	req, out := c.RegisterAppInstanceUserEndpointRequest(input)
	return out, req.Send()
}

// RegisterAppInstanceUserEndpointWithContext is the same as RegisterAppInstanceUserEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterAppInstanceUserEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) RegisterAppInstanceUserEndpointWithContext(ctx aws.Context, input *RegisterAppInstanceUserEndpointInput, opts ...request.Option) (*RegisterAppInstanceUserEndpointOutput, error) {
	req, out := c.RegisterAppInstanceUserEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/TagResource
func (c *ChimeSDKIdentity) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Chime SDK Identity.
//
// Applies the specified tags to the specified Amazon Chime SDK identity resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/TagResource
func (c *ChimeSDKIdentity) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UntagResource
func (c *ChimeSDKIdentity) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Chime SDK Identity.
//
// Removes the specified tags from the specified Amazon Chime SDK identity resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UntagResource
func (c *ChimeSDKIdentity) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstance = "UpdateAppInstance"

// UpdateAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstance for more information on using the UpdateAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppInstanceRequest method.
//	req, resp := client.UpdateAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance
func (c *ChimeSDKIdentity) UpdateAppInstanceRequest(input *UpdateAppInstanceInput) (req *request.Request, output *UpdateAppInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateAppInstance,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceInput{}
	}

	output = &UpdateAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppInstance API operation for Amazon Chime SDK Identity.
//
// Updates AppInstance metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UpdateAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance
func (c *ChimeSDKIdentity) UpdateAppInstance(input *UpdateAppInstanceInput) (*UpdateAppInstanceOutput, error) {
	req, out := c.UpdateAppInstanceRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceWithContext is the same as UpdateAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UpdateAppInstanceWithContext(ctx aws.Context, input *UpdateAppInstanceInput, opts ...request.Option) (*UpdateAppInstanceOutput, error) {
	req, out := c.UpdateAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstanceBot = "UpdateAppInstanceBot"

// UpdateAppInstanceBotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstanceBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstanceBot for more information on using the UpdateAppInstanceBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppInstanceBotRequest method.
//	req, resp := client.UpdateAppInstanceBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceBot
func (c *ChimeSDKIdentity) UpdateAppInstanceBotRequest(input *UpdateAppInstanceBotInput) (req *request.Request, output *UpdateAppInstanceBotOutput) {
	op := &request.Operation{
		Name:       opUpdateAppInstanceBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instance-bots/{appInstanceBotArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceBotInput{}
	}

	output = &UpdateAppInstanceBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppInstanceBot API operation for Amazon Chime SDK Identity.
//
// Updates the name and metadata of an AppInstanceBot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UpdateAppInstanceBot for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceBot
func (c *ChimeSDKIdentity) UpdateAppInstanceBot(input *UpdateAppInstanceBotInput) (*UpdateAppInstanceBotOutput, error) {
	req, out := c.UpdateAppInstanceBotRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceBotWithContext is the same as UpdateAppInstanceBot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstanceBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UpdateAppInstanceBotWithContext(ctx aws.Context, input *UpdateAppInstanceBotInput, opts ...request.Option) (*UpdateAppInstanceBotOutput, error) {
	req, out := c.UpdateAppInstanceBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstanceUser = "UpdateAppInstanceUser"

// UpdateAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstanceUser for more information on using the UpdateAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppInstanceUserRequest method.
//	req, resp := client.UpdateAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser
func (c *ChimeSDKIdentity) UpdateAppInstanceUserRequest(input *UpdateAppInstanceUserInput) (req *request.Request, output *UpdateAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opUpdateAppInstanceUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceUserInput{}
	}

	output = &UpdateAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Updates the details of an AppInstanceUser. You can update names and metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UpdateAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser
func (c *ChimeSDKIdentity) UpdateAppInstanceUser(input *UpdateAppInstanceUserInput) (*UpdateAppInstanceUserOutput, error) {
	req, out := c.UpdateAppInstanceUserRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceUserWithContext is the same as UpdateAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UpdateAppInstanceUserWithContext(ctx aws.Context, input *UpdateAppInstanceUserInput, opts ...request.Option) (*UpdateAppInstanceUserOutput, error) {
	req, out := c.UpdateAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstanceUserEndpoint = "UpdateAppInstanceUserEndpoint"

// UpdateAppInstanceUserEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstanceUserEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstanceUserEndpoint for more information on using the UpdateAppInstanceUserEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppInstanceUserEndpointRequest method.
//	req, resp := client.UpdateAppInstanceUserEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) UpdateAppInstanceUserEndpointRequest(input *UpdateAppInstanceUserEndpointInput) (req *request.Request, output *UpdateAppInstanceUserEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateAppInstanceUserEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}/endpoints/{endpointId}",
	}

	if input == nil {
		input = &UpdateAppInstanceUserEndpointInput{}
	}

	output = &UpdateAppInstanceUserEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppInstanceUserEndpoint API operation for Amazon Chime SDK Identity.
//
// Updates the details of an AppInstanceUserEndpoint. You can update the name
// and AllowMessage values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UpdateAppInstanceUserEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUserEndpoint
func (c *ChimeSDKIdentity) UpdateAppInstanceUserEndpoint(input *UpdateAppInstanceUserEndpointInput) (*UpdateAppInstanceUserEndpointOutput, error) {
	req, out := c.UpdateAppInstanceUserEndpointRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceUserEndpointWithContext is the same as UpdateAppInstanceUserEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstanceUserEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UpdateAppInstanceUserEndpointWithContext(ctx aws.Context, input *UpdateAppInstanceUserEndpointInput, opts ...request.Option) (*UpdateAppInstanceUserEndpointOutput, error) {
	req, out := c.UpdateAppInstanceUserEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The details of an AppInstance, an instance of an Amazon Chime SDK messaging
// application.
type AppInstance struct {
	_ struct{} `type:"structure"`

	// The ARN of the messaging instance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The time at which an AppInstance was created. In epoch milliseconds.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time an AppInstance was last updated. In epoch milliseconds.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata of an AppInstance.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstance's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of an AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstance's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstance) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstance) SetAppInstanceArn(v string) *AppInstance {
	s.AppInstanceArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstance) SetCreatedTimestamp(v time.Time) *AppInstance {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstance) SetLastUpdatedTimestamp(v time.Time) *AppInstance {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstance) SetMetadata(v string) *AppInstance {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstance) SetName(v string) *AppInstance {
	s.Name = &v
	return s
}

// The name and ARN of the admin for the AppInstance.
type AppInstanceAdmin struct {
	_ struct{} `type:"structure"`

	// The AppInstanceAdmin data.
	Admin *Identity `type:"structure"`

	// The ARN of the AppInstance for which the user is an administrator.
	AppInstanceArn *string `min:"5" type:"string"`

	// The time at which an administrator was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdmin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdmin) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *AppInstanceAdmin) SetAdmin(v *Identity) *AppInstanceAdmin {
	s.Admin = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstanceAdmin) SetAppInstanceArn(v string) *AppInstanceAdmin {
	s.AppInstanceArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceAdmin) SetCreatedTimestamp(v time.Time) *AppInstanceAdmin {
	s.CreatedTimestamp = &v
	return s
}

// Summary of the details of an AppInstanceAdmin.
type AppInstanceAdminSummary struct {
	_ struct{} `type:"structure"`

	// The details of the AppInstanceAdmin.
	Admin *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdminSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdminSummary) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *AppInstanceAdminSummary) SetAdmin(v *Identity) *AppInstanceAdminSummary {
	s.Admin = v
	return s
}

// An Amazon Lex V2 chat bot created under an AppInstance.
type AppInstanceBot struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceBot.
	AppInstanceBotArn *string `min:"5" type:"string"`

	// The data processing instructions for an AppInstanceBot.
	Configuration *Configuration `type:"structure"`

	// The time at which the AppInstanceBot was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which the AppInstanceBot was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata for an AppInstanceBot.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceBot's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstanceBot.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceBot's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceBot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceBot) GoString() string {
	return s.String()
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *AppInstanceBot) SetAppInstanceBotArn(v string) *AppInstanceBot {
	s.AppInstanceBotArn = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *AppInstanceBot) SetConfiguration(v *Configuration) *AppInstanceBot {
	s.Configuration = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceBot) SetCreatedTimestamp(v time.Time) *AppInstanceBot {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstanceBot) SetLastUpdatedTimestamp(v time.Time) *AppInstanceBot {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceBot) SetMetadata(v string) *AppInstanceBot {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceBot) SetName(v string) *AppInstanceBot {
	s.Name = &v
	return s
}

// High-level information about an AppInstanceBot.
type AppInstanceBotSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceBot.
	AppInstanceBotArn *string `min:"5" type:"string"`

	// The metadata of the AppInstanceBot.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceBotSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstanceBox.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceBotSummary's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceBotSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceBotSummary) GoString() string {
	return s.String()
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *AppInstanceBotSummary) SetAppInstanceBotArn(v string) *AppInstanceBotSummary {
	s.AppInstanceBotArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceBotSummary) SetMetadata(v string) *AppInstanceBotSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceBotSummary) SetName(v string) *AppInstanceBotSummary {
	s.Name = &v
	return s
}

// The details of the data-retention settings for an AppInstance.
type AppInstanceRetentionSettings struct {
	_ struct{} `type:"structure"`

	// The length of time in days to retain the messages in a channel.
	ChannelRetentionSettings *ChannelRetentionSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceRetentionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceRetentionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppInstanceRetentionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppInstanceRetentionSettings"}
	if s.ChannelRetentionSettings != nil {
		if err := s.ChannelRetentionSettings.Validate(); err != nil {
			invalidParams.AddNested("ChannelRetentionSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelRetentionSettings sets the ChannelRetentionSettings field's value.
func (s *AppInstanceRetentionSettings) SetChannelRetentionSettings(v *ChannelRetentionSettings) *AppInstanceRetentionSettings {
	s.ChannelRetentionSettings = v
	return s
}

// Summary of the data for an AppInstance.
type AppInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The AppInstance ARN.
	AppInstanceArn *string `min:"5" type:"string"`

	// The metadata of the AppInstance.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceSummary) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstanceSummary) SetAppInstanceArn(v string) *AppInstanceSummary {
	s.AppInstanceArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceSummary) SetMetadata(v string) *AppInstanceSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceSummary) SetName(v string) *AppInstanceSummary {
	s.Name = &v
	return s
}

// The details of an AppInstanceUser.
type AppInstanceUser struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// The time at which the AppInstanceUser was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The interval after which an AppInstanceUser is automatically deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`

	// The time at which the AppInstanceUser was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUser's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUser's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUser) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUser) SetAppInstanceUserArn(v string) *AppInstanceUser {
	s.AppInstanceUserArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceUser) SetCreatedTimestamp(v time.Time) *AppInstanceUser {
	s.CreatedTimestamp = &v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *AppInstanceUser) SetExpirationSettings(v *ExpirationSettings) *AppInstanceUser {
	s.ExpirationSettings = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstanceUser) SetLastUpdatedTimestamp(v time.Time) *AppInstanceUser {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceUser) SetMetadata(v string) *AppInstanceUser {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUser) SetName(v string) *AppInstanceUser {
	s.Name = &v
	return s
}

// An endpoint under an Amazon Chime AppInstanceUser that receives messages
// for a user. For push notifications, the endpoint is a mobile device used
// to receive mobile push notifications for a user.
type AppInstanceUserEndpoint struct {
	_ struct{} `type:"structure"`

	// Boolean that controls whether the AppInstanceUserEndpoint is opted in to
	// receive messages. ALL indicates the endpoint will receive all messages. NONE
	// indicates the endpoint will receive no messages.
	AllowMessages *string `type:"string" enum:"AllowMessages"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserEndpoint's
	// String and GoString methods.
	AppInstanceUserArn *string `min:"5" type:"string" sensitive:"true"`

	// The time at which an AppInstanceUserEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The attributes of an Endpoint.
	EndpointAttributes *EndpointAttributes `type:"structure"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserEndpoint's
	// String and GoString methods.
	EndpointId *string `type:"string" sensitive:"true"`

	// A read-only field that represents the state of an AppInstanceUserEndpoint.
	// Supported values:
	//
	//    * ACTIVE: The AppInstanceUserEndpoint is active and able to receive messages.
	//    When ACTIVE, the EndpointStatusReason remains empty.
	//
	//    * INACTIVE: The AppInstanceUserEndpoint is inactive and can't receive
	//    message. When INACTIVE, the corresponding reason will be conveyed through
	//    EndpointStatusReason.
	//
	//    * INVALID_DEVICE_TOKEN indicates that an AppInstanceUserEndpoint is INACTIVE
	//    due to invalid device token
	//
	//    * INVALID_PINPOINT_ARN indicates that an AppInstanceUserEndpoint is INACTIVE
	//    due to an invalid pinpoint ARN that was input through the ResourceArn
	//    field.
	EndpointState *EndpointState `type:"structure"`

	// The time at which an AppInstanceUserEndpoint was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The name of the AppInstanceUserEndpoint.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserEndpoint's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`

	// The ARN of the resource to which the endpoint belongs.
	ResourceArn *string `min:"5" type:"string"`

	// The type of the AppInstanceUserEndpoint.
	Type *string `type:"string" enum:"AppInstanceUserEndpointType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserEndpoint) GoString() string {
	return s.String()
}

// SetAllowMessages sets the AllowMessages field's value.
func (s *AppInstanceUserEndpoint) SetAllowMessages(v string) *AppInstanceUserEndpoint {
	s.AllowMessages = &v
	return s
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUserEndpoint) SetAppInstanceUserArn(v string) *AppInstanceUserEndpoint {
	s.AppInstanceUserArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceUserEndpoint) SetCreatedTimestamp(v time.Time) *AppInstanceUserEndpoint {
	s.CreatedTimestamp = &v
	return s
}

// SetEndpointAttributes sets the EndpointAttributes field's value.
func (s *AppInstanceUserEndpoint) SetEndpointAttributes(v *EndpointAttributes) *AppInstanceUserEndpoint {
	s.EndpointAttributes = v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *AppInstanceUserEndpoint) SetEndpointId(v string) *AppInstanceUserEndpoint {
	s.EndpointId = &v
	return s
}

// SetEndpointState sets the EndpointState field's value.
func (s *AppInstanceUserEndpoint) SetEndpointState(v *EndpointState) *AppInstanceUserEndpoint {
	s.EndpointState = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstanceUserEndpoint) SetLastUpdatedTimestamp(v time.Time) *AppInstanceUserEndpoint {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUserEndpoint) SetName(v string) *AppInstanceUserEndpoint {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AppInstanceUserEndpoint) SetResourceArn(v string) *AppInstanceUserEndpoint {
	s.ResourceArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *AppInstanceUserEndpoint) SetType(v string) *AppInstanceUserEndpoint {
	s.Type = &v
	return s
}

// Summary of the details of an AppInstanceUserEndpoint.
type AppInstanceUserEndpointSummary struct {
	_ struct{} `type:"structure"`

	// BBoolean that controls whether the AppInstanceUserEndpoint is opted in to
	// receive messages. ALL indicates the endpoint will receive all messages. NONE
	// indicates the endpoint will receive no messages.
	AllowMessages *string `type:"string" enum:"AllowMessages"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserEndpointSummary's
	// String and GoString methods.
	AppInstanceUserArn *string `min:"5" type:"string" sensitive:"true"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserEndpointSummary's
	// String and GoString methods.
	EndpointId *string `type:"string" sensitive:"true"`

	// A read-only field that represent the state of an AppInstanceUserEndpoint.
	EndpointState *EndpointState `type:"structure"`

	// The name of the AppInstanceUserEndpoint.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserEndpointSummary's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`

	// The type of the AppInstanceUserEndpoint.
	Type *string `type:"string" enum:"AppInstanceUserEndpointType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserEndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserEndpointSummary) GoString() string {
	return s.String()
}

// SetAllowMessages sets the AllowMessages field's value.
func (s *AppInstanceUserEndpointSummary) SetAllowMessages(v string) *AppInstanceUserEndpointSummary {
	s.AllowMessages = &v
	return s
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUserEndpointSummary) SetAppInstanceUserArn(v string) *AppInstanceUserEndpointSummary {
	s.AppInstanceUserArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *AppInstanceUserEndpointSummary) SetEndpointId(v string) *AppInstanceUserEndpointSummary {
	s.EndpointId = &v
	return s
}

// SetEndpointState sets the EndpointState field's value.
func (s *AppInstanceUserEndpointSummary) SetEndpointState(v *EndpointState) *AppInstanceUserEndpointSummary {
	s.EndpointState = v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUserEndpointSummary) SetName(v string) *AppInstanceUserEndpointSummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AppInstanceUserEndpointSummary) SetType(v string) *AppInstanceUserEndpointSummary {
	s.Type = &v
	return s
}

// Summary of the details of an AppInstanceUser.
type AppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of an AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUserSummary) SetAppInstanceUserArn(v string) *AppInstanceUserSummary {
	s.AppInstanceUserArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceUserSummary) SetMetadata(v string) *AppInstanceUserSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUserSummary) SetName(v string) *AppInstanceUserSummary {
	s.Name = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of the retention settings for a channel.
type ChannelRetentionSettings struct {
	_ struct{} `type:"structure"`

	// The time in days to retain the messages in a channel.
	RetentionDays *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelRetentionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelRetentionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelRetentionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelRetentionSettings"}
	if s.RetentionDays != nil && *s.RetentionDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *ChannelRetentionSettings) SetRetentionDays(v int64) *ChannelRetentionSettings {
	s.RetentionDays = &v
	return s
}

// A structure that contains configuration data.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The configuration for an Amazon Lex V2 bot.
	//
	// Lex is a required field
	Lex *LexConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Configuration"}
	if s.Lex == nil {
		invalidParams.Add(request.NewErrParamRequired("Lex"))
	}
	if s.Lex != nil {
		if err := s.Lex.Validate(); err != nil {
			invalidParams.AddNested("Lex", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLex sets the Lex field's value.
func (s *Configuration) SetLex(v *LexConfiguration) *Configuration {
	s.Lex = v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAppInstanceAdminInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the administrator of the current AppInstance.
	//
	// AppInstanceAdminArn is a required field
	AppInstanceAdminArn *string `min:"5" type:"string" required:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceAdminInput"}
	if s.AppInstanceAdminArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceAdminArn"))
	}
	if s.AppInstanceAdminArn != nil && len(*s.AppInstanceAdminArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceAdminArn", 5))
	}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceAdminArn sets the AppInstanceAdminArn field's value.
func (s *CreateAppInstanceAdminInput) SetAppInstanceAdminArn(v string) *CreateAppInstanceAdminInput {
	s.AppInstanceAdminArn = &v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceAdminInput) SetAppInstanceArn(v string) *CreateAppInstanceAdminInput {
	s.AppInstanceArn = &v
	return s
}

type CreateAppInstanceAdminOutput struct {
	_ struct{} `type:"structure"`

	// The ARN and name of the administrator, the ARN of the AppInstance, and the
	// created and last-updated timestamps. All timestamps use epoch milliseconds.
	AppInstanceAdmin *Identity `type:"structure"`

	// The ARN of the of the admin for the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminOutput) GoString() string {
	return s.String()
}

// SetAppInstanceAdmin sets the AppInstanceAdmin field's value.
func (s *CreateAppInstanceAdminOutput) SetAppInstanceAdmin(v *Identity) *CreateAppInstanceAdminOutput {
	s.AppInstanceAdmin = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceAdminOutput) SetAppInstanceArn(v string) *CreateAppInstanceAdminOutput {
	s.AppInstanceArn = &v
	return s
}

type CreateAppInstanceBotInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance request.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `min:"5" type:"string" required:"true"`

	// The unique ID for the client making the request. Use different tokens for
	// different AppInstanceBots.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true"`

	// Configuration information about the Amazon Lex V2 V2 bot.
	//
	// Configuration is a required field
	Configuration *Configuration `type:"structure" required:"true"`

	// The request metadata. Limited to a 1KB string in UTF-8.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceBotInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The user's name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceBotInput's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`

	// The tags assigned to the AppInstanceBot.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceBotInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceBotInput) SetAppInstanceArn(v string) *CreateAppInstanceBotInput {
	s.AppInstanceArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAppInstanceBotInput) SetClientRequestToken(v string) *CreateAppInstanceBotInput {
	s.ClientRequestToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateAppInstanceBotInput) SetConfiguration(v *Configuration) *CreateAppInstanceBotInput {
	s.Configuration = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateAppInstanceBotInput) SetMetadata(v string) *CreateAppInstanceBotInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInstanceBotInput) SetName(v string) *CreateAppInstanceBotInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInstanceBotInput) SetTags(v []*Tag) *CreateAppInstanceBotInput {
	s.Tags = v
	return s
}

type CreateAppInstanceBotOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppinstanceBot.
	AppInstanceBotArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceBotOutput) GoString() string {
	return s.String()
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *CreateAppInstanceBotOutput) SetAppInstanceBotArn(v string) *CreateAppInstanceBotOutput {
	s.AppInstanceBotArn = &v
	return s
}

type CreateAppInstanceInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the request. Use different tokens to create different AppInstances.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true"`

	// The metadata of the AppInstance. Limited to a 1KB string in UTF-8.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Tags assigned to the AppInstance.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAppInstanceInput) SetClientRequestToken(v string) *CreateAppInstanceInput {
	s.ClientRequestToken = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateAppInstanceInput) SetMetadata(v string) *CreateAppInstanceInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInstanceInput) SetName(v string) *CreateAppInstanceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInstanceInput) SetTags(v []*Tag) *CreateAppInstanceInput {
	s.Tags = v
	return s
}

type CreateAppInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceOutput) SetAppInstanceArn(v string) *CreateAppInstanceOutput {
	s.AppInstanceArn = &v
	return s
}

type CreateAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance request.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `min:"5" type:"string" required:"true"`

	// The user ID of the AppInstance.
	//
	// AppInstanceUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	//
	// AppInstanceUserId is a required field
	AppInstanceUserId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The unique ID of the request. Use different tokens to request additional
	// AppInstances.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true"`

	// Settings that control the interval after which the AppInstanceUser is automatically
	// deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`

	// The request's metadata. Limited to a 1KB string in UTF-8.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The user's name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Tags assigned to the AppInstanceUser.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceUserInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.AppInstanceUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserId"))
	}
	if s.AppInstanceUserId != nil && len(*s.AppInstanceUserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ExpirationSettings != nil {
		if err := s.ExpirationSettings.Validate(); err != nil {
			invalidParams.AddNested("ExpirationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceUserInput) SetAppInstanceArn(v string) *CreateAppInstanceUserInput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceUserId sets the AppInstanceUserId field's value.
func (s *CreateAppInstanceUserInput) SetAppInstanceUserId(v string) *CreateAppInstanceUserInput {
	s.AppInstanceUserId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAppInstanceUserInput) SetClientRequestToken(v string) *CreateAppInstanceUserInput {
	s.ClientRequestToken = &v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *CreateAppInstanceUserInput) SetExpirationSettings(v *ExpirationSettings) *CreateAppInstanceUserInput {
	s.ExpirationSettings = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateAppInstanceUserInput) SetMetadata(v string) *CreateAppInstanceUserInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInstanceUserInput) SetName(v string) *CreateAppInstanceUserInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInstanceUserInput) SetTags(v []*Tag) *CreateAppInstanceUserInput {
	s.Tags = v
	return s
}

type CreateAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The user's ARN.
	AppInstanceUserArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *CreateAppInstanceUserOutput) SetAppInstanceUserArn(v string) *CreateAppInstanceUserOutput {
	s.AppInstanceUserArn = &v
	return s
}

type DeleteAppInstanceAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance's administrator.
	//
	// AppInstanceAdminArn is a required field
	AppInstanceAdminArn *string `location:"uri" locationName:"appInstanceAdminArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceAdminInput"}
	if s.AppInstanceAdminArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceAdminArn"))
	}
	if s.AppInstanceAdminArn != nil && len(*s.AppInstanceAdminArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceAdminArn", 5))
	}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceAdminArn sets the AppInstanceAdminArn field's value.
func (s *DeleteAppInstanceAdminInput) SetAppInstanceAdminArn(v string) *DeleteAppInstanceAdminInput {
	s.AppInstanceAdminArn = &v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DeleteAppInstanceAdminInput) SetAppInstanceArn(v string) *DeleteAppInstanceAdminInput {
	s.AppInstanceArn = &v
	return s
}

type DeleteAppInstanceAdminOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminOutput) GoString() string {
	return s.String()
}

type DeleteAppInstanceBotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceBot being deleted.
	//
	// AppInstanceBotArn is a required field
	AppInstanceBotArn *string `location:"uri" locationName:"appInstanceBotArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceBotInput"}
	if s.AppInstanceBotArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceBotArn"))
	}
	if s.AppInstanceBotArn != nil && len(*s.AppInstanceBotArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceBotArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *DeleteAppInstanceBotInput) SetAppInstanceBotArn(v string) *DeleteAppInstanceBotInput {
	s.AppInstanceBotArn = &v
	return s
}

type DeleteAppInstanceBotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceBotOutput) GoString() string {
	return s.String()
}

type DeleteAppInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DeleteAppInstanceInput) SetAppInstanceArn(v string) *DeleteAppInstanceInput {
	s.AppInstanceArn = &v
	return s
}

type DeleteAppInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceOutput) GoString() string {
	return s.String()
}

type DeleteAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user request being deleted.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DeleteAppInstanceUserInput) SetAppInstanceUserArn(v string) *DeleteAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

type DeleteAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserOutput) GoString() string {
	return s.String()
}

type DeregisterAppInstanceUserEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeregisterAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true" sensitive:"true"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeregisterAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpointId" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAppInstanceUserEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAppInstanceUserEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterAppInstanceUserEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterAppInstanceUserEndpointInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DeregisterAppInstanceUserEndpointInput) SetAppInstanceUserArn(v string) *DeregisterAppInstanceUserEndpointInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DeregisterAppInstanceUserEndpointInput) SetEndpointId(v string) *DeregisterAppInstanceUserEndpointInput {
	s.EndpointId = &v
	return s
}

type DeregisterAppInstanceUserEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAppInstanceUserEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAppInstanceUserEndpointOutput) GoString() string {
	return s.String()
}

type DescribeAppInstanceAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceAdmin.
	//
	// AppInstanceAdminArn is a required field
	AppInstanceAdminArn *string `location:"uri" locationName:"appInstanceAdminArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceAdminInput"}
	if s.AppInstanceAdminArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceAdminArn"))
	}
	if s.AppInstanceAdminArn != nil && len(*s.AppInstanceAdminArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceAdminArn", 5))
	}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceAdminArn sets the AppInstanceAdminArn field's value.
func (s *DescribeAppInstanceAdminInput) SetAppInstanceAdminArn(v string) *DescribeAppInstanceAdminInput {
	s.AppInstanceAdminArn = &v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DescribeAppInstanceAdminInput) SetAppInstanceArn(v string) *DescribeAppInstanceAdminInput {
	s.AppInstanceArn = &v
	return s
}

type DescribeAppInstanceAdminOutput struct {
	_ struct{} `type:"structure"`

	// The ARN and name of the AppInstanceUser, the ARN of the AppInstance, and
	// the created and last-updated timestamps. All timestamps use epoch milliseconds.
	AppInstanceAdmin *AppInstanceAdmin `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminOutput) GoString() string {
	return s.String()
}

// SetAppInstanceAdmin sets the AppInstanceAdmin field's value.
func (s *DescribeAppInstanceAdminOutput) SetAppInstanceAdmin(v *AppInstanceAdmin) *DescribeAppInstanceAdminOutput {
	s.AppInstanceAdmin = v
	return s
}

type DescribeAppInstanceBotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceBot.
	//
	// AppInstanceBotArn is a required field
	AppInstanceBotArn *string `location:"uri" locationName:"appInstanceBotArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceBotInput"}
	if s.AppInstanceBotArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceBotArn"))
	}
	if s.AppInstanceBotArn != nil && len(*s.AppInstanceBotArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceBotArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *DescribeAppInstanceBotInput) SetAppInstanceBotArn(v string) *DescribeAppInstanceBotInput {
	s.AppInstanceBotArn = &v
	return s
}

type DescribeAppInstanceBotOutput struct {
	_ struct{} `type:"structure"`

	// The detials of the AppInstanceBot.
	AppInstanceBot *AppInstanceBot `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceBotOutput) GoString() string {
	return s.String()
}

// SetAppInstanceBot sets the AppInstanceBot field's value.
func (s *DescribeAppInstanceBotOutput) SetAppInstanceBot(v *AppInstanceBot) *DescribeAppInstanceBotOutput {
	s.AppInstanceBot = v
	return s
}

type DescribeAppInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DescribeAppInstanceInput) SetAppInstanceArn(v string) *DescribeAppInstanceInput {
	s.AppInstanceArn = &v
	return s
}

type DescribeAppInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN, metadata, created and last-updated timestamps, and the name of the
	// AppInstance. All timestamps use epoch milliseconds.
	AppInstance *AppInstance `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceOutput) GoString() string {
	return s.String()
}

// SetAppInstance sets the AppInstance field's value.
func (s *DescribeAppInstanceOutput) SetAppInstance(v *AppInstance) *DescribeAppInstanceOutput {
	s.AppInstance = v
	return s
}

type DescribeAppInstanceUserEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" type:"string" required:"true" sensitive:"true"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpointId" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceUserEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceUserEndpointInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 1))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeAppInstanceUserEndpointInput) SetAppInstanceUserArn(v string) *DescribeAppInstanceUserEndpointInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DescribeAppInstanceUserEndpointInput) SetEndpointId(v string) *DescribeAppInstanceUserEndpointInput {
	s.EndpointId = &v
	return s
}

type DescribeAppInstanceUserEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The full details of an AppInstanceUserEndpoint: the AppInstanceUserArn, ID,
	// name, type, resource ARN, attributes, allow messages, state, and created
	// and last updated timestamps. All timestamps use epoch milliseconds.
	AppInstanceUserEndpoint *AppInstanceUserEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserEndpointOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserEndpoint sets the AppInstanceUserEndpoint field's value.
func (s *DescribeAppInstanceUserEndpointOutput) SetAppInstanceUserEndpoint(v *AppInstanceUserEndpoint) *DescribeAppInstanceUserEndpointOutput {
	s.AppInstanceUserEndpoint = v
	return s
}

type DescribeAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeAppInstanceUserInput) SetAppInstanceUserArn(v string) *DescribeAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

type DescribeAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The name of the AppInstanceUser.
	AppInstanceUser *AppInstanceUser `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUser sets the AppInstanceUser field's value.
func (s *DescribeAppInstanceUserOutput) SetAppInstanceUser(v *AppInstanceUser) *DescribeAppInstanceUserOutput {
	s.AppInstanceUser = v
	return s
}

// The attributes of an Endpoint.
type EndpointAttributes struct {
	_ struct{} `type:"structure"`

	// The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.
	//
	// DeviceToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EndpointAttributes's
	// String and GoString methods.
	//
	// DeviceToken is a required field
	DeviceToken *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The VOIP device token for the APNS and APNS_SANDBOX endpoint types.
	//
	// VoipDeviceToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EndpointAttributes's
	// String and GoString methods.
	VoipDeviceToken *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointAttributes"}
	if s.DeviceToken == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceToken"))
	}
	if s.DeviceToken != nil && len(*s.DeviceToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceToken", 1))
	}
	if s.VoipDeviceToken != nil && len(*s.VoipDeviceToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoipDeviceToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceToken sets the DeviceToken field's value.
func (s *EndpointAttributes) SetDeviceToken(v string) *EndpointAttributes {
	s.DeviceToken = &v
	return s
}

// SetVoipDeviceToken sets the VoipDeviceToken field's value.
func (s *EndpointAttributes) SetVoipDeviceToken(v string) *EndpointAttributes {
	s.VoipDeviceToken = &v
	return s
}

// A read-only field that represents the state of an AppInstanceUserEndpoint.
// Supported values:
//
//   - ACTIVE: The AppInstanceUserEndpoint is active and able to receive messages.
//     When ACTIVE, the EndpointStatusReason remains empty.
//
//   - INACTIVE: The AppInstanceUserEndpoint is inactive and can't receive
//     message. When INACTIVE, the corresponding reason will be conveyed through
//     EndpointStatusReason.
//
//   - INVALID_DEVICE_TOKEN indicates that an AppInstanceUserEndpoint is INACTIVE
//     due to invalid device token
//
//   - INVALID_PINPOINT_ARN indicates that an AppInstanceUserEndpoint is INACTIVE
//     due to an invalid pinpoint ARN that was input through the ResourceArn
//     field.
type EndpointState struct {
	_ struct{} `type:"structure"`

	// Enum that indicates the Status of an AppInstanceUserEndpoint.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EndpointStatus"`

	// The reason for the EndpointStatus.
	StatusReason *string `type:"string" enum:"EndpointStatusReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointState) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *EndpointState) SetStatus(v string) *EndpointState {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *EndpointState) SetStatusReason(v string) *EndpointState {
	s.StatusReason = &v
	return s
}

// Determines the interval after which an AppInstanceUser is automatically deleted.
type ExpirationSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the conditions under which an AppInstanceUser will expire.
	//
	// ExpirationCriterion is a required field
	ExpirationCriterion *string `type:"string" required:"true" enum:"ExpirationCriterion"`

	// The period in days after which an AppInstanceUser will be automatically deleted.
	//
	// ExpirationDays is a required field
	ExpirationDays *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpirationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpirationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpirationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpirationSettings"}
	if s.ExpirationCriterion == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpirationCriterion"))
	}
	if s.ExpirationDays == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpirationDays"))
	}
	if s.ExpirationDays != nil && *s.ExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpirationCriterion sets the ExpirationCriterion field's value.
func (s *ExpirationSettings) SetExpirationCriterion(v string) *ExpirationSettings {
	s.ExpirationCriterion = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *ExpirationSettings) SetExpirationDays(v int64) *ExpirationSettings {
	s.ExpirationDays = &v
	return s
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAppInstanceRetentionSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppInstanceRetentionSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppInstanceRetentionSettingsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *GetAppInstanceRetentionSettingsInput) SetAppInstanceArn(v string) *GetAppInstanceRetentionSettingsInput {
	s.AppInstanceArn = &v
	return s
}

type GetAppInstanceRetentionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The retention settings for the AppInstance.
	AppInstanceRetentionSettings *AppInstanceRetentionSettings `type:"structure"`

	// The timestamp representing the time at which the specified items are retained,
	// in Epoch Seconds.
	InitiateDeletionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceRetentionSettings sets the AppInstanceRetentionSettings field's value.
func (s *GetAppInstanceRetentionSettingsOutput) SetAppInstanceRetentionSettings(v *AppInstanceRetentionSettings) *GetAppInstanceRetentionSettingsOutput {
	s.AppInstanceRetentionSettings = v
	return s
}

// SetInitiateDeletionTimestamp sets the InitiateDeletionTimestamp field's value.
func (s *GetAppInstanceRetentionSettingsOutput) SetInitiateDeletionTimestamp(v time.Time) *GetAppInstanceRetentionSettingsOutput {
	s.InitiateDeletionTimestamp = &v
	return s
}

// The details of a user or bot.
type Identity struct {
	_ struct{} `type:"structure"`

	// The ARN in an Identity.
	Arn *string `min:"5" type:"string"`

	// The name in an Identity.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Identity's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Identity) SetArn(v string) *Identity {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Identity) SetName(v string) *Identity {
	s.Name = &v
	return s
}

// The configuration for an Amazon Lex V2 bot.
type LexConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format: arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS
	//
	// LexBotAliasArn is a required field
	LexBotAliasArn *string `min:"15" type:"string" required:"true"`

	// Identifies the Amazon Lex V2 bot's language and locale. The string must match
	// one of the supported locales in Amazon Lex V2. All of the intents, slot types,
	// and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
	// in the Amazon Lex V2 Developer Guide.
	//
	// LocaleId is a required field
	LocaleId *string `type:"string" required:"true"`

	// Determines whether the Amazon Lex V2 bot responds to all standard messages.
	// Control messages are not supported.
	//
	// RespondsTo is a required field
	RespondsTo *string `type:"string" required:"true" enum:"RespondsTo"`

	// The name of the welcome intent configured in the Amazon Lex V2 bot.
	WelcomeIntent *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LexConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LexConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LexConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LexConfiguration"}
	if s.LexBotAliasArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LexBotAliasArn"))
	}
	if s.LexBotAliasArn != nil && len(*s.LexBotAliasArn) < 15 {
		invalidParams.Add(request.NewErrParamMinLen("LexBotAliasArn", 15))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.RespondsTo == nil {
		invalidParams.Add(request.NewErrParamRequired("RespondsTo"))
	}
	if s.WelcomeIntent != nil && len(*s.WelcomeIntent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WelcomeIntent", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLexBotAliasArn sets the LexBotAliasArn field's value.
func (s *LexConfiguration) SetLexBotAliasArn(v string) *LexConfiguration {
	s.LexBotAliasArn = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *LexConfiguration) SetLocaleId(v string) *LexConfiguration {
	s.LocaleId = &v
	return s
}

// SetRespondsTo sets the RespondsTo field's value.
func (s *LexConfiguration) SetRespondsTo(v string) *LexConfiguration {
	s.RespondsTo = &v
	return s
}

// SetWelcomeIntent sets the WelcomeIntent field's value.
func (s *LexConfiguration) SetWelcomeIntent(v string) *LexConfiguration {
	s.WelcomeIntent = &v
	return s
}

type ListAppInstanceAdminsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The maximum number of administrators that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of administrators
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceAdminsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstanceAdminsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstanceAdminsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceAdminsInput) SetAppInstanceArn(v string) *ListAppInstanceAdminsInput {
	s.AppInstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstanceAdminsInput) SetMaxResults(v int64) *ListAppInstanceAdminsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceAdminsInput) SetNextToken(v string) *ListAppInstanceAdminsInput {
	s.NextToken = &v
	return s
}

type ListAppInstanceAdminsOutput struct {
	_ struct{} `type:"structure"`

	// The information for each administrator.
	AppInstanceAdmins []*AppInstanceAdminSummary `type:"list"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The token returned from previous API requests until the number of administrators
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceAdminsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceAdmins sets the AppInstanceAdmins field's value.
func (s *ListAppInstanceAdminsOutput) SetAppInstanceAdmins(v []*AppInstanceAdminSummary) *ListAppInstanceAdminsOutput {
	s.AppInstanceAdmins = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceAdminsOutput) SetAppInstanceArn(v string) *ListAppInstanceAdminsOutput {
	s.AppInstanceArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceAdminsOutput) SetNextToken(v string) *ListAppInstanceAdminsOutput {
	s.NextToken = &v
	return s
}

type ListAppInstanceBotsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"querystring" locationName:"app-instance-arn" min:"5" type:"string" required:"true"`

	// The maximum number of requests to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested bots are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceBotsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceBotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceBotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstanceBotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstanceBotsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceBotsInput) SetAppInstanceArn(v string) *ListAppInstanceBotsInput {
	s.AppInstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstanceBotsInput) SetMaxResults(v int64) *ListAppInstanceBotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceBotsInput) SetNextToken(v string) *ListAppInstanceBotsInput {
	s.NextToken = &v
	return s
}

type ListAppInstanceBotsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The information for each requested AppInstanceBot.
	AppInstanceBots []*AppInstanceBotSummary `type:"list"`

	// The token passed by previous API calls until all requested bots are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceBotsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceBotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceBotsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceBotsOutput) SetAppInstanceArn(v string) *ListAppInstanceBotsOutput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceBots sets the AppInstanceBots field's value.
func (s *ListAppInstanceBotsOutput) SetAppInstanceBots(v []*AppInstanceBotSummary) *ListAppInstanceBotsOutput {
	s.AppInstanceBots = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceBotsOutput) SetNextToken(v string) *ListAppInstanceBotsOutput {
	s.NextToken = &v
	return s
}

type ListAppInstanceUserEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUserEndpointsInput's
	// String and GoString methods.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true" sensitive:"true"`

	// The maximum number of endpoints that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested endpoints are
	// returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUserEndpointsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUserEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUserEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstanceUserEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstanceUserEndpointsInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *ListAppInstanceUserEndpointsInput) SetAppInstanceUserArn(v string) *ListAppInstanceUserEndpointsInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstanceUserEndpointsInput) SetMaxResults(v int64) *ListAppInstanceUserEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceUserEndpointsInput) SetNextToken(v string) *ListAppInstanceUserEndpointsInput {
	s.NextToken = &v
	return s
}

type ListAppInstanceUserEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The information for each requested AppInstanceUserEndpoint.
	AppInstanceUserEndpoints []*AppInstanceUserEndpointSummary `type:"list"`

	// The token passed by previous API calls until all requested endpoints are
	// returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUserEndpointsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUserEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUserEndpointsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserEndpoints sets the AppInstanceUserEndpoints field's value.
func (s *ListAppInstanceUserEndpointsOutput) SetAppInstanceUserEndpoints(v []*AppInstanceUserEndpointSummary) *ListAppInstanceUserEndpointsOutput {
	s.AppInstanceUserEndpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceUserEndpointsOutput) SetNextToken(v string) *ListAppInstanceUserEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListAppInstanceUsersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"querystring" locationName:"app-instance-arn" min:"5" type:"string" required:"true"`

	// The maximum number of requests that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested users are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUsersInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstanceUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstanceUsersInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceUsersInput) SetAppInstanceArn(v string) *ListAppInstanceUsersInput {
	s.AppInstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstanceUsersInput) SetMaxResults(v int64) *ListAppInstanceUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceUsersInput) SetNextToken(v string) *ListAppInstanceUsersInput {
	s.NextToken = &v
	return s
}

type ListAppInstanceUsersOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The information for each requested AppInstanceUser.
	AppInstanceUsers []*AppInstanceUserSummary `type:"list"`

	// The token passed by previous API calls until all requested users are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUsersOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceUsersOutput) SetAppInstanceArn(v string) *ListAppInstanceUsersOutput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceUsers sets the AppInstanceUsers field's value.
func (s *ListAppInstanceUsersOutput) SetAppInstanceUsers(v []*AppInstanceUserSummary) *ListAppInstanceUsersOutput {
	s.AppInstanceUsers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceUsersOutput) SetNextToken(v string) *ListAppInstanceUsersOutput {
	s.NextToken = &v
	return s
}

type ListAppInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of AppInstances that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API requests until you reach the maximum number
	// of AppInstances.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstancesInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstancesInput) SetMaxResults(v int64) *ListAppInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstancesInput) SetNextToken(v string) *ListAppInstancesInput {
	s.NextToken = &v
	return s
}

type ListAppInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The information for each AppInstance.
	AppInstances []*AppInstanceSummary `type:"list"`

	// The token passed by previous API requests until the maximum number of AppInstances
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstancesOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesOutput) GoString() string {
	return s.String()
}

// SetAppInstances sets the AppInstances field's value.
func (s *ListAppInstancesOutput) SetAppInstances(v []*AppInstanceSummary) *ListAppInstancesOutput {
	s.AppInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstancesOutput) SetNextToken(v string) *ListAppInstancesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"querystring" locationName:"arn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tag key-value pairs.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutAppInstanceRetentionSettingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The time in days to retain data. Data type: number.
	//
	// AppInstanceRetentionSettings is a required field
	AppInstanceRetentionSettings *AppInstanceRetentionSettings `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppInstanceRetentionSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAppInstanceRetentionSettingsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.AppInstanceRetentionSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceRetentionSettings"))
	}
	if s.AppInstanceRetentionSettings != nil {
		if err := s.AppInstanceRetentionSettings.Validate(); err != nil {
			invalidParams.AddNested("AppInstanceRetentionSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *PutAppInstanceRetentionSettingsInput) SetAppInstanceArn(v string) *PutAppInstanceRetentionSettingsInput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceRetentionSettings sets the AppInstanceRetentionSettings field's value.
func (s *PutAppInstanceRetentionSettingsInput) SetAppInstanceRetentionSettings(v *AppInstanceRetentionSettings) *PutAppInstanceRetentionSettingsInput {
	s.AppInstanceRetentionSettings = v
	return s
}

type PutAppInstanceRetentionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The time in days to retain data. Data type: number.
	AppInstanceRetentionSettings *AppInstanceRetentionSettings `type:"structure"`

	// The time at which the API deletes data.
	InitiateDeletionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceRetentionSettings sets the AppInstanceRetentionSettings field's value.
func (s *PutAppInstanceRetentionSettingsOutput) SetAppInstanceRetentionSettings(v *AppInstanceRetentionSettings) *PutAppInstanceRetentionSettingsOutput {
	s.AppInstanceRetentionSettings = v
	return s
}

// SetInitiateDeletionTimestamp sets the InitiateDeletionTimestamp field's value.
func (s *PutAppInstanceRetentionSettingsOutput) SetInitiateDeletionTimestamp(v time.Time) *PutAppInstanceRetentionSettingsOutput {
	s.InitiateDeletionTimestamp = &v
	return s
}

type PutAppInstanceUserExpirationSettingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`

	// Settings that control the interval after which an AppInstanceUser is automatically
	// deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceUserExpirationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceUserExpirationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppInstanceUserExpirationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAppInstanceUserExpirationSettingsInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ExpirationSettings != nil {
		if err := s.ExpirationSettings.Validate(); err != nil {
			invalidParams.AddNested("ExpirationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *PutAppInstanceUserExpirationSettingsInput) SetAppInstanceUserArn(v string) *PutAppInstanceUserExpirationSettingsInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *PutAppInstanceUserExpirationSettingsInput) SetExpirationSettings(v *ExpirationSettings) *PutAppInstanceUserExpirationSettingsInput {
	s.ExpirationSettings = v
	return s
}

type PutAppInstanceUserExpirationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// Settings that control the interval after which an AppInstanceUser is automatically
	// deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceUserExpirationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceUserExpirationSettingsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *PutAppInstanceUserExpirationSettingsOutput) SetAppInstanceUserArn(v string) *PutAppInstanceUserExpirationSettingsOutput {
	s.AppInstanceUserArn = &v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *PutAppInstanceUserExpirationSettingsOutput) SetExpirationSettings(v *ExpirationSettings) *PutAppInstanceUserExpirationSettingsOutput {
	s.ExpirationSettings = v
	return s
}

type RegisterAppInstanceUserEndpointInput struct {
	_ struct{} `type:"structure"`

	// Boolean that controls whether the AppInstanceUserEndpoint is opted in to
	// receive messages. ALL indicates the endpoint receives all messages. NONE
	// indicates the endpoint receives no messages.
	AllowMessages *string `type:"string" enum:"AllowMessages"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RegisterAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true" sensitive:"true"`

	// The unique ID assigned to the request. Use different tokens to register other
	// endpoints.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true"`

	// The attributes of an Endpoint.
	//
	// EndpointAttributes is a required field
	EndpointAttributes *EndpointAttributes `type:"structure" required:"true"`

	// The name of the AppInstanceUserEndpoint.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RegisterAppInstanceUserEndpointInput's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`

	// The ARN of the resource to which the endpoint belongs.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"5" type:"string" required:"true"`

	// The type of the AppInstanceUserEndpoint. Supported types:
	//
	//    * APNS: The mobile notification service for an Apple device.
	//
	//    * APNS_SANDBOX: The sandbox environment of the mobile notification service
	//    for an Apple device.
	//
	//    * GCM: The mobile notification service for an Android device.
	//
	// Populate the ResourceArn value of each type as PinpointAppArn.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"AppInstanceUserEndpointType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAppInstanceUserEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAppInstanceUserEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterAppInstanceUserEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterAppInstanceUserEndpointInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.EndpointAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointAttributes"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 5))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.EndpointAttributes != nil {
		if err := s.EndpointAttributes.Validate(); err != nil {
			invalidParams.AddNested("EndpointAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowMessages sets the AllowMessages field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetAllowMessages(v string) *RegisterAppInstanceUserEndpointInput {
	s.AllowMessages = &v
	return s
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetAppInstanceUserArn(v string) *RegisterAppInstanceUserEndpointInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetClientRequestToken(v string) *RegisterAppInstanceUserEndpointInput {
	s.ClientRequestToken = &v
	return s
}

// SetEndpointAttributes sets the EndpointAttributes field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetEndpointAttributes(v *EndpointAttributes) *RegisterAppInstanceUserEndpointInput {
	s.EndpointAttributes = v
	return s
}

// SetName sets the Name field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetName(v string) *RegisterAppInstanceUserEndpointInput {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetResourceArn(v string) *RegisterAppInstanceUserEndpointInput {
	s.ResourceArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *RegisterAppInstanceUserEndpointInput) SetType(v string) *RegisterAppInstanceUserEndpointInput {
	s.Type = &v
	return s
}

type RegisterAppInstanceUserEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RegisterAppInstanceUserEndpointOutput's
	// String and GoString methods.
	AppInstanceUserArn *string `min:"5" type:"string" sensitive:"true"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RegisterAppInstanceUserEndpointOutput's
	// String and GoString methods.
	EndpointId *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAppInstanceUserEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAppInstanceUserEndpointOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *RegisterAppInstanceUserEndpointOutput) SetAppInstanceUserArn(v string) *RegisterAppInstanceUserEndpointOutput {
	s.AppInstanceUserArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *RegisterAppInstanceUserEndpointOutput) SetEndpointId(v string) *RegisterAppInstanceUserEndpointOutput {
	s.EndpointId = &v
	return s
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A tag object containing a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key in a tag.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value in a tag.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"5" type:"string" required:"true"`

	// The tag key-value pairs.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"5" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 5))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAppInstanceBotInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceBot.
	//
	// AppInstanceBotArn is a required field
	AppInstanceBotArn *string `location:"uri" locationName:"appInstanceBotArn" min:"5" type:"string" required:"true"`

	// The metadata of the AppInstanceBot.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceBotInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata *string `type:"string" required:"true" sensitive:"true"`

	// The name of the AppInstanceBot.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceBotInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInstanceBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInstanceBotInput"}
	if s.AppInstanceBotArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceBotArn"))
	}
	if s.AppInstanceBotArn != nil && len(*s.AppInstanceBotArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceBotArn", 5))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *UpdateAppInstanceBotInput) SetAppInstanceBotArn(v string) *UpdateAppInstanceBotInput {
	s.AppInstanceBotArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateAppInstanceBotInput) SetMetadata(v string) *UpdateAppInstanceBotInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInstanceBotInput) SetName(v string) *UpdateAppInstanceBotInput {
	s.Name = &v
	return s
}

type UpdateAppInstanceBotOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceBot.
	AppInstanceBotArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceBotOutput) GoString() string {
	return s.String()
}

// SetAppInstanceBotArn sets the AppInstanceBotArn field's value.
func (s *UpdateAppInstanceBotOutput) SetAppInstanceBotArn(v string) *UpdateAppInstanceBotOutput {
	s.AppInstanceBotArn = &v
	return s
}

type UpdateAppInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The metadata that you want to change.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata *string `type:"string" required:"true" sensitive:"true"`

	// The name that you want to change.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInstanceInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *UpdateAppInstanceInput) SetAppInstanceArn(v string) *UpdateAppInstanceInput {
	s.AppInstanceArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateAppInstanceInput) SetMetadata(v string) *UpdateAppInstanceInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInstanceInput) SetName(v string) *UpdateAppInstanceInput {
	s.Name = &v
	return s
}

type UpdateAppInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *UpdateAppInstanceOutput) SetAppInstanceArn(v string) *UpdateAppInstanceOutput {
	s.AppInstanceArn = &v
	return s
}

type UpdateAppInstanceUserEndpointInput struct {
	_ struct{} `type:"structure"`

	// Boolean that controls whether the AppInstanceUserEndpoint is opted in to
	// receive messages. ALL indicates the endpoint will receive all messages. NONE
	// indicates the endpoint will receive no messages.
	AllowMessages *string `type:"string" enum:"AllowMessages"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true" sensitive:"true"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserEndpointInput's
	// String and GoString methods.
	//
	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpointId" type:"string" required:"true" sensitive:"true"`

	// The name of the AppInstanceUserEndpoint.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserEndpointInput's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInstanceUserEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInstanceUserEndpointInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowMessages sets the AllowMessages field's value.
func (s *UpdateAppInstanceUserEndpointInput) SetAllowMessages(v string) *UpdateAppInstanceUserEndpointInput {
	s.AllowMessages = &v
	return s
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *UpdateAppInstanceUserEndpointInput) SetAppInstanceUserArn(v string) *UpdateAppInstanceUserEndpointInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *UpdateAppInstanceUserEndpointInput) SetEndpointId(v string) *UpdateAppInstanceUserEndpointInput {
	s.EndpointId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInstanceUserEndpointInput) SetName(v string) *UpdateAppInstanceUserEndpointInput {
	s.Name = &v
	return s
}

type UpdateAppInstanceUserEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserEndpointOutput's
	// String and GoString methods.
	AppInstanceUserArn *string `min:"5" type:"string" sensitive:"true"`

	// The unique identifier of the AppInstanceUserEndpoint.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserEndpointOutput's
	// String and GoString methods.
	EndpointId *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserEndpointOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *UpdateAppInstanceUserEndpointOutput) SetAppInstanceUserArn(v string) *UpdateAppInstanceUserEndpointOutput {
	s.AppInstanceUserArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *UpdateAppInstanceUserEndpointOutput) SetEndpointId(v string) *UpdateAppInstanceUserEndpointOutput {
	s.EndpointId = &v
	return s
}

type UpdateAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata *string `type:"string" required:"true" sensitive:"true"`

	// The name of the AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *UpdateAppInstanceUserInput) SetAppInstanceUserArn(v string) *UpdateAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateAppInstanceUserInput) SetMetadata(v string) *UpdateAppInstanceUserInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInstanceUserInput) SetName(v string) *UpdateAppInstanceUserInput {
	s.Name = &v
	return s
}

type UpdateAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *UpdateAppInstanceUserOutput) SetAppInstanceUserArn(v string) *UpdateAppInstanceUserOutput {
	s.AppInstanceUserArn = &v
	return s
}

const (
	// AllowMessagesAll is a AllowMessages enum value
	AllowMessagesAll = "ALL"

	// AllowMessagesNone is a AllowMessages enum value
	AllowMessagesNone = "NONE"
)

// AllowMessages_Values returns all elements of the AllowMessages enum
func AllowMessages_Values() []string {
	return []string{
		AllowMessagesAll,
		AllowMessagesNone,
	}
}

const (
	// AppInstanceUserEndpointTypeApns is a AppInstanceUserEndpointType enum value
	AppInstanceUserEndpointTypeApns = "APNS"

	// AppInstanceUserEndpointTypeApnsSandbox is a AppInstanceUserEndpointType enum value
	AppInstanceUserEndpointTypeApnsSandbox = "APNS_SANDBOX"

	// AppInstanceUserEndpointTypeGcm is a AppInstanceUserEndpointType enum value
	AppInstanceUserEndpointTypeGcm = "GCM"
)

// AppInstanceUserEndpointType_Values returns all elements of the AppInstanceUserEndpointType enum
func AppInstanceUserEndpointType_Values() []string {
	return []string{
		AppInstanceUserEndpointTypeApns,
		AppInstanceUserEndpointTypeApnsSandbox,
		AppInstanceUserEndpointTypeGcm,
	}
}

const (
	// EndpointStatusActive is a EndpointStatus enum value
	EndpointStatusActive = "ACTIVE"

	// EndpointStatusInactive is a EndpointStatus enum value
	EndpointStatusInactive = "INACTIVE"
)

// EndpointStatus_Values returns all elements of the EndpointStatus enum
func EndpointStatus_Values() []string {
	return []string{
		EndpointStatusActive,
		EndpointStatusInactive,
	}
}

const (
	// EndpointStatusReasonInvalidDeviceToken is a EndpointStatusReason enum value
	EndpointStatusReasonInvalidDeviceToken = "INVALID_DEVICE_TOKEN"

	// EndpointStatusReasonInvalidPinpointArn is a EndpointStatusReason enum value
	EndpointStatusReasonInvalidPinpointArn = "INVALID_PINPOINT_ARN"
)

// EndpointStatusReason_Values returns all elements of the EndpointStatusReason enum
func EndpointStatusReason_Values() []string {
	return []string{
		EndpointStatusReasonInvalidDeviceToken,
		EndpointStatusReasonInvalidPinpointArn,
	}
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"

	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeVoiceConnectorGroupAssociationsExist is a ErrorCode enum value
	ErrorCodeVoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"

	// ErrorCodePhoneNumberAssociationsExist is a ErrorCode enum value
	ErrorCodePhoneNumberAssociationsExist = "PhoneNumberAssociationsExist"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeConflict,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodePreconditionFailed,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeAccessDenied,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottled,
		ErrorCodeThrottling,
		ErrorCodeUnauthorized,
		ErrorCodeUnprocessable,
		ErrorCodeVoiceConnectorGroupAssociationsExist,
		ErrorCodePhoneNumberAssociationsExist,
	}
}

const (
	// ExpirationCriterionCreatedTimestamp is a ExpirationCriterion enum value
	ExpirationCriterionCreatedTimestamp = "CREATED_TIMESTAMP"
)

// ExpirationCriterion_Values returns all elements of the ExpirationCriterion enum
func ExpirationCriterion_Values() []string {
	return []string{
		ExpirationCriterionCreatedTimestamp,
	}
}

const (
	// RespondsToStandardMessages is a RespondsTo enum value
	RespondsToStandardMessages = "STANDARD_MESSAGES"
)

// RespondsTo_Values returns all elements of the RespondsTo enum
func RespondsTo_Values() []string {
	return []string{
		RespondsToStandardMessages,
	}
}
