// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/genomics/v1/reads.proto

package genomics

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ImportReadGroupSetsRequest_PartitionStrategy int32

const (
	ImportReadGroupSetsRequest_PARTITION_STRATEGY_UNSPECIFIED ImportReadGroupSetsRequest_PartitionStrategy = 0
	// In most cases, this strategy yields one read group set per file. This is
	// the default behavior.
	//
	// Allocate one read group set per file per sample. For BAM files, read
	// groups are considered to share a sample if they have identical sample
	// names. Furthermore, all reads for each file which do not belong to a read
	// group, if any, will be grouped into a single read group set per-file.
	ImportReadGroupSetsRequest_PER_FILE_PER_SAMPLE ImportReadGroupSetsRequest_PartitionStrategy = 1
	// Includes all read groups in all imported files into a single read group
	// set. Requires that the headers for all imported files are equivalent. All
	// reads which do not belong to a read group, if any, will be grouped into a
	// separate read group set.
	ImportReadGroupSetsRequest_MERGE_ALL ImportReadGroupSetsRequest_PartitionStrategy = 2
)

var ImportReadGroupSetsRequest_PartitionStrategy_name = map[int32]string{
	0: "PARTITION_STRATEGY_UNSPECIFIED",
	1: "PER_FILE_PER_SAMPLE",
	2: "MERGE_ALL",
}

var ImportReadGroupSetsRequest_PartitionStrategy_value = map[string]int32{
	"PARTITION_STRATEGY_UNSPECIFIED": 0,
	"PER_FILE_PER_SAMPLE":            1,
	"MERGE_ALL":                      2,
}

func (x ImportReadGroupSetsRequest_PartitionStrategy) String() string {
	return proto.EnumName(ImportReadGroupSetsRequest_PartitionStrategy_name, int32(x))
}

func (ImportReadGroupSetsRequest_PartitionStrategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{2, 0}
}

// The read group set search request.
type SearchReadGroupSetsRequest struct {
	// Restricts this query to read group sets within the given datasets. At least
	// one ID must be provided.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds,proto3" json:"dataset_ids,omitempty"`
	// Only return read group sets for which a substring of the name matches this
	// string.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 1024.
	PageSize             int32    `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchReadGroupSetsRequest) Reset()         { *m = SearchReadGroupSetsRequest{} }
func (m *SearchReadGroupSetsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchReadGroupSetsRequest) ProtoMessage()    {}
func (*SearchReadGroupSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{0}
}

func (m *SearchReadGroupSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchReadGroupSetsRequest.Unmarshal(m, b)
}
func (m *SearchReadGroupSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchReadGroupSetsRequest.Marshal(b, m, deterministic)
}
func (m *SearchReadGroupSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchReadGroupSetsRequest.Merge(m, src)
}
func (m *SearchReadGroupSetsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchReadGroupSetsRequest.Size(m)
}
func (m *SearchReadGroupSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchReadGroupSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchReadGroupSetsRequest proto.InternalMessageInfo

func (m *SearchReadGroupSetsRequest) GetDatasetIds() []string {
	if m != nil {
		return m.DatasetIds
	}
	return nil
}

func (m *SearchReadGroupSetsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SearchReadGroupSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchReadGroupSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The read group set search response.
type SearchReadGroupSetsResponse struct {
	// The list of matching read group sets.
	ReadGroupSets []*ReadGroupSet `protobuf:"bytes,1,rep,name=read_group_sets,json=readGroupSets,proto3" json:"read_group_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchReadGroupSetsResponse) Reset()         { *m = SearchReadGroupSetsResponse{} }
func (m *SearchReadGroupSetsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchReadGroupSetsResponse) ProtoMessage()    {}
func (*SearchReadGroupSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{1}
}

func (m *SearchReadGroupSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchReadGroupSetsResponse.Unmarshal(m, b)
}
func (m *SearchReadGroupSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchReadGroupSetsResponse.Marshal(b, m, deterministic)
}
func (m *SearchReadGroupSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchReadGroupSetsResponse.Merge(m, src)
}
func (m *SearchReadGroupSetsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchReadGroupSetsResponse.Size(m)
}
func (m *SearchReadGroupSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchReadGroupSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchReadGroupSetsResponse proto.InternalMessageInfo

func (m *SearchReadGroupSetsResponse) GetReadGroupSets() []*ReadGroupSet {
	if m != nil {
		return m.ReadGroupSets
	}
	return nil
}

func (m *SearchReadGroupSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The read group set import request.
type ImportReadGroupSetsRequest struct {
	// Required. The ID of the dataset these read group sets will belong to. The
	// caller must have WRITE permissions to this dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The reference set to which the imported read group sets are aligned to, if
	// any. The reference names of this reference set must be a superset of those
	// found in the imported file headers. If no reference set id is provided, a
	// best effort is made to associate with a matching reference set.
	ReferenceSetId string `protobuf:"bytes,4,opt,name=reference_set_id,json=referenceSetId,proto3" json:"reference_set_id,omitempty"`
	// A list of URIs pointing at [BAM
	// files](https://samtools.github.io/hts-specs/SAMv1.pdf)
	// in Google Cloud Storage.
	// Those URIs can include wildcards (*), but do not add or remove
	// matching files before import has completed.
	//
	// Note that Google Cloud Storage object listing is only eventually
	// consistent: files added may be not be immediately visible to
	// everyone. Thus, if using a wildcard it is preferable not to start
	// the import immediately after the files are created.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// The partition strategy describes how read groups are partitioned into read
	// group sets.
	PartitionStrategy    ImportReadGroupSetsRequest_PartitionStrategy `protobuf:"varint,5,opt,name=partition_strategy,json=partitionStrategy,proto3,enum=google.genomics.v1.ImportReadGroupSetsRequest_PartitionStrategy" json:"partition_strategy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *ImportReadGroupSetsRequest) Reset()         { *m = ImportReadGroupSetsRequest{} }
func (m *ImportReadGroupSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportReadGroupSetsRequest) ProtoMessage()    {}
func (*ImportReadGroupSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{2}
}

func (m *ImportReadGroupSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportReadGroupSetsRequest.Unmarshal(m, b)
}
func (m *ImportReadGroupSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportReadGroupSetsRequest.Marshal(b, m, deterministic)
}
func (m *ImportReadGroupSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportReadGroupSetsRequest.Merge(m, src)
}
func (m *ImportReadGroupSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportReadGroupSetsRequest.Size(m)
}
func (m *ImportReadGroupSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportReadGroupSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportReadGroupSetsRequest proto.InternalMessageInfo

func (m *ImportReadGroupSetsRequest) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *ImportReadGroupSetsRequest) GetReferenceSetId() string {
	if m != nil {
		return m.ReferenceSetId
	}
	return ""
}

func (m *ImportReadGroupSetsRequest) GetSourceUris() []string {
	if m != nil {
		return m.SourceUris
	}
	return nil
}

func (m *ImportReadGroupSetsRequest) GetPartitionStrategy() ImportReadGroupSetsRequest_PartitionStrategy {
	if m != nil {
		return m.PartitionStrategy
	}
	return ImportReadGroupSetsRequest_PARTITION_STRATEGY_UNSPECIFIED
}

// The read group set import response.
type ImportReadGroupSetsResponse struct {
	// IDs of the read group sets that were created.
	ReadGroupSetIds      []string `protobuf:"bytes,1,rep,name=read_group_set_ids,json=readGroupSetIds,proto3" json:"read_group_set_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportReadGroupSetsResponse) Reset()         { *m = ImportReadGroupSetsResponse{} }
func (m *ImportReadGroupSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ImportReadGroupSetsResponse) ProtoMessage()    {}
func (*ImportReadGroupSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{3}
}

func (m *ImportReadGroupSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportReadGroupSetsResponse.Unmarshal(m, b)
}
func (m *ImportReadGroupSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportReadGroupSetsResponse.Marshal(b, m, deterministic)
}
func (m *ImportReadGroupSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportReadGroupSetsResponse.Merge(m, src)
}
func (m *ImportReadGroupSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ImportReadGroupSetsResponse.Size(m)
}
func (m *ImportReadGroupSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportReadGroupSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportReadGroupSetsResponse proto.InternalMessageInfo

func (m *ImportReadGroupSetsResponse) GetReadGroupSetIds() []string {
	if m != nil {
		return m.ReadGroupSetIds
	}
	return nil
}

// The read group set export request.
type ExportReadGroupSetRequest struct {
	// Required. The Google Cloud project ID that owns this
	// export. The caller must have WRITE access to this project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. A Google Cloud Storage URI for the exported BAM file.
	// The currently authenticated user must have write access to the new file.
	// An error will be returned if the URI already contains data.
	ExportUri string `protobuf:"bytes,2,opt,name=export_uri,json=exportUri,proto3" json:"export_uri,omitempty"`
	// Required. The ID of the read group set to export. The caller must have
	// READ access to this read group set.
	ReadGroupSetId string `protobuf:"bytes,3,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The reference names to export. If this is not specified, all reference
	// sequences, including unmapped reads, are exported.
	// Use `*` to export only unmapped reads.
	ReferenceNames       []string `protobuf:"bytes,4,rep,name=reference_names,json=referenceNames,proto3" json:"reference_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportReadGroupSetRequest) Reset()         { *m = ExportReadGroupSetRequest{} }
func (m *ExportReadGroupSetRequest) String() string { return proto.CompactTextString(m) }
func (*ExportReadGroupSetRequest) ProtoMessage()    {}
func (*ExportReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{4}
}

func (m *ExportReadGroupSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportReadGroupSetRequest.Unmarshal(m, b)
}
func (m *ExportReadGroupSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportReadGroupSetRequest.Marshal(b, m, deterministic)
}
func (m *ExportReadGroupSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportReadGroupSetRequest.Merge(m, src)
}
func (m *ExportReadGroupSetRequest) XXX_Size() int {
	return xxx_messageInfo_ExportReadGroupSetRequest.Size(m)
}
func (m *ExportReadGroupSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportReadGroupSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportReadGroupSetRequest proto.InternalMessageInfo

func (m *ExportReadGroupSetRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ExportReadGroupSetRequest) GetExportUri() string {
	if m != nil {
		return m.ExportUri
	}
	return ""
}

func (m *ExportReadGroupSetRequest) GetReadGroupSetId() string {
	if m != nil {
		return m.ReadGroupSetId
	}
	return ""
}

func (m *ExportReadGroupSetRequest) GetReferenceNames() []string {
	if m != nil {
		return m.ReferenceNames
	}
	return nil
}

type UpdateReadGroupSetRequest struct {
	// The ID of the read group set to be updated. The caller must have WRITE
	// permissions to the dataset associated with this read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The new read group set data. See `updateMask` for details on mutability of
	// fields.
	ReadGroupSet *ReadGroupSet `protobuf:"bytes,2,opt,name=read_group_set,json=readGroupSet,proto3" json:"read_group_set,omitempty"`
	// An optional mask specifying which fields to update. Supported fields:
	//
	// * [name][google.genomics.v1.ReadGroupSet.name].
	// * [referenceSetId][google.genomics.v1.ReadGroupSet.reference_set_id].
	//
	// Leaving `updateMask` unset is equivalent to specifying all mutable
	// fields.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateReadGroupSetRequest) Reset()         { *m = UpdateReadGroupSetRequest{} }
func (m *UpdateReadGroupSetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateReadGroupSetRequest) ProtoMessage()    {}
func (*UpdateReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{5}
}

func (m *UpdateReadGroupSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateReadGroupSetRequest.Unmarshal(m, b)
}
func (m *UpdateReadGroupSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateReadGroupSetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateReadGroupSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateReadGroupSetRequest.Merge(m, src)
}
func (m *UpdateReadGroupSetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateReadGroupSetRequest.Size(m)
}
func (m *UpdateReadGroupSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateReadGroupSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateReadGroupSetRequest proto.InternalMessageInfo

func (m *UpdateReadGroupSetRequest) GetReadGroupSetId() string {
	if m != nil {
		return m.ReadGroupSetId
	}
	return ""
}

func (m *UpdateReadGroupSetRequest) GetReadGroupSet() *ReadGroupSet {
	if m != nil {
		return m.ReadGroupSet
	}
	return nil
}

func (m *UpdateReadGroupSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteReadGroupSetRequest struct {
	// The ID of the read group set to be deleted. The caller must have WRITE
	// permissions to the dataset associated with this read group set.
	ReadGroupSetId       string   `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteReadGroupSetRequest) Reset()         { *m = DeleteReadGroupSetRequest{} }
func (m *DeleteReadGroupSetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteReadGroupSetRequest) ProtoMessage()    {}
func (*DeleteReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{6}
}

func (m *DeleteReadGroupSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteReadGroupSetRequest.Unmarshal(m, b)
}
func (m *DeleteReadGroupSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteReadGroupSetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteReadGroupSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteReadGroupSetRequest.Merge(m, src)
}
func (m *DeleteReadGroupSetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteReadGroupSetRequest.Size(m)
}
func (m *DeleteReadGroupSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteReadGroupSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteReadGroupSetRequest proto.InternalMessageInfo

func (m *DeleteReadGroupSetRequest) GetReadGroupSetId() string {
	if m != nil {
		return m.ReadGroupSetId
	}
	return ""
}

type GetReadGroupSetRequest struct {
	// The ID of the read group set.
	ReadGroupSetId       string   `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReadGroupSetRequest) Reset()         { *m = GetReadGroupSetRequest{} }
func (m *GetReadGroupSetRequest) String() string { return proto.CompactTextString(m) }
func (*GetReadGroupSetRequest) ProtoMessage()    {}
func (*GetReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{7}
}

func (m *GetReadGroupSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReadGroupSetRequest.Unmarshal(m, b)
}
func (m *GetReadGroupSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReadGroupSetRequest.Marshal(b, m, deterministic)
}
func (m *GetReadGroupSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReadGroupSetRequest.Merge(m, src)
}
func (m *GetReadGroupSetRequest) XXX_Size() int {
	return xxx_messageInfo_GetReadGroupSetRequest.Size(m)
}
func (m *GetReadGroupSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReadGroupSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReadGroupSetRequest proto.InternalMessageInfo

func (m *GetReadGroupSetRequest) GetReadGroupSetId() string {
	if m != nil {
		return m.ReadGroupSetId
	}
	return ""
}

type ListCoverageBucketsRequest struct {
	// Required. The ID of the read group set over which coverage is requested.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The name of the reference to query, within the reference set associated
	// with this query. Optional.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified. Defaults to 0.
	Start int64 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified. If unset or 0, defaults
	// to the length of the reference.
	End int64 `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// The desired width of each reported coverage bucket in base pairs. This
	// will be rounded down to the nearest precomputed bucket width; the value
	// of which is returned as `bucketWidth` in the response. Defaults
	// to infinity (each bucket spans an entire reference sequence) or the length
	// of the target range, if specified. The smallest precomputed
	// `bucketWidth` is currently 2048 base pairs; this is subject to
	// change.
	TargetBucketWidth int64 `protobuf:"varint,6,opt,name=target_bucket_width,json=targetBucketWidth,proto3" json:"target_bucket_width,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024. The maximum value is 2048.
	PageSize             int32    `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCoverageBucketsRequest) Reset()         { *m = ListCoverageBucketsRequest{} }
func (m *ListCoverageBucketsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCoverageBucketsRequest) ProtoMessage()    {}
func (*ListCoverageBucketsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{8}
}

func (m *ListCoverageBucketsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCoverageBucketsRequest.Unmarshal(m, b)
}
func (m *ListCoverageBucketsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCoverageBucketsRequest.Marshal(b, m, deterministic)
}
func (m *ListCoverageBucketsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCoverageBucketsRequest.Merge(m, src)
}
func (m *ListCoverageBucketsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCoverageBucketsRequest.Size(m)
}
func (m *ListCoverageBucketsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCoverageBucketsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCoverageBucketsRequest proto.InternalMessageInfo

func (m *ListCoverageBucketsRequest) GetReadGroupSetId() string {
	if m != nil {
		return m.ReadGroupSetId
	}
	return ""
}

func (m *ListCoverageBucketsRequest) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *ListCoverageBucketsRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *ListCoverageBucketsRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *ListCoverageBucketsRequest) GetTargetBucketWidth() int64 {
	if m != nil {
		return m.TargetBucketWidth
	}
	return 0
}

func (m *ListCoverageBucketsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListCoverageBucketsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// A bucket over which read coverage has been precomputed. A bucket corresponds
// to a specific range of the reference sequence.
type CoverageBucket struct {
	// The genomic coordinate range spanned by this bucket.
	Range *Range `protobuf:"bytes,1,opt,name=range,proto3" json:"range,omitempty"`
	// The average number of reads which are aligned to each individual
	// reference base in this bucket.
	MeanCoverage         float32  `protobuf:"fixed32,2,opt,name=mean_coverage,json=meanCoverage,proto3" json:"mean_coverage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CoverageBucket) Reset()         { *m = CoverageBucket{} }
func (m *CoverageBucket) String() string { return proto.CompactTextString(m) }
func (*CoverageBucket) ProtoMessage()    {}
func (*CoverageBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{9}
}

func (m *CoverageBucket) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CoverageBucket.Unmarshal(m, b)
}
func (m *CoverageBucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CoverageBucket.Marshal(b, m, deterministic)
}
func (m *CoverageBucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CoverageBucket.Merge(m, src)
}
func (m *CoverageBucket) XXX_Size() int {
	return xxx_messageInfo_CoverageBucket.Size(m)
}
func (m *CoverageBucket) XXX_DiscardUnknown() {
	xxx_messageInfo_CoverageBucket.DiscardUnknown(m)
}

var xxx_messageInfo_CoverageBucket proto.InternalMessageInfo

func (m *CoverageBucket) GetRange() *Range {
	if m != nil {
		return m.Range
	}
	return nil
}

func (m *CoverageBucket) GetMeanCoverage() float32 {
	if m != nil {
		return m.MeanCoverage
	}
	return 0
}

type ListCoverageBucketsResponse struct {
	// The length of each coverage bucket in base pairs. Note that buckets at the
	// end of a reference sequence may be shorter. This value is omitted if the
	// bucket width is infinity (the default behaviour, with no range or
	// `targetBucketWidth`).
	BucketWidth int64 `protobuf:"varint,1,opt,name=bucket_width,json=bucketWidth,proto3" json:"bucket_width,omitempty"`
	// The coverage buckets. The list of buckets is sparse; a bucket with 0
	// overlapping reads is not returned. A bucket never crosses more than one
	// reference sequence. Each bucket has width `bucketWidth`, unless
	// its end is the end of the reference sequence.
	CoverageBuckets []*CoverageBucket `protobuf:"bytes,2,rep,name=coverage_buckets,json=coverageBuckets,proto3" json:"coverage_buckets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCoverageBucketsResponse) Reset()         { *m = ListCoverageBucketsResponse{} }
func (m *ListCoverageBucketsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCoverageBucketsResponse) ProtoMessage()    {}
func (*ListCoverageBucketsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{10}
}

func (m *ListCoverageBucketsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCoverageBucketsResponse.Unmarshal(m, b)
}
func (m *ListCoverageBucketsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCoverageBucketsResponse.Marshal(b, m, deterministic)
}
func (m *ListCoverageBucketsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCoverageBucketsResponse.Merge(m, src)
}
func (m *ListCoverageBucketsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCoverageBucketsResponse.Size(m)
}
func (m *ListCoverageBucketsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCoverageBucketsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCoverageBucketsResponse proto.InternalMessageInfo

func (m *ListCoverageBucketsResponse) GetBucketWidth() int64 {
	if m != nil {
		return m.BucketWidth
	}
	return 0
}

func (m *ListCoverageBucketsResponse) GetCoverageBuckets() []*CoverageBucket {
	if m != nil {
		return m.CoverageBuckets
	}
	return nil
}

func (m *ListCoverageBucketsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The read search request.
type SearchReadsRequest struct {
	// The IDs of the read groups sets within which to search for reads. All
	// specified read group sets must be aligned against a common set of reference
	// sequences; this defines the genomic coordinates for the query. Must specify
	// one of `readGroupSetIds` or `readGroupIds`.
	ReadGroupSetIds []string `protobuf:"bytes,1,rep,name=read_group_set_ids,json=readGroupSetIds,proto3" json:"read_group_set_ids,omitempty"`
	// The IDs of the read groups within which to search for reads. All specified
	// read groups must belong to the same read group sets. Must specify one of
	// `readGroupSetIds` or `readGroupIds`.
	ReadGroupIds []string `protobuf:"bytes,5,rep,name=read_group_ids,json=readGroupIds,proto3" json:"read_group_ids,omitempty"`
	// The reference sequence name, for example `chr1`, `1`, or `chrX`. If set to
	// `*`, only unmapped reads are returned. If unspecified, all reads (mapped
	// and unmapped) are returned.
	ReferenceName string `protobuf:"bytes,7,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified.
	Start int64 `protobuf:"varint,8,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified.
	End int64 `protobuf:"varint,9,opt,name=end,proto3" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 2048.
	PageSize             int32    `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchReadsRequest) Reset()         { *m = SearchReadsRequest{} }
func (m *SearchReadsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchReadsRequest) ProtoMessage()    {}
func (*SearchReadsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{11}
}

func (m *SearchReadsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchReadsRequest.Unmarshal(m, b)
}
func (m *SearchReadsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchReadsRequest.Marshal(b, m, deterministic)
}
func (m *SearchReadsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchReadsRequest.Merge(m, src)
}
func (m *SearchReadsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchReadsRequest.Size(m)
}
func (m *SearchReadsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchReadsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchReadsRequest proto.InternalMessageInfo

func (m *SearchReadsRequest) GetReadGroupSetIds() []string {
	if m != nil {
		return m.ReadGroupSetIds
	}
	return nil
}

func (m *SearchReadsRequest) GetReadGroupIds() []string {
	if m != nil {
		return m.ReadGroupIds
	}
	return nil
}

func (m *SearchReadsRequest) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *SearchReadsRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SearchReadsRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *SearchReadsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchReadsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The read search response.
type SearchReadsResponse struct {
	// The list of matching alignments sorted by mapped genomic coordinate,
	// if any, ascending in position within the same reference. Unmapped reads,
	// which have no position, are returned contiguously and are sorted in
	// ascending lexicographic order by fragment name.
	Alignments []*Read `protobuf:"bytes,1,rep,name=alignments,proto3" json:"alignments,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchReadsResponse) Reset()         { *m = SearchReadsResponse{} }
func (m *SearchReadsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchReadsResponse) ProtoMessage()    {}
func (*SearchReadsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{12}
}

func (m *SearchReadsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchReadsResponse.Unmarshal(m, b)
}
func (m *SearchReadsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchReadsResponse.Marshal(b, m, deterministic)
}
func (m *SearchReadsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchReadsResponse.Merge(m, src)
}
func (m *SearchReadsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchReadsResponse.Size(m)
}
func (m *SearchReadsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchReadsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchReadsResponse proto.InternalMessageInfo

func (m *SearchReadsResponse) GetAlignments() []*Read {
	if m != nil {
		return m.Alignments
	}
	return nil
}

func (m *SearchReadsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The stream reads request.
type StreamReadsRequest struct {
	// The Google Cloud project ID which will be billed
	// for this access. The caller must have WRITE access to this project.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The ID of the read group set from which to stream reads.
	ReadGroupSetId string `protobuf:"bytes,2,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The reference sequence name, for example `chr1`,
	// `1`, or `chrX`. If set to *, only unmapped reads are
	// returned.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified.
	Start int64 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified.
	End int64 `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// Restricts results to a shard containing approximately `1/totalShards`
	// of the normal response payload for this query. Results from a sharded
	// request are disjoint from those returned by all queries which differ only
	// in their shard parameter. A shard may yield 0 results; this is especially
	// likely for large values of `totalShards`.
	//
	// Valid values are `[0, totalShards)`.
	Shard int32 `protobuf:"varint,6,opt,name=shard,proto3" json:"shard,omitempty"`
	// Specifying `totalShards` causes a disjoint subset of the normal response
	// payload to be returned for each query with a unique `shard` parameter
	// specified. A best effort is made to yield equally sized shards. Sharding
	// can be used to distribute processing amongst workers, where each worker is
	// assigned a unique `shard` number and all workers specify the same
	// `totalShards` number. The union of reads returned for all sharded queries
	// `[0, totalShards)` is equal to those returned by a single unsharded query.
	//
	// Queries for different values of `totalShards` with common divisors will
	// share shard boundaries. For example, streaming `shard` 2 of 5
	// `totalShards` yields the same results as streaming `shard`s 4 and 5 of 10
	// `totalShards`. This property can be leveraged for adaptive retries.
	TotalShards          int32    `protobuf:"varint,7,opt,name=total_shards,json=totalShards,proto3" json:"total_shards,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamReadsRequest) Reset()         { *m = StreamReadsRequest{} }
func (m *StreamReadsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamReadsRequest) ProtoMessage()    {}
func (*StreamReadsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{13}
}

func (m *StreamReadsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamReadsRequest.Unmarshal(m, b)
}
func (m *StreamReadsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamReadsRequest.Marshal(b, m, deterministic)
}
func (m *StreamReadsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamReadsRequest.Merge(m, src)
}
func (m *StreamReadsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamReadsRequest.Size(m)
}
func (m *StreamReadsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamReadsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamReadsRequest proto.InternalMessageInfo

func (m *StreamReadsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *StreamReadsRequest) GetReadGroupSetId() string {
	if m != nil {
		return m.ReadGroupSetId
	}
	return ""
}

func (m *StreamReadsRequest) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *StreamReadsRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *StreamReadsRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *StreamReadsRequest) GetShard() int32 {
	if m != nil {
		return m.Shard
	}
	return 0
}

func (m *StreamReadsRequest) GetTotalShards() int32 {
	if m != nil {
		return m.TotalShards
	}
	return 0
}

type StreamReadsResponse struct {
	Alignments           []*Read  `protobuf:"bytes,1,rep,name=alignments,proto3" json:"alignments,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamReadsResponse) Reset()         { *m = StreamReadsResponse{} }
func (m *StreamReadsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamReadsResponse) ProtoMessage()    {}
func (*StreamReadsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b02d5d0c80a106c, []int{14}
}

func (m *StreamReadsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamReadsResponse.Unmarshal(m, b)
}
func (m *StreamReadsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamReadsResponse.Marshal(b, m, deterministic)
}
func (m *StreamReadsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamReadsResponse.Merge(m, src)
}
func (m *StreamReadsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamReadsResponse.Size(m)
}
func (m *StreamReadsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamReadsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamReadsResponse proto.InternalMessageInfo

func (m *StreamReadsResponse) GetAlignments() []*Read {
	if m != nil {
		return m.Alignments
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.genomics.v1.ImportReadGroupSetsRequest_PartitionStrategy", ImportReadGroupSetsRequest_PartitionStrategy_name, ImportReadGroupSetsRequest_PartitionStrategy_value)
	proto.RegisterType((*SearchReadGroupSetsRequest)(nil), "google.genomics.v1.SearchReadGroupSetsRequest")
	proto.RegisterType((*SearchReadGroupSetsResponse)(nil), "google.genomics.v1.SearchReadGroupSetsResponse")
	proto.RegisterType((*ImportReadGroupSetsRequest)(nil), "google.genomics.v1.ImportReadGroupSetsRequest")
	proto.RegisterType((*ImportReadGroupSetsResponse)(nil), "google.genomics.v1.ImportReadGroupSetsResponse")
	proto.RegisterType((*ExportReadGroupSetRequest)(nil), "google.genomics.v1.ExportReadGroupSetRequest")
	proto.RegisterType((*UpdateReadGroupSetRequest)(nil), "google.genomics.v1.UpdateReadGroupSetRequest")
	proto.RegisterType((*DeleteReadGroupSetRequest)(nil), "google.genomics.v1.DeleteReadGroupSetRequest")
	proto.RegisterType((*GetReadGroupSetRequest)(nil), "google.genomics.v1.GetReadGroupSetRequest")
	proto.RegisterType((*ListCoverageBucketsRequest)(nil), "google.genomics.v1.ListCoverageBucketsRequest")
	proto.RegisterType((*CoverageBucket)(nil), "google.genomics.v1.CoverageBucket")
	proto.RegisterType((*ListCoverageBucketsResponse)(nil), "google.genomics.v1.ListCoverageBucketsResponse")
	proto.RegisterType((*SearchReadsRequest)(nil), "google.genomics.v1.SearchReadsRequest")
	proto.RegisterType((*SearchReadsResponse)(nil), "google.genomics.v1.SearchReadsResponse")
	proto.RegisterType((*StreamReadsRequest)(nil), "google.genomics.v1.StreamReadsRequest")
	proto.RegisterType((*StreamReadsResponse)(nil), "google.genomics.v1.StreamReadsResponse")
}

func init() { proto.RegisterFile("google/genomics/v1/reads.proto", fileDescriptor_6b02d5d0c80a106c) }

var fileDescriptor_6b02d5d0c80a106c = []byte{
	// 1333 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xff, 0x8e, 0x1d, 0xb7, 0xcd, 0x73, 0x93, 0x38, 0xe3, 0x7e, 0x8b, 0xe3, 0x90, 0x36, 0x6c,
	0x69, 0x1b, 0x02, 0xb5, 0x89, 0x11, 0x2a, 0x4a, 0x85, 0x44, 0xda, 0x3a, 0xc1, 0x28, 0x69, 0xad,
	0x75, 0x02, 0x82, 0xcb, 0x6a, 0x62, 0x4f, 0xb6, 0x4b, 0xec, 0xdd, 0x65, 0x66, 0x9c, 0xfe, 0x52,
	0x2f, 0xbd, 0x81, 0x04, 0x1c, 0x10, 0x27, 0xae, 0x5c, 0x39, 0x22, 0xfe, 0x08, 0x4e, 0x88, 0x0b,
	0x7f, 0x00, 0xe2, 0x0f, 0xe0, 0xc4, 0x11, 0xcd, 0xec, 0x6e, 0xbc, 0xeb, 0x9d, 0x6d, 0x1c, 0x55,
	0xe2, 0xb6, 0xfb, 0xe6, 0xb3, 0x6f, 0x3e, 0xef, 0xf7, 0x5b, 0xb8, 0x64, 0x7b, 0x9e, 0xdd, 0xa7,
	0x75, 0x9b, 0xba, 0xde, 0xc0, 0xe9, 0xf2, 0xfa, 0xd1, 0x5a, 0x9d, 0x51, 0xd2, 0xe3, 0x35, 0x9f,
	0x79, 0xc2, 0xc3, 0x38, 0x38, 0xaf, 0x45, 0xe7, 0xb5, 0xa3, 0xb5, 0xea, 0xab, 0xe1, 0x37, 0xc4,
	0x77, 0xea, 0xc4, 0x75, 0x3d, 0x41, 0x84, 0xe3, 0xb9, 0xe1, 0x17, 0x55, 0xad, 0x46, 0xe2, 0xda,
	0x34, 0x3c, 0xbf, 0x96, 0x71, 0x23, 0xe9, 0x3b, 0xb6, 0x3b, 0xa0, 0xae, 0x08, 0x71, 0x57, 0x33,
	0x70, 0x36, 0xf3, 0x86, 0x3e, 0xa7, 0x11, 0xec, 0x4a, 0x08, 0xeb, 0x7b, 0xae, 0xcd, 0x86, 0xae,
	0xeb, 0xb8, 0x76, 0xdd, 0xf3, 0x29, 0x4b, 0x70, 0x5a, 0x0c, 0x41, 0xea, 0x6d, 0x7f, 0x78, 0x50,
	0xa7, 0x03, 0x5f, 0x3c, 0x0e, 0x0f, 0x97, 0xc7, 0x0f, 0x0f, 0x1c, 0xda, 0xef, 0x59, 0x03, 0xc2,
	0x0f, 0x03, 0x84, 0xf1, 0x35, 0x82, 0x6a, 0x87, 0x12, 0xd6, 0x7d, 0x60, 0x52, 0xd2, 0xdb, 0x92,
	0x04, 0x3a, 0x54, 0x70, 0x93, 0x7e, 0x31, 0xa4, 0x5c, 0xe0, 0xcb, 0x50, 0xec, 0x11, 0x41, 0x38,
	0x15, 0x96, 0xd3, 0xe3, 0x15, 0xb4, 0x9c, 0x5f, 0x99, 0x36, 0x21, 0x14, 0xb5, 0x7a, 0x1c, 0x63,
	0x98, 0x72, 0xc9, 0x80, 0x56, 0xf2, 0xcb, 0x68, 0x65, 0xda, 0x54, 0xcf, 0x78, 0x09, 0xc0, 0x27,
	0x36, 0xb5, 0x84, 0x77, 0x48, 0xdd, 0x4a, 0x4e, 0x9d, 0x4c, 0x4b, 0xc9, 0xae, 0x14, 0xe0, 0x45,
	0x50, 0x2f, 0x16, 0x77, 0x9e, 0xd0, 0xca, 0xd4, 0x32, 0x5a, 0x29, 0x98, 0xe7, 0xa4, 0xa0, 0xe3,
	0x3c, 0xa1, 0xc6, 0xb7, 0x08, 0x16, 0xb5, 0x7c, 0xb8, 0xef, 0xb9, 0x9c, 0xe2, 0x0f, 0x61, 0x4e,
	0x7a, 0xca, 0x52, 0xae, 0xb2, 0x38, 0x15, 0x01, 0xa9, 0x62, 0x63, 0xb9, 0x96, 0x0e, 0x67, 0x2d,
	0xae, 0xc3, 0x9c, 0x61, 0x71, 0x8d, 0xf8, 0x1a, 0xcc, 0xb9, 0xf4, 0x91, 0xb0, 0x52, 0x54, 0x67,
	0xa4, 0xb8, 0x1d, 0xd1, 0x35, 0xfe, 0xc8, 0x41, 0xb5, 0x35, 0xf0, 0x3d, 0x26, 0xb4, 0x1e, 0x5a,
	0x02, 0x18, 0x79, 0xa8, 0x82, 0x02, 0x63, 0x8f, 0x1d, 0x84, 0x57, 0xa0, 0xc4, 0xe8, 0x01, 0x65,
	0xd4, 0xed, 0x52, 0x2b, 0x04, 0x4d, 0x29, 0xd0, 0xec, 0xb1, 0xbc, 0xa3, 0x90, 0x97, 0xa1, 0xc8,
	0xbd, 0x21, 0xeb, 0x52, 0x6b, 0xc8, 0x1c, 0x5e, 0xc9, 0x05, 0xae, 0x0e, 0x44, 0x7b, 0xcc, 0xe1,
	0xd8, 0x03, 0xec, 0x13, 0x26, 0x1c, 0x19, 0x7d, 0x8b, 0x0b, 0x46, 0x04, 0xb5, 0x1f, 0x57, 0x0a,
	0xcb, 0x68, 0x65, 0xb6, 0xf1, 0x81, 0xce, 0xfa, 0x6c, 0xd6, 0xb5, 0x76, 0xa4, 0xa8, 0x13, 0xea,
	0x31, 0xe7, 0xfd, 0x71, 0x91, 0x61, 0xc1, 0x7c, 0x0a, 0x87, 0x0d, 0xb8, 0xd4, 0xde, 0x30, 0x77,
	0x5b, 0xbb, 0xad, 0xfb, 0xf7, 0xac, 0xce, 0xae, 0xb9, 0xb1, 0xdb, 0xdc, 0xfa, 0xd4, 0xda, 0xbb,
	0xd7, 0x69, 0x37, 0xef, 0xb4, 0x36, 0x5b, 0xcd, 0xbb, 0xa5, 0xff, 0xe1, 0x57, 0xa0, 0xdc, 0x6e,
	0x9a, 0xd6, 0x66, 0x6b, 0xbb, 0x69, 0xc9, 0x87, 0xce, 0xc6, 0x4e, 0x7b, 0xbb, 0x59, 0x42, 0x78,
	0x06, 0xa6, 0x77, 0x9a, 0xe6, 0x56, 0xd3, 0xda, 0xd8, 0xde, 0x2e, 0xe5, 0x8c, 0x8f, 0x60, 0x51,
	0xcb, 0x31, 0x8c, 0xf5, 0x9b, 0x80, 0x93, 0xb1, 0x8e, 0xe5, 0xe0, 0x5c, 0x3c, 0x98, 0xad, 0x1e,
	0x37, 0x7e, 0x42, 0xb0, 0xd0, 0x7c, 0x34, 0xae, 0x2c, 0x16, 0x25, 0x9f, 0x79, 0x9f, 0xd3, 0x6e,
	0x3c, 0x4a, 0xa1, 0xa4, 0xd5, 0x93, 0xc7, 0x54, 0x7d, 0x2b, 0x7d, 0x1f, 0x65, 0x6c, 0x20, 0xd9,
	0x63, 0x0e, 0x7e, 0x03, 0xe6, 0x53, 0x44, 0xc2, 0x8c, 0x9f, 0x4d, 0xf2, 0xc0, 0xd7, 0x65, 0x7e,
	0x46, 0xf1, 0x96, 0xd5, 0xc0, 0x2b, 0x53, 0x8a, 0xf0, 0x28, 0xdc, 0xf7, 0xa4, 0xd4, 0xf8, 0x15,
	0xc1, 0xc2, 0x9e, 0xdf, 0x23, 0x82, 0xea, 0xf8, 0x6a, 0x6f, 0x44, 0xda, 0x1b, 0x37, 0x61, 0x36,
	0x09, 0x55, 0xfc, 0x27, 0x29, 0x88, 0xf3, 0x71, 0x4d, 0xf8, 0x16, 0x14, 0x87, 0x8a, 0x8f, 0x6a,
	0x0f, 0xca, 0xbc, 0x62, 0xa3, 0x1a, 0x29, 0x89, 0x3a, 0x48, 0x6d, 0x53, 0x76, 0x90, 0x1d, 0xc2,
	0x0f, 0x4d, 0x08, 0xe0, 0xf2, 0xd9, 0xd8, 0x84, 0x85, 0xbb, 0xb4, 0x4f, 0x5f, 0xd6, 0x18, 0xe3,
	0x0e, 0x5c, 0xdc, 0xa2, 0xe2, 0x25, 0x95, 0x3c, 0xcf, 0x41, 0x75, 0xdb, 0xe1, 0xe2, 0x8e, 0x77,
	0x44, 0x19, 0xb1, 0xe9, 0xed, 0x61, 0xf7, 0x30, 0x56, 0xb1, 0xa7, 0xf0, 0xed, 0x55, 0x98, 0x4d,
	0x46, 0x33, 0x8c, 0xfa, 0x4c, 0x22, 0x98, 0xf8, 0x02, 0x14, 0xb8, 0x20, 0x4c, 0xa8, 0xca, 0xce,
	0x9b, 0xc1, 0x0b, 0x2e, 0x41, 0x9e, 0xba, 0x3d, 0x55, 0xa0, 0x79, 0x53, 0x3e, 0xe2, 0x1a, 0x94,
	0x05, 0x61, 0x36, 0x15, 0xd6, 0xbe, 0xa2, 0x64, 0x3d, 0x74, 0x7a, 0xe2, 0x41, 0xe5, 0x8c, 0x42,
	0xcc, 0x07, 0x47, 0x01, 0xd9, 0x4f, 0xe4, 0xc1, 0x58, 0x23, 0x3d, 0xfb, 0xc2, 0x46, 0x7a, 0x6e,
	0xac, 0x91, 0x1e, 0xc0, 0x6c, 0xd2, 0x7e, 0x5c, 0x87, 0x82, 0x1a, 0x56, 0xca, 0xd6, 0x62, 0x63,
	0x41, 0x9b, 0x1f, 0x12, 0x60, 0x06, 0x38, 0x7c, 0x05, 0x66, 0x06, 0x94, 0xb8, 0x56, 0x37, 0xd4,
	0xa3, 0x12, 0x2b, 0x67, 0x9e, 0x97, 0xc2, 0x48, 0xb7, 0xf1, 0x0b, 0x82, 0x45, 0xad, 0xb3, 0xc3,
	0x22, 0x7e, 0x0d, 0xce, 0x27, 0x8c, 0x45, 0xca, 0xd8, 0xe2, 0x7e, 0xcc, 0xcc, 0x1d, 0x28, 0x45,
	0x57, 0x84, 0x8e, 0x09, 0xda, 0x5f, 0xb1, 0x61, 0xe8, 0x38, 0x26, 0x6f, 0x32, 0xe7, 0xba, 0xc9,
	0x9b, 0x75, 0x8d, 0x3d, 0xaf, 0x6b, 0xec, 0x7f, 0x23, 0xc0, 0xa3, 0x51, 0x73, 0x9c, 0x1e, 0xa7,
	0xe9, 0x3a, 0xf8, 0xf5, 0x44, 0xf1, 0x49, 0x60, 0x41, 0x01, 0x47, 0xa5, 0x25, 0x51, 0xe9, 0x34,
	0x3a, 0xfb, 0xc2, 0x34, 0x3a, 0xa7, 0x49, 0xa3, 0xe9, 0x51, 0x1a, 0x25, 0xd3, 0x22, 0x7f, 0xaa,
	0xf9, 0xfa, 0x10, 0xca, 0x09, 0x9b, 0xc3, 0x28, 0xbd, 0x07, 0x70, 0xbc, 0xa4, 0x44, 0x13, 0xb5,
	0x92, 0xd5, 0x40, 0xcc, 0x18, 0x76, 0xe2, 0x31, 0xfa, 0x97, 0xf4, 0xb6, 0x60, 0x94, 0x0c, 0x12,
	0xde, 0x3e, 0xa1, 0x31, 0x6b, 0x6b, 0x35, 0xf7, 0x5f, 0xd4, 0xaa, 0xc4, 0x3d, 0x20, 0xac, 0xa7,
	0xaa, 0xb3, 0x60, 0x06, 0x2f, 0x32, 0x9b, 0x85, 0x27, 0x48, 0xdf, 0x52, 0xaf, 0x5c, 0xc5, 0xb1,
	0x60, 0x16, 0x95, 0xac, 0xa3, 0x44, 0xc6, 0x7d, 0x28, 0x27, 0xec, 0x7c, 0x59, 0x0f, 0x37, 0xbe,
	0x47, 0x70, 0x21, 0xd0, 0xe8, 0xb8, 0xb6, 0x3c, 0xed, 0x50, 0x76, 0xe4, 0x74, 0x29, 0x7e, 0x06,
	0xc5, 0xd8, 0x4d, 0xf8, 0x9a, 0x4e, 0x5b, 0xda, 0xe5, 0xd5, 0xeb, 0x27, 0xe2, 0x02, 0xca, 0xc6,
	0xe2, 0xf3, 0xdf, 0xff, 0xfc, 0x2e, 0xf7, 0x7f, 0xa3, 0x74, 0xbc, 0x39, 0xaf, 0x73, 0x05, 0x5b,
	0x47, 0xab, 0x6f, 0xa3, 0xc6, 0x6f, 0xd3, 0x30, 0x13, 0xa3, 0xf3, 0xf1, 0x1a, 0xfe, 0x12, 0x41,
	0x59, 0x33, 0xd0, 0x71, 0xed, 0x74, 0xdb, 0x49, 0x75, 0x29, 0xc2, 0xc7, 0x36, 0xdf, 0xda, 0xfd,
	0x68, 0xf3, 0x35, 0xae, 0x28, 0x5e, 0x4b, 0x46, 0x65, 0x7c, 0x6f, 0xe6, 0xeb, 0x8e, 0x52, 0xba,
	0x8e, 0x56, 0xf1, 0x0f, 0x08, 0x70, 0x7a, 0x1f, 0xc0, 0x37, 0x74, 0x54, 0x32, 0xf7, 0x86, 0x93,
	0x98, 0xdc, 0x54, 0x4c, 0xd6, 0x8c, 0xb7, 0x52, 0x4c, 0xea, 0x4f, 0x53, 0x79, 0xfb, 0x6c, 0x3d,
	0xd8, 0x28, 0x42, 0x76, 0x65, 0xcd, 0x9a, 0xab, 0xf7, 0x54, 0xf6, 0x7e, 0x5e, 0xad, 0x4f, 0x8c,
	0x0f, 0x63, 0x9a, 0xed, 0xbb, 0x3a, 0x57, 0x9f, 0x49, 0x76, 0x3f, 0x22, 0xc0, 0xe9, 0xdd, 0x44,
	0xef, 0xbb, 0xcc, 0x1d, 0xa6, 0x7a, 0xe2, 0x02, 0x62, 0xbc, 0xaf, 0xc8, 0xdc, 0x6c, 0x5c, 0x9d,
	0xcc, 0x7d, 0x63, 0x7b, 0x0e, 0xfe, 0x0a, 0x01, 0x4e, 0x6f, 0x1d, 0x7a, 0x9a, 0x99, 0xdb, 0x49,
	0xf5, 0x62, 0x6a, 0xc5, 0x69, 0xca, 0x3f, 0x28, 0xe3, 0x86, 0x22, 0x77, 0x7d, 0x75, 0x32, 0x72,
	0xf8, 0x1b, 0x04, 0x73, 0x63, 0xab, 0x0b, 0x5e, 0xd5, 0x31, 0xd1, 0xef, 0x37, 0x13, 0x78, 0x2b,
	0x24, 0x84, 0x27, 0x24, 0xf4, 0x33, 0x82, 0xb2, 0x66, 0x30, 0xeb, 0x53, 0x2c, 0x7b, 0x5d, 0xd2,
	0xa7, 0xd8, 0x0b, 0x26, 0x7e, 0x14, 0x55, 0xfc, 0xee, 0x44, 0x3c, 0xeb, 0xd1, 0xf8, 0x0e, 0x27,
	0x3f, 0x7e, 0x0a, 0xc5, 0xd8, 0x84, 0xca, 0xe8, 0x6a, 0xa9, 0xb1, 0x9d, 0xd1, 0xd5, 0xd2, 0xa3,
	0x4e, 0xd3, 0xd5, 0x46, 0x99, 0x7f, 0x9b, 0xc2, 0xc5, 0xae, 0x37, 0xd0, 0xa8, 0xba, 0x0d, 0x4a,
	0x4b, 0x5b, 0xe6, 0x48, 0x1b, 0x7d, 0xb6, 0x1e, 0x21, 0xbc, 0x3e, 0x71, 0xed, 0x9a, 0xc7, 0x6c,
	0xf9, 0x33, 0xaf, 0x32, 0xa8, 0x1e, 0x1c, 0x11, 0xdf, 0xe1, 0xf1, 0x1f, 0xfc, 0x5b, 0xd1, 0xf3,
	0x3f, 0x08, 0xed, 0x9f, 0x51, 0xc8, 0x77, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x1b, 0x9b, 0xce,
	0x6e, 0xa3, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// StreamingReadServiceClient is the client API for StreamingReadService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingReadServiceClient interface {
	// Returns a stream of all the reads matching the search request, ordered
	// by reference name, position, and ID.
	StreamReads(ctx context.Context, in *StreamReadsRequest, opts ...grpc.CallOption) (StreamingReadService_StreamReadsClient, error)
}

type streamingReadServiceClient struct {
	cc *grpc.ClientConn
}

func NewStreamingReadServiceClient(cc *grpc.ClientConn) StreamingReadServiceClient {
	return &streamingReadServiceClient{cc}
}

func (c *streamingReadServiceClient) StreamReads(ctx context.Context, in *StreamReadsRequest, opts ...grpc.CallOption) (StreamingReadService_StreamReadsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingReadService_serviceDesc.Streams[0], "/google.genomics.v1.StreamingReadService/StreamReads", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingReadServiceStreamReadsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StreamingReadService_StreamReadsClient interface {
	Recv() (*StreamReadsResponse, error)
	grpc.ClientStream
}

type streamingReadServiceStreamReadsClient struct {
	grpc.ClientStream
}

func (x *streamingReadServiceStreamReadsClient) Recv() (*StreamReadsResponse, error) {
	m := new(StreamReadsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StreamingReadServiceServer is the server API for StreamingReadService service.
type StreamingReadServiceServer interface {
	// Returns a stream of all the reads matching the search request, ordered
	// by reference name, position, and ID.
	StreamReads(*StreamReadsRequest, StreamingReadService_StreamReadsServer) error
}

// UnimplementedStreamingReadServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreamingReadServiceServer struct {
}

func (*UnimplementedStreamingReadServiceServer) StreamReads(req *StreamReadsRequest, srv StreamingReadService_StreamReadsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamReads not implemented")
}

func RegisterStreamingReadServiceServer(s *grpc.Server, srv StreamingReadServiceServer) {
	s.RegisterService(&_StreamingReadService_serviceDesc, srv)
}

func _StreamingReadService_StreamReads_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamReadsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StreamingReadServiceServer).StreamReads(m, &streamingReadServiceStreamReadsServer{stream})
}

type StreamingReadService_StreamReadsServer interface {
	Send(*StreamReadsResponse) error
	grpc.ServerStream
}

type streamingReadServiceStreamReadsServer struct {
	grpc.ServerStream
}

func (x *streamingReadServiceStreamReadsServer) Send(m *StreamReadsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _StreamingReadService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.StreamingReadService",
	HandlerType: (*StreamingReadServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamReads",
			Handler:       _StreamingReadService_StreamReads_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/genomics/v1/reads.proto",
}

// ReadServiceV1Client is the client API for ReadServiceV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReadServiceV1Client interface {
	// Creates read group sets by asynchronously importing the provided
	// information.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The caller must have WRITE permissions to the dataset.
	//
	// ## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import
	//
	// - Tags will be converted to strings - tag types are not preserved
	// - Comments (`@CO`) in the input file header will not be preserved
	// - Original header order of references (`@SQ`) will not be preserved
	// - Any reverse stranded unmapped reads will be reverse complemented, and
	// their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
	// - Unmapped reads will be stripped of positional information (reference name
	// and position)
	ImportReadGroupSets(ctx context.Context, in *ImportReadGroupSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports a read group set to a BAM file in Google Cloud Storage.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Note that currently there may be some differences between exported BAM
	// files and the original BAM file at the time of import. See
	// [ImportReadGroupSets][google.genomics.v1.ReadServiceV1.ImportReadGroupSets]
	// for caveats.
	ExportReadGroupSet(ctx context.Context, in *ExportReadGroupSetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Searches for read group sets matching the criteria.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).
	SearchReadGroupSets(ctx context.Context, in *SearchReadGroupSetsRequest, opts ...grpc.CallOption) (*SearchReadGroupSetsResponse, error)
	// Updates a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateReadGroupSet(ctx context.Context, in *UpdateReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error)
	// Deletes a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteReadGroupSet(ctx context.Context, in *DeleteReadGroupSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets a read group set by ID.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetReadGroupSet(ctx context.Context, in *GetReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error)
	// Lists fixed width coverage buckets for a read group set, each of which
	// correspond to a range of a reference sequence. Each bucket summarizes
	// coverage information across its corresponding genomic range.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Coverage is defined as the number of reads which are aligned to a given
	// base in the reference sequence. Coverage buckets are available at several
	// precomputed bucket widths, enabling retrieval of various coverage 'zoom
	// levels'. The caller must have READ permissions for the target read group
	// set.
	ListCoverageBuckets(ctx context.Context, in *ListCoverageBucketsRequest, opts ...grpc.CallOption) (*ListCoverageBucketsResponse, error)
	// Gets a list of reads for one or more read group sets.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Reads search operates over a genomic coordinate space of reference sequence
	// & position defined over the reference sequences to which the requested
	// read group sets are aligned.
	//
	// If a target positional range is specified, search returns all reads whose
	// alignment to the reference genome overlap the range. A query which
	// specifies only read group set IDs yields all reads in those read group
	// sets, including unmapped reads.
	//
	// All reads returned (including reads on subsequent pages) are ordered by
	// genomic coordinate (by reference sequence, then position). Reads with
	// equivalent genomic coordinates are returned in an unspecified order. This
	// order is consistent, such that two queries for the same content (regardless
	// of page size) yield reads in the same order across their respective streams
	// of paginated responses.
	//
	// Implements
	// [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).
	SearchReads(ctx context.Context, in *SearchReadsRequest, opts ...grpc.CallOption) (*SearchReadsResponse, error)
}

type readServiceV1Client struct {
	cc *grpc.ClientConn
}

func NewReadServiceV1Client(cc *grpc.ClientConn) ReadServiceV1Client {
	return &readServiceV1Client{cc}
}

func (c *readServiceV1Client) ImportReadGroupSets(ctx context.Context, in *ImportReadGroupSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ImportReadGroupSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) ExportReadGroupSet(ctx context.Context, in *ExportReadGroupSetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ExportReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) SearchReadGroupSets(ctx context.Context, in *SearchReadGroupSetsRequest, opts ...grpc.CallOption) (*SearchReadGroupSetsResponse, error) {
	out := new(SearchReadGroupSetsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/SearchReadGroupSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) UpdateReadGroupSet(ctx context.Context, in *UpdateReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error) {
	out := new(ReadGroupSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/UpdateReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) DeleteReadGroupSet(ctx context.Context, in *DeleteReadGroupSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/DeleteReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) GetReadGroupSet(ctx context.Context, in *GetReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error) {
	out := new(ReadGroupSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/GetReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) ListCoverageBuckets(ctx context.Context, in *ListCoverageBucketsRequest, opts ...grpc.CallOption) (*ListCoverageBucketsResponse, error) {
	out := new(ListCoverageBucketsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ListCoverageBuckets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) SearchReads(ctx context.Context, in *SearchReadsRequest, opts ...grpc.CallOption) (*SearchReadsResponse, error) {
	out := new(SearchReadsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/SearchReads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReadServiceV1Server is the server API for ReadServiceV1 service.
type ReadServiceV1Server interface {
	// Creates read group sets by asynchronously importing the provided
	// information.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The caller must have WRITE permissions to the dataset.
	//
	// ## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import
	//
	// - Tags will be converted to strings - tag types are not preserved
	// - Comments (`@CO`) in the input file header will not be preserved
	// - Original header order of references (`@SQ`) will not be preserved
	// - Any reverse stranded unmapped reads will be reverse complemented, and
	// their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
	// - Unmapped reads will be stripped of positional information (reference name
	// and position)
	ImportReadGroupSets(context.Context, *ImportReadGroupSetsRequest) (*longrunning.Operation, error)
	// Exports a read group set to a BAM file in Google Cloud Storage.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Note that currently there may be some differences between exported BAM
	// files and the original BAM file at the time of import. See
	// [ImportReadGroupSets][google.genomics.v1.ReadServiceV1.ImportReadGroupSets]
	// for caveats.
	ExportReadGroupSet(context.Context, *ExportReadGroupSetRequest) (*longrunning.Operation, error)
	// Searches for read group sets matching the criteria.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).
	SearchReadGroupSets(context.Context, *SearchReadGroupSetsRequest) (*SearchReadGroupSetsResponse, error)
	// Updates a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateReadGroupSet(context.Context, *UpdateReadGroupSetRequest) (*ReadGroupSet, error)
	// Deletes a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteReadGroupSet(context.Context, *DeleteReadGroupSetRequest) (*empty.Empty, error)
	// Gets a read group set by ID.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetReadGroupSet(context.Context, *GetReadGroupSetRequest) (*ReadGroupSet, error)
	// Lists fixed width coverage buckets for a read group set, each of which
	// correspond to a range of a reference sequence. Each bucket summarizes
	// coverage information across its corresponding genomic range.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Coverage is defined as the number of reads which are aligned to a given
	// base in the reference sequence. Coverage buckets are available at several
	// precomputed bucket widths, enabling retrieval of various coverage 'zoom
	// levels'. The caller must have READ permissions for the target read group
	// set.
	ListCoverageBuckets(context.Context, *ListCoverageBucketsRequest) (*ListCoverageBucketsResponse, error)
	// Gets a list of reads for one or more read group sets.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Reads search operates over a genomic coordinate space of reference sequence
	// & position defined over the reference sequences to which the requested
	// read group sets are aligned.
	//
	// If a target positional range is specified, search returns all reads whose
	// alignment to the reference genome overlap the range. A query which
	// specifies only read group set IDs yields all reads in those read group
	// sets, including unmapped reads.
	//
	// All reads returned (including reads on subsequent pages) are ordered by
	// genomic coordinate (by reference sequence, then position). Reads with
	// equivalent genomic coordinates are returned in an unspecified order. This
	// order is consistent, such that two queries for the same content (regardless
	// of page size) yield reads in the same order across their respective streams
	// of paginated responses.
	//
	// Implements
	// [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).
	SearchReads(context.Context, *SearchReadsRequest) (*SearchReadsResponse, error)
}

// UnimplementedReadServiceV1Server can be embedded to have forward compatible implementations.
type UnimplementedReadServiceV1Server struct {
}

func (*UnimplementedReadServiceV1Server) ImportReadGroupSets(ctx context.Context, req *ImportReadGroupSetsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportReadGroupSets not implemented")
}
func (*UnimplementedReadServiceV1Server) ExportReadGroupSet(ctx context.Context, req *ExportReadGroupSetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) SearchReadGroupSets(ctx context.Context, req *SearchReadGroupSetsRequest) (*SearchReadGroupSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchReadGroupSets not implemented")
}
func (*UnimplementedReadServiceV1Server) UpdateReadGroupSet(ctx context.Context, req *UpdateReadGroupSetRequest) (*ReadGroupSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) DeleteReadGroupSet(ctx context.Context, req *DeleteReadGroupSetRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) GetReadGroupSet(ctx context.Context, req *GetReadGroupSetRequest) (*ReadGroupSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) ListCoverageBuckets(ctx context.Context, req *ListCoverageBucketsRequest) (*ListCoverageBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCoverageBuckets not implemented")
}
func (*UnimplementedReadServiceV1Server) SearchReads(ctx context.Context, req *SearchReadsRequest) (*SearchReadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchReads not implemented")
}

func RegisterReadServiceV1Server(s *grpc.Server, srv ReadServiceV1Server) {
	s.RegisterService(&_ReadServiceV1_serviceDesc, srv)
}

func _ReadServiceV1_ImportReadGroupSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportReadGroupSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ImportReadGroupSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ImportReadGroupSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ImportReadGroupSets(ctx, req.(*ImportReadGroupSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_ExportReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ExportReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ExportReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ExportReadGroupSet(ctx, req.(*ExportReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_SearchReadGroupSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchReadGroupSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).SearchReadGroupSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/SearchReadGroupSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).SearchReadGroupSets(ctx, req.(*SearchReadGroupSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_UpdateReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).UpdateReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/UpdateReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).UpdateReadGroupSet(ctx, req.(*UpdateReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_DeleteReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).DeleteReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/DeleteReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).DeleteReadGroupSet(ctx, req.(*DeleteReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_GetReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).GetReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/GetReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).GetReadGroupSet(ctx, req.(*GetReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_ListCoverageBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCoverageBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ListCoverageBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ListCoverageBuckets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ListCoverageBuckets(ctx, req.(*ListCoverageBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_SearchReads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchReadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).SearchReads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/SearchReads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).SearchReads(ctx, req.(*SearchReadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReadServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.ReadServiceV1",
	HandlerType: (*ReadServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportReadGroupSets",
			Handler:    _ReadServiceV1_ImportReadGroupSets_Handler,
		},
		{
			MethodName: "ExportReadGroupSet",
			Handler:    _ReadServiceV1_ExportReadGroupSet_Handler,
		},
		{
			MethodName: "SearchReadGroupSets",
			Handler:    _ReadServiceV1_SearchReadGroupSets_Handler,
		},
		{
			MethodName: "UpdateReadGroupSet",
			Handler:    _ReadServiceV1_UpdateReadGroupSet_Handler,
		},
		{
			MethodName: "DeleteReadGroupSet",
			Handler:    _ReadServiceV1_DeleteReadGroupSet_Handler,
		},
		{
			MethodName: "GetReadGroupSet",
			Handler:    _ReadServiceV1_GetReadGroupSet_Handler,
		},
		{
			MethodName: "ListCoverageBuckets",
			Handler:    _ReadServiceV1_ListCoverageBuckets_Handler,
		},
		{
			MethodName: "SearchReads",
			Handler:    _ReadServiceV1_SearchReads_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1/reads.proto",
}
