/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline.print;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.internal.exports.outline.Messages;
import org.xmind.ui.internal.exports.outline.print.TextData;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.UnitConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlinePrintClient {
    private static final String EMPTY_STRING = "";
    private static final int INNER_SPACE = 5;
    private String jobName;
    private PrinterData printerData;
    private boolean jobStarted = false;
    private IDialogSettings settings;
    private Printer printer = null;
    private org.eclipse.swt.graphics.Rectangle bounds = null;
    private int yPos;
    private int headerHeight;
    private int footerHeight;
    private int pageNumberHeight;
    private int contentTop;
    private int contentBottom;
    private int contentLeft;
    private int contentRight;
    private Point dpi;
    private List<TextData> datas = null;
    private boolean showBorder;
    private boolean showPageNumber;
    private String header;
    private String footer;
    private int headerAlign;
    private int footerAlign;
    private String headerFont;
    private String footerFont;
    private int pageNumber = 1;
    private GC gc = null;

    public OutlinePrintClient(String jobName, PrinterData printerData, IDialogSettings settings, List<TextData> datas) {
        this.jobName = jobName;
        this.printerData = printerData;
        this.settings = settings;
        this.datas = datas;
    }

    public void print(IWorkbook workbook) {
        if (!this.start()) {
            return;
        }
        this.print();
    }

    public void print(ISheet sheet) {
        if (!this.start()) {
            return;
        }
        this.print();
    }

    private boolean start() {
        if (this.printer == null) {
            this.printer = new Printer(this.printerData);
        }
        this.bounds = this.calcPrinterArea();
        this.init();
        if (!this.jobStarted) {
            if (!this.printer.startJob(this.jobName)) {
                return false;
            }
            this.jobStarted = true;
        }
        return this.printer.startPage();
    }

    private void init() {
        this.showBorder = this.settings.getBoolean("border");
        this.showPageNumber = !this.settings.getBoolean("noPageNumber");
        this.header = this.getString("headerText", EMPTY_STRING);
        this.footer = this.getString("footerText", EMPTY_STRING);
        if (!this.header.equals(EMPTY_STRING)) {
            this.headerAlign = PrintConstants.toDraw2DAlignment((String)this.getString("headerAlign", "center"), (int)2);
            this.headerFont = this.getString("headerFont", null);
        }
        if (!this.footer.equals(EMPTY_STRING)) {
            this.footerAlign = PrintConstants.toDraw2DAlignment((String)this.getString("footerAlign", "right"), (int)4);
            this.footerFont = this.getString("footerFont", null);
        }
    }

    private void print() {
        this.gc = new GC((Drawable)this.printer);
        this.initHF();
        this.decoratePage();
        this.yPos = this.contentTop;
        for (TextData data : this.datas) {
            Font font = this.getContentFont(data);
            this.gc.setFont(font);
            int level = data.getLevel();
            String text = data.getText();
            int whiteSpace = 12 * level * this.dpi.y / UnitConvertor.getScreenDpi().y;
            int w = this.gc.stringExtent((String)text).x;
            int lines = w / (this.bounds.width - 10 - whiteSpace);
            if (lines == 0) {
                this.drawText(text, font, 1, this.contentLeft + whiteSpace, this.yPos);
                this.printNewline();
                continue;
            }
            this.drawMultiLines(text, font, 1, this.yPos, whiteSpace, lines, true);
        }
        this.printer.endPage();
        this.printer.endJob();
        this.gc.dispose();
    }

    private void drawMultiLines(String text, Font font, int align, int yStart, int whiteSpace, int lines, boolean isContent) {
        ArrayList<String> texts = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            buf.append(c);
            if (this.gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)buf.toString())).append((String)" ").toString()).x > this.bounds.width - 15 - whiteSpace) {
                while (buf.length() > 0 && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    buf.deleteCharAt(buf.length() - 1);
                    c = text.charAt(--i);
                }
                texts.add(buf.toString());
                buf = new StringBuffer();
            }
            ++i;
        }
        texts.add(buf.toString());
        if (isContent) {
            i = 0;
            while (i < texts.size()) {
                this.drawText((String)texts.get(i), font, 1, this.contentLeft + whiteSpace, this.yPos);
                this.printNewline();
                ++i;
            }
        } else {
            i = 0;
            while (i < texts.size()) {
                if (i == lines) {
                    this.drawText((String)texts.get(i), font, align, this.contentLeft, yStart);
                } else {
                    this.drawText((String)texts.get(i), font, align, this.contentLeft, yStart);
                    yStart += this.gc.stringExtent((String)((String)texts.get((int)i))).y;
                }
                ++i;
            }
        }
    }

    private void printNewline() {
        int lineHeight = this.gc.getFontMetrics().getHeight();
        this.yPos += lineHeight;
        if (this.yPos + lineHeight > this.contentBottom) {
            this.yPos = this.contentTop;
            this.printer.endPage();
            this.printer.startPage();
            this.decoratePage();
        }
    }

    private void initHF() {
        int lines;
        int height;
        int width;
        Point extent;
        Font font;
        if (!EMPTY_STRING.equals(this.header)) {
            font = this.getFont(this.headerFont);
            this.gc.setFont(font);
            extent = this.gc.stringExtent(this.header);
            width = extent.x;
            height = extent.y;
            lines = width / (this.bounds.width - 10);
            this.headerHeight = height * (lines + 1);
            this.contentTop += this.headerHeight;
            font.dispose();
        }
        if (!EMPTY_STRING.equals(this.footer)) {
            font = this.getFont(this.footerFont);
            this.gc.setFont(font);
            extent = this.gc.stringExtent(this.footer);
            width = extent.x;
            height = extent.y;
            lines = width / (this.bounds.width - 10);
            this.footerHeight = height * (lines + 1);
            this.contentBottom -= this.footerHeight;
            font.dispose();
        }
        if (this.showPageNumber) {
            font = this.getFont("Calibri");
            this.gc.setFont(font);
            this.pageNumberHeight = this.gc.stringExtent((String)Messages.PageSetupDialog_PageNumber).y;
            this.contentBottom -= this.pageNumberHeight;
            font.dispose();
        }
    }

    private void decoratePage() {
        if (this.showBorder) {
            this.gc.drawRectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
        if (this.showPageNumber) {
            this.addPageNumber(this.pageNumber++);
        }
        this.addHeader();
        this.addFooter();
    }

    private void addHeader() {
        if (EMPTY_STRING.equals(this.header)) {
            return;
        }
        Font font = this.getFont(this.headerFont);
        this.drawHF(this.header, font, this.headerAlign, this.contentTop - this.headerHeight);
        font.dispose();
    }

    private void addFooter() {
        if (EMPTY_STRING.equals(this.footer)) {
            return;
        }
        Font font = this.getFont(this.footerFont);
        this.drawHF(this.footer, font, this.footerAlign, this.contentBottom);
        font.dispose();
    }

    private void drawHF(String text, Font font, int align, int yStart) {
        int w = this.gc.stringExtent((String)text).x;
        int lines = w / (this.bounds.width - 10);
        if (lines == 0) {
            this.drawText(text, font, align, this.contentLeft, yStart);
        } else {
            this.drawMultiLines(text, font, align, yStart, 0, lines, false);
        }
    }

    private void addPageNumber(int pageNumber) {
        String pn = String.valueOf(Messages.PageSetupDialog_PageNumber_title) + " " + pageNumber;
        Font font = this.getFont("Calibri");
        this.drawText(pn, font, 4, this.contentLeft, this.contentBottom + this.footerHeight);
        font.dispose();
    }

    private int getUserMargin(String key) {
        double margin;
        try {
            margin = this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            margin = 0.2;
        }
        double dpi = "leftMargin".equals(key) || "rightMargin".equals(key) ? (double)this.dpi.x : (double)this.dpi.y;
        return (int)(margin * dpi);
    }

    private org.eclipse.swt.graphics.Rectangle calcPrinterArea() {
        int bottom;
        int top;
        int right;
        org.eclipse.swt.graphics.Rectangle rect = this.printer.getClientArea();
        org.eclipse.swt.graphics.Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        this.dpi = this.printer.getDPI();
        int lm = this.getUserMargin("leftMargin");
        int rm = this.getUserMargin("rightMargin");
        int tm = this.getUserMargin("topMargin");
        int bm = this.getUserMargin("bottomMargin");
        int left = trim.x + lm;
        if (left < rect.x) {
            left = rect.x;
        }
        if ((right = rect.width + trim.x + trim.width - rm) > rect.width) {
            right = rect.width;
        }
        if ((top = trim.y + tm) < rect.y) {
            top = rect.y;
        }
        if ((bottom = rect.height + trim.y + trim.height - bm) > rect.height) {
            bottom = rect.height;
        }
        this.contentTop = top + 5;
        this.contentBottom = bottom - 5;
        this.contentLeft = left + 5;
        this.contentRight = right - 5;
        return new org.eclipse.swt.graphics.Rectangle(left, top, right - left, bottom - top);
    }

    private String getString(String key, String defaultValue) {
        String value = this.settings.get(key);
        return value == null ? defaultValue : value;
    }

    private void drawText(String text, Font font, int alignment, int startX, int startY) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(Display.getCurrent().getSystemColor(2));
        int width = this.contentRight - startX;
        Dimension size = label.getPreferredSize(width, -1);
        label.setBounds(new Rectangle(startX, startY, width, size.height));
        SWTGraphics graphics = new SWTGraphics(this.gc);
        try {
            label.paint((Graphics)graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    private Font getFont(String fontKey) {
        FontData[] fontData;
        Font font = null;
        String fontValue = this.settings.get(fontKey);
        if (fontValue != null && (fontData = FontUtils.toFontData((String)fontValue)) != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y);
                ++n2;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
        }
        if (font == null) {
            FontData[] defaultFontData = JFaceResources.getDefaultFontDescriptor().getFontData();
            int defaultHeight = defaultFontData[0].getHeight();
            font = new Font((Device)Display.getCurrent(), FontUtils.newHeight((FontData[])defaultFontData, (int)(defaultHeight * this.dpi.y / UnitConvertor.getScreenDpi().y)));
        }
        return font;
    }

    private Font getContentFont(TextData data) {
        String type = data.getType();
        if ("root".equals(type)) {
            return FontUtils.getFont((String)"Calibri Light", (int)(28 * this.dpi.y / UnitConvertor.getScreenDpi().y), (boolean)false, (boolean)false);
        }
        if ("attached".equals(type)) {
            switch (data.getLevel()) {
                case 1: {
                    return FontUtils.getFont((String)"Calibri", (int)(16 * this.dpi.y / UnitConvertor.getScreenDpi().y), (boolean)false, (boolean)false);
                }
                case 2: {
                    return FontUtils.getFont((String)"Calibri", (int)(12 * this.dpi.y / UnitConvertor.getScreenDpi().y), (boolean)true, (boolean)false);
                }
            }
        } else if ("summary".equals(type) || "callout".equals(type)) {
            return FontUtils.getFont((String)"Calibri", (int)(12 * this.dpi.y / UnitConvertor.getScreenDpi().y), (boolean)false, (boolean)true);
        }
        return FontUtils.getFont((String)"Calibri", (int)(12 * this.dpi.y / UnitConvertor.getScreenDpi().y), (boolean)false, (boolean)false);
    }

    public void dispose() {
        if (this.printer != null) {
            if (!this.printer.isDisposed()) {
                this.printer.endJob();
            }
            this.printer.dispose();
            this.printer = null;
        }
        this.jobStarted = false;
    }
}

