/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ISelectionBackgroundCustomizationElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertySelectionBackgroundHandler
implements ICSSPropertyHandler {
    private static final String SWT_SELECTION_FOREGROUND_COLOR = "swt-selection-foreground-color";
    private static final String SWT_SELECTION_BACKGROUND_COLOR = "swt-selection-background-color";
    private static final String SWT_SELECTION_BORDER_COLOR = "swt-selection-border-color";
    private static final String SWT_HOT_BACKGROUND_COLOR = "swt-hot-background-color";
    private static final String SWT_HOT_BORDER_COLOR = "swt-hot-border-color";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        ElementAdapter elementAdapter;
        Object nativeWidget;
        if (element instanceof ISelectionBackgroundCustomizationElement && element instanceof ElementAdapter && (nativeWidget = (elementAdapter = (ElementAdapter)element).getNativeWidget()) instanceof Widget) {
            Widget widget = (Widget)nativeWidget;
            ISelectionBackgroundCustomizationElement treeElement = (ISelectionBackgroundCustomizationElement)element;
            if (value.getCssValueType() == 1) {
                if (SWT_SELECTION_FOREGROUND_COLOR.equals(property)) {
                    Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
                    treeElement.setSelectionForegroundColor(newColor);
                } else if (SWT_SELECTION_BACKGROUND_COLOR.equals(property)) {
                    Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
                    treeElement.setSelectionBackgroundColor(newColor);
                } else if (SWT_SELECTION_BORDER_COLOR.equals(property)) {
                    Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
                    treeElement.setSelectionBorderColor(newColor);
                } else if (SWT_HOT_BACKGROUND_COLOR.equals(property)) {
                    Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
                    treeElement.setHotBackgroundColor(newColor);
                } else if (SWT_HOT_BORDER_COLOR.equals(property)) {
                    Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
                    treeElement.setHotBorderColor(newColor);
                }
            }
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

