/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.EncryptionData;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionDataImpl
extends EncryptionData {
    private Element implementation;
    private FileEntryImpl entry;

    public EncryptionDataImpl(Element implementation, FileEntryImpl entry) {
        this.implementation = implementation;
        this.entry = entry;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getImplementation());
        }
        return super.getAdapter(adapter);
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public int getIntAttribute(int defaultValue, String ... keyPath) {
        String value = this.getAttribute(keyPath);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    @Override
    public String getAttribute(String ... keys) {
        if (keys.length > 0) {
            Element ele = this.implementation;
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                if (i == keys.length - 1) {
                    return DOMUtils.getAttribute(ele, key);
                }
                ele = DOMUtils.getFirstChildElementByTag(ele, key);
                ++i;
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String value, String ... keys) {
        if (keys.length > 0) {
            Element ele = this.implementation;
            int i = 0;
            while (i < keys.length) {
                Element ele2;
                String key = keys[i];
                if (i == keys.length - 1) {
                    DOMUtils.setAttribute(ele, key, value);
                }
                ele = (ele2 = DOMUtils.getFirstChildElementByTag(ele, key)) == null ? DOMUtils.createElement(ele, key) : ele2;
                ++i;
            }
        }
    }

    @Override
    public String getChecksum() {
        return this.getAttribute("checksum");
    }

    @Override
    public String getChecksumType() {
        return this.getAttribute("checksum-type");
    }

    @Override
    public void setChecksum(String checksum) {
        this.setAttribute(checksum, "checksum");
    }

    @Override
    public void setChecksumType(String checksumType) {
        this.setAttribute(checksumType, "checksum-type");
    }

    @Override
    public IFileEntry getFileEntry() {
        return this.entry;
    }
}

